/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.heuristics;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.heuristics.StandardNeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;

public class RoundRobinNeighbourSelection<V extends Variable<V, T>, T extends Value<V, T>>
extends StandardNeighbourSelection<V, T> {
    protected static Logger sLogger = Logger.getLogger(RoundRobinNeighbourSelection.class);
    private int iSelectionIdx = -1;
    private List<NeighbourSelection<V, T>> iSelections = new ArrayList<NeighbourSelection<V, T>>();
    protected Solver<V, T> iSolver = null;

    public RoundRobinNeighbourSelection(DataProperties properties) throws Exception {
        super(properties);
    }

    public void registerSelection(NeighbourSelection<V, T> selection) {
        this.iSelections.add(selection);
    }

    @Override
    public void init(Solver<V, T> solver) {
        super.init(solver);
        this.iSolver = solver;
    }

    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        int selectionIndex;
        NeighbourSelection<V, T> selection;
        Neighbour<V, T> neighbour;
        while ((neighbour = (selection = this.iSelections.get((selectionIndex = this.getSelectionIndex()) % this.iSelections.size())).selectNeighbour(solution)) == null) {
            this.changeSelection(selectionIndex);
        }
        return neighbour;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSelectionIndex() {
        if (this.iSelectionIdx == -1) {
            this.changeSelection(-1);
        }
        this.iSolver.currentSolution().getLock().readLock().lock();
        try {
            int n = this.iSelectionIdx;
            return n;
        }
        finally {
            this.iSolver.currentSolution().getLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeSelection(int selectionIndex) {
        this.iSolver.currentSolution().getLock().writeLock().lock();
        try {
            int newSelectionIndex = 1 + selectionIndex;
            if (newSelectionIndex <= this.iSelectionIdx) {
                return;
            }
            this.iSelectionIdx = newSelectionIndex;
            sLogger.info("Phase changed to " + (newSelectionIndex % this.iSelections.size() + 1));
            sLogger.info(this.iSolver.currentSolution().toString());
            if (this.iSolver.currentSolution().getBestInfo() == null || this.iSolver.getSolutionComparator().isBetterThanBestSolution(this.iSolver.currentSolution())) {
                this.iSolver.currentSolution().saveBest();
            }
            this.iSelections.get(this.iSelectionIdx % this.iSelections.size()).init(this.iSolver);
        }
        finally {
            this.iSolver.currentSolution().getLock().writeLock().unlock();
        }
    }

    public NeighbourSelection<V, T> getSelection() {
        return this.iSelections.get(this.getSelectionIndex() % this.iSelections.size());
    }
}

