/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternDays;
import org.unitime.timetable.model.TimePatternTime;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.solver.CommitedClassAssignmentProxy;

public class ExportPreferences {
    private static Log sLog = LogFactory.getLog(ExportPreferences.class);
    public CommitedClassAssignmentProxy proxy = new CommitedClassAssignmentProxy();
    public Comparator ioCmp = null;
    public Comparator subpartCmp = null;
    public Comparator classCmp = null;

    public void exportDatePattern(Element parent, DatePattern datePattern) {
        sLog.info((Object)("Exporting " + datePattern.getName()));
        Element el = parent.addElement("datePattern");
        el.addAttribute("uniqueId", datePattern.getUniqueId().toString());
        el.addAttribute("name", datePattern.getName());
        el.addAttribute("pattern", datePattern.getPattern());
        el.addAttribute("visible", datePattern.isVisible().toString());
        el.addAttribute("type", datePattern.getType().toString());
        el.addAttribute("offset", datePattern.getOffset().toString());
    }

    public void exportTimePattern(Element parent, TimePattern timePattern) {
        sLog.info((Object)("Exporting " + timePattern.getName()));
        Element el = parent.addElement("timePattern");
        el.addAttribute("uniqueId", timePattern.getUniqueId().toString());
        el.addAttribute("name", timePattern.getName());
        el.addAttribute("minPerMtg", timePattern.getMinPerMtg().toString());
        el.addAttribute("slotsPerMtg", timePattern.getSlotsPerMtg().toString());
        el.addAttribute("nrMeetings", timePattern.getNrMeetings().toString());
        el.addAttribute("visible", timePattern.isVisible().toString());
        el.addAttribute("type", timePattern.getType().toString());
        for (TimePatternDays d : timePattern.getDays()) {
            el.addElement("dayCode").setText(d.getDayCode().toString());
        }
        for (TimePatternTime t : timePattern.getTimes()) {
            el.addElement("startSlot").setText(t.getStartSlot().toString());
        }
    }

    public void exportSubpartStructure(Element parent, SchedulingSubpart s) {
        Element el = parent.addElement("schedulingSubpart");
        el.addAttribute("uniqueId", s.getUniqueId().toString());
        el.addAttribute("itype", s.getItypeDesc());
        el.addAttribute("suffix", s.getSchedulingSubpartSuffix());
        el.addAttribute("minutesPerWk", s.getMinutesPerWk().toString());
        TreeSet<SchedulingSubpart> subparts = new TreeSet<SchedulingSubpart>(this.subpartCmp);
        subparts.addAll(s.getChildSubparts());
        Iterator i = subparts.iterator();
        while (i.hasNext()) {
            this.exportSubpartStructure(el, s);
        }
        TreeSet<Class_> classes = new TreeSet<Class_>(this.classCmp);
        classes.addAll(s.getClasses());
        for (Class_ c : classes) {
            Element x = el.addElement("class");
            x.addAttribute("uniqueId", c.getUniqueId().toString());
            if (c.getParentClass() != null) {
                x.addAttribute("parent", c.getParentClass().getUniqueId().toString());
            }
            x.addAttribute("expectedCapacity", c.getExpectedCapacity().toString());
            x.addAttribute("maxExpectedCapacity", c.getMaxExpectedCapacity().toString());
            x.addAttribute("roomRatio", c.getRoomRatio().toString());
            x.addAttribute("nbrRooms", c.getNbrRooms().toString());
            x.addAttribute("manager", c.getManagingDept().getDeptCode());
            x.addAttribute("sectionNumber", String.valueOf(c.getSectionNumber()));
        }
    }

    public void exportInstructionalOffering(Element parent, InstructionalOffering io) throws Exception {
        Element x;
        sLog.info((Object)("Exporting " + io.getCourseName()));
        Element el = parent.addElement("instructionalOffering");
        el.addAttribute("uniqueId", io.getUniqueId().toString());
        el.addAttribute("subjectArea", io.getControllingCourseOffering().getSubjectAreaAbbv());
        el.addAttribute("courseNbr", io.getControllingCourseOffering().getCourseNbr());
        if (io.getInstrOfferingPermId() != null) {
            el.addAttribute("instrOfferingPermId", io.getInstrOfferingPermId().toString());
        }
        for (CourseOffering co : io.getCourseOfferings()) {
            x = el.addElement("courseOffering");
            x.addAttribute("uniqueId", co.getUniqueId().toString());
            x.addAttribute("subjectArea", co.getSubjectAreaAbbv());
            x.addAttribute("courseNbr", co.getCourseNbr());
            x.addAttribute("projectedDemand", co.getProjectedDemand().toString());
            x.addAttribute("demand", co.getDemand().toString());
            x.addAttribute("isControl", co.getIsControl().toString());
            if (co.getPermId() == null) continue;
            x.addAttribute("permId", co.getPermId());
        }
        for (InstrOfferingConfig c : io.getInstrOfferingConfigs()) {
            x = el.addElement("instrOfferingConfig");
            x.addAttribute("uniqueId", c.getUniqueId().toString());
            x.addAttribute("limit", c.getLimit().toString());
            TreeSet<SchedulingSubpart> subparts = new TreeSet<SchedulingSubpart>(this.subpartCmp);
            subparts.addAll(c.getSchedulingSubparts());
            for (SchedulingSubpart s : subparts) {
                if (s.getParentSubpart() != null) continue;
                this.exportSubpartStructure(x, s);
            }
        }
    }

    public void exportClass(Element parent, Class_ clazz) throws Exception {
        sLog.info((Object)("Exporting " + clazz.getClassLabel()));
        Element el = parent.addElement("class");
        el.addAttribute("uniqueId", clazz.getUniqueId().toString());
        el.addAttribute("subjectArea", clazz.getSchedulingSubpart().getControllingCourseOffering().getSubjectAreaAbbv());
        el.addAttribute("courseNbr", clazz.getSchedulingSubpart().getControllingCourseOffering().getCourseNbr());
        el.addAttribute("itype", clazz.getSchedulingSubpart().getItypeDesc());
        el.addAttribute("section", String.valueOf(clazz.getSectionNumber()));
        el.addAttribute("suffix", clazz.getSchedulingSubpart().getSchedulingSubpartSuffix());
        el.addAttribute("manager", clazz.getManagingDept().getDeptCode());
        el.addAttribute("expectedCapacity", clazz.getExpectedCapacity().toString());
        el.addAttribute("numberOfRooms", clazz.getNbrRooms().toString());
        el.addAttribute("maxExpectedCapacity", clazz.getMaxExpectedCapacity().toString());
        el.addAttribute("roomRatio", clazz.getRoomRatio().toString());
        el.addAttribute("notes", clazz.getNotes());
        if (clazz.getDatePattern() != null) {
            el.addAttribute("datePattern", clazz.getDatePattern().getName());
        }
        el.addAttribute("deptCode", clazz.getControllingDept().getDeptCode());
        Iterator<ClassInstructor> i = clazz.getClassInstructors().iterator();
        while (i.hasNext()) {
            this.exportClassInstructor(el, i.next());
        }
        i = clazz.getPreferences(TimePref.class).iterator();
        while (i.hasNext()) {
            this.exportTimePref(el, (TimePref)((Object)i.next()));
        }
        i = clazz.getPreferences(RoomPref.class).iterator();
        while (i.hasNext()) {
            this.exportRoomPref(el, (RoomPref)((Object)i.next()));
        }
        i = clazz.getPreferences(BuildingPref.class).iterator();
        while (i.hasNext()) {
            this.exportBuildingPref(el, (BuildingPref)((Object)i.next()));
        }
        i = clazz.getPreferences(RoomFeaturePref.class).iterator();
        while (i.hasNext()) {
            this.exportRoomFeaturePref(el, (RoomFeaturePref)((Object)i.next()));
        }
        i = clazz.getPreferences(RoomGroupPref.class).iterator();
        while (i.hasNext()) {
            this.exportRoomGroupPref(el, (RoomGroupPref)((Object)i.next()));
        }
        Assignment assignment = this.proxy.getAssignment(clazz);
        if (assignment != null) {
            el.addAttribute("assignedDays", assignment.getDays().toString());
            el.addAttribute("assignedSlot", assignment.getStartSlot().toString());
            el.addAttribute("assignedTimePattern", assignment.getTimePattern().getName());
            Element r = el.addElement("assignedRooms");
            for (Location location : assignment.getRooms()) {
                r.addElement("room").addAttribute("uniqueId", location.getUniqueId().toString()).addAttribute("name", location.getLabel());
            }
        }
    }

    public void exportSchedulingSubpart(Element parent, SchedulingSubpart subpart) {
        sLog.info((Object)("Exporting " + subpart.getCourseName() + " " + subpart.getItypeDesc() + (subpart.getSchedulingSubpartSuffix().length() == 0 ? "" : " (" + subpart.getSchedulingSubpartSuffix() + ")")));
        Element el = parent.addElement("schedulingSubpart");
        el.addAttribute("uniqueId", subpart.getUniqueId().toString());
        el.addAttribute("subjectArea", subpart.getControllingCourseOffering().getSubjectAreaAbbv());
        el.addAttribute("courseNbr", subpart.getControllingCourseOffering().getCourseNbr());
        el.addAttribute("itype", subpart.getItypeDesc());
        el.addAttribute("suffix", subpart.getSchedulingSubpartSuffix());
        el.addAttribute("manager", subpart.getManagingDept().getDeptCode());
        el.addAttribute("minutesPerWk", subpart.getMinutesPerWk().toString());
        if (subpart.getDatePattern() != null) {
            el.addAttribute("datePattern", subpart.getDatePattern().getName());
        }
        el.addAttribute("deptCode", subpart.getControllingDept().getDeptCode());
        Iterator i = subpart.getPreferences(TimePref.class).iterator();
        while (i.hasNext()) {
            this.exportTimePref(el, (TimePref)i.next());
        }
        i = subpart.getPreferences(RoomPref.class).iterator();
        while (i.hasNext()) {
            this.exportRoomPref(el, (RoomPref)i.next());
        }
        i = subpart.getPreferences(BuildingPref.class).iterator();
        while (i.hasNext()) {
            this.exportBuildingPref(el, (BuildingPref)i.next());
        }
        i = subpart.getPreferences(RoomFeaturePref.class).iterator();
        while (i.hasNext()) {
            this.exportRoomFeaturePref(el, (RoomFeaturePref)i.next());
        }
        i = subpart.getPreferences(RoomGroupPref.class).iterator();
        while (i.hasNext()) {
            this.exportRoomGroupPref(el, (RoomGroupPref)i.next());
        }
    }

    public void exportClassInstructor(Element parent, ClassInstructor classInstructor) {
        Element el = parent.addElement("instructor");
        el.addAttribute("uniqueId", classInstructor.getInstructor().getUniqueId().toString());
        el.addAttribute("isLead", classInstructor.isLead().toString());
        el.addAttribute("percentShare", classInstructor.getPercentShare().toString());
        el.addAttribute("puid", classInstructor.getInstructor().getExternalUniqueId());
        if (classInstructor.getResponsibility() != null) {
            el.addAttribute("responsibility", classInstructor.getResponsibility().getReference());
        }
    }

    public void exportTimePref(Element parent, TimePref timePref) {
        Element el = parent.addElement("timePref");
        el.addAttribute("uniqueId", timePref.getUniqueId().toString());
        el.addAttribute("timePattern", timePref.getTimePattern().getName());
        el.addAttribute("level", timePref.getPrefLevel().getPrefProlog());
        el.addAttribute("preference", timePref.getPreference());
    }

    public void exportRoomPref(Element parent, RoomPref roomPref) {
        Element el = parent.addElement("roomPref");
        el.addAttribute("uniqueId", roomPref.getUniqueId().toString());
        el.addAttribute("level", roomPref.getPrefLevel().getPrefProlog());
        el.addAttribute("room", roomPref.getRoom().getLabel());
    }

    public void exportBuildingPref(Element parent, BuildingPref bldgPref) {
        Element el = parent.addElement("buildingPref");
        el.addAttribute("uniqueId", bldgPref.getUniqueId().toString());
        el.addAttribute("level", bldgPref.getPrefLevel().getPrefProlog());
        el.addAttribute("building", bldgPref.getBuilding().getAbbreviation());
    }

    public void exportRoomFeaturePref(Element parent, RoomFeaturePref roomFeaturePref) {
        Element el = parent.addElement("roomFeaturePref");
        el.addAttribute("uniqueId", roomFeaturePref.getUniqueId().toString());
        el.addAttribute("level", roomFeaturePref.getPrefLevel().getPrefProlog());
        el.addAttribute("feature", roomFeaturePref.getRoomFeature().getLabel());
    }

    public void exportRoomGroupPref(Element parent, RoomGroupPref roomGroupPref) {
        Element el = parent.addElement("roomGroupPref");
        el.addAttribute("uniqueId", roomGroupPref.getUniqueId().toString());
        el.addAttribute("level", roomGroupPref.getPrefLevel().getPrefProlog());
        el.addAttribute("group", roomGroupPref.getRoomGroup().getName());
    }

    public void exportDistributionPref(Element parent, DistributionPref distributionPref) {
        sLog.info((Object)("Exporting " + distributionPref.getDistributionType().getLabel()));
        Element el = parent.addElement("distributionPref");
        el.addAttribute("uniqueId", distributionPref.getUniqueId().toString());
        el.addAttribute("level", distributionPref.getPrefLevel().getPrefProlog());
        el.addAttribute("type", distributionPref.getDistributionType().getReference());
        el.addAttribute("manager", ((Department)distributionPref.getOwner()).getDeptCode());
        el.addAttribute("grouping", distributionPref.getGrouping() == null ? "0" : distributionPref.getGrouping().toString());
        for (DistributionObject dobj : distributionPref.getDistributionObjects()) {
            Element x;
            if (dobj.getPrefGroup() instanceof Class_) {
                Class_ clazz = (Class_)dobj.getPrefGroup();
                x = el.addElement("class");
                x.addAttribute("sequenceNumber", dobj.getSequenceNumber().toString());
                x.addAttribute("uniqueId", clazz.getUniqueId().toString());
                x.addAttribute("subjectArea", clazz.getSchedulingSubpart().getControllingCourseOffering().getSubjectAreaAbbv());
                x.addAttribute("courseNbr", clazz.getSchedulingSubpart().getControllingCourseOffering().getCourseNbr());
                x.addAttribute("itype", clazz.getSchedulingSubpart().getItypeDesc());
                x.addAttribute("section", String.valueOf(clazz.getSectionNumber()));
                x.addAttribute("suffix", clazz.getSchedulingSubpart().getSchedulingSubpartSuffix());
                continue;
            }
            if (!(dobj.getPrefGroup() instanceof SchedulingSubpart)) continue;
            SchedulingSubpart subpart = (SchedulingSubpart)dobj.getPrefGroup();
            x = el.addElement("schedulingSubpart");
            x.addAttribute("sequenceNumber", dobj.getSequenceNumber().toString());
            x.addAttribute("uniqueId", subpart.getUniqueId().toString());
            x.addAttribute("subjectArea", subpart.getControllingCourseOffering().getSubjectAreaAbbv());
            x.addAttribute("courseNbr", subpart.getControllingCourseOffering().getCourseNbr());
            x.addAttribute("itype", subpart.getItypeDesc());
            x.addAttribute("suffix", subpart.getSchedulingSubpartSuffix());
        }
    }

    public void exportInstructor(Element parent, DepartmentalInstructor instructorDept) {
        sLog.info((Object)("Exporting " + instructorDept.getNameLastFirst() + " (" + instructorDept.getDepartment().getDeptCode() + ")"));
        Element el = parent.addElement("instructor");
        el.addAttribute("uniqueId", instructorDept.getUniqueId().toString());
        el.addAttribute("deptCode", instructorDept.getDepartment().getDeptCode());
        el.addAttribute("puid", instructorDept.getExternalUniqueId());
        Iterator i = instructorDept.getPreferences(TimePref.class).iterator();
        while (i.hasNext()) {
            this.exportTimePref(el, (TimePref)i.next());
        }
        i = instructorDept.getPreferences(RoomPref.class).iterator();
        while (i.hasNext()) {
            this.exportRoomPref(el, (RoomPref)i.next());
        }
        i = instructorDept.getPreferences(BuildingPref.class).iterator();
        while (i.hasNext()) {
            this.exportBuildingPref(el, (BuildingPref)i.next());
        }
        i = instructorDept.getPreferences(RoomFeaturePref.class).iterator();
        while (i.hasNext()) {
            this.exportRoomFeaturePref(el, (RoomFeaturePref)i.next());
        }
        i = instructorDept.getPreferences(RoomGroupPref.class).iterator();
        while (i.hasNext()) {
            this.exportRoomGroupPref(el, (RoomGroupPref)i.next());
        }
    }

    public void exportInstructors(Element parent, Department dept) {
        List ids = new DepartmentDAO().getSession().createQuery("select id from DepartmentalInstructor id where id.department.deptCode=:deptCode and id.department.sessionId=:sessionId").setString("deptCode", dept.getDeptCode()).setLong("sessionId", dept.getSessionId().longValue()).list();
        for (DepartmentalInstructor id : ids) {
            this.exportInstructor(parent, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportAll(Long solverGroupId, File outFile) throws Exception {
        SolverGroup solverGroup = (SolverGroup)new SolverGroupDAO().get(solverGroupId);
        Session session = solverGroup.getSession();
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("export");
        root.addAttribute("solverGroup", solverGroup.getUniqueId().toString());
        root.addAttribute("solverGroupName", solverGroup.getName());
        root.addAttribute("session", session.getUniqueId().toString());
        root.addAttribute("academicYearTerm", session.getAcademicYearTerm());
        root.addAttribute("academicInitiative", session.getAcademicInitiative());
        for (TimePattern t : TimePattern.findAll(session, null)) {
            this.exportTimePattern(root, t);
        }
        for (DatePattern d : DatePattern.findAll(session, true, null, null)) {
            this.exportDatePattern(root, d);
        }
        this.classCmp = new Comparator(){

            public int compare(Object o1, Object o2) {
                Class_ c1 = (Class_)o1;
                Class_ c2 = (Class_)o2;
                int cmp = c1.getCourseName().compareTo(c2.getCourseName());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = c1.getSchedulingSubpart().getItype().getItype().compareTo(c2.getSchedulingSubpart().getItype().getItype());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = c1.getSchedulingSubpart().getSchedulingSubpartSuffix().compareTo(c2.getSchedulingSubpart().getSchedulingSubpartSuffix());
                if (cmp != 0) {
                    return cmp;
                }
                return c1.getUniqueId().compareTo(c2.getUniqueId());
            }
        };
        TreeSet classes = new TreeSet(this.classCmp);
        this.subpartCmp = new Comparator(){

            public int compare(Object o1, Object o2) {
                SchedulingSubpart s1 = (SchedulingSubpart)o1;
                SchedulingSubpart s2 = (SchedulingSubpart)o2;
                int cmp = s1.getCourseName().compareTo(s2.getCourseName());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = s1.getItype().getItype().compareTo(s2.getItype().getItype());
                if (cmp != 0) {
                    return cmp;
                }
                return s1.getUniqueId().compareTo(s2.getUniqueId());
            }
        };
        TreeSet<SchedulingSubpart> subparts = new TreeSet<SchedulingSubpart>(this.subpartCmp);
        this.ioCmp = new Comparator(){

            public int compare(Object o1, Object o2) {
                InstructionalOffering i1 = (InstructionalOffering)o1;
                InstructionalOffering i2 = (InstructionalOffering)o2;
                int cmp = i1.getCourseName().compareTo(i2.getCourseName());
                if (cmp != 0) {
                    return cmp;
                }
                return i1.getUniqueId().compareTo(i2.getUniqueId());
            }
        };
        TreeSet<InstructionalOffering> offerings = new TreeSet<InstructionalOffering>(this.ioCmp);
        classes.addAll(solverGroup.getClasses());
        for (Class_ c : classes) {
            this.exportClass(root, c);
            SchedulingSubpart s = c.getSchedulingSubpart();
            offerings.add(s.getInstrOfferingConfig().getInstructionalOffering());
            if (!solverGroup.getDepartments().contains(s.getManagingDept())) continue;
            subparts.add(s);
        }
        for (SchedulingSubpart s : subparts) {
            this.exportSchedulingSubpart(root, s);
        }
        for (InstructionalOffering io : offerings) {
            this.exportInstructionalOffering(root, io);
        }
        for (Comparable<Department> d : solverGroup.getDepartments()) {
            this.exportInstructors(root, (Department)d);
        }
        for (Comparable<Department> d : solverGroup.getDistributionPreferences()) {
            this.exportDistributionPref(root, (DistributionPref)d);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outFile);
            new XMLWriter((OutputStream)fos, OutputFormat.createPrettyPrint()).write(document);
            fos.flush();
            fos.close();
            fos = null;
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (fos != null) {
                fos.close();
            }
        }
        catch (IOException e) {}
    }

    public static void main(String[] args) {
        try {
            ToolBox.configureLogging();
            HibernateUtil.configureHibernate(args[0]);
            new ExportPreferences().exportAll(new Long(args[1]), new File(args[2]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

