/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.ui;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.criteria.additional.ImportantStudentConflict;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DistanceMetric;
import org.dom4j.Element;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.solver.ui.TimetableInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JenrlInfo
implements TimetableInfo,
Serializable {
    private static DecimalFormat sDF = new DecimalFormat("0.#");
    private static final long serialVersionUID = 1L;
    public static int sVersion = 1;
    public double iJenrl = 0.0;
    public boolean iIsSatisfied = false;
    public boolean iIsHard = false;
    public boolean iIsDistance = false;
    public boolean iIsFixed = false;
    public boolean iIsCommited = false;
    public boolean iIsImportant = false;
    public boolean iIsInstructor = false;
    public double iDistance = 0.0;
    public ClassAssignmentDetails iFirst = null;
    public ClassAssignmentDetails iSecond = null;
    private TreeSet<CurriculumInfo> iCurriculum2nrStudents = null;

    public JenrlInfo() {
    }

    public JenrlInfo(JenrlConstraint jc) {
        this(null, jc);
    }

    public JenrlInfo(Solver solver, JenrlConstraint jc) {
        Assignment assignment = solver.currentSolution().getAssignment();
        TimetableModel model = (TimetableModel)solver.currentSolution().getModel();
        Lecture first = (Lecture)jc.first();
        Placement firstPl = (Placement)assignment.getValue((Variable)first);
        Lecture second = (Lecture)jc.second();
        Placement secondPl = (Placement)assignment.getValue((Variable)second);
        if (solver != null) {
            if (firstPl != null) {
                this.iFirst = new ClassAssignmentDetails(solver, first, firstPl, false);
            }
            if (secondPl != null) {
                this.iSecond = new ClassAssignmentDetails(solver, second, secondPl, false);
            }
        }
        if (firstPl == null || secondPl == null) {
            return;
        }
        this.setJenrl(jc.getJenrl());
        this.setIsSatisfied(jc.isInConflict(assignment));
        if (jc.isInConflict(assignment)) {
            StudentConflict imp;
            this.setIsHard(first.areStudentConflictsHard(second));
            this.setIsFixed(first.nrTimeLocations() == 1 && second.nrTimeLocations() == 1);
            this.setIsDistance(!firstPl.getTimeLocation().hasIntersection(secondPl.getTimeLocation()));
            this.setIsCommited(jc.areStudentConflictsCommitted());
            if (this.isDistance()) {
                this.setDistance(Placement.getDistanceInMeters((DistanceMetric)model.getDistanceMetric(), (Placement)firstPl, (Placement)secondPl));
            }
            this.setIsImportant((imp = (StudentConflict)model.getCriterion(ImportantStudentConflict.class)) != null && imp.isApplicable(first, second) && imp.inConflict(firstPl, secondPl));
            this.setIsInstructor(jc.getNrInstructors() > 0);
        }
        Hashtable<String, Double> curriculum2nrStudents = new Hashtable<String, Double>();
        for (Student student : ((Lecture)jc.first()).sameStudents((Lecture)jc.second())) {
            if (student.getCurriculum() == null || student.getCurriculum().isEmpty()) continue;
            for (String c : student.getCurriculum().split("\\|")) {
                Double nrStudents = (Double)curriculum2nrStudents.get(c);
                curriculum2nrStudents.put(student.getCurriculum(), jc.getJenrlWeight(student) + (nrStudents == null ? 0.0 : nrStudents));
            }
        }
        if (!curriculum2nrStudents.isEmpty()) {
            this.iCurriculum2nrStudents = new TreeSet();
            for (Map.Entry entry : curriculum2nrStudents.entrySet()) {
                this.iCurriculum2nrStudents.add(new CurriculumInfo((String)entry.getKey(), (Double)entry.getValue()));
            }
        }
    }

    public ClassAssignmentDetails getFirst() {
        return this.iFirst;
    }

    public ClassAssignmentDetails getSecond() {
        return this.iSecond;
    }

    public static Hashtable getCommitedJenrlInfos(Lecture lecture) {
        return JenrlInfo.getCommitedJenrlInfos(null, lecture);
    }

    public static Hashtable<Long, JenrlInfo> getCommitedJenrlInfos(Solver solver, Lecture lecture) {
        Assignment assignment = solver.currentSolution().getAssignment();
        Hashtable<Long, JenrlInfo> ret = new Hashtable<Long, JenrlInfo>();
        Hashtable assignment2curriculum2nrStudents = new Hashtable();
        Placement placement = (Placement)assignment.getValue((Variable)lecture);
        if (placement == null) {
            return ret;
        }
        for (Student student : lecture.students()) {
            Set conflicts = student.conflictPlacements(placement);
            if (conflicts == null) continue;
            for (Placement pl : conflicts) {
                JenrlInfo info = ret.get(pl.getAssignmentId());
                if (info == null) {
                    info = new JenrlInfo();
                    info.setIsCommited(true);
                    info.setIsDistance(!pl.getTimeLocation().hasIntersection(placement.getTimeLocation()));
                    info.setIsFixed(lecture.nrTimeLocations() == 1);
                    if (solver != null) {
                        info.iFirst = new ClassAssignmentDetails(solver, lecture, placement, false);
                        info.iSecond = new ClassAssignmentDetails(solver, (Lecture)pl.variable(), pl, false);
                    }
                    if (info.isDistance()) {
                        info.setDistance(Placement.getDistanceInMeters((DistanceMetric)((TimetableModel)lecture.getModel()).getDistanceMetric(), (Placement)placement, (Placement)pl));
                    }
                    ret.put(pl.getAssignmentId(), info);
                }
                if (student.getCurriculum() != null && !student.getCurriculum().isEmpty()) {
                    Hashtable<String, Double> curriculum2nrStudents = (Hashtable<String, Double>)assignment2curriculum2nrStudents.get(pl.getAssignmentId());
                    if (curriculum2nrStudents == null) {
                        curriculum2nrStudents = new Hashtable<String, Double>();
                        assignment2curriculum2nrStudents.put(pl.getAssignmentId(), curriculum2nrStudents);
                    }
                    for (String c : student.getCurriculum().split("\\|")) {
                        Double nrStudents = (Double)curriculum2nrStudents.get(c);
                        curriculum2nrStudents.put(student.getCurriculum(), student.getJenrlWeight(lecture, (Lecture)pl.variable()) + (nrStudents == null ? 0.0 : nrStudents));
                    }
                }
                info.setJenrl(info.getJenrl() + student.getJenrlWeight(lecture, (Lecture)pl.variable()));
            }
        }
        for (Map.Entry entry : assignment2curriculum2nrStudents.entrySet()) {
            Long assignmentId = (Long)entry.getKey();
            Hashtable curriculum2nrStudents = (Hashtable)entry.getValue();
            if (curriculum2nrStudents.isEmpty()) continue;
            JenrlInfo info = ret.get(assignmentId);
            info.iCurriculum2nrStudents = new TreeSet();
            for (Map.Entry e : curriculum2nrStudents.entrySet()) {
                info.iCurriculum2nrStudents.add(new CurriculumInfo((String)e.getKey(), (Double)e.getValue()));
            }
        }
        return ret;
    }

    public double getJenrl() {
        return this.iJenrl;
    }

    public void setJenrl(double jenrl) {
        this.iJenrl = jenrl;
    }

    public boolean isSatisfied() {
        return this.iIsSatisfied;
    }

    public void setIsSatisfied(boolean isSatisfied) {
        this.iIsSatisfied = isSatisfied;
    }

    public boolean isHard() {
        return this.iIsHard;
    }

    public void setIsHard(boolean isHard) {
        this.iIsHard = isHard;
    }

    public boolean isDistance() {
        return this.iIsDistance;
    }

    public void setIsDistance(boolean isDistance) {
        this.iIsDistance = isDistance;
    }

    public boolean isFixed() {
        return this.iIsFixed;
    }

    public void setIsFixed(boolean isFixed) {
        this.iIsFixed = isFixed;
    }

    public boolean isCommited() {
        return this.iIsCommited;
    }

    public void setIsCommited(boolean isCommited) {
        this.iIsCommited = isCommited;
    }

    public boolean isImportant() {
        return this.iIsImportant;
    }

    public void setIsImportant(boolean isImportant) {
        this.iIsImportant = isImportant;
    }

    public boolean isInstructor() {
        return this.iIsInstructor;
    }

    public void setIsInstructor(boolean isInstructor) {
        this.iIsInstructor = isInstructor;
    }

    public double getDistance() {
        return this.iDistance;
    }

    public void setDistance(double distance) {
        this.iDistance = distance;
    }

    public boolean hasCurricula() {
        return this.iCurriculum2nrStudents != null;
    }

    public String getCurriculumText() {
        if (!this.hasCurricula()) {
            return "";
        }
        int top = 0;
        double total = 0.0;
        for (CurriculumInfo i : this.iCurriculum2nrStudents) {
            total += i.getNrStudents();
        }
        String ret = "";
        for (CurriculumInfo i : this.iCurriculum2nrStudents) {
            double fraction = i.getNrStudents() / total;
            if (top < 3) {
                ++top;
                if (!ret.isEmpty()) {
                    ret = ret + ", ";
                }
                ret = ret + sDF.format(100.0 * fraction) + "% " + i.getName();
                if (fraction != 1.0) continue;
                return i.getName();
            }
            ret = ret + ", ...";
            break;
        }
        return ret;
    }

    @Override
    public void load(Element root) {
        int version = Integer.parseInt(root.attributeValue("version"));
        if (version == 1) {
            this.iJenrl = Double.parseDouble(root.elementText("jenrl"));
            this.iIsSatisfied = Boolean.valueOf(root.elementText("satisfied"));
            this.iIsDistance = Boolean.valueOf(root.elementText("dist"));
            this.iIsFixed = Boolean.valueOf(root.elementText("fixed"));
            this.iIsHard = Boolean.valueOf(root.elementText("hard"));
            if (root.elementText("distance") != null) {
                this.iDistance = Double.parseDouble(root.elementText("distance"));
            }
            this.iIsCommited = root.elementText("commited") == null ? false : Boolean.valueOf(root.elementText("commited"));
            this.iIsImportant = root.elementText("important") == null ? false : Boolean.valueOf(root.elementText("important"));
            this.iIsInstructor = root.elementText("instructor") == null ? false : Boolean.valueOf(root.elementText("instructor"));
        }
    }

    @Override
    public void save(Element root) {
        root.addAttribute("version", String.valueOf(sVersion));
        root.addElement("jenrl").setText(String.valueOf(this.iJenrl));
        root.addElement("satisfied").setText(String.valueOf(this.iIsSatisfied));
        root.addElement("dist").setText(String.valueOf(this.iIsDistance));
        root.addElement("fixed").setText(String.valueOf(this.iIsFixed));
        root.addElement("hard").setText(String.valueOf(this.iIsHard));
        root.addElement("commited").setText(String.valueOf(this.iIsCommited));
        root.addElement("distance").setText(String.valueOf(this.iDistance));
        root.addElement("important").setText(String.valueOf(this.iIsImportant));
        root.addElement("instructor").setText(String.valueOf(this.iIsInstructor));
    }

    @Override
    public boolean saveToFile() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CurriculumInfo
    implements Serializable,
    Comparable<CurriculumInfo> {
        private static final long serialVersionUID = 1L;
        private String iName;
        private double iNrStudents;

        public CurriculumInfo(String name, double nrStudents) {
            this.iName = name;
            this.iNrStudents = nrStudents;
        }

        public String getName() {
            return this.iName;
        }

        public double getNrStudents() {
            return this.iNrStudents;
        }

        @Override
        public int compareTo(CurriculumInfo i) {
            int cmp = Double.compare(i.getNrStudents(), this.getNrStudents());
            if (cmp != 0) {
                return cmp;
            }
            return this.getName().compareTo(i.getName());
        }
    }
}

