/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.ui;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.DepartmentSpreadConstraint;
import org.cpsolver.coursett.constraint.SpreadConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.solver.Solver;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;

public class DeptBalancingReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashSet iGroups = new HashSet();
    private int iFirstDaySlot;
    private int iLastDaySlot;
    private int iFirstWorkDay;
    private int iLastWorkDay;

    public DeptBalancingReport(Solver solver) {
        TimetableModel model = (TimetableModel)solver.currentSolution().getModel();
        this.iFirstDaySlot = model.getProperties().getPropertyInt("General.FirstDaySlot", Constants.DAY_SLOTS_FIRST);
        this.iLastDaySlot = model.getProperties().getPropertyInt("General.LastDaySlot", Constants.DAY_SLOTS_LAST);
        this.iFirstWorkDay = model.getProperties().getPropertyInt("General.FirstWorkDay", 0);
        this.iLastWorkDay = model.getProperties().getPropertyInt("General.LastWorkDay", Constants.NR_DAYS_WEEK - 1);
        for (DepartmentSpreadConstraint deptSpread : model.getDepartmentSpreadConstraints()) {
            this.iGroups.add(new DeptBalancingGroup(solver, deptSpread));
        }
    }

    public int getFirstDaySlot() {
        return this.iFirstDaySlot;
    }

    public int getLastDaySlot() {
        return this.iLastDaySlot;
    }

    public int getFirstWorkDay() {
        return this.iFirstWorkDay;
    }

    public int getLastWorkDay() {
        return this.iLastWorkDay;
    }

    public int getSlotsPerDayNoEvening() {
        return this.iLastDaySlot - this.iFirstDaySlot + 1;
    }

    public int getNrWorkDays() {
        return this.iLastWorkDay - this.iFirstWorkDay + 1;
    }

    public Set getGroups() {
        return this.iGroups;
    }

    public class DeptBalancingGroup
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long iDeptId = null;
        private String iDeptName = null;
        private int[][] iLimit;
        private int[][] iUsage;
        private HashSet[][] iCourses;

        public DeptBalancingGroup(Solver solver, DepartmentSpreadConstraint deptSpread) {
            Assignment assignment = solver.currentSolution().getAssignment();
            this.iDeptId = deptSpread.getDepartmentId();
            this.iDeptName = deptSpread.getName();
            this.iLimit = new int[DeptBalancingReport.this.iLastDaySlot - DeptBalancingReport.this.iFirstDaySlot + 1][DeptBalancingReport.this.iLastWorkDay - DeptBalancingReport.this.iFirstWorkDay + 1];
            this.iUsage = new int[DeptBalancingReport.this.iLastDaySlot - DeptBalancingReport.this.iFirstDaySlot + 1][DeptBalancingReport.this.iLastWorkDay - DeptBalancingReport.this.iFirstWorkDay + 1];
            this.iCourses = new HashSet[DeptBalancingReport.this.iLastDaySlot - DeptBalancingReport.this.iFirstDaySlot + 1][DeptBalancingReport.this.iLastWorkDay - DeptBalancingReport.this.iFirstWorkDay + 1];
            Hashtable<Long, ClassAssignmentDetails> detailCache = new Hashtable<Long, ClassAssignmentDetails>();
            SpreadConstraint.SpreadConstraintContext context = (SpreadConstraint.SpreadConstraintContext)deptSpread.getContext(assignment);
            for (int i = 0; i < DeptBalancingReport.this.iLastDaySlot - DeptBalancingReport.this.iFirstDaySlot + 1; ++i) {
                for (int j = 0; j < DeptBalancingReport.this.iLastWorkDay - DeptBalancingReport.this.iFirstWorkDay + 1; ++j) {
                    this.iLimit[i][j] = context.getMaxCourses(i + DeptBalancingReport.this.iFirstDaySlot, j + DeptBalancingReport.this.iFirstWorkDay);
                    this.iUsage[i][j] = context.getCourses(i + DeptBalancingReport.this.iFirstDaySlot, j + DeptBalancingReport.this.iFirstWorkDay).size();
                    this.iCourses[i][j] = new HashSet(context.getCourses(i + DeptBalancingReport.this.iFirstDaySlot, j + DeptBalancingReport.this.iFirstWorkDay).size());
                    for (Placement placement : context.getCourses(i + DeptBalancingReport.this.iFirstDaySlot, j + DeptBalancingReport.this.iFirstWorkDay)) {
                        Lecture lecture = (Lecture)placement.variable();
                        ClassAssignmentDetails ca = (ClassAssignmentDetails)detailCache.get(lecture.getClassId());
                        if (ca == null) {
                            ca = new ClassAssignmentDetails(solver, lecture, false);
                            detailCache.put(lecture.getClassId(), ca);
                        }
                        this.iCourses[i][j].add(ca);
                    }
                }
            }
        }

        public Long getDepartmentId() {
            return this.iDeptId;
        }

        public String getDepartmentName() {
            return this.iDeptName;
        }

        public int getLimit(int slot, int day) {
            if (slot < DeptBalancingReport.this.iFirstDaySlot || slot > DeptBalancingReport.this.iLastDaySlot) {
                return 0;
            }
            if (day < DeptBalancingReport.this.iFirstWorkDay || day > DeptBalancingReport.this.iLastWorkDay) {
                return 0;
            }
            return this.iLimit[slot - DeptBalancingReport.this.iFirstDaySlot][day - DeptBalancingReport.this.iFirstWorkDay];
        }

        public int getUsage(int slot, int day) {
            if (slot < DeptBalancingReport.this.iFirstDaySlot || slot > DeptBalancingReport.this.iLastDaySlot) {
                return 0;
            }
            if (day < DeptBalancingReport.this.iFirstWorkDay || day > DeptBalancingReport.this.iLastWorkDay) {
                return 0;
            }
            return this.iUsage[slot - DeptBalancingReport.this.iFirstDaySlot][day - DeptBalancingReport.this.iFirstWorkDay];
        }

        public Collection getClasses(int slot, int day) {
            if (slot < DeptBalancingReport.this.iFirstDaySlot || slot > DeptBalancingReport.this.iLastDaySlot) {
                return new HashSet(0);
            }
            if (day < DeptBalancingReport.this.iFirstWorkDay || day > DeptBalancingReport.this.iLastWorkDay) {
                return new HashSet(0);
            }
            return this.iCourses[slot - DeptBalancingReport.this.iFirstDaySlot][day - DeptBalancingReport.this.iFirstWorkDay];
        }

        public int getLimit(int slot) {
            if (slot < DeptBalancingReport.this.iFirstDaySlot || slot > DeptBalancingReport.this.iLastDaySlot) {
                return 0;
            }
            int ret = 0;
            for (int day = 0; day < DeptBalancingReport.this.iLastWorkDay - DeptBalancingReport.this.iFirstWorkDay + 1; ++day) {
                ret += this.iLimit[slot - DeptBalancingReport.this.iFirstDaySlot][day - DeptBalancingReport.this.iFirstWorkDay];
            }
            return ret;
        }

        public int getUsage(int slot) {
            if (slot < DeptBalancingReport.this.iFirstDaySlot || slot > DeptBalancingReport.this.iLastDaySlot) {
                return 0;
            }
            int ret = 0;
            for (int day = 0; day < DeptBalancingReport.this.iLastWorkDay - DeptBalancingReport.this.iFirstWorkDay + 1; ++day) {
                ret += this.iUsage[slot - DeptBalancingReport.this.iFirstDaySlot][day - DeptBalancingReport.this.iFirstWorkDay];
            }
            return ret;
        }

        public int getExcess(int slot) {
            if (slot < DeptBalancingReport.this.iFirstDaySlot || slot > DeptBalancingReport.this.iLastDaySlot) {
                return 0;
            }
            int ret = 0;
            for (int day = 0; day < DeptBalancingReport.this.iLastWorkDay - DeptBalancingReport.this.iFirstWorkDay + 1; ++day) {
                ret += Math.max(0, this.iUsage[slot - DeptBalancingReport.this.iFirstDaySlot][day - DeptBalancingReport.this.iFirstWorkDay] - this.iLimit[slot - DeptBalancingReport.this.iFirstDaySlot][day - DeptBalancingReport.this.iFirstWorkDay]);
            }
            return ret;
        }

        public Collection getClasses(int slot) {
            if (slot < DeptBalancingReport.this.iFirstDaySlot || slot > DeptBalancingReport.this.iLastDaySlot) {
                return new HashSet(0);
            }
            HashSet ret = new HashSet();
            for (int day = 0; day < DeptBalancingReport.this.iLastWorkDay - DeptBalancingReport.this.iFirstWorkDay + 1; ++day) {
                ret.addAll(this.iCourses[slot - DeptBalancingReport.this.iFirstDaySlot][day - DeptBalancingReport.this.iFirstWorkDay]);
            }
            return ret;
        }
    }
}

