/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula.students;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.ConstraintWithContext;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.solver.curricula.students.CurModel;
import org.unitime.timetable.solver.curricula.students.CurStudent;
import org.unitime.timetable.solver.curricula.students.CurValue;
import org.unitime.timetable.solver.curricula.students.CurVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurCourse
extends ConstraintWithContext<CurVariable, CurValue, CurCourseContext> {
    private static DecimalFormat sDF = new DecimalFormat("0.###");
    private String iCourseName;
    private Long iCourseId;
    private Hashtable<Long, Double> iTargetShare = new Hashtable();
    private CurModel iModel;
    private double iMaxSize;
    private Double iPriority = null;

    public CurCourse(CurModel model, Long course, String courseName, int maxNrStudents, double maxSize, Double priority) {
        this.iModel = model;
        this.iCourseId = course;
        this.iCourseName = courseName;
        this.iMaxSize = maxSize;
        this.iPriority = priority;
        for (int i = 0; i < maxNrStudents; ++i) {
            CurVariable c = new CurVariable(model, this, 0, model.getStudents().size());
            model.addVariable(c);
            this.addVariable(c);
        }
        model.addConstraint((Constraint)this);
    }

    public void computeConflicts(Assignment<CurVariable, CurValue> assignment, CurValue value, Set<CurValue> conflicts) {
        if (this.getSize(assignment) + value.getStudent().getWeight() > this.getMaxSize()) {
            double excess = this.getSize(assignment) + value.getStudent().getWeight() - this.getMaxSize();
            for (CurValue conf : conflicts) {
                if (!((CurVariable)conf.variable()).getCourse().equals((Object)this)) continue;
                excess -= conf.getStudent().getWeight();
            }
            while (excess > 0.0) {
                ArrayList<CurValue> adepts = new ArrayList<CurValue>();
                double best = 0.0;
                for (CurVariable assigned : this.variables()) {
                    CurValue adept;
                    if (assigned.equals(value.variable()) || (adept = (CurValue)assignment.getValue((Variable)assigned)) == null || conflicts.contains((Object)adept)) continue;
                    double p = adept.toDouble(assignment);
                    if (adepts.isEmpty() || p < best) {
                        best = p;
                        adepts.clear();
                        adepts.add(adept);
                        continue;
                    }
                    if (p != best) continue;
                    adepts.add(adept);
                }
                if (adepts.isEmpty()) {
                    conflicts.add(value);
                    break;
                }
                CurValue conf = (CurValue)((Object)ToolBox.random(adepts));
                conflicts.add(conf);
                excess -= conf.getStudent().getWeight();
            }
        }
        if (this.getStudents(assignment).contains((Object)value.getStudent())) {
            for (CurVariable sc : this.variables()) {
                CurValue v = (CurValue)assignment.getValue((Variable)sc);
                if (v == null || !((Object)((Object)v.getStudent())).equals((Object)value.getStudent())) continue;
                conflicts.add(v);
            }
        }
    }

    public double getMaxSize() {
        return this.iMaxSize + this.iModel.getMinStudentWidth() / 2.0;
    }

    public double getOriginalMaxSize() {
        return this.iMaxSize;
    }

    public Long getCourseId() {
        return this.iCourseId;
    }

    public String getCourseName() {
        return this.iCourseName;
    }

    public int getNrStudents() {
        return this.variables().size();
    }

    public Set<CurStudent> getStudents(Assignment<CurVariable, CurValue> assignment) {
        return ((CurCourseContext)this.getContext(assignment)).getStudents();
    }

    public double getSize(Assignment<CurVariable, CurValue> assignment) {
        return ((CurCourseContext)this.getContext(assignment)).getSize();
    }

    public CurValue getValue(Assignment<CurVariable, CurValue> assignment, CurStudent student) {
        for (CurVariable var : this.variables()) {
            CurValue val = (CurValue)assignment.getValue((Variable)var);
            if (val == null || !((Object)((Object)val.getStudent())).equals((Object)student)) continue;
            return val;
        }
        return null;
    }

    public double share(Assignment<CurVariable, CurValue> assignment, CurCourse course) {
        double share = 0.0;
        for (CurStudent s : ((CurCourseContext)this.getContext(assignment)).getStudents()) {
            if (!course.getStudents(assignment).contains((Object)s)) continue;
            share += s.getWeight();
        }
        return share;
    }

    public double penalty(Assignment<CurVariable, CurValue> assignment, CurCourse course) {
        double target = this.getTargetShare(course.getCourseId());
        return Math.abs(this.share(assignment, course) - target) * (target == 0.0 ? 10.0 : 1.0);
    }

    public double penalty(Assignment<CurVariable, CurValue> assignment, CurStudent student) {
        return this.penalty(assignment, student, null);
    }

    public double penalty(Assignment<CurVariable, CurValue> assignment, CurStudent newStudent, CurStudent oldStudent) {
        if (oldStudent != null && ((Object)((Object)oldStudent)).equals((Object)newStudent)) {
            return this.penalty(assignment, newStudent, null);
        }
        double penalty = 0.0;
        for (CurCourse course : this.iModel.getCourses()) {
            if (course.getCourseId().equals(this.getCourseId())) continue;
            double target = this.getTargetShare(course.getCourseId());
            double share = this.share(assignment, course);
            double oldPenalty = Math.abs(share - target);
            if (newStudent != null && course.getStudents(assignment).contains((Object)newStudent)) {
                share += newStudent.getWeight();
            }
            if (oldStudent != null && course.getStudents(assignment).contains((Object)oldStudent)) {
                share -= oldStudent.getWeight();
            }
            double newPenalty = Math.abs(share - target);
            penalty += (newPenalty - oldPenalty) * (target == 0.0 ? 10.0 : 1.0);
        }
        return penalty;
    }

    public void setTargetShare(Long course, double targetShare) {
        this.iTargetShare.put(course, targetShare);
    }

    public double getTargetShare(Long course) {
        Double targetShare = this.iTargetShare.get(course);
        return targetShare == null ? 0.0 : targetShare;
    }

    public int hashCode() {
        return this.getCourseId().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CurCourse)) {
            return false;
        }
        return this.getCourseId().equals(((CurCourse)((Object)o)).getCourseId());
    }

    public String toString(Assignment<CurVariable, CurValue> assignment) {
        return "Course<" + this.getCourseName() + ", size: " + sDF.format(this.getSize(assignment)) + "/" + sDF.format(this.getOriginalMaxSize()) + ">";
    }

    public boolean isComplete(Assignment<CurVariable, CurValue> assignment) {
        return this.getSize(assignment) + this.iModel.getMinStudentWidth() > this.getMaxSize();
    }

    public Double getPriority() {
        return this.iPriority;
    }

    public CurCourseContext createAssignmentContext(Assignment<CurVariable, CurValue> assignment) {
        return new CurCourseContext(assignment);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CurCourseContext
    implements AssignmentConstraintContext<CurVariable, CurValue> {
        private Set<CurStudent> iStudents = new HashSet<CurStudent>();
        private double iSize = 0.0;

        public CurCourseContext(Assignment<CurVariable, CurValue> assignment) {
        }

        public void assigned(Assignment<CurVariable, CurValue> assignment, CurValue value) {
            this.iStudents.add(value.getStudent());
            value.getStudent().getCourses(assignment).add(CurCourse.this);
            this.iSize += value.getStudent().getWeight();
        }

        public void unassigned(Assignment<CurVariable, CurValue> assignment, CurValue value) {
            this.iStudents.remove((Object)value.getStudent());
            this.iSize -= value.getStudent().getWeight();
            value.getStudent().getCourses(assignment).remove((Object)CurCourse.this);
        }

        public Set<CurStudent> getStudents() {
            return this.iStudents;
        }

        public double getSize() {
            return this.iSize;
        }
    }
}

