/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.course.ui;

import java.io.Serializable;
import org.cpsolver.ifs.util.DistanceMetric;
import org.hibernate.Session;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.dao.LocationDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassRoomInfo
implements Serializable,
Comparable<ClassRoomInfo> {
    private static final long serialVersionUID = 210491037628622512L;
    private Long iId = null;
    private String iName = null;
    private int iPreference = 0;
    private int iCapacity;
    private Double iX = null;
    private Double iY = null;
    private boolean iIgnoreTooFar;
    private transient Location iLocation = null;
    private String iNote = null;
    private boolean iIgnoreRoomChecks;
    private static transient DistanceMetric sDistanceMetric = null;

    public ClassRoomInfo(Location location, int preference) {
        this.iLocation = location;
        this.iId = location.getUniqueId();
        this.iName = location.getLabel();
        this.iCapacity = location.getCapacity();
        this.iPreference = preference;
        this.iX = location.getCoordinateX();
        this.iY = location.getCoordinateY();
        this.iIgnoreTooFar = location.isIgnoreTooFar();
        this.iIgnoreRoomChecks = location.isIgnoreRoomCheck();
    }

    public ClassRoomInfo(Location location, int preference, String note) {
        this(location, preference);
        this.iNote = note;
    }

    public Long getLocationId() {
        return this.iId;
    }

    public String getName() {
        return this.iName;
    }

    public int getPreference() {
        return this.iPreference;
    }

    public void setPreference(int preference) {
        this.iPreference = preference;
    }

    public int getCapacity() {
        return this.iCapacity;
    }

    public boolean isIgnoreTooFar() {
        return this.iIgnoreTooFar;
    }

    public boolean hasNote() {
        return this.iNote != null;
    }

    public String getNote() {
        return this.iNote;
    }

    public Location getLocation() {
        if (this.iLocation == null) {
            this.iLocation = (Location)new LocationDAO().get(this.getLocationId());
        }
        return this.iLocation;
    }

    public Location getLocation(Session hibSession) {
        return (Location)new LocationDAO().get(this.getLocationId(), hibSession);
    }

    public String toString() {
        int pref = this.getPreference();
        boolean s = false;
        if (pref > 5000) {
            s = true;
            pref -= 5000;
        }
        return "<span style='color:" + PreferenceLevel.prolog2color(PreferenceLevel.int2prolog(pref)) + ";' " + "onmouseover=\"showGwtRoomHint(this, '" + this.iId + "', '" + PreferenceLevel.prolog2string(PreferenceLevel.int2prolog(pref)) + "'" + (this.hasNote() ? ", null, '" + this.getNote().replace("'", "\\'") + "'" : "") + ");\" onmouseout=\"hideGwtRoomHint();\">" + (s ? "<s>" : "") + this.getName() + (s ? "</s>" : "") + "</span>";
    }

    @Override
    public int compareTo(ClassRoomInfo room) {
        int cmp = -Double.compare(this.getCapacity(), room.getCapacity());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getName().compareTo(room.getName());
        if (cmp != 0) {
            return cmp;
        }
        return this.getLocationId().compareTo(room.getLocationId());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ClassRoomInfo)) {
            return false;
        }
        return this.getLocationId().equals(((ClassRoomInfo)o).getLocationId());
    }

    public int hashCode() {
        return this.getLocationId().hashCode();
    }

    public Double getCoordX() {
        return this.iX;
    }

    public Double getCoordY() {
        return this.iY;
    }

    public double getDistance(ClassRoomInfo other) {
        if (this.isIgnoreTooFar() || other.isIgnoreTooFar()) {
            return 0.0;
        }
        if (sDistanceMetric == null) {
            sDistanceMetric = new DistanceMetric(DistanceMetric.Ellipsoid.valueOf((String)ApplicationProperty.DistanceEllipsoid.value()));
        }
        return sDistanceMetric.getDistanceInMeters(this.getLocationId(), this.getCoordX(), this.getCoordY(), other.getLocationId(), other.getCoordX(), other.getCoordY());
    }

    public String getNameHtml() {
        return "<span onmouseover=\"showGwtRoomHint(this, '" + this.iId + "', '" + PreferenceLevel.int2string(this.getPreference()) + "'" + ");\" onmouseout=\"hideGwtRoomHint();\">" + this.getName() + "</span>";
    }

    public boolean isIgnoreRoomChecks() {
        return this.iIgnoreRoomChecks;
    }

    public void setIgnoreRoomChecks(boolean ignoreRoomChecks) {
        this.iIgnoreRoomChecks = ignoreRoomChecks;
    }
}

