/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.coursett.Test;
import org.cpsolver.coursett.TimetableSaver;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.StudentGroup;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.extension.ConflictStatistics;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.Progress;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Transaction;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.ExternalSolutionCommitAction;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.AssignmentInfo;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.ConstraintInfo;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolutionInfo;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SolverInfoDef;
import org.unitime.timetable.model.SolverParameter;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.StudentEnrollment;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.solver.ui.BtbInstructorConstraintInfo;
import org.unitime.timetable.solver.ui.ConflictStatisticsInfo;
import org.unitime.timetable.solver.ui.GroupConstraintInfo;
import org.unitime.timetable.solver.ui.JenrlInfo;
import org.unitime.timetable.solver.ui.LogInfo;
import org.unitime.timetable.solver.ui.PropertiesInfo;
import org.unitime.timetable.solver.ui.StudentGroupInfo;
import org.unitime.timetable.solver.ui.TimetableInfoFileProxy;
import org.unitime.timetable.solver.ui.TimetableInfoUtil;

public class TimetableDatabaseSaver
extends TimetableSaver {
    private static Log sLog = LogFactory.getLog(TimetableDatabaseSaver.class);
    private Long iSessionId;
    private Long[] iSolverGroupId;
    private Long[] iSolutionId;
    private boolean iCreateNew = true;
    private boolean iCommitSolution = false;
    private boolean iStudentSectioning = false;
    private Hashtable<Long, Assignment> iAssignments = new Hashtable();
    private Hashtable<Long, Solution> iSolutions = new Hashtable();
    private Progress iProgress = Progress.getInstance((Object)this.getModel());
    private static int BATCH_SIZE = 100;
    private boolean iUseAmPm = true;

    public TimetableDatabaseSaver(Solver solver) {
        super(solver);
        this.iSessionId = new Long(((TimetableModel)this.getModel()).getProperties().getPropertyLong("General.SessionId", -1L));
        this.iSolverGroupId = ((TimetableModel)this.getModel()).getProperties().getPropertyLongArry("General.SolverGroupId", null);
        this.iSolutionId = ((TimetableModel)this.getModel()).getProperties().getPropertyLongArry("General.SolutionId", null);
        this.iCreateNew = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.CreateNewSolution", this.iCreateNew);
        this.iCommitSolution = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.CommitSolution", this.iCommitSolution);
        this.iStudentSectioning = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.RunStudentSectioningOnSave", this.iStudentSectioning);
        this.iUseAmPm = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.UseAmPm", this.iUseAmPm);
    }

    public TimetableInfoFileProxy getFileProxy() {
        return TimetableInfoUtil.getInstance();
    }

    private Solution getSolution(Lecture lecture, org.hibernate.Session hibSession) {
        if (lecture.getSolverGroupId() != null) {
            return this.iSolutions.get(lecture.getSolverGroupId());
        }
        Class_ clazz = (Class_)new Class_DAO().get(lecture.getClassId(), hibSession);
        if (clazz == null) {
            return null;
        }
        SolverGroup sg = clazz.getManagingDept().getSolverGroup();
        if (sg == null) {
            return null;
        }
        return this.iSolutions.get(sg.getUniqueId());
    }

    public void refreshCourseSolution(Long solutionId) {
        if (SolverServerImplementation.getInstance() != null) {
            SolverServerImplementation.getInstance().refreshCourseSolution(solutionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() {
        ApplicationProperties.setSessionId(this.iSessionId);
        org.hibernate.Session hibSession = null;
        Transaction tx = null;
        try {
            try {
                int i;
                TimetableManagerDAO dao = new TimetableManagerDAO();
                hibSession = dao.getSession();
                hibSession.setCacheMode(CacheMode.IGNORE);
                hibSession.setFlushMode(FlushMode.COMMIT);
                tx = hibSession.beginTransaction();
                Object[] solutionIds = this.save(hibSession);
                tx.commit();
                HashSet<Long> refreshIds = new HashSet<Long>();
                if (this.iCommitSolution && solutionIds != null) {
                    Solution solution;
                    int i2;
                    HashSet<Solution> touchedSolutions = new HashSet<Solution>();
                    if (hibSession != null && hibSession.isOpen()) {
                        hibSession.close();
                    }
                    hibSession = dao.getSession();
                    this.setPhase("Committing solution ...", 2 * solutionIds.length);
                    tx = hibSession.beginTransaction();
                    for (i2 = 0; i2 < solutionIds.length; ++i2) {
                        solution = (Solution)new SolutionDAO().get(solutionIds[i2]);
                        Solution committedSolution = solution.getOwner().getCommittedSolution();
                        if (committedSolution != null) {
                            committedSolution.uncommitSolution(hibSession, ((TimetableModel)this.getModel()).getProperties().getProperty("General.OwnerPuid"));
                            refreshIds.add(committedSolution.getUniqueId());
                            touchedSolutions.add(committedSolution);
                        }
                        touchedSolutions.add(solution);
                        this.incProgress();
                    }
                    for (i2 = 0; i2 < solutionIds.length; ++i2) {
                        solution = (Solution)new SolutionDAO().get(solutionIds[i2]);
                        ArrayList<String> messages = new ArrayList<String>();
                        solution.commitSolution(messages, hibSession, ((TimetableModel)this.getModel()).getProperties().getProperty("General.OwnerPuid"));
                        touchedSolutions.add(solution);
                        for (String m : messages) {
                            this.iProgress.error("Unable to commit: " + m);
                        }
                        hibSession.update((Object)solution);
                        this.incProgress();
                    }
                    tx.commit();
                    String className = ApplicationProperty.ExternalActionSolutionCommit.value();
                    if (className != null && className.trim().length() > 0) {
                        ExternalSolutionCommitAction commitAction = (ExternalSolutionCommitAction)Class.forName(className).newInstance();
                        commitAction.performExternalSolutionCommitAction(touchedSolutions, hibSession);
                    }
                }
                this.setPhase("Refreshing solution ...", solutionIds.length + refreshIds.size());
                for (Long solutionId : refreshIds) {
                    this.refreshCourseSolution(solutionId);
                    this.incProgress();
                }
                for (i = 0; i < solutionIds.length; ++i) {
                    try {
                        this.refreshCourseSolution(solutionIds[i]);
                    }
                    catch (Exception e) {
                        this.iProgress.warn("Unable to refresh solution " + solutionIds[i] + ", reason:" + e.getMessage(), (Throwable)e);
                    }
                    this.incProgress();
                }
                if (solutionIds != null) {
                    ((TimetableModel)this.getModel()).getProperties().setProperty("General.SolutionId", solutionIds);
                    this.iProgress.info("Solution successfully saved.");
                    if (hibSession != null && hibSession.isOpen()) {
                        hibSession.close();
                    }
                    hibSession = dao.getSession();
                    for (i = 0; i < solutionIds.length; ++i) {
                        tx = hibSession.beginTransaction();
                        Solution solution = (Solution)new SolutionDAO().get(solutionIds[i]);
                        LogInfo lInfo = new LogInfo();
                        lInfo.setLog(this.iProgress.getLog());
                        SolutionInfo logInfo = new SolutionInfo();
                        logInfo.setDefinition(SolverInfoDef.findByName(hibSession, "LogInfo"));
                        logInfo.setOpt(null);
                        logInfo.setSolution(solution);
                        logInfo.setInfo(lInfo, this.getFileProxy());
                        hibSession.save((Object)logInfo);
                        tx.commit();
                    }
                }
                Object var13_16 = null;
                if (hibSession == null) return;
            }
            catch (Exception e) {
                this.iProgress.fatal("Unable to save timetable, reason: " + e.getMessage(), (Throwable)e);
                sLog.error((Object)e.getMessage(), (Throwable)e);
                tx.rollback();
                Object var13_17 = null;
                if (hibSession == null) return;
                if (!hibSession.isOpen()) return;
                hibSession.close();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            if (hibSession == null) throw throwable;
            if (!hibSession.isOpen()) throw throwable;
            hibSession.close();
            throw throwable;
        }
        if (!hibSession.isOpen()) return;
        hibSession.close();
    }

    private Long[] save(org.hibernate.Session hibSession) throws Exception {
        ConstraintInfo constraintInfo;
        Solution solution;
        List<Object> lectures;
        SolverInfoDef defGroupInfo;
        SolverInfoDef defBtbInstrInfo;
        SolverInfoDef defLogInfo;
        SolverInfoDef defJenrlInfo;
        SolverInfoDef defDistributionInfo;
        SolverInfoDef defAssignmentInfo;
        SolverInfoDef defCbsInfo;
        SolverInfoDef defGlobalInfo;
        Session session;
        int i;
        if (this.iStudentSectioning) {
            ((TimetableModel)this.getModel()).switchStudents(this.getAssignment(), this.getTerminationCondition());
        }
        this.iProgress.setStatus("Saving solution ...");
        if (this.iSolverGroupId == null || this.iSolverGroupId.length == 0) {
            this.iProgress.fatal("No solver group loaded.");
            return null;
        }
        Hashtable<Long, SolverGroup> solverGroups = new Hashtable<Long, SolverGroup>();
        for (i = 0; i < this.iSolverGroupId.length; ++i) {
            SolverGroup solverGroup = (SolverGroup)SolverGroupDAO.getInstance().get(this.iSolverGroupId[i], hibSession);
            if (solverGroup == null) {
                this.iProgress.fatal("Unable to load solver group " + this.iSolverGroupId[i] + ".");
                return null;
            }
            solverGroups.put(solverGroup.getUniqueId(), solverGroup);
            this.iProgress.debug("solver group [" + (i + 1) + "]: " + solverGroup.getName());
        }
        this.iSolutions = new Hashtable();
        if (!this.iCreateNew && this.iSolutionId != null && this.iSolutionId.length >= 0) {
            for (i = 0; i < this.iSolverGroupId.length; ++i) {
                if (i >= this.iSolutionId.length || this.iSolutionId[i] == null) continue;
                Solution solution2 = (Solution)new SolutionDAO().get(this.iSolutionId[i], hibSession);
                if (solution2 == null) {
                    this.iProgress.warn("Unable to load solution " + this.iSolutionId[i]);
                    continue;
                }
                if (!solverGroups.containsKey(solution2.getOwner().getUniqueId())) {
                    this.iProgress.warn("Solution " + this.iSolutionId[i] + " ignored -- it does not match with the owner(s) of the problem");
                    continue;
                }
                if (solution2.isCommited().booleanValue()) {
                    String className;
                    solution2.uncommitSolution(hibSession, ((TimetableModel)this.getModel()).getProperties().getProperty("General.OwnerPuid"));
                    if (!this.iCommitSolution && (className = ApplicationProperty.ExternalActionSolutionCommit.value()) != null && className.trim().length() > 0) {
                        HashSet<Solution> touchedSolutions = new HashSet<Solution>();
                        touchedSolutions.add(solution2);
                        ExternalSolutionCommitAction commitAction = (ExternalSolutionCommitAction)Class.forName(className).newInstance();
                        commitAction.performExternalSolutionCommitAction(touchedSolutions, hibSession);
                    }
                }
                solution2.empty(hibSession, this.getFileProxy());
                this.iSolutions.put(solution2.getOwner().getUniqueId(), solution2);
            }
        }
        if ((session = (Session)SessionDAO.getInstance().get(this.iSessionId, hibSession)) == null) {
            this.iProgress.fatal("No session loaded.");
            return null;
        }
        this.iProgress.debug("session: " + session.getLabel());
        Enumeration e = solverGroups.elements();
        while (e.hasMoreElements()) {
            SolverGroup solverGroup = (SolverGroup)e.nextElement();
            Solution solution3 = this.iSolutions.get(solverGroup.getUniqueId());
            if (solution3 == null) {
                solution3 = new Solution();
                this.iSolutions.put(solverGroup.getUniqueId(), solution3);
            }
            solution3.setCommitDate(null);
            solution3.setCreated(new Timestamp(new Date().getTime()));
            solution3.setCreator(Test.getVersionString());
            solution3.setNote(((TimetableModel)this.getModel()).getProperties().getProperty("General.Note"));
            solution3.setOwner(solverGroup);
            solverGroup.getSolutions().add(solution3);
            solution3.setValid(Boolean.TRUE);
            solution3.setCommited(Boolean.FALSE);
            this.setPhase("Saving solver parameters ...", ((TimetableModel)this.getModel()).getProperties().size());
            HashSet<SolverParameter> params = new HashSet<SolverParameter>();
            for (Map.Entry entry : ((TimetableModel)this.getModel()).getProperties().entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                SolverParameterDef def = SolverParameterDef.findByNameType(hibSession, name, SolverParameterGroup.SolverType.COURSE);
                if (def != null) {
                    this.iProgress.trace("save " + (String)name + "=" + value);
                    SolverParameter param = new SolverParameter();
                    param.setDefinition(def);
                    param.setValue(value);
                    hibSession.save((Object)param);
                    params.add(param);
                }
                this.incProgress();
            }
            solution3.setParameters(params);
            hibSession.saveOrUpdate((Object)solution3);
        }
        hibSession.flush();
        hibSession.clear();
        int batchIdx = 0;
        this.setPhase("Saving assignments ...", ((TimetableModel)this.getModel()).variables().size());
        for (Lecture lecture : ((TimetableModel)this.getModel()).variables()) {
            Placement placement = (Placement)this.getAssignment().getValue((Variable)lecture);
            if (placement != null) {
                Object r2;
                this.iProgress.trace("save " + lecture.getName() + " " + placement.getName());
                Class_ clazz = (Class_)new Class_DAO().get(lecture.getClassId(), hibSession);
                if (clazz == null) {
                    this.iProgress.warn("Unable to save assignment for class " + lecture + " (" + placement.getLongName(this.iUseAmPm) + ") -- class (id:" + lecture.getClassId() + ") does not exist.");
                    continue;
                }
                HashSet<Location> rooms = new HashSet<Location>();
                if (placement.isMultiRoom()) {
                    for (Object r2 : placement.getRoomLocations()) {
                        Location room = (Location)new LocationDAO().get(r2.getId(), hibSession);
                        if (room == null) {
                            this.iProgress.warn("Unable to save assignment for class " + lecture + " (" + placement.getLongName(this.iUseAmPm) + ") -- room (id:" + r2.getId() + ") does not exist.");
                            continue;
                        }
                        rooms.add(room);
                    }
                    if (rooms.size() != placement.getRoomLocations().size()) {
                        continue;
                    }
                } else {
                    Location room = (Location)new LocationDAO().get(placement.getRoomLocation().getId(), hibSession);
                    if (room == null) {
                        this.iProgress.warn("Unable to save assignment for class " + lecture + " (" + placement.getLongName(this.iUseAmPm) + ") -- room (id:" + placement.getRoomLocation().getId() + ") does not exist.");
                        continue;
                    }
                    rooms.add(room);
                }
                HashSet<DepartmentalInstructor> instructors = new HashSet<DepartmentalInstructor>();
                r2 = lecture.getInstructorConstraints().iterator();
                while (r2.hasNext()) {
                    InstructorConstraint ic = (InstructorConstraint)r2.next();
                    DepartmentalInstructor instructor = null;
                    if (ic.getPuid() != null && ic.getPuid().length() > 0) {
                        instructor = DepartmentalInstructor.findByPuidDepartmentId(ic.getPuid(), clazz.getControllingDept().getUniqueId());
                    } else if (ic.getResourceId() != null) {
                        instructor = (DepartmentalInstructor)new DepartmentalInstructorDAO().get(ic.getResourceId(), hibSession);
                    }
                    if (instructor == null) continue;
                    instructors.add(instructor);
                }
                TimePattern pattern = (TimePattern)new TimePatternDAO().get(placement.getTimeLocation().getTimePatternId(), hibSession);
                if (pattern == null) {
                    this.iProgress.warn("Unable to save assignment for class " + lecture + " (" + placement.getLongName(this.iUseAmPm) + ") -- time pattern (id:" + placement.getTimeLocation().getTimePatternId() + ") does not exist.");
                    continue;
                }
                Solution solution4 = this.getSolution(lecture, hibSession);
                if (solution4 == null) {
                    this.iProgress.warn("Unable to save assignment for class " + lecture + " (" + placement.getLongName(this.iUseAmPm) + ") -- none or wrong solution group assigned to the class");
                    continue;
                }
                Assignment assignment = new Assignment();
                assignment.setClazz(clazz);
                assignment.setClassId(clazz.getUniqueId());
                assignment.setClassName(lecture.getName());
                assignment.setDays(new Integer(placement.getTimeLocation().getDayCode()));
                assignment.setStartSlot(new Integer(placement.getTimeLocation().getStartSlot()));
                assignment.setTimePattern(pattern);
                if (placement.getTimeLocation().getDatePatternId() != null) {
                    assignment.setDatePattern((DatePattern)DatePatternDAO.getInstance().get(placement.getTimeLocation().getDatePatternId(), hibSession));
                }
                assignment.setRooms(rooms);
                assignment.setInstructors(instructors);
                assignment.setSolution(solution4);
                hibSession.save((Object)assignment);
                this.iAssignments.put(lecture.getClassId(), assignment);
                if (++batchIdx % BATCH_SIZE == 0) {
                    hibSession.flush();
                    hibSession.clear();
                }
            }
            this.incProgress();
        }
        hibSession.flush();
        hibSession.clear();
        batchIdx = 0;
        if (((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.SaveStudentEnrollments", true)) {
            this.setPhase("Saving student enrollments ...", ((TimetableModel)this.getModel()).variables().size());
            for (Lecture lecture : ((TimetableModel)this.getModel()).variables()) {
                Class_ clazz = (Class_)new Class_DAO().get(lecture.getClassId(), hibSession);
                if (clazz == null) continue;
                this.iProgress.trace("save " + lecture.getName());
                Solution solution5 = this.getSolution(lecture, hibSession);
                if (solution5 == null) {
                    this.iProgress.warn("Unable to save student enrollments for class " + lecture + "  -- none or wrong solution group assigned to the class");
                    continue;
                }
                for (Student student : lecture.students()) {
                    if (student.getId() < 0L) continue;
                    StudentEnrollment enrl = new StudentEnrollment();
                    enrl.setStudentId(student.getId());
                    enrl.setClazz(clazz);
                    enrl.setSolution(solution5);
                    hibSession.save((Object)enrl);
                    if (++batchIdx % BATCH_SIZE != 0) continue;
                    hibSession.flush();
                    hibSession.clear();
                }
                this.incProgress();
            }
            hibSession.flush();
            hibSession.clear();
            batchIdx = 0;
        }
        if ((defGlobalInfo = SolverInfoDef.findByName(hibSession, "GlobalInfo")) == null) {
            this.iProgress.warn("Global info is not registered.");
        }
        if ((defCbsInfo = SolverInfoDef.findByName(hibSession, "CBSInfo")) == null) {
            this.iProgress.warn("Constraint-based statistics info is not registered.");
        }
        if ((defAssignmentInfo = SolverInfoDef.findByName(hibSession, "AssignmentInfo")) == null) {
            this.iProgress.warn("Assignment info is not registered.");
        }
        if ((defDistributionInfo = SolverInfoDef.findByName(hibSession, "DistributionInfo")) == null) {
            this.iProgress.warn("Distribution constraint info is not registered.");
        }
        if ((defJenrlInfo = SolverInfoDef.findByName(hibSession, "JenrlInfo")) == null) {
            this.iProgress.warn("Joint enrollments info is not registered.");
        }
        if ((defLogInfo = SolverInfoDef.findByName(hibSession, "LogInfo")) == null) {
            this.iProgress.warn("Solver log info is not registered.");
        }
        if ((defBtbInstrInfo = SolverInfoDef.findByName(hibSession, "BtbInstructorInfo")) == null) {
            this.iProgress.warn("Back-to-back instructor info is not registered.");
        }
        if ((defGroupInfo = SolverInfoDef.findByName(hibSession, "GroupInfo")) == null) {
            this.iProgress.warn("Student group info is not registered.");
            defGroupInfo = new SolverInfoDef();
            defGroupInfo.setDescription("Student group information");
            defGroupInfo.setImplementation(StudentGroupInfo.class.getName());
            defGroupInfo.setName("GroupInfo");
            hibSession.save((Object)defGroupInfo);
        }
        Hashtable<Solution, ArrayList<Lecture>> lectures4solution = new Hashtable<Solution, ArrayList<Lecture>>();
        for (Lecture lecture : ((TimetableModel)this.getModel()).variables()) {
            Solution s = this.getSolution(lecture, hibSession);
            if (s == null) continue;
            lectures = (ArrayList<Lecture>)lectures4solution.get(s);
            if (lectures == null) {
                lectures = new ArrayList<Lecture>();
                lectures4solution.put(s, (ArrayList<Lecture>)lectures);
            }
            lectures.add(lecture);
        }
        this.setPhase("Saving global info ...", solverGroups.size());
        Enumeration e2 = solverGroups.elements();
        while (e2.hasMoreElements()) {
            SolverGroup solverGroup = (SolverGroup)e2.nextElement();
            solution = this.iSolutions.get(solverGroup.getUniqueId());
            lectures = (List)lectures4solution.get(solution);
            if (lectures == null) {
                lectures = new ArrayList(0);
            }
            SolutionInfo solutionInfo = new SolutionInfo();
            solutionInfo.setDefinition(defGlobalInfo);
            solutionInfo.setOpt(null);
            solutionInfo.setSolution(solution);
            solutionInfo.setInfo(new PropertiesInfo(this.getSolution().getInfo(lectures)), this.getFileProxy());
            hibSession.save((Object)solutionInfo);
            solution.setGlobalInfo(solutionInfo);
            this.incProgress();
        }
        hibSession.flush();
        hibSession.clear();
        batchIdx = 0;
        ConflictStatistics cbs = null;
        for (Extension ext : this.getSolver().getExtensions()) {
            if (!(ext instanceof ConflictStatistics)) continue;
            cbs = (ConflictStatistics)ext;
            break;
        }
        if (cbs != null && cbs.getNoGoods() != null) {
            Iterator cbsInfo = new ConflictStatisticsInfo();
            ((ConflictStatisticsInfo)((Object)cbsInfo)).load((Solver<Lecture, Placement>)this.getSolver(), cbs);
            this.setPhase("Saving conflict-based statistics ...", 1L);
            Enumeration<Solution> e3 = this.iSolutions.elements();
            while (e3.hasMoreElements()) {
                Solution solution6 = e3.nextElement();
                ArrayList lectures2 = (ArrayList)lectures4solution.get(solution6);
                if (lectures2 == null) {
                    lectures2 = new ArrayList(0);
                }
                SolutionInfo cbsSolutionInfo = new SolutionInfo();
                cbsSolutionInfo.setDefinition(defCbsInfo);
                cbsSolutionInfo.setOpt(null);
                cbsSolutionInfo.setSolution(solution6);
                cbsSolutionInfo.setInfo(((ConflictStatisticsInfo)((Object)cbsInfo)).getConflictStatisticsSubInfo(lectures2), this.getFileProxy());
                hibSession.save((Object)cbsSolutionInfo);
                if (++batchIdx % BATCH_SIZE != 0) continue;
                hibSession.flush();
                hibSession.clear();
            }
            this.incProgress();
        }
        hibSession.flush();
        hibSession.clear();
        batchIdx = 0;
        this.setPhase("Saving variable infos ...", ((TimetableModel)this.getModel()).variables().size());
        for (Lecture lecture : ((TimetableModel)this.getModel()).variables()) {
            Placement placement = (Placement)this.getAssignment().getValue((Variable)lecture);
            if (placement != null) {
                Assignment assignment = this.iAssignments.get(lecture.getClassId());
                AssignmentInfo assignmentInfo = new AssignmentInfo();
                assignmentInfo.setAssignment(assignment);
                assignmentInfo.setDefinition(defAssignmentInfo);
                assignmentInfo.setOpt(null);
                assignmentInfo.setInfo(new AssignmentPreferenceInfo(this.getSolver(), placement, true, true), this.getFileProxy());
                hibSession.save((Object)assignmentInfo);
                if (++batchIdx % BATCH_SIZE == 0) {
                    hibSession.flush();
                    hibSession.clear();
                }
            }
            this.incProgress();
        }
        hibSession.flush();
        hibSession.clear();
        batchIdx = 0;
        this.setPhase("Saving btb instructor infos ...", ((TimetableModel)this.getModel()).variables().size());
        for (Lecture lecture1 : ((TimetableModel)this.getModel()).variables()) {
            Placement placement1 = (Placement)this.getAssignment().getValue((Variable)lecture1);
            this.incProgress();
            if (placement1 == null) continue;
            for (InstructorConstraint ic : lecture1.getInstructorConstraints()) {
                for (Lecture lecture2 : ic.variables()) {
                    int pref;
                    Placement placement2 = (Placement)this.getAssignment().getValue((Variable)lecture2);
                    if (placement2 == null || lecture2.getClassId().compareTo(lecture1.getClassId()) <= 0 || (pref = ic.getDistancePreference(placement1, placement2)) == PreferenceLevel.sIntLevelNeutral) continue;
                    this.iProgress.trace("Back-to-back instructor constraint (" + pref + ") between " + placement1 + " and " + placement2);
                    BtbInstructorConstraintInfo biInfo = new BtbInstructorConstraintInfo();
                    biInfo.setPreference(pref);
                    biInfo.setInstructorId(ic.getResourceId());
                    ConstraintInfo constraintInfo2 = new ConstraintInfo();
                    constraintInfo2.setDefinition(defBtbInstrInfo);
                    constraintInfo2.setOpt(String.valueOf(ic.getResourceId()));
                    HashSet<Assignment> biAssignments = new HashSet<Assignment>();
                    Assignment assignment = this.iAssignments.get(lecture1.getClassId());
                    if (assignment != null) {
                        biAssignments.add(assignment);
                    }
                    if ((assignment = this.iAssignments.get(lecture2.getClassId())) != null) {
                        biAssignments.add(assignment);
                    }
                    if (!biAssignments.isEmpty()) {
                        constraintInfo2.setAssignments(biAssignments);
                        constraintInfo2.setInfo(biInfo, this.getFileProxy());
                        hibSession.save((Object)constraintInfo2);
                        if (++batchIdx % BATCH_SIZE != 0) continue;
                        hibSession.flush();
                        hibSession.clear();
                        continue;
                    }
                    this.iProgress.trace("   NO ASSIGNMENTS !!!");
                }
            }
        }
        hibSession.flush();
        hibSession.clear();
        batchIdx = 0;
        this.setPhase("Saving group constraint infos ...", ((TimetableModel)this.getModel()).getGroupConstraints().size());
        for (GroupConstraint gc : ((TimetableModel)this.getModel()).getGroupConstraints()) {
            GroupConstraintInfo gcInfo = new GroupConstraintInfo((org.cpsolver.ifs.assignment.Assignment<Lecture, Placement>)this.getAssignment(), gc);
            constraintInfo = new ConstraintInfo();
            constraintInfo.setDefinition(defDistributionInfo);
            constraintInfo.setOpt(gcInfo.isSatisfied() ? "1" : "0");
            this.iProgress.trace("Distribution constraint " + gcInfo.getName() + " (p:" + gcInfo.getPreference() + ", s:" + gcInfo.isSatisfied() + ") between");
            HashSet<Assignment> gcAssignments = new HashSet<Assignment>();
            for (Lecture lecture : gc.variables()) {
                Assignment assignment = this.iAssignments.get(lecture.getClassId());
                this.iProgress.trace("  " + this.getAssignment().getValue((Variable)lecture));
                if (assignment == null) continue;
                gcAssignments.add(assignment);
            }
            if (!gcAssignments.isEmpty()) {
                constraintInfo.setAssignments(gcAssignments);
                constraintInfo.setInfo(gcInfo, this.getFileProxy());
                hibSession.save((Object)constraintInfo);
                if (++batchIdx % BATCH_SIZE == 0) {
                    hibSession.flush();
                    hibSession.clear();
                }
            } else {
                this.iProgress.trace("   NO ASSIGNMENTS !!!");
            }
            this.incProgress();
        }
        hibSession.flush();
        hibSession.clear();
        batchIdx = 0;
        this.setPhase("Saving student enrollment infos ...", ((TimetableModel)this.getModel()).getJenrlConstraints().size());
        for (JenrlConstraint jc : ((TimetableModel)this.getModel()).getJenrlConstraints()) {
            if (!jc.isInConflict(this.getAssignment()) || !jc.isOfTheSameProblem()) {
                this.incProgress();
                continue;
            }
            JenrlInfo jInfo = new JenrlInfo(this.getSolver(), jc);
            constraintInfo = new ConstraintInfo();
            constraintInfo.setDefinition(defJenrlInfo);
            constraintInfo.setOpt((jInfo.isSatisfied() ? "S" : "") + (jInfo.isHard() ? "H" : "") + (jInfo.isDistance() ? "D" : "") + (jInfo.isFixed() ? "F" : "") + (jInfo.isImportant() ? "I" : "") + (jInfo.isInstructor() ? "X" : ""));
            Assignment firstAssignment = this.iAssignments.get(((Lecture)jc.first()).getClassId());
            Assignment secondAssignment = this.iAssignments.get(((Lecture)jc.second()).getClassId());
            if (firstAssignment == null || secondAssignment == null) continue;
            HashSet<Assignment> jAssignments = new HashSet<Assignment>();
            jAssignments.add(firstAssignment);
            jAssignments.add(secondAssignment);
            constraintInfo.setAssignments(jAssignments);
            constraintInfo.setInfo(jInfo, this.getFileProxy());
            hibSession.save((Object)constraintInfo);
            if (++batchIdx % BATCH_SIZE == 0) {
                hibSession.flush();
                hibSession.clear();
            }
            this.incProgress();
        }
        this.setPhase("Saving student group infos ...", ((TimetableModel)this.getModel()).getStudentGroups().size());
        for (StudentGroup group : ((TimetableModel)this.getModel()).getStudentGroups()) {
            StudentGroupInfo gInfo = new StudentGroupInfo((Solver<Lecture, Placement>)this.getSolver(), group);
            constraintInfo = new ConstraintInfo();
            constraintInfo.setDefinition(defGroupInfo);
            constraintInfo.setOpt(gInfo.getGroupName());
            HashSet<Assignment> jAssignments = new HashSet<Assignment>();
            for (StudentGroupInfo.ClassInfo clazz : gInfo.getGroupAssignments()) {
                Assignment a = this.iAssignments.get(clazz.getClassId());
                if (a == null) continue;
                jAssignments.add(a);
            }
            if (jAssignments.isEmpty()) continue;
            constraintInfo.setAssignments(jAssignments);
            constraintInfo.setInfo(gInfo, this.getFileProxy());
            hibSession.save((Object)constraintInfo);
            if (++batchIdx % BATCH_SIZE == 0) {
                hibSession.flush();
                hibSession.clear();
            }
            this.incProgress();
        }
        hibSession.flush();
        hibSession.clear();
        batchIdx = 0;
        this.setPhase("Saving committed student enrollment infos ...", this.iSolutions.size());
        Enumeration<Solution> e4 = this.iSolutions.elements();
        while (e4.hasMoreElements()) {
            solution = e4.nextElement();
            solution.updateCommittedStudentEnrollmentInfos(hibSession);
            this.incProgress();
        }
        this.incProgress();
        hibSession.flush();
        hibSession.clear();
        batchIdx = 0;
        this.setPhase("Done", 1L);
        this.incProgress();
        Long[] ret = new Long[this.iSolutions.size()];
        int idx = 0;
        Enumeration<Solution> e5 = this.iSolutions.elements();
        while (e5.hasMoreElements()) {
            ret[idx++] = e5.nextElement().getUniqueId();
        }
        return ret;
    }

    protected void checkTermination() {
        if (this.getTerminationCondition() != null && !this.getTerminationCondition().canContinue(this.getSolution())) {
            throw new RuntimeException("The save was interrupted.");
        }
    }

    protected void setPhase(String phase, long progressMax) {
        this.checkTermination();
        this.iProgress.setPhase(phase, progressMax);
    }

    protected void incProgress() {
        this.checkTermination();
        this.iProgress.incProgress();
    }
}

