/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.script;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringEscapeUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.Email;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.ScriptInterface;
import org.unitime.timetable.model.Script;
import org.unitime.timetable.model.ScriptParameter;
import org.unitime.timetable.model.dao.BuildingDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.RoomDAO;
import org.unitime.timetable.model.dao.ScriptDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.queue.QueueItem;

public class ScriptExecution
extends QueueItem {
    private ScriptInterface.ExecuteScriptRpcRequest iRequest;
    private double iProgress = 0.0;
    private double iMaxProgress = 100.0;
    private FileItem iFile = null;

    public ScriptExecution(ScriptInterface.ExecuteScriptRpcRequest request, SessionContext context) {
        super(context.getUser());
        this.iRequest = request;
        Script script = (Script)ScriptDAO.getInstance().get(request.getScriptId());
        if (script.getPermission() != null) {
            context.checkPermission(Right.valueOf(script.getPermission().replace(" ", "")));
        }
        for (ScriptParameter parameter : script.getParameters()) {
            if (!"file".equals(parameter.getType())) continue;
            this.iFile = (FileItem)context.getAttribute("LAST_FILE");
        }
    }

    public ScriptInterface.ExecuteScriptRpcRequest getRequest() {
        return this.iRequest;
    }

    public String type() {
        return "Script";
    }

    public String name() {
        return this.iRequest.getScriptName();
    }

    public double progress() {
        return this.iProgress / this.iMaxProgress;
    }

    public void setStatus(String status, double maxProgress) {
        this.iProgress = 0.0;
        this.iMaxProgress = maxProgress;
        super.setStatus(status);
    }

    public void incProgress() {
        this.iProgress += 1.0;
    }

    public void incProgress(double value) {
        this.iProgress += value;
    }

    public void setProgress(double value) {
        this.iProgress = value;
    }

    public void debug(String message) {
        this.log("&nbsp;&nbsp;<i><font color='gray'> " + StringEscapeUtils.escapeHtml((String)message) + "</font></i>");
    }

    public void info(String message) {
        this.log("&nbsp;&nbsp;" + StringEscapeUtils.escapeHtml((String)message));
    }

    public void warn(String message) {
        super.warn(message);
    }

    public void error(String message) {
        super.error(message);
    }

    public void error(String message, Throwable t) {
        super.error(message);
        this.logStackTrace(t);
        this.setError(t);
    }

    public File createOutput(String prefix, String ext) {
        return super.createOutput(prefix, ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute() throws Exception {
        Session hibSession = ScriptDAO.getInstance().getSession();
        Transaction tx = hibSession.beginTransaction();
        try {
            try {
                this.setStatus(MSG.scriptStatusStartingUp(), 3.0);
                Script script = (Script)ScriptDAO.getInstance().get(this.iRequest.getScriptId(), hibSession);
                ScriptEngineManager manager = new ScriptEngineManager();
                ScriptEngine engine = manager.getEngineByName(script.getEngine());
                engine.put("hibSession", hibSession);
                engine.put("session", SessionDAO.getInstance().get(this.getSessionId()));
                engine.put("log", this);
                this.incProgress();
                engine.getContext().setWriter(new Writer(){

                    public void write(char[] cbuf, int off, int len) throws IOException {
                        String line = String.valueOf(cbuf, off, len);
                        if (line.endsWith("\n")) {
                            line = line.substring(0, line.length() - 1);
                        }
                        if (!line.isEmpty()) {
                            ScriptExecution.this.info(line);
                        }
                    }

                    public void flush() throws IOException {
                    }

                    public void close() throws IOException {
                    }
                });
                engine.getContext().setErrorWriter(new Writer(){

                    public void write(char[] cbuf, int off, int len) throws IOException {
                        String line = String.valueOf(cbuf, off, len);
                        if (line.endsWith("\n")) {
                            line = line.substring(0, line.length() - 1);
                        }
                        if (!line.isEmpty()) {
                            ScriptExecution.this.warn(line);
                        }
                    }

                    public void flush() throws IOException {
                    }

                    public void close() throws IOException {
                    }
                });
                this.incProgress();
                this.debug("Engine: " + engine.getFactory().getEngineName() + " (ver. " + engine.getFactory().getEngineVersion() + ")");
                this.debug("Language: " + engine.getFactory().getLanguageName() + " (ver. " + engine.getFactory().getLanguageVersion() + ")");
                for (ScriptParameter parameter : script.getParameters()) {
                    String value = this.iRequest.getParameters().get(parameter.getName());
                    if ("file".equals(parameter.getType()) && this.iFile != null) {
                        this.debug(parameter.getName() + ": " + this.iFile.getName() + " (" + this.iFile.getSize() + " bytes)");
                        engine.put(parameter.getName(), this.iFile);
                        continue;
                    }
                    if (value == null) {
                        value = parameter.getDefaultValue();
                    }
                    if (value == null) {
                        engine.put(parameter.getName(), null);
                        continue;
                    }
                    this.debug(parameter.getName() + ": " + value);
                    if (parameter.getType().equalsIgnoreCase("boolean")) {
                        engine.put(parameter.getName(), "true".equalsIgnoreCase(value));
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("long")) {
                        engine.put(parameter.getName(), value == null || value.isEmpty() ? null : Long.valueOf(value));
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("int") || parameter.getType().equalsIgnoreCase("integer")) {
                        engine.put(parameter.getName(), value == null || value.isEmpty() ? null : Integer.valueOf(value));
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("double")) {
                        engine.put(parameter.getName(), value == null || value.isEmpty() ? null : Double.valueOf(value));
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("float")) {
                        engine.put(parameter.getName(), value == null || value.isEmpty() ? null : Float.valueOf(value));
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("short")) {
                        engine.put(parameter.getName(), value == null || value.isEmpty() ? null : Short.valueOf(value));
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("byte")) {
                        engine.put(parameter.getName(), value == null || value.isEmpty() ? null : Byte.valueOf(value));
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("date")) {
                        Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EVENT);
                        engine.put(parameter.getName(), dateFormat.parse(value));
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("department")) {
                        engine.put(parameter.getName(), DepartmentDAO.getInstance().get(Long.valueOf(value), hibSession));
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("departments")) {
                        ArrayList departments = new ArrayList();
                        for (String id : value.split(",")) {
                            if (id.isEmpty()) continue;
                            departments.add(DepartmentDAO.getInstance().get(Long.valueOf(id), hibSession));
                        }
                        engine.put(parameter.getName(), departments);
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("subject")) {
                        engine.put(parameter.getName(), SubjectAreaDAO.getInstance().get(Long.valueOf(value), hibSession));
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("subjects")) {
                        ArrayList subjects = new ArrayList();
                        for (String id : value.split(",")) {
                            if (id.isEmpty()) continue;
                            subjects.add(SubjectAreaDAO.getInstance().get(Long.valueOf(id), hibSession));
                        }
                        engine.put(parameter.getName(), subjects);
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("building")) {
                        engine.put(parameter.getName(), BuildingDAO.getInstance().get(Long.valueOf(value), hibSession));
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("buildings")) {
                        ArrayList buildings = new ArrayList();
                        for (String id : value.split(",")) {
                            if (id.isEmpty()) continue;
                            buildings.add(BuildingDAO.getInstance().get(Long.valueOf(id), hibSession));
                        }
                        engine.put(parameter.getName(), buildings);
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("room")) {
                        engine.put(parameter.getName(), RoomDAO.getInstance().get(Long.valueOf(value), hibSession));
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("rooms")) {
                        ArrayList rooms = new ArrayList();
                        for (String id : value.split(",")) {
                            if (id.isEmpty()) continue;
                            rooms.add(RoomDAO.getInstance().get(Long.valueOf(id), hibSession));
                        }
                        engine.put(parameter.getName(), rooms);
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("location")) {
                        engine.put(parameter.getName(), LocationDAO.getInstance().get(Long.valueOf(value), hibSession));
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("locations")) {
                        ArrayList locations = new ArrayList();
                        for (String id : value.split(",")) {
                            if (id.isEmpty()) continue;
                            locations.add(LocationDAO.getInstance().get(Long.valueOf(id), hibSession));
                        }
                        engine.put(parameter.getName(), locations);
                        continue;
                    }
                    engine.put(parameter.getName(), value);
                }
                this.incProgress();
                if (engine instanceof Compilable) {
                    this.setStatus(MSG.scriptStatusCompiling(), 1.0);
                    CompiledScript compiled = ((Compilable)((Object)engine)).compile(script.getScript());
                    this.incProgress();
                    this.setStatus(MSG.scriptStatusRunning(), 100.0);
                    compiled.eval();
                } else {
                    this.setStatus(MSG.scriptStatusRunning(), 100.0);
                    engine.eval(script.getScript());
                }
                hibSession.flush();
                tx.commit();
                this.setStatus(MSG.scriptStatusAllDone(), 1.0);
                this.incProgress();
            }
            catch (Exception e) {
                tx.rollback();
                this.error(MSG.failedExecution(e.getMessage()), (Throwable)e);
                Object var15_16 = null;
                hibSession.close();
                return;
            }
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            hibSession.close();
            throw throwable;
        }
        hibSession.close();
    }

    public void executeItem() {
        super.executeItem();
        this.sendEmail();
    }

    protected boolean sendEmail() {
        block7: {
            if (!this.getRequest().hasEmail()) {
                return false;
            }
            try {
                Email email = Email.createEmail();
                String suffix = ApplicationProperty.EmailDefaultAddressSuffix.value();
                for (String address : this.getRequest().getEmail().split("[\n,]")) {
                    if (address.trim().isEmpty()) continue;
                    if (suffix != null && address.indexOf(64) < 0) {
                        email.addRecipientCC(address.trim() + suffix, null);
                        continue;
                    }
                    email.addRecipientCC(address.trim(), null);
                }
                email.setHTML(this.log());
                if (this.hasOutput()) {
                    email.addAttachment(this.output(), this.output().getName());
                }
                if (this.hasOwnerEmail()) {
                    email.setReplyTo(this.getOwnerEmail(), this.getOwnerName());
                }
                email.setSubject(this.name() + (this.hasError() ? " -- " + this.error().getMessage() : ""));
                email.send();
            }
            catch (Exception e) {
                Throwable t = this.error();
                this.error(MSG.failedEmail(e.getMessage()), (Throwable)e);
                if (t == null) break block7;
                this.setError(t);
            }
        }
        return true;
    }
}

