/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.unitime.timetable.model.LocationPicture;
import org.unitime.timetable.model.dao.LocationPictureDAO;

public class RoomPictureServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String TEMP_ROOM_PICTURES = "ROOM_PICTURES";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String idStr = request.getParameter("id");
        if (idStr != null) {
            Long id = Long.valueOf(idStr);
            LocationPicture picture = null;
            if (id >= 0L) {
                picture = (LocationPicture)LocationPictureDAO.getInstance().get(id);
            } else {
                Map temp = (Map)request.getSession().getAttribute(TEMP_ROOM_PICTURES);
                if (temp != null) {
                    picture = (LocationPicture)temp.get(id);
                }
            }
            if (picture != null) {
                response.setContentType(picture.getContentType());
                response.setHeader("Content-Disposition", "attachment; filename=\"" + picture.getFileName() + "\"");
                ServletOutputStream out = response.getOutputStream();
                out.write(picture.getDataFile());
                out.flush();
            } else {
                new ServletException("Room picture of the given id does not exist.");
            }
        }
        new ServletException("No room picture id provided.");
    }
}

