/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.context;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.ManagerRole;
import org.unitime.timetable.model.ManagerSettings;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Settings;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.UserData;
import org.unitime.timetable.model.base.BaseDepartmentalInstructor;
import org.unitime.timetable.model.base.BaseManagerSettings;
import org.unitime.timetable.model.base.BasePreferenceGroup;
import org.unitime.timetable.model.base.BaseRoles;
import org.unitime.timetable.model.base.BaseSession;
import org.unitime.timetable.model.base.BaseSettings;
import org.unitime.timetable.model.base.BaseStudent;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.model.dao.UserDataDAO;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.authority.RoleAuthority;
import org.unitime.timetable.security.context.AbstractUserContext;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.HasRights;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LoginManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniTimeUserContext
extends AbstractUserContext {
    private static final long serialVersionUID = 1L;
    private String iId;
    private String iPassword;
    private String iName;
    private String iLogin;
    private String iEmail;

    public UniTimeUserContext(String userId, String login, String name, String password) {
        this(userId, login, name, password, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UniTimeUserContext(String userId, String login, String name, String password, Long sessionId) {
        this.iLogin = login;
        this.iPassword = password;
        this.iId = userId;
        this.iName = name;
        org.hibernate.Session hibSession = TimetableManagerDAO.getInstance().createNewSession();
        try {
            List<? extends UserAuthority> authorities;
            Session session;
            Roles noRole;
            List<? extends UserAuthority> authorities2;
            List<? extends UserAuthority> authorities22;
            Session session2;
            Roles studentRole;
            RoleAuthority authority;
            TimetableManager manager;
            String lastSessionId;
            for (UserData data : hibSession.createQuery("from UserData where externalUniqueId = :id").setString("id", userId).list()) {
                this.getProperties().put(data.getName(), data.getValue());
            }
            for (Serializable setting : hibSession.createQuery("from Settings").list()) {
                if (((BaseSettings)setting).getDefaultValue() == null) continue;
                this.getProperties().put(((BaseSettings)setting).getKey(), ((BaseSettings)setting).getDefaultValue());
            }
            for (Serializable setting : hibSession.createQuery("from ManagerSettings where manager.externalUniqueId = :id").setString("id", userId).list()) {
                if (((BaseManagerSettings)setting).getValue() == null) continue;
                this.getProperties().put(((BaseManagerSettings)setting).getKey().getKey(), ((BaseManagerSettings)setting).getValue());
            }
            if (sessionId == null && ApplicationProperty.KeepLastUsedAcademicSession.isTrue() && (lastSessionId = this.getProperty(UserProperty.LastAcademicSession)) != null) {
                sessionId = Long.valueOf(lastSessionId);
            }
            if ((manager = (TimetableManager)hibSession.createQuery("from TimetableManager where externalUniqueId = :id").setString("id", userId).setMaxResults(1).uniqueResult()) != null) {
                Object authorities3;
                Session session3;
                this.iName = manager.getName();
                this.iEmail = manager.getEmailAddress();
                BaseRoles primary = null;
                TreeSet<Object> primarySessions = null;
                for (ManagerRole role : manager.getManagerRoles()) {
                    if (!role.getRole().isEnabled().booleanValue()) continue;
                    TreeSet<Object> sessions = new TreeSet<Object>();
                    if (role.getRole().hasRight(Right.SessionIndependent) || sessions.isEmpty() && role.getRole().hasRight(Right.SessionIndependentIfNoSessionGiven)) {
                        sessions.addAll(SessionDAO.getInstance().findAll(hibSession));
                    } else {
                        for (Department department : manager.getDepartments()) {
                            sessions.add(department.getSession());
                        }
                    }
                    if (role.isPrimary().booleanValue() && primary == null) {
                        primary = role.getRole();
                        primarySessions = sessions;
                    }
                    for (Session session4 : sessions) {
                        if ((session4.getStatusType() == null || session4.getStatusType().isTestSession()) && !role.getRole().hasRight(Right.AllowTestSessions)) continue;
                        RoleAuthority authority2 = new RoleAuthority(manager.getUniqueId(), role.getRole());
                        authority2.addQualifier(session4);
                        authority2.addQualifier(manager);
                        for (Department department : manager.getDepartments()) {
                            if (!department.getSession().equals(session4)) continue;
                            authority2.addQualifier(department);
                        }
                        block9: for (SolverGroup group : manager.getSolverGroups()) {
                            for (Department department : group.getDepartments()) {
                                if (!department.getSession().equals(session4)) continue;
                                authority2.addQualifier(group);
                                continue block9;
                            }
                        }
                        this.addAuthority(authority2);
                    }
                }
                if (sessionId == null && primary != null && (session3 = UniTimeUserContext.defaultSession(primarySessions, (HasRights)((Object)primary), this.getProperty(UserProperty.PrimaryCampus.key()))) != null) {
                    sessionId = session3.getUniqueId();
                }
                if (sessionId != null && primary != null && !(authorities3 = this.getAuthorities(primary.getReference(), new SimpleQualifier("Session", sessionId))).isEmpty()) {
                    this.setCurrentAuthority((UserAuthority)authorities3.get(0));
                }
            }
            TreeSet<Session> sessions = new TreeSet<Session>();
            Roles instructorRole = Roles.getRole("Instructor", hibSession);
            if (instructorRole != null && instructorRole.isEnabled().booleanValue()) {
                for (Object instructor : hibSession.createQuery("from DepartmentalInstructor where externalUniqueId = :id").setString("id", userId).list()) {
                    UserAuthority instrRoleAuthority;
                    List<? extends UserAuthority> authorities4;
                    if (this.iName == null) {
                        this.iName = ((DepartmentalInstructor)instructor).getName(DepartmentalInstructor.sNameFormatLastFirstMiddle);
                    }
                    if (this.iEmail == null) {
                        this.iEmail = ((BaseDepartmentalInstructor)instructor).getEmail();
                    }
                    UserAuthority userAuthority = authority = (authorities4 = this.getAuthorities("Instructor", ((BaseDepartmentalInstructor)instructor).getDepartment().getSession())).isEmpty() ? null : authorities4.get(0);
                    if (authority == null) {
                        authority = new RoleAuthority(((BasePreferenceGroup)instructor).getUniqueId(), instructorRole);
                        authority.addQualifier(((BaseDepartmentalInstructor)instructor).getDepartment().getSession());
                        this.addAuthority(authority);
                        sessions.add(((BaseDepartmentalInstructor)instructor).getDepartment().getSession());
                    }
                    authority.addQualifier(((BaseDepartmentalInstructor)instructor).getDepartment());
                    if (((BaseDepartmentalInstructor)instructor).getRole() == null) continue;
                    List<? extends UserAuthority> list = this.getAuthorities(((BaseDepartmentalInstructor)instructor).getRole().getReference(), ((BaseDepartmentalInstructor)instructor).getDepartment().getSession());
                    UserAuthority userAuthority2 = instrRoleAuthority = list.isEmpty() ? null : list.get(0);
                    if (instrRoleAuthority == null) {
                        instrRoleAuthority = new RoleAuthority(((BasePreferenceGroup)instructor).getUniqueId(), ((BaseDepartmentalInstructor)instructor).getRole());
                        instrRoleAuthority.addQualifier(((BaseDepartmentalInstructor)instructor).getDepartment().getSession());
                        this.addAuthority(instrRoleAuthority);
                    }
                    instrRoleAuthority.addQualifier(((BaseDepartmentalInstructor)instructor).getDepartment());
                    instrRoleAuthority.addQualifier(new SimpleQualifier("Role", (Serializable)((Object)"Instructor")));
                }
            }
            if ((studentRole = Roles.getRole("Student", hibSession)) != null && studentRole.isEnabled().booleanValue()) {
                for (Object student : hibSession.createQuery("from Student where externalUniqueId = :id").setString("id", userId).list()) {
                    if (this.iName == null) {
                        this.iName = ((Student)student).getName(DepartmentalInstructor.sNameFormatLastFirstMiddle);
                    }
                    if (this.iEmail == null) {
                        this.iEmail = ((BaseStudent)student).getEmail();
                    }
                    authority = new RoleAuthority(((BaseStudent)student).getUniqueId(), studentRole);
                    authority.addQualifier(((BaseStudent)student).getSession());
                    this.addAuthority(authority);
                    sessions.add(((BaseStudent)student).getSession());
                }
            }
            if (sessionId == null && (session2 = UniTimeUserContext.defaultSession(sessions, null, this.getProperty(UserProperty.PrimaryCampus.key()))) != null) {
                sessionId = session2.getUniqueId();
            }
            if (this.getCurrentAuthority() == null && sessionId != null && !(authorities22 = this.getAuthorities("Instructor", new SimpleQualifier("Session", sessionId))).isEmpty()) {
                this.setCurrentAuthority(authorities22.get(0));
            }
            if (this.getCurrentAuthority() == null && sessionId != null && !(authorities2 = this.getAuthorities("Student", new SimpleQualifier("Session", sessionId))).isEmpty()) {
                this.setCurrentAuthority(authorities2.get(0));
            }
            if ((noRole = Roles.getRole("No Role", hibSession)) != null && noRole.isEnabled().booleanValue()) {
                for (Session session5 : new TreeSet(SessionDAO.getInstance().findAll(hibSession))) {
                    List<? extends UserAuthority> list;
                    if (session5.getStatusType() == null || !session5.getStatusType().isAllowNoRole() || session5.getStatusType().isTestSession() || !(list = this.getAuthorities(null, new SimpleQualifier("Session", session5.getUniqueId()))).isEmpty()) continue;
                    RoleAuthority authority2 = new RoleAuthority(-1L, noRole);
                    authority2.addQualifier(session5);
                    this.addAuthority(authority2);
                    sessions.add(session5);
                }
            }
            if (this.getCurrentAuthority() == null && (session = UniTimeUserContext.defaultSession(sessions, null, this.getProperty(UserProperty.PrimaryCampus.key()))) != null && !(authorities = this.getAuthorities(null, new SimpleQualifier("Session", session.getUniqueId()))).isEmpty()) {
                this.setCurrentAuthority(authorities.get(0));
            }
            Object var21_26 = null;
        }
        catch (Throwable throwable) {
            Object var21_27 = null;
            hibSession.close();
            throw throwable;
        }
        hibSession.close();
        if (this.iName == null) {
            this.iName = this.iLogin;
        }
    }

    public static Session defaultSession(TreeSet<Session> sessions, HasRights role, String primaryCampus) {
        if (sessions == null || sessions.isEmpty()) {
            return null;
        }
        String initiative = null;
        Session lastActive = null;
        BaseSession currentActive = null;
        Session firstFutureSession = null;
        boolean multipleInitiatives = false;
        Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Integer shift = ApplicationProperty.SessionDefaultShiftDays.intValue();
        if (shift != null && shift != 0) {
            cal.add(6, shift);
        }
        Date today = cal.getTime();
        for (Session session : sessions) {
            if (session.getStatusType() == null || !session.getStatusType().isActive() || session.getStatusType().isTestSession()) continue;
            if (initiative == null) {
                initiative = session.getAcademicInitiative();
            } else if (!initiative.equals(session.getAcademicInitiative())) {
                if (initiative.equals(primaryCampus)) continue;
                if (session.getAcademicInitiative().equals(primaryCampus)) {
                    initiative = session.getAcademicInitiative();
                    currentActive = null;
                    firstFutureSession = null;
                    lastActive = null;
                } else {
                    multipleInitiatives = true;
                    currentActive = null;
                    firstFutureSession = null;
                    lastActive = null;
                    continue;
                }
            }
            Date begin = session.getEventBeginDate();
            cal.setTime(session.getEventEndDate());
            cal.add(6, 1);
            Date end = cal.getTime();
            if (currentActive == null && !begin.after(today) && today.before(end)) {
                currentActive = session;
            }
            if (currentActive != null && firstFutureSession == null && !currentActive.equals(session)) {
                firstFutureSession = session;
            }
            if (currentActive == null && firstFutureSession == null && today.before(begin)) {
                firstFutureSession = session;
            }
            lastActive = session;
        }
        if (multipleInitiatives && lastActive == null) {
            return null;
        }
        if (role != null && role.hasRight(Right.SessionDefaultFirstFuture)) {
            if (firstFutureSession != null) {
                return firstFutureSession;
            }
            if (currentActive != null) {
                return currentActive;
            }
        }
        if (role != null && role.hasRight(Right.SessionDefaultFirstExamination)) {
            if (currentActive != null && !currentActive.getStatusType().canNoRoleReportExamFinal()) {
                return currentActive;
            }
            if (firstFutureSession != null) {
                return firstFutureSession;
            }
        }
        if (currentActive != null) {
            return currentActive;
        }
        if (firstFutureSession != null) {
            return firstFutureSession;
        }
        if (lastActive != null) {
            return lastActive;
        }
        Session lastNoTest = null;
        for (Session session : sessions) {
            if (session.getStatusType() == null || session.getStatusType().isTestSession()) continue;
            Date begin = session.getEventBeginDate();
            if (!begin.after(today)) {
                return session;
            }
            lastNoTest = session;
        }
        return lastNoTest;
    }

    public static Session defaultSession(TreeSet<Session> sessions, HasRights role) {
        return UniTimeUserContext.defaultSession(sessions, role, null);
    }

    @Override
    public void setCurrentAuthority(UserAuthority authority) {
        super.setCurrentAuthority(authority);
        if (authority.getAcademicSession() != null) {
            this.setProperty(UserProperty.LastAcademicSession, authority.getAcademicSession().getQualifierId().toString());
        }
    }

    @Override
    public String getExternalUserId() {
        return this.iId;
    }

    @Override
    public String getName() {
        return this.iName;
    }

    @Override
    public String getEmail() {
        return this.iEmail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setProperty(String key, String value) {
        org.hibernate.Session hibSession;
        block21: {
            block20: {
                block19: {
                    block17: {
                        block16: {
                            if (value != null && value.isEmpty()) {
                                value = null;
                            }
                            super.setProperty(key, value);
                            if (this.getExternalUserId() == null) return;
                            if (this.getExternalUserId().isEmpty()) {
                                return;
                            }
                            hibSession = UserDataDAO.getInstance().createNewSession();
                            try {
                                Settings settings = (Settings)hibSession.createQuery("from Settings where key = :key").setString("key", key).setCacheable(true).setMaxResults(1).uniqueResult();
                                if (settings != null && this.getCurrentAuthority() != null && !this.getCurrentAuthority().getQualifiers("TimetableManager").isEmpty()) {
                                    ManagerSettings managerData = (ManagerSettings)hibSession.createQuery("from ManagerSettings where key.key = :key and manager.externalUniqueId = :id").setString("key", key).setString("id", this.getExternalUserId()).setCacheable(true).setMaxResults(1).uniqueResult();
                                    if (value == null && managerData == null) {
                                        Object var7_7 = null;
                                        break block16;
                                    }
                                    if (value != null && managerData != null && value.equals(managerData.getValue())) {
                                        break block17;
                                    }
                                    if (managerData == null) {
                                        managerData = new ManagerSettings();
                                        managerData.setKey(settings);
                                        managerData.setManager((TimetableManager)TimetableManagerDAO.getInstance().get((Long)this.getCurrentAuthority().getQualifiers("TimetableManager").get(0).getQualifierId(), hibSession));
                                    }
                                    managerData.setValue(value);
                                    if (value == null) {
                                        hibSession.delete((Object)managerData);
                                    } else {
                                        hibSession.saveOrUpdate((Object)managerData);
                                    }
                                } else {
                                    UserData userData = (UserData)UserDataDAO.getInstance().get(new UserData(this.getExternalUserId(), key), hibSession);
                                    if (userData == null && value == null) {
                                        break block19;
                                    }
                                    if (userData != null && value != null && value.equals(userData.getValue())) {
                                        break block20;
                                    }
                                    if (userData == null) {
                                        userData = new UserData(this.getExternalUserId(), key);
                                    }
                                    if (value == null) {
                                        hibSession.delete((Object)userData);
                                    } else {
                                        userData.setValue(value);
                                        hibSession.saveOrUpdate((Object)userData);
                                    }
                                }
                                hibSession.flush();
                                break block21;
                            }
                            catch (Throwable throwable) {
                                Object var7_12 = null;
                                hibSession.close();
                                throw throwable;
                            }
                        }
                        hibSession.close();
                        return;
                    }
                    Object var7_8 = null;
                    hibSession.close();
                    return;
                }
                Object var7_9 = null;
                hibSession.close();
                return;
            }
            Object var7_10 = null;
            hibSession.close();
            return;
        }
        Object var7_11 = null;
        hibSession.close();
    }

    @Override
    public String getPassword() {
        return this.iPassword;
    }

    public String getUsername() {
        return this.iLogin;
    }

    @Override
    public boolean isAccountNonLocked() {
        return !LoginManager.isUserLockedOut(this.getUsername(), new Date());
    }
}

