/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.hibernate.Session;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.SectioningServlet;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CourseRequestOption;
import org.unitime.timetable.model.FreeTime;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.onlinesectioning.updates.NotifyStudentAction;
import org.unitime.timetable.onlinesectioning.updates.ReloadAllData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class SaveStudentRequests
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Long iStudentId;
    private CourseRequestInterface iRequest;
    private boolean iKeepEnrollments;

    public SaveStudentRequests forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    public SaveStudentRequests withRequest(CourseRequestInterface request, boolean keepEnrollments) {
        this.iRequest = request;
        this.iKeepEnrollments = keepEnrollments;
        return this;
    }

    public SaveStudentRequests withRequest(CourseRequestInterface request) {
        return this.withRequest(request, true);
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    public CourseRequestInterface getRequest() {
        return this.iRequest;
    }

    public boolean getKeepEnrollments() {
        return this.iKeepEnrollments;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        Throwable throwable2;
        Boolean bl;
        OnlineSectioningServer.Lock lock = server.lockStudent(this.getStudentId(), null, this.name());
        helper.beginTransaction();
        try {
            Student student = (Student)StudentDAO.getInstance().get(this.getStudentId(), helper.getHibSession());
            if (student == null) {
                throw new SectioningException(MSG.exceptionBadStudentId());
            }
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            if (this.getRequest().getStudentId() != null) {
                action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getStudentId()));
            }
            SaveStudentRequests.saveRequest(server, helper, student, this.getRequest(), this.getKeepEnrollments());
            XStudent oldStudent = server.getStudent(this.getStudentId());
            XStudent newStudent = null;
            try {
                newStudent = ReloadAllData.loadStudentNoCheck(student, server, helper);
                server.update(newStudent, true);
                action.getStudentBuilder().setUniqueId(newStudent.getStudentId()).setExternalId(newStudent.getExternalId()).setName(newStudent.getName());
                for (XRequest r : newStudent.getRequests()) {
                    action.addRequest(OnlineSectioningHelper.toProto(r));
                }
            }
            catch (Exception e) {
                if (!(e instanceof RuntimeException)) throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                throw (RuntimeException)e;
            }
            server.execute(server.createAction(NotifyStudentAction.class).forStudent(this.getStudentId()).oldStudent(oldStudent), helper.getUser());
            helper.commitTransaction();
            bl = true;
        }
        catch (Exception e) {
            try {
                helper.rollbackTransaction();
                if (!(e instanceof SectioningException)) throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                throw (SectioningException)e;
            }
            catch (Throwable throwable2) {
                Object var11_13 = null;
                lock.release();
            }
        }
        Object var11_12 = null;
        lock.release();
        return bl;
        throw throwable2;
    }

    @Override
    public String name() {
        return "save-request";
    }

    public static CourseOffering getCourse(Session hibSession, Long sessionId, Long studentId, CourseRequestInterface.RequestedCourse rc) {
        if (rc.hasCourseId()) {
            return (CourseOffering)CourseOfferingDAO.getInstance().get(rc.getCourseId(), hibSession);
        }
        if (rc.hasCourseName()) {
            return SectioningServlet.lookupCourse(hibSession, sessionId, studentId, rc.getCourseName(), null);
        }
        return null;
    }

    private static CourseOffering getCourse(Session hibSession, long courseId) {
        return (CourseOffering)CourseOfferingDAO.getInstance().get(courseId, hibSession);
    }

    public static Map<Long, CourseRequest> saveRequest(OnlineSectioningServer server, OnlineSectioningHelper helper, Student student, CourseRequestInterface request, boolean keepEnrollments) throws SectioningException {
        Iterator<Object> i;
        Iterator<Object> i2;
        ArrayList<CourseOffering> courses;
        TreeSet<CourseDemand> remaining = new TreeSet<CourseDemand>(student.getCourseDemands());
        int priority = 0;
        Date ts = new Date();
        HashMap<Long, CourseRequest> course2request = new HashMap<Long, CourseRequest>();
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            courses = new ArrayList<CourseOffering>();
            HashMap preferences = new HashMap();
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                Object pref;
                if (rc.isFreeTime()) {
                    for (CourseRequestInterface.FreeTime ft : rc.getFreeTime()) {
                        CourseDemand cd = null;
                        i2 = remaining.iterator();
                        while (i2.hasNext()) {
                            CourseDemand adept = (CourseDemand)i2.next();
                            if (adept.getFreeTime() == null) continue;
                            cd = adept;
                            i2.remove();
                            break;
                        }
                        if (cd == null) {
                            cd = new CourseDemand();
                            cd.setTimestamp(ts);
                            cd.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                            student.getCourseDemands().add(cd);
                            cd.setStudent(student);
                        }
                        cd.setAlternative(false);
                        cd.setPriority(priority);
                        cd.setWaitlist(false);
                        FreeTime free = cd.getFreeTime();
                        if (free == null) {
                            free = new FreeTime();
                            cd.setFreeTime(free);
                        }
                        free.setCategory(0);
                        free.setDayCode(DayCode.toInt(DayCode.toDayCodes(ft.getDays())));
                        free.setStartSlot(ft.getStart());
                        free.setLength(ft.getLength());
                        free.setSession(student.getSession());
                        free.setName(ft.toString());
                        helper.getHibSession().saveOrUpdate((Object)free);
                        helper.getHibSession().saveOrUpdate((Object)cd);
                    }
                    ++priority;
                    continue;
                }
                if (!rc.isCourse()) continue;
                CourseOffering co = null;
                if (rc.hasCourseId()) {
                    co = SaveStudentRequests.getCourse(helper.getHibSession(), rc.getCourseId());
                } else {
                    XCourseId c = server == null ? null : server.getCourse(rc.getCourseName());
                    CourseOffering courseOffering = co = c == null ? SaveStudentRequests.getCourse(helper.getHibSession(), request.getAcademicSessionId(), student.getUniqueId(), rc) : SaveStudentRequests.getCourse(helper.getHibSession(), c.getCourseId());
                }
                if (co == null) continue;
                courses.add(co);
                if (server != null) {
                    pref = OnlineSectioningHelper.toPreference(server, rc, new XCourseId(co));
                    if (pref == null) continue;
                    preferences.put(co.getUniqueId(), pref);
                    continue;
                }
                pref = OnlineSectioningHelper.toPreference(co, rc);
                if (pref == null) continue;
                preferences.put(co.getUniqueId(), pref);
            }
            if (courses.isEmpty()) continue;
            CourseDemand cd = null;
            Iterator i3 = remaining.iterator();
            block4: while (i3.hasNext()) {
                CourseDemand adept = (CourseDemand)i3.next();
                if (adept.getFreeTime() != null) continue;
                for (CourseRequest cr : adept.getCourseRequests()) {
                    if (!cr.getCourseOffering().getUniqueId().equals(((CourseOffering)courses.get(0)).getUniqueId())) continue;
                    cd = adept;
                    i3.remove();
                    break block4;
                }
            }
            if (cd == null) {
                cd = new CourseDemand();
                cd.setTimestamp(ts);
                cd.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                cd.setCourseRequests(new HashSet<CourseRequest>());
                cd.setStudent(student);
                student.getCourseDemands().add(cd);
            }
            cd.setAlternative(false);
            cd.setPriority(priority);
            cd.setWaitlist(r.isWaitList());
            Iterator<CourseRequest> requests = new TreeSet<CourseRequest>(cd.getCourseRequests()).iterator();
            int order = 0;
            for (CourseOffering co : courses) {
                CourseRequest cr = null;
                if (requests.hasNext()) {
                    cr = requests.next();
                } else {
                    cr = new CourseRequest();
                    cd.getCourseRequests().add(cr);
                    cr.setCourseDemand(cd);
                }
                cr.updateCourseRequestOption(OnlineSectioningLog.CourseRequestOption.OptionType.ORIGINAL_ENROLLMENT, null);
                cr.updateCourseRequestOption(OnlineSectioningLog.CourseRequestOption.OptionType.REQUEST_PREFERENCE, (OnlineSectioningLog.CourseRequestOption.Builder)preferences.get(co.getUniqueId()));
                cr.setAllowOverlap(false);
                cr.setCredit(0);
                cr.setOrder(order++);
                cr.setCourseOffering(co);
                course2request.put(co.getUniqueId(), cr);
            }
            while (requests.hasNext()) {
                CourseRequest cr = requests.next();
                cd.getCourseRequests().remove(cr);
                helper.getHibSession().delete((Object)cr);
            }
            helper.getHibSession().saveOrUpdate((Object)cd);
            ++priority;
        }
        for (CourseRequestInterface.Request r : request.getAlternatives()) {
            if (r.hasRequestedCourse()) {
                courses = new ArrayList();
                for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                    if (rc.isFreeTime()) {
                        for (CourseRequestInterface.FreeTime ft : rc.getFreeTime()) {
                            CourseDemand cd = null;
                            Iterator i4 = remaining.iterator();
                            while (i4.hasNext()) {
                                CourseDemand adept = (CourseDemand)i4.next();
                                if (adept.getFreeTime() == null) continue;
                                cd = adept;
                                i4.remove();
                                break;
                            }
                            if (cd == null) {
                                cd = new CourseDemand();
                                cd.setTimestamp(ts);
                                cd.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                                student.getCourseDemands().add(cd);
                                cd.setStudent(student);
                            }
                            cd.setAlternative(true);
                            cd.setPriority(priority);
                            cd.setWaitlist(false);
                            FreeTime free = cd.getFreeTime();
                            if (free == null) {
                                free = new FreeTime();
                                cd.setFreeTime(free);
                            }
                            free.setCategory(0);
                            free.setDayCode(DayCode.toInt(DayCode.toDayCodes(ft.getDays())));
                            free.setStartSlot(ft.getStart());
                            free.setLength(ft.getLength());
                            free.setSession(student.getSession());
                            free.setName(ft.toString());
                            helper.getHibSession().saveOrUpdate((Object)free);
                            helper.getHibSession().saveOrUpdate((Object)cd);
                        }
                        ++priority;
                        continue;
                    }
                    if (!rc.isCourse()) continue;
                    CourseOffering co = null;
                    if (rc.hasCourseId()) {
                        co = SaveStudentRequests.getCourse(helper.getHibSession(), rc.getCourseId());
                    } else {
                        Iterator c = server == null ? null : server.getCourse(rc.getCourseName());
                        CourseOffering courseOffering = co = c == null ? SaveStudentRequests.getCourse(helper.getHibSession(), request.getAcademicSessionId(), student.getUniqueId(), rc) : SaveStudentRequests.getCourse(helper.getHibSession(), ((XCourseId)((Object)c)).getCourseId());
                    }
                    if (co == null) continue;
                    courses.add(co);
                }
                if (courses.isEmpty()) continue;
                CourseDemand cd = null;
                i = remaining.iterator();
                block12: while (i.hasNext()) {
                    CourseDemand adept = (CourseDemand)i.next();
                    if (adept.getFreeTime() != null) continue;
                    for (CourseRequest cr : adept.getCourseRequests()) {
                        if (!cr.getCourseOffering().getUniqueId().equals(((CourseOffering)courses.get(0)).getUniqueId())) continue;
                        cd = adept;
                        i.remove();
                        break block12;
                    }
                }
                if (cd == null) {
                    cd = new CourseDemand();
                    cd.setTimestamp(ts);
                    cd.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                    cd.setCourseRequests(new HashSet<CourseRequest>());
                    cd.setStudent(student);
                    student.getCourseDemands().add(cd);
                }
                cd.setAlternative(true);
                cd.setPriority(priority);
                cd.setWaitlist(r.isWaitList());
                Iterator<CourseRequest> requests = new TreeSet<CourseRequest>(cd.getCourseRequests()).iterator();
                int order = 0;
                for (CourseOffering co : courses) {
                    CourseRequest cr;
                    cr = null;
                    if (requests.hasNext()) {
                        cr = requests.next();
                        if (cr.getCourseRequestOptions() != null) {
                            i2 = cr.getCourseRequestOptions().iterator();
                            while (i2.hasNext()) {
                                helper.getHibSession().delete(i2.next());
                            }
                            cr.getCourseRequestOptions().clear();
                        }
                    } else {
                        cr = new CourseRequest();
                        cd.getCourseRequests().add(cr);
                        cr.setCourseDemand(cd);
                        cr.setCourseRequestOptions(new HashSet<CourseRequestOption>());
                    }
                    cr.setAllowOverlap(false);
                    cr.setCredit(0);
                    cr.setOrder(order++);
                    cr.setCourseOffering(co);
                    course2request.put(co.getUniqueId(), cr);
                }
                while (requests.hasNext()) {
                    CourseRequest cr = requests.next();
                    cd.getCourseRequests().remove(cr);
                    helper.getHibSession().delete((Object)cr);
                }
                helper.getHibSession().saveOrUpdate((Object)cd);
            }
            ++priority;
        }
        Iterator<StudentClassEnrollment> i5 = student.getClassEnrollments().iterator();
        while (i5.hasNext()) {
            StudentClassEnrollment enrl = i5.next();
            if (keepEnrollments) {
                CourseRequest cr = (CourseRequest)course2request.get(enrl.getCourseOffering().getUniqueId());
                if (cr == null) {
                    enrl.getClazz().getStudentEnrollments().remove(enrl);
                    helper.getHibSession().delete((Object)enrl);
                    i5.remove();
                    continue;
                }
                enrl.setCourseRequest(cr);
                helper.getHibSession().saveOrUpdate((Object)enrl);
                continue;
            }
            enrl.getClazz().getStudentEnrollments().remove(enrl);
            helper.getHibSession().delete((Object)enrl);
            i5.remove();
        }
        if (!keepEnrollments) {
            for (CourseDemand cd : student.getCourseDemands()) {
                if (cd.getCourseRequests() == null) continue;
                for (CourseRequest cr : cd.getCourseRequests()) {
                    if (cr.getClassWaitLists() == null) continue;
                    i = cr.getClassWaitLists().iterator();
                    while (i.hasNext()) {
                        helper.getHibSession().delete(i.next());
                        i.remove();
                    }
                }
            }
        }
        for (CourseDemand cd : remaining) {
            if (cd.getFreeTime() != null) {
                helper.getHibSession().delete((Object)cd.getFreeTime());
            }
            for (CourseRequest cr : cd.getCourseRequests()) {
                helper.getHibSession().delete((Object)cr);
            }
            student.getCourseDemands().remove(cd);
            helper.getHibSession().delete((Object)cd);
        }
        helper.getHibSession().saveOrUpdate((Object)student);
        helper.getHibSession().flush();
        return course2request;
    }
}

