/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.component.VEvent;
import biweekly.component.VFreeBusy;
import biweekly.io.text.ICalWriter;
import biweekly.parameter.Role;
import biweekly.property.Attendee;
import biweekly.property.CalendarScale;
import biweekly.property.DateEnd;
import biweekly.property.DateStart;
import biweekly.property.ExceptionDates;
import biweekly.property.Method;
import biweekly.property.Organizer;
import biweekly.property.Status;
import biweekly.util.Recurrence;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XTime;
import org.unitime.timetable.server.CourseDetailsBackend;
import org.unitime.timetable.util.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarExport
implements OnlineSectioningAction<String> {
    private static final long serialVersionUID = 1L;
    private String iClassIds;
    private String iFts;

    public CalendarExport withParams(String classIds, String fts) {
        this.iClassIds = classIds;
        this.iFts = fts;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        try {
            ICalendar ical = new ICalendar();
            ical.setVersion(ICalVersion.V2_0);
            ical.setCalendarScale(CalendarScale.gregorian());
            ical.setMethod(new Method("PUBLISH"));
            ical.setExperimentalProperty("X-WR-CALNAME", "UniTime Schedule");
            ical.setExperimentalProperty("X-WR-TIMEZONE", TimeZone.getDefault().getID());
            ical.setProductId("-//UniTime LLC/UniTime " + Constants.getVersion() + " Schedule//EN");
            if (this.iClassIds != null && !this.iClassIds.isEmpty()) {
                for (String classId : this.iClassIds.split(",")) {
                    XSection section;
                    String[] courseAndClassId;
                    if (classId.isEmpty() || (courseAndClassId = classId.split("-")).length != 2) continue;
                    XCourse course = server.getCourse(Long.valueOf(courseAndClassId[0]));
                    XOffering offering = course == null ? null : server.getOffering(course.getOfferingId());
                    XSection xSection = section = offering == null ? null : offering.getSection(Long.valueOf(courseAndClassId[1]));
                    if (course == null || section == null) continue;
                    CalendarExport.printSection(server, course, section, ical);
                }
            }
            if (this.iFts != null && !this.iFts.isEmpty()) {
                Date dpFirstDate = server.getAcademicSession().getDatePatternFirstDate();
                BitSet weekCode = server.getAcademicSession().getFreeTimePattern();
                for (String ft : this.iFts.split(",")) {
                    String[] daysStartLen;
                    if (ft.isEmpty() || (daysStartLen = ft.split("-")).length != 3) continue;
                    CalendarExport.printFreeTime(dpFirstDate, weekCode, daysStartLen[0], Integer.parseInt(daysStartLen[1]), Integer.parseInt(daysStartLen[2]), ical);
                }
            }
            StringWriter ret = new StringWriter();
            ICalWriter writer = new ICalWriter(ret, ICalVersion.V2_0);
            writer.getTimezoneInfo().setDefaultTimeZone(TimeZone.getDefault());
            try {
                writer.write(ical);
                writer.flush();
                Object var13_18 = null;
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                writer.close();
                throw throwable;
            }
            writer.close();
            return ret.toString();
        }
        catch (IOException e) {
            throw new SectioningException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCalendar(OnlineSectioningServer server, XStudent student) throws IOException {
        if (student == null) {
            return null;
        }
        ICalendar ical = new ICalendar();
        ical.setVersion(ICalVersion.V2_0);
        ical.setCalendarScale(CalendarScale.gregorian());
        ical.setMethod(new Method("PUBLISH"));
        ical.setExperimentalProperty("X-WR-CALNAME", "UniTime Schedule");
        ical.setExperimentalProperty("X-WR-TIMEZONE", TimeZone.getDefault().getID());
        ical.setProductId("-//UniTime LLC/UniTime " + Constants.getVersion() + " Schedule//EN");
        for (XRequest request : student.getRequests()) {
            if (request instanceof XCourseRequest) {
                XCourseRequest cr = (XCourseRequest)request;
                XEnrollment enrollment = cr.getEnrollment();
                if (enrollment == null) continue;
                XCourse course = server.getCourse(enrollment.getCourseId());
                XOffering offering = server.getOffering(enrollment.getOfferingId());
                if (course == null || offering == null) continue;
                for (XSection section : offering.getSections(enrollment)) {
                    CalendarExport.printSection(server, course, section, ical);
                }
                continue;
            }
            if (!(request instanceof XFreeTimeRequest)) continue;
            XFreeTimeRequest ft = (XFreeTimeRequest)request;
            CalendarExport.printFreeTime(server.getAcademicSession().getDatePatternFirstDate(), server.getAcademicSession().getFreeTimePattern(), DayCode.toString(ft.getTime().getDays()), ft.getTime().getSlot(), ft.getTime().getLength(), ical);
        }
        StringWriter ret = new StringWriter();
        ICalWriter writer = new ICalWriter(ret, ICalVersion.V2_0);
        writer.getTimezoneInfo().setDefaultTimeZone(TimeZone.getDefault());
        try {
            writer.write(ical);
            writer.flush();
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            writer.close();
            throw throwable;
        }
        writer.close();
        return ret.toString();
    }

    private static void printSection(OnlineSectioningServer server, XCourse course, XSection section, ICalendar ical) throws IOException {
        String desc;
        XTime time = section.getTime();
        if (time == null || time.getWeeks().isEmpty()) {
            return;
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setLenient(true);
        cal.setTime(server.getAcademicSession().getDatePatternFirstDate());
        int idx = time.getWeeks().nextSetBit(0);
        cal.add(6, idx);
        cal.set(11, Constants.toHour(time.getSlot()));
        cal.set(12, Constants.toMinute(time.getSlot()));
        cal.set(13, 0);
        Date first = null;
        while (idx < time.getWeeks().size() && first == null) {
            if (time.getWeeks().get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if ((time.getDays() & DayCode.MON.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 3: {
                        if ((time.getDays() & DayCode.TUE.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 4: {
                        if ((time.getDays() & DayCode.WED.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 5: {
                        if ((time.getDays() & DayCode.THU.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 6: {
                        if ((time.getDays() & DayCode.FRI.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 7: {
                        if ((time.getDays() & DayCode.SAT.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 1: {
                        if ((time.getDays() & DayCode.SUN.getCode()) == 0) break;
                        first = cal.getTime();
                    }
                }
            }
            if (first != null) continue;
            cal.add(6, 1);
            ++idx;
        }
        if (first == null) {
            return;
        }
        cal.add(12, Constants.SLOT_LENGTH_MIN * time.getLength() - time.getBreakTime());
        Date firstEnd = cal.getTime();
        int fidx = idx;
        cal.setTime(server.getAcademicSession().getDatePatternFirstDate());
        idx = time.getWeeks().length() - 1;
        cal.add(6, idx);
        cal.set(11, Constants.toHour(time.getSlot()));
        cal.set(12, Constants.toMinute(time.getSlot()));
        cal.set(13, 0);
        cal.add(12, Constants.SLOT_LENGTH_MIN * time.getLength() - time.getBreakTime());
        Date last = null;
        while (idx >= 0 && last == null) {
            if (time.getWeeks().get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if ((time.getDays() & DayCode.MON.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 3: {
                        if ((time.getDays() & DayCode.TUE.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 4: {
                        if ((time.getDays() & DayCode.WED.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 5: {
                        if ((time.getDays() & DayCode.THU.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 6: {
                        if ((time.getDays() & DayCode.FRI.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 7: {
                        if ((time.getDays() & DayCode.SAT.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 1: {
                        if ((time.getDays() & DayCode.SUN.getCode()) == 0) break;
                        last = cal.getTime();
                    }
                }
            }
            if (last != null) continue;
            cal.add(6, -1);
            --idx;
        }
        if (last == null) {
            return;
        }
        cal.setTime(server.getAcademicSession().getDatePatternFirstDate());
        idx = fidx;
        cal.add(6, idx);
        cal.set(11, Constants.toHour(time.getSlot()));
        cal.set(12, Constants.toMinute(time.getSlot()));
        cal.set(13, 0);
        VEvent vevent = new VEvent();
        DateStart dstart = new DateStart(first, true);
        vevent.setDateStart(dstart);
        DateEnd dend = new DateEnd(firstEnd, true);
        vevent.setDateEnd(dend);
        Recurrence.Builder recur = new Recurrence.Builder(Recurrence.Frequency.WEEKLY);
        Iterator<DayCode> i = DayCode.toDayCodes(time.getDays()).iterator();
        while (i.hasNext()) {
            switch (i.next()) {
                case MON: {
                    recur.byDay(Recurrence.DayOfWeek.MONDAY);
                    break;
                }
                case TUE: {
                    recur.byDay(Recurrence.DayOfWeek.TUESDAY);
                    break;
                }
                case WED: {
                    recur.byDay(Recurrence.DayOfWeek.WEDNESDAY);
                    break;
                }
                case THU: {
                    recur.byDay(Recurrence.DayOfWeek.THURSDAY);
                    break;
                }
                case FRI: {
                    recur.byDay(Recurrence.DayOfWeek.FRIDAY);
                    break;
                }
                case SAT: {
                    recur.byDay(Recurrence.DayOfWeek.SATURDAY);
                    break;
                }
                case SUN: {
                    recur.byDay(Recurrence.DayOfWeek.SUNDAY);
                }
            }
        }
        recur.workweekStarts(Recurrence.DayOfWeek.MONDAY).until(last);
        vevent.setRecurrenceRule(recur.build());
        ExceptionDates exdates = new ExceptionDates();
        while (idx < time.getWeeks().length()) {
            int dow = cal.get(7);
            boolean offered = false;
            switch (dow) {
                case 2: {
                    if ((time.getDays() & DayCode.MON.getCode()) == 0) break;
                    offered = true;
                    break;
                }
                case 3: {
                    if ((time.getDays() & DayCode.TUE.getCode()) == 0) break;
                    offered = true;
                    break;
                }
                case 4: {
                    if ((time.getDays() & DayCode.WED.getCode()) == 0) break;
                    offered = true;
                    break;
                }
                case 5: {
                    if ((time.getDays() & DayCode.THU.getCode()) == 0) break;
                    offered = true;
                    break;
                }
                case 6: {
                    if ((time.getDays() & DayCode.FRI.getCode()) == 0) break;
                    offered = true;
                    break;
                }
                case 7: {
                    if ((time.getDays() & DayCode.SAT.getCode()) == 0) break;
                    offered = true;
                    break;
                }
                case 1: {
                    if ((time.getDays() & DayCode.SUN.getCode()) == 0) break;
                    offered = true;
                }
            }
            if (!offered) {
                cal.add(6, 1);
                ++idx;
                continue;
            }
            cal.set(11, Constants.toHour(time.getSlot()));
            cal.set(12, Constants.toMinute(time.getSlot()));
            cal.set(13, 0);
            if (!time.getWeeks().get(idx)) {
                exdates.addValue(cal.getTime());
            }
            cal.add(6, 1);
            ++idx;
        }
        if (!exdates.getValues().isEmpty()) {
            vevent.addExceptionDates(exdates);
        }
        vevent.setUid(section.getSectionId().toString());
        vevent.setSequence(0);
        vevent.setSummary(course.getSubjectArea() + " " + course.getCourseNumber() + " " + section.getSubpartName() + " " + section.getName(course.getCourseId()));
        String string = desc = course.getTitle() == null ? "" : course.getTitle();
        if (course.getConsentLabel() != null && !course.getConsentLabel().isEmpty()) {
            desc = desc + " (" + course.getConsentLabel() + ")";
        }
        vevent.setDescription(desc);
        if (section.getRooms() != null && !section.getRooms().isEmpty()) {
            String loc = "";
            for (XRoom r : section.getRooms()) {
                if (!loc.isEmpty()) {
                    loc = loc + ", ";
                }
                loc = loc + r.getName();
            }
            vevent.setLocation(loc);
        }
        try {
            URL url = CourseDetailsBackend.getCourseUrl(server.getAcademicSession(), course.getSubjectArea(), course.getCourseNumber());
            if (url != null) {
                vevent.setUrl(url.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (section.getInstructors() != null && !section.getInstructors().isEmpty()) {
            for (XInstructor instructor : section.getInstructors()) {
                if (vevent.getOrganizer() == null) {
                    Organizer organizer = new Organizer(instructor.getName(), instructor.getEmail() != null ? instructor.getEmail() : "");
                    vevent.setOrganizer(organizer);
                    continue;
                }
                Attendee attendee = new Attendee(instructor.getName(), instructor.getEmail() != null ? instructor.getEmail() : "");
                attendee.setRole(Role.CHAIR);
                vevent.addAttendee(attendee);
            }
        }
        vevent.setStatus(Status.confirmed());
        ical.addEvent(vevent);
    }

    private static void printFreeTime(Date dpFirstDate, BitSet weekCode, String days, int start, int len, ICalendar ical) throws IOException {
        int idx;
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setLenient(true);
        cal.setTime(dpFirstDate);
        cal.add(6, idx);
        cal.set(11, Constants.toHour(start));
        cal.set(12, Constants.toMinute(start));
        cal.set(13, 0);
        Date first = null;
        for (idx = weekCode.nextSetBit(0); idx < weekCode.size() && first == null; ++idx) {
            if (weekCode.get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if (!days.contains(DayCode.MON.getAbbv())) break;
                        first = cal.getTime();
                        break;
                    }
                    case 3: {
                        if (!days.contains(DayCode.TUE.getAbbv())) break;
                        first = cal.getTime();
                        break;
                    }
                    case 4: {
                        if (!days.contains(DayCode.WED.getAbbv())) break;
                        first = cal.getTime();
                        break;
                    }
                    case 5: {
                        if (!days.contains(DayCode.THU.getAbbv())) break;
                        first = cal.getTime();
                        break;
                    }
                    case 6: {
                        if (!days.contains(DayCode.FRI.getAbbv())) break;
                        first = cal.getTime();
                        break;
                    }
                    case 7: {
                        if (!days.contains(DayCode.SAT.getAbbv())) break;
                        first = cal.getTime();
                        break;
                    }
                    case 1: {
                        if (!days.contains(DayCode.SUN.getAbbv())) break;
                        first = cal.getTime();
                    }
                }
            }
            cal.add(6, 1);
        }
        if (first == null) {
            return;
        }
        cal.setTime(dpFirstDate);
        cal.add(6, idx);
        cal.set(11, Constants.toHour(start));
        cal.set(12, Constants.toMinute(start));
        cal.set(13, 0);
        cal.add(12, Constants.SLOT_LENGTH_MIN * len);
        Date last = null;
        for (idx = weekCode.length() - 1; idx >= 0 && last == null; --idx) {
            if (weekCode.get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if (!days.contains(DayCode.MON.getAbbv())) break;
                        last = cal.getTime();
                        break;
                    }
                    case 3: {
                        if (!days.contains(DayCode.TUE.getAbbv())) break;
                        last = cal.getTime();
                        break;
                    }
                    case 4: {
                        if (!days.contains(DayCode.WED.getAbbv())) break;
                        last = cal.getTime();
                        break;
                    }
                    case 5: {
                        if (!days.contains(DayCode.THU.getAbbv())) break;
                        last = cal.getTime();
                        break;
                    }
                    case 6: {
                        if (!days.contains(DayCode.FRI.getAbbv())) break;
                        last = cal.getTime();
                        break;
                    }
                    case 7: {
                        if (!days.contains(DayCode.SAT.getAbbv())) break;
                        last = cal.getTime();
                        break;
                    }
                    case 1: {
                        if (!days.contains(DayCode.SUN.getAbbv())) break;
                        last = cal.getTime();
                    }
                }
            }
            cal.add(6, -1);
        }
        if (last == null) {
            return;
        }
        VFreeBusy vfree = new VFreeBusy();
        DateStart dstart = new DateStart(first, true);
        vfree.setDateStart(dstart);
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(first);
        c.add(12, Constants.SLOT_LENGTH_MIN * len);
        DateEnd dend = new DateEnd(c.getTime(), true);
        vfree.setDateEnd(dend);
        vfree.addComment("Free Time");
        ical.addFreeBusy(vfree);
        cal.setTime(dpFirstDate);
        cal.add(6, idx);
        for (idx = weekCode.nextSetBit(0); idx < weekCode.length(); ++idx) {
            if (weekCode.get(idx)) {
                int dow = cal.get(7);
                boolean offered = false;
                switch (dow) {
                    case 2: {
                        if (!days.contains(DayCode.MON.getAbbv())) break;
                        offered = true;
                        break;
                    }
                    case 3: {
                        if (!days.contains(DayCode.TUE.getAbbv())) break;
                        offered = true;
                        break;
                    }
                    case 4: {
                        if (!days.contains(DayCode.WED.getAbbv())) break;
                        offered = true;
                        break;
                    }
                    case 5: {
                        if (!days.contains(DayCode.THU.getAbbv())) break;
                        offered = true;
                        break;
                    }
                    case 6: {
                        if (!days.contains(DayCode.FRI.getAbbv())) break;
                        offered = true;
                        break;
                    }
                    case 7: {
                        if (!days.contains(DayCode.SAT.getAbbv())) break;
                        offered = true;
                        break;
                    }
                    case 1: {
                        if (!days.contains(DayCode.SUN.getAbbv())) break;
                        offered = true;
                    }
                }
                if (offered) {
                    cal.set(11, Constants.toHour(start));
                    cal.set(12, Constants.toMinute(start));
                    cal.set(13, 0);
                    vfree = new VFreeBusy();
                    dstart = new DateStart(cal.getTime(), true);
                    vfree.setDateStart(dstart);
                    cal.add(12, Constants.SLOT_LENGTH_MIN * len);
                    dend = new DateEnd(cal.getTime(), true);
                    vfree.setDateEnd(dend);
                    vfree.addComment("Free Time");
                    ical.addFreeBusy(vfree);
                }
            }
            cal.add(6, 1);
        }
    }

    @Override
    public String name() {
        return "calendar";
    }
}

