/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.model.XCredit;
import org.unitime.timetable.onlinesectioning.model.XSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SerializeWith(value=XSubpartSerializer.class)
public class XSubpart
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static DecimalFormat sF3Z = new DecimalFormat("000");
    private Long iUniqueId = null;
    private String iInstructionalType = null;
    private String iName = null;
    private List<XSection> iSections = new ArrayList<XSection>();
    private Long iConfigId = null;
    private Long iParentId = null;
    private XCredit iCredit = null;
    private boolean iAllowOverlap = false;
    private Map<Long, XCredit> iCreditByCourse = new HashMap<Long, XCredit>();

    public XSubpart() {
    }

    public XSubpart(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XSubpart(SchedulingSubpart subpart, boolean courseCredit, OnlineSectioningHelper helper) {
        this.iUniqueId = subpart.getUniqueId();
        this.iInstructionalType = sF3Z.format(subpart.getItype().getItype()) + subpart.getSchedulingSubpartSuffix(helper.getHibSession());
        this.iAllowOverlap = subpart.isStudentAllowOverlap();
        this.iName = subpart.getItype().getAbbv().trim();
        if (subpart.getInstrOfferingConfig().getInstructionalMethod() != null) {
            this.iName = this.iName + " (" + subpart.getInstrOfferingConfig().getInstructionalMethod().getLabel() + ")";
        }
        this.iConfigId = subpart.getInstrOfferingConfig().getUniqueId();
        Long l = this.iParentId = subpart.getParentSubpart() == null ? null : subpart.getParentSubpart().getUniqueId();
        if (subpart.getCredit() != null) {
            this.iCredit = new XCredit(subpart.getCredit());
        }
        if (courseCredit) {
            for (CourseOffering co : subpart.getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings()) {
                if (co.getCredit() == null) continue;
                this.iCreditByCourse.put(co.getUniqueId(), new XCredit(co.getCredit()));
            }
        }
        for (Class_ clazz : subpart.getClasses()) {
            this.iSections.add(new XSection(clazz, helper));
        }
        Collections.sort(this.iSections);
    }

    public XSubpart(Subpart subpart, boolean courseCredit) {
        this.iUniqueId = subpart.getId();
        this.iInstructionalType = subpart.getInstructionalType();
        this.iAllowOverlap = subpart.isAllowOverlap();
        this.iName = subpart.getName();
        this.iConfigId = subpart.getConfig().getId();
        Long l = this.iParentId = subpart.getParent() == null ? null : Long.valueOf(subpart.getParent().getId());
        if (subpart.getCredit() != null) {
            this.iCredit = new XCredit(subpart.getCredit());
        }
        if (courseCredit) {
            for (Course course : subpart.getConfig().getOffering().getCourses()) {
                if (course.getCredit() == null) continue;
                this.iCreditByCourse.put(course.getId(), new XCredit(course.getCredit()));
            }
        }
        for (Section section : subpart.getSections()) {
            this.iSections.add(new XSection(section));
        }
    }

    public Long getSubpartId() {
        return this.iUniqueId;
    }

    public String getInstructionalType() {
        return this.iInstructionalType;
    }

    public String getName() {
        return this.iName;
    }

    public Long getConfigId() {
        return this.iConfigId;
    }

    public List<XSection> getSections() {
        return this.iSections;
    }

    public Long getParentId() {
        return this.iParentId;
    }

    public boolean isAllowOverlap() {
        return this.iAllowOverlap;
    }

    public String toString() {
        return this.getName();
    }

    public int getLimit() {
        int limit = 0;
        for (XSection section : this.getSections()) {
            if (section.getLimit() < 0) {
                return -1;
            }
            limit += section.getLimit();
        }
        return limit;
    }

    public String getCreditAbbv(Long courseId) {
        XCredit credit;
        XCredit xCredit = credit = courseId != null ? this.iCreditByCourse.get(courseId) : null;
        return credit != null ? credit.getAbbreviation() : (this.iCredit != null ? this.iCredit.getAbbreviation() : null);
    }

    public String getCreditText(Long courseId) {
        XCredit credit;
        XCredit xCredit = credit = courseId != null ? this.iCreditByCourse.get(courseId) : null;
        return credit != null ? credit.getText() : (this.iCredit != null ? this.iCredit.getText() : null);
    }

    public XCredit getCreditInfo(Long courseId) {
        XCredit credit = courseId != null ? this.iCreditByCourse.get(courseId) : null;
        return credit != null ? credit : this.iCredit;
    }

    public String getCredit(Long courseId) {
        XCredit credit;
        if (courseId != null && (credit = this.iCreditByCourse.get(courseId)) != null) {
            return credit.getAbbreviation() + "|" + credit.getText();
        }
        return this.iCredit == null ? null : this.iCredit.getAbbreviation() + "|" + this.iCredit.getText();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XSubpart)) {
            return false;
        }
        return this.getSubpartId().equals(((XSubpart)o).getSubpartId());
    }

    public int hashCode() {
        return (int)(this.getSubpartId() ^ this.getSubpartId() >>> 32);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iUniqueId = in.readLong();
        this.iInstructionalType = (String)in.readObject();
        this.iName = (String)in.readObject();
        int nrSections = in.readInt();
        this.iSections.clear();
        for (int i = 0; i < nrSections; ++i) {
            this.iSections.add(new XSection(in));
        }
        this.iConfigId = in.readLong();
        this.iParentId = in.readLong();
        if (this.iParentId < 0L) {
            this.iParentId = null;
        }
        this.iCredit = in.readBoolean() ? new XCredit(in) : null;
        this.iAllowOverlap = in.readBoolean();
        int nrCredits = in.readInt();
        this.iCreditByCourse.clear();
        for (int i = 0; i < nrCredits; ++i) {
            this.iCreditByCourse.put(in.readLong(), new XCredit(in));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.iUniqueId);
        out.writeObject(this.iInstructionalType);
        out.writeObject(this.iName);
        out.writeInt(this.iSections.size());
        for (XSection xSection : this.iSections) {
            xSection.writeExternal(out);
        }
        out.writeLong(this.iConfigId);
        out.writeLong(this.iParentId == null ? -1L : this.iParentId);
        out.writeBoolean(this.iCredit != null);
        if (this.iCredit != null) {
            this.iCredit.writeExternal(out);
        }
        out.writeBoolean(this.iAllowOverlap);
        out.writeInt(this.iCreditByCourse.size());
        for (Map.Entry entry : this.iCreditByCourse.entrySet()) {
            out.writeLong((Long)entry.getKey());
            ((XCredit)entry.getValue()).writeExternal(out);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XSubpartSerializer
    implements Externalizer<XSubpart> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XSubpart object) throws IOException {
            object.writeExternal(output);
        }

        public XSubpart readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XSubpart(input);
        }
    }
}

