/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.model.AcademicAreaCode;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentNote;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XInstructorAssignment;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XStudentNote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SerializeWith(value=XStudentSerializer.class)
public class XStudent
extends XStudentId
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private Set<XAreaClassificationMajor> iMajors = new TreeSet<XAreaClassificationMajor>();
    private List<String> iGroups = new ArrayList<String>();
    private List<String> iAccomodations = new ArrayList<String>();
    private List<XRequest> iRequests = new ArrayList<XRequest>();
    private String iStatus = null;
    private String iEmail = null;
    private Date iEmailTimeStamp = null;
    private List<XInstructorAssignment> iInstructorAssignments = new ArrayList<XInstructorAssignment>();
    private XStudentNote iLastNote = null;

    public XStudent() {
    }

    public XStudent(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XStudent(Long studentId, String externalId, String name) {
        super(studentId, externalId, name);
    }

    /*
     * WARNING - void declaration
     */
    public XStudent(org.unitime.timetable.model.Student student, OnlineSectioningHelper helper, BitSet freeTimePattern) {
        super(student, helper);
        void var6_18;
        this.iStatus = student.getSectioningStatus() == null ? null : student.getSectioningStatus().getReference();
        this.iEmail = student.getEmail();
        this.iEmailTimeStamp = student.getScheduleEmailedDate() == null ? null : student.getScheduleEmailedDate();
        for (StudentAreaClassificationMajor studentAreaClassificationMajor : student.getAreaClasfMajors()) {
            this.iMajors.add(new XAreaClassificationMajor(studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation(), studentAreaClassificationMajor.getAcademicClassification().getCode(), studentAreaClassificationMajor.getMajor().getCode()));
        }
        for (StudentGroup studentGroup : student.getGroups()) {
            this.iGroups.add(studentGroup.getGroupAbbreviation());
        }
        for (StudentAccomodation studentAccomodation : student.getAccomodations()) {
            this.iAccomodations.add(studentAccomodation.getAbbreviation());
        }
        TreeSet<CourseDemand> demands = new TreeSet<CourseDemand>(new Comparator<CourseDemand>(){

            @Override
            public int compare(CourseDemand d1, CourseDemand d2) {
                if (d1.isAlternative().booleanValue() && !d2.isAlternative().booleanValue()) {
                    return 1;
                }
                if (!d1.isAlternative().booleanValue() && d2.isAlternative().booleanValue()) {
                    return -1;
                }
                int cmp = d1.getPriority().compareTo(d2.getPriority());
                if (cmp != 0) {
                    return cmp;
                }
                return d1.getUniqueId().compareTo(d2.getUniqueId());
            }
        });
        demands.addAll(student.getCourseDemands());
        for (CourseDemand courseDemand : demands) {
            if (courseDemand.getFreeTime() != null) {
                this.iRequests.add(new XFreeTimeRequest(courseDemand, freeTimePattern));
                continue;
            }
            if (courseDemand.getCourseRequests().isEmpty()) continue;
            this.iRequests.add(new XCourseRequest(courseDemand, helper));
        }
        HashMap<CourseOffering, ArrayList<StudentClassEnrollment>> hashMap = new HashMap<CourseOffering, ArrayList<StudentClassEnrollment>>();
        for (StudentClassEnrollment enrollment : student.getClassEnrollments()) {
            if (this.getRequestForCourse(enrollment.getCourseOffering().getUniqueId()) != null) continue;
            ArrayList<StudentClassEnrollment> classes = (ArrayList<StudentClassEnrollment>)hashMap.get(enrollment.getCourseOffering());
            if (classes == null) {
                classes = new ArrayList<StudentClassEnrollment>();
                hashMap.put(enrollment.getCourseOffering(), classes);
            }
            classes.add(enrollment);
        }
        if (!hashMap.isEmpty()) {
            boolean bl = false;
            for (XRequest request : this.iRequests) {
                int n;
                if (request.isAlternative() || request.getPriority() <= n) continue;
                n = request.getPriority();
            }
            for (CourseOffering course : new TreeSet(hashMap.keySet())) {
                void var6_16;
                List classes = (List)hashMap.get(course);
                this.iRequests.add(new XCourseRequest(student, course, (int)(++var6_16), helper, classes));
            }
        }
        Collections.sort(this.iRequests);
        Object var6_17 = null;
        if (student.getNotes() != null) {
            for (StudentNote n : student.getNotes()) {
                if (var6_18 != null && var6_18.compareTo(n) <= 0) continue;
                StudentNote studentNote = n;
            }
        }
        if (var6_18 != null) {
            this.iLastNote = new XStudentNote((StudentNote)var6_18);
        }
    }

    public XStudent(XStudent student) {
        super(student);
        this.iStatus = student.getStatus();
        this.iEmail = student.getEmail();
        this.iEmailTimeStamp = student.getEmailTimeStamp();
        this.iMajors.addAll(student.getMajors());
        this.iGroups.addAll(student.getGroups());
        this.iAccomodations.addAll(student.getAccomodations());
        this.iRequests.addAll(student.getRequests());
    }

    public XStudent(XStudent student, Collection<CourseDemand> demands, OnlineSectioningHelper helper, BitSet freeTimePattern) {
        super(student);
        this.iStatus = student.getStatus();
        this.iEmail = student.getEmail();
        this.iEmailTimeStamp = student.getEmailTimeStamp();
        this.iMajors.addAll(student.getMajors());
        this.iGroups.addAll(student.getGroups());
        this.iAccomodations.addAll(student.getAccomodations());
        if (demands != null) {
            for (CourseDemand cd : demands) {
                if (cd.getFreeTime() != null) {
                    this.iRequests.add(new XFreeTimeRequest(cd, freeTimePattern));
                    continue;
                }
                if (cd.getCourseRequests().isEmpty()) continue;
                this.iRequests.add(new XCourseRequest(cd, helper));
            }
        }
        Collections.sort(this.iRequests);
    }

    public static List<XRequest> loadRequests(org.unitime.timetable.model.Student student, OnlineSectioningHelper helper, BitSet freeTimePattern) {
        ArrayList<XRequest> requests = new ArrayList<XRequest>();
        TreeSet<CourseDemand> demands = new TreeSet<CourseDemand>(new Comparator<CourseDemand>(){

            @Override
            public int compare(CourseDemand d1, CourseDemand d2) {
                if (d1.isAlternative().booleanValue() && !d2.isAlternative().booleanValue()) {
                    return 1;
                }
                if (!d1.isAlternative().booleanValue() && d2.isAlternative().booleanValue()) {
                    return -1;
                }
                int cmp = d1.getPriority().compareTo(d2.getPriority());
                if (cmp != 0) {
                    return cmp;
                }
                return d1.getUniqueId().compareTo(d2.getUniqueId());
            }
        });
        demands.addAll(student.getCourseDemands());
        for (CourseDemand cd : demands) {
            if (cd.getFreeTime() != null) {
                requests.add(new XFreeTimeRequest(cd, freeTimePattern));
                continue;
            }
            if (cd.getCourseRequests().isEmpty()) continue;
            requests.add(new XCourseRequest(cd, helper));
        }
        Collections.sort(requests);
        return requests;
    }

    public XStudent(Student student, Assignment<Request, Enrollment> assignment) {
        super(student);
        this.iStatus = student.getStatus();
        this.iEmailTimeStamp = student.getEmailTimeStamp() == null ? null : new Date(student.getEmailTimeStamp());
        for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
            this.iMajors.add(new XAreaClassificationMajor(acm.getArea(), acm.getClassification(), acm.getMajor()));
        }
        for (int i = 0; i < Math.min(student.getAcademicAreaClasiffications().size(), student.getMajors().size()); ++i) {
            this.iMajors.add(new XAreaClassificationMajor(((AcademicAreaCode)student.getMajors().get(i)).getArea(), ((AcademicAreaCode)student.getAcademicAreaClasiffications().get(i)).getCode(), ((AcademicAreaCode)student.getMajors().get(i)).getCode()));
        }
        for (AcademicAreaCode aac : student.getMinors()) {
            if ("A".equals(aac.getArea())) {
                this.iAccomodations.add(aac.getCode());
                continue;
            }
            this.iGroups.add(aac.getCode());
        }
        for (Request request : student.getRequests()) {
            if (request instanceof FreeTimeRequest) {
                this.iRequests.add(new XFreeTimeRequest((FreeTimeRequest)request));
                continue;
            }
            if (!(request instanceof CourseRequest)) continue;
            this.iRequests.add(new XCourseRequest((CourseRequest)request, assignment == null ? null : (Enrollment)assignment.getValue((Variable)request)));
        }
    }

    public List<XInstructorAssignment> getInstructorAssignments() {
        return this.iInstructorAssignments;
    }

    public boolean hasInstructorAssignments() {
        return this.iInstructorAssignments != null && !this.iInstructorAssignments.isEmpty();
    }

    public XStudentNote getLastNote() {
        return this.iLastNote;
    }

    public boolean hasLastNote() {
        return this.iLastNote != null && this.iLastNote.hasNote();
    }

    public void setLastNote(XStudentNote note) {
        this.iLastNote = note;
    }

    public XCourseRequest getRequestForCourse(Long courseId) {
        for (XRequest request : this.iRequests) {
            if (!(request instanceof XCourseRequest) || !((XCourseRequest)request).hasCourse(courseId)) continue;
            return (XCourseRequest)request;
        }
        return null;
    }

    public Set<XAreaClassificationMajor> getMajors() {
        return this.iMajors;
    }

    public List<String> getGroups() {
        return this.iGroups;
    }

    public List<String> getAccomodations() {
        return this.iAccomodations;
    }

    public String getStatus() {
        return this.iStatus;
    }

    public void setStatus(String status) {
        this.iStatus = status;
    }

    public Date getEmailTimeStamp() {
        return this.iEmailTimeStamp;
    }

    public void setEmailTimeStamp(Date emailTimeStamp) {
        this.iEmailTimeStamp = emailTimeStamp;
    }

    public List<XRequest> getRequests() {
        return this.iRequests;
    }

    public String getEmail() {
        return this.iEmail;
    }

    public boolean canAssign(XCourseRequest request) {
        if (request.getEnrollment() != null) {
            return true;
        }
        int alt = 0;
        boolean found = false;
        for (XRequest r : this.iRequests) {
            boolean waitlist;
            boolean course;
            if (r.equals(request)) {
                found = true;
            }
            boolean assigned = !(course = r instanceof XCourseRequest) || ((XCourseRequest)r).getEnrollment() != null || r.equals(request);
            boolean bl = waitlist = course && ((XCourseRequest)r).isWaitlist();
            if (r.isAlternative()) {
                if (!assigned && (found || !waitlist)) continue;
                --alt;
                continue;
            }
            if (!course || waitlist || assigned) continue;
            ++alt;
        }
        return alt >= 0;
    }

    @Override
    public String toString() {
        return this.getName() + " (" + this.getExternalId() + ")";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int nrMajors = in.readInt();
        this.iMajors.clear();
        for (int i = 0; i < nrMajors; ++i) {
            this.iMajors.add(new XAreaClassificationMajor(in));
        }
        int nrGroups = in.readInt();
        this.iGroups.clear();
        for (int i = 0; i < nrGroups; ++i) {
            this.iGroups.add((String)in.readObject());
        }
        int nrAccomodations = in.readInt();
        this.iAccomodations.clear();
        for (int i = 0; i < nrAccomodations; ++i) {
            this.iAccomodations.add((String)in.readObject());
        }
        int nrRequests = in.readInt();
        this.iRequests.clear();
        for (int i = 0; i < nrRequests; ++i) {
            this.iRequests.add(in.readBoolean() ? new XCourseRequest(in) : new XFreeTimeRequest(in));
        }
        this.iStatus = (String)in.readObject();
        this.iEmail = (String)in.readObject();
        Date date = this.iEmailTimeStamp = in.readBoolean() ? new Date(in.readLong()) : null;
        if (in.readBoolean()) {
            this.iLastNote = new XStudentNote(in);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.iMajors.size());
        for (XAreaClassificationMajor major : this.iMajors) {
            major.writeExternal(out);
        }
        out.writeInt(this.iGroups.size());
        for (String group : this.iGroups) {
            out.writeObject(group);
        }
        out.writeInt(this.iAccomodations.size());
        for (String accomodation : this.iAccomodations) {
            out.writeObject(accomodation);
        }
        out.writeInt(this.iRequests.size());
        for (XRequest request : this.iRequests) {
            if (request instanceof XCourseRequest) {
                out.writeBoolean(true);
                ((XCourseRequest)request).writeExternal(out);
                continue;
            }
            out.writeBoolean(false);
            ((XFreeTimeRequest)request).writeExternal(out);
        }
        out.writeObject(this.iStatus);
        out.writeObject(this.iEmail);
        out.writeBoolean(this.iEmailTimeStamp != null);
        if (this.iEmailTimeStamp != null) {
            out.writeLong(this.iEmailTimeStamp.getTime());
        }
        out.writeBoolean(this.iLastNote != null);
        if (this.iLastNote != null) {
            this.iLastNote.writeExternal(out);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XStudentSerializer
    implements Externalizer<XStudent> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XStudent object) throws IOException {
            object.writeExternal(output);
        }

        public XStudent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XStudent(input);
        }
    }
}

