/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.studentsct.reservation.GroupReservation;
import org.cpsolver.studentsct.reservation.Reservation;
import org.cpsolver.studentsct.reservation.ReservationOverride;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.OverrideReservation;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XStudent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SerializeWith(value=XIndividualReservationSerializer.class)
public class XIndividualReservation
extends XReservation {
    private static final long serialVersionUID = 1L;
    private Set<Long> iStudentIds = new HashSet<Long>();
    private Integer iLimit = null;
    private Boolean iExpired = null;

    public XIndividualReservation() {
    }

    public XIndividualReservation(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XIndividualReservation(XOffering offering, IndividualReservation reservation) {
        super(XReservationType.Individual, offering, reservation);
        for (Student student : reservation.getStudents()) {
            this.iStudentIds.add(student.getUniqueId());
        }
    }

    public XIndividualReservation(XOffering offering, OverrideReservation reservation) {
        super(XReservationType.Override, offering, reservation);
        for (Student student : reservation.getStudents()) {
            this.iStudentIds.add(student.getUniqueId());
        }
        this.setMustBeUsed(reservation.getOverrideType().isMustBeUsed());
        this.setAllowOverlap(reservation.getOverrideType().isAllowTimeConflict());
        this.setCanAssignOverLimit(reservation.getOverrideType().isAllowOverLimit());
        this.iExpired = reservation.getOverrideType().isExpired();
    }

    public XIndividualReservation(org.cpsolver.studentsct.reservation.IndividualReservation reservation) {
        super(XReservationType.Individual, (Reservation)reservation);
        this.iStudentIds.addAll(reservation.getStudentIds());
    }

    public XIndividualReservation(ReservationOverride reservation) {
        super(XReservationType.Override, (Reservation)reservation);
        this.iStudentIds.addAll(reservation.getStudentIds());
    }

    public XIndividualReservation(GroupReservation reservation) {
        super(XReservationType.Group, (Reservation)reservation);
        this.iStudentIds.addAll(reservation.getStudentIds());
        this.iLimit = (int)Math.round(reservation.getReservationLimit());
    }

    @Override
    public boolean isApplicable(XStudent student, XCourseId course) {
        return this.iStudentIds.contains(student.getStudentId());
    }

    public Set<Long> getStudentIds() {
        return this.iStudentIds;
    }

    @Override
    public int getReservationLimit() {
        return this.iLimit == null ? this.iStudentIds.size() : this.iLimit.intValue();
    }

    @Override
    public boolean isExpired() {
        return this.getType() == XReservationType.Override && this.iExpired != null ? this.iExpired.booleanValue() : super.isExpired();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int nrStudents = in.readInt();
        this.iStudentIds.clear();
        for (int i = 0; i < nrStudents; ++i) {
            this.iStudentIds.add(in.readLong());
        }
        this.iLimit = in.readInt();
        if (this.iLimit == -2) {
            this.iLimit = null;
        }
        if (this.getType() == XReservationType.Override) {
            switch (in.readByte()) {
                case 0: {
                    this.iExpired = false;
                    break;
                }
                case 1: {
                    this.iExpired = true;
                    break;
                }
                default: {
                    this.iExpired = null;
                }
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.iStudentIds.size());
        for (Long studentId : this.iStudentIds) {
            out.writeLong(studentId);
        }
        out.writeInt(this.iLimit == null ? -2 : this.iLimit);
        if (this.getType() == XReservationType.Override) {
            out.writeByte(this.iExpired == null ? 2 : (this.iExpired != false ? 1 : 0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XIndividualReservationSerializer
    implements Externalizer<XIndividualReservation> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XIndividualReservation object) throws IOException {
            object.writeExternal(output);
        }

        public XIndividualReservation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XIndividualReservation(input);
        }
    }
}

