/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.studentsct.reservation.Reservation;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.CurriculumReservation;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XStudent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SerializeWith(value=XCurriculumReservationSerializer.class)
public class XCurriculumReservation
extends XReservation {
    private static final long serialVersionUID = 1L;
    private int iLimit;
    private String iAcadArea;
    private Set<String> iClassifications = new HashSet<String>();
    private Set<String> iMajors = new HashSet<String>();

    public XCurriculumReservation() {
    }

    public XCurriculumReservation(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XCurriculumReservation(XOffering offering, CurriculumReservation reservation) {
        super(XReservationType.Curriculum, offering, reservation);
        this.iLimit = reservation.getLimit() == null ? -1 : reservation.getLimit();
        this.iAcadArea = reservation.getArea().getAcademicAreaAbbreviation();
        for (AcademicClassification clasf : reservation.getClassifications()) {
            this.iClassifications.add(clasf.getCode());
        }
        for (PosMajor major : reservation.getMajors()) {
            this.iMajors.add(major.getCode());
        }
    }

    public XCurriculumReservation(org.cpsolver.studentsct.reservation.CurriculumReservation reservation) {
        super(XReservationType.Curriculum, (Reservation)reservation);
        this.iLimit = (int)Math.round(reservation.getReservationLimit());
        this.iAcadArea = reservation.getAcademicArea();
        if (reservation.getClassifications() != null) {
            this.iClassifications.addAll(reservation.getClassifications());
        }
        if (reservation.getMajors() != null) {
            this.iMajors.addAll(reservation.getMajors());
        }
    }

    @Override
    public int getReservationLimit() {
        return this.iLimit;
    }

    public String getAcademicArea() {
        return this.iAcadArea;
    }

    public Set<String> getMajors() {
        return this.iMajors;
    }

    public Set<String> getClassifications() {
        return this.iClassifications;
    }

    @Override
    public boolean isApplicable(XStudent student, XCourseId course) {
        for (XAreaClassificationMajor acm : student.getMajors()) {
            if (!this.getAcademicArea().equals(acm.getArea()) || !this.getClassifications().isEmpty() && !this.getClassifications().contains(acm.getClassification()) || !this.getMajors().isEmpty() && !this.getMajors().contains(acm.getMajor())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.iAcadArea = (String)in.readObject();
        int nrClassifications = in.readInt();
        this.iClassifications.clear();
        for (int i = 0; i < nrClassifications; ++i) {
            this.iClassifications.add((String)in.readObject());
        }
        int nrMajors = in.readInt();
        this.iMajors.clear();
        for (int i = 0; i < nrMajors; ++i) {
            this.iMajors.add((String)in.readObject());
        }
        this.iLimit = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.iAcadArea);
        out.writeInt(this.iClassifications.size());
        for (String clasf : this.iClassifications) {
            out.writeObject(clasf);
        }
        out.writeInt(this.iMajors.size());
        for (String major : this.iMajors) {
            out.writeObject(major);
        }
        out.writeInt(this.iLimit);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XCurriculumReservationSerializer
    implements Externalizer<XCurriculumReservation> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XCurriculumReservation object) throws IOException {
            object.writeExternal(output);
        }

        public XCurriculumReservation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XCurriculumReservation(input);
        }
    }
}

