/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.CourseCreditFormat;
import org.unitime.timetable.model.CourseCreditType;
import org.unitime.timetable.model.CourseCreditUnitType;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.DemandOfferingType;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.OfferingConsentType;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.PositionType;
import org.unitime.timetable.model.RefTableEntry;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomFeatureType;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseSavedHQL;
import org.unitime.timetable.model.dao.SavedHQLDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.UserQualifier;
import org.unitime.timetable.security.rights.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SavedHQL
extends BaseSavedHQL {
    private static final long serialVersionUID = 2532519378106863655L;

    public static void main(String[] args) {
        for (Flag f : Flag.values()) {
            System.out.println(f.name() + ": " + f.flag() + " (" + f.isSet(255) + ")");
        }
    }

    public boolean isSet(Flag f) {
        return this.getType() != null && f.isSet(this.getType());
    }

    public void set(Flag f) {
        if (!this.isSet(f)) {
            this.setType((this.getType() == null ? 0 : this.getType()) + f.flag());
        }
    }

    public void clear(Flag f) {
        if (this.isSet(f)) {
            this.setType(this.getType() - f.flag());
        }
    }

    public static List<SavedHQL> listAll(org.hibernate.Session hibSession, Flag appearance, boolean admin) {
        if (admin) {
            return (hibSession == null ? SavedHQLDAO.getInstance().getSession() : hibSession).createQuery("from SavedHQL q where bit_and(q.type, :flag) > 0 order by q.name").setInteger("flag", appearance.flag()).setCacheable(true).list();
        }
        return (hibSession == null ? SavedHQLDAO.getInstance().getSession() : hibSession).createQuery("from SavedHQL q where bit_and(q.type, :flag) > 0 and bit_and(q.type, :admin) = 0 order by q.name").setInteger("flag", appearance.flag()).setInteger("admin", Flag.ADMIN_ONLY.flag()).setCacheable(true).list();
    }

    public static boolean hasQueries(Flag appearance, boolean admin) {
        if (admin) {
            return ((Number)SavedHQLDAO.getInstance().getSession().createQuery("select count(q) from SavedHQL q where bit_and(q.type, :flag) > 0").setInteger("flag", appearance.flag()).setCacheable(true).uniqueResult()).intValue() > 0;
        }
        return ((Number)SavedHQLDAO.getInstance().getSession().createQuery("select count(q) from SavedHQL q where bit_and(q.type, :flag) > 0 and bit_and(q.type, :admin) = 0").setInteger("flag", appearance.flag()).setInteger("admin", Flag.ADMIN_ONLY.flag()).setCacheable(true).uniqueResult()).intValue() > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        SESSION("Academic Session", false, false, new OptionImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                Session session;
                Long sessionId = user.getCurrentAcademicSessionId();
                Session session2 = session = sessionId == null ? null : (Session)SessionDAO.getInstance().get(sessionId);
                if (session == null) {
                    return null;
                }
                Hashtable<Long, String> ret = new Hashtable<Long, String>();
                ret.put(session.getUniqueId(), session.getLabel());
                return ret;
            }

            @Override
            public Long lookupValue(UserContext user, String value) {
                return (Long)SessionDAO.getInstance().getSession().createQuery("select s.uniqueId from Session s where s.academicTerm || s.academicYear = :term or s.academicTerm || s.academicYear || s.academicInitiative = :term").setString("term", value).setMaxResults(1).uniqueResult();
            }
        }),
        DEPARTMENT("Department", true, false, new OptionImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                Session session;
                Long sessionId = user.getCurrentAcademicSessionId();
                Session session2 = session = sessionId == null ? null : (Session)SessionDAO.getInstance().get(sessionId);
                if (session == null) {
                    return null;
                }
                TimetableManager manager = TimetableManager.findByExternalId(user.getExternalUserId());
                if (manager == null) {
                    return null;
                }
                Hashtable<Long, String> ret = new Hashtable<Long, String>();
                for (Department d : Department.getUserDepartments(user)) {
                    ret.put(d.getUniqueId(), d.htmlLabel());
                }
                return ret;
            }

            @Override
            public Long lookupValue(UserContext user, String value) {
                for (Department d : Department.getUserDepartments(user)) {
                    if (!value.equalsIgnoreCase(d.getDeptCode())) continue;
                    return d.getUniqueId();
                }
                return null;
            }
        }),
        DEPARTMENTS("Departments", true, true, Option.DEPARTMENT.iImplementation),
        SUBJECT("Subject Area", true, false, new OptionImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                Hashtable<Long, String> ret = new Hashtable<Long, String>();
                try {
                    for (SubjectArea s : SubjectArea.getUserSubjectAreas(user)) {
                        ret.put(s.getUniqueId(), s.getSubjectAreaAbbreviation());
                    }
                }
                catch (Exception e) {
                    return null;
                }
                return ret;
            }

            @Override
            public Long lookupValue(UserContext user, String value) {
                for (SubjectArea s : SubjectArea.getUserSubjectAreas(user)) {
                    if (!value.equalsIgnoreCase(s.getSubjectAreaAbbreviation())) continue;
                    return s.getUniqueId();
                }
                return null;
            }
        }),
        SUBJECTS("Subject Areas", true, true, Option.SUBJECT.iImplementation),
        BUILDING("Building", true, false, new OptionImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                Long sessionId = user.getCurrentAcademicSessionId();
                Session session = sessionId == null ? null : (Session)SessionDAO.getInstance().get(sessionId);
                TimetableManager manager = TimetableManager.findByExternalId(user.getExternalUserId());
                if (manager == null) {
                    return null;
                }
                Hashtable<Long, String> ret = new Hashtable<Long, String>();
                for (Building b : Building.findAll(session.getUniqueId())) {
                    ret.put(b.getUniqueId(), b.getAbbrName());
                }
                return ret;
            }

            @Override
            public Long lookupValue(UserContext user, String value) {
                Map<Long, String> values = this.getValues(user);
                if (values != null) {
                    for (Map.Entry<Long, String> e : values.entrySet()) {
                        if (!value.equalsIgnoreCase(e.getValue())) continue;
                        return e.getKey();
                    }
                }
                return null;
            }
        }),
        BUILDINGS("Buildings", true, true, Option.BUILDING.iImplementation),
        ROOM("Room", true, false, new OptionImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                Long sessionId = user.getCurrentAcademicSessionId();
                Session session = sessionId == null ? null : (Session)SessionDAO.getInstance().get(sessionId);
                TimetableManager manager = TimetableManager.findByExternalId(user.getExternalUserId());
                if (manager == null) {
                    return null;
                }
                Hashtable<Long, String> ret = new Hashtable<Long, String>();
                for (Room r : Room.findAllRooms(session.getUniqueId())) {
                    ret.put(r.getUniqueId(), r.getLabel());
                }
                return ret;
            }

            @Override
            public Long lookupValue(UserContext user, String value) {
                Map<Long, String> values = this.getValues(user);
                if (values != null) {
                    for (Map.Entry<Long, String> e : values.entrySet()) {
                        if (!value.equalsIgnoreCase(e.getValue())) continue;
                        return e.getKey();
                    }
                }
                return null;
            }
        }),
        ROOMS("Rooms", true, true, Option.ROOM.iImplementation),
        PITD("Point In Time Data", true, false, new OptionImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                Session session;
                Long sessionId = user.getCurrentAcademicSessionId();
                Session session2 = session = sessionId == null ? null : (Session)SessionDAO.getInstance().get(sessionId);
                if (session == null) {
                    return null;
                }
                ArrayList<PointInTimeData> pitdList = PointInTimeData.findAllSavedSuccessfullyForSession(sessionId);
                Hashtable<Long, String> ret = new Hashtable<Long, String>();
                for (PointInTimeData pitd : pitdList) {
                    ret.put(pitd.getUniqueId(), pitd.getName());
                }
                return ret;
            }

            @Override
            public Long lookupValue(UserContext user, String value) {
                Map<Long, String> values = this.getValues(user);
                if (values != null) {
                    for (Map.Entry<Long, String> e : values.entrySet()) {
                        if (!value.equalsIgnoreCase(e.getValue())) continue;
                        return e.getKey();
                    }
                }
                return null;
            }
        }),
        SESSIONS("Academic Sessions", true, true, new OptionImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                Hashtable<Long, String> ret = new Hashtable<Long, String>();
                for (UserAuthority userAuthority : user.getAuthorities(user.getCurrentAuthority().getRole(), new Qualifiable[0])) {
                    UserQualifier session = userAuthority.getAcademicSession();
                    if (session == null) continue;
                    ret.put((Long)session.getQualifierId(), session.getQualifierLabel());
                }
                return ret;
            }

            @Override
            public Long lookupValue(UserContext user, String value) {
                return (Long)SessionDAO.getInstance().getSession().createQuery("select s.uniqueId from Session s where s.academicTerm || s.academicYear = :term or s.academicTerm || s.academicYear || s.academicInitiative = :term").setString("term", value).setMaxResults(1).uniqueResult();
            }
        }),
        DistributionType(DistributionType.class, false),
        DistributionTypes(DistributionType.class, true),
        DemandOfferingType(DemandOfferingType.class, false),
        DemandOfferingTypes(DemandOfferingType.class, true),
        OfferingConsentType(OfferingConsentType.class, false),
        OfferingConsentTypes(OfferingConsentType.class, true),
        CourseCreditFormat(CourseCreditFormat.class, false),
        CourseCreditFormats(CourseCreditFormat.class, true),
        CourseCreditType(CourseCreditType.class, false),
        CourseCreditTypes(CourseCreditType.class, true),
        CourseCreditUnitType(CourseCreditUnitType.class, false),
        CourseCreditUnitTypes(CourseCreditUnitType.class, true),
        PositionType(PositionType.class, false),
        PositionTypes(PositionType.class, true),
        DepartmentStatusType(DepartmentStatusType.class, false),
        DepartmentStatusTypes(DepartmentStatusType.class, true),
        RoomType(RoomType.class, false),
        RoomTypes(RoomType.class, true),
        StudentSectioningStatus(StudentSectioningStatus.class, false),
        StudentSectioningStatuses(StudentSectioningStatus.class, true),
        ExamType(ExamType.class, false),
        ExamTypes(ExamType.class, true),
        RoomFeatureType(RoomFeatureType.class, false),
        RoomFeatureTypes(RoomFeatureType.class, true),
        CourseType(CourseType.class, false),
        CourseTypes(CourseType.class, true);

        String iName;
        OptionImplementation iImplementation;
        boolean iAllowSelection;
        boolean iMultiSelect;

        private Option(String name, boolean allowSelection, boolean multiSelect, OptionImplementation impl) {
            this.iName = name;
            this.iAllowSelection = allowSelection;
            this.iMultiSelect = multiSelect;
            this.iImplementation = impl;
        }

        private Option(Class<? extends RefTableEntry> reference, boolean multiSelect) {
            this.iName = this.name().replaceAll("(?<=[^A-Z])([A-Z])", " $1");
            this.iAllowSelection = true;
            this.iMultiSelect = multiSelect;
            this.iImplementation = new RefTableOptions(reference);
        }

        public String text() {
            return this.iName;
        }

        public boolean allowSingleSelection() {
            return this.iAllowSelection;
        }

        public boolean allowMultiSelection() {
            return this.iAllowSelection && this.iMultiSelect;
        }

        public Map<Long, String> values(UserContext user) {
            return this.iImplementation.getValues(user);
        }

        public Long lookupValue(UserContext user, String value) {
            return this.iImplementation.lookupValue(user, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RefTableOptions
    implements OptionImplementation {
        private Class<? extends RefTableEntry> iReference;

        RefTableOptions(Class<? extends RefTableEntry> reference) {
            this.iReference = reference;
        }

        @Override
        public Map<Long, String> getValues(UserContext user) {
            Hashtable<Long, String> ret = new Hashtable<Long, String>();
            for (RefTableEntry ref : SessionDAO.getInstance().getSession().createCriteria(this.iReference).setCacheable(true).list()) {
                ret.put(ref.getUniqueId(), ref.getLabel());
            }
            return ret;
        }

        @Override
        public Long lookupValue(UserContext user, String value) {
            for (RefTableEntry ref : SessionDAO.getInstance().getSession().createCriteria(this.iReference).setCacheable(true).list()) {
                if (!value.equalsIgnoreCase(ref.getReference())) continue;
                return ref.getUniqueId();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface OptionImplementation {
        public Map<Long, String> getValues(UserContext var1);

        public Long lookupValue(UserContext var1, String var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        APPEARANCE_COURSES("Appearance: Courses", Right.HQLReportsCourses, "courses"),
        APPEARANCE_EXAMS("Appearance: Examinations", Right.HQLReportsExaminations, "exams"),
        APPEARANCE_SECTIONING("Appearance: Student Sectioning", Right.HQLReportsStudents, "sectioning"),
        APPEARANCE_EVENTS("Appearance: Events", Right.HQLReportsEvents, "events"),
        APPEARANCE_ADMINISTRATION("Appearance: Administration", Right.HQLReportsAdministration, "administration"),
        ADMIN_ONLY("Restrictions: Administrator Only", Right.HQLReportsAdminOnly);

        private String iDescription;
        private String iAppearance;
        private Right iRight;

        private Flag(String desc, Right right, String appearance) {
            this.iDescription = desc;
            this.iRight = right;
            this.iAppearance = appearance;
        }

        private Flag(String desc, Right right) {
            this(desc, right, null);
        }

        public int flag() {
            return 1 << this.ordinal();
        }

        public boolean isSet(int type) {
            return (type & this.flag()) != 0;
        }

        public String description() {
            return this.iDescription;
        }

        public String getAppearance() {
            return this.iAppearance;
        }

        public Right getPermission() {
            return this.iRight;
        }
    }
}

