/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.ExternalBuilding;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseBuilding;
import org.unitime.timetable.model.dao.BuildingDAO;
import org.unitime.timetable.model.dao.RoomDAO;
import org.unitime.timetable.server.rooms.RoomDetailsBackend;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Building
extends BaseBuilding
implements Comparable {
    private static final long serialVersionUID = 3256440313428981557L;
    public static String BLDG_LIST_ATTR_NAME = "bldgsList";

    public Building() {
    }

    public Building(Long uniqueId) {
        super(uniqueId);
    }

    public String getAbbrName() {
        return this.getAbbreviation() + " - " + this.getName();
    }

    public void setAbbrName(String abbrName) {
    }

    @Override
    public String toString() {
        return this.getAbbrName();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof Building)) {
            return -1;
        }
        Building b = (Building)o;
        int cmp = this.getAbbreviation().compareTo(b.getAbbreviation());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(b.getUniqueId() == null ? -1L : b.getUniqueId());
    }

    public static Building findByBldgAbbv(String bldgAbbv, Long sessionId) {
        List bldgs = new BuildingDAO().getQuery("SELECT distinct b FROM Building b WHERE b.session.uniqueId=:sessionId AND b.abbreviation=:bldgAbbv").setLong("sessionId", sessionId.longValue()).setString("bldgAbbv", bldgAbbv).list();
        if (!bldgs.isEmpty()) {
            return (Building)bldgs.get(0);
        }
        return null;
    }

    public static Building findByName(String name, Long sessionId) {
        return (Building)new BuildingDAO().getSession().createQuery("select b from Building b where b.session.uniqueId=:sessionId and b.name=:name").setLong("sessionId", sessionId.longValue()).setString("name", name).uniqueResult();
    }

    public static void updateBuildings(Long sessionId) {
        Session currentSession = Session.getSessionById(sessionId);
        TreeSet<Building> currentBuildings = new TreeSet<Building>(currentSession.getBuildings());
        Hashtable updateBuildings = ExternalBuilding.getBuildings(sessionId);
        Iterator<Building> b = currentBuildings.iterator();
        BuildingDAO bldgDAO = new BuildingDAO();
        while (b.hasNext()) {
            Building bldg = b.next();
            String externalUniqueId = bldg.getExternalUniqueId();
            if (externalUniqueId == null) continue;
            ExternalBuilding extBldg = (ExternalBuilding)updateBuildings.get(externalUniqueId);
            if (extBldg != null) {
                if (Building.updateBldgInfo(bldg, extBldg)) {
                    bldgDAO.update(bldg);
                }
                updateBuildings.remove(extBldg.getExternalUniqueId());
                continue;
            }
            if (!Building.checkBuildingDelete(bldg)) continue;
            currentSession.getBuildings().remove(bldg);
            bldgDAO.delete(bldg);
        }
        for (ExternalBuilding extBldg : updateBuildings.values()) {
            Building newBldg = new Building();
            newBldg.setAbbreviation(extBldg.getAbbreviation());
            newBldg.setCoordinateX(extBldg.getCoordinateX());
            newBldg.setCoordinateY(extBldg.getCoordinateY());
            newBldg.setName(extBldg.getDisplayName());
            newBldg.setSession(currentSession);
            newBldg.setExternalUniqueId(extBldg.getExternalUniqueId());
            bldgDAO.save(newBldg);
        }
    }

    private static boolean updateBldgInfo(Building bldg, ExternalBuilding extBldg) {
        boolean updated = false;
        if (!bldg.getAbbreviation().equals(extBldg.getAbbreviation())) {
            bldg.setAbbreviation(extBldg.getAbbreviation());
            updated = true;
        }
        if (!bldg.getName().equals(extBldg.getDisplayName())) {
            bldg.setName(extBldg.getDisplayName());
            updated = true;
        }
        if (!ToolBox.equals((Object)bldg.getCoordinateX(), (Object)extBldg.getCoordinateX())) {
            bldg.setCoordinateX(extBldg.getCoordinateX());
            updated = true;
        }
        if (!ToolBox.equals((Object)bldg.getCoordinateY(), (Object)extBldg.getCoordinateY())) {
            bldg.setCoordinateY(extBldg.getCoordinateY());
            updated = true;
        }
        return updated;
    }

    private static boolean checkBuildingDelete(Building bldg) {
        boolean result = false;
        List rooms = new RoomDAO().getQuery("from Room as rm where rm.building.uniqueId = " + bldg.getUniqueId()).list();
        if (rooms.isEmpty()) {
            result = true;
        }
        return result;
    }

    public Object clone() {
        Building b = new Building();
        b.setAbbreviation(this.getAbbreviation());
        b.setCoordinateX(this.getCoordinateX());
        b.setCoordinateY(this.getCoordinateY());
        b.setExternalUniqueId(this.getExternalUniqueId());
        b.setName(this.getName());
        b.setSession(this.getSession());
        return b;
    }

    public Building findSameBuildingInSession(Session newSession) throws Exception {
        if (newSession == null) {
            return null;
        }
        Building newBuilding = Building.findByBldgAbbv(this.getAbbreviation(), newSession.getUniqueId());
        if (newBuilding == null && this.getExternalUniqueId() != null) {
            newBuilding = Building.findByExternalIdAndSession(this.getExternalUniqueId(), newSession);
        }
        return newBuilding;
    }

    public static Building findByExternalIdAndSession(String externalId, Session session) {
        return Building.findByExternalIdAndSession(externalId, session.getUniqueId());
    }

    public static Building findByExternalIdAndSession(String externalId, Long sessionId) {
        BuildingDAO bDao = new BuildingDAO();
        List bldgs = bDao.getSession().createCriteria(Building.class).add((Criterion)Restrictions.eq((String)"externalUniqueId", (Object)externalId)).add((Criterion)Restrictions.eq((String)"session.uniqueId", (Object)sessionId)).setCacheable(true).list();
        if (bldgs != null && bldgs.size() == 1) {
            return (Building)bldgs.get(0);
        }
        return null;
    }

    public static List<Building> findAll(Long sessionId) {
        return new BuildingDAO().getSession().createQuery("select b from Building b where b.session.uniqueId=:sessionId order by b.abbreviation").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
    }

    @Deprecated
    public String getHtmlHint() {
        String hint = this.getName();
        String minimap = ApplicationProperty.RoomHintMinimapUrl.value();
        if (minimap != null && this.getCoordinateX() != null && this.getCoordinateY() != null) {
            minimap = minimap.replace("%x", this.getCoordinateX().toString()).replace("%y", this.getCoordinateY().toString()).replace("%n", this.getAbbreviation()).replace("%i", this.getExternalUniqueId() == null ? "" : this.getExternalUniqueId());
            String apikey = ApplicationProperty.RoomMapStaticApiKey.value();
            if (apikey != null && !apikey.isEmpty()) {
                minimap = minimap + "&key=" + apikey;
                String secret = ApplicationProperty.RoomMapStaticSecret.value();
                if (secret != null && !secret.isEmpty()) {
                    try {
                        minimap = minimap + "&signature=" + new RoomDetailsBackend.UrlSigner(secret).signRequest(minimap);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            hint = hint + "<br><img src=\\'" + minimap + "\\' border=\\'0\\' style=\\'border: 1px solid #9CB0CE;\\'/>";
        }
        return hint;
    }
}

