/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.hibernate.Hibernate;
import org.hibernate.LazyInitializationException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.AssignmentInfo;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.ConstraintInfo;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.ExactTimeMins;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.SolverInfoDef;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.base.BaseAssignment;
import org.unitime.timetable.model.dao.AssignmentDAO;
import org.unitime.timetable.model.dao.AssignmentInfoDAO;
import org.unitime.timetable.model.dao.ConstraintInfoDAO;
import org.unitime.timetable.solver.ui.TimetableInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.duration.DurationModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assignment
extends BaseAssignment {
    private static final long serialVersionUID = 1L;
    public transient Hashtable iAssignmentInfoCache = new Hashtable();
    public transient Hashtable iConstraintInfoCache = new Hashtable();
    private int iSlotsPerMtg = -1;
    private int iBreakTime = -1;
    private transient TimeLocation iTimeLocation = null;
    private transient Placement iPlacement = null;

    public Assignment() {
    }

    public Assignment(Long uniqueId) {
        super(uniqueId);
    }

    public int[] getStartSlots() {
        int[] ret = new int[this.getTimePattern().getNrMeetings().intValue()];
        int idx = 0;
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            if ((this.getDays() & Constants.DAY_CODES[i]) == 0) continue;
            ret[idx++] = this.getStartSlot() + i * 288;
        }
        return ret;
    }

    public Vector getStartSlotsVect() {
        Vector<Integer> ret = new Vector<Integer>();
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            if ((this.getDays() & Constants.DAY_CODES[i]) == 0) continue;
            ret.addElement(new Integer(this.getStartSlot() + i * 288));
        }
        return ret;
    }

    public TimetableInfo getAssignmentInfo(String name) {
        TimetableInfo tInfo = (TimetableInfo)this.iAssignmentInfoCache.get(name);
        if (tInfo == null) {
            try {
                for (AssignmentInfo info : this.getAssignmentInfo()) {
                    if (info.getDefinition() == null || !info.getDefinition().getName().equals(name)) continue;
                    tInfo = info.getInfo();
                    break;
                }
            }
            catch (LazyInitializationException e) {
                Session session = new AssignmentInfoDAO().getSession();
                SolverInfoDef def = SolverInfoDef.findByName(session, name);
                if (def == null) {
                    return null;
                }
                AssignmentInfo info = (AssignmentInfo)session.createCriteria(AssignmentInfo.class).add((Criterion)Restrictions.eq((String)"definition", (Object)def)).add((Criterion)Restrictions.eq((String)"assignment", (Object)this)).uniqueResult();
                if (info == null) {
                    return null;
                }
                tInfo = info.getInfo();
            }
            if (tInfo != null) {
                this.iAssignmentInfoCache.put(name, tInfo);
            }
        }
        return tInfo;
    }

    public void cleastAssignmentInfoCache() {
        this.iAssignmentInfoCache.clear();
    }

    public TimetableInfo getConstraintInfo(String name) {
        Vector infos = this.getConstraintInfos(name);
        if (infos == null || infos.isEmpty()) {
            return null;
        }
        return (TimetableInfo)infos.firstElement();
    }

    public Vector getConstraintInfos(String name) {
        Vector<TimetableInfo> tInfos = (Vector<TimetableInfo>)this.iConstraintInfoCache.get(name);
        if (tInfos == null) {
            try {
                tInfos = new Vector<TimetableInfo>();
                for (ConstraintInfo info : this.getConstraintInfo()) {
                    TimetableInfo tInfo;
                    if (info.getDefinition() == null || !info.getDefinition().getName().equals(name) || (tInfo = info.getInfo()) == null) continue;
                    tInfos.add(tInfo);
                }
            }
            catch (LazyInitializationException e) {
                Session session = new ConstraintInfoDAO().getSession();
                Query q = session.createQuery("select distinct c from ConstraintInfo as c inner join c.assignments as a where c.definition.name=:name and a.uniqueId=:assignmentId");
                q.setLong("assignmentId", this.getUniqueId().longValue());
                q.setString("name", name);
                tInfos = new Vector();
                for (ConstraintInfo info : q.list()) {
                    TimetableInfo tInfo = info.getInfo();
                    if (tInfo == null) continue;
                    tInfos.add(tInfo);
                }
            }
            if (tInfos != null) {
                this.iConstraintInfoCache.put(name, tInfos);
            }
        }
        return tInfos;
    }

    public Hashtable getConstraintInfoTable(String name) {
        Hashtable<ConstraintInfo, TimetableInfo> ret = new Hashtable<ConstraintInfo, TimetableInfo>();
        try {
            for (ConstraintInfo info : this.getConstraintInfo()) {
                TimetableInfo tInfo;
                if (info.getDefinition() == null || !info.getDefinition().getName().equals(name) || (tInfo = info.getInfo()) == null) continue;
                ret.put(info, tInfo);
            }
        }
        catch (LazyInitializationException e) {
            Session session = new ConstraintInfoDAO().getSession();
            Query q = session.createQuery("select distinct c from ConstraintInfo as c inner join c.assignments as a where c.definition.name=:name and a.uniqueId=:assignmentId");
            q.setLong("assignmentId", this.getUniqueId().longValue());
            q.setString("name", name);
            for (ConstraintInfo info : q.list()) {
                TimetableInfo tInfo = info.getInfo();
                if (tInfo == null) continue;
                ret.put(info, tInfo);
            }
        }
        return ret;
    }

    public void setSlotsPerMtg(int slotsPerMtg) {
        this.iSlotsPerMtg = slotsPerMtg;
    }

    public int getSlotPerMtg() {
        if (this.iSlotsPerMtg >= 0) {
            return this.iSlotsPerMtg;
        }
        TimePattern pattern = this.getTimePattern();
        this.iSlotsPerMtg = pattern.getSlotsPerMtg();
        if (pattern.getType() == 5) {
            DurationModel dm = this.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
            int minsPerMeeting = dm.getExactTimeMinutesPerMeeting(this.getClazz().getSchedulingSubpart().getMinutesPerWk(), this.getDatePattern(), this.getDays());
            this.iSlotsPerMtg = ExactTimeMins.getNrSlotsPerMtg(minsPerMeeting);
        }
        return this.iSlotsPerMtg;
    }

    public void setBreakTime(int breakTime) {
        this.iBreakTime = breakTime;
    }

    public int getBreakTime() {
        if (this.iBreakTime >= 0) {
            return this.iBreakTime;
        }
        TimePattern pattern = this.getTimePattern();
        this.iBreakTime = pattern.getBreakTime();
        if (pattern.getType() == 5) {
            DurationModel dm = this.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
            int minsPerMeeting = dm.getExactTimeMinutesPerMeeting(this.getClazz().getSchedulingSubpart().getMinutesPerWk(), this.getDatePattern(), this.getDays());
            this.iBreakTime = ExactTimeMins.getBreakTime(minsPerMeeting);
        }
        return this.iBreakTime;
    }

    public TimeLocation getTimeLocation() {
        if (this.iPlacement != null) {
            return this.iPlacement.getTimeLocation();
        }
        if (this.iTimeLocation == null) {
            DatePattern datePattern = this.getDatePattern();
            this.iTimeLocation = new TimeLocation(this.getDays().intValue(), this.getStartSlot().intValue(), this.getSlotPerMtg(), 0, 0.0, datePattern == null ? null : datePattern.getUniqueId(), datePattern == null ? "?" : datePattern.getName(), datePattern == null ? new BitSet() : datePattern.getPatternBitSet(), this.getBreakTime());
            this.iTimeLocation.setTimePatternId(this.getTimePattern().getUniqueId());
        }
        return this.iTimeLocation;
    }

    public Vector getRoomLocations() {
        Vector<RoomLocation> ret = new Vector<RoomLocation>();
        for (Location room : this.getRooms()) {
            RoomLocation roomLocation = new RoomLocation(room.getUniqueId(), room.getLabel(), room instanceof Room ? ((Room)room).getBuilding().getUniqueId() : null, 0, room.getCapacity().intValue(), room.getCoordinateX(), room.getCoordinateY(), room.isIgnoreTooFar().booleanValue(), null);
            ret.addElement(roomLocation);
        }
        return ret;
    }

    public Placement getPlacement() {
        if (this.iPlacement != null) {
            return this.iPlacement;
        }
        TimeLocation timeLocation = this.getTimeLocation();
        Vector<TimeLocation> timeLocations = new Vector<TimeLocation>(1);
        timeLocations.addElement(timeLocation);
        Vector roomLocations = this.getRoomLocations();
        Lecture lecture = new Lecture(this.getClassId(), this.getSolution() == null || this.getSolution().getOwner() == null ? null : this.getSolution().getOwner().getUniqueId(), this.getClazz() == null ? null : this.getClazz().getSchedulingSubpart().getUniqueId(), this.getClassName(), timeLocations, (List)roomLocations, roomLocations.size(), new Placement(null, timeLocation, (List)roomLocations), this.getClazz() == null ? 0 : this.getClazz().getExpectedCapacity(), this.getClazz() == null ? 0 : this.getClazz().getMaxExpectedCapacity(), (double)(this.getClazz() == null ? 1.0f : this.getClazz().getRoomRatio().floatValue()));
        if (this.getClazz() != null) {
            lecture.setNote(this.getClazz().getNotes());
        }
        this.iPlacement = (Placement)lecture.getInitialAssignment();
        this.iPlacement.setVariable((Variable)lecture);
        this.iPlacement.setAssignmentId(this.getUniqueId());
        lecture.setBestAssignment((Value)this.iPlacement, 0L);
        if (this.getSolution() != null && this.getSolution().isCommited() != null) {
            lecture.setCommitted(this.getSolution().isCommited().booleanValue());
        }
        this.iPlacement.setAssignment((Object)this);
        return this.iPlacement;
    }

    @Override
    public String toString() {
        return this.getClassName() + " " + this.getPlacement().getName();
    }

    @Override
    public DatePattern getDatePattern() {
        DatePattern dp = super.getDatePattern();
        if (dp != null && !Hibernate.isInitialized((Object)dp.getSession())) {
            return (DatePattern)AssignmentDAO.getInstance().getSession().merge((Object)dp);
        }
        if (dp == null && this.getClazz() != null) {
            dp = this.getClazz().effectiveDatePattern();
        }
        return dp;
    }

    @Override
    public String getClassName() {
        if (super.getClassName() != null) {
            return super.getClassName();
        }
        return this.getClazz().getClassLabel(ApplicationProperty.SolverShowClassSufix.isTrue(), ApplicationProperty.SolverShowConfiguratioName.isTrue());
    }

    public String getClassName(boolean showSuffix) {
        return this.getClazz().getClassLabel(showSuffix);
    }

    @Override
    public Set<Location> getRooms() {
        try {
            return super.getRooms();
        }
        catch (LazyInitializationException e) {
            new AssignmentDAO().getSession().merge((Object)this);
            return super.getRooms();
        }
    }

    public static double getDistance(Assignment a1, Assignment a2) {
        double dist = 0.0;
        for (Location r1 : a1.getRooms()) {
            for (Location r2 : a2.getRooms()) {
                dist = Math.max(dist, r1.getDistance(r2));
            }
        }
        return dist;
    }

    public boolean isInConflict(Assignment other) {
        return Assignment.isInConflict(this, other, true);
    }

    public static boolean isInConflict(Assignment a1, Assignment a2, boolean useDistances) {
        TimeLocation t2;
        if (a1 == null || a2 == null) {
            return false;
        }
        TimeLocation t1 = a1.getTimeLocation();
        if (!t1.shareDays(t2 = a2.getTimeLocation())) {
            return false;
        }
        if (!t1.shareWeeks(t2)) {
            return false;
        }
        if (t1.shareHours(t2)) {
            return true;
        }
        if (!useDistances) {
            return false;
        }
        int s1 = t1.getStartSlot();
        int s2 = t2.getStartSlot();
        if (s1 + t1.getNrSlotsPerMeeting() != s2 && s2 + t2.getNrSlotsPerMeeting() != s1) {
            return false;
        }
        double distance = Assignment.getDistance(a1, a2);
        if (distance <= a1.getSolution().getProperties().getPropertyDouble("Student.DistanceLimit", 67.0)) {
            return false;
        }
        return !(distance <= a1.getSolution().getProperties().getPropertyDouble("Student.DistanceLimit75min", 100.0)) || (t1.getLength() != 18 || s1 + t1.getLength() != s2) && (t2.getLength() != 18 || s2 + t2.getLength() != s1);
    }

    public int getMinutesPerMeeting() {
        TimePattern pattern = this.getTimePattern();
        if (pattern.getType() == 5) {
            DurationModel dm = this.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
            return dm.getExactTimeMinutesPerMeeting(this.getClazz().getSchedulingSubpart().getMinutesPerWk(), this.getDatePattern(), this.getDays());
        }
        return pattern.getMinPerMtg();
    }

    public ClassEvent generateCommittedEvent(ClassEvent event, boolean createNoRoomMeetings) {
        Class_ clazz = this.getClazz();
        if (event == null) {
            event = new ClassEvent();
            event.setClazz(clazz);
            clazz.setEvent(event);
            if (this.getClazz().getSession().getStatusType().isTestSession()) {
                return null;
            }
        }
        event.setEventName(this.getClassName());
        event.setMinCapacity(clazz.getClassLimit(this));
        event.setMaxCapacity(clazz.getClassLimit(this));
        boolean changePast = ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue();
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date today = cal.getTime();
        if (event.getMeetings() != null) {
            if (changePast) {
                event.getMeetings().clear();
            } else {
                Iterator<Meeting> i = event.getMeetings().iterator();
                while (i.hasNext()) {
                    if (i.next().getMeetingDate().before(today)) continue;
                    i.remove();
                }
            }
        } else {
            event.setMeetings(new HashSet<Meeting>());
        }
        DurationModel dm = this.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
        TimeLocation time = this.getTimeLocation();
        for (Date meetingDate : dm.getDates(clazz.getSchedulingSubpart().getMinutesPerWk(), this.getDatePattern(), time.getDayCode(), this.getMinutesPerMeeting())) {
            if (!changePast && meetingDate.before(today)) continue;
            boolean created = false;
            for (Location location : this.getRooms()) {
                if (location.getPermanentId() == null) continue;
                Meeting m = new Meeting();
                m.setMeetingDate(meetingDate);
                m.setStartPeriod(time.getStartSlot());
                m.setStartOffset(0);
                m.setStopPeriod(time.getStartSlot() + time.getLength());
                m.setStopOffset(-time.getBreakTime());
                m.setClassCanOverride(false);
                m.setLocationPermanentId(location.getPermanentId());
                m.setStatus(Meeting.Status.APPROVED);
                m.setApprovalDate(this.getSolution().getCommitDate());
                m.setEvent(event);
                event.getMeetings().add(m);
                created = true;
            }
            if (created || !createNoRoomMeetings) continue;
            Meeting m = new Meeting();
            m.setMeetingDate(meetingDate);
            m.setStartPeriod(time.getStartSlot());
            m.setStartOffset(0);
            m.setStopPeriod(time.getStartSlot() + time.getLength());
            m.setStopOffset(-time.getBreakTime());
            m.setClassCanOverride(false);
            m.setLocationPermanentId(null);
            m.setStatus(Meeting.Status.APPROVED);
            m.setApprovalDate(this.getSolution().getCommitDate());
            m.setEvent(event);
            event.getMeetings().add(m);
        }
        return event;
    }

    public boolean shareDays(Assignment another) {
        return (this.getDays() & another.getDays()) != 0;
    }

    public boolean shareHours(Assignment another) {
        return this.getStartSlot() + this.getSlotPerMtg() > another.getStartSlot() && another.getStartSlot() + another.getSlotPerMtg() > this.getStartSlot();
    }

    public boolean shareWeeks(Assignment another) {
        return this.getDatePattern() == null || another.getDatePattern() == null || this.getDatePattern().getPatternBitSet().intersects(another.getDatePattern().getPatternBitSet());
    }

    public boolean overlaps(Assignment another) {
        return this.shareDays(another) && this.shareHours(another) && this.shareWeeks(another);
    }
}

