/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver;

import com.google.gwt.user.client.Cookies;
import java.util.Date;
import org.unitime.timetable.gwt.shared.SolverInterface;

public class SolverCookie {
    private static SolverCookie sInstance = null;
    private int iLogLevel = SolverInterface.ProgressLogLevel.INFO.ordinal();
    private boolean iTimeGridFilter = true;
    private boolean iAssignedClassesFilter = true;
    private int iAssignedClassesSort = 0;
    private boolean iNotAssignedClassesFilter = true;
    private int iNotAssignedClassesSort = 0;

    private SolverCookie() {
        try {
            String cookie = Cookies.getCookie((String)"UniTime:Solver");
            if (cookie != null) {
                String[] params = cookie.split("\\|");
                int idx = 0;
                this.iLogLevel = Integer.valueOf(params[idx++]);
                this.iTimeGridFilter = "1".equals(params[idx++]);
                this.iAssignedClassesFilter = "1".equals(params[idx++]);
                this.iAssignedClassesSort = Integer.parseInt(params[idx++]);
                this.iNotAssignedClassesFilter = "1".equals(params[idx++]);
                this.iNotAssignedClassesSort = Integer.parseInt(params[idx++]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void save() {
        String cookie = this.iLogLevel + "|" + (this.iTimeGridFilter ? "1" : "0") + "|" + (this.iAssignedClassesFilter ? "1" : "0") + "|" + this.iAssignedClassesSort + "|" + (this.iNotAssignedClassesFilter ? "1" : "0") + "|" + this.iNotAssignedClassesSort;
        Date expires = new Date(new Date().getTime() + 604800000L);
        Cookies.setCookie((String)"UniTime:Solver", (String)cookie, (Date)expires);
    }

    public static SolverCookie getInstance() {
        if (sInstance == null) {
            sInstance = new SolverCookie();
        }
        return sInstance;
    }

    public int getLogLevel() {
        return this.iLogLevel;
    }

    public void setLogLevel(int level) {
        this.iLogLevel = level;
        this.save();
    }

    public boolean isTimeGridFilter() {
        return this.iTimeGridFilter;
    }

    public void setTimeGridFilter(boolean filter) {
        this.iTimeGridFilter = filter;
        this.save();
    }

    public boolean isAssignedClassesFilter() {
        return this.iAssignedClassesFilter;
    }

    public void setAssignedClassesFilter(boolean filter) {
        this.iAssignedClassesFilter = filter;
        this.save();
    }

    public int getAssignedClassesSort() {
        return this.iAssignedClassesSort;
    }

    public void setAssignedClassesSort(int sort) {
        this.iAssignedClassesSort = sort;
        this.save();
    }

    public boolean isNotAssignedClassesFilter() {
        return this.iNotAssignedClassesFilter;
    }

    public void setNotAssignedClassesFilter(boolean filter) {
        this.iNotAssignedClassesFilter = filter;
        this.save();
    }

    public int getNotAssignedClassesSort() {
        return this.iNotAssignedClassesSort;
    }

    public void setNotAssignedClassesSort(int sort) {
        this.iNotAssignedClassesSort = sort;
        this.save();
    }
}

