/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.unitime.timetable.gwt.client.aria.AriaCheckBox;
import org.unitime.timetable.gwt.client.aria.ImageButton;
import org.unitime.timetable.gwt.client.widgets.CourseFinder;
import org.unitime.timetable.gwt.client.widgets.CourseFinderClasses;
import org.unitime.timetable.gwt.client.widgets.CourseFinderCourses;
import org.unitime.timetable.gwt.client.widgets.CourseFinderDetails;
import org.unitime.timetable.gwt.client.widgets.CourseFinderDialog;
import org.unitime.timetable.gwt.client.widgets.CourseFinderFactory;
import org.unitime.timetable.gwt.client.widgets.CourseFinderFreeTime;
import org.unitime.timetable.gwt.client.widgets.CourseRequestBox;
import org.unitime.timetable.gwt.client.widgets.CourseSelection;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionEvent;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionHandler;
import org.unitime.timetable.gwt.client.widgets.DataProvider;
import org.unitime.timetable.gwt.client.widgets.FreeTimeParser;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.Validator;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseRequestLine
extends P
implements HasValue<CourseRequestInterface.Request> {
    protected static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    protected static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    protected static final SectioningServiceAsync sSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    private boolean iAlternate;
    private int iPriority;
    private AcademicSessionProvider iSessionProvider;
    private List<CourseSelectionBox> iCourses = new ArrayList<CourseSelectionBox>();
    private AriaCheckBox iWaitList = null;
    private CourseRequestLine iPrevious = null;
    private CourseRequestLine iNext = null;
    private Validator<CourseSelection> iValidator = null;
    private boolean iArrowsVisible = true;

    public CourseRequestLine(AcademicSessionProvider session, int priority, boolean alternate, Validator<CourseSelection> validator) {
        super("unitime-CourseRequestLine");
        this.iSessionProvider = session;
        this.iValidator = validator;
        this.iPriority = priority;
        this.iAlternate = alternate;
        P line = new P("line");
        if (alternate) {
            line.addStyleName("alternative");
        }
        P title = new P("title");
        title.setText(alternate ? MESSAGES.courseRequestsAlternate(priority + 1) : MESSAGES.courseRequestsPriority(priority + 1));
        line.add((Widget)title);
        CourseSelectionBox box = new CourseSelectionBox(!alternate, false);
        if (alternate) {
            box.setLabel(ARIA.titleRequestedAlternate(1 + priority, String.valueOf((char)(97 + priority))), ARIA.altRequestedAlternateFinder(1 + priority));
            box.setAccessKey((char)(97 + priority));
        } else {
            box.setLabel(ARIA.titleRequestedCourse(1 + priority), ARIA.altRequestedCourseFinder(1 + priority));
            if (priority < 9) {
                box.setAccessKey((char)(49 + priority));
            } else if (priority == 9) {
                box.setAccessKey('0');
            }
        }
        box.addStyleName("course");
        line.add((Widget)box);
        this.iCourses.add(box);
        P buttons = new P("buttons");
        if (!alternate) {
            this.iWaitList = new AriaCheckBox();
            this.iWaitList.setAriaLabel(ARIA.titleRequestedWaitList(1 + priority));
            this.iWaitList.addStyleName("wait-list");
            buttons.add((Widget)this.iWaitList);
        } else {
            this.addStyleName("nowaitlist");
        }
        P up = new P("blank");
        buttons.add((Widget)up);
        P down = new P("blank");
        buttons.add((Widget)down);
        ImageButton delete = new ImageButton(RESOURCES.delete(), RESOURCES.delete_Down(), RESOURCES.delete_Over());
        delete.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CourseRequestLine.this.delete();
                ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestLine.this, (Object)CourseRequestLine.this.getValue());
            }
        });
        delete.addStyleName("delete");
        delete.setAltText(ARIA.altDeleteRequest(priority + 1));
        buttons.add((Widget)delete);
        line.add((Widget)buttons);
        this.add((Widget)line);
    }

    public boolean isWaitListVisible() {
        return this.iWaitList != null && this.iWaitList.isVisible();
    }

    public void setWaitListVisible(boolean visible) {
        if (this.iWaitList != null) {
            this.iWaitList.setVisible(visible);
            this.changeVisibleStyle();
        }
    }

    public boolean getWaitList() {
        return this.iWaitList != null && this.iWaitList.getValue() != false;
    }

    public void setWaitList(boolean value) {
        if (this.iWaitList != null) {
            this.iWaitList.setValue(value);
        }
    }

    public void setPrevious(CourseRequestLine previous) {
        int idx;
        this.iPrevious = previous;
        P line = (P)this.getWidget(0);
        P buttons = (P)line.getWidget(2);
        int n = idx = this.iWaitList == null ? 0 : 1;
        if (this.iPrevious == null) {
            if (buttons.getWidget(idx) instanceof ImageButton) {
                buttons.remove(idx);
                P up = new P("blank");
                buttons.add((Widget)up);
                buttons.insert((Widget)up, idx);
            }
        } else {
            ImageButton up = null;
            if (buttons.getWidget(idx) instanceof ImageButton) {
                up = (ImageButton)buttons.getWidget(idx);
            } else {
                buttons.remove(idx);
                up = new ImageButton(RESOURCES.up(), RESOURCES.up_Down(), RESOURCES.up_Over());
                up.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        CourseRequestLine.this.up();
                        ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestLine.this, (Object)CourseRequestLine.this.getValue());
                    }
                });
                up.addStyleName("up");
                buttons.insert((Widget)up, idx);
            }
            if (this.isAlternate()) {
                if (this.iPrevious.isAlternate()) {
                    up.setAltText(ARIA.altSwapAlternateRequest(this.getPriority() + 1, this.getPriority()));
                } else {
                    up.setAltText(ARIA.altSwapCourseAlternateRequest(this.iPrevious.getPriority() + 1, this.getPriority() + 1));
                }
            } else {
                up.setAltText(ARIA.altSwapCourseRequest(this.getPriority() + 1, this.getPriority()));
            }
        }
    }

    public void setNext(CourseRequestLine next) {
        int idx;
        this.iNext = next;
        P line = (P)this.getWidget(0);
        P buttons = (P)line.getWidget(2);
        int n = idx = this.iWaitList == null ? 1 : 2;
        if (this.iNext == null) {
            if (buttons.getWidget(idx) instanceof ImageButton) {
                buttons.remove(idx);
                P down = new P("blank");
                buttons.add((Widget)down);
                buttons.insert((Widget)down, idx);
            }
        } else {
            ImageButton down = null;
            if (buttons.getWidget(idx) instanceof ImageButton) {
                down = (ImageButton)buttons.getWidget(idx);
            } else {
                buttons.remove(idx);
                down = new ImageButton(RESOURCES.down(), RESOURCES.down_Down(), RESOURCES.down_Over());
                down.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        CourseRequestLine.this.down();
                        ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestLine.this, (Object)CourseRequestLine.this.getValue());
                    }
                });
                down.addStyleName("down");
                buttons.insert((Widget)down, idx);
            }
            if (this.isAlternate()) {
                down.setAltText(ARIA.altSwapAlternateRequest(this.getPriority() + 1, this.getPriority() + 2));
            } else if (this.iNext.isAlternate()) {
                down.setAltText(ARIA.altSwapCourseAlternateRequest(this.getPriority() + 1, this.iNext.getPriority() + 1));
            } else {
                down.setAltText(ARIA.altSwapCourseRequest(this.getPriority() + 1, this.getPriority() + 2));
            }
        }
    }

    public void up() {
        if (this.iPrevious != null) {
            CourseRequestInterface.Request r = this.getValue();
            this.setValue(this.iPrevious.getValue());
            this.iPrevious.setValue(r);
        }
    }

    public void down() {
        if (this.iNext != null) {
            CourseRequestInterface.Request r = this.getValue();
            this.setValue(this.iNext.getValue());
            this.iNext.setValue(r);
        }
    }

    public List<? extends CourseSelectionBox> getCourses() {
        return this.iCourses;
    }

    public void fixTitles() {
        for (int i = 0; i < this.getWidgetCount(); ++i) {
            P line = (P)this.getWidget(i);
            P title = (P)line.getWidget(0);
            CourseSelectionBox box = (CourseSelectionBox)line.getWidget(1);
            if (i == 0) {
                title.setText(this.isAlternate() ? MESSAGES.courseRequestsAlternate(this.getPriority() + 1) : MESSAGES.courseRequestsPriority(this.getPriority() + 1));
                if (this.isAlternate()) {
                    box.setLabel(ARIA.titleRequestedAlternate(1 + this.getPriority(), String.valueOf((char)(97 + this.getPriority()))), ARIA.altRequestedAlternateFinder(1 + this.getPriority()));
                } else {
                    box.setLabel(ARIA.titleRequestedCourse(1 + this.getPriority()), ARIA.altRequestedCourseFinder(1 + this.getPriority()));
                }
            } else {
                title.setText(MESSAGES.courseRequestsAlternative(i));
                if (this.isAlternate()) {
                    if (i == 1) {
                        box.setLabel(ARIA.titleRequestedAlternateFirstAlternative(1 + this.getPriority()), ARIA.altRequestedAlternateFirstFinder(1 + this.getPriority()));
                    } else if (i == 2) {
                        box.setLabel(ARIA.titleRequestedAlternateSecondAlternative(1 + this.getPriority()), ARIA.altRequestedAlternateSecondFinder(1 + this.getPriority()));
                    } else {
                        box.setLabel(ARIA.titleRequestedAlternateNAlternative(i, 1 + this.getPriority()), ARIA.altRequestedNAlternateFinder(i, 1 + this.getPriority()));
                    }
                } else if (i == 1) {
                    box.setLabel(ARIA.titleRequestedCourseFirstAlternative(1 + this.getPriority()), ARIA.altRequestedCourseFirstAlternativeFinder(1 + this.getPriority()));
                } else if (i == 2) {
                    box.setLabel(ARIA.titleRequestedCourseSecondAlternative(1 + this.getPriority()), ARIA.altRequestedCourseSecondAlternativeFinder(1 + this.getPriority()));
                } else {
                    box.setLabel(ARIA.titleRequestedCourseNAlternative(i, 1 + this.getPriority()), ARIA.altRequestedCourseNAlternativeFinder(i, 1 + this.getPriority()));
                }
            }
            box.resizeFilterIfNeeded();
            CourseSelectionEvent.fire((HasHandlers)box, box.getValue());
        }
    }

    public boolean isAlternate() {
        return this.iAlternate;
    }

    public int getPriority() {
        return this.iPriority;
    }

    public void delete() {
        if (this.iNext != null && this.isAlternate() == this.iNext.isAlternate()) {
            this.setValue(this.iNext.getValue());
            this.iNext.delete();
        } else {
            this.iCourses.get(0).setValue(null);
            if (this.iWaitList != null && this.iWaitList.isVisible()) {
                this.iWaitList.setEnabled(true);
                this.iWaitList.setValue(false);
            }
            for (int i = this.iCourses.size() - 1; i > 0; --i) {
                this.deleteAlternative(i);
            }
        }
    }

    public void deleteAlternative(int index) {
        this.iCourses.remove(index).dispose();
        this.remove(index);
        this.fixTitles();
    }

    public void insertAlternative(int index) {
        P line = new P("alt-line");
        P title = new P("title");
        title.setText(MESSAGES.courseRequestsAlternative(index));
        line.add((Widget)title);
        CourseSelectionBox box = new CourseSelectionBox(!this.isAlternate(), true);
        if (this.isAlternate()) {
            if (index == 1) {
                box.setLabel(ARIA.titleRequestedAlternateFirstAlternative(1 + this.getPriority()), ARIA.altRequestedAlternateFirstFinder(1 + this.getPriority()));
            } else if (index == 2) {
                box.setLabel(ARIA.titleRequestedAlternateSecondAlternative(1 + this.getPriority()), ARIA.altRequestedAlternateSecondFinder(1 + this.getPriority()));
            } else {
                box.setLabel(ARIA.titleRequestedAlternateNAlternative(index, 1 + this.getPriority()), ARIA.altRequestedNAlternateFinder(index, 1 + this.getPriority()));
            }
        } else if (index == 1) {
            box.setLabel(ARIA.titleRequestedCourseFirstAlternative(1 + this.getPriority()), ARIA.altRequestedCourseFirstAlternativeFinder(1 + this.getPriority()));
        } else if (index == 2) {
            box.setLabel(ARIA.titleRequestedCourseSecondAlternative(1 + this.getPriority()), ARIA.altRequestedCourseSecondAlternativeFinder(1 + this.getPriority()));
        } else {
            box.setLabel(ARIA.titleRequestedCourseNAlternative(index, 1 + this.getPriority()), ARIA.altRequestedCourseNAlternativeFinder(index, 1 + this.getPriority()));
        }
        box.addStyleName("course");
        line.add((Widget)box);
        this.iCourses.add(box);
        this.insert((Widget)line, index);
        box.setValue(null);
        this.fixTitles();
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<CourseRequestInterface.Request> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public CourseRequestInterface.Request getValue() {
        CourseRequestInterface.Request ret = new CourseRequestInterface.Request();
        for (CourseSelectionBox box : this.iCourses) {
            CourseRequestInterface.RequestedCourse rc = box.getValue();
            if (rc.isEmpty()) continue;
            ret.addRequestedCourse(rc);
        }
        if (this.iWaitList != null && this.iWaitList.isVisible()) {
            ret.setWaitList(this.iWaitList.getValue());
        }
        return ret.isEmpty() ? null : ret;
    }

    public void setValue(CourseRequestInterface.Request value) {
        this.setValue(value, false);
    }

    public void setValue(CourseRequestInterface.Request value, boolean fireEvents) {
        if (value == null) {
            if (this.iWaitList != null) {
                this.iWaitList.setValue(false);
            }
            for (int i = this.iCourses.size() - 1; i > 0; --i) {
                this.deleteAlternative(i);
            }
            this.iCourses.get(0).setValue(null, true);
        } else {
            if (this.iWaitList != null) {
                this.iWaitList.setValue(value.isWaitList());
            }
            int index = 0;
            if (value.hasRequestedCourse()) {
                for (CourseRequestInterface.RequestedCourse rc : value.getRequestedCourse()) {
                    if (rc.isEmpty()) continue;
                    if (this.iCourses.size() <= index) {
                        this.insertAlternative(index);
                    }
                    this.iCourses.get(index).setValue(rc, true);
                    ++index;
                }
            }
            if (index == 0) {
                this.iCourses.get(0).setValue(null, true);
                ++index;
            }
            for (int i = this.iCourses.size() - 1; i >= index; --i) {
                this.deleteAlternative(i);
            }
        }
        if (this.iWaitList != null && this.iWaitList.isVisible()) {
            this.iWaitList.setEnabled(value == null || !value.isReadOnly());
        }
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        }
    }

    public String validate() {
        String failed = null;
        for (CourseSelectionBox box : this.iCourses) {
            String message = box.validate();
            if (failed != null || message == null) continue;
            failed = message;
        }
        return failed;
    }

    public void setArrowsVisible(boolean visible) {
        this.iArrowsVisible = visible;
        this.changeVisibleStyle();
    }

    public boolean areArrowsVisible() {
        return this.iArrowsVisible;
    }

    protected void changeVisibleStyle() {
        this.setStyleName("noarrows", !this.areArrowsVisible() && this.isWaitListVisible());
        this.setStyleName("nowaitlist", this.areArrowsVisible() && !this.isWaitListVisible());
        this.setStyleName("noarrowswaitlist", !this.areArrowsVisible() && !this.isWaitListVisible());
    }

    public class CourseSelectionBox
    extends CourseRequestBox {
        private HandlerRegistration iCourseSelectionHandlerRegistration;

        public CourseSelectionBox(boolean allowFreeTime, boolean alternative) {
            super(CONSTANTS.showCourseTitle());
            if (allowFreeTime) {
                FreeTimeParser parser = new FreeTimeParser();
                this.setFreeTimes(parser);
            }
            this.setCourseFinderFactory(new CourseFinderFactory(){

                public CourseFinder createCourseFinder() {
                    CourseFinderDialog finder = new CourseFinderDialog();
                    CourseFinderCourses courses = new CourseFinderCourses(CONSTANTS.showCourseTitle(), CONSTANTS.courseFinderSuggestWhenEmpty());
                    courses.setDataProvider(new DataProvider<String, Collection<ClassAssignmentInterface.CourseAssignment>>(){

                        @Override
                        public void getData(String source, AsyncCallback<Collection<ClassAssignmentInterface.CourseAssignment>> callback) {
                            sSectioningService.listCourseOfferings(CourseRequestLine.this.iSessionProvider.getAcademicSessionId(), source, null, callback);
                        }
                    });
                    CourseFinderDetails details = new CourseFinderDetails();
                    details.setDataProvider(new DataProvider<ClassAssignmentInterface.CourseAssignment, String>(){

                        @Override
                        public void getData(ClassAssignmentInterface.CourseAssignment source, AsyncCallback<String> callback) {
                            sSectioningService.retrieveCourseDetails(CourseRequestLine.this.iSessionProvider.getAcademicSessionId(), source.hasUniqueName() ? source.getCourseName() : source.getCourseNameWithTitle(), callback);
                        }
                    });
                    CourseFinderClasses classes = new CourseFinderClasses(true);
                    classes.setDataProvider(new DataProvider<ClassAssignmentInterface.CourseAssignment, Collection<ClassAssignmentInterface.ClassAssignment>>(){

                        @Override
                        public void getData(ClassAssignmentInterface.CourseAssignment source, AsyncCallback<Collection<ClassAssignmentInterface.ClassAssignment>> callback) {
                            sSectioningService.listClasses(CourseRequestLine.this.iSessionProvider.getAcademicSessionId(), source.hasUniqueName() ? source.getCourseName() : source.getCourseNameWithTitle(), callback);
                        }
                    });
                    courses.setCourseDetails(details, classes);
                    if (CourseSelectionBox.this.getFreeTimes() != null) {
                        CourseFinderFreeTime free = new CourseFinderFreeTime();
                        free.setDataProvider(CourseSelectionBox.this.getFreeTimes());
                        finder.setTabs(courses, free);
                    } else {
                        finder.setTabs(courses);
                    }
                    return finder;
                }
            });
            this.setSuggestions(new DataProvider<String, Collection<ClassAssignmentInterface.CourseAssignment>>(){

                @Override
                public void getData(String source, AsyncCallback<Collection<ClassAssignmentInterface.CourseAssignment>> callback) {
                    sSectioningService.listCourseOfferings(CourseRequestLine.this.iSessionProvider.getAcademicSessionId(), source, 20, callback);
                }
            });
            this.setSectionsProvider(new DataProvider<ClassAssignmentInterface.CourseAssignment, Collection<ClassAssignmentInterface.ClassAssignment>>(){

                @Override
                public void getData(ClassAssignmentInterface.CourseAssignment source, AsyncCallback<Collection<ClassAssignmentInterface.ClassAssignment>> callback) {
                    sSectioningService.listClasses(CourseRequestLine.this.iSessionProvider.getAcademicSessionId(), source.hasUniqueName() ? source.getCourseName() : source.getCourseNameWithTitle(), callback);
                }
            });
            this.iCourseSelectionHandlerRegistration = this.addCourseSelectionHandler(new CourseSelectionHandler(){

                public void onCourseSelection(CourseSelectionEvent event) {
                    CourseSelectionBox prev;
                    CourseSelectionBox next;
                    if (event.isValid()) {
                        CourseSelectionBox.this.setError("");
                    }
                    if ((next = CourseSelectionBox.this.getNext()) != null) {
                        if (event.getValue().isFreeTime()) {
                            next.setHint("");
                        } else {
                            next.resizeFilterIfNeeded();
                            next.setEnabled(event.isValid() || !next.getValue().isEmpty());
                            if (event.isValid() && next.getValue().isEmpty()) {
                                prev = CourseSelectionBox.this.getPrevious();
                                if (prev != null) {
                                    next.setHint(MESSAGES.courseRequestsHintAlt2(prev.getText(), CourseSelectionBox.this.getText()));
                                } else {
                                    next.setHint(MESSAGES.courseRequestsHintAlt(CourseSelectionBox.this.getText()));
                                }
                            } else {
                                next.setHint("");
                            }
                        }
                    }
                    if ((prev = CourseSelectionBox.this.getPrevious()) != null) {
                        prev.resizeFilterIfNeeded();
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestLine.this, (Object)CourseRequestLine.this.getValue());
                }
            });
            this.addValidator(new Validator<CourseSelection>(){

                @Override
                public String validate(CourseSelection source) {
                    if (CourseSelectionBox.this.getIndex() == 0) {
                        if (CourseRequestLine.this.isAlternate() && CourseSelectionBox.this.getValue().isFreeTime()) {
                            return MESSAGES.validationAltFreeTime();
                        }
                    } else {
                        if (!CourseSelectionBox.this.getValue().isEmpty() && CourseSelectionBox.this.getPrevious().getValue().isEmpty()) {
                            if (CourseSelectionBox.this.getIndex() == 2) {
                                return MESSAGES.validationSecondAltWithoutFirst();
                            }
                            return MESSAGES.validationNoCourse();
                        }
                        if (!CourseSelectionBox.this.getValue().isEmpty() && CourseSelectionBox.this.getPrevious().getValue().isFreeTime()) {
                            return MESSAGES.validationFreeTimeWithAlt();
                        }
                        if (CourseSelectionBox.this.getValue().isFreeTime()) {
                            return MESSAGES.validationAltFreeTime();
                        }
                    }
                    return null;
                }
            });
            if (CourseRequestLine.this.iValidator != null) {
                this.addValidator(CourseRequestLine.this.iValidator);
            }
            if (alternative) {
                this.removeClearOperation();
                CourseRequestBox.FilterOperation moveUp = new CourseRequestBox.FilterOperation(RESOURCES.filterSwap(), Character.valueOf('S')){

                    public void onBeforeResize(CourseRequestBox.CourseRequestFilterBox filter) {
                        this.setVisible(CourseSelectionBox.this.isEnabled() && !filter.getText().isEmpty() && CourseRequestLine.this.iCourses.size() != CourseSelectionBox.this.getIndex() + 1);
                    }
                };
                moveUp.setTitle(MESSAGES.altFilterSwapWithAlternative());
                moveUp.setAltText(MESSAGES.altFilterSwapWithAlternative());
                moveUp.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        final CourseSelectionBox next = CourseSelectionBox.this.getNext();
                        if (next != null && next.getValue().isCourse()) {
                            CourseRequestInterface.RequestedCourse rc = CourseSelectionBox.this.getValue();
                            CourseSelectionBox.this.setValue(next.getValue(), true);
                            next.setValue(rc, true);
                            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                                public void execute() {
                                    next.setFocus(true);
                                }
                            });
                            return;
                        }
                        final CourseSelectionBox prev = CourseSelectionBox.this.getPrevious();
                        if (prev != null) {
                            CourseRequestInterface.RequestedCourse rc = prev.getValue();
                            prev.setValue(CourseSelectionBox.this.getValue(), true);
                            CourseSelectionBox.this.setValue(rc, true);
                            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                                public void execute() {
                                    prev.setFocus(true);
                                }
                            });
                        }
                    }
                });
                this.addOperation(moveUp, true);
                CourseRequestBox.FilterOperation remove = new CourseRequestBox.FilterOperation(RESOURCES.filterRemoveAlternative(), Character.valueOf('X')){

                    public void onBeforeResize(CourseRequestBox.CourseRequestFilterBox filter) {
                        this.setVisible(CourseSelectionBox.this.isEnabled());
                    }
                };
                remove.setTitle(MESSAGES.altFilterRemoveAlternative());
                remove.setAltText(MESSAGES.altFilterRemoveAlternative());
                remove.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        final CourseSelectionBox prev = CourseSelectionBox.this.getPrevious();
                        CourseRequestLine.this.deleteAlternative(CourseSelectionBox.this.getIndex());
                        if (prev != null) {
                            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                                public void execute() {
                                    prev.setFocus(true);
                                }
                            });
                        }
                    }
                });
                this.addOperation(remove, false);
                CourseRequestBox.FilterOperation addAlternative = new CourseRequestBox.FilterOperation(RESOURCES.filterAddAlternative(), Character.valueOf('A')){

                    public void onBeforeResize(CourseRequestBox.CourseRequestFilterBox filter) {
                        this.setVisible(CourseSelectionBox.this.isEnabled() && CourseSelectionBox.this.getValue().isCourse() && CourseRequestLine.this.iCourses.size() == CourseSelectionBox.this.getIndex() + 1);
                    }
                };
                addAlternative.setTitle(MESSAGES.altFilterAddAlternative());
                addAlternative.setAltText(MESSAGES.altFilterAddAlternative());
                addAlternative.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        CourseRequestLine.this.insertAlternative(CourseRequestLine.this.iCourses.size());
                        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                            public void execute() {
                                ((CourseSelectionBox)CourseRequestLine.this.iCourses.get(CourseRequestLine.this.iCourses.size() - 1)).setFocus(true);
                            }
                        });
                    }
                });
                this.addOperation(addAlternative, true);
            } else {
                this.removeClearOperation();
                CourseRequestBox.FilterOperation moveDown = new CourseRequestBox.FilterOperation(RESOURCES.filterSwap(), Character.valueOf('S')){

                    public void onBeforeResize(CourseRequestBox.CourseRequestFilterBox filter) {
                        CourseSelectionBox next = CourseSelectionBox.this.getNext();
                        this.setVisible(CourseSelectionBox.this.isEnabled() && !filter.getText().isEmpty() && next != null && next.getValue().isCourse());
                    }
                };
                moveDown.setTitle(MESSAGES.altFilterSwapWithAlternative());
                moveDown.setAltText(MESSAGES.altFilterSwapWithAlternative());
                moveDown.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        final CourseSelectionBox next = CourseSelectionBox.this.getNext();
                        if (next != null) {
                            CourseRequestInterface.RequestedCourse rc = CourseSelectionBox.this.getValue();
                            CourseSelectionBox.this.setValue(next.getValue(), true);
                            next.setValue(rc, true);
                            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                                public void execute() {
                                    next.setFocus(true);
                                }
                            });
                        }
                    }
                });
                this.addOperation(moveDown, true);
                CourseRequestBox.FilterOperation remove = new CourseRequestBox.FilterOperation(RESOURCES.filterRemoveAlternative(), Character.valueOf('X')){

                    public void onBeforeResize(CourseRequestBox.CourseRequestFilterBox filter) {
                        this.setVisible(CourseSelectionBox.this.isEnabled());
                    }
                };
                remove.setTitle(MESSAGES.altFilterClearCourseRequest());
                remove.setAltText(MESSAGES.altFilterClearCourseRequest());
                remove.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (CourseRequestLine.this.iCourses.size() > 1) {
                            CourseRequestInterface.RequestedCourse rc = ((CourseSelectionBox)CourseRequestLine.this.iCourses.get(1)).getValue();
                            CourseRequestLine.this.deleteAlternative(1);
                            CourseSelectionBox.this.setValue(rc, true);
                        } else if (!CourseSelectionBox.this.getValue().isEmpty()) {
                            CourseSelectionBox.this.setValue(null, true);
                        } else {
                            CourseRequestLine.this.delete();
                        }
                    }
                });
                this.addOperation(remove, false);
                CourseRequestBox.FilterOperation addAlternative = new CourseRequestBox.FilterOperation(RESOURCES.filterAddAlternative(), Character.valueOf('A')){

                    public void onBeforeResize(CourseRequestBox.CourseRequestFilterBox filter) {
                        this.setVisible(CourseSelectionBox.this.isEnabled() && CourseSelectionBox.this.getValue().isCourse() && CourseRequestLine.this.iCourses.size() == 1);
                    }
                };
                addAlternative.setTitle(MESSAGES.altFilterAddAlternative());
                addAlternative.setAltText(MESSAGES.altFilterAddAlternative());
                addAlternative.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        CourseRequestLine.this.insertAlternative(CourseRequestLine.this.iCourses.size());
                        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                            public void execute() {
                                ((CourseSelectionBox)CourseRequestLine.this.iCourses.get(CourseRequestLine.this.iCourses.size() - 1)).setFocus(true);
                            }
                        });
                    }
                });
                this.addOperation(addAlternative, true);
            }
        }

        public void setValue(CourseRequestInterface.RequestedCourse rc) {
            super.setValue(rc);
            CourseSelectionBox prev = this.getPrevious();
            if (rc == null && prev != null && !prev.getValue().isCourse()) {
                this.setEnabled(false);
            }
            if (prev != null) {
                if (rc != null && rc.isReadOnly() || prev.getValue().isFreeTime()) {
                    this.setHint("");
                } else if (this.getIndex() == 1) {
                    this.setHint(MESSAGES.courseRequestsHintAlt(prev.getText()));
                } else if (this.getIndex() == 2) {
                    this.setHint(MESSAGES.courseRequestsHintAlt2(((CourseSelectionBox)CourseRequestLine.this.iCourses.get(0)).getText(), ((CourseSelectionBox)CourseRequestLine.this.iCourses.get(1)).getText()));
                } else {
                    this.setHint(MESSAGES.courseRequestsHintAlt3(((CourseSelectionBox)CourseRequestLine.this.iCourses.get(0)).getText(), ((CourseSelectionBox)CourseRequestLine.this.iCourses.get(1)).getText()));
                }
            }
        }

        public int getIndex() {
            return CourseRequestLine.this.iCourses.indexOf(this);
        }

        public CourseSelectionBox getPrevious() {
            return this.getIndex() > 0 ? (CourseSelectionBox)CourseRequestLine.this.iCourses.get(this.getIndex() - 1) : null;
        }

        public CourseSelectionBox getNext() {
            return this.getIndex() + 1 < CourseRequestLine.this.iCourses.size() ? (CourseSelectionBox)CourseRequestLine.this.iCourses.get(this.getIndex() + 1) : null;
        }

        public void dispose() {
            this.iCourseSelectionHandlerRegistration.removeHandler();
        }
    }
}

