/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.StudentSectioningStatusDAO;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.IdValue;
import org.unitime.timetable.util.ReferenceList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionEditForm
extends ActionForm {
    private static final long serialVersionUID = 3258410646873060656L;
    Session session = new Session();
    ReferenceList statusOptions;
    String academicInitiative;
    String academicYear;
    String academicTerm;
    String sessionStart;
    String sessionEnd;
    String classesEnd;
    String examStart;
    String eventStart;
    String eventEnd;
    String defaultDatePatternId;
    String defaultDatePatternLabel;
    Integer wkEnroll = 1;
    Integer wkChange = 1;
    Integer wkDrop = 4;
    Long sectStatus;
    boolean includeTestSession;
    Long durationType;

    public ActionErrors validate(ActionMapping arg0, HttpServletRequest arg1) {
        ActionErrors errors = new ActionErrors();
        if (this.academicInitiative == null || this.academicInitiative.trim().length() == 0) {
            errors.add("academicInitiative", new ActionMessage("errors.required", (Object)"Academic Initiative"));
        }
        if (this.academicTerm == null || this.academicTerm.trim().length() == 0) {
            errors.add("academicTerm", new ActionMessage("errors.required", (Object)"Academic Term"));
        }
        if (this.academicYear == null || this.academicYear.trim().length() == 0) {
            errors.add("academicYear", new ActionMessage("errors.required", (Object)"Academic Year"));
        } else {
            try {
                Integer.parseInt(this.academicYear);
            }
            catch (Exception e) {
                errors.add("academicYear", new ActionMessage("errors.numeric", (Object)"Academic Year"));
            }
        }
        this.validateDates(errors);
        if (this.getStatus() == null || this.getStatus().trim().length() == 0) {
            errors.add("status", new ActionMessage("errors.required", (Object)"Session Status"));
        }
        if (errors.size() == 0) {
            Session sessn = Session.getSessionUsingInitiativeYearTerm(this.academicInitiative, this.academicYear, this.academicTerm);
            if (this.session.getSessionId() == null && sessn != null) {
                errors.add("sessionId", new ActionMessage("errors.generic", (Object)"An academic session for the initiative, year and term already exists"));
            }
            if (this.session.getSessionId() != null && sessn != null && !this.session.getSessionId().equals(sessn.getSessionId())) {
                errors.add("sessionId", new ActionMessage("errors.generic", (Object)"Another academic session for the same initiative, year and term already exists"));
            }
        }
        return errors;
    }

    public void validateDates(ActionErrors errors) {
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT);
        Date dStart = null;
        try {
            dStart = df.parse(this.sessionStart);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (dStart == null) {
            errors.add("sessionStart", new ActionMessage("errors.invalidDate", (Object)"Session Start Date"));
        } else {
            Date dEnd = null;
            try {
                dEnd = df.parse(this.sessionEnd);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (dEnd == null) {
                errors.add("sessionEnd", new ActionMessage("errors.invalidDate", (Object)"Session End Date"));
            } else if (!dEnd.after(dStart)) {
                errors.add("sessionEnd", new ActionMessage("errors.generic", (Object)"Session End Date must occur AFTER Session Start Date"));
            } else {
                Date dClassEnd = null;
                try {
                    dClassEnd = df.parse(this.classesEnd);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (dClassEnd == null) {
                    errors.add("classesEnd", new ActionMessage("errors.invalidDate", (Object)"Classes End Date"));
                } else if (!dClassEnd.after(dStart)) {
                    errors.add("classesEnd", new ActionMessage("errors.generic", (Object)"Classes End Date must occur AFTER Session Start Date"));
                } else if (!dClassEnd.before(dEnd) && !dClassEnd.equals(dEnd)) {
                    errors.add("classesEnd", new ActionMessage("errors.generic", (Object)"Classes End Date must occur ON or BEFORE Session End Date"));
                } else {
                    Date dExamStart = null;
                    try {
                        dExamStart = df.parse(this.examStart);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (dExamStart == null) {
                        errors.add("examStart", new ActionMessage("errors.invalidDate", (Object)"Examinations Start Date"));
                    }
                    Date dEventStart = null;
                    try {
                        dEventStart = df.parse(this.eventStart);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Date dEventEnd = null;
                    try {
                        dEventEnd = df.parse(this.eventEnd);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (dEventStart == null) {
                        errors.add("eventStart", new ActionMessage("errors.invalidDate", (Object)"Event Start Date"));
                    } else if (dEventEnd == null) {
                        errors.add("eventEnd", new ActionMessage("errors.invalidDate", (Object)"Event End Date"));
                    }
                    if (errors.isEmpty() && !dEventStart.before(dEventEnd)) {
                        errors.add("eventEnd", new ActionMessage("errors.generic", (Object)"Event End Date must occur AFTER Event Start Date"));
                    }
                    Calendar start = Calendar.getInstance(Locale.US);
                    if (dEventStart != null) {
                        if (dEventStart.before(dStart)) {
                            start.setTime(dEventStart);
                        } else {
                            start.setTime(dStart);
                        }
                    } else {
                        start.setTime(dStart);
                    }
                    Calendar end = Calendar.getInstance(Locale.US);
                    if (dEventEnd != null) {
                        if (dEventEnd.after(dEnd)) {
                            end.setTime(dEventEnd);
                        } else {
                            end.setTime(dEnd);
                        }
                    } else {
                        end.setTime(dEnd);
                    }
                    int startYear = start.get(1);
                    int endYear = end.get(1);
                    int startMonth = start.get(2);
                    int endMonth = end.get(2);
                    int startDay = start.get(5);
                    int endDay = end.get(5);
                    if (startYear < endYear && (startYear + 1 < endYear || startMonth < endMonth || startMonth == endMonth && startDay <= endDay)) {
                        errors.add("sessionDays", new ActionMessage("errors.generic", (Object)"Dates associated with a session cannot cover more than one year."));
                    }
                }
            }
        }
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public boolean equals(Object arg0) {
        return this.session.equals(arg0);
    }

    public String getAcademicInitiative() {
        return this.academicInitiative;
    }

    public int hashCode() {
        return this.session.hashCode();
    }

    public void setAcademicInitiative(String academicInitiative) {
        this.academicInitiative = academicInitiative;
    }

    public Long getSessionId() {
        return this.session.getSessionId();
    }

    public void setSessionId(Long sessionId) {
        if (sessionId != null && sessionId <= 0L) {
            this.session.setSessionId(null);
        } else {
            this.session.setSessionId(sessionId);
        }
    }

    public String getStatus() {
        return this.session.getStatusType() == null ? null : this.session.getStatusType().getReference();
    }

    public DepartmentStatusType getStatusType() {
        return this.session.getStatusType();
    }

    public void setStatus(String status) throws Exception {
        this.session.setStatusType(status == null || status.length() == 0 ? null : DepartmentStatusType.findByRef(status));
    }

    public ReferenceList getStatusOptions() {
        if (this.statusOptions == null) {
            this.statusOptions = Session.getSessionStatusList(this.includeTestSession);
        }
        return this.statusOptions;
    }

    public void setStatusOptions(ReferenceList statusOptions) {
        this.statusOptions = statusOptions;
    }

    public String getAcademicInitiativeDisplayString() {
        return this.session.academicInitiativeDisplayString();
    }

    public String getLabel() {
        return this.session.getLabel();
    }

    public String getAcademicTerm() {
        return this.academicTerm;
    }

    public void setAcademicTerm(String academicTerm) {
        this.academicTerm = academicTerm;
    }

    public String getAcademicYear() {
        return this.academicYear;
    }

    public void setAcademicYear(String academicYear) {
        this.academicYear = academicYear;
    }

    public String getDefaultDatePatternId() {
        return this.defaultDatePatternId;
    }

    public void setDefaultDatePatternId(String defaultDatePatternId) {
        this.defaultDatePatternId = defaultDatePatternId;
    }

    public String getDefaultDatePatternLabel() {
        return this.defaultDatePatternLabel;
    }

    public void setDefaultDatePatternLabel(String defaultDatePatternLabel) {
        this.defaultDatePatternLabel = defaultDatePatternLabel;
    }

    public String getClassesEnd() {
        return this.classesEnd;
    }

    public void setClassesEnd(String classesEnd) {
        this.classesEnd = classesEnd;
    }

    public String getSessionEnd() {
        return this.sessionEnd;
    }

    public void setSessionEnd(String sessionEnd) {
        this.sessionEnd = sessionEnd;
    }

    public String getSessionStart() {
        return this.sessionStart;
    }

    public void setSessionStart(String sessionStart) {
        this.sessionStart = sessionStart;
    }

    public String getExamStart() {
        return this.examStart;
    }

    public void setExamStart(String examStart) {
        this.examStart = examStart;
    }

    public String getEventStart() {
        return this.eventStart;
    }

    public void setEventStart(String eventStart) {
        this.eventStart = eventStart;
    }

    public String getEventEnd() {
        return this.eventEnd;
    }

    public void setEventEnd(String eventEnd) {
        this.eventEnd = eventEnd;
    }

    public Set<RoomType> getRoomTypes() {
        return RoomType.findAll();
    }

    public Integer getWkEnroll() {
        return this.wkEnroll;
    }

    public void setWkEnroll(Integer wkEnroll) {
        this.wkEnroll = wkEnroll;
    }

    public Integer getWkChange() {
        return this.wkChange;
    }

    public void setWkChange(Integer wkChange) {
        this.wkChange = wkChange;
    }

    public Integer getWkDrop() {
        return this.wkDrop;
    }

    public void setWkDrop(Integer wkDrop) {
        this.wkDrop = wkDrop;
    }

    public Long getSectStatus() {
        return this.sectStatus;
    }

    public void setSectStatus(Long sectStatus) {
        this.sectStatus = sectStatus;
    }

    public List<IdValue> getSectStates() {
        ArrayList<IdValue> ret = new ArrayList<IdValue>();
        for (StudentSectioningStatus status : StudentSectioningStatusDAO.getInstance().findAll()) {
            ret.add(new IdValue(status.getUniqueId(), status.getLabel()));
        }
        return ret;
    }

    public Long getDurationType() {
        return this.durationType;
    }

    public void setDurationType(Long durationType) {
        this.durationType = durationType;
    }

    public List<IdValue> getDurationTypes() {
        ArrayList<IdValue> ret = new ArrayList<IdValue>();
        for (ClassDurationType type : ClassDurationType.findAll()) {
            if (!type.isVisible().booleanValue() && !type.getUniqueId().equals(this.durationType)) continue;
            ret.add(new IdValue(type.getUniqueId(), type.getLabel()));
        }
        return ret;
    }

    public void setIncludeTestSession(boolean includeTestSession) {
        this.includeTestSession = includeTestSession;
    }
}

