/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.util.MessageResources;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.SimpleItypeConfig;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.IdValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionalOfferingConfigEditForm
extends ActionForm {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private static final long serialVersionUID = 3257570611432993077L;
    private Long configId;
    private String instrOfferingName;
    private String courseOfferingId;
    private String instrOfferingId;
    private String subjectArea;
    private String courseNumber;
    private int limit;
    private Boolean notOffered;
    private String itype;
    private String op;
    private String name;
    private Boolean unlimited;
    private Integer configCount;
    private String catalogLinkLabel;
    private String catalogLinkLocation;
    private String durationTypeDefault;
    private Long durationType;
    private boolean durationTypeEditable;
    private Long instructionalMethod;
    private final short NO_ERR = 0;
    private final short ERR_NC = (short)-1;
    private final short ERR_CL = (short)-2;
    private final short ERR_LS = (short)-3;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        MessageResources rsc = (MessageResources)super.getServlet().getServletContext().getAttribute("org.apache.struts.action.MESSAGE");
        if (this.limit < 0) {
            errors.add("limit", new ActionMessage("errors.integerGtEq", (Object)"Limit", (Object)"0"));
        }
        String lblMax = "Limit";
        if (request.getParameter("varLimits") != null) {
            lblMax = "Max limit";
        }
        if (this.op.equals(rsc.getMessage("button.add")) && (this.itype == null || this.itype.trim().length() == 0 || this.itype.equals(Constants.BLANK_OPTION_VALUE))) {
            errors.add("itype", new ActionMessage("errors.required", (Object)"Instructional Type"));
        }
        if (this.op.equals(MSG.actionSaveConfiguration()) || this.op.equals(MSG.actionUpdateConfiguration())) {
            HttpSession webSession = request.getSession();
            Vector sp = (Vector)webSession.getAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME);
            InstructionalOffering io = (InstructionalOffering)new InstructionalOfferingDAO().get(new Long(this.getInstrOfferingId()));
            if (io.existsConfig(this.getName(), this.getConfigId())) {
                errors.add("subparts", new ActionMessage("errors.generic", (Object)"A configuration with this name already exists in this offering. Use a unique name"));
            }
            for (int i = 0; i < sp.size(); ++i) {
                SimpleItypeConfig sic = (SimpleItypeConfig)sp.elementAt(i);
                if (!this.getUnlimited().booleanValue() && ApplicationProperty.ConfigEditCheckLimits.isTrue()) {
                    int numClasses = sic.getNumClasses();
                    int maxLimitPerClass = sic.getMaxLimitPerClass();
                    if (numClasses == 1 && maxLimitPerClass != this.limit) {
                        sic.setHasError(true);
                        errors.add("subparts", new ActionMessage("errors.equal", (Object)(lblMax + " per class for <u>" + sic.getItype().getDesc() + "</u>"), (Object)("Configuration limit of " + this.limit)));
                    }
                    if (numClasses > 1 && maxLimitPerClass * numClasses < this.limit) {
                        sic.setHasError(true);
                        errors.add("subparts", new ActionMessage("errors.integerGtEq", (Object)("Sum of class limits <u>" + sic.getItype().getDesc() + "</u>"), (Object)("Configuration limit of " + this.limit)));
                    }
                }
                this.checkInputfields(request, errors, sic, lblMax, this.getUnlimited());
                short errCode = this.checkChildSubpart(request, errors, sic, lblMax, this.getUnlimited());
                if (errCode == 0) continue;
                String errM = "Subparts that are grouped under <u>" + sic.getItype().getDesc() + "</u> must <br>";
                if (errCode == -1) {
                    errM = errM + "&nbsp; &nbsp; &nbsp; have number of classes that is a multiple of " + sic.getNumClasses() + ".";
                }
                if (errCode == -2) {
                    errM = errM + "&nbsp; &nbsp; &nbsp; have a " + lblMax.toLowerCase() + " per class <= " + lblMax.toLowerCase() + " per class of " + sic.getMaxLimitPerClass() + ".";
                }
                if (errCode == -3) {
                    errM = errM + "&nbsp; &nbsp; &nbsp; not accomodate lesser number of students.";
                }
                errors.add("subparts", new ActionMessage("errors.generic", (Object)errM));
            }
        }
        return errors;
    }

    private void checkInputfields(HttpServletRequest request, ActionErrors errors, SimpleItypeConfig sic, String lblMax, boolean unlimited) {
        int mxlpc = sic.getMaxLimitPerClass();
        int mnlpc = sic.getMinLimitPerClass();
        int nc = sic.getNumClasses();
        int nr = sic.getNumRooms();
        int mpw = sic.getMinPerWeek();
        float rc = sic.getRoomRatio();
        String lblSubpart = " for <u>" + sic.getItype().getDesc() + "</u>";
        long indx = sic.getId();
        int ct = errors.size();
        if (!unlimited) {
            if (mxlpc < 0) {
                errors.add("subparts" + indx, new ActionMessage("errors.integerGtEq", (Object)(lblMax + " per class" + lblSubpart), (Object)"0"));
            } else if (mxlpc > this.limit && ApplicationProperty.ConfigEditCheckLimits.isTrue()) {
                if (nc > 1) {
                    errors.add("subparts" + indx, new ActionMessage("errors.integerLtEq", (Object)(lblMax + " per class of " + mxlpc + lblSubpart), (Object)(" Configuration limit of " + this.limit)));
                }
            } else {
                if (request.getParameter("varLimits") == null) {
                    mnlpc = mxlpc;
                }
                if (mnlpc < 0) {
                    errors.add("subparts" + indx, new ActionMessage("errors.integerGtEq", (Object)("Min limit per class" + lblSubpart), (Object)"0"));
                }
                if (mnlpc > mxlpc) {
                    errors.add("subparts" + indx, new ActionMessage("errors.integerLtEq", (Object)("Min limit per class" + lblSubpart), (Object)"Max limit per class"));
                }
                if (nc <= 0) {
                    errors.add("subparts" + indx, new ActionMessage("errors.integerGt", (Object)("Number of classes" + lblSubpart), (Object)"0"));
                }
                if (nc > ApplicationProperty.SubpartMaxNumClasses.intValue()) {
                    errors.add("subparts" + indx, new ActionMessage("errors.integerLtEq", (Object)("Number of classes" + lblSubpart), (Object)ApplicationProperty.SubpartMaxNumClasses.value()));
                }
                if (nr < 0) {
                    errors.add("subparts" + indx, new ActionMessage("errors.integerGtEq", (Object)("Number of rooms" + lblSubpart), (Object)"0"));
                }
                if (mpw < 0) {
                    errors.add("subparts" + indx, new ActionMessage("errors.integerGtEq", (Object)("Minutes per week" + lblSubpart), (Object)"0"));
                }
                if (mpw == 0 && nr != 0) {
                    errors.add("subparts" + indx, new ActionMessage("errors.generic", (Object)("Minutes per week " + lblSubpart + " can be 0 only if number of rooms is 0")));
                }
                if (rc < 0.0f) {
                    errors.add("subparts" + indx, new ActionMessage("errors.integerGtEq", (Object)("Room ratio" + lblSubpart), (Object)"0.0"));
                }
            }
        } else {
            if (nc <= 0) {
                errors.add("subparts" + indx, new ActionMessage("errors.integerGt", (Object)("Number of classes" + lblSubpart), (Object)"0"));
            }
            if (nc > ApplicationProperty.SubpartMaxNumClasses.intValue()) {
                errors.add("subparts" + indx, new ActionMessage("errors.integerLtEq", (Object)("Number of classes" + lblSubpart), (Object)ApplicationProperty.SubpartMaxNumClasses.value()));
            }
            if (mpw < 0) {
                errors.add("subparts" + indx, new ActionMessage("errors.integerGtEq", (Object)("Minutes per week" + lblSubpart), (Object)"0"));
            }
        }
        if (errors.size() > ct) {
            sic.setHasError(true);
        }
    }

    private short checkChildSubpart(HttpServletRequest request, ActionErrors errors, SimpleItypeConfig sic, String lblMax, boolean unlimited) {
        Vector csp = sic.getSubparts();
        if (csp != null && csp.size() > 0) {
            for (int i = 0; i < csp.size(); ++i) {
                short errCode;
                SimpleItypeConfig csic = (SimpleItypeConfig)csp.elementAt(i);
                this.checkInputfields(request, errors, csic, lblMax, unlimited);
                if (!unlimited) {
                    if (sic.getNumClasses() != 0 && csic.getNumClasses() % sic.getNumClasses() != 0) {
                        csic.setHasError(true);
                        return -1;
                    }
                    if (csic.getMaxLimitPerClass() > sic.getMaxLimitPerClass()) {
                        csic.setHasError(true);
                        return -2;
                    }
                    if (csic.getNumClasses() * csic.getMaxLimitPerClass() < sic.getNumClasses() * sic.getMaxLimitPerClass()) {
                        csic.setHasError(true);
                        return -3;
                    }
                } else if (sic.getNumClasses() != 0 && csic.getNumClasses() % sic.getNumClasses() != 0) {
                    csic.setHasError(true);
                    return -1;
                }
                if ((errCode = this.checkChildSubpart(request, errors, csic, lblMax, unlimited)) == 0) continue;
                return errCode;
            }
        }
        return 0;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.courseOfferingId = "";
        this.subjectArea = "";
        this.courseNumber = "";
        this.itype = "";
        this.limit = 0;
        this.op = "";
        this.unlimited = new Boolean(false);
        this.configCount = new Integer(0);
        this.configId = new Long(0L);
        this.name = null;
        this.catalogLinkLabel = null;
        this.catalogLinkLocation = null;
        this.durationType = null;
        this.durationTypeDefault = null;
        this.durationTypeEditable = false;
        this.instructionalMethod = null;
    }

    public Integer getConfigCount() {
        return this.configCount;
    }

    public void setConfigCount(Integer configCount) {
        this.configCount = configCount;
    }

    public String getSubjectArea() {
        return this.subjectArea;
    }

    public void setSubjectArea(String subjectArea) {
        this.subjectArea = subjectArea;
    }

    public String getCourseNumber() {
        return this.courseNumber;
    }

    public void setCourseNumber(String courseNumber) {
        this.courseNumber = courseNumber;
    }

    public String getCourseOfferingId() {
        return this.courseOfferingId;
    }

    public void setCourseOfferingId(String courseOfferingId) {
        this.courseOfferingId = courseOfferingId;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public Boolean getNotOffered() {
        return this.notOffered;
    }

    public void setNotOffered(Boolean notOffered) {
        this.notOffered = notOffered;
    }

    public String getItype() {
        return this.itype;
    }

    public void setItype(String itype) {
        this.itype = itype;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public String getInstrOfferingId() {
        return this.instrOfferingId;
    }

    public void setInstrOfferingId(String instrOfferingId) {
        this.instrOfferingId = instrOfferingId;
    }

    public Long getConfigId() {
        return this.configId;
    }

    public void setConfigId(Long configId) {
        this.configId = configId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getUnlimited() {
        return this.unlimited;
    }

    public void setUnlimited(Boolean unlimited) {
        this.unlimited = unlimited;
    }

    public String getInstrOfferingName() {
        return this.instrOfferingName;
    }

    public void setInstrOfferingName(String instrOfferingName) {
        this.instrOfferingName = instrOfferingName;
    }

    public String getCatalogLinkLabel() {
        return this.catalogLinkLabel;
    }

    public void setCatalogLinkLabel(String catalogLinkLabel) {
        this.catalogLinkLabel = catalogLinkLabel;
    }

    public String getCatalogLinkLocation() {
        return this.catalogLinkLocation;
    }

    public void setCatalogLinkLocation(String catalogLinkLocation) {
        this.catalogLinkLocation = catalogLinkLocation;
    }

    public Long getDurationType() {
        return this.durationType;
    }

    public void setDurationType(Long durationType) {
        this.durationType = durationType;
    }

    public String getDurationTypeDefault() {
        return this.durationTypeDefault;
    }

    public void setDurationTypeDefault(String durationTypeDefault) {
        this.durationTypeDefault = durationTypeDefault;
    }

    public List<IdValue> getDurationTypes() {
        ArrayList<IdValue> ret = new ArrayList<IdValue>();
        for (ClassDurationType type : ClassDurationType.findAll()) {
            if (!type.isVisible().booleanValue() && !type.getUniqueId().equals(this.durationType)) continue;
            ret.add(new IdValue(type.getUniqueId(), type.getLabel()));
        }
        return ret;
    }

    public String getDurationTypeText() {
        for (ClassDurationType type : ClassDurationType.findAll()) {
            if (!type.getUniqueId().equals(this.durationType)) continue;
            return type.getLabel();
        }
        return this.durationTypeDefault;
    }

    public boolean isDurationTypeEditable() {
        return this.durationTypeEditable;
    }

    public void setDurationTypeEditable(boolean durationTypeEditable) {
        this.durationTypeEditable = durationTypeEditable;
    }

    public Long getInstructionalMethod() {
        return this.instructionalMethod;
    }

    public void setInstructionalMethod(Long instructionalMethod) {
        this.instructionalMethod = instructionalMethod;
    }

    public List<IdValue> getInstructionalMethods() {
        ArrayList<IdValue> ret = new ArrayList<IdValue>();
        for (InstructionalMethod type : InstructionalMethod.findAll()) {
            if (!type.isVisible().booleanValue() && !type.getUniqueId().equals(this.instructionalMethod)) continue;
            ret.add(new IdValue(type.getUniqueId(), type.getLabel()));
        }
        return ret;
    }
}

