/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.util.MessageResources;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.util.DynamicList;
import org.unitime.timetable.util.DynamicListObjectFactory;
import org.unitime.timetable.util.IdValue;

public class ExamDistributionPrefsForm
extends ActionForm {
    private static final long serialVersionUID = -822886662425670241L;
    private String op;
    private String distPrefId;
    private String distType;
    private String prefLevel;
    private String description;
    private List subjectArea;
    private List courseNbr;
    private List exam;
    private Long iExamType;
    private String filterSubjectAreaId;
    private Collection filterSubjectAreas;
    private String filterCourseNbr;
    protected DynamicListObjectFactory factory = new DynamicListObjectFactory(){

        public Object create() {
            return new Long(-1L);
        }
    };

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        MessageResources rsc = (MessageResources)super.getServlet().getServletContext().getAttribute("org.apache.struts.action.MESSAGE");
        if (this.distType == null || this.distType.equals("-")) {
            errors.add("distType", new ActionMessage("errors.generic", (Object)"Select a distribution type. "));
        }
        if (this.prefLevel == null || this.prefLevel.equals("-")) {
            errors.add("prefLevel", new ActionMessage("errors.generic", (Object)"Select a preference level. "));
        }
        if (this.op.equals(rsc.getMessage("button.addNew")) || this.op.equals(rsc.getMessage("button.update"))) {
            // empty if block
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.op = "";
        this.distPrefId = "";
        this.distType = "-";
        this.prefLevel = "-";
        this.subjectArea = DynamicList.getInstance(new ArrayList(), this.factory);
        this.courseNbr = DynamicList.getInstance(new ArrayList(), this.factory);
        this.exam = DynamicList.getInstance(new ArrayList(), this.factory);
        this.filterSubjectAreaId = null;
        this.filterCourseNbr = null;
        this.filterSubjectAreas = new ArrayList();
        this.iExamType = null;
    }

    public String getDistPrefId() {
        return this.distPrefId;
    }

    public void setDistPrefId(String distPrefId) {
        this.distPrefId = distPrefId;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public String getPrefLevel() {
        return this.prefLevel;
    }

    public void setPrefLevel(String prefLevel) {
        this.prefLevel = prefLevel;
    }

    public String getDistType() {
        return this.distType;
    }

    public void setDistType(String distType) {
        this.distType = distType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List getSubjectAreaList() {
        return this.subjectArea;
    }

    public List getSubjectArea() {
        return this.subjectArea;
    }

    public Long getSubjectArea(int key) {
        try {
            return (Long)this.subjectArea.get(key);
        }
        catch (ClassCastException e) {
            return Long.valueOf(this.subjectArea.get(key).toString());
        }
    }

    public void setSubjectArea(int key, Long value) {
        this.subjectArea.set(key, value);
    }

    public void setSubjectArea(List subjectArea) {
        this.subjectArea = subjectArea;
    }

    public List getCourseNbr() {
        return this.courseNbr;
    }

    public Long getCourseNbr(int key) {
        try {
            return (Long)this.courseNbr.get(key);
        }
        catch (ClassCastException e) {
            return Long.valueOf(this.courseNbr.get(key).toString());
        }
    }

    public void setCourseNbr(int key, Long value) {
        this.courseNbr.set(key, value);
    }

    public void setCourseNbr(List courseNbr) {
        this.courseNbr = courseNbr;
    }

    public List getExam() {
        return this.exam;
    }

    public Long getExam(int key) {
        try {
            return (Long)this.exam.get(key);
        }
        catch (ClassCastException e) {
            return Long.valueOf(this.exam.get(key).toString());
        }
    }

    public void setExam(int key, Long value) {
        this.exam.set(key, value);
    }

    public void setExam(List itype) {
        this.exam = itype;
    }

    public void deleteExam(int key) {
        this.subjectArea.remove(key);
        this.courseNbr.remove(key);
        this.exam.remove(key);
    }

    public void swapExams(int i1, int i2) {
        Object objSa1 = this.subjectArea.get(i1);
        Object objCo1 = this.courseNbr.get(i1);
        Object objEx1 = this.exam.get(i1);
        Object objSa2 = this.subjectArea.get(i2);
        Object objCo2 = this.courseNbr.get(i2);
        Object objEx2 = this.exam.get(i2);
        this.subjectArea.set(i1, objSa2);
        this.subjectArea.set(i2, objSa1);
        this.courseNbr.set(i1, objCo2);
        this.courseNbr.set(i2, objCo1);
        this.exam.set(i1, objEx2);
        this.exam.set(i2, objEx1);
    }

    public String getFilterSubjectAreaId() {
        return this.filterSubjectAreaId;
    }

    public void setFilterSubjectAreaId(String filterSubjectAreaId) {
        this.filterSubjectAreaId = filterSubjectAreaId;
    }

    public String getFilterCourseNbr() {
        return this.filterCourseNbr;
    }

    public void setFilterCourseNbr(String filterCourseNbr) {
        this.filterCourseNbr = filterCourseNbr;
    }

    public Collection getFilterSubjectAreas() {
        return this.filterSubjectAreas;
    }

    public void setFilterSubjectAreas(Collection filterSubjectAreas) {
        this.filterSubjectAreas = filterSubjectAreas;
    }

    public Collection getCourseNbrs(int idx) {
        Vector<IdValue> ret = new Vector<IdValue>();
        boolean contains = false;
        if (this.getSubjectArea(idx) >= 0L) {
            Iterator i = new CourseOfferingDAO().getSession().createQuery("select co.uniqueId, co.courseNbr, co.title from CourseOffering co where co.subjectArea.uniqueId = :subjectAreaId and co.instructionalOffering.notOffered = false order by co.courseNbr ").setFetchSize(200).setCacheable(true).setLong("subjectAreaId", this.getSubjectArea(idx).longValue()).iterate();
            while (i.hasNext()) {
                Object[] o = (Object[])i.next();
                ret.add(new IdValue((Long)o[0], (String)o[1] + " - " + (String)o[2]));
                if (!o[0].equals(this.getCourseNbr(idx))) continue;
                contains = true;
            }
        }
        if (!contains) {
            this.setCourseNbr(idx, -1L);
        }
        if (ret.size() == 1) {
            this.setCourseNbr(idx, ((IdValue)ret.firstElement()).getId());
        } else {
            ret.insertElementAt(new IdValue(-1L, "-"), 0);
        }
        return ret;
    }

    public Collection getExams(int idx) {
        Vector<IdValue> ret = new Vector<IdValue>();
        boolean contains = false;
        if (this.getCourseNbr(idx) >= 0L) {
            TreeSet exams = new TreeSet(Exam.findExamsOfCourseOffering(this.getCourseNbr(idx), this.getExamType()));
            for (Exam exam : exams) {
                ret.add(new IdValue(exam.getUniqueId(), exam.getLabel()));
                if (!exam.getUniqueId().equals(this.getExam(idx))) continue;
                contains = true;
            }
        }
        if (!contains) {
            this.setExam(idx, -1L);
        }
        if (ret.size() == 1) {
            this.setCourseNbr(idx, ((IdValue)ret.firstElement()).getId());
        } else {
            ret.insertElementAt(new IdValue(-1L, "-"), 0);
        }
        return ret;
    }

    public Long getExamType() {
        return this.iExamType;
    }

    public void setExamType(Long type) {
        this.iExamType = type;
    }
}

