/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.OutputStream;
import java.util.Date;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.form.ExamGridForm;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.webutil.timegrid.PdfExamGridTable;

@Service(value="/examGrid")
public class ExamGridAction
extends Action {
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TreeSet<ExamType> types;
        String op;
        ExamGridForm myForm = (ExamGridForm)form;
        this.sessionContext.checkPermission(Right.ExaminationTimetable);
        String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        if (op == null && request.getParameter("resource") != null) {
            op = "Change";
        }
        if ("Change".equals(op) || "Export PDF".equals(op)) {
            myForm.save(this.sessionContext);
        }
        myForm.load(this.sessionContext);
        if (myForm.getExamType() == null && !(types = ExamType.findAllUsed(this.sessionContext.getUser().getCurrentAcademicSessionId())).isEmpty()) {
            myForm.setExamType(types.first().getUniqueId());
        }
        if ("Cbs".equals(op)) {
            if (request.getParameter("resource") != null) {
                myForm.setResource(Integer.parseInt(request.getParameter("resource")));
            }
            if (request.getParameter("filter") != null) {
                myForm.setFilter(request.getParameter("filter"));
            }
        }
        if (RoomAvailability.getInstance() != null && myForm.getExamType() != null) {
            String exclude;
            Session session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
            Date[] bounds = ExamPeriod.getBounds(session, myForm.getExamType());
            String string2 = exclude = ((ExamType)ExamTypeDAO.getInstance().get(myForm.getExamType())).getType() == 0 ? RoomAvailabilityInterface.sFinalExamType : RoomAvailabilityInterface.sMidtermExamType;
            if (bounds != null) {
                RoomAvailability.getInstance().activate(session, bounds[0], bounds[1], exclude, false);
                RoomAvailability.setAvailabilityWarning(request, session, myForm.getExamType(), true, false);
            }
        }
        PdfExamGridTable table = new PdfExamGridTable(myForm, this.sessionContext, this.examinationSolverService.getSolver());
        request.setAttribute("table", (Object)table);
        if ("Export PDF".equals(op)) {
            OutputStream out = ExportUtils.getPdfOutputStream(response, "timetable");
            table.export(out);
            out.flush();
            out.close();
            return null;
        }
        myForm.setOp("Change");
        LookupTables.setupExamTypes(request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamTimetable);
        return mapping.findForward("showGrid");
    }
}

