/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.timetable.form.EditRoomGroupForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.RoomGroupDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/editRoomGroup")
public class EditRoomGroupAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EditRoomGroupForm editRoomGroupForm = (EditRoomGroupForm)form;
        MessageResources rsc = this.getResources(request);
        String doit = editRoomGroupForm.getDoit();
        if (doit != null && doit.equals(rsc.getMessage("button.returnToRoomDetail"))) {
            response.sendRedirect("roomDetail.do?id=" + editRoomGroupForm.getId());
            return null;
        }
        if (doit != null && doit.equals(rsc.getMessage("button.update"))) {
            this.doUpdate(editRoomGroupForm, request);
            return mapping.findForward("showRoomDetail");
        }
        LocationDAO ldao = new LocationDAO();
        Long id = Long.valueOf(request.getParameter("id"));
        Location location = (Location)ldao.get(id);
        if (location instanceof Room) {
            Room r = (Room)location;
            editRoomGroupForm.setName(r.getLabel());
        } else if (location instanceof NonUniversityLocation) {
            NonUniversityLocation nonUnivLocation = (NonUniversityLocation)location;
            editRoomGroupForm.setName(nonUnivLocation.getName());
        } else {
            ActionMessages errors = new ActionMessages();
            errors.add("editRoomGroup", new ActionMessage("errors.lookup.notFound", (Object)"Room Group"));
            this.saveErrors(request, errors);
        }
        this.sessionContext.checkPermission(location, Right.RoomEditGroups);
        boolean editGlobalGroups = this.sessionContext.hasPermission(location, Right.RoomEditGlobalGroups);
        for (RoomGroup rg : RoomGroup.getAllGlobalRoomGroups(location.getSession())) {
            editRoomGroupForm.addToGlobalRoomGroups(rg, editGlobalGroups, location.hasGroup(rg));
        }
        TreeSet<Department> departments = Department.getUserDepartments(this.sessionContext.getUser());
        for (Department department : departments) {
            for (RoomGroup rg : RoomGroup.getAllDepartmentRoomGroups(department)) {
                editRoomGroupForm.addToMangaerRoomGroups(rg, true, location.hasGroup(rg));
            }
        }
        for (Department department : Department.findAllExternal(location.getSession().getUniqueId())) {
            if (departments.contains(department)) continue;
            for (RoomGroup rg : RoomGroup.getAllDepartmentRoomGroups(department)) {
                editRoomGroupForm.addToMangaerRoomGroups(rg, false, location.hasGroup(rg));
            }
        }
        return mapping.findForward("showEditRoomGroup");
    }

    private void doUpdate(EditRoomGroupForm editRoomGroupForm, HttpServletRequest request) throws Exception {
        Session hibSession = LocationDAO.getInstance().getSession();
        Transaction tx = null;
        try {
            TreeSet<Department> departments;
            tx = hibSession.beginTransaction();
            Location location = (Location)LocationDAO.getInstance().get(Long.valueOf(request.getParameter("id")), hibSession);
            this.sessionContext.checkPermission(location, Right.RoomEditGroups);
            boolean editGlobalGroups = this.sessionContext.hasPermission(location, Right.RoomEditGlobalGroups);
            if (editGlobalGroups && editRoomGroupForm.getGlobalRoomGroupsAssigned() != null) {
                List globalSelected = editRoomGroupForm.getGlobalRoomGroupsAssigned();
                List globalRg = editRoomGroupForm.getGlobalRoomGroupIds();
                if (globalSelected.size() == 0) {
                    for (String rgId : globalRg) {
                        RoomGroup rg = (RoomGroup)RoomGroupDAO.getInstance().get(Long.valueOf(rgId), hibSession);
                        rg.getRooms().remove(location);
                        location.getRoomGroups().remove(rg);
                        hibSession.saveOrUpdate((Object)rg);
                    }
                } else {
                    int i = 0;
                    for (String rgId : globalRg) {
                        String selected = (String)globalSelected.get(i);
                        RoomGroup rg = (RoomGroup)RoomGroupDAO.getInstance().get(Long.valueOf(rgId), hibSession);
                        if (selected == null) continue;
                        if (selected.equalsIgnoreCase("on") || selected.equalsIgnoreCase("true")) {
                            if (!rg.hasLocation(location)) {
                                rg.getRooms().add(location);
                                location.getRoomGroups().add(rg);
                            }
                        } else if (rg.hasLocation(location)) {
                            rg.getRooms().remove(location);
                            location.getRoomGroups().remove(rg);
                        }
                        hibSession.saveOrUpdate((Object)rg);
                        ++i;
                    }
                }
            }
            if (!(departments = Department.getUserDepartments(this.sessionContext.getUser())).isEmpty() && editRoomGroupForm.getManagerRoomGroupsAssigned() != null) {
                List managerSelected = editRoomGroupForm.getManagerRoomGroupsAssigned();
                List managerRg = editRoomGroupForm.getManagerRoomGroupIds();
                if (managerSelected.size() == 0) {
                    for (String rgId : managerRg) {
                        RoomGroup rg = (RoomGroup)RoomGroupDAO.getInstance().get(Long.valueOf(rgId), hibSession);
                        if (rg.getDepartment() == null || !departments.contains(rg.getDepartment())) continue;
                        rg.getRooms().remove(location);
                        location.getRoomGroups().remove(rg);
                        hibSession.saveOrUpdate((Object)rg);
                    }
                } else {
                    int i = 0;
                    for (String rgId : managerRg) {
                        RoomGroup rg;
                        String selected = (String)managerSelected.get(i);
                        if (selected == null || (rg = (RoomGroup)RoomGroupDAO.getInstance().get(Long.valueOf(rgId), hibSession)).getDepartment() == null || !departments.contains(rg.getDepartment())) continue;
                        if (selected.equalsIgnoreCase("on") || selected.equalsIgnoreCase("true")) {
                            if (!rg.hasLocation(location)) {
                                rg.getRooms().add(location);
                                location.getRoomGroups().add(rg);
                            }
                        } else if (rg.hasLocation(location)) {
                            rg.getRooms().remove(location);
                            location.getRoomGroups().remove(rg);
                        }
                        hibSession.saveOrUpdate((Object)rg);
                        ++i;
                    }
                }
            }
            hibSession.saveOrUpdate((Object)location);
            ChangeLog.addChange(hibSession, this.sessionContext, location, ChangeLog.Source.ROOM_GROUP_EDIT, ChangeLog.Operation.UPDATE, null, location.getControllingDepartment());
            tx.commit();
            hibSession.refresh((Object)location);
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw e;
        }
    }
}

