/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.model;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.StudentCommittedConflict;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.model.Configuration;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.termination.TerminationCondition;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ToolBox;

public class FinalSectioning {
    private TimetableModel iModel = null;
    public static double sEps = 1.0E-4;
    private boolean iWeighStudents = false;

    public FinalSectioning(TimetableModel model) {
        this.iModel = model;
        this.iWeighStudents = model.getProperties().getPropertyBoolean("General.WeightStudents", this.iWeighStudents);
    }

    public void execute(Solution<Lecture, Placement> solution, TerminationCondition<Lecture, Placement> termination) {
        Progress p = Progress.getInstance(this.iModel);
        p.setStatus("Student Sectioning...");
        AbstractCollection variables = new ArrayList(this.iModel.variables());
        if (this.iModel.hasConstantVariables()) {
            for (Lecture lecture : this.iModel.constantVariables()) {
                variables.add(lecture);
            }
        }
        while (!variables.isEmpty() && (termination == null || termination.canContinue(solution))) {
            p.setPhase("moving students ...", variables.size());
            HashSet<Lecture> lecturesToRecompute = new HashSet<Lecture>(variables.size());
            for (Lecture lecture : variables) {
                Configuration cfg;
                if (lecture.getParent() == null && (cfg = lecture.getConfiguration()) != null && cfg.getAltConfigurations().size() > 1) {
                    this.findAndPerformMoves(solution.getAssignment(), cfg, lecturesToRecompute);
                }
                this.findAndPerformMoves(solution.getAssignment(), lecture, lecturesToRecompute);
                p.incProgress();
            }
            variables = lecturesToRecompute;
        }
    }

    public void resection(Assignment<Lecture, Placement> assignment, Lecture lecture, boolean recursive, boolean configAsWell) {
        Configuration cfg;
        HashSet<Lecture> variables = new HashSet<Lecture>();
        this.findAndPerformMoves(assignment, lecture, variables);
        if (configAsWell && (cfg = lecture.getConfiguration()) != null && cfg.getAltConfigurations().size() > 1) {
            this.findAndPerformMoves(assignment, cfg, variables);
        }
        if (recursive) {
            while (!variables.isEmpty()) {
                HashSet<Lecture> lecturesToRecompute = new HashSet<Lecture>();
                for (Lecture l : variables) {
                    Configuration cfg2;
                    if (configAsWell && l.getParent() == null && (cfg2 = l.getConfiguration()) != null && cfg2.getAltConfigurations().size() > 1) {
                        this.findAndPerformMoves(assignment, cfg2, lecturesToRecompute);
                    }
                    this.findAndPerformMoves(assignment, l, lecturesToRecompute);
                }
                variables = lecturesToRecompute;
            }
        }
    }

    public void findAndPerformMoves(Assignment<Lecture, Placement> assignment, Lecture lecture, HashSet<Lecture> lecturesToRecompute) {
        Set<Student> conflictStudents;
        Move m;
        if (lecture.sameSubpartLectures() == null || assignment.getValue(lecture) == null) {
            return;
        }
        if (lecture.getClassLimitConstraint() != null) {
            while (lecture.nrWeightedStudents() > sEps + (double)lecture.minClassLimit() && (m = this.findAwayMove(assignment, lecture)) != null) {
                if (m.perform(assignment)) {
                    lecturesToRecompute.add(m.secondLecture());
                    continue;
                }
                m.getUndoMove().perform(assignment);
            }
        } else if (!this.iWeighStudents) {
            while ((m = this.findAwayMove(assignment, lecture)) != null) {
                if (m.perform(assignment)) {
                    lecturesToRecompute.add(m.secondLecture());
                    continue;
                }
                m.getUndoMove().perform(assignment);
            }
        }
        if ((conflictStudents = lecture.conflictStudents(assignment)) == null || conflictStudents.isEmpty()) {
            return;
        }
        if (lecture.sameSubpartLectures().size() > 1) {
            for (Student student : conflictStudents) {
                Move m2;
                if (assignment.getValue(lecture) == null || (m2 = this.findMove(assignment, lecture, student)) == null) continue;
                if (m2.perform(assignment)) {
                    lecturesToRecompute.add(m2.secondLecture());
                    continue;
                }
                m2.getUndoMove().perform(assignment);
            }
        } else {
            for (Student student : conflictStudents) {
                for (Lecture anotherLecture : lecture.conflictLectures(assignment, student)) {
                    if (anotherLecture.equals(lecture) || anotherLecture.sameSubpartLectures() == null || assignment.getValue(anotherLecture) == null || anotherLecture.sameSubpartLectures().size() <= 1) continue;
                    lecturesToRecompute.add(anotherLecture);
                }
            }
        }
    }

    public void findAndPerformMoves(Assignment<Lecture, Placement> assignment, Configuration configuration, HashSet<Lecture> lecturesToRecompute) {
        for (Student student : configuration.students()) {
            MoveBetweenCfgs m;
            if (!configuration.hasConflict(assignment, student) || (m = this.findMove(assignment, configuration, student)) == null) continue;
            if (m.perform(assignment)) {
                lecturesToRecompute.addAll(m.secondLectures());
                continue;
            }
            m.getUndoMove().perform(assignment);
        }
    }

    public Move findAwayMove(Assignment<Lecture, Placement> assignment, Lecture lecture) {
        ArrayList<Move> bestMoves = null;
        double bestDelta = 0.0;
        for (Student student : lecture.students()) {
            if (!student.canUnenroll(lecture)) continue;
            for (Lecture sameLecture : lecture.sameSubpartLectures()) {
                Move m;
                double studentWeight = student.getOfferingWeight(sameLecture.getConfiguration());
                if (!student.canEnroll(sameLecture) || sameLecture.equals(lecture) || assignment.getValue(sameLecture) == null || !(sameLecture.nrWeightedStudents() + studentWeight <= sEps + (double)sameLecture.classLimit(assignment)) || (m = this.createMove(assignment, lecture, student, sameLecture, null)) == null || m.isTabu()) continue;
                double delta = m.getDelta(assignment);
                if (delta < bestDelta) {
                    if (bestMoves == null) {
                        bestMoves = new ArrayList<Move>();
                    } else {
                        bestMoves.clear();
                    }
                    bestMoves.add(m);
                    bestDelta = delta;
                    continue;
                }
                if (delta != bestDelta) continue;
                if (bestMoves == null) {
                    bestMoves = new ArrayList();
                }
                bestMoves.add(m);
            }
        }
        if (bestDelta < -sEps && bestMoves != null) {
            Move m = (Move)ToolBox.random(bestMoves);
            return m;
        }
        return null;
    }

    public Move findMove(Assignment<Lecture, Placement> assignment, Lecture lecture, Student student) {
        if (!student.canUnenroll(lecture)) {
            return null;
        }
        double bestDelta = 0.0;
        ArrayList<Move> bestMoves = null;
        double studentWeight = student.getOfferingWeight(lecture.getConfiguration());
        for (Lecture sameLecture : lecture.sameSubpartLectures()) {
            if (!student.canEnroll(sameLecture) || sameLecture.equals(lecture) || assignment.getValue(sameLecture) == null) continue;
            if (sameLecture.nrWeightedStudents() + studentWeight <= sEps + (double)sameLecture.classLimit(assignment)) {
                Move m = this.createMove(assignment, lecture, student, sameLecture, null);
                if (m == null || m.isTabu()) continue;
                double delta = m.getDelta(assignment);
                if (delta < bestDelta) {
                    if (bestMoves == null) {
                        bestMoves = new ArrayList<Move>();
                    } else {
                        bestMoves.clear();
                    }
                    bestMoves.add(m);
                    bestDelta = delta;
                } else if (delta == bestDelta) {
                    if (bestMoves == null) {
                        bestMoves = new ArrayList();
                    }
                    bestMoves.add(m);
                }
            }
            for (Student anotherStudent : sameLecture.students()) {
                double anotherStudentWeight;
                if (!anotherStudent.canUnenroll(sameLecture) || !anotherStudent.canEnroll(lecture) || (anotherStudentWeight = anotherStudent.getOfferingWeight(lecture.getConfiguration())) != studentWeight && (sameLecture.nrWeightedStudents() - anotherStudentWeight + studentWeight > sEps + (double)sameLecture.classLimit(assignment) || lecture.nrWeightedStudents() - studentWeight + anotherStudentWeight > sEps + (double)lecture.classLimit(assignment))) continue;
                if (bestDelta < -sEps && bestMoves != null && bestMoves.size() > 10) break;
                Move m = this.createMove(assignment, lecture, student, sameLecture, anotherStudent);
                if (m == null || m.isTabu()) continue;
                double delta = m.getDelta(assignment);
                if (delta < bestDelta) {
                    if (bestMoves == null) {
                        bestMoves = new ArrayList();
                    } else {
                        bestMoves.clear();
                    }
                    bestMoves.add(m);
                    bestDelta = delta;
                    continue;
                }
                if (delta != bestDelta) continue;
                if (bestMoves == null) {
                    bestMoves = new ArrayList();
                }
                bestMoves.add(m);
            }
            if (!(Math.abs(bestDelta) < sEps) || bestMoves == null || bestMoves.size() <= 10) continue;
            break;
        }
        if (bestDelta < -sEps && bestMoves != null) {
            return (Move)ToolBox.random(bestMoves);
        }
        return null;
    }

    public MoveBetweenCfgs findMove(Assignment<Lecture, Placement> assignment, Configuration config, Student student) {
        double bestDelta = 0.0;
        ArrayList<MoveBetweenCfgs> bestMoves = null;
        for (Configuration altConfig : config.getAltConfigurations()) {
            if (altConfig.equals(config)) continue;
            MoveBetweenCfgs m = this.createMove(assignment, config, student, altConfig, null);
            if (m != null && !m.isTabu()) {
                double delta = m.getDelta(assignment);
                if (delta < bestDelta) {
                    if (bestMoves == null) {
                        bestMoves = new ArrayList<MoveBetweenCfgs>();
                    } else {
                        bestMoves.clear();
                    }
                    bestMoves.add(m);
                    bestDelta = delta;
                } else if (delta == bestDelta) {
                    if (bestMoves == null) {
                        bestMoves = new ArrayList();
                    }
                    bestMoves.add(m);
                }
            }
            for (Student anotherStudent : altConfig.students()) {
                if (bestDelta < -sEps && bestMoves != null && bestMoves.size() > 10) break;
                m = this.createMove(assignment, config, student, altConfig, anotherStudent);
                if (m == null || m.isTabu()) continue;
                double delta = m.getDelta(assignment);
                if (delta < bestDelta) {
                    if (bestMoves == null) {
                        bestMoves = new ArrayList();
                    } else {
                        bestMoves.clear();
                    }
                    bestMoves.add(m);
                    bestDelta = delta;
                    continue;
                }
                if (delta != bestDelta) continue;
                if (bestMoves == null) {
                    bestMoves = new ArrayList();
                }
                bestMoves.add(m);
            }
            if (!(Math.abs(bestDelta) < sEps) || bestMoves == null || bestMoves.size() <= 10) continue;
            break;
        }
        if (bestDelta < -sEps && bestMoves != null) {
            return (MoveBetweenCfgs)ToolBox.random(bestMoves);
        }
        return null;
    }

    public Move createMove(Assignment<Lecture, Placement> assignment, Lecture firstLecture, Student firstStudent, Lecture secondLecture, Student secondStudent) {
        return this.createMove(assignment, firstLecture, firstStudent, secondLecture, secondStudent, null);
    }

    public Move createMove(Assignment<Lecture, Placement> assignment, Lecture firstLecture, Student firstStudent, Lecture secondLecture, Student secondStudent, Move parentMove) {
        Move move;
        block29: {
            Lecture firstChildLecture;
            if (!firstStudent.canUnenroll(firstLecture) || !firstStudent.canEnroll(secondLecture)) {
                return null;
            }
            if (!(secondStudent == null || secondStudent.canUnenroll(secondLecture) && secondStudent.canEnroll(firstLecture))) {
                return null;
            }
            if (firstLecture.getParent() != null && secondLecture.getParent() == null) {
                return null;
            }
            if (firstLecture.getParent() == null && secondLecture.getParent() != null) {
                return null;
            }
            move = new Move(firstLecture, firstStudent, secondLecture, secondStudent);
            if (parentMove == null) {
                Lecture l1 = firstLecture;
                Lecture l2 = secondLecture;
                while (l1.getParent() != null && l2.getParent() != null && !l1.getParent().equals(l2.getParent())) {
                    double w2;
                    Lecture p1 = l1.getParent();
                    Lecture p2 = l2.getParent();
                    if (assignment.getValue(p1) == null || assignment.getValue(p2) == null) {
                        return null;
                    }
                    double w1 = firstStudent.getOfferingWeight(p1.getConfiguration());
                    double d = w2 = secondStudent == null ? 0.0 : secondStudent.getOfferingWeight(p2.getConfiguration());
                    if (w1 != w2) {
                        if (p1.nrWeightedStudents() - w1 + w2 > sEps + (double)p1.classLimit(assignment)) {
                            return null;
                        }
                        if (p2.nrWeightedStudents() - w2 + w1 > sEps + (double)p2.classLimit(assignment)) {
                            return null;
                        }
                    }
                    if (!(firstStudent.canUnenroll(p2) && firstStudent.canEnroll(p1) && (secondStudent == null || secondStudent.canUnenroll(p1) && secondStudent.canEnroll(p2)))) {
                        return null;
                    }
                    move.addChildMove(new Move(p1, firstStudent, p2, secondStudent));
                    l1 = p1;
                    l2 = p2;
                }
            }
            if (firstLecture.hasAnyChildren() != secondLecture.hasAnyChildren()) {
                return null;
            }
            if (!firstLecture.hasAnyChildren()) break block29;
            if (secondStudent != null) {
                for (Long subpartId : firstLecture.getChildrenSubpartIds()) {
                    double secondStudentWeight;
                    firstChildLecture = firstLecture.getChild(firstStudent, subpartId);
                    Lecture secondChildLecture = secondLecture.getChild(secondStudent, subpartId);
                    if (firstChildLecture == null || secondChildLecture == null) {
                        return null;
                    }
                    double firstStudentWeight = firstStudent.getOfferingWeight(firstChildLecture.getConfiguration());
                    if (firstStudentWeight != (secondStudentWeight = secondStudent.getOfferingWeight(secondChildLecture.getConfiguration()))) {
                        if (firstChildLecture.nrWeightedStudents() - firstStudentWeight + secondStudentWeight > sEps + (double)firstChildLecture.classLimit(assignment)) {
                            return null;
                        }
                        if (secondChildLecture.nrWeightedStudents() - secondStudentWeight + firstStudentWeight > sEps + (double)secondChildLecture.classLimit(assignment)) {
                            return null;
                        }
                    }
                    if (assignment.getValue(firstChildLecture) != null && assignment.getValue(secondChildLecture) != null) {
                        Move m = this.createMove(assignment, firstChildLecture, firstStudent, secondChildLecture, secondStudent, move);
                        if (m == null) {
                            return null;
                        }
                        move.addChildMove(m);
                        continue;
                    }
                    return null;
                }
            } else {
                for (Long subpartId : firstLecture.getChildrenSubpartIds()) {
                    firstChildLecture = firstLecture.getChild(firstStudent, subpartId);
                    if (firstChildLecture == null || assignment.getValue(firstChildLecture) == null) {
                        return null;
                    }
                    double firstStudentWeight = firstStudent.getOfferingWeight(firstChildLecture.getConfiguration());
                    List<Lecture> secondChildLectures = secondLecture.getChildren(subpartId);
                    if (secondChildLectures == null || secondChildLectures.isEmpty()) {
                        return null;
                    }
                    ArrayList<Move> bestMoves = null;
                    double bestDelta = 0.0;
                    for (Lecture secondChildLecture : secondChildLectures) {
                        Move m;
                        if (assignment.getValue(secondChildLecture) == null || secondChildLecture.nrWeightedStudents() + firstStudentWeight > sEps + (double)secondChildLecture.classLimit(assignment) || (m = this.createMove(assignment, firstChildLecture, firstStudent, secondChildLecture, secondStudent, move)) == null) continue;
                        double delta = m.getDelta(assignment);
                        if (bestMoves == null || delta < bestDelta) {
                            if (bestMoves == null) {
                                bestMoves = new ArrayList<Move>();
                            } else {
                                bestMoves.clear();
                            }
                            bestMoves.add(m);
                            bestDelta = delta;
                            continue;
                        }
                        if (delta != bestDelta) continue;
                        bestMoves.add(m);
                    }
                    if (bestDelta >= 0.0 || bestMoves == null) {
                        return null;
                    }
                    Move m = (Move)ToolBox.random(bestMoves);
                    move.addChildMove(m);
                }
            }
        }
        return move;
    }

    public MoveBetweenCfgs createMove(Assignment<Lecture, Placement> assignment, Configuration firstConfig, Student firstStudent, Configuration secondConfig, Student secondStudent) {
        MoveBetweenCfgs m = new MoveBetweenCfgs(firstConfig, firstStudent, secondConfig, secondStudent);
        for (Long subpartId : firstConfig.getTopSubpartIds()) {
            if (this.addLectures(assignment, firstStudent, secondStudent, m.firstLectures(), firstConfig.getTopLectures(subpartId))) continue;
            return null;
        }
        for (Long subpartId : secondConfig.getTopSubpartIds()) {
            if (this.addLectures(assignment, secondStudent, firstStudent, m.secondLectures(), secondConfig.getTopLectures(subpartId))) continue;
            return null;
        }
        return m;
    }

    private boolean addLectures(Assignment<Lecture, Placement> assignment, Student student, Student newStudent, Set<Lecture> studentLectures, Collection<Lecture> lectures) {
        Lecture lecture = null;
        if (lectures == null) {
            return false;
        }
        if (student != null) {
            for (Lecture l : lectures) {
                if (!l.students().contains(student)) continue;
                lecture = l;
                if (!student.canUnenroll(lecture)) {
                    return false;
                }
                break;
            }
        } else {
            int bestValue = 0;
            Lecture bestLecture = null;
            for (Lecture l : lectures) {
                int val = this.test(assignment, newStudent, l);
                if (val < 0 || bestLecture != null && bestValue <= val) continue;
                bestValue = val;
                bestLecture = l;
            }
            lecture = bestLecture;
        }
        if (lecture == null) {
            return false;
        }
        if (newStudent != null && !newStudent.canEnroll(lecture)) {
            return false;
        }
        studentLectures.add(lecture);
        if (lecture.getChildrenSubpartIds() != null) {
            for (Long subpartId : lecture.getChildrenSubpartIds()) {
                if (this.addLectures(assignment, student, newStudent, studentLectures, lecture.getChildren(subpartId))) continue;
                return false;
            }
        }
        return true;
    }

    public int test(Assignment<Lecture, Placement> assignment, Student student, Lecture lecture) {
        if (assignment.getValue(lecture) == null) {
            return -1;
        }
        double studentWeight = student.getOfferingWeight(lecture.getConfiguration());
        if (lecture.nrWeightedStudents() + studentWeight > sEps + (double)lecture.classLimit(assignment)) {
            return -1;
        }
        if (!student.canEnroll(lecture)) {
            return -1;
        }
        int test = 0;
        for (Lecture x : student.getLectures()) {
            if (assignment.getValue(x) == null || !JenrlConstraint.isInConflict(assignment.getValue(lecture), assignment.getValue(x), this.iModel.getDistanceMetric())) continue;
            ++test;
        }
        test += student.countConflictPlacements(assignment.getValue(lecture));
        if (lecture.getChildrenSubpartIds() != null) {
            for (Long subpartId : lecture.getChildrenSubpartIds()) {
                int bestTest = -1;
                for (Lecture child : lecture.getChildren(subpartId)) {
                    int t = this.test(assignment, student, child);
                    if (t < 0 || bestTest >= 0 && bestTest <= t) continue;
                    bestTest = t;
                }
                if (bestTest < 0) {
                    return -1;
                }
                test += bestTest;
            }
        }
        return test;
    }

    public class MoveBetweenCfgs {
        Configuration iFirstConfig = null;
        Set<Lecture> iFirstLectures = new HashSet<Lecture>();
        Student iFirstStudent = null;
        Configuration iSecondConfig = null;
        Set<Lecture> iSecondLectures = new HashSet<Lecture>();
        Student iSecondStudent = null;

        public MoveBetweenCfgs(Configuration firstConfig, Student firstStudent, Configuration secondConfig, Student secondStudent) {
            this.iFirstConfig = firstConfig;
            this.iFirstStudent = firstStudent;
            this.iSecondConfig = secondConfig;
            this.iSecondStudent = secondStudent;
        }

        public Configuration firstConfiguration() {
            return this.iFirstConfig;
        }

        public Student firstStudent() {
            return this.iFirstStudent;
        }

        public Set<Lecture> firstLectures() {
            return this.iFirstLectures;
        }

        public Configuration secondConfiguration() {
            return this.iSecondConfig;
        }

        public Student secondStudent() {
            return this.iSecondStudent;
        }

        public Set<Lecture> secondLectures() {
            return this.iSecondLectures;
        }

        public MoveBetweenCfgs getUndoMove() {
            MoveBetweenCfgs ret = new MoveBetweenCfgs(this.iSecondConfig, this.iFirstStudent, this.iFirstConfig, this.iSecondStudent);
            ret.secondLectures().addAll(this.iFirstLectures);
            ret.firstLectures().addAll(this.iSecondLectures);
            return ret;
        }

        public boolean perform(Assignment<Lecture, Placement> assignment) {
            int k;
            Object[] vars;
            JenrlConstraint jenrl;
            double conflicts = this.firstLectures().iterator().next().getModel().getCriterion(StudentConflict.class).getValue(assignment) + this.firstLectures().iterator().next().getModel().getCriterion(StudentCommittedConflict.class).getValue(assignment);
            this.firstStudent().removeConfiguration(this.firstConfiguration());
            this.firstStudent().addConfiguration(this.secondConfiguration());
            for (Lecture lecture : this.firstStudent().getLectures()) {
                for (Lecture firstLecture : this.firstLectures()) {
                    if (firstLecture.equals(lecture) || this.firstLectures().contains(lecture) && firstLecture.getClassId().compareTo(lecture.getClassId()) > 0 || (jenrl = firstLecture.jenrlConstraint(lecture)) == null) continue;
                    jenrl.decJenrl(assignment, this.firstStudent());
                    if (jenrl.getNrStudents() != 0) continue;
                    ((JenrlConstraint.JenrlConstraintContext)jenrl.getContext((Assignment)assignment)).unassigned(assignment, (Placement)null);
                    vars = jenrl.variables().toArray();
                    for (k = 0; k < vars.length; ++k) {
                        jenrl.removeVariable((Lecture)vars[k]);
                    }
                    FinalSectioning.this.iModel.removeConstraint(jenrl);
                }
            }
            if (this.secondStudent() != null) {
                this.secondStudent().removeConfiguration(this.secondConfiguration());
                this.secondStudent().addConfiguration(this.firstConfiguration());
                for (Lecture lecture : this.secondStudent().getLectures()) {
                    for (Lecture secondLecture : this.secondLectures()) {
                        if (secondLecture.equals(lecture) || this.secondLectures().contains(lecture) && secondLecture.getClassId().compareTo(lecture.getClassId()) > 0 || (jenrl = secondLecture.jenrlConstraint(lecture)) == null) continue;
                        jenrl.decJenrl(assignment, this.secondStudent());
                        if (jenrl.getNrStudents() != 0) continue;
                        ((JenrlConstraint.JenrlConstraintContext)jenrl.getContext((Assignment)assignment)).unassigned(assignment, (Placement)null);
                        vars = jenrl.variables().toArray();
                        for (k = 0; k < vars.length; ++k) {
                            jenrl.removeVariable((Lecture)vars[k]);
                        }
                        FinalSectioning.this.iModel.removeConstraint(jenrl);
                    }
                }
            }
            for (Lecture firstLecture : this.firstLectures()) {
                firstLecture.removeStudent(assignment, this.firstStudent());
                this.firstStudent().removeLecture(firstLecture);
                if (this.secondStudent() == null) continue;
                firstLecture.addStudent(assignment, this.secondStudent());
                this.secondStudent().addLecture(firstLecture);
            }
            for (Lecture secondLecture : this.secondLectures()) {
                secondLecture.addStudent(assignment, this.firstStudent());
                this.firstStudent().addLecture(secondLecture);
                if (this.secondStudent() == null) continue;
                secondLecture.removeStudent(assignment, this.secondStudent());
                this.secondStudent().removeLecture(secondLecture);
            }
            for (Lecture lecture : this.firstStudent().getLectures()) {
                for (Lecture secondLecture : this.secondLectures()) {
                    if (secondLecture.equals(lecture) || this.secondLectures().contains(lecture) && secondLecture.getClassId().compareTo(lecture.getClassId()) > 0) continue;
                    jenrl = secondLecture.jenrlConstraint(lecture);
                    if (jenrl == null) {
                        jenrl = new JenrlConstraint();
                        jenrl.addVariable(secondLecture);
                        jenrl.addVariable(lecture);
                        FinalSectioning.this.iModel.addConstraint(jenrl);
                    }
                    jenrl.incJenrl(assignment, this.firstStudent());
                }
            }
            if (this.secondStudent() != null) {
                for (Lecture lecture : this.secondStudent().getLectures()) {
                    for (Lecture firstLecture : this.firstLectures()) {
                        if (firstLecture.equals(lecture) || this.firstLectures().contains(lecture) && firstLecture.getClassId().compareTo(lecture.getClassId()) > 0) continue;
                        jenrl = firstLecture.jenrlConstraint(lecture);
                        if (jenrl == null) {
                            jenrl = new JenrlConstraint();
                            jenrl.addVariable(firstLecture);
                            jenrl.addVariable(lecture);
                            FinalSectioning.this.iModel.addConstraint(jenrl);
                        }
                        jenrl.incJenrl(assignment, this.secondStudent());
                    }
                }
            }
            return this.firstLectures().iterator().next().getModel().getCriterion(StudentConflict.class).getValue(assignment) + this.firstLectures().iterator().next().getModel().getCriterion(StudentCommittedConflict.class).getValue(assignment) < conflicts;
        }

        public double getDelta(Assignment<Lecture, Placement> assignment) {
            JenrlConstraint jenrl;
            double delta = 0.0;
            for (Lecture lecture : this.firstStudent().getLectures()) {
                if (assignment.getValue(lecture) == null) continue;
                for (Lecture firstLecture : this.firstLectures()) {
                    if (assignment.getValue(firstLecture) == null || firstLecture.equals(lecture) || (jenrl = firstLecture.jenrlConstraint(lecture)) == null || !jenrl.isInConflict(assignment)) continue;
                    delta -= jenrl.getJenrlWeight(this.firstStudent());
                }
                for (Lecture secondLecture : this.secondLectures()) {
                    if (assignment.getValue(secondLecture) == null || secondLecture.equals(lecture)) continue;
                    jenrl = secondLecture.jenrlConstraint(lecture);
                    if (jenrl != null) {
                        if (!jenrl.isInConflict(assignment)) continue;
                        delta += jenrl.getJenrlWeight(this.firstStudent());
                        continue;
                    }
                    if (!JenrlConstraint.isInConflict(assignment.getValue(secondLecture), assignment.getValue(lecture), FinalSectioning.this.iModel.getDistanceMetric())) continue;
                    delta += this.firstStudent().getJenrlWeight(secondLecture, lecture);
                }
            }
            if (this.secondStudent() != null) {
                for (Lecture lecture : this.secondStudent().getLectures()) {
                    if (assignment.getValue(lecture) == null) continue;
                    for (Lecture secondLecture : this.secondLectures()) {
                        if (assignment.getValue(secondLecture) == null || secondLecture.equals(lecture) || (jenrl = secondLecture.jenrlConstraint(lecture)) == null || !jenrl.isInConflict(assignment)) continue;
                        delta -= jenrl.getJenrlWeight(this.secondStudent());
                    }
                    for (Lecture firstLecture : this.firstLectures()) {
                        if (assignment.getValue(firstLecture) == null || firstLecture.equals(lecture)) continue;
                        jenrl = firstLecture.jenrlConstraint(lecture);
                        if (jenrl != null) {
                            if (!jenrl.isInConflict(assignment)) continue;
                            delta += jenrl.getJenrlWeight(this.secondStudent());
                            continue;
                        }
                        if (!JenrlConstraint.isInConflict(assignment.getValue(firstLecture), assignment.getValue(lecture), FinalSectioning.this.iModel.getDistanceMetric())) continue;
                        delta += this.secondStudent().getJenrlWeight(firstLecture, lecture);
                    }
                }
            }
            for (Lecture firstLecture : this.firstLectures()) {
                Placement p1 = assignment.getValue(firstLecture);
                if (p1 == null) continue;
                delta -= (double)this.firstStudent().countConflictPlacements(p1);
                if (this.secondStudent() == null) continue;
                delta += (double)this.secondStudent().countConflictPlacements(p1);
            }
            for (Lecture secondLecture : this.secondLectures()) {
                Placement p2 = assignment.getValue(secondLecture);
                if (p2 == null) continue;
                delta += (double)this.firstStudent().countConflictPlacements(p2);
                if (this.secondStudent() == null) continue;
                delta -= (double)this.secondStudent().countConflictPlacements(p2);
            }
            return delta;
        }

        public boolean isTabu() {
            return false;
        }

        public String toString() {
            return "Move{" + this.firstStudent() + "/" + this.firstConfiguration().getConfigId() + " <-> " + this.secondStudent() + "/" + this.secondConfiguration().getConfigId() + "}";
        }
    }

    public class Move {
        Lecture iFirstLecture = null;
        Student iFirstStudent = null;
        Lecture iSecondLecture = null;
        Student iSecondStudent = null;
        List<Move> iChildMoves = null;

        private Move(Lecture firstLecture, Student firstStudent, Lecture secondLecture, Student secondStudent) {
            this.iFirstLecture = firstLecture;
            this.iFirstStudent = firstStudent;
            this.iSecondLecture = secondLecture;
            this.iSecondStudent = secondStudent;
        }

        public Lecture firstLecture() {
            return this.iFirstLecture;
        }

        public Student firstStudent() {
            return this.iFirstStudent;
        }

        public Lecture secondLecture() {
            return this.iSecondLecture;
        }

        public Student secondStudent() {
            return this.iSecondStudent;
        }

        public void addChildMove(Move move) {
            if (this.iChildMoves == null) {
                this.iChildMoves = new ArrayList<Move>();
            }
            this.iChildMoves.add(move);
        }

        public List<Move> getChildMoves() {
            return this.iChildMoves;
        }

        public Move getUndoMove() {
            Move ret = new Move(this.iSecondLecture, this.iFirstStudent, this.iFirstLecture, this.iSecondStudent);
            if (this.iChildMoves != null) {
                for (Move move : this.iChildMoves) {
                    ret.addChildMove(move.getUndoMove());
                }
            }
            return ret;
        }

        public boolean perform(Assignment<Lecture, Placement> assignment) {
            int j;
            Object[] vars;
            JenrlConstraint jenrl;
            double conflicts = this.firstLecture().getModel().getCriterion(StudentConflict.class).getValue(assignment) + this.firstLecture().getModel().getCriterion(StudentCommittedConflict.class).getValue(assignment);
            for (Lecture lecture : this.firstStudent().getLectures()) {
                if (lecture.equals(this.firstLecture()) || (jenrl = this.firstLecture().jenrlConstraint(lecture)) == null) continue;
                jenrl.decJenrl(assignment, this.firstStudent());
                if (jenrl.getNrStudents() != 0) continue;
                ((JenrlConstraint.JenrlConstraintContext)jenrl.getContext((Assignment)assignment)).unassigned(assignment, (Placement)null);
                vars = jenrl.variables().toArray();
                for (j = 0; j < vars.length; ++j) {
                    jenrl.removeVariable((Lecture)vars[j]);
                }
                FinalSectioning.this.iModel.removeConstraint(jenrl);
            }
            if (this.secondStudent() != null) {
                for (Lecture lecture : this.secondStudent().getLectures()) {
                    if (lecture.equals(this.secondLecture()) || (jenrl = this.secondLecture().jenrlConstraint(lecture)) == null) continue;
                    jenrl.decJenrl(assignment, this.secondStudent());
                    if (jenrl.getNrStudents() != 0) continue;
                    ((JenrlConstraint.JenrlConstraintContext)jenrl.getContext((Assignment)assignment)).unassigned(assignment, (Placement)null);
                    vars = jenrl.variables().toArray();
                    for (j = 0; j < vars.length; ++j) {
                        jenrl.removeVariable((Lecture)vars[j]);
                    }
                    FinalSectioning.this.iModel.removeConstraint(jenrl);
                }
            }
            this.firstLecture().removeStudent(assignment, this.firstStudent());
            this.firstStudent().removeLecture(this.firstLecture());
            this.secondLecture().addStudent(assignment, this.firstStudent());
            this.firstStudent().addLecture(this.secondLecture());
            if (this.secondStudent() != null) {
                this.secondLecture().removeStudent(assignment, this.secondStudent());
                this.secondStudent().removeLecture(this.secondLecture());
                this.firstLecture().addStudent(assignment, this.secondStudent());
                this.secondStudent().addLecture(this.firstLecture());
            }
            for (Lecture lecture : this.firstStudent().getLectures()) {
                if (lecture.equals(this.secondLecture())) continue;
                jenrl = this.secondLecture().jenrlConstraint(lecture);
                if (jenrl == null) {
                    jenrl = new JenrlConstraint();
                    jenrl.addVariable(this.secondLecture());
                    jenrl.addVariable(lecture);
                    FinalSectioning.this.iModel.addConstraint(jenrl);
                }
                jenrl.incJenrl(assignment, this.firstStudent());
            }
            if (this.secondStudent() != null) {
                for (Lecture lecture : this.secondStudent().getLectures()) {
                    if (lecture.equals(this.firstLecture())) continue;
                    jenrl = this.firstLecture().jenrlConstraint(lecture);
                    if (jenrl == null) {
                        jenrl = new JenrlConstraint();
                        jenrl.addVariable(lecture);
                        jenrl.addVariable(this.firstLecture());
                        FinalSectioning.this.iModel.addConstraint(jenrl);
                    }
                    jenrl.incJenrl(assignment, this.secondStudent());
                }
            }
            if (this.getChildMoves() != null) {
                for (Move move : this.getChildMoves()) {
                    move.perform(assignment);
                }
            }
            return this.firstLecture().getModel().getCriterion(StudentConflict.class).getValue(assignment) + this.firstLecture().getModel().getCriterion(StudentCommittedConflict.class).getValue(assignment) < conflicts;
        }

        public double getDelta(Assignment<Lecture, Placement> assignment) {
            JenrlConstraint jenrl;
            double delta = 0.0;
            for (Lecture lecture : this.firstStudent().getLectures()) {
                if (assignment.getValue(lecture) == null || lecture.equals(this.firstLecture()) || (jenrl = this.firstLecture().jenrlConstraint(lecture)) == null || !jenrl.isInConflict(assignment)) continue;
                delta -= jenrl.getJenrlWeight(this.firstStudent());
            }
            if (this.secondStudent() != null) {
                for (Lecture lecture : this.secondStudent().getLectures()) {
                    if (assignment.getValue(lecture) == null || lecture.equals(this.secondLecture()) || (jenrl = this.secondLecture().jenrlConstraint(lecture)) == null || !jenrl.isInConflict(assignment)) continue;
                    delta -= jenrl.getJenrlWeight(this.secondStudent());
                }
            }
            for (Lecture lecture : this.firstStudent().getLectures()) {
                if (assignment.getValue(lecture) == null || lecture.equals(this.firstLecture())) continue;
                jenrl = this.secondLecture().jenrlConstraint(lecture);
                if (jenrl != null) {
                    if (!jenrl.isInConflict(assignment)) continue;
                    delta += jenrl.getJenrlWeight(this.firstStudent());
                    continue;
                }
                if (!JenrlConstraint.isInConflict(assignment.getValue(this.secondLecture()), assignment.getValue(lecture), FinalSectioning.this.iModel.getDistanceMetric())) continue;
                delta += this.firstStudent().getJenrlWeight(this.secondLecture(), lecture);
            }
            if (this.secondStudent() != null) {
                for (Lecture lecture : this.secondStudent().getLectures()) {
                    if (assignment.getValue(lecture) == null || lecture.equals(this.secondLecture())) continue;
                    jenrl = this.firstLecture().jenrlConstraint(lecture);
                    if (jenrl != null) {
                        if (!jenrl.isInConflict(assignment)) continue;
                        delta += jenrl.getJenrlWeight(this.secondStudent());
                        continue;
                    }
                    if (!JenrlConstraint.isInConflict(assignment.getValue(this.firstLecture()), assignment.getValue(lecture), FinalSectioning.this.iModel.getDistanceMetric())) continue;
                    delta += this.secondStudent().getJenrlWeight(this.firstLecture(), lecture);
                }
            }
            Placement p1 = assignment.getValue(this.firstLecture());
            Placement p2 = assignment.getValue(this.secondLecture());
            delta += (double)(this.firstStudent().countConflictPlacements(p2) - this.firstStudent().countConflictPlacements(p1));
            if (this.secondStudent() != null) {
                delta += (double)(this.secondStudent().countConflictPlacements(p1) - this.secondStudent().countConflictPlacements(p2));
            }
            if (this.getChildMoves() != null) {
                for (Move move : this.getChildMoves()) {
                    delta += move.getDelta(assignment);
                }
            }
            return delta;
        }

        public boolean isTabu() {
            return false;
        }

        public String toString() {
            return "Move{" + this.firstStudent() + "/" + this.firstLecture() + " <-> " + this.secondStudent() + "/" + this.secondLecture() + ", ch=" + this.getChildMoves() + "}";
        }
    }
}

