/*
 * Licensed to The Apereo Foundation under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for
 * additional information regarding copyright ownership.
 *
 * The Apereo Foundation licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
*/


spool woebegon-data.log
set feedback off
set define off

prompt Disabling triggers for DATE_PATTERN...
alter table DATE_PATTERN disable all triggers;
prompt Disabling triggers for DEPT_STATUS_TYPE...
alter table DEPT_STATUS_TYPE disable all triggers;
prompt Disabling triggers for SESSIONS...
alter table SESSIONS disable all triggers;
prompt Disabling triggers for ACADEMIC_AREA...
alter table ACADEMIC_AREA disable all triggers;
prompt Disabling triggers for ACADEMIC_CLASSIFICATION...
alter table ACADEMIC_CLASSIFICATION disable all triggers;
prompt Disabling triggers for RESERVATION_TYPE...
alter table RESERVATION_TYPE disable all triggers;
prompt Disabling triggers for ACAD_AREA_RESERVATION...
alter table ACAD_AREA_RESERVATION disable all triggers;
prompt Disabling triggers for APPLICATION_CONFIG...
alter table APPLICATION_CONFIG disable all triggers;
prompt Disabling triggers for OFFR_CONSENT_TYPE...
alter table OFFR_CONSENT_TYPE disable all triggers;
prompt Disabling triggers for INSTRUCTIONAL_OFFERING...
alter table INSTRUCTIONAL_OFFERING disable all triggers;
prompt Disabling triggers for INSTR_OFFERING_CONFIG...
alter table INSTR_OFFERING_CONFIG disable all triggers;
prompt Disabling triggers for ITYPE_DESC...
alter table ITYPE_DESC disable all triggers;
prompt Disabling triggers for SCHEDULING_SUBPART...
alter table SCHEDULING_SUBPART disable all triggers;
prompt Disabling triggers for CLASS_...
alter table CLASS_ disable all triggers;
prompt Disabling triggers for SOLVER_GROUP...
alter table SOLVER_GROUP disable all triggers;
prompt Disabling triggers for SOLUTION...
alter table SOLUTION disable all triggers;
prompt Disabling triggers for TIME_PATTERN...
alter table TIME_PATTERN disable all triggers;
prompt Disabling triggers for ASSIGNMENT...
alter table ASSIGNMENT disable all triggers;
prompt Disabling triggers for POSITION_TYPE...
alter table POSITION_TYPE disable all triggers;
prompt Disabling triggers for DEPARTMENT...
alter table DEPARTMENT disable all triggers;
prompt Disabling triggers for DEPARTMENTAL_INSTRUCTOR...
alter table DEPARTMENTAL_INSTRUCTOR disable all triggers;
prompt Disabling triggers for ASSIGNED_INSTRUCTORS...
alter table ASSIGNED_INSTRUCTORS disable all triggers;
prompt Disabling triggers for ASSIGNED_ROOMS...
alter table ASSIGNED_ROOMS disable all triggers;
prompt Disabling triggers for BUILDING...
alter table BUILDING disable all triggers;
prompt Disabling triggers for PREFERENCE_LEVEL...
alter table PREFERENCE_LEVEL disable all triggers;
prompt Disabling triggers for BUILDING_PREF...
alter table BUILDING_PREF disable all triggers;
prompt Disabling triggers for CLASS_INSTRUCTOR...
alter table CLASS_INSTRUCTOR disable all triggers;
prompt Disabling triggers for STUDENT_STATUS_TYPE...
alter table STUDENT_STATUS_TYPE disable all triggers;
prompt Disabling triggers for STUDENT...
alter table STUDENT disable all triggers;
prompt Disabling triggers for FREE_TIME...
alter table FREE_TIME disable all triggers;
prompt Disabling triggers for COURSE_DEMAND...
alter table COURSE_DEMAND disable all triggers;
prompt Disabling triggers for SUBJECT_AREA...
alter table SUBJECT_AREA disable all triggers;
prompt Disabling triggers for COURSE_OFFERING...
alter table COURSE_OFFERING disable all triggers;
prompt Disabling triggers for COURSE_REQUEST...
alter table COURSE_REQUEST disable all triggers;
prompt Disabling triggers for CLASS_WAITLIST...
alter table CLASS_WAITLIST disable all triggers;
prompt Disabling triggers for CONSTRAINT_INFO...
alter table CONSTRAINT_INFO disable all triggers;
prompt Disabling triggers for COURSE_CATALOG...
alter table COURSE_CATALOG disable all triggers;
prompt Disabling triggers for COURSE_CREDIT_TYPE...
alter table COURSE_CREDIT_TYPE disable all triggers;
prompt Disabling triggers for COURSE_CREDIT_UNIT_CONFIG...
alter table COURSE_CREDIT_UNIT_CONFIG disable all triggers;
prompt Disabling triggers for COURSE_CREDIT_UNIT_TYPE...
alter table COURSE_CREDIT_UNIT_TYPE disable all triggers;
prompt Disabling triggers for COURSE_RESERVATION...
alter table COURSE_RESERVATION disable all triggers;
prompt Disabling triggers for COURSE_SUBPART_CREDIT...
alter table COURSE_SUBPART_CREDIT disable all triggers;
prompt Disabling triggers for CRSE_CREDIT_FORMAT...
alter table CRSE_CREDIT_FORMAT disable all triggers;
prompt Disabling triggers for CURRICULUM...
alter table CURRICULUM disable all triggers;
prompt Disabling triggers for CURRICULUM_CLASF...
alter table CURRICULUM_CLASF disable all triggers;
prompt Disabling triggers for CURRICULUM_COURSE...
alter table CURRICULUM_COURSE disable all triggers;
prompt Disabling triggers for CURRICULUM_GROUP...
alter table CURRICULUM_GROUP disable all triggers;
prompt Disabling triggers for CURRICULUM_COURSE_GROUP...
alter table CURRICULUM_COURSE_GROUP disable all triggers;
prompt Disabling triggers for POS_MAJOR...
alter table POS_MAJOR disable all triggers;
prompt Disabling triggers for CURRICULUM_MAJOR...
alter table CURRICULUM_MAJOR disable all triggers;
prompt Disabling triggers for CURRICULUM_RULE...
alter table CURRICULUM_RULE disable all triggers;
prompt Disabling triggers for DATE_PATTERN_DEPT...
alter table DATE_PATTERN_DEPT disable all triggers;
prompt Disabling triggers for DEMAND_OFFR_TYPE...
alter table DEMAND_OFFR_TYPE disable all triggers;
prompt Disabling triggers for TIMETABLE_MANAGER...
alter table TIMETABLE_MANAGER disable all triggers;
prompt Disabling triggers for DEPT_TO_TT_MGR...
alter table DEPT_TO_TT_MGR disable all triggers;
prompt Disabling triggers for DESIGNATOR...
alter table DESIGNATOR disable all triggers;
prompt Disabling triggers for DISTRIBUTION_TYPE...
alter table DISTRIBUTION_TYPE disable all triggers;
prompt Disabling triggers for DISTRIBUTION_PREF...
alter table DISTRIBUTION_PREF disable all triggers;
prompt Disabling triggers for DISTRIBUTION_OBJECT...
alter table DISTRIBUTION_OBJECT disable all triggers;
prompt Disabling triggers for DIST_TYPE_DEPT...
alter table DIST_TYPE_DEPT disable all triggers;
prompt Disabling triggers for EVENT_CONTACT...
alter table EVENT_CONTACT disable all triggers;
prompt Disabling triggers for EXAM_PERIOD...
alter table EXAM_PERIOD disable all triggers;
prompt Disabling triggers for EXAM...
alter table EXAM disable all triggers;
prompt Disabling triggers for SPONSORING_ORGANIZATION...
alter table SPONSORING_ORGANIZATION disable all triggers;
prompt Disabling triggers for EVENT...
alter table EVENT disable all triggers;
prompt Disabling triggers for EVENT_JOIN_EVENT_CONTACT...
alter table EVENT_JOIN_EVENT_CONTACT disable all triggers;
prompt Disabling triggers for EVENT_NOTE...
alter table EVENT_NOTE disable all triggers;
prompt Disabling triggers for EXACT_TIME_MINS...
alter table EXACT_TIME_MINS disable all triggers;
prompt Disabling triggers for EXAM_INSTRUCTOR...
alter table EXAM_INSTRUCTOR disable all triggers;
prompt Disabling triggers for EXAM_LOCATION_PREF...
alter table EXAM_LOCATION_PREF disable all triggers;
prompt Disabling triggers for EXAM_OWNER...
alter table EXAM_OWNER disable all triggers;
prompt Disabling triggers for EXAM_PERIOD_PREF...
alter table EXAM_PERIOD_PREF disable all triggers;
prompt Disabling triggers for EXAM_ROOM_ASSIGNMENT...
alter table EXAM_ROOM_ASSIGNMENT disable all triggers;
prompt Disabling triggers for EXTERNAL_BUILDING...
alter table EXTERNAL_BUILDING disable all triggers;
prompt Disabling triggers for ROOM_TYPE...
alter table ROOM_TYPE disable all triggers;
prompt Disabling triggers for EXTERNAL_ROOM...
alter table EXTERNAL_ROOM disable all triggers;
prompt Disabling triggers for EXTERNAL_ROOM_DEPARTMENT...
alter table EXTERNAL_ROOM_DEPARTMENT disable all triggers;
prompt Disabling triggers for EXTERNAL_ROOM_FEATURE...
alter table EXTERNAL_ROOM_FEATURE disable all triggers;
prompt Disabling triggers for HISTORY...
alter table HISTORY disable all triggers;
prompt Disabling triggers for INDIVIDUAL_RESERVATION...
alter table INDIVIDUAL_RESERVATION disable all triggers;
prompt Disabling triggers for JENRL...
alter table JENRL disable all triggers;
prompt Disabling triggers for LASTLIKE_COURSE_DEMAND...
alter table LASTLIKE_COURSE_DEMAND disable all triggers;
prompt Disabling triggers for SETTINGS...
alter table SETTINGS disable all triggers;
prompt Disabling triggers for MANAGER_SETTINGS...
alter table MANAGER_SETTINGS disable all triggers;
prompt Disabling triggers for MEETING...
alter table MEETING disable all triggers;
prompt Disabling triggers for NON_UNIVERSITY_LOCATION...
alter table NON_UNIVERSITY_LOCATION disable all triggers;
prompt Disabling triggers for OFFR_GROUP...
alter table OFFR_GROUP disable all triggers;
prompt Disabling triggers for OFFR_GROUP_OFFERING...
alter table OFFR_GROUP_OFFERING disable all triggers;
prompt Disabling triggers for POSITION_CODE_TO_TYPE...
alter table POSITION_CODE_TO_TYPE disable all triggers;
prompt Disabling triggers for POS_ACAD_AREA_MAJOR...
alter table POS_ACAD_AREA_MAJOR disable all triggers;
prompt Disabling triggers for POS_MINOR...
alter table POS_MINOR disable all triggers;
prompt Disabling triggers for POS_ACAD_AREA_MINOR...
alter table POS_ACAD_AREA_MINOR disable all triggers;
prompt Disabling triggers for POS_RESERVATION...
alter table POS_RESERVATION disable all triggers;
prompt Disabling triggers for RELATED_COURSE_INFO...
alter table RELATED_COURSE_INFO disable all triggers;
prompt Disabling triggers for ROLES...
alter table ROLES disable all triggers;
prompt Disabling triggers for ROOM...
alter table ROOM disable all triggers;
prompt Disabling triggers for ROOM_DEPT...
alter table ROOM_DEPT disable all triggers;
prompt Disabling triggers for ROOM_FEATURE...
alter table ROOM_FEATURE disable all triggers;
prompt Disabling triggers for ROOM_FEATURE_PREF...
alter table ROOM_FEATURE_PREF disable all triggers;
prompt Disabling triggers for ROOM_GROUP...
alter table ROOM_GROUP disable all triggers;
prompt Disabling triggers for ROOM_GROUP_PREF...
alter table ROOM_GROUP_PREF disable all triggers;
prompt Disabling triggers for ROOM_GROUP_ROOM...
alter table ROOM_GROUP_ROOM disable all triggers;
prompt Disabling triggers for ROOM_JOIN_ROOM_FEATURE...
alter table ROOM_JOIN_ROOM_FEATURE disable all triggers;
prompt Disabling triggers for ROOM_PREF...
alter table ROOM_PREF disable all triggers;
prompt Disabling triggers for ROOM_TYPE_OPTION...
alter table ROOM_TYPE_OPTION disable all triggers;
prompt Disabling triggers for SECTIONING_INFO...
alter table SECTIONING_INFO disable all triggers;
prompt Disabling triggers for SOLVER_GR_TO_TT_MGR...
alter table SOLVER_GR_TO_TT_MGR disable all triggers;
prompt Disabling triggers for SOLVER_INFO_DEF...
alter table SOLVER_INFO_DEF disable all triggers;
prompt Disabling triggers for SOLVER_PARAMETER_GROUP...
alter table SOLVER_PARAMETER_GROUP disable all triggers;
prompt Disabling triggers for SOLVER_PARAMETER_DEF...
alter table SOLVER_PARAMETER_DEF disable all triggers;
prompt Disabling triggers for SOLVER_PREDEF_SETTING...
alter table SOLVER_PREDEF_SETTING disable all triggers;
prompt Disabling triggers for SOLVER_PARAMETER...
alter table SOLVER_PARAMETER disable all triggers;
prompt Disabling triggers for STAFF...
alter table STAFF disable all triggers;
prompt Disabling triggers for STANDARD_EVENT_NOTE...
alter table STANDARD_EVENT_NOTE disable all triggers;
prompt Disabling triggers for STUDENT_ACAD_AREA...
alter table STUDENT_ACAD_AREA disable all triggers;
prompt Disabling triggers for STUDENT_ACCOMODATION...
alter table STUDENT_ACCOMODATION disable all triggers;
prompt Disabling triggers for STUDENT_CLASS_ENRL...
alter table STUDENT_CLASS_ENRL disable all triggers;
prompt Disabling triggers for STUDENT_ENRL...
alter table STUDENT_ENRL disable all triggers;
prompt Disabling triggers for STUDENT_ENRL_MSG...
alter table STUDENT_ENRL_MSG disable all triggers;
prompt Disabling triggers for STUDENT_GROUP...
alter table STUDENT_GROUP disable all triggers;
prompt Disabling triggers for STUDENT_GROUP_RESERVATION...
alter table STUDENT_GROUP_RESERVATION disable all triggers;
prompt Disabling triggers for STUDENT_MAJOR...
alter table STUDENT_MAJOR disable all triggers;
prompt Disabling triggers for STUDENT_MINOR...
alter table STUDENT_MINOR disable all triggers;
prompt Disabling triggers for STUDENT_TO_ACOMODATION...
alter table STUDENT_TO_ACOMODATION disable all triggers;
prompt Disabling triggers for STUDENT_TO_GROUP...
alter table STUDENT_TO_GROUP disable all triggers;
prompt Disabling triggers for TIME_PATTERN_DAYS...
alter table TIME_PATTERN_DAYS disable all triggers;
prompt Disabling triggers for TIME_PATTERN_DEPT...
alter table TIME_PATTERN_DEPT disable all triggers;
prompt Disabling triggers for TIME_PATTERN_TIME...
alter table TIME_PATTERN_TIME disable all triggers;
prompt Disabling triggers for TIME_PREF...
alter table TIME_PREF disable all triggers;
prompt Disabling triggers for TMTBL_MGR_TO_ROLES...
alter table TMTBL_MGR_TO_ROLES disable all triggers;
prompt Disabling triggers for USERS...
alter table USERS disable all triggers;
prompt Disabling triggers for USER_DATA...
alter table USER_DATA disable all triggers;
prompt Disabling triggers for WAITLIST...
alter table WAITLIST disable all triggers;
prompt Disabling triggers for XCONFLICT...
alter table XCONFLICT disable all triggers;
prompt Disabling triggers for XCONFLICT_EXAM...
alter table XCONFLICT_EXAM disable all triggers;
prompt Disabling triggers for XCONFLICT_INSTRUCTOR...
alter table XCONFLICT_INSTRUCTOR disable all triggers;
prompt Disabling triggers for XCONFLICT_STUDENT...
alter table XCONFLICT_STUDENT disable all triggers;
prompt Disabling foreign key constraints for DATE_PATTERN...
alter table DATE_PATTERN disable constraint FK_DATE_PATTERN_SESSION;
prompt Disabling foreign key constraints for SESSIONS...
alter table SESSIONS disable constraint FK_SESSIONS_STATUS_TYPE;
alter table SESSIONS disable constraint FK_SESSION_DATEPATT;
prompt Disabling foreign key constraints for ACADEMIC_AREA...
alter table ACADEMIC_AREA disable constraint FK_ACADEMIC_AREA_SESSION;
prompt Disabling foreign key constraints for ACADEMIC_CLASSIFICATION...
alter table ACADEMIC_CLASSIFICATION disable constraint FK_ACAD_CLASS_SESSION;
prompt Disabling foreign key constraints for ACAD_AREA_RESERVATION...
alter table ACAD_AREA_RESERVATION disable constraint FK_ACAD_AREA_RESV_ACAD_AREA;
alter table ACAD_AREA_RESERVATION disable constraint FK_ACAD_AREA_RESV_ACAD_CLASS;
alter table ACAD_AREA_RESERVATION disable constraint FK_ACAD_AREA_RESV_TYPE;
prompt Disabling foreign key constraints for INSTRUCTIONAL_OFFERING...
alter table INSTRUCTIONAL_OFFERING disable constraint FK_INSTR_OFFR_CONSENT_TYPE;
prompt Disabling foreign key constraints for INSTR_OFFERING_CONFIG...
alter table INSTR_OFFERING_CONFIG disable constraint FK_INSTR_OFFR_CFG_INSTR_OFFR;
prompt Disabling foreign key constraints for SCHEDULING_SUBPART...
alter table SCHEDULING_SUBPART disable constraint FK_SCHED_SUBPART_CONFIG;
alter table SCHEDULING_SUBPART disable constraint FK_SCHED_SUBPART_DATE_PATTERN;
alter table SCHEDULING_SUBPART disable constraint FK_SCHED_SUBPART_ITYPE;
alter table SCHEDULING_SUBPART disable constraint FK_SCHED_SUBPART_PARENT;
prompt Disabling foreign key constraints for CLASS_...
alter table CLASS_ disable constraint FK_CLASS_DATEPATT;
alter table CLASS_ disable constraint FK_CLASS_PARENT;
alter table CLASS_ disable constraint FK_CLASS_SCHEDULING_SUBPART;
prompt Disabling foreign key constraints for SOLVER_GROUP...
alter table SOLVER_GROUP disable constraint FK_SOLVER_GROUP_SESSION;
prompt Disabling foreign key constraints for SOLUTION...
alter table SOLUTION disable constraint FK_SOLUTION_OWNER;
prompt Disabling foreign key constraints for TIME_PATTERN...
alter table TIME_PATTERN disable constraint FK_TIME_PATTERN_SESSION;
prompt Disabling foreign key constraints for ASSIGNMENT...
alter table ASSIGNMENT disable constraint FK_ASSIGNMENT_CLASS;
alter table ASSIGNMENT disable constraint FK_ASSIGNMENT_SOLUTION;
alter table ASSIGNMENT disable constraint FK_ASSIGNMENT_TIME_PATTERN;
prompt Disabling foreign key constraints for DEPARTMENT...
alter table DEPARTMENT disable constraint FK_DEPARTMENT_SOLVER_GROUP;
alter table DEPARTMENT disable constraint FK_DEPARTMENT_STATUS_TYPE;
prompt Disabling foreign key constraints for DEPARTMENTAL_INSTRUCTOR...
alter table DEPARTMENTAL_INSTRUCTOR disable constraint FK_DEPT_INSTR_DEPT;
alter table DEPARTMENTAL_INSTRUCTOR disable constraint FK_DEPT_INSTR_POS_CODE_TYPE;
prompt Disabling foreign key constraints for ASSIGNED_INSTRUCTORS...
alter table ASSIGNED_INSTRUCTORS disable constraint FK_ASSIGNED_INSTRS_ASSIGNMENT;
alter table ASSIGNED_INSTRUCTORS disable constraint FK_ASSIGNED_INSTRS_INSTRUCTOR;
prompt Disabling foreign key constraints for ASSIGNED_ROOMS...
alter table ASSIGNED_ROOMS disable constraint FK_ASSIGNED_ROOMS_ASSIGNMENT;
prompt Disabling foreign key constraints for BUILDING...
alter table BUILDING disable constraint FK_BUILDING_SESSION;
prompt Disabling foreign key constraints for BUILDING_PREF...
alter table BUILDING_PREF disable constraint FK_BUILDING_PREF_BLDG;
alter table BUILDING_PREF disable constraint FK_BUILDING_PREF_LEVEL;
prompt Disabling foreign key constraints for CLASS_INSTRUCTOR...
alter table CLASS_INSTRUCTOR disable constraint FK_CLASS_INSTRUCTOR_CLASS;
alter table CLASS_INSTRUCTOR disable constraint FK_CLASS_INSTRUCTOR_INSTR;
prompt Disabling foreign key constraints for STUDENT...
alter table STUDENT disable constraint FK_STUDENT_SESSION;
alter table STUDENT disable constraint FK_STUDENT_STATUS_STUDENT;
prompt Disabling foreign key constraints for FREE_TIME...
alter table FREE_TIME disable constraint FK_FREE_TIME_SESSION;
prompt Disabling foreign key constraints for COURSE_DEMAND...
alter table COURSE_DEMAND disable constraint FK_COURSE_DEMAND_FREE_TIME;
alter table COURSE_DEMAND disable constraint FK_COURSE_DEMAND_STUDENT;
prompt Disabling foreign key constraints for SUBJECT_AREA...
alter table SUBJECT_AREA disable constraint FK_SUBJECT_AREA_DEPT;
prompt Disabling foreign key constraints for COURSE_OFFERING...
alter table COURSE_OFFERING disable constraint FK_COURSE_OFFERING_DEMAND_OFFR;
alter table COURSE_OFFERING disable constraint FK_COURSE_OFFERING_INSTR_OFFR;
alter table COURSE_OFFERING disable constraint FK_COURSE_OFFERING_SUBJ_AREA;
prompt Disabling foreign key constraints for COURSE_REQUEST...
alter table COURSE_REQUEST disable constraint FK_COURSE_REQUEST_DEMAND;
alter table COURSE_REQUEST disable constraint FK_COURSE_REQUEST_OFFERING;
prompt Disabling foreign key constraints for CLASS_WAITLIST...
alter table CLASS_WAITLIST disable constraint FK_CLASS_WAITLIST_CLASS;
alter table CLASS_WAITLIST disable constraint FK_CLASS_WAITLIST_REQUEST;
alter table CLASS_WAITLIST disable constraint FK_CLASS_WAITLIST_STUDENT;
prompt Disabling foreign key constraints for CONSTRAINT_INFO...
alter table CONSTRAINT_INFO disable constraint FK_CONSTRAINT_INFO_ASSIGNMENT;
alter table CONSTRAINT_INFO disable constraint FK_CONSTRAINT_INFO_SOLVER;
prompt Disabling foreign key constraints for COURSE_CREDIT_UNIT_CONFIG...
alter table COURSE_CREDIT_UNIT_CONFIG disable constraint FK_CRS_CRDT_UNIT_CFG_CRDT_TYPE;
alter table COURSE_CREDIT_UNIT_CONFIG disable constraint FK_CRS_CRDT_UNIT_CFG_IO_OWN;
alter table COURSE_CREDIT_UNIT_CONFIG disable constraint FK_CRS_CRDT_UNIT_CFG_OWNER;
prompt Disabling foreign key constraints for COURSE_RESERVATION...
alter table COURSE_RESERVATION disable constraint FK_COURSE_RESERV_TYPE;
alter table COURSE_RESERVATION disable constraint FK_COURSE_RESV_CRS_OFFR;
prompt Disabling foreign key constraints for COURSE_SUBPART_CREDIT...
alter table COURSE_SUBPART_CREDIT disable constraint FK_SUBPART_CRED_CRS;
prompt Disabling foreign key constraints for CURRICULUM...
alter table CURRICULUM disable constraint FK_CURRICULUM_ACAD_AREA;
alter table CURRICULUM disable constraint FK_CURRICULUM_DEPT;
prompt Disabling foreign key constraints for CURRICULUM_CLASF...
alter table CURRICULUM_CLASF disable constraint FK_CURRICULUM_CLASF_ACAD_CLASF;
alter table CURRICULUM_CLASF disable constraint FK_CURRICULUM_CLASF_CURRICULUM;
prompt Disabling foreign key constraints for CURRICULUM_COURSE...
alter table CURRICULUM_COURSE disable constraint FK_CURRICULUM_COURSE_CLASF;
alter table CURRICULUM_COURSE disable constraint FK_CURRICULUM_COURSE_COURSE;
prompt Disabling foreign key constraints for CURRICULUM_GROUP...
alter table CURRICULUM_GROUP disable constraint FK_CURRICULUM_GROUP_CURRICULUM;
prompt Disabling foreign key constraints for CURRICULUM_COURSE_GROUP...
alter table CURRICULUM_COURSE_GROUP disable constraint FK_CUR_COURSE_GROUP_COURSE;
alter table CURRICULUM_COURSE_GROUP disable constraint FK_CUR_COURSE_GROUP_GROUP;
prompt Disabling foreign key constraints for POS_MAJOR...
alter table POS_MAJOR disable constraint FK_POS_MAJOR_SESSION;
prompt Disabling foreign key constraints for CURRICULUM_MAJOR...
alter table CURRICULUM_MAJOR disable constraint FK_CURRICULUM_MAJOR_CURRICULUM;
alter table CURRICULUM_MAJOR disable constraint FK_CURRICULUM_MAJOR_MAJOR;
prompt Disabling foreign key constraints for CURRICULUM_RULE...
alter table CURRICULUM_RULE disable constraint FK_CUR_RULE_ACAD_AREA;
alter table CURRICULUM_RULE disable constraint FK_CUR_RULE_ACAD_CLASF;
alter table CURRICULUM_RULE disable constraint FK_CUR_RULE_MAJOR;
prompt Disabling foreign key constraints for DATE_PATTERN_DEPT...
alter table DATE_PATTERN_DEPT disable constraint FK_DATE_PATTERN_DEPT_DATE;
alter table DATE_PATTERN_DEPT disable constraint FK_DATE_PATTERN_DEPT_DEPT;
prompt Disabling foreign key constraints for DEPT_TO_TT_MGR...
alter table DEPT_TO_TT_MGR disable constraint FK_DEPT_TO_TT_MGR_DEPT;
alter table DEPT_TO_TT_MGR disable constraint FK_DEPT_TO_TT_MGR_MGR;
prompt Disabling foreign key constraints for DESIGNATOR...
alter table DESIGNATOR disable constraint FK_DESIGNATOR_INSTRUCTOR;
alter table DESIGNATOR disable constraint FK_DESIGNATOR_SUBJ_AREA;
prompt Disabling foreign key constraints for DISTRIBUTION_PREF...
alter table DISTRIBUTION_PREF disable constraint FK_DISTRIBUTION_PREF_DIST_TYPE;
alter table DISTRIBUTION_PREF disable constraint FK_DISTRIBUTION_PREF_LEVEL;
prompt Disabling foreign key constraints for DISTRIBUTION_OBJECT...
alter table DISTRIBUTION_OBJECT disable constraint FK_DISTRIBUTION_OBJECT_PREF;
prompt Disabling foreign key constraints for DIST_TYPE_DEPT...
alter table DIST_TYPE_DEPT disable constraint FK_DIST_TYPE_DEPT_DEPT;
alter table DIST_TYPE_DEPT disable constraint FK_DIST_TYPE_DEPT_TYPE;
prompt Disabling foreign key constraints for EXAM_PERIOD...
alter table EXAM_PERIOD disable constraint FK_EXAM_PERIOD_PREF;
alter table EXAM_PERIOD disable constraint FK_EXAM_PERIOD_SESSION;
prompt Disabling foreign key constraints for EXAM...
alter table EXAM disable constraint FK_EXAM_PERIOD;
alter table EXAM disable constraint FK_EXAM_SESSION;
prompt Disabling foreign key constraints for EVENT...
alter table EVENT disable constraint FK_EVENT_CLASS;
alter table EVENT disable constraint FK_EVENT_EXAM;
alter table EVENT disable constraint FK_EVENT_MAIN_CONTACT;
alter table EVENT disable constraint FK_EVENT_SPONSOR_ORG;
prompt Disabling foreign key constraints for EVENT_JOIN_EVENT_CONTACT...
alter table EVENT_JOIN_EVENT_CONTACT disable constraint FK_EVENT_CONTACT_JOIN;
alter table EVENT_JOIN_EVENT_CONTACT disable constraint FK_EVENT_ID_JOIN;
prompt Disabling foreign key constraints for EVENT_NOTE...
alter table EVENT_NOTE disable constraint FK_EVENT_NOTE_EVENT;
prompt Disabling foreign key constraints for EXAM_INSTRUCTOR...
alter table EXAM_INSTRUCTOR disable constraint FK_EXAM_INSTRUCTOR_EXAM;
alter table EXAM_INSTRUCTOR disable constraint FK_EXAM_INSTRUCTOR_INSTRUCTOR;
prompt Disabling foreign key constraints for EXAM_LOCATION_PREF...
alter table EXAM_LOCATION_PREF disable constraint FK_EXAM_LOCATION_PREF_PERIOD;
alter table EXAM_LOCATION_PREF disable constraint FK_EXAM_LOCATION_PREF_PREF;
prompt Disabling foreign key constraints for EXAM_OWNER...
alter table EXAM_OWNER disable constraint FK_EXAM_OWNER_COURSE;
alter table EXAM_OWNER disable constraint FK_EXAM_OWNER_EXAM;
prompt Disabling foreign key constraints for EXAM_PERIOD_PREF...
alter table EXAM_PERIOD_PREF disable constraint FK_EXAM_PERIOD_PREF_PERIOD;
alter table EXAM_PERIOD_PREF disable constraint FK_EXAM_PERIOD_PREF_PREF;
prompt Disabling foreign key constraints for EXAM_ROOM_ASSIGNMENT...
alter table EXAM_ROOM_ASSIGNMENT disable constraint FK_EXAM_ROOM_EXAM;
prompt Disabling foreign key constraints for EXTERNAL_ROOM...
alter table EXTERNAL_ROOM disable constraint FK_EXTERNAL_ROOM_TYPE;
alter table EXTERNAL_ROOM disable constraint FK_EXT_ROOM_BUILDING;
prompt Disabling foreign key constraints for EXTERNAL_ROOM_DEPARTMENT...
alter table EXTERNAL_ROOM_DEPARTMENT disable constraint FK_EXT_DEPT_ROOM;
prompt Disabling foreign key constraints for EXTERNAL_ROOM_FEATURE...
alter table EXTERNAL_ROOM_FEATURE disable constraint FK_EXT_FTR_ROOM;
prompt Disabling foreign key constraints for HISTORY...
alter table HISTORY disable constraint FK_HISTORY_SESSION;
prompt Disabling foreign key constraints for INDIVIDUAL_RESERVATION...
alter table INDIVIDUAL_RESERVATION disable constraint FK_INDIVIDUAL_RESV_TYPE;
prompt Disabling foreign key constraints for JENRL...
alter table JENRL disable constraint FK_JENRL_CLASS1;
alter table JENRL disable constraint FK_JENRL_CLASS2;
alter table JENRL disable constraint FK_JENRL_SOLUTION;
prompt Disabling foreign key constraints for LASTLIKE_COURSE_DEMAND...
alter table LASTLIKE_COURSE_DEMAND disable constraint FK_LL_COURSE_DEMAND_STUDENT;
alter table LASTLIKE_COURSE_DEMAND disable constraint FK_LL_COURSE_DEMAND_SUBJAREA;
prompt Disabling foreign key constraints for MANAGER_SETTINGS...
alter table MANAGER_SETTINGS disable constraint FK_MANAGER_SETTINGS_KEY;
alter table MANAGER_SETTINGS disable constraint FK_MANAGER_SETTINGS_USER;
prompt Disabling foreign key constraints for MEETING...
alter table MEETING disable constraint FK_MEETING_EVENT;
prompt Disabling foreign key constraints for NON_UNIVERSITY_LOCATION...
alter table NON_UNIVERSITY_LOCATION disable constraint FK_LOCATION_TYPE;
alter table NON_UNIVERSITY_LOCATION disable constraint FK_NON_UNIV_LOC_SESSION;
prompt Disabling foreign key constraints for OFFR_GROUP...
alter table OFFR_GROUP disable constraint FK_OFFR_GROUP_DEPT;
alter table OFFR_GROUP disable constraint FK_OFFR_GROUP_SESSION;
prompt Disabling foreign key constraints for OFFR_GROUP_OFFERING...
alter table OFFR_GROUP_OFFERING disable constraint FK_OFFR_GROUP_INSTR_OFFR;
alter table OFFR_GROUP_OFFERING disable constraint FK_OFFR_GROUP_OFFR_OFFR_GRP;
prompt Disabling foreign key constraints for POSITION_CODE_TO_TYPE...
alter table POSITION_CODE_TO_TYPE disable constraint FK_POS_CODE_TO_TYPE_CODE_TYPE;
prompt Disabling foreign key constraints for POS_ACAD_AREA_MAJOR...
alter table POS_ACAD_AREA_MAJOR disable constraint FK_POS_ACAD_AREA_MAJOR_AREA;
alter table POS_ACAD_AREA_MAJOR disable constraint FK_POS_ACAD_AREA_MAJOR_MAJOR;
prompt Disabling foreign key constraints for POS_MINOR...
alter table POS_MINOR disable constraint FK_POS_MINOR_SESSION;
prompt Disabling foreign key constraints for POS_ACAD_AREA_MINOR...
alter table POS_ACAD_AREA_MINOR disable constraint FK_POS_ACAD_AREA_MINOR_AREA;
alter table POS_ACAD_AREA_MINOR disable constraint FK_POS_ACAD_AREA_MINOR_MINOR;
prompt Disabling foreign key constraints for POS_RESERVATION...
alter table POS_RESERVATION disable constraint FK_POS_RESV_ACAD_CLASS;
alter table POS_RESERVATION disable constraint FK_POS_RESV_MAJOR;
alter table POS_RESERVATION disable constraint FK_POS_RESV_TYPE;
prompt Disabling foreign key constraints for RELATED_COURSE_INFO...
alter table RELATED_COURSE_INFO disable constraint FK_EVENT_OWNER_COURSE;
alter table RELATED_COURSE_INFO disable constraint FK_EVENT_OWNER_EVENT;
prompt Disabling foreign key constraints for ROOM...
alter table ROOM disable constraint FK_ROOM_BUILDING;
alter table ROOM disable constraint FK_ROOM_SESSION;
alter table ROOM disable constraint FK_ROOM_TYPE;
prompt Disabling foreign key constraints for ROOM_DEPT...
alter table ROOM_DEPT disable constraint FK_ROOM_DEPT_DEPT;
prompt Disabling foreign key constraints for ROOM_FEATURE...
alter table ROOM_FEATURE disable constraint FK_ROOM_FEATURE_DEPT;
prompt Disabling foreign key constraints for ROOM_FEATURE_PREF...
alter table ROOM_FEATURE_PREF disable constraint FK_ROOM_FEAT_PREF_LEVEL;
alter table ROOM_FEATURE_PREF disable constraint FK_ROOM_FEAT_PREF_ROOM_FEAT;
prompt Disabling foreign key constraints for ROOM_GROUP...
alter table ROOM_GROUP disable constraint FK_ROOM_GROUP_DEPT;
alter table ROOM_GROUP disable constraint FK_ROOM_GROUP_SESSION;
prompt Disabling foreign key constraints for ROOM_GROUP_PREF...
alter table ROOM_GROUP_PREF disable constraint FK_ROOM_GROUP_PREF_LEVEL;
alter table ROOM_GROUP_PREF disable constraint FK_ROOM_GROUP_PREF_ROOM_GRP;
prompt Disabling foreign key constraints for ROOM_GROUP_ROOM...
alter table ROOM_GROUP_ROOM disable constraint FK_ROOM_GROUP_ROOM_ROOM_GRP;
prompt Disabling foreign key constraints for ROOM_JOIN_ROOM_FEATURE...
alter table ROOM_JOIN_ROOM_FEATURE disable constraint FK_ROOM_JOIN_ROOM_FEAT_RM_FEAT;
prompt Disabling foreign key constraints for ROOM_PREF...
alter table ROOM_PREF disable constraint FK_ROOM_PREF_LEVEL;
prompt Disabling foreign key constraints for ROOM_TYPE_OPTION...
alter table ROOM_TYPE_OPTION disable constraint FK_RTYPE_OPTION_SESSION;
alter table ROOM_TYPE_OPTION disable constraint FK_RTYPE_OPTION_TYPE;
prompt Disabling foreign key constraints for SECTIONING_INFO...
alter table SECTIONING_INFO disable constraint FK_SECTIONING_INFO_CLASS;
prompt Disabling foreign key constraints for SOLVER_GR_TO_TT_MGR...
alter table SOLVER_GR_TO_TT_MGR disable constraint FK_SOLVER_GR_TO_TT_MGR_SOLVGRP;
alter table SOLVER_GR_TO_TT_MGR disable constraint FK_SOLVER_GR_TO_TT_MGR_TT_MGR;
prompt Disabling foreign key constraints for SOLVER_PARAMETER_DEF...
alter table SOLVER_PARAMETER_DEF disable constraint FK_SOLV_PARAM_DEF_SOLV_PAR_GRP;
prompt Disabling foreign key constraints for SOLVER_PARAMETER...
alter table SOLVER_PARAMETER disable constraint FK_SOLVER_PARAM_DEF;
alter table SOLVER_PARAMETER disable constraint FK_SOLVER_PARAM_PREDEF_STG;
alter table SOLVER_PARAMETER disable constraint FK_SOLVER_PARAM_SOLUTION;
prompt Disabling foreign key constraints for STUDENT_ACAD_AREA...
alter table STUDENT_ACAD_AREA disable constraint FK_STUDENT_ACAD_AREA_AREA;
alter table STUDENT_ACAD_AREA disable constraint FK_STUDENT_ACAD_AREA_CLASF;
alter table STUDENT_ACAD_AREA disable constraint FK_STUDENT_ACAD_AREA_STUDENT;
prompt Disabling foreign key constraints for STUDENT_ACCOMODATION...
alter table STUDENT_ACCOMODATION disable constraint FK_STUDENT_ACCOM_SESSION;
prompt Disabling foreign key constraints for STUDENT_CLASS_ENRL...
alter table STUDENT_CLASS_ENRL disable constraint FK_STUDENT_CLASS_ENRL_CLASS;
alter table STUDENT_CLASS_ENRL disable constraint FK_STUDENT_CLASS_ENRL_COURSE;
alter table STUDENT_CLASS_ENRL disable constraint FK_STUDENT_CLASS_ENRL_REQUEST;
alter table STUDENT_CLASS_ENRL disable constraint FK_STUDENT_CLASS_ENRL_STUDENT;
prompt Disabling foreign key constraints for STUDENT_ENRL...
alter table STUDENT_ENRL disable constraint FK_STUDENT_ENRL_CLASS;
alter table STUDENT_ENRL disable constraint FK_STUDENT_ENRL_SOLUTION;
prompt Disabling foreign key constraints for STUDENT_ENRL_MSG...
alter table STUDENT_ENRL_MSG disable constraint FK_STUDENT_ENRL_MSG_DEMAND;
prompt Disabling foreign key constraints for STUDENT_GROUP...
alter table STUDENT_GROUP disable constraint FK_STUDENT_GROUP_SESSION;
prompt Disabling foreign key constraints for STUDENT_GROUP_RESERVATION...
alter table STUDENT_GROUP_RESERVATION disable constraint FK_STU_GRP_RESV_RESERV_TYPE;
alter table STUDENT_GROUP_RESERVATION disable constraint FK_STU_GRP_RESV_STU_GRP;
prompt Disabling foreign key constraints for STUDENT_MAJOR...
alter table STUDENT_MAJOR disable constraint FK_STUDENT_MAJOR_MAJOR;
alter table STUDENT_MAJOR disable constraint FK_STUDENT_MAJOR_STUDENT;
prompt Disabling foreign key constraints for STUDENT_MINOR...
alter table STUDENT_MINOR disable constraint FK_STUDENT_MINOR_MINOR;
alter table STUDENT_MINOR disable constraint FK_STUDENT_MINOR_STUDENT;
prompt Disabling foreign key constraints for STUDENT_TO_ACOMODATION...
alter table STUDENT_TO_ACOMODATION disable constraint FK_STUDENT_ACOMODATION_ACCOM;
alter table STUDENT_TO_ACOMODATION disable constraint FK_STUDENT_ACOMODATION_STUDENT;
prompt Disabling foreign key constraints for STUDENT_TO_GROUP...
alter table STUDENT_TO_GROUP disable constraint FK_STUDENT_GROUP_GROUP;
alter table STUDENT_TO_GROUP disable constraint FK_STUDENT_GROUP_STUDENT;
prompt Disabling foreign key constraints for TIME_PATTERN_DAYS...
alter table TIME_PATTERN_DAYS disable constraint FK_TIME_PATTERN_DAYS_TIME_PATT;
prompt Disabling foreign key constraints for TIME_PATTERN_DEPT...
alter table TIME_PATTERN_DEPT disable constraint FK_TIME_PATTERN_DEPT_DEPT;
alter table TIME_PATTERN_DEPT disable constraint FK_TIME_PATTERN_DEPT_PATTERN;
prompt Disabling foreign key constraints for TIME_PATTERN_TIME...
alter table TIME_PATTERN_TIME disable constraint FK_TIME_PATTERN_TIME;
prompt Disabling foreign key constraints for TIME_PREF...
alter table TIME_PREF disable constraint FK_TIME_PREF_PREF_LEVEL;
alter table TIME_PREF disable constraint FK_TIME_PREF_TIME_PTRN;
prompt Disabling foreign key constraints for TMTBL_MGR_TO_ROLES...
alter table TMTBL_MGR_TO_ROLES disable constraint FK_TMTBL_MGR_TO_ROLES_MANAGER;
alter table TMTBL_MGR_TO_ROLES disable constraint FK_TMTBL_MGR_TO_ROLES_ROLE;
prompt Disabling foreign key constraints for WAITLIST...
alter table WAITLIST disable constraint FK_WAITLIST_COURSE_OFFERING;
alter table WAITLIST disable constraint FK_WAITLIST_STUDENT;
prompt Disabling foreign key constraints for XCONFLICT_EXAM...
alter table XCONFLICT_EXAM disable constraint FK_XCONFLICT_EX_CONF;
alter table XCONFLICT_EXAM disable constraint FK_XCONFLICT_EX_EXAM;
prompt Disabling foreign key constraints for XCONFLICT_INSTRUCTOR...
alter table XCONFLICT_INSTRUCTOR disable constraint FK_XCONFLICT_IN_CONF;
alter table XCONFLICT_INSTRUCTOR disable constraint FK_XCONFLICT_IN_INSTRUCTOR;
prompt Disabling foreign key constraints for XCONFLICT_STUDENT...
alter table XCONFLICT_STUDENT disable constraint FK_XCONFLICT_ST_CONF;
alter table XCONFLICT_STUDENT disable constraint FK_XCONFLICT_ST_STUDENT;
prompt Loading DATE_PATTERN...
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (49, 'Full Term', '111111011111100111110111111011111101111110111111000111101111110111111011111101111110111111011000001111110111111', 0, 0, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (52, 'Week 1-10', '111111011111100111110111111011111101111110111111000111101111110111111011', 0, 0, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (53, 'Week 6-15', '1111110111111000111101111110111111011111101111110111111011000001111110111111', -35, 0, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (54, 'Week 1-8', '1111110111111001111101111110111111011111101111110001111011', 0, 0, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (55, 'Week 9-15', '11110111111011111101111110111111011000001111110111111', -58, 0, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (56, 'Week 1-5', '1111110111111001111101111110111111', 0, 0, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (57, 'Week 6-10', '1111110111111000111101111110111111011', -35, 0, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (58, 'Week 11-15', '111101111110111111011000001111110111111', -72, 0, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (59, 'Odd Wks', '111111000000000111110000000011111100000000111111000000000011110110000000111101100000001111011000000000000111111', 0, 1, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (60, 'Even Wks', '1111110000000011111100000000111111000000000011110110000000111101100000001111011000000000000111111', -7, 1, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (369, 'Week -1', '1111111', 7, 2, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (61, 'Week 1', '1111111', 0, 2, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (62, 'Week 2', '1111111', -7, 2, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (51, 'Week 2-15', '11111100111110111111011111101111110111111000111101111110111111011111101111110111111011000001111110111111', -7, 2, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (63, 'Week 3', '111111', -15, 2, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (64, 'Week 4', '1111111', -21, 2, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (65, 'Week 5', '1111111', -28, 2, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (66, 'Week 6', '1111111', -35, 2, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (67, 'Week 7', '1111111', -42, 2, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (68, 'Week 8', '1111111', -51, 2, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (69, 'Week 9', '1111111', -58, 2, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (70, 'Week 10', '1111111', -65, 2, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (71, 'Week 11', '1111111', -72, 2, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (72, 'Week 12', '1111111', -79, 2, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (73, 'Week 13', '1111111', -86, 2, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (74, 'Week 14', '1111111', -98, 2, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (75, 'Week 15', '1111111', -105, 2, 1, 223206);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (853, 'Full Term', '111111011111100111110111111011111101111110111111000111101111110111111011111101111110111111011000001111110111111', 0, 0, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (854, 'Week 1-10', '111111011111100111110111111011111101111110111111000111101111110111111011', 0, 0, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (855, 'Week 6-15', '1111110111111000111101111110111111011111101111110111111011000001111110111111', -35, 0, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (856, 'Week 1-8', '1111110111111001111101111110111111011111101111110001111011', 0, 0, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (857, 'Week 9-15', '11110111111011111101111110111111011000001111110111111', -58, 0, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (858, 'Week 1-5', '1111110111111001111101111110111111', 0, 0, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (859, 'Week 6-10', '1111110111111000111101111110111111011', -35, 0, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (860, 'Week 11-15', '111101111110111111011000001111110111111', -72, 0, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (861, 'Odd Wks', '111111000000000111110000000011111100000000111111000000000011110110000000111101100000001111011000000000000111111', 0, 1, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (862, 'Even Wks', '1111110000000011111100000000111111000000000011110110000000111101100000001111011000000000000111111', -7, 1, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (863, 'Week -1', '1111111', 7, 2, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (864, 'Week 1', '1111111', 0, 2, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (865, 'Week 2', '1111111', -7, 2, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (866, 'Week 2-15', '11111100111110111111011111101111110111111000111101111110111111011111101111110111111011000001111110111111', -7, 2, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (867, 'Week 3', '111111', -15, 2, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (868, 'Week 4', '1111111', -21, 2, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (869, 'Week 5', '1111111', -28, 2, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (870, 'Week 6', '1111111', -35, 2, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (871, 'Week 7', '1111111', -42, 2, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (872, 'Week 8', '1111111', -51, 2, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (873, 'Week 9', '1111111', -58, 2, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (874, 'Week 10', '1111111', -65, 2, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (875, 'Week 11', '1111111', -72, 2, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (876, 'Week 12', '1111111', -79, 2, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (877, 'Week 13', '1111111', -86, 2, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (878, 'Week 14', '1111111', -98, 2, 1, 231379);
insert into DATE_PATTERN (uniqueid, name, pattern, offset, type, visible, session_id)
values (879, 'Week 15', '1111111', -105, 2, 1, 231379);
commit;
prompt 54 records loaded
prompt Loading DEPT_STATUS_TYPE...
insert into DEPT_STATUS_TYPE (uniqueid, reference, label, status, apply, ord)
values (265, 'initial', 'Initial Data Load', 0, 1, 0);
insert into DEPT_STATUS_TYPE (uniqueid, reference, label, status, apply, ord)
values (266, 'input', 'Input Data Entry', 1721, 1, 1);
insert into DEPT_STATUS_TYPE (uniqueid, reference, label, status, apply, ord)
values (267, 'timetabling', 'Timetabling', 4025, 1, 2);
insert into DEPT_STATUS_TYPE (uniqueid, reference, label, status, apply, ord)
values (268, 'publish', 'Timetable Published', 61961, 1, 4);
insert into DEPT_STATUS_TYPE (uniqueid, reference, label, status, apply, ord)
values (269, 'finished', 'Session Finished', 521, 1, 5);
insert into DEPT_STATUS_TYPE (uniqueid, reference, label, status, apply, ord)
values (270, 'dept_input', 'External Mgr. Input Data Entry', 135, 2, 7);
insert into DEPT_STATUS_TYPE (uniqueid, reference, label, status, apply, ord)
values (271, 'dept_timetabling', 'External Mgr. Timetabling', 423, 2, 8);
insert into DEPT_STATUS_TYPE (uniqueid, reference, label, status, apply, ord)
values (272, 'dept_publish', 'External Mgr. Timetable Published', 1, 2, 10);
insert into DEPT_STATUS_TYPE (uniqueid, reference, label, status, apply, ord)
values (385, 'dept_readonly_ni', 'External Mgr. Timetabling (No Instructor Assignments)', 391, 2, 9);
insert into DEPT_STATUS_TYPE (uniqueid, reference, label, status, apply, ord)
values (325, 'dept_readonly', 'Department Read Only', 9, 2, 11);
insert into DEPT_STATUS_TYPE (uniqueid, reference, label, status, apply, ord)
values (326, 'dept_edit', 'Department Allow Edit', 441, 2, 12);
insert into DEPT_STATUS_TYPE (uniqueid, reference, label, status, apply, ord)
values (414, 'exams', 'Examination Timetabling', 3593, 1, 3);
insert into DEPT_STATUS_TYPE (uniqueid, reference, label, status, apply, ord)
values (445, 'demo', 'Demo (All Enabled)', 65535, 1, 6);
commit;
prompt 13 records loaded
prompt Loading SESSIONS...
insert into SESSIONS (academic_initiative, session_begin_date_time, classes_end_date_time, session_end_date_time, uniqueid, holidays, def_datepatt_id, status_type, last_modified_time, academic_year, academic_term, exam_begin_date, event_begin_date, event_end_date)
values ('woebegon', to_date('20-08-2007', 'dd-mm-yyyy'), to_date('08-12-2007', 'dd-mm-yyyy'), to_date('15-12-2007', 'dd-mm-yyyy'), 223206, '00000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000022000000000000000000000000000000000000000000222200000000000000000000000000000000000000000000000000000000000000000000', 49, 269, null, '2007', 'Fal', to_date('10-12-2007', 'dd-mm-yyyy'), to_date('20-07-2007', 'dd-mm-yyyy'), to_date('15-01-2008', 'dd-mm-yyyy'));
insert into SESSIONS (academic_initiative, session_begin_date_time, classes_end_date_time, session_end_date_time, uniqueid, holidays, def_datepatt_id, status_type, last_modified_time, academic_year, academic_term, exam_begin_date, event_begin_date, event_end_date)
values ('woebegon', to_date('23-08-2010', 'dd-mm-yyyy'), to_date('12-12-2010', 'dd-mm-yyyy'), to_date('19-12-2010', 'dd-mm-yyyy'), 231379, '00000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000022000000000000000000000000000000000000000000222200000000000000000000000000000000000000000000000000000000000000000', 853, 445, null, '2010', 'Fal', to_date('13-12-2010', 'dd-mm-yyyy'), to_date('19-07-2010', 'dd-mm-yyyy'), to_date('16-01-2011', 'dd-mm-yyyy'));
commit;
prompt 2 records loaded
prompt Loading ACADEMIC_AREA...
insert into ACADEMIC_AREA (uniqueid, session_id, academic_area_abbreviation, short_title, long_title, external_uid)
values (142, 231379, 'A', 'Woebegon', 'The Woebegon''s Only Academic Area', 'A');
insert into ACADEMIC_AREA (uniqueid, session_id, academic_area_abbreviation, short_title, long_title, external_uid)
values (144, 223206, 'A', 'Area 1', 'Area 1', 'A');
commit;
prompt 2 records loaded
prompt Loading ACADEMIC_CLASSIFICATION...
insert into ACADEMIC_CLASSIFICATION (uniqueid, session_id, code, name, external_uid)
values (61, 231379, '01', 'Junior Year', '01');
insert into ACADEMIC_CLASSIFICATION (uniqueid, session_id, code, name, external_uid)
values (62, 231379, '02', 'Senior Year', '02');
insert into ACADEMIC_CLASSIFICATION (uniqueid, session_id, code, name, external_uid)
values (63, 223206, '01', 'Junior Year', '01');
insert into ACADEMIC_CLASSIFICATION (uniqueid, session_id, code, name, external_uid)
values (64, 223206, '02', 'Senior Year', '02');
commit;
prompt 4 records loaded
prompt Loading RESERVATION_TYPE...
insert into RESERVATION_TYPE (uniqueid, reference, label)
values (288, 'perm', 'Permanent');
insert into RESERVATION_TYPE (uniqueid, reference, label)
values (289, 'temp', 'Temporary');
insert into RESERVATION_TYPE (uniqueid, reference, label)
values (290, 'info', null);
commit;
prompt 3 records loaded
prompt Loading ACAD_AREA_RESERVATION...
prompt Table is empty
prompt Loading APPLICATION_CONFIG...
insert into APPLICATION_CONFIG (name, value, description)
values ('tmtbl.system_message', 'Welcome to Woebegon College test suite.', 'Message displayed to users when they first log in to Timetabling');
insert into APPLICATION_CONFIG (name, value, description)
values ('tmtbl.access_level', 'all', 'Access Levels: all | {dept code}(:{dept code})*');
insert into APPLICATION_CONFIG (name, value, description)
values ('tmtbl.db.version', '59', 'Timetabling database version (please do not change -- this key is used by automatic database update)');
commit;
prompt 3 records loaded
prompt Loading OFFR_CONSENT_TYPE...
insert into OFFR_CONSENT_TYPE (uniqueid, reference, label)
values (225, 'instructor', 'Consent of Instructor');
insert into OFFR_CONSENT_TYPE (uniqueid, reference, label)
values (226, 'department', 'Consent of Department');
commit;
prompt 2 records loaded
prompt Loading INSTRUCTIONAL_OFFERING...
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132331, 223206, 166800, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132334, 223206, 166801, 1, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132335, 223206, 166802, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132336, 223206, 166803, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132337, 223206, 166804, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132313, 223206, 1, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132314, 223206, 2, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132315, 223206, 3, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132316, 223206, 4, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132317, 223206, 5, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132318, 223206, 6, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132319, 223206, 7, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132320, 223206, 8, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132321, 223206, 9, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132322, 223206, 10, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132338, 223206, 166805, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132324, 223206, 12, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132325, 223206, 13, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132326, 223206, 14, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132327, 223206, 15, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132328, 223206, 16, 1, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132329, 223206, 17, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132330, 223206, 18, 0, null, null, 0, null, null, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132351, 231379, 1, 0, null, null, 0, null, 132313, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132352, 231379, 4, 0, null, null, 0, null, 132316, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132353, 231379, 2, 0, null, null, 0, null, 132314, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132354, 231379, 166801, 1, null, null, 0, null, 132334, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132355, 231379, 3, 0, null, null, 0, null, 132315, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132356, 231379, 166800, 0, null, null, 0, null, 132331, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132357, 231379, 16, 1, null, null, 0, null, 132328, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132358, 231379, 5, 0, null, null, 0, null, 132317, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132359, 231379, 7, 0, null, null, 0, null, 132319, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132360, 231379, 6, 0, null, null, 0, null, 132318, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132361, 231379, 8, 0, null, null, 0, null, 132320, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132362, 231379, 166802, 0, null, null, 0, null, 132335, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132363, 231379, 9, 0, null, null, 0, null, 132321, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132364, 231379, 10, 0, null, null, 0, null, 132322, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132365, 231379, 166803, 0, null, null, 0, null, 132336, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132366, 231379, 166805, 0, null, null, 0, null, 132338, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132367, 231379, 166804, 0, null, null, 0, null, 132337, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132368, 231379, 12, 0, null, null, 0, null, 132324, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132369, 231379, 13, 0, null, null, 0, null, 132325, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132370, 231379, 14, 0, null, null, 0, null, 132326, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132371, 231379, 15, 0, null, null, 0, null, 132327, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132372, 231379, 17, 0, null, null, 0, null, 132329, null);
insert into INSTRUCTIONAL_OFFERING (uniqueid, session_id, instr_offering_perm_id, not_offered, limit, consent_type, designator_required, last_modified_time, uid_rolled_fwd_from, external_uid)
values (132373, 231379, 18, 0, null, null, 0, null, 132330, null);
commit;
prompt 46 records loaded
prompt Loading INSTR_OFFERING_CONFIG...
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36966, 12, 132331, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36967, 3, 132334, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36968, 3, 132335, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36969, 2, 132336, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36970, 4, 132337, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36948, 2, 132313, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36949, 11, 132314, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36950, 4, 132315, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36951, 4, 132316, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36952, 12, 132317, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36953, 4, 132318, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36954, 9, 132319, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36955, 10, 132320, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36956, 4, 132321, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36957, 4, 132322, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36971, 3, 132338, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36959, 2, 132324, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36960, 5, 132325, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36961, 4, 132326, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36962, 4, 132327, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36963, 2, 132328, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36964, 4, 132329, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36965, 4, 132330, 0, '1', null, null);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36986, 2, 132351, 0, '1', null, 36948);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36987, 4, 132352, 0, '1', null, 36951);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36988, 11, 132353, 0, '1', null, 36949);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36989, 3, 132354, 0, '1', null, 36967);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36990, 4, 132355, 0, '1', null, 36950);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36991, 12, 132356, 0, '1', null, 36966);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36992, 2, 132357, 0, '1', null, 36963);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36993, 12, 132358, 0, '1', null, 36952);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36994, 9, 132359, 0, '1', null, 36954);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36995, 4, 132360, 0, '1', null, 36953);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36996, 10, 132361, 0, '1', null, 36955);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36997, 3, 132362, 0, '1', null, 36968);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36998, 4, 132363, 0, '1', null, 36956);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (36999, 4, 132364, 0, '1', null, 36957);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (37000, 2, 132365, 0, '1', null, 36969);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (37001, 3, 132366, 0, '1', null, 36971);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (37002, 4, 132367, 0, '1', null, 36970);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (37003, 2, 132368, 0, '1', null, 36959);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (37004, 5, 132369, 0, '1', null, 36960);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (37005, 4, 132370, 0, '1', null, 36961);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (37006, 4, 132371, 0, '1', null, 36962);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (37007, 4, 132372, 0, '1', null, 36964);
insert into INSTR_OFFERING_CONFIG (uniqueid, config_limit, instr_offr_id, unlimited_enrollment, name, last_modified_time, uid_rolled_fwd_from)
values (37008, 4, 132373, 0, '1', null, 36965);
commit;
prompt 46 records loaded
prompt Loading ITYPE_DESC...
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (10, 'Lec  ', 'Lecture', 'lec', 1, null, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (11, 'Lec 1', 'Lecture 1', 'lec', 0, 10, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (12, 'Lec 2', 'Lecture 2', 'lec', 0, 10, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (13, 'Lec 3', 'Lecture 3', 'lec', 0, 10, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (14, 'Lec 4', 'Lecture 4', 'lec', 0, 10, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (15, 'Lec 5', 'Lecture 5', 'lec', 0, 10, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (16, 'Lec 6', 'Lecture 6', 'lec', 0, 10, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (17, 'Lec 7', 'Lecture 7', 'lec', 0, 10, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (18, 'Lec 8', 'Lecture 8', 'lec', 0, 10, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (19, 'Lec 9', 'Lecture 9', 'lec', 0, 10, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (20, 'Rec  ', 'Recitation', 'rec', 1, null, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (21, 'Rec 1', 'Recitation 1', 'rec', 0, 20, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (22, 'Rec 2', 'Recitation 2', 'rec', 0, 20, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (23, 'Rec 3', 'Recitation 3', 'rec', 0, 20, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (24, 'Rec 4', 'Recitation 4', 'rec', 0, 20, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (25, 'Prsn ', 'Presentation', 'prsn', 1, null, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (26, 'Prsn1', 'Presentation 1', 'prsn', 0, 25, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (27, 'Prsn2', 'Presentation 2', 'prsn', 0, 25, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (28, 'Prsn3', 'Presentation 3 ', 'prsn', 0, 25, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (29, 'Prsn4', 'Presentation 4', 'prsn', 0, 25, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (30, 'Lab  ', 'Laboratory', 'lab', 1, null, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (31, 'Lab 1', 'Laboratory 1', 'lab', 0, 30, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (32, 'Lab 2', 'Laboratory 2', 'lab', 0, 30, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (33, 'Lab 3', 'Laboratory 3', 'lab', 0, 30, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (34, 'Lab 4', 'Laboratory 4', 'lab', 0, 30, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (35, 'LabP ', 'Laboratory Preparation', 'labP', 1, null, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (36, 'LabP1', 'Laboratory Preparation 1', 'labP', 0, 35, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (37, 'LabP2', 'Laboratory Preparation 2', 'labP', 0, 35, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (38, 'LabP3', 'Laboratory Preparation 3', 'labP', 0, 35, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (39, 'LabP4', 'Laboratory Preparation 4', 'labP', 0, 35, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (40, 'Stdo ', 'Studio', 'stdo', 1, null, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (41, 'Stdo1', 'Studio 1', 'stdo', 0, 40, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (42, 'Stdo2', 'Studio 2', 'stdo', 0, 40, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (43, 'Stdo3', 'Studio 3', 'stdo', 0, 40, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (44, 'Stdo4', 'Studio 4', 'stdo', 0, 40, 1);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (45, 'Dist ', 'Distance Learning', 'dist', 1, null, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (46, 'Dist1', 'Distance Learning 1', 'dist', 0, 45, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (47, 'Dist2', 'Distance Learning 2', 'dist', 0, 45, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (48, 'Dist3', 'Distance Learning 3', 'dist', 0, 45, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (49, 'Dist4', 'Distance Learning 4', 'dist', 0, 45, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (50, 'Clin ', 'Clinic', 'clin', 1, null, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (51, 'Clin1', 'Clinic 1', 'clin', 0, 50, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (52, 'Clin2', 'Clinic 2', 'clin', 0, 50, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (53, 'Clin3', 'Clinic 3', 'clin', 0, 50, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (54, 'Clin4', 'Clinic 4', 'clin', 0, 50, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (55, 'Clin5', 'Clinic 5', 'clin', 0, 50, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (56, 'Clin6', 'Clinic 6', 'clin', 0, 50, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (57, 'Clin7', 'Clinic 7', 'clin', 0, 50, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (58, 'Clin8', 'Clinic 8', 'clin', 0, 50, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (59, 'Clin9', 'Clinic 9', 'clin', 0, 50, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (60, 'Expr ', 'Experiential', 'expr', 1, null, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (61, 'Expr1', 'Experiential 1', 'expr', 0, 60, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (62, 'Expr2', 'Experiential 2', 'expr', 0, 60, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (63, 'Expr3', 'Experiential 3', 'expr', 0, 60, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (64, 'Expr4', 'Experiential 4', 'expr', 0, 60, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (65, 'Expr5', 'Experiential 5', 'expr', 0, 60, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (66, 'Expr6', 'Experiential 6', 'expr', 0, 60, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (67, 'Expr7', 'Experiential 7', 'expr', 0, 60, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (68, 'Expr8', 'Experiential 8', 'expr', 0, 60, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (69, 'Expr9', 'Experiential 9', 'expr', 0, 60, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (70, 'Res  ', 'Research', 'res', 1, null, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (71, 'Res 1', 'Research 1', 'res', 0, 70, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (72, 'Res 2', 'Research 2', 'res', 0, 70, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (73, 'Res 3', 'Research 3', 'res', 0, 70, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (74, 'Res 4', 'Research 4', 'res', 0, 70, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (75, 'Res 5', 'Research 5', 'res', 0, 70, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (76, 'Res 6', 'Research 6', 'res', 0, 70, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (77, 'Res 7', 'Research 7', 'res', 0, 70, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (78, 'Res 8', 'Research 8', 'res', 0, 70, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (79, 'Res 9', 'Research 9', 'res', 0, 70, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (80, 'Ind  ', 'Individual Study', 'ind', 1, null, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (81, 'Ind 1', 'Individual Study 1', 'ind', 0, 80, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (82, 'Ind 2', 'Individual Study 2', 'ind', 0, 80, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (83, 'Ind 3', 'Individual Study 3', 'ind', 0, 80, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (84, 'Ind 4', 'Individual Study 4', 'ind', 0, 80, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (85, 'Ind 5', 'Individual Study 5', 'ind', 0, 80, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (86, 'Ind 6', 'Individual Study 6', 'ind', 0, 80, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (87, 'Ind 7', 'Individual Study 7', 'ind', 0, 80, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (88, 'Ind 8', 'Individual Study 8', 'ind', 0, 80, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (89, 'Ind 9', 'Individual Study 9', 'ind', 0, 80, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (90, 'Pso  ', 'Practice Study Observation', 'pso', 1, null, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (91, 'Pso 1', 'Practice Study Observation 1', 'pso', 0, 90, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (92, 'Pso 2', 'Practice Study Observation 2', 'pso', 0, 90, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (93, 'Pso 3', 'Practice Study Observation 3', 'pso', 0, 90, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (94, 'Pso 4', 'Practice Study Observation 4', 'pso', 0, 90, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (95, 'Pso 5', 'Practice Study Observation 5', 'pso', 0, 90, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (96, 'Pso 6', 'Practice Study Observation 6', 'pso', 0, 90, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (97, 'Pso 7', 'Practice Study Observation 7', 'pso', 0, 90, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (98, 'Pso 8', 'Practice Study Observation 8', 'pso', 0, 90, 0);
insert into ITYPE_DESC (itype, abbv, description, sis_ref, basic, parent, organized)
values (99, 'Pso 9', 'Practice Study Observation 9', 'pso', 0, 90, 0);
commit;
prompt 90 records loaded
prompt Loading SCHEDULING_SUBPART...
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223790, 50, 223367, 36963, 30, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223799, 50, 223377, 36965, 30, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223815, 50, 223255, 36952, 20, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223848, 50, 223309, 36955, 30, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223867, 150, null, 36966, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223868, 50, 223867, 36966, 20, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223901, 50, null, 36949, 20, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223913, 100, null, 36949, 30, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223925, 50, null, 36949, 90, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223937, 100, null, 36967, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223939, 100, null, 36967, 30, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223948, 100, null, 36950, 30, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223995, 100, null, 36968, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223997, 100, null, 36968, 30, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (224004, 50, 223323, 36956, 30, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (224016, 150, null, 36969, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (224021, 50, null, 36970, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (224030, 50, 223349, 36960, 20, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (224031, 100, 224030, 36960, 30, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223228, 150, null, 36948, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223239, 100, null, 36949, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223244, 100, null, 36950, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223248, 500, null, 36951, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223254, 100, null, 36952, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223255, 150, 223254, 36952, 30, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223290, 150, null, 36953, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223296, 150, null, 36954, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223309, 150, null, 36955, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223323, 150, null, 36956, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223329, 150, null, 36957, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (224056, 100, null, 36971, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223343, 150, null, 36959, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223349, 100, null, 36960, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223355, 150, null, 36961, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223362, 150, null, 36962, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223367, 150, null, 36963, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223372, 150, null, 36964, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (223377, 150, null, 36965, 10, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (224058, 100, null, 36971, 30, null, 1, '-', 0, null, null);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231390, 150, null, 36986, 10, null, 1, '-', 0, null, 223228);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231392, 500, null, 36987, 10, null, 1, '-', 0, null, 223248);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231394, 100, null, 36988, 10, null, 1, '-', 0, null, 223239);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231398, 100, null, 36988, 30, null, 1, '-', 0, null, 223913);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231410, 50, null, 36988, 20, null, 1, '-', 0, null, 223901);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231422, 50, null, 36988, 90, null, 1, '-', 0, null, 223925);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231426, 100, null, 36989, 10, null, 1, null, 0, null, 223937);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231427, 100, null, 36989, 30, null, 1, null, 0, null, 223939);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231428, 100, null, 36990, 30, null, 1, '-', 0, null, 223948);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231433, 100, null, 36990, 10, null, 1, '-', 0, null, 223244);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231436, 150, null, 36991, 10, null, 1, '-', 0, null, 223867);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231440, 50, 231436, 36991, 20, null, 1, '-', 0, null, 223868);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231453, 150, null, 36992, 10, null, 1, null, 0, null, 223367);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231454, 50, 231453, 36992, 30, null, 1, null, 0, null, 223790);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231455, 100, null, 36993, 10, null, 1, '-', 0, null, 223254);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231459, 150, 231455, 36993, 30, null, 1, '-', 0, null, 223255);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231472, 50, 231459, 36993, 20, null, 1, '-', 0, null, 223815);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231485, 150, null, 36994, 10, null, 1, '-', 0, null, 223296);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231495, 150, null, 36995, 10, null, 1, '-', 0, null, 223290);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231497, 150, null, 36996, 10, null, 1, '-', 0, null, 223309);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231508, 50, 231497, 36996, 30, null, 1, '-', 0, null, 223848);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231519, 100, null, 36997, 30, null, 1, '-', 0, null, 223997);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231523, 100, null, 36997, 10, null, 1, '-', 0, null, 223995);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231525, 150, null, 36998, 10, null, 1, '-', 0, null, 223323);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231528, 50, 231525, 36998, 30, null, 1, '-', 0, null, 224004);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231533, 150, null, 36999, 10, null, 1, '-', 0, null, 223329);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231536, 150, null, 37000, 10, null, 1, '-', 0, null, 224016);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231538, 100, null, 37001, 10, null, 1, '-', 0, null, 224056);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231540, 100, null, 37001, 30, null, 1, '-', 0, null, 224058);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231544, 50, null, 37002, 10, null, 1, '-', 0, null, 224021);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231546, 150, null, 37003, 10, null, 1, '-', 0, null, 223343);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231548, 100, null, 37004, 10, null, 1, '-', 0, null, 223349);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231551, 50, 231548, 37004, 20, null, 1, '-', 0, null, 224030);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231557, 100, 231551, 37004, 30, null, 1, '-', 0, null, 224031);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231563, 150, null, 37005, 10, null, 1, '-', 0, null, 223355);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231566, 150, null, 37006, 10, null, 1, '-', 0, null, 223362);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231568, 150, null, 37007, 10, null, 1, '-', 0, null, 223372);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231571, 150, null, 37008, 10, null, 1, '-', 0, null, 223377);
insert into SCHEDULING_SUBPART (uniqueid, min_per_wk, parent, config_id, itype, date_pattern_id, auto_time_spread, subpart_suffix, student_allow_overlap, last_modified_time, uid_rolled_fwd_from)
values (231574, 50, 231571, 37008, 30, null, 1, '-', 0, null, 223799);
commit;
prompt 78 records loaded
prompt Loading CLASS_...
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223240, 223239, 4, 1, null, null, null, null, null, 226199, 1, null, '003001', 1, 4, 1, 1, null, null, null, 3);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223245, 223244, 2, 1, null, null, null, null, null, 223207, 1, null, '001001', 1, 2, 1, 1, null, null, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223249, 223248, 4, 1, null, null, null, null, null, 226199, 1, null, '001001', 1, 4, 1, 1, null, null, null, 3);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223256, 223254, 4, 1, null, null, null, null, null, 226199, 1, null, '003001', 1, 4, 1, 1, null, null, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223257, 223254, 4, 1, null, null, null, null, null, 226199, 1, null, '002001', 1, 4, 1, 2, null, null, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223258, 223254, 4, 1, null, null, null, null, null, 226199, 1, null, '001001', 1, 4, 1, 3, null, null, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223259, 223255, 1, 1, 223256, null, null, null, null, 223207, 1, null, '009001', 1, 1, 1, 1, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223260, 223255, 1, 1, 223256, null, null, null, null, 223207, 1, null, '011001', 1, 1, 1, 2, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223261, 223255, 1, 1, 223256, null, null, null, null, 223207, 1, null, '012001', 1, 1, 1, 3, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223263, 223255, 1, 1, 223256, null, null, null, null, 223207, 1, null, '010001', 1, 1, 1, 4, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223264, 223255, 1, 1, 223257, null, null, null, null, 223207, 1, null, '007001', 1, 1, 1, 5, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223265, 223255, 1, 1, 223257, null, null, null, null, 223207, 1, null, '005001', 1, 1, 1, 6, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223267, 223255, 1, 1, 223257, null, null, null, null, 223207, 1, null, '008001', 1, 1, 1, 7, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223268, 223255, 1, 1, 223257, null, null, null, null, 223207, 1, null, '006001', 1, 1, 1, 8, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223269, 223255, 1, 1, 223258, null, null, null, null, 223207, 1, null, '002001', 1, 1, 1, 9, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223291, 223290, 4, 1, null, null, null, null, null, 226199, 1, null, '001001', 1, 4, 1, 1, null, null, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223297, 223296, 1, 1, null, null, null, null, null, 223207, 1, null, '005001', 1, 1, 1, 1, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223298, 223296, 1, 1, null, null, null, null, null, 223207, 1, null, '008001', 1, 1, 1, 2, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223299, 223296, 1, 1, null, null, null, null, null, 223207, 1, null, '001001', 1, 1, 1, 3, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223300, 223296, 1, 1, null, null, null, null, null, 223207, 1, null, '007001', 1, 1, 1, 4, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223301, 223296, 1, 1, null, null, null, null, null, 223207, 1, null, '006001', 1, 1, 1, 5, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223302, 223296, 1, 1, null, null, null, null, null, 223207, 1, null, '002001', 1, 1, 1, 6, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223303, 223296, 1, 1, null, null, null, null, null, 223207, 1, null, '009001', 1, 1, 1, 7, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223304, 223296, 1, 1, null, null, null, null, null, 223207, 1, null, '004001', 1, 1, 1, 8, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223305, 223296, 1, 1, null, null, null, null, null, 223207, 1, null, '003001', 1, 1, 1, 9, null, null, null, 0);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223310, 223309, 1, 1, null, null, null, null, null, 223207, 1, null, '010001', 1, 1, 1, 1, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223311, 223309, 1, 1, null, null, null, null, null, 223207, 1, null, '001001', 1, 1, 1, 2, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223312, 223309, 1, 1, null, null, null, null, null, 223207, 1, null, '009001', 1, 1, 1, 3, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223313, 223309, 1, 1, null, null, null, null, null, 223207, 1, null, '006001', 1, 1, 1, 4, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223314, 223309, 1, 1, null, null, null, null, null, 223207, 1, null, '002001', 1, 1, 1, 5, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223315, 223309, 1, 1, null, null, null, null, null, 223207, 1, null, '004001', 1, 1, 1, 6, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223316, 223309, 1, 1, null, null, null, null, null, 223207, 1, null, '003001', 1, 1, 1, 7, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223317, 223309, 1, 1, null, null, null, null, null, 223207, 1, null, '005001', 1, 1, 1, 8, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223318, 223309, 1, 1, null, null, null, null, null, 223207, 1, null, '008001', 1, 1, 1, 9, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223319, 223309, 1, 1, null, null, null, null, null, 223207, 1, null, '007001', 1, 1, 1, 10, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223324, 223323, 2, 1, null, null, null, null, null, 223207, 1, null, '001001', 1, 2, 1, 1, null, null, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223325, 223323, 2, 1, null, null, null, null, null, 223207, 1, null, '002001', 1, 2, 1, 2, null, null, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223330, 223329, 2, 1, null, null, null, null, null, 223207, 1, null, '002001', 1, 2, 1, 1, null, null, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223331, 223329, 2, 1, null, null, null, null, null, 223207, 1, null, '001001', 1, 2, 1, 2, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223344, 223343, 2, 1, null, null, null, null, null, 223207, 1, null, '001001', 1, 2, 1, 1, null, null, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223350, 223349, 3, 1, null, null, null, null, null, 223207, 1, null, '002001', 1, 3, 1, 1, null, null, null, 3);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223351, 223349, 2, 1, null, null, null, null, null, 223207, 1, null, '001001', 1, 2, 1, 2, null, null, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223356, 223355, 2, 1, null, null, null, null, null, 223207, 1, null, '001001', 1, 2, 1, 1, null, null, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223363, 223362, 4, 1, null, null, null, null, null, 226199, 1, null, '001001', 1, 4, 1, 1, null, null, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223373, 223372, 2, 1, null, null, null, null, null, 223207, 1, null, '002001', 1, 2, 1, 1, null, null, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223378, 223377, 2, 1, null, null, null, null, null, 223207, 1, null, '002001', 1, 2, 1, 1, null, null, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223379, 223377, 2, 1, null, null, null, null, null, 223207, 1, null, '001001', 1, 2, 1, 2, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223800, 223799, 1, 1, 223378, null, null, null, null, 223207, 1, null, '004001', 1, 1, 1, 1, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223801, 223799, 1, 1, 223378, null, null, null, null, 223207, 1, null, '003001', 1, 1, 1, 2, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223802, 223799, 1, 1, 223379, null, null, null, null, 223207, 1, null, '001001', 1, 1, 1, 3, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223803, 223799, 1, 1, 223379, null, null, null, null, 223207, 1, null, '002001', 1, 1, 1, 4, null, null, null, 0);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223817, 223255, 1, 1, 223258, null, null, null, null, 223207, 1, null, '004001', 1, 1, 1, 10, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223818, 223255, 1, 1, 223258, null, null, null, null, 223207, 1, null, '003001', 1, 1, 1, 11, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223819, 223255, 1, 1, 223258, null, null, null, null, 223207, 1, null, '001001', 1, 1, 1, 12, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223824, 223815, 1, 1, 223259, null, null, null, null, 223207, 1, null, '009001', 1, 1, 1, 1, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223825, 223815, 1, 1, 223260, null, null, null, null, 223207, 1, null, '011001', 1, 1, 1, 2, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223826, 223815, 1, 1, 223261, null, null, null, null, 223207, 1, null, '012001', 1, 1, 1, 3, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223827, 223815, 1, 1, 223263, null, null, null, null, 223207, 1, null, '010001', 1, 1, 1, 4, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223828, 223815, 1, 1, 223264, null, null, null, null, 223207, 1, null, '007001', 1, 1, 1, 5, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223829, 223815, 1, 1, 223265, null, null, null, null, 223207, 1, null, '005001', 1, 1, 1, 6, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223830, 223815, 1, 1, 223267, null, null, null, null, 223207, 1, null, '008001', 1, 1, 1, 7, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223831, 223815, 1, 1, 223268, null, null, null, null, 223207, 1, null, '006001', 1, 1, 1, 8, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223832, 223815, 1, 1, 223269, null, null, null, null, 223207, 1, null, '002001', 1, 1, 1, 9, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223833, 223815, 1, 1, 223817, null, null, null, null, 223207, 1, null, '004001', 1, 1, 1, 10, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223834, 223815, 1, 1, 223818, null, null, null, null, 223207, 1, null, '003001', 1, 1, 1, 11, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223835, 223815, 1, 1, 223819, null, null, null, null, 223207, 1, null, '001001', 1, 1, 1, 12, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223851, 223848, 1, 1, 223310, null, null, null, null, 223207, 1, null, '010001', 1, 1, 1, 1, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223852, 223848, 1, 1, 223311, null, null, null, null, 223207, 1, null, '001001', 1, 1, 1, 2, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223853, 223848, 1, 1, 223312, null, null, null, null, 223207, 1, null, '009001', 1, 1, 1, 3, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223854, 223848, 1, 1, 223313, null, null, null, null, 223207, 1, null, '006001', 1, 1, 1, 4, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223855, 223848, 1, 1, 223314, null, null, null, null, 223207, 1, null, '002001', 1, 1, 1, 5, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223856, 223848, 1, 1, 223315, null, null, null, null, 223207, 1, null, '004001', 1, 1, 1, 6, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223857, 223848, 1, 1, 223316, null, null, null, null, 223207, 1, null, '003001', 1, 1, 1, 7, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223858, 223848, 1, 1, 223317, null, null, null, null, 223207, 1, null, '005001', 1, 1, 1, 8, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223859, 223848, 1, 1, 223318, null, null, null, null, 223207, 1, null, '008001', 1, 1, 1, 9, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223860, 223848, 1, 1, 223319, null, null, null, null, 223207, 1, null, '007001', 1, 1, 1, 10, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223869, 223867, 4, 1, null, null, null, null, null, 226199, 1, null, '002001', 1, 4, 1, 1, null, null, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223870, 223868, 1, 1, 223869, null, null, null, null, 223207, 1, null, '007001', 1, 1, 1, 1, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224057, 224056, 3, 1, null, null, null, null, null, 226199, 1, null, '001001', 1, 3, 1, 1, null, null, null, 3);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224059, 224058, 1, 1, null, null, null, null, null, 223207, 1, null, '003001', 1, 1, 1, 1, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224060, 224058, 1, 1, null, null, null, null, null, 223207, 1, null, '002001', 1, 1, 1, 2, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224061, 224058, 1, 1, null, null, null, null, null, 223207, 1, null, '001001', 1, 1, 1, 3, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223884, 223228, 2, 1, null, null, null, null, null, 223207, 1, null, '001001', 1, 2, 1, 1, null, null, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223899, 223239, 4, 1, null, null, null, null, null, 226199, 1, null, '002001', 1, 4, 1, 2, null, null, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223900, 223239, 4, 1, null, null, null, null, null, 226199, 1, null, '001001', 1, 4, 1, 3, null, null, null, 3);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223902, 223901, 1, 1, null, null, null, null, null, 223207, 1, null, '004001', 1, 1, 1, 1, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223903, 223901, 1, 1, null, null, null, null, null, 223207, 1, null, '010001', 1, 1, 1, 2, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223904, 223901, 1, 1, null, null, null, null, null, 223207, 1, null, '005001', 1, 1, 1, 3, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223905, 223901, 1, 1, null, null, null, null, null, 223207, 1, null, '011001', 1, 1, 1, 4, null, null, null, 0);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223906, 223901, 1, 1, null, null, null, null, null, 223207, 1, null, '002001', 1, 1, 1, 5, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223907, 223901, 1, 1, null, null, null, null, null, 223207, 1, null, '003001', 1, 1, 1, 6, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223908, 223901, 1, 1, null, null, null, null, null, 223207, 1, null, '001001', 1, 1, 1, 7, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223909, 223901, 1, 1, null, null, null, null, null, 223207, 1, null, '009001', 1, 1, 1, 8, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223910, 223901, 1, 1, null, null, null, null, null, 223207, 1, null, '006001', 1, 1, 1, 9, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223973, 223925, 4, 1, null, null, null, null, null, 226199, 1, null, '002001', 1, 4, 1, 3, null, null, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223976, 223901, 1, 1, null, null, null, null, null, 223207, 1, null, '008001', 1, 1, 1, 10, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223914, 223913, 1, 1, null, null, null, null, null, 223207, 1, null, '010001', 1, 1, 1, 1, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223915, 223913, 1, 1, null, null, null, null, null, 223207, 1, null, '003001', 1, 1, 1, 2, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223916, 223913, 1, 1, null, null, null, null, null, 223207, 1, null, '002001', 1, 1, 1, 3, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223917, 223913, 1, 1, null, null, null, null, null, 223207, 1, null, '001001', 1, 1, 1, 4, null, null, null, 1);
commit;
prompt 100 records committed...
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223918, 223913, 1, 1, null, null, null, null, null, 223207, 1, null, '011001', 1, 1, 1, 5, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223919, 223913, 1, 1, null, null, null, null, null, 223207, 1, null, '007001', 1, 1, 1, 6, null, null, null, 0);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223920, 223913, 1, 1, null, null, null, null, null, 223207, 1, null, '006001', 1, 1, 1, 7, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223921, 223913, 1, 1, null, null, null, null, null, 223207, 1, null, '008001', 1, 1, 1, 8, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223922, 223913, 1, 1, null, null, null, null, null, 223207, 1, null, '009001', 1, 1, 1, 9, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223977, 223901, 1, 1, null, null, null, null, null, 223207, 1, null, '007001', 1, 1, 1, 11, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223978, 223913, 1, 1, null, null, null, null, null, 223207, 1, null, '005001', 1, 1, 1, 10, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223926, 223925, 4, 1, null, null, null, null, null, 226199, 1, null, '001001', 1, 4, 1, 1, null, null, null, 3);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223927, 223925, 4, 1, null, null, null, null, null, 226199, 1, null, '003001', 1, 4, 1, 2, null, null, null, 3);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223979, 223913, 1, 1, null, null, null, null, null, 223207, 1, null, '004001', 1, 1, 1, 11, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223947, 223244, 2, 1, null, null, null, null, null, 223207, 1, null, '002001', 1, 2, 1, 2, null, null, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223949, 223948, 1, 1, null, null, null, null, null, 223207, 1, null, '002001', 1, 1, 1, 1, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223950, 223948, 1, 1, null, null, null, null, null, 223207, 1, null, '004001', 1, 1, 1, 2, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223951, 223948, 1, 1, null, null, null, null, null, 223207, 1, null, '001001', 1, 1, 1, 3, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223956, 223867, 4, 1, null, null, null, null, null, 226199, 1, null, '003001', 1, 4, 1, 2, null, null, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223957, 223867, 4, 1, null, null, null, null, null, 226199, 1, null, '001001', 1, 4, 1, 3, null, null, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223958, 223868, 1, 1, 223869, null, null, null, null, 223207, 1, null, '005001', 1, 1, 1, 2, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223959, 223868, 1, 1, 223869, null, null, null, null, 223207, 1, null, '006001', 1, 1, 1, 3, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223960, 223868, 1, 1, 223869, null, null, null, null, 223207, 1, null, '008001', 1, 1, 1, 4, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223961, 223868, 1, 1, 223956, null, null, null, null, 223207, 1, null, '011001', 1, 1, 1, 5, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223962, 223868, 1, 1, 223956, null, null, null, null, 223207, 1, null, '009001', 1, 1, 1, 6, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223963, 223868, 1, 1, 223956, null, null, null, null, 223207, 1, null, '010001', 1, 1, 1, 7, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223964, 223868, 1, 1, 223956, null, null, null, null, 223207, 1, null, '012001', 1, 1, 1, 8, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223965, 223868, 1, 1, 223957, null, null, null, null, 223207, 1, null, '001001', 1, 1, 1, 9, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223966, 223868, 1, 1, 223957, null, null, null, null, 223207, 1, null, '003001', 1, 1, 1, 10, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223967, 223868, 1, 1, 223957, null, null, null, null, 223207, 1, null, '002001', 1, 1, 1, 11, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223968, 223868, 1, 1, 223957, null, null, null, null, 223207, 1, null, '004001', 1, 1, 1, 12, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223970, 223948, 1, 1, null, null, null, null, null, 223207, 1, null, '003001', 1, 1, 1, 4, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223996, 223995, 3, 1, null, null, null, null, null, 223207, 1, null, '001001', 1, 3, 1, 1, null, null, null, 3);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223998, 223997, 1, 1, null, null, null, null, null, 223207, 1, null, '003001', 1, 1, 1, 1, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (223999, 223997, 1, 1, null, null, null, null, null, 223207, 1, null, '001001', 1, 1, 1, 2, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224000, 223997, 1, 1, null, null, null, null, null, 223207, 1, null, '002001', 1, 1, 1, 3, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224005, 224004, 1, 1, 223324, null, null, null, null, 223207, 1, null, '001001', 1, 1, 1, 1, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224006, 224004, 1, 1, 223324, null, null, null, null, 223207, 1, null, '002001', 1, 1, 1, 2, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224007, 224004, 1, 1, 223325, null, null, null, null, 223207, 1, null, '003001', 1, 1, 1, 3, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224008, 224004, 1, 1, 223325, null, null, null, null, 223207, 1, null, '004001', 1, 1, 1, 4, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224017, 224016, 2, 1, null, null, null, null, null, 223207, 1, null, '001001', 1, 2, 1, 1, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224022, 224021, 4, 1, null, null, null, null, null, 226199, 1, null, '001001', 1, 4, 1, 1, null, null, null, 3);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224028, 223355, 2, 1, null, null, null, null, null, 223207, 1, null, '002001', 1, 2, 1, 2, null, null, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224032, 224030, 1, 1, 223350, null, null, null, null, 223207, 1, null, '003001', 1, 1, 1, 1, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224033, 224030, 1, 1, 223350, null, null, null, null, 223207, 1, null, '005001', 1, 1, 1, 2, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224034, 224030, 1, 1, 223350, null, null, null, null, 223207, 1, null, '004001', 1, 1, 1, 3, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224035, 224030, 1, 1, 223351, null, null, null, null, 223207, 1, null, '002001', 1, 1, 1, 4, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224036, 224030, 1, 1, 223351, null, null, null, null, 223207, 1, null, '001001', 1, 1, 1, 5, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224038, 224031, 1, 1, 224032, null, null, null, null, 223207, 1, null, '003001', 1, 1, 1, 1, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224039, 224031, 1, 1, 224033, null, null, null, null, 223207, 1, null, '005001', 1, 1, 1, 2, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224040, 224031, 1, 1, 224034, null, null, null, null, 223207, 1, null, '004001', 1, 1, 1, 3, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224041, 224031, 1, 1, 224035, null, null, null, null, 223207, 1, null, '002001', 1, 1, 1, 4, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224042, 224031, 1, 1, 224036, null, null, null, null, 223207, 1, null, '001001', 1, 1, 1, 5, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (224050, 223372, 2, 1, null, null, null, null, null, 223207, 1, null, '001001', 1, 2, 1, 2, null, null, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231391, 231390, 2, 1, null, null, null, null, null, 231383, 1, null, null, 1, 2, 1, 1, null, 223884, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231393, 231392, 4, 1, null, null, null, null, null, 231382, 1, null, null, 1, 4, 1, 1, null, 223249, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231395, 231394, 4, 1, null, null, null, null, null, 231382, 1, null, null, 1, 4, 1, 1, null, 223900, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231396, 231394, 4, 1, null, null, null, null, null, 231382, 1, null, null, 1, 4, 1, 2, null, 223240, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231397, 231394, 4, 1, null, null, null, null, null, 231382, 1, null, null, 1, 4, 1, 3, null, 223899, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231399, 231398, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 1, null, 223922, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231400, 231398, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 2, null, 223919, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231401, 231398, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 3, null, 223914, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231402, 231398, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 4, null, 223920, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231403, 231398, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 5, null, 223915, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231404, 231398, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 6, null, 223979, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231405, 231398, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 7, null, 223916, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231406, 231398, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 8, null, 223917, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231407, 231398, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 9, null, 223921, null, 0);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231408, 231398, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 10, null, 223918, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231409, 231398, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 11, null, 223978, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231411, 231410, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 1, null, 223910, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231412, 231410, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 2, null, 223908, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231413, 231410, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 3, null, 223902, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231414, 231410, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 4, null, 223904, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231415, 231410, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 5, null, 223977, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231416, 231410, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 6, null, 223906, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231417, 231410, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 7, null, 223903, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231418, 231410, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 8, null, 223976, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231419, 231410, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 9, null, 223907, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231420, 231410, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 10, null, 223905, null, 0);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231421, 231410, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 11, null, 223909, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231423, 231422, 4, 1, null, null, null, null, null, 231382, 1, null, null, 1, 4, 1, 1, null, 223973, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231424, 231422, 4, 1, null, null, null, null, null, 231382, 1, null, null, 1, 4, 1, 2, null, 223926, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231425, 231422, 4, 1, null, null, null, null, null, 231382, 1, null, null, 1, 4, 1, 3, null, 223927, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231429, 231428, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 1, null, 223949, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231430, 231428, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 2, null, 223970, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231431, 231428, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 3, null, 223951, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231432, 231428, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 4, null, 223950, null, 0);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231434, 231433, 2, 1, null, null, null, null, null, 231383, 1, null, null, 1, 2, 1, 1, null, 223947, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231435, 231433, 2, 1, null, null, null, null, null, 231383, 1, null, null, 1, 2, 1, 2, null, 223245, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231437, 231436, 4, 1, null, null, null, null, null, 231382, 1, null, null, 1, 4, 1, 1, null, 223956, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231438, 231436, 4, 1, null, null, null, null, null, 231382, 1, null, null, 1, 4, 1, 2, null, 223869, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231441, 231440, 1, 1, 231437, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 1, null, 223964, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231442, 231440, 1, 1, 231439, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 9, null, 223967, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231443, 231440, 1, 1, 231438, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 5, null, 223959, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231444, 231440, 1, 1, 231439, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 10, null, 223966, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231445, 231440, 1, 1, 231437, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 2, null, 223963, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231446, 231440, 1, 1, 231438, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 6, null, 223958, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231447, 231440, 1, 1, 231439, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 11, null, 223968, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231448, 231440, 1, 1, 231438, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 7, null, 223960, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231449, 231440, 1, 1, 231437, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 3, null, 223961, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231450, 231440, 1, 1, 231439, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 12, null, 223965, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231451, 231440, 1, 1, 231437, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 4, null, 223962, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231456, 231455, 4, 1, null, null, null, null, null, 231382, 1, null, null, 1, 4, 1, 1, null, 223256, null, 4);
commit;
prompt 200 records committed...
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231457, 231455, 4, 1, null, null, null, null, null, 231382, 1, null, null, 1, 4, 1, 2, null, 223258, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231458, 231455, 4, 1, null, null, null, null, null, 231382, 1, null, null, 1, 4, 1, 3, null, 223257, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231460, 231459, 1, 1, 231457, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 5, null, 223818, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231461, 231459, 1, 1, 231456, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 1, null, 223261, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231462, 231459, 1, 1, 231457, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 6, null, 223817, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231463, 231459, 1, 1, 231457, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 7, null, 223819, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231464, 231459, 1, 1, 231458, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 9, null, 223265, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231465, 231459, 1, 1, 231457, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 8, null, 223269, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231466, 231459, 1, 1, 231456, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 2, null, 223263, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231467, 231459, 1, 1, 231456, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 3, null, 223260, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231468, 231459, 1, 1, 231456, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 4, null, 223259, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231470, 231459, 1, 1, 231458, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 11, null, 223267, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231471, 231459, 1, 1, 231458, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 12, null, 223264, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231473, 231472, 1, 1, 231462, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 6, null, 223833, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231474, 231472, 1, 1, 231463, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 7, null, 223835, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231475, 231472, 1, 1, 231469, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 10, null, 223831, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231476, 231472, 1, 1, 231464, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 9, null, 223829, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231477, 231472, 1, 1, 231466, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 2, null, 223827, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231478, 231472, 1, 1, 231465, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 8, null, 223832, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231479, 231472, 1, 1, 231468, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 4, null, 223824, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231480, 231472, 1, 1, 231461, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 1, null, 223826, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231481, 231472, 1, 1, 231470, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 11, null, 223830, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231482, 231472, 1, 1, 231471, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 12, null, 223828, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231484, 231472, 1, 1, 231467, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 3, null, 223825, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231486, 231485, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 1, null, 223303, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231487, 231485, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 2, null, 223301, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231488, 231485, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 3, null, 223304, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231489, 231485, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 4, null, 223299, null, 0);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231490, 231485, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 5, null, 223305, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231491, 231485, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 6, null, 223298, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231492, 231485, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 7, null, 223297, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231493, 231485, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 8, null, 223302, null, 0);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231494, 231485, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 9, null, 223300, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231496, 231495, 4, 1, null, null, null, null, null, 231382, 1, null, null, 1, 4, 1, 1, null, 223291, null, 3);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231498, 231497, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 1, null, 223314, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231500, 231497, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 3, null, 223311, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231501, 231497, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 4, null, 223310, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231502, 231497, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 5, null, 223318, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231503, 231497, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 6, null, 223313, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231504, 231497, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 7, null, 223317, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231505, 231497, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 8, null, 223316, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231506, 231497, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 9, null, 223319, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231507, 231497, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 10, null, 223315, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231509, 231508, 1, 1, 231504, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 7, null, 223858, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231510, 231508, 1, 1, 231505, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 8, null, 223857, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231511, 231508, 1, 1, 231498, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 1, null, 223855, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231513, 231508, 1, 1, 231503, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 6, null, 223854, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231514, 231508, 1, 1, 231506, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 9, null, 223860, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231515, 231508, 1, 1, 231499, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 2, null, 223853, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231516, 231508, 1, 1, 231501, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 4, null, 223851, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231517, 231508, 1, 1, 231507, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 10, null, 223856, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231518, 231508, 1, 1, 231500, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 3, null, 223852, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231520, 231519, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 1, null, 223999, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231521, 231519, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 2, null, 224000, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231522, 231519, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 3, null, 223998, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231524, 231523, 3, 1, null, null, null, null, null, 231383, 1, null, null, 1, 3, 1, 1, null, 223996, null, 3);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231526, 231525, 2, 1, null, null, null, null, null, 231383, 1, null, null, 1, 2, 1, 1, null, 223325, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231527, 231525, 2, 1, null, null, null, null, null, 231383, 1, null, null, 1, 2, 1, 2, null, 223324, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231530, 231528, 1, 1, 231527, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 4, null, 224006, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231531, 231528, 1, 1, 231526, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 1, null, 224008, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231532, 231528, 1, 1, 231526, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 2, null, 224007, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231534, 231533, 2, 1, null, null, null, null, null, 231383, 1, null, null, 1, 2, 1, 1, null, 223330, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231535, 231533, 2, 1, null, null, null, null, null, 231383, 1, null, null, 1, 2, 1, 2, null, 223331, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231537, 231536, 2, 1, null, null, null, null, null, 231383, 1, null, null, 1, 2, 1, 1, null, 224017, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231539, 231538, 3, 1, null, null, null, null, null, 231382, 1, null, null, 1, 3, 1, 1, null, 224057, null, 3);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231541, 231540, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 1, null, 224061, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231542, 231540, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 2, null, 224059, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231543, 231540, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 3, null, 224060, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231545, 231544, 4, 1, null, null, null, null, null, 231382, 1, null, null, 1, 4, 1, 1, null, 224022, null, 3);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231547, 231546, 2, 1, null, null, null, null, null, 231383, 1, null, null, 1, 2, 1, 1, null, 223344, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231549, 231548, 2, 1, null, null, null, null, null, 231383, 1, null, null, 1, 2, 1, 1, null, 223351, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231550, 231548, 3, 1, null, null, null, null, null, 231383, 1, null, null, 1, 3, 1, 2, null, 223350, null, 3);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231552, 231551, 1, 1, 231550, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 3, null, 224032, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231553, 231551, 1, 1, 231549, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 1, null, 224036, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231554, 231551, 1, 1, 231550, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 4, null, 224033, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231555, 231551, 1, 1, 231550, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 5, null, 224034, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231556, 231551, 1, 1, 231549, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 2, null, 224035, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231558, 231557, 1, 1, 231555, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 5, null, 224040, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231559, 231557, 1, 1, 231552, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 3, null, 224038, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231560, 231557, 1, 1, 231553, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 1, null, 224042, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231561, 231557, 1, 1, 231554, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 4, null, 224039, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231562, 231557, 1, 1, 231556, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 2, null, 224041, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231564, 231563, 2, 1, null, null, null, null, null, 231383, 1, null, null, 1, 2, 1, 1, null, 224028, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231565, 231563, 2, 1, null, null, null, null, null, 231383, 1, null, null, 1, 2, 1, 2, null, 223356, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231567, 231566, 4, 1, null, null, null, null, null, 231382, 1, null, null, 1, 4, 1, 1, null, 223363, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231569, 231568, 2, 1, null, null, null, null, null, 231383, 1, null, null, 1, 2, 1, 1, null, 224050, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231570, 231568, 2, 1, null, null, null, null, null, 231383, 1, null, null, 1, 2, 1, 2, null, 223373, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231572, 231571, 2, 1, null, null, null, null, null, 231383, 1, null, null, 1, 2, 1, 1, null, 223379, null, 2);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231573, 231571, 2, 1, null, null, null, null, null, 231383, 1, null, null, 1, 2, 1, 2, null, 223378, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231575, 231574, 1, 1, 231573, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 3, null, 223801, null, 0);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231576, 231574, 1, 1, 231573, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 4, null, 223800, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231577, 231574, 1, 1, 231572, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 1, null, 223802, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231578, 231574, 1, 1, 231572, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 2, null, 223803, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231439, 231436, 4, 1, null, null, null, null, null, 231382, 1, null, null, 1, 4, 1, 3, null, 223957, null, 4);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231452, 231440, 1, 1, 231438, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 8, null, 223870, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231469, 231459, 1, 1, 231458, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 10, null, 223268, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231483, 231472, 1, 1, 231460, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 5, null, 223834, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231499, 231497, 1, 1, null, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 2, null, 223312, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231512, 231508, 1, 1, 231502, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 5, null, 223859, null, 1);
insert into CLASS_ (uniqueid, subpart_id, expected_capacity, nbr_rooms, parent_class_id, owner_id, room_capacity, notes, date_pattern_id, managing_dept, display_instructor, sched_print_note, class_suffix, display_in_sched_book, max_expected_capacity, room_ratio, section_number, last_modified_time, uid_rolled_fwd_from, external_uid, enrollment)
values (231529, 231528, 1, 1, 231527, null, null, null, null, 231383, 1, null, null, 1, 1, 1, 3, null, 224005, null, 1);
commit;
prompt 300 records loaded
prompt Loading SOLVER_GROUP...
insert into SOLVER_GROUP (uniqueid, name, abbv, session_id)
values (345, 'Large Lecture Room', 'LLR', 223206);
insert into SOLVER_GROUP (uniqueid, name, abbv, session_id)
values (344, 'Instructional Planning', 'Instr Plan', 223206);
insert into SOLVER_GROUP (uniqueid, name, abbv, session_id)
values (365, 'Large Lecture Room', 'LLR', 231379);
insert into SOLVER_GROUP (uniqueid, name, abbv, session_id)
values (366, 'Instructional Planning', 'Instr Plan', 231379);
commit;
prompt 4 records loaded
prompt Loading SOLUTION...
insert into SOLUTION (uniqueid, created, valid, commited, commit_date, note, creator, owner_id, last_modified_time)
values (806, to_date('07-05-2008 08:39:38', 'dd-mm-yyyy hh24:mi:ss'), 1, 1, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'), null, 'IFS Timetable Solver v1.1 build-1, Unknown', 345, null);
insert into SOLUTION (uniqueid, created, valid, commited, commit_date, note, creator, owner_id, last_modified_time)
values (807, to_date('07-05-2008 08:39:53', 'dd-mm-yyyy hh24:mi:ss'), 1, 1, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'), null, 'IFS Timetable Solver v1.1 build-1, Unknown', 344, null);
insert into SOLUTION (uniqueid, created, valid, commited, commit_date, note, creator, owner_id, last_modified_time)
values (826, to_date('22-09-2010 16:09:22', 'dd-mm-yyyy hh24:mi:ss'), 1, 1, to_date('22-09-2010 16:09:27', 'dd-mm-yyyy hh24:mi:ss'), null, 'IFS Timetable Solver v1.2 build-1, Unknown', 366, null);
insert into SOLUTION (uniqueid, created, valid, commited, commit_date, note, creator, owner_id, last_modified_time)
values (827, to_date('22-09-2010 16:09:23', 'dd-mm-yyyy hh24:mi:ss'), 1, 1, to_date('22-09-2010 16:09:29', 'dd-mm-yyyy hh24:mi:ss'), null, 'IFS Timetable Solver v1.2 build-1, Unknown', 365, null);
commit;
prompt 4 records loaded
prompt Loading TIME_PATTERN...
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1368, '5 x 50', 50, 12, 5, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1456, '5 x 75', 75, 18, 5, 1, 0, 15, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1480, '5 x 100', 100, 24, 5, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1481, '5 x 150', 150, 36, 5, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1450, '5 x 180', 180, 42, 5, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1457, '5 x 200', 200, 48, 5, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1369, '4 x 50', 50, 12, 4, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1370, '4 x 100', 100, 24, 4, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1436, '3 x 20', 20, 6, 3, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1435, '3 x 30', 30, 6, 3, 1, 0, 0, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1371, '3 x 50', 50, 12, 3, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1474, '3 x 90', 90, 21, 3, 1, 0, 15, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1372, '3 x 100', 100, 24, 3, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1460, '3 x 150', 150, 36, 3, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1482, '3 x 200', 200, 48, 3, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1430, '2 x 15', 15, 3, 2, 1, 0, 0, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1429, '2 x 15 Quarter', 15, 3, 2, 1, 0, 0, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1468, '2 x 20', 20, 6, 2, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1431, '2 x 30', 30, 6, 2, 1, 0, 0, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1373, '2 x 50', 50, 12, 2, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1374, '2 x 75', 75, 18, 2, 1, 0, 15, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1486, '2 x 90', 90, 21, 2, 1, 0, 15, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1375, '2 x 100', 100, 24, 2, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1399, '2 x 120', 120, 30, 2, 1, 0, 15, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1400, '2 x 150', 150, 36, 2, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1433, '2 x 200', 200, 48, 2, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1434, '2 x 300', 300, 72, 2, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1376, '1 x 20', 20, 6, 1, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1389, '1 x 30', 30, 6, 1, 1, 0, 0, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1377, '1 x 50', 50, 12, 1, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1489, '1 x 75', 75, 18, 1, 1, 0, 15, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1412, '1 x 80', 80, 18, 1, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1485, '1 x 90', 90, 21, 1, 1, 0, 15, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1378, '1 x 100', 100, 24, 1, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1418, '1 x 120', 120, 30, 1, 1, 0, 15, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1379, '1 x 150', 150, 36, 1, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1420, '1 x 180', 180, 42, 1, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1380, '1 x 200', 200, 48, 1, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1421, '1 x 250', 250, 60, 1, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1405, '1 x 300', 300, 72, 1, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1406, '1 x 350', 350, 84, 1, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1427, '1 x 400', 400, 96, 1, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1428, '1 x 450', 450, 108, 1, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1454, '1 x 600', 600, 144, 1, 1, 0, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1459, '3 x 50 Evening', 50, 12, 3, 1, 1, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1449, '2 x 50 Evening', 50, 12, 2, 1, 1, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1381, '2 x 75 Evening', 75, 18, 2, 1, 1, 15, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1382, '2 x 100 Evening', 100, 24, 2, 1, 1, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1410, '1 x 20 Evening', 20, 6, 1, 1, 1, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1409, '1 x 30 Evening', 30, 6, 1, 1, 1, 0, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1383, '1 x 50 Evening', 50, 12, 1, 1, 1, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1402, '1 x 75 Evening', 75, 18, 1, 1, 1, 15, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1415, '1 x 80 Evening', 80, 18, 1, 1, 1, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1384, '1 x 100 Evening', 100, 24, 1, 1, 1, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1385, '1 x 150 Evening', 150, 36, 1, 1, 1, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1444, '1 x 180 Evening', 180, 42, 1, 1, 1, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1470, '1 x 200 Evening', 200, 48, 1, 1, 1, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1422, '1 x 250 Evening', 250, 60, 1, 1, 1, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1447, '1 x 350 Evening', 350, 84, 1, 1, 1, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1438, '3 x 50 TThS', 50, 12, 3, 1, 2, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1477, '3 x 100 TThS', 100, 24, 3, 1, 2, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1455, '2 x 100 WS', 100, 24, 2, 1, 2, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1386, '1 x 50 Weekend', 50, 12, 1, 1, 2, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1416, '1 x 80 Weekend', 80, 18, 1, 1, 2, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1387, '1 x 100 Weekend', 100, 24, 1, 1, 2, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1419, '1 x 120 Weekend', 120, 30, 1, 1, 2, 15, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1388, '1 x 150 Weekend', 150, 36, 1, 1, 2, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1476, '1 x 250 Weekend', 250, 60, 1, 1, 2, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1445, '1 x 300 Weekend', 300, 72, 1, 1, 2, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1467, '1 x 400 Weekend', 400, 96, 1, 1, 2, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1390, '3 x 50 Early AM', 50, 12, 3, 1, 3, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1411, '1 x 50 Early AM', 50, 12, 1, 1, 3, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1441, '1 x 100 Early AM', 100, 24, 1, 1, 3, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1424, '1 x 250 Early AM', 250, 60, 1, 1, 3, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1407, 'Exact Time', 0, 6, 1, 1, 5, 10, 223206);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1529, '5 x 50', 50, 12, 5, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1530, '5 x 75', 75, 18, 5, 1, 0, 15, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1531, '5 x 100', 100, 24, 5, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1532, '5 x 150', 150, 36, 5, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1533, '5 x 180', 180, 42, 5, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1534, '5 x 200', 200, 48, 5, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1535, '4 x 50', 50, 12, 4, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1536, '4 x 100', 100, 24, 4, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1537, '3 x 20', 20, 6, 3, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1538, '3 x 30', 30, 6, 3, 1, 0, 0, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1539, '3 x 50', 50, 12, 3, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1540, '3 x 90', 90, 21, 3, 1, 0, 15, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1541, '3 x 100', 100, 24, 3, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1542, '3 x 150', 150, 36, 3, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1543, '3 x 200', 200, 48, 3, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1544, '2 x 15', 15, 3, 2, 1, 0, 0, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1545, '2 x 15 Quarter', 15, 3, 2, 1, 0, 0, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1546, '2 x 20', 20, 6, 2, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1547, '2 x 30', 30, 6, 2, 1, 0, 0, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1548, '2 x 50', 50, 12, 2, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1549, '2 x 75', 75, 18, 2, 1, 0, 15, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1550, '2 x 90', 90, 21, 2, 1, 0, 15, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1551, '2 x 100', 100, 24, 2, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1552, '2 x 120', 120, 30, 2, 1, 0, 15, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1553, '2 x 150', 150, 36, 2, 1, 0, 10, 231379);
commit;
prompt 100 records committed...
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1554, '2 x 200', 200, 48, 2, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1555, '2 x 300', 300, 72, 2, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1556, '1 x 20', 20, 6, 1, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1557, '1 x 30', 30, 6, 1, 1, 0, 0, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1558, '1 x 50', 50, 12, 1, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1559, '1 x 75', 75, 18, 1, 1, 0, 15, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1560, '1 x 80', 80, 18, 1, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1561, '1 x 90', 90, 21, 1, 1, 0, 15, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1562, '1 x 100', 100, 24, 1, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1563, '1 x 120', 120, 30, 1, 1, 0, 15, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1564, '1 x 150', 150, 36, 1, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1565, '1 x 180', 180, 42, 1, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1566, '1 x 200', 200, 48, 1, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1567, '1 x 250', 250, 60, 1, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1568, '1 x 300', 300, 72, 1, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1569, '1 x 350', 350, 84, 1, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1570, '1 x 400', 400, 96, 1, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1571, '1 x 450', 450, 108, 1, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1572, '1 x 600', 600, 144, 1, 1, 0, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1573, '3 x 50 Evening', 50, 12, 3, 1, 1, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1574, '2 x 50 Evening', 50, 12, 2, 1, 1, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1575, '2 x 75 Evening', 75, 18, 2, 1, 1, 15, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1576, '2 x 100 Evening', 100, 24, 2, 1, 1, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1577, '1 x 20 Evening', 20, 6, 1, 1, 1, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1578, '1 x 30 Evening', 30, 6, 1, 1, 1, 0, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1579, '1 x 50 Evening', 50, 12, 1, 1, 1, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1580, '1 x 75 Evening', 75, 18, 1, 1, 1, 15, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1581, '1 x 80 Evening', 80, 18, 1, 1, 1, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1582, '1 x 100 Evening', 100, 24, 1, 1, 1, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1583, '1 x 150 Evening', 150, 36, 1, 1, 1, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1584, '1 x 180 Evening', 180, 42, 1, 1, 1, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1585, '1 x 200 Evening', 200, 48, 1, 1, 1, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1586, '1 x 250 Evening', 250, 60, 1, 1, 1, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1587, '1 x 350 Evening', 350, 84, 1, 1, 1, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1588, '3 x 50 TThS', 50, 12, 3, 1, 2, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1589, '3 x 100 TThS', 100, 24, 3, 1, 2, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1590, '2 x 100 WS', 100, 24, 2, 1, 2, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1591, '1 x 50 Weekend', 50, 12, 1, 1, 2, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1592, '1 x 80 Weekend', 80, 18, 1, 1, 2, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1593, '1 x 100 Weekend', 100, 24, 1, 1, 2, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1594, '1 x 120 Weekend', 120, 30, 1, 1, 2, 15, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1595, '1 x 150 Weekend', 150, 36, 1, 1, 2, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1596, '1 x 250 Weekend', 250, 60, 1, 1, 2, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1597, '1 x 300 Weekend', 300, 72, 1, 1, 2, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1598, '1 x 400 Weekend', 400, 96, 1, 1, 2, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1599, '3 x 50 Early AM', 50, 12, 3, 1, 3, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1600, '1 x 50 Early AM', 50, 12, 1, 1, 3, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1601, '1 x 100 Early AM', 100, 24, 1, 1, 3, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1602, '1 x 250 Early AM', 250, 60, 1, 1, 3, 10, 231379);
insert into TIME_PATTERN (uniqueid, name, mins_pmt, slots_pmt, nr_mtgs, visible, type, break_time, session_id)
values (1603, 'Exact Time', 0, 6, 1, 1, 5, 10, 231379);
commit;
prompt 150 records loaded
prompt Loading ASSIGNMENT...
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142297, 84, 114, 1371, 807, 223884, 'ALG 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142298, 124, 186, 1480, 806, 223249, 'BAND 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142299, 40, 150, 1373, 806, 223240, 'BIOL 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142300, 40, 126, 1373, 806, 223899, 'BIOL 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142301, 40, 114, 1373, 806, 223900, 'BIOL 101 Lec 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142302, 32, 186, 1377, 807, 223902, 'BIOL 101 Rec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142303, 8, 174, 1377, 807, 223903, 'BIOL 101 Rec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142304, 16, 90, 1377, 807, 223904, 'BIOL 101 Rec 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142305, 4, 102, 1377, 807, 223905, 'BIOL 101 Rec 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142306, 32, 138, 1377, 807, 223906, 'BIOL 101 Rec 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142307, 32, 150, 1377, 807, 223907, 'BIOL 101 Rec 6', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142308, 64, 102, 1377, 807, 223908, 'BIOL 101 Rec 7', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142309, 8, 138, 1377, 807, 223909, 'BIOL 101 Rec 8', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142310, 16, 114, 1377, 807, 223910, 'BIOL 101 Rec 9', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142311, 16, 162, 1377, 807, 223976, 'BIOL 101 Rec 10', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142312, 16, 126, 1377, 807, 223977, 'BIOL 101 Rec 11', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142313, 4, 162, 1378, 807, 223914, 'BIOL 101 Lab 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142314, 16, 162, 1378, 807, 223915, 'BIOL 101 Lab 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142315, 16, 114, 1378, 807, 223916, 'BIOL 101 Lab 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142316, 16, 90, 1378, 807, 223917, 'BIOL 101 Lab 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142317, 4, 186, 1378, 807, 223918, 'BIOL 101 Lab 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142318, 8, 162, 1378, 807, 223919, 'BIOL 101 Lab 6', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142319, 8, 138, 1378, 807, 223920, 'BIOL 101 Lab 7', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142320, 8, 186, 1378, 807, 223921, 'BIOL 101 Lab 8', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142321, 4, 114, 1378, 807, 223922, 'BIOL 101 Lab 9', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142322, 8, 90, 1378, 807, 223978, 'BIOL 101 Lab 10', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142323, 16, 186, 1378, 807, 223979, 'BIOL 101 Lab 11', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142324, 32, 138, 1377, 806, 223926, 'BIOL 101 Pso 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142325, 8, 138, 1377, 806, 223927, 'BIOL 101 Pso 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142326, 16, 138, 1377, 806, 223973, 'BIOL 101 Pso 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142327, 80, 102, 1373, 807, 223245, 'C S 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142328, 68, 126, 1373, 807, 223947, 'C S 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142329, 8, 186, 1378, 807, 223949, 'C S 101 Lab 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142330, 4, 162, 1378, 807, 223950, 'C S 101 Lab 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142331, 8, 162, 1378, 807, 223951, 'C S 101 Lab 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142332, 4, 114, 1378, 807, 223970, 'C S 101 Lab 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142333, 84, 150, 1371, 806, 223869, 'CALC 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142334, 84, 174, 1371, 806, 223956, 'CALC 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142335, 84, 90, 1371, 806, 223957, 'CALC 101 Lec 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142336, 8, 126, 1377, 807, 223870, 'CALC 101 Rec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142337, 32, 162, 1377, 807, 223958, 'CALC 101 Rec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142338, 8, 114, 1377, 807, 223959, 'CALC 101 Rec 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142339, 8, 138, 1377, 807, 223960, 'CALC 101 Rec 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142340, 4, 102, 1377, 807, 223961, 'CALC 101 Rec 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142341, 32, 150, 1377, 807, 223962, 'CALC 101 Rec 6', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142342, 16, 150, 1377, 807, 223963, 'CALC 101 Rec 7', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142343, 4, 150, 1377, 807, 223964, 'CALC 101 Rec 8', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142344, 32, 102, 1377, 807, 223965, 'CALC 101 Rec 9', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142345, 32, 138, 1377, 807, 223966, 'CALC 101 Rec 10', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142346, 32, 126, 1377, 807, 223967, 'CALC 101 Rec 11', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142347, 8, 150, 1377, 807, 223968, 'CALC 101 Rec 12', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142348, 20, 126, 1373, 806, 223256, 'CHM 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142349, 68, 138, 1373, 806, 223257, 'CHM 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142350, 80, 114, 1373, 806, 223258, 'CHM 101 Lec 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142351, 32, 138, 1379, 807, 223259, 'CHM 101 Lab 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142352, 8, 138, 1379, 807, 223260, 'CHM 101 Lab 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142353, 4, 138, 1379, 807, 223261, 'CHM 101 Lab 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142354, 32, 180, 1379, 807, 223263, 'CHM 101 Lab 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142355, 4, 90, 1379, 807, 223264, 'CHM 101 Lab 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142356, 32, 90, 1379, 807, 223265, 'CHM 101 Lab 6', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142357, 4, 180, 1379, 807, 223267, 'CHM 101 Lab 7', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142358, 16, 90, 1379, 807, 223268, 'CHM 101 Lab 8', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142359, 16, 180, 1379, 807, 223269, 'CHM 101 Lab 9', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142360, 8, 180, 1379, 807, 223817, 'CHM 101 Lab 10', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142361, 8, 90, 1379, 807, 223818, 'CHM 101 Lab 11', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142362, 16, 138, 1379, 807, 223819, 'CHM 101 Lab 12', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142363, 8, 186, 1377, 807, 223824, 'CHM 101 Rec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142364, 16, 186, 1377, 807, 223825, 'CHM 101 Rec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142365, 32, 198, 1377, 807, 223826, 'CHM 101 Rec 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142366, 32, 90, 1377, 807, 223827, 'CHM 101 Rec 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142367, 32, 126, 1377, 807, 223828, 'CHM 101 Rec 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142368, 16, 102, 1377, 807, 223829, 'CHM 101 Rec 6', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142369, 8, 162, 1377, 807, 223830, 'CHM 101 Rec 7', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142370, 4, 162, 1377, 807, 223831, 'CHM 101 Rec 8', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142371, 8, 102, 1377, 807, 223832, 'CHM 101 Rec 9', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142372, 64, 150, 1377, 807, 223833, 'CHM 101 Rec 10', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142373, 32, 114, 1377, 807, 223834, 'CHM 101 Rec 11', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142374, 64, 186, 1377, 807, 223835, 'CHM 101 Rec 12', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142375, 40, 162, 1374, 807, 223297, 'COM 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142376, 40, 198, 1374, 807, 223298, 'COM 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142377, 40, 90, 1374, 807, 223299, 'COM 101 Lec 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142378, 40, 180, 1374, 807, 223300, 'COM 101 Lec 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142379, 40, 162, 1374, 807, 223301, 'COM 101 Lec 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142380, 40, 108, 1374, 807, 223302, 'COM 101 Lec 6', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142381, 40, 198, 1374, 807, 223303, 'COM 101 Lec 7', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142382, 40, 144, 1374, 807, 223304, 'COM 101 Lec 8', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142383, 40, 108, 1374, 807, 223305, 'COM 101 Lec 9', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142384, 40, 90, 1374, 806, 223291, 'ECON 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142385, 84, 198, 1371, 807, 223310, 'ENGL 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142386, 84, 90, 1371, 807, 223311, 'ENGL 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142387, 84, 186, 1371, 807, 223312, 'ENGL 101 Lec 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142388, 84, 150, 1371, 807, 223313, 'ENGL 101 Lec 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142389, 84, 102, 1371, 807, 223314, 'ENGL 101 Lec 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142390, 84, 126, 1371, 807, 223315, 'ENGL 101 Lec 6', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142391, 84, 114, 1371, 807, 223316, 'ENGL 101 Lec 7', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142392, 84, 138, 1371, 807, 223317, 'ENGL 101 Lec 8', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142393, 84, 174, 1371, 807, 223318, 'ENGL 101 Lec 9', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142394, 84, 162, 1371, 807, 223319, 'ENGL 101 Lec 10', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142395, 16, 102, 1377, 807, 223851, 'ENGL 101 Lab 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142396, 8, 114, 1377, 807, 223852, 'ENGL 101 Lab 2', null);
commit;
prompt 100 records committed...
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142397, 4, 150, 1377, 807, 223853, 'ENGL 101 Lab 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142398, 4, 138, 1377, 807, 223854, 'ENGL 101 Lab 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142399, 32, 174, 1377, 807, 223855, 'ENGL 101 Lab 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142400, 16, 114, 1377, 807, 223856, 'ENGL 101 Lab 6', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142401, 16, 162, 1377, 807, 223857, 'ENGL 101 Lab 7', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142402, 8, 150, 1377, 807, 223858, 'ENGL 101 Lab 8', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142403, 16, 126, 1377, 807, 223859, 'ENGL 101 Lab 9', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142404, 32, 90, 1377, 807, 223860, 'ENGL 101 Lab 10', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142405, 40, 174, 1373, 807, 223996, 'ENGR 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142406, 8, 90, 1378, 807, 223998, 'ENGR 101 Lab 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142407, 64, 114, 1378, 807, 223999, 'ENGR 101 Lab 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142408, 32, 138, 1378, 807, 224000, 'ENGR 101 Lab 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142409, 84, 138, 1371, 807, 223324, 'GER 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142410, 84, 186, 1371, 807, 223325, 'GER 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142411, 64, 102, 1377, 807, 224005, 'GER 101 Lab 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142412, 16, 174, 1377, 807, 224006, 'GER 101 Lab 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142413, 64, 90, 1377, 807, 224007, 'GER 101 Lab 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142414, 16, 90, 1377, 807, 224008, 'GER 101 Lab 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142415, 40, 90, 1374, 807, 223330, 'HIST 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142416, 84, 126, 1371, 807, 223331, 'HIST 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142417, 84, 198, 1371, 807, 224017, 'LING 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142418, 20, 102, 1373, 806, 224057, 'MBIO 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142419, 64, 186, 1378, 807, 224059, 'MBIO 101 Lab 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142420, 64, 162, 1378, 807, 224060, 'MBIO 101 Lab 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142421, 64, 114, 1378, 807, 224061, 'MBIO 101 Lab 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142422, 64, 102, 1377, 806, 224022, 'PHAR 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142423, 40, 126, 1374, 807, 223344, 'PHIL 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142424, 40, 162, 1373, 807, 223350, 'PHYS 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142425, 68, 114, 1373, 807, 223351, 'PHYS 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142426, 64, 162, 1377, 807, 224032, 'PHYS 101 Rec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142427, 4, 186, 1377, 807, 224033, 'PHYS 101 Rec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142428, 8, 90, 1377, 807, 224034, 'PHYS 101 Rec 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142429, 8, 198, 1377, 807, 224035, 'PHYS 101 Rec 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142430, 32, 174, 1377, 807, 224036, 'PHYS 101 Rec 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142431, 4, 90, 1378, 807, 224038, 'PHYS 101 Lab 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142432, 32, 114, 1378, 807, 224039, 'PHYS 101 Lab 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142433, 64, 138, 1378, 807, 224040, 'PHYS 101 Lab 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142434, 64, 162, 1378, 807, 224041, 'PHYS 101 Lab 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142435, 16, 138, 1378, 807, 224042, 'PHYS 101 Lab 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142436, 84, 150, 1371, 807, 223356, 'POL 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142437, 84, 162, 1371, 807, 224028, 'POL 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142438, 84, 162, 1371, 806, 223363, 'PSY 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142439, 84, 138, 1371, 807, 223373, 'SOC 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142440, 84, 90, 1371, 807, 224050, 'SOC 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142441, 40, 180, 1374, 807, 223378, 'SPAN 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142442, 84, 174, 1371, 807, 223379, 'SPAN 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142443, 32, 162, 1377, 807, 223800, 'SPAN 101 Lab 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142444, 32, 102, 1377, 807, 223801, 'SPAN 101 Lab 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142445, 32, 186, 1377, 807, 223802, 'SPAN 101 Lab 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142446, 8, 138, 1377, 807, 223803, 'SPAN 101 Lab 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142457, 84, 114, 1539, 826, 231391, 'ALG 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142458, 124, 186, 1531, 827, 231393, 'BAND 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142459, 68, 174, 1548, 827, 231395, 'BIOL 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142460, 40, 90, 1548, 827, 231396, 'BIOL 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142461, 68, 114, 1548, 827, 231397, 'BIOL 101 Lec 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142462, 64, 138, 1558, 826, 231411, 'BIOL 101 Rec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142463, 4, 90, 1558, 826, 231412, 'BIOL 101 Rec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142464, 8, 162, 1558, 826, 231413, 'BIOL 101 Rec 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142465, 64, 162, 1558, 826, 231414, 'BIOL 101 Rec 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142466, 16, 138, 1558, 826, 231415, 'BIOL 101 Rec 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142467, 4, 114, 1558, 826, 231416, 'BIOL 101 Rec 6', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142468, 16, 162, 1558, 826, 231417, 'BIOL 101 Rec 7', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142469, 16, 186, 1558, 826, 231418, 'BIOL 101 Rec 8', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142470, 16, 90, 1558, 826, 231419, 'BIOL 101 Rec 9', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142471, 32, 126, 1558, 826, 231420, 'BIOL 101 Rec 10', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142472, 16, 114, 1558, 826, 231421, 'BIOL 101 Rec 11', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142473, 16, 138, 1562, 826, 231399, 'BIOL 101 Lab 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142474, 16, 186, 1562, 826, 231400, 'BIOL 101 Lab 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142475, 16, 114, 1562, 826, 231401, 'BIOL 101 Lab 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142476, 8, 138, 1562, 826, 231402, 'BIOL 101 Lab 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142477, 4, 186, 1562, 826, 231403, 'BIOL 101 Lab 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142478, 4, 162, 1562, 826, 231404, 'BIOL 101 Lab 6', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142479, 8, 90, 1562, 826, 231405, 'BIOL 101 Lab 7', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142480, 8, 114, 1562, 826, 231406, 'BIOL 101 Lab 8', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142481, 16, 90, 1562, 826, 231407, 'BIOL 101 Lab 9', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142482, 4, 138, 1562, 826, 231408, 'BIOL 101 Lab 10', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142483, 16, 162, 1562, 826, 231409, 'BIOL 101 Lab 11', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142484, 16, 174, 1558, 827, 231423, 'BIOL 101 Pso 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142485, 16, 114, 1558, 827, 231424, 'BIOL 101 Pso 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142486, 8, 102, 1558, 827, 231425, 'BIOL 101 Pso 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142487, 68, 162, 1548, 826, 231434, 'C S 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142488, 80, 150, 1548, 826, 231435, 'C S 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142489, 32, 138, 1562, 826, 231429, 'C S 101 Lab 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142490, 32, 90, 1562, 826, 231430, 'C S 101 Lab 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142491, 16, 114, 1562, 826, 231431, 'C S 101 Lab 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142492, 64, 162, 1562, 826, 231432, 'C S 101 Lab 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142493, 84, 90, 1539, 827, 231437, 'CALC 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142494, 84, 126, 1539, 827, 231438, 'CALC 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142495, 84, 102, 1539, 827, 231439, 'CALC 101 Lec 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142496, 4, 126, 1558, 826, 231441, 'CALC 101 Rec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142497, 64, 126, 1558, 826, 231445, 'CALC 101 Rec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142498, 32, 186, 1558, 826, 231449, 'CALC 101 Rec 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142499, 4, 174, 1558, 826, 231451, 'CALC 101 Rec 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142500, 32, 174, 1558, 826, 231443, 'CALC 101 Rec 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142501, 32, 126, 1558, 826, 231446, 'CALC 101 Rec 6', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142502, 16, 174, 1558, 826, 231448, 'CALC 101 Rec 7', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142503, 8, 174, 1558, 826, 231452, 'CALC 101 Rec 8', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142504, 4, 162, 1558, 826, 231442, 'CALC 101 Rec 9', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142505, 32, 150, 1558, 826, 231444, 'CALC 101 Rec 10', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142506, 8, 150, 1558, 826, 231447, 'CALC 101 Rec 11', null);
commit;
prompt 200 records committed...
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142507, 32, 138, 1558, 826, 231450, 'CALC 101 Rec 12', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142508, 80, 150, 1548, 827, 231456, 'CHM 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142509, 40, 114, 1548, 827, 231457, 'CHM 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142510, 40, 138, 1548, 827, 231458, 'CHM 101 Lec 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142511, 8, 138, 1564, 826, 231461, 'CHM 101 Lab 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142512, 4, 180, 1564, 826, 231466, 'CHM 101 Lab 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142513, 8, 90, 1564, 826, 231467, 'CHM 101 Lab 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142514, 32, 180, 1564, 826, 231468, 'CHM 101 Lab 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142515, 4, 90, 1564, 826, 231460, 'CHM 101 Lab 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142516, 16, 90, 1564, 826, 231462, 'CHM 101 Lab 6', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142517, 16, 180, 1564, 826, 231463, 'CHM 101 Lab 7', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142518, 32, 138, 1564, 826, 231465, 'CHM 101 Lab 8', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142519, 8, 180, 1564, 826, 231464, 'CHM 101 Lab 9', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142520, 32, 90, 1564, 826, 231469, 'CHM 101 Lab 10', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142521, 16, 138, 1564, 826, 231470, 'CHM 101 Lab 11', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142522, 4, 138, 1564, 826, 231471, 'CHM 101 Lab 12', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142523, 32, 90, 1558, 826, 231480, 'CHM 101 Rec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142524, 32, 102, 1558, 826, 231477, 'CHM 101 Rec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142525, 4, 186, 1558, 826, 231484, 'CHM 101 Rec 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142526, 64, 174, 1558, 826, 231479, 'CHM 101 Rec 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142527, 4, 138, 1558, 826, 231483, 'CHM 101 Rec 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142528, 8, 138, 1558, 826, 231473, 'CHM 101 Rec 6', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142529, 16, 126, 1558, 826, 231474, 'CHM 101 Rec 7', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142530, 4, 150, 1558, 826, 231478, 'CHM 101 Rec 8', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142531, 32, 162, 1558, 826, 231476, 'CHM 101 Rec 9', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142532, 8, 126, 1558, 826, 231475, 'CHM 101 Rec 10', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142533, 64, 102, 1558, 826, 231481, 'CHM 101 Rec 11', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142534, 16, 162, 1558, 826, 231482, 'CHM 101 Rec 12', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142535, 40, 90, 1549, 826, 231486, 'COM 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142536, 40, 198, 1549, 826, 231487, 'COM 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142537, 40, 90, 1549, 826, 231488, 'COM 101 Lec 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142538, 40, 162, 1549, 826, 231489, 'COM 101 Lec 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142539, 40, 198, 1549, 826, 231490, 'COM 101 Lec 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142540, 40, 108, 1549, 826, 231491, 'COM 101 Lec 6', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142541, 40, 180, 1549, 826, 231492, 'COM 101 Lec 7', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142542, 40, 126, 1549, 826, 231493, 'COM 101 Lec 8', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142543, 40, 108, 1549, 826, 231494, 'COM 101 Lec 9', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142544, 84, 138, 1539, 827, 231496, 'ECON 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142545, 84, 198, 1539, 826, 231498, 'ENGL 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142546, 84, 186, 1539, 826, 231499, 'ENGL 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142547, 84, 126, 1539, 826, 231500, 'ENGL 101 Lec 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142548, 84, 174, 1539, 826, 231501, 'ENGL 101 Lec 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142549, 84, 138, 1539, 826, 231502, 'ENGL 101 Lec 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142550, 84, 162, 1539, 826, 231503, 'ENGL 101 Lec 6', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142551, 84, 114, 1539, 826, 231504, 'ENGL 101 Lec 7', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142552, 84, 102, 1539, 826, 231505, 'ENGL 101 Lec 8', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142553, 84, 90, 1539, 826, 231506, 'ENGL 101 Lec 9', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142554, 84, 150, 1539, 826, 231507, 'ENGL 101 Lec 10', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142555, 8, 174, 1558, 826, 231511, 'ENGL 101 Lab 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142556, 8, 198, 1558, 826, 231515, 'ENGL 101 Lab 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142557, 8, 138, 1558, 826, 231518, 'ENGL 101 Lab 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142558, 64, 138, 1558, 826, 231516, 'ENGL 101 Lab 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142559, 4, 198, 1558, 826, 231512, 'ENGL 101 Lab 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142560, 64, 186, 1558, 826, 231513, 'ENGL 101 Lab 6', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142561, 32, 114, 1558, 826, 231509, 'ENGL 101 Lab 7', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142562, 8, 150, 1558, 826, 231510, 'ENGL 101 Lab 8', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142563, 32, 198, 1558, 826, 231514, 'ENGL 101 Lab 9', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142564, 32, 174, 1558, 826, 231517, 'ENGL 101 Lab 10', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142565, 40, 174, 1548, 826, 231524, 'ENGR 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142566, 4, 114, 1562, 826, 231520, 'ENGR 101 Lab 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142567, 64, 114, 1562, 826, 231521, 'ENGR 101 Lab 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142568, 16, 90, 1562, 826, 231522, 'ENGR 101 Lab 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142569, 84, 90, 1539, 826, 231526, 'GER 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142570, 84, 150, 1539, 826, 231527, 'GER 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142571, 4, 186, 1558, 826, 231531, 'GER 101 Lab 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142572, 4, 102, 1558, 826, 231532, 'GER 101 Lab 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142573, 32, 126, 1558, 826, 231529, 'GER 101 Lab 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142574, 32, 162, 1558, 826, 231530, 'GER 101 Lab 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142575, 84, 186, 1539, 826, 231534, 'HIST 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142576, 84, 174, 1539, 826, 231535, 'HIST 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142577, 84, 198, 1539, 826, 231537, 'LING 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142578, 40, 126, 1548, 827, 231539, 'MBIO 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142579, 64, 138, 1562, 826, 231541, 'MBIO 101 Lab 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142580, 64, 186, 1562, 826, 231542, 'MBIO 101 Lab 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142581, 64, 162, 1562, 826, 231543, 'MBIO 101 Lab 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142582, 32, 102, 1558, 827, 231545, 'PHAR 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142583, 84, 126, 1539, 826, 231547, 'PHIL 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142584, 40, 150, 1548, 826, 231549, 'PHYS 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142585, 40, 162, 1548, 826, 231550, 'PHYS 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142586, 8, 126, 1558, 826, 231553, 'PHYS 101 Rec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142587, 8, 186, 1558, 826, 231556, 'PHYS 101 Rec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142588, 32, 114, 1558, 826, 231552, 'PHYS 101 Rec 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142589, 64, 90, 1558, 826, 231554, 'PHYS 101 Rec 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142590, 64, 114, 1558, 826, 231555, 'PHYS 101 Rec 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142591, 4, 162, 1562, 826, 231560, 'PHYS 101 Lab 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142592, 16, 162, 1562, 826, 231562, 'PHYS 101 Lab 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142593, 8, 90, 1562, 826, 231559, 'PHYS 101 Lab 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142594, 4, 138, 1562, 826, 231561, 'PHYS 101 Lab 4', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142595, 8, 114, 1562, 826, 231558, 'PHYS 101 Lab 5', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142596, 40, 162, 1549, 826, 231564, 'POL 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142597, 40, 144, 1549, 826, 231565, 'POL 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142598, 84, 162, 1539, 827, 231567, 'PSY 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142599, 84, 102, 1539, 826, 231569, 'SOC 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142600, 84, 198, 1539, 826, 231570, 'SOC 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142601, 40, 180, 1549, 826, 231572, 'SPAN 101 Lec 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142602, 40, 198, 1549, 826, 231573, 'SPAN 101 Lec 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142603, 16, 138, 1558, 826, 231577, 'SPAN 101 Lab 1', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142604, 8, 162, 1558, 826, 231578, 'SPAN 101 Lab 2', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142605, 64, 102, 1558, 826, 231575, 'SPAN 101 Lab 3', null);
insert into ASSIGNMENT (uniqueid, days, slot, time_pattern_id, solution_id, class_id, class_name, last_modified_time)
values (142606, 16, 186, 1558, 826, 231576, 'SPAN 101 Lab 4', null);
commit;
prompt 300 records loaded
prompt Loading POSITION_TYPE...
insert into POSITION_TYPE (uniqueid, reference, label, sort_order)
values (18, 'ADMIN_STAFF', 'Administrative/Professional Staff', 1300);
insert into POSITION_TYPE (uniqueid, reference, label, sort_order)
values (19, 'UNDRGRD_TEACH_ASST', 'Undergrad Teaching Assistant', 1400);
insert into POSITION_TYPE (uniqueid, reference, label, sort_order)
values (1, 'PROF', 'Professor', 100);
insert into POSITION_TYPE (uniqueid, reference, label, sort_order)
values (2, 'ASSOC_PROF', 'Associate Professor', 200);
insert into POSITION_TYPE (uniqueid, reference, label, sort_order)
values (3, 'ASST_PROF', 'Assistant Professor', 300);
insert into POSITION_TYPE (uniqueid, reference, label, sort_order)
values (4, 'INSTRUCTOR', 'Instructor', 800);
insert into POSITION_TYPE (uniqueid, reference, label, sort_order)
values (5, 'CLIN_PROF', 'Clinical / Professional', 500);
insert into POSITION_TYPE (uniqueid, reference, label, sort_order)
values (6, 'CONT_LEC', 'Continuing Lecturer', 600);
insert into POSITION_TYPE (uniqueid, reference, label, sort_order)
values (7, 'LTD_LEC', 'Limited-Term Lecturer', 700);
insert into POSITION_TYPE (uniqueid, reference, label, sort_order)
values (8, 'VISIT_FAC', 'Visiting Faculty', 400);
insert into POSITION_TYPE (uniqueid, reference, label, sort_order)
values (9, 'POST_DOC', 'Post Doctoral', 1500);
insert into POSITION_TYPE (uniqueid, reference, label, sort_order)
values (10, 'ADJUNCT_FAC', 'Adjunct Faculty', 1000);
insert into POSITION_TYPE (uniqueid, reference, label, sort_order)
values (11, 'GRAD_TEACH_ASST', 'Graduate Teaching Assistant', 1200);
insert into POSITION_TYPE (uniqueid, reference, label, sort_order)
values (12, 'GRAD_LEC', 'Graduate Lecturer', 1100);
insert into POSITION_TYPE (uniqueid, reference, label, sort_order)
values (13, 'CLERICAL_STAFF', 'Clerical Staff', 1600);
insert into POSITION_TYPE (uniqueid, reference, label, sort_order)
values (14, 'SERVICE_STAFF', 'Service Staff', 1700);
insert into POSITION_TYPE (uniqueid, reference, label, sort_order)
values (15, 'FELLOWSHIP', 'Fellowship', 1800);
insert into POSITION_TYPE (uniqueid, reference, label, sort_order)
values (16, 'EMERITUS', 'Emeritus Faculty', 900);
insert into POSITION_TYPE (uniqueid, reference, label, sort_order)
values (17, 'OTHER', 'Other', 2000);
commit;
prompt 19 records loaded
prompt Loading DEPARTMENT...
insert into DEPARTMENT (uniqueid, session_id, abbreviation, name, dept_code, external_uid, rs_color, external_manager, external_mgr_label, external_mgr_abbv, solver_group_id, status_type, dist_priority, allow_req_time, allow_req_room, last_modified_time)
values (226216, 223206, 'Adm', 'Admission Office', '0102', null, 'f032f0', 0, null, null, null, null, 0, 0, 0, null);
insert into DEPARTMENT (uniqueid, session_id, abbreviation, name, dept_code, external_uid, rs_color, external_manager, external_mgr_label, external_mgr_abbv, solver_group_id, status_type, dist_priority, allow_req_time, allow_req_room, last_modified_time)
values (226199, 223206, 'Centr', 'Central Office', '0100', null, '32f0f0', 1, 'Large Lecture Room', 'LLR', 345, 271, -1, 0, 0, null);
insert into DEPARTMENT (uniqueid, session_id, abbreviation, name, dept_code, external_uid, rs_color, external_manager, external_mgr_label, external_mgr_abbv, solver_group_id, status_type, dist_priority, allow_req_time, allow_req_room, last_modified_time)
values (223207, 223206, 'Instr', 'Student Instructional Planning', '0101', 'Woebegon Dept 0101', 'f032f0', 0, null, null, 344, null, 0, 0, 0, null);
insert into DEPARTMENT (uniqueid, session_id, abbreviation, name, dept_code, external_uid, rs_color, external_manager, external_mgr_label, external_mgr_abbv, solver_group_id, status_type, dist_priority, allow_req_time, allow_req_room, last_modified_time)
values (231382, 231379, 'Centr', 'Central Office', '0100', null, 'f032f0', 1, 'Large Lecture Room', 'LLR', 365, null, -1, 0, 0, null);
insert into DEPARTMENT (uniqueid, session_id, abbreviation, name, dept_code, external_uid, rs_color, external_manager, external_mgr_label, external_mgr_abbv, solver_group_id, status_type, dist_priority, allow_req_time, allow_req_room, last_modified_time)
values (231383, 231379, 'Instr', 'Student Instructional Planning', '0101', 'Woebegon Dept 0101', '32f0f0', 0, null, null, 366, null, 0, 0, 0, null);
insert into DEPARTMENT (uniqueid, session_id, abbreviation, name, dept_code, external_uid, rs_color, external_manager, external_mgr_label, external_mgr_abbv, solver_group_id, status_type, dist_priority, allow_req_time, allow_req_room, last_modified_time)
values (231384, 231379, 'Adm', 'Admission Office', '0102', null, null, 0, null, null, null, null, 0, 0, 0, null);
commit;
prompt 6 records loaded
prompt Loading DEPARTMENTAL_INSTRUCTOR...
insert into DEPARTMENTAL_INSTRUCTOR (uniqueid, external_uid, career_acct, lname, fname, mname, pos_code_type, note, department_uniqueid, ignore_too_far, last_modified_time, email)
values (226238, '102', null, 'SMITH', 'JOHN', 'WILLIAM', 1, null, 223207, 0, null, null);
insert into DEPARTMENTAL_INSTRUCTOR (uniqueid, external_uid, career_acct, lname, fname, mname, pos_code_type, note, department_uniqueid, ignore_too_far, last_modified_time, email)
values (226240, '101', null, 'NEWMAN', 'GEORGE', null, 2, null, 223207, 0, null, null);
insert into DEPARTMENTAL_INSTRUCTOR (uniqueid, external_uid, career_acct, lname, fname, mname, pos_code_type, note, department_uniqueid, ignore_too_far, last_modified_time, email)
values (226242, '100', null, 'DOE', 'JOE', null, 6, null, 223207, 0, null, null);
insert into DEPARTMENTAL_INSTRUCTOR (uniqueid, external_uid, career_acct, lname, fname, mname, pos_code_type, note, department_uniqueid, ignore_too_far, last_modified_time, email)
values (226244, null, null, 'STUDENT', 'JOHN', null, 11, null, 223207, 0, null, null);
insert into DEPARTMENTAL_INSTRUCTOR (uniqueid, external_uid, career_acct, lname, fname, mname, pos_code_type, note, department_uniqueid, ignore_too_far, last_modified_time, email)
values (226246, null, null, 'STUDENT', 'STEVEN', null, 19, null, 223207, 0, null, null);
insert into DEPARTMENTAL_INSTRUCTOR (uniqueid, external_uid, career_acct, lname, fname, mname, pos_code_type, note, department_uniqueid, ignore_too_far, last_modified_time, email)
values (231385, '102', null, 'SMITH', 'JOHN', 'WILLIAM', 1, null, 231383, 0, null, null);
insert into DEPARTMENTAL_INSTRUCTOR (uniqueid, external_uid, career_acct, lname, fname, mname, pos_code_type, note, department_uniqueid, ignore_too_far, last_modified_time, email)
values (231386, null, null, 'STUDENT', 'STEVEN', null, 19, null, 231383, 0, null, null);
insert into DEPARTMENTAL_INSTRUCTOR (uniqueid, external_uid, career_acct, lname, fname, mname, pos_code_type, note, department_uniqueid, ignore_too_far, last_modified_time, email)
values (231387, null, null, 'STUDENT', 'JOHN', null, 11, null, 231383, 0, null, null);
insert into DEPARTMENTAL_INSTRUCTOR (uniqueid, external_uid, career_acct, lname, fname, mname, pos_code_type, note, department_uniqueid, ignore_too_far, last_modified_time, email)
values (231388, '100', null, 'DOE', 'JOE', null, 6, null, 231383, 0, null, null);
insert into DEPARTMENTAL_INSTRUCTOR (uniqueid, external_uid, career_acct, lname, fname, mname, pos_code_type, note, department_uniqueid, ignore_too_far, last_modified_time, email)
values (231389, '101', null, 'NEWMAN', 'GEORGE', null, 2, null, 231383, 0, null, null);
commit;
prompt 10 records loaded
prompt Loading ASSIGNED_INSTRUCTORS...
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142297, 226242, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142299, 226240, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142300, 226240, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142301, 226240, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142324, 226240, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142325, 226240, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142326, 226240, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142327, 226242, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142328, 226242, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142329, 226246, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142330, 226244, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142331, 226246, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142332, 226244, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142333, 226242, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142334, 226242, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142335, 226242, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142336, 226238, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142337, 226238, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142338, 226238, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142339, 226238, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142340, 226238, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142341, 226238, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142342, 226238, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142343, 226238, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142344, 226238, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142345, 226238, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142346, 226238, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142347, 226238, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142457, 231388, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142459, 231389, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142460, 231389, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142461, 231389, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142484, 231389, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142485, 231389, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142486, 231389, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142487, 231388, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142488, 231388, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142493, 231388, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142494, 231388, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142495, 231388, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142496, 231385, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142497, 231385, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142498, 231385, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142499, 231385, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142500, 231385, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142501, 231385, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142502, 231385, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142503, 231385, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142504, 231385, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142505, 231385, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142506, 231385, null);
insert into ASSIGNED_INSTRUCTORS (assignment_id, instructor_id, last_modified_time)
values (142507, 231385, null);
commit;
prompt 52 records loaded
prompt Loading ASSIGNED_ROOMS...
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142297, 7987, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142298, 7986, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142299, 7986, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142300, 7986, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142301, 7986, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142302, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142303, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142304, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142305, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142306, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142307, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142308, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142309, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142310, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142311, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142312, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142313, 7992, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142314, 7992, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142315, 7992, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142316, 7992, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142317, 7992, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142318, 7992, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142319, 7992, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142320, 7992, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142321, 7992, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142322, 7992, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142323, 7992, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142324, 7986, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142325, 7986, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142326, 7986, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142327, 7987, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142328, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142329, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142330, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142331, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142332, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142333, 7986, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142334, 7986, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142335, 7986, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142336, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142337, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142338, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142339, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142340, 7987, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142341, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142342, 7987, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142343, 7987, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142344, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142345, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142346, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142347, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142348, 7986, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142349, 7986, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142350, 7986, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142351, 7991, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142352, 7991, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142353, 7991, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142354, 7991, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142355, 7991, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142356, 7991, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142357, 7991, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142358, 7991, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142359, 7991, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142360, 7991, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142361, 7991, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142362, 7991, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142363, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142364, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142365, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142366, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142367, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142368, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142369, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142370, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142371, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142372, 7987, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142373, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142374, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142375, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142376, 7987, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142377, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142378, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142379, 7987, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142380, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142381, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142382, 7987, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142383, 7987, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142384, 7986, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142385, 7987, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142386, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142387, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142388, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142389, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142390, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142391, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142392, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142393, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142394, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142395, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142396, 7993, null);
commit;
prompt 100 records committed...
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142397, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142398, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142399, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142400, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142401, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142402, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142403, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142404, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142405, 7986, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142406, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142407, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142408, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142409, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142410, 7987, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142411, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142412, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142413, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142414, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142415, 7987, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142416, 7987, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142417, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142418, 7986, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142419, 7992, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142420, 7992, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142421, 7992, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142422, 7986, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142423, 7987, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142424, 7986, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142425, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142426, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142427, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142428, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142429, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142430, 7989, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142431, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142432, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142433, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142434, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142435, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142436, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142437, 7987, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142438, 7986, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142439, 7987, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142440, 7987, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142441, 7987, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142442, 7988, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142443, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142444, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142445, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142446, 7993, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142457, 8019, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142458, 8023, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142459, 8023, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142460, 8023, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142461, 8023, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142462, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142463, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142464, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142465, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142466, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142467, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142468, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142469, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142470, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142471, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142472, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142473, 8015, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142474, 8015, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142475, 8015, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142476, 8015, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142477, 8015, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142478, 8015, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142479, 8015, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142480, 8015, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142481, 8015, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142482, 8015, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142483, 8015, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142484, 8023, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142485, 8023, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142486, 8023, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142487, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142488, 8019, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142489, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142490, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142491, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142492, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142493, 8023, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142494, 8023, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142495, 8023, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142496, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142497, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142498, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142499, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142500, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142501, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142502, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142503, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142504, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142505, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142506, 8020, null);
commit;
prompt 200 records committed...
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142507, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142508, 8023, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142509, 8023, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142510, 8023, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142511, 8022, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142512, 8022, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142513, 8019, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142514, 8015, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142515, 8022, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142516, 8022, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142517, 8022, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142518, 8022, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142519, 8015, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142520, 8015, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142521, 8022, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142522, 8022, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142523, 8019, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142524, 8019, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142525, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142526, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142527, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142528, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142529, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142530, 8019, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142531, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142532, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142533, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142534, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142535, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142536, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142537, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142538, 8019, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142539, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142540, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142541, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142542, 8019, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142543, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142544, 8023, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142545, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142546, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142547, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142548, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142549, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142550, 8019, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142551, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142552, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142553, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142554, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142555, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142556, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142557, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142558, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142559, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142560, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142561, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142562, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142563, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142564, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142565, 8023, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142566, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142567, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142568, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142569, 8019, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142570, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142571, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142572, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142573, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142574, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142575, 8019, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142576, 8019, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142577, 8019, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142578, 8023, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142579, 8015, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142580, 8015, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142581, 8015, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142582, 8023, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142583, 8019, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142584, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142585, 8023, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142586, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142587, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142588, 8019, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142589, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142590, 8020, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142591, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142592, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142593, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142594, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142595, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142596, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142597, 8019, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142598, 8023, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142599, 8019, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142600, 8024, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142601, 8019, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142602, 8019, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142603, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142604, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142605, 8016, null);
insert into ASSIGNED_ROOMS (assignment_id, room_id, last_modified_time)
values (142606, 8016, null);
commit;
prompt 300 records loaded
prompt Loading BUILDING...
insert into BUILDING (uniqueid, session_id, abbreviation, name, coordinate_x, coordinate_y, external_uid)
values (1762, 223206, 'THTR', 'Theater of Performing Arts', 2, 1, null);
insert into BUILDING (uniqueid, session_id, abbreviation, name, coordinate_x, coordinate_y, external_uid)
values (1761, 223206, 'EDUC', 'Education Hall', 1, 1, null);
insert into BUILDING (uniqueid, session_id, abbreviation, name, coordinate_x, coordinate_y, external_uid)
values (1782, 231379, 'EDUC', 'Education Hall', 1, 1, null);
insert into BUILDING (uniqueid, session_id, abbreviation, name, coordinate_x, coordinate_y, external_uid)
values (1783, 231379, 'THTR', 'Theater of Performing Arts', 2, 1, null);
commit;
prompt 4 records loaded
prompt Loading PREFERENCE_LEVEL...
insert into PREFERENCE_LEVEL (pref_id, pref_prolog, pref_name, uniqueid)
values (1, 'R', 'Required', 1);
insert into PREFERENCE_LEVEL (pref_id, pref_prolog, pref_name, uniqueid)
values (2, '-2', 'Strongly Preferred', 2);
insert into PREFERENCE_LEVEL (pref_id, pref_prolog, pref_name, uniqueid)
values (3, '-1', 'Preferred', 3);
insert into PREFERENCE_LEVEL (pref_id, pref_prolog, pref_name, uniqueid)
values (4, '0', 'Neutral', 4);
insert into PREFERENCE_LEVEL (pref_id, pref_prolog, pref_name, uniqueid)
values (5, '1', 'Discouraged', 5);
insert into PREFERENCE_LEVEL (pref_id, pref_prolog, pref_name, uniqueid)
values (6, '2', 'Strongly Discouraged', 6);
insert into PREFERENCE_LEVEL (pref_id, pref_prolog, pref_name, uniqueid)
values (7, 'P', 'Prohibited', 7);
commit;
prompt 7 records loaded
prompt Loading BUILDING_PREF...
insert into BUILDING_PREF (uniqueid, owner_id, pref_level_id, bldg_id, distance_from, last_modified_time)
values (121515, 226240, 2, 1761, null, null);
insert into BUILDING_PREF (uniqueid, owner_id, pref_level_id, bldg_id, distance_from, last_modified_time)
values (123256, 231389, 2, 1782, null, null);
commit;
prompt 2 records loaded
prompt Loading CLASS_INSTRUCTOR...
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38068, 223884, 226242, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38069, 223245, 226242, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38070, 223947, 226242, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38071, 223949, 226246, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38072, 223950, 226244, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38073, 223951, 226246, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38074, 223970, 226244, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38081, 223926, 226240, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38082, 223927, 226240, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38083, 223973, 226240, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38078, 223240, 226240, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38079, 223899, 226240, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38080, 223900, 226240, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38084, 223869, 226242, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38085, 223870, 226238, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38086, 223958, 226238, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38087, 223959, 226238, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38088, 223960, 226238, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38089, 223956, 226242, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38090, 223961, 226238, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38091, 223962, 226238, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38092, 223963, 226238, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38093, 223964, 226238, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38094, 223957, 226242, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38095, 223965, 226238, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38096, 223966, 226238, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38097, 223967, 226238, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38098, 223968, 226238, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38108, 231391, 231388, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38109, 231396, 231389, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38110, 231423, 231389, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38111, 231424, 231389, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38112, 231425, 231389, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38113, 231395, 231389, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38114, 231397, 231389, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38115, 231435, 231388, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38116, 231434, 231388, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38117, 231451, 231385, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38118, 231448, 231385, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38119, 231438, 231388, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38120, 231439, 231388, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38121, 231446, 231385, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38122, 231442, 231385, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38123, 231452, 231385, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38124, 231444, 231385, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38125, 231437, 231388, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38126, 231441, 231385, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38127, 231450, 231385, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38128, 231443, 231385, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38129, 231445, 231385, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38130, 231447, 231385, 100, 1, null);
insert into CLASS_INSTRUCTOR (uniqueid, class_id, instructor_id, percent_share, is_lead, last_modified_time)
values (38131, 231449, 231385, 100, 1, null);
commit;
prompt 52 records loaded
prompt Loading STUDENT_STATUS_TYPE...
prompt Table is empty
prompt Loading STUDENT...
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (223384, '1001', 'Andrew', null, 'Student', null, 0, 0, null, null, 223206);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (223385, '1002', 'Brian', null, 'Student', null, 0, 0, null, null, 223206);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (223386, '1003', 'Charles', null, 'Student', null, 0, 0, null, null, 223206);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (223387, '1004', 'David', null, 'Student', null, 0, 0, null, null, 223206);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (223388, '1005', 'Edward', null, 'Student', null, 0, 0, null, null, 223206);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (223389, '1006', 'Frank', null, 'Student', null, 0, 0, null, null, 223206);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (223390, '1007', 'George', null, 'Student', null, 0, 0, null, null, 223206);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (223391, '1008', 'Henry', null, 'Student', null, 0, 0, null, null, 223206);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (223392, '1009', 'Ivan', null, 'Student', null, 0, 0, null, null, 223206);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (223393, '1010', 'James', null, 'Student', null, 0, 0, null, null, 223206);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (223394, '1011', 'Kevin', null, 'Student', null, 0, 0, null, null, 223206);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (223395, '1012', 'Larry', null, 'Student', null, 0, 0, null, null, 223206);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (223396, '1013', 'Michael', null, 'Student', null, 0, 0, null, null, 223206);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (223397, '1014', 'Norman', null, 'Student', null, 0, 0, null, null, 223206);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (223398, '1015', 'Oscar', null, 'Student', null, 0, 0, null, null, 223206);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (223399, '1016', 'Peter', null, 'Student', null, 0, 0, null, null, 223206);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (223400, '1017', 'Richard', null, 'Student', null, 0, 0, null, null, 223206);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (223401, '1018', 'Steve', null, 'Student', null, 0, 0, null, null, 223206);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (223402, '1019', 'Thomas', null, 'Student', null, 0, 0, null, null, 223206);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (231849, '1001', 'Andrew', null, 'Student', null, 0, 0, null, null, 231379);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (232436, '1002', 'Brian', null, 'Student', null, 0, 0, null, null, 231379);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (232448, '1003', 'Charles', null, 'Student', null, 0, 0, null, null, 231379);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (232460, '1004', 'David', null, 'Student', null, 0, 0, null, null, 231379);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (232472, '1005', 'Edward', null, 'Student', null, 0, 0, null, null, 231379);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (232484, '1006', 'Frank', null, 'Student', null, 0, 0, null, null, 231379);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (232496, '1007', 'George', null, 'Student', null, 0, 0, null, null, 231379);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (232510, '1008', 'Henry', null, 'Student', null, 0, 0, null, null, 231379);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (232522, '1009', 'Ivan', null, 'Student', null, 0, 0, null, null, 231379);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (232534, '1010', 'James', null, 'Student', null, 0, 0, null, null, 231379);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (232546, '1011', 'Kevin', null, 'Student', null, 0, 0, null, null, 231379);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (232558, '1012', 'Larry', null, 'Student', null, 0, 0, null, null, 231379);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (232572, '1013', 'Michael', null, 'Student', null, 0, 0, null, null, 231379);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (232584, '1014', 'Norman', null, 'Student', null, 0, 0, null, null, 231379);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (232596, '1015', 'Oscar', null, 'Student', null, 0, 0, null, null, 231379);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (232608, '1016', 'Peter', null, 'Student', null, 0, 0, null, null, 231379);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (232620, '1017', 'Richard', null, 'Student', null, 0, 0, null, null, 231379);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (232632, '1018', 'Steve', null, 'Student', null, 0, 0, null, null, 231379);
insert into STUDENT (uniqueid, external_uid, first_name, middle_name, last_name, email, free_time_cat, schedule_preference, status_type_id, status_change_date, session_id)
values (232644, '1019', 'Thomas', null, 'Student', null, 0, 0, null, null, 231379);
commit;
prompt 38 records loaded
prompt Loading FREE_TIME...
prompt Table is empty
prompt Loading COURSE_DEMAND...
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225705, 223396, 0, 0, 0, to_date('25-04-2007 10:31:12', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225708, 223396, 1, 0, 0, to_date('25-04-2007 10:31:12', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225711, 223396, 2, 0, 0, to_date('25-04-2007 10:31:12', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225714, 223396, 3, 0, 0, to_date('25-04-2007 10:31:12', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225717, 223396, 4, 0, 0, to_date('25-04-2007 10:31:12', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225492, 223386, 0, 0, 0, to_date('25-04-2007 10:31:04', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225496, 223386, 1, 0, 0, to_date('25-04-2007 10:31:04', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225500, 223386, 2, 0, 0, to_date('25-04-2007 10:31:04', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225503, 223386, 3, 0, 0, to_date('25-04-2007 10:31:04', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225506, 223386, 4, 0, 0, to_date('25-04-2007 10:31:04', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225622, 223392, 0, 0, 0, to_date('25-04-2007 10:31:09', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225627, 223392, 1, 0, 0, to_date('25-04-2007 10:31:09', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225632, 223392, 2, 0, 0, to_date('25-04-2007 10:31:09', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225636, 223392, 3, 0, 0, to_date('25-04-2007 10:31:09', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225640, 223392, 4, 0, 0, to_date('25-04-2007 10:31:09', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225644, 223393, 0, 0, 0, to_date('25-04-2007 10:31:10', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225722, 223397, 0, 0, 0, to_date('25-04-2007 10:31:13', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (226167, 223384, 0, 0, 0, to_date('25-04-2007 11:53:22', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (226171, 223384, 1, 0, 0, to_date('25-04-2007 11:53:22', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (226176, 223384, 2, 0, 0, to_date('25-04-2007 11:53:22', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (226180, 223384, 3, 0, 0, to_date('25-04-2007 11:53:22', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (226184, 223384, 4, 0, 0, to_date('25-04-2007 11:53:22', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225532, 223388, 0, 0, 0, to_date('25-04-2007 10:31:06', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225538, 223388, 1, 0, 0, to_date('25-04-2007 10:31:06', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225543, 223388, 2, 0, 0, to_date('25-04-2007 10:31:06', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225547, 223388, 3, 0, 0, to_date('25-04-2007 10:31:06', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225832, 223402, 0, 0, 0, to_date('25-04-2007 10:31:16', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225510, 223387, 0, 0, 0, to_date('25-04-2007 10:31:05', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225516, 223387, 1, 0, 0, to_date('25-04-2007 10:31:05', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225521, 223387, 2, 0, 0, to_date('25-04-2007 10:31:05', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225525, 223387, 3, 0, 0, to_date('25-04-2007 10:31:05', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225528, 223387, 4, 0, 0, to_date('25-04-2007 10:31:05', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225550, 223388, 4, 0, 0, to_date('25-04-2007 10:31:06', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225836, 223402, 1, 0, 0, to_date('25-04-2007 10:31:16', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225841, 223402, 2, 0, 0, to_date('25-04-2007 10:31:16', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225843, 223402, 3, 0, 0, to_date('25-04-2007 10:31:16', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225846, 223402, 4, 0, 0, to_date('25-04-2007 10:31:16', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225554, 223389, 0, 0, 0, to_date('25-04-2007 10:31:07', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225560, 223389, 1, 0, 0, to_date('25-04-2007 10:31:07', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225565, 223389, 2, 0, 0, to_date('25-04-2007 10:31:07', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225569, 223389, 3, 0, 0, to_date('25-04-2007 10:31:07', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225572, 223389, 4, 0, 0, to_date('25-04-2007 10:31:07', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225576, 223390, 0, 0, 0, to_date('25-04-2007 10:31:08', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225581, 223390, 1, 0, 0, to_date('25-04-2007 10:31:08', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225586, 223390, 2, 0, 0, to_date('25-04-2007 10:31:08', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225590, 223390, 3, 0, 0, to_date('25-04-2007 10:31:08', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225594, 223390, 4, 0, 0, to_date('25-04-2007 10:31:08', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225597, 223390, 5, 0, 0, to_date('25-04-2007 10:31:08', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225600, 223391, 0, 0, 0, to_date('25-04-2007 10:31:09', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225605, 223391, 1, 0, 0, to_date('25-04-2007 10:31:09', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225611, 223391, 2, 0, 0, to_date('25-04-2007 10:31:09', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225615, 223391, 3, 0, 0, to_date('25-04-2007 10:31:09', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225649, 223393, 1, 0, 0, to_date('25-04-2007 10:31:10', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225654, 223393, 2, 0, 0, to_date('25-04-2007 10:31:10', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225658, 223393, 3, 0, 0, to_date('25-04-2007 10:31:10', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225662, 223393, 4, 0, 0, to_date('25-04-2007 10:31:10', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225666, 223394, 0, 0, 0, to_date('25-04-2007 10:31:10', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225672, 223394, 1, 0, 0, to_date('25-04-2007 10:31:10', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225675, 223394, 2, 0, 0, to_date('25-04-2007 10:31:10', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225678, 223394, 3, 0, 0, to_date('25-04-2007 10:31:10', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225681, 223394, 4, 0, 0, to_date('25-04-2007 10:31:10', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225685, 223395, 0, 0, 0, to_date('25-04-2007 10:31:11', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225688, 223395, 1, 0, 0, to_date('25-04-2007 10:31:11', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225692, 223395, 2, 0, 0, to_date('25-04-2007 10:31:11', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225696, 223395, 3, 0, 0, to_date('25-04-2007 10:31:11', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225699, 223395, 4, 0, 0, to_date('25-04-2007 10:31:11', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225702, 223395, 5, 0, 0, to_date('25-04-2007 10:31:11', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225728, 223397, 1, 0, 0, to_date('25-04-2007 10:31:13', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225732, 223397, 2, 0, 0, to_date('25-04-2007 10:31:13', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225737, 223397, 3, 0, 0, to_date('25-04-2007 10:31:13', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225741, 223397, 4, 0, 0, to_date('25-04-2007 10:31:13', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225745, 223398, 0, 0, 0, to_date('25-04-2007 10:31:13', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225751, 223398, 1, 0, 0, to_date('25-04-2007 10:31:13', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225755, 223398, 2, 0, 0, to_date('25-04-2007 10:31:13', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225760, 223398, 3, 0, 0, to_date('25-04-2007 10:31:13', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225764, 223398, 4, 0, 0, to_date('25-04-2007 10:31:13', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225768, 223399, 0, 0, 0, to_date('25-04-2007 10:31:14', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225774, 223399, 1, 0, 0, to_date('25-04-2007 10:31:14', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225778, 223399, 2, 0, 0, to_date('25-04-2007 10:31:14', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225780, 223399, 3, 0, 0, to_date('25-04-2007 10:31:14', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225784, 223399, 4, 0, 0, to_date('25-04-2007 10:31:14', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225788, 223400, 0, 0, 0, to_date('25-04-2007 10:31:15', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225791, 223400, 1, 0, 0, to_date('25-04-2007 10:31:15', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225797, 223400, 2, 0, 0, to_date('25-04-2007 10:31:15', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225802, 223400, 3, 0, 0, to_date('25-04-2007 10:31:15', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225806, 223400, 4, 0, 0, to_date('25-04-2007 10:31:15', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225810, 223401, 0, 0, 0, to_date('25-04-2007 10:31:15', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225813, 223401, 1, 0, 0, to_date('25-04-2007 10:31:15', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225819, 223401, 2, 0, 0, to_date('25-04-2007 10:31:15', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225824, 223401, 3, 0, 0, to_date('25-04-2007 10:31:15', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225828, 223401, 4, 0, 0, to_date('25-04-2007 10:31:15', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225476, 223385, 0, 0, 0, to_date('25-04-2007 10:31:02', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225479, 223385, 1, 0, 0, to_date('25-04-2007 10:31:02', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225482, 223385, 2, 0, 0, to_date('25-04-2007 10:31:02', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225485, 223385, 3, 0, 0, to_date('25-04-2007 10:31:02', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225488, 223385, 4, 0, 0, to_date('25-04-2007 10:31:02', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (225619, 223391, 4, 0, 0, to_date('25-04-2007 10:31:09', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237799, 232436, 0, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237801, 232436, 1, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237803, 232436, 2, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
commit;
prompt 100 records committed...
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237805, 232436, 3, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237807, 232436, 4, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237788, 231849, 0, 0, 0, to_date('22-09-2010 16:25:20', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237790, 231849, 1, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237792, 231849, 2, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237794, 231849, 3, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237796, 231849, 4, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237810, 232448, 0, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237812, 232448, 1, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237814, 232448, 2, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237816, 232448, 3, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237818, 232448, 4, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237821, 232460, 0, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237823, 232460, 1, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237825, 232460, 2, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237827, 232460, 3, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237829, 232460, 4, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237832, 232472, 0, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237834, 232472, 1, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237836, 232472, 2, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237838, 232472, 3, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237840, 232472, 4, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237843, 232484, 0, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237845, 232484, 1, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237847, 232484, 2, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237849, 232484, 3, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237851, 232484, 4, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237854, 232496, 0, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237856, 232496, 1, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237858, 232496, 2, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237860, 232496, 3, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237862, 232496, 4, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237864, 232496, 5, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237867, 232510, 0, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237869, 232510, 1, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237871, 232510, 2, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237873, 232510, 3, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237875, 232510, 4, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237878, 232522, 0, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237880, 232522, 1, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237882, 232522, 2, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237884, 232522, 3, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237886, 232522, 4, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237889, 232534, 0, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237891, 232534, 1, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237893, 232534, 2, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237895, 232534, 3, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237897, 232534, 4, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237900, 232546, 0, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237902, 232546, 1, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237904, 232546, 2, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237906, 232546, 3, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237908, 232546, 4, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237911, 232558, 0, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237913, 232558, 1, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237915, 232558, 2, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237917, 232558, 3, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237919, 232558, 4, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237921, 232558, 5, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237924, 232572, 0, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237926, 232572, 1, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237928, 232572, 2, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237930, 232572, 3, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237932, 232572, 4, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237935, 232584, 0, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237937, 232584, 1, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237939, 232584, 2, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237941, 232584, 3, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237943, 232584, 4, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237946, 232596, 0, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237948, 232596, 1, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237950, 232596, 2, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237952, 232596, 3, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237954, 232596, 4, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237957, 232608, 0, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237959, 232608, 1, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237961, 232608, 2, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237963, 232608, 3, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237965, 232608, 4, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237968, 232620, 0, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237970, 232620, 1, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237972, 232620, 2, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237974, 232620, 3, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237976, 232620, 4, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237979, 232632, 0, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237981, 232632, 1, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237983, 232632, 2, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237985, 232632, 3, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237987, 232632, 4, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237990, 232644, 0, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237992, 232644, 1, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237994, 232644, 2, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237996, 232644, 3, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
insert into COURSE_DEMAND (uniqueid, student_id, priority, waitlist, is_alternative, timestamp, free_time_id)
values (237998, 232644, 4, 0, 0, to_date('22-09-2010 16:25:21', 'dd-mm-yyyy hh24:mi:ss'), null);
commit;
prompt 194 records loaded
prompt Loading SUBJECT_AREA...
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (779, 223206, 'ENGR', 'Engineering', 'Engineering', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (780, 223206, 'LING', 'Linguistics', 'Linguistics', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (781, 223206, 'PHAR', 'Pharmacy', 'Pharmacy', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (782, 223206, 'MBIO', 'Microbiology', 'Microbiology', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (761, 223206, 'ALG', 'Algebra', 'Algebra', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (762, 223206, 'BIOL', 'Biology', 'Biology', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (763, 223206, 'C S', 'Computer Science', 'Computer Science', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (764, 223206, 'BAND', 'Band', 'Band', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (765, 223206, 'CHM', 'Chemistry', 'Chemistry', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (766, 223206, 'ECON', 'Economics', 'Economics', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (767, 223206, 'COM', 'Communications', 'Communications', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (768, 223206, 'ENGL', 'English', 'English', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (769, 223206, 'GER', 'German', 'German', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (770, 223206, 'HIST', 'History', 'History', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (771, 223206, 'CALC', 'Calculus', 'Calculus', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (772, 223206, 'PHIL', 'Philosophy', 'Philosophy', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (773, 223206, 'PHYS', 'Physics', 'Physics', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (774, 223206, 'POL', 'Political Science', 'Political Science', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (775, 223206, 'PSY', 'Psychology', 'Psychology', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (776, 223206, 'CHIN', 'Chinese', 'Chinese', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (777, 223206, 'SOC', 'Sociology', 'Solciology', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (778, 223206, 'SPAN', 'Spanish', 'Spanish', '0', '0', 223207, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (799, 231379, 'ALG', 'Algebra', 'Algebra', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (800, 231379, 'BAND', 'Band', 'Band', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (801, 231379, 'BIOL', 'Biology', 'Biology', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (802, 231379, 'C S', 'Computer Science', 'Computer Science', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (803, 231379, 'CALC', 'Calculus', 'Calculus', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (804, 231379, 'CHIN', 'Chinese', 'Chinese', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (805, 231379, 'CHM', 'Chemistry', 'Chemistry', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (806, 231379, 'COM', 'Communications', 'Communications', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (807, 231379, 'ECON', 'Economics', 'Economics', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (808, 231379, 'ENGL', 'English', 'English', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (809, 231379, 'ENGR', 'Engineering', 'Engineering', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (810, 231379, 'GER', 'German', 'German', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (811, 231379, 'HIST', 'History', 'History', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (812, 231379, 'LING', 'Linguistics', 'Linguistics', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (813, 231379, 'MBIO', 'Microbiology', 'Microbiology', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (814, 231379, 'PHAR', 'Pharmacy', 'Pharmacy', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (815, 231379, 'PHIL', 'Philosophy', 'Philosophy', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (816, 231379, 'PHYS', 'Physics', 'Physics', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (817, 231379, 'POL', 'Political Science', 'Political Science', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (818, 231379, 'PSY', 'Psychology', 'Psychology', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (819, 231379, 'SOC', 'Sociology', 'Solciology', '0', '0', 231383, null, null);
insert into SUBJECT_AREA (uniqueid, session_id, subject_area_abbreviation, short_title, long_title, schedule_book_only, pseudo_subject_area, department_uniqueid, external_uid, last_modified_time)
values (820, 231379, 'SPAN', 'Spanish', 'Spanish', '0', '0', 231383, null, null);
commit;
prompt 44 records loaded
prompt Loading COURSE_OFFERING...
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135715, '101', 1, null, 0, 132313, 761, 'Algebra I', null, null, null, 0, null, null, null, 2, 2);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135716, '101', 1, null, 0, 132314, 762, 'Introduction to Biology', null, null, null, 0, null, null, null, 11, 10);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135717, '101', 1, null, 0, 132315, 763, 'Introductory Computing', null, null, null, 0, null, null, null, 4, 4);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135718, '101', 1, null, 0, 132316, 764, 'Band', null, null, null, 0, null, null, null, 4, 3);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135719, '101', 1, null, 0, 132317, 765, 'Chemistry I', null, null, null, 0, null, null, null, 12, 12);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135720, '101', 1, null, 0, 132318, 766, 'Micoeconomics', null, null, null, 0, null, null, null, 4, 4);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135721, '101', 1, null, 0, 132319, 767, 'Communications I', null, null, null, 0, null, null, null, 9, 8);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135722, '101', 1, null, 0, 132320, 768, 'English', null, null, null, 0, null, null, null, 10, 10);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135723, '101', 1, null, 0, 132321, 769, 'German', null, null, null, 0, null, null, null, 4, 4);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135724, '101', 1, null, 0, 132322, 770, 'History of the World', null, null, null, 0, null, null, null, 4, 3);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135726, '101', 1, null, 0, 132324, 772, 'Philosophy', null, null, null, 0, null, null, null, 2, 2);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135727, '101', 1, null, 0, 132325, 773, 'Physics', null, null, null, 0, null, null, null, 5, 5);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135728, '101', 1, null, 0, 132326, 774, 'Political Science', null, null, null, 0, null, null, null, 4, 4);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135729, '101', 1, null, 0, 132327, 775, 'Psychology', null, null, null, 0, null, null, null, 4, 4);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135730, '201', 1, null, 0, 132328, 776, 'Advanced Chinese', null, null, null, 0, null, null, null, 0, 0);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135731, '101', 1, null, 0, 132329, 777, 'Sociology', null, null, null, 0, null, null, null, 4, 3);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135732, '101', 1, null, 0, 132330, 778, 'Spanish', null, null, null, 0, null, null, null, 4, 3);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135733, '101', 1, null, 0, 132331, 771, 'Calculus', null, null, null, 0, null, null, null, 12, 12);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135739, '101', 1, null, 0, 132338, 782, 'Principles of Microbiology', null, null, null, 0, null, null, null, 3, 3);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135735, '201', 1, null, 0, 132334, 762, 'Principles of Microbiology', null, null, null, 0, null, null, null, 0, 0);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135736, '101', 1, null, 0, 132335, 779, 'Freshman Engineering', null, null, null, 0, null, null, null, 3, 3);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135737, '101', 1, null, 0, 132336, 780, 'Introduction to Linguistics', null, null, null, 0, null, null, null, 1, 1);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135738, '101', 1, null, 0, 132337, 781, 'Seminars in Pharmacy', null, null, null, 0, null, null, null, 3, 3);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135753, '101', 1, null, null, 132351, 799, 'Algebra I', null, null, null, 0, null, null, 135715, 2, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135754, '101', 1, null, null, 132352, 800, 'Band', null, null, null, 0, null, null, 135718, 3, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135755, '101', 1, null, null, 132353, 801, 'Introduction to Biology', null, null, null, 0, null, null, 135716, 10, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135756, '201', 1, null, null, 132354, 801, 'Principles of Microbiology', null, null, null, 0, null, null, 135735, 0, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135757, '101', 1, null, null, 132355, 802, 'Introductory Computing', null, null, null, 0, null, null, 135717, 4, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135758, '101', 1, null, null, 132356, 803, 'Calculus', null, null, null, 0, null, null, 135733, 12, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135759, '201', 1, null, null, 132357, 804, 'Advanced Chinese', null, null, null, 0, null, null, 135730, 0, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135760, '101', 1, null, null, 132358, 805, 'Chemistry I', null, null, null, 0, null, null, 135719, 12, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135761, '101', 1, null, null, 132359, 806, 'Communications I', null, null, null, 0, null, null, 135721, 8, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135762, '101', 1, null, null, 132360, 807, 'Micoeconomics', null, null, null, 0, null, null, 135720, 4, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135763, '101', 1, null, null, 132361, 808, 'English', null, null, null, 0, null, null, 135722, 10, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135764, '101', 1, null, null, 132362, 809, 'Freshman Engineering', null, null, null, 0, null, null, 135736, 3, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135765, '101', 1, null, null, 132363, 810, 'German', null, null, null, 0, null, null, 135723, 4, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135766, '101', 1, null, null, 132364, 811, 'History of the World', null, null, null, 0, null, null, 135724, 3, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135767, '101', 1, null, null, 132365, 812, 'Introduction to Linguistics', null, null, null, 0, null, null, 135737, 1, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135768, '101', 1, null, null, 132366, 813, 'Principles of Microbiology', null, null, null, 0, null, null, 135739, 3, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135769, '101', 1, null, null, 132367, 814, 'Seminars in Pharmacy', null, null, null, 0, null, null, 135738, 3, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135770, '101', 1, null, null, 132368, 815, 'Philosophy', null, null, null, 0, null, null, 135726, 2, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135771, '101', 1, null, null, 132369, 816, 'Physics', null, null, null, 0, null, null, 135727, 5, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135772, '101', 1, null, null, 132370, 817, 'Political Science', null, null, null, 0, null, null, 135728, 4, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135773, '101', 1, null, null, 132371, 818, 'Psychology', null, null, null, 0, null, null, 135729, 4, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135774, '101', 1, null, null, 132372, 819, 'Sociology', null, null, null, 0, null, null, 135731, 3, null);
insert into COURSE_OFFERING (uniqueid, course_nbr, is_control, perm_id, proj_demand, instr_offr_id, subject_area_id, title, schedule_book_note, demand_offering_id, demand_offering_type, nbr_expected_stdents, external_uid, last_modified_time, uid_rolled_fwd_from, lastlike_demand, enrollment)
values (135775, '101', 1, null, null, 132373, 820, 'Spanish', null, null, null, 0, null, null, 135732, 3, null);
commit;
prompt 46 records loaded
prompt Loading COURSE_REQUEST...
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225623, 225622, 135719, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225628, 225627, 135727, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225633, 225632, 135736, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225637, 225636, 135733, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225641, 225640, 135722, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225706, 225705, 135731, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225709, 225708, 135724, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225712, 225711, 135737, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225715, 225714, 135726, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225718, 225717, 135727, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225645, 225644, 135719, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225723, 225722, 135716, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (226168, 226167, 135715, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (226172, 226171, 135721, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (226177, 226176, 135729, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (226181, 226180, 135720, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (226185, 226184, 135731, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225533, 225532, 135716, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225539, 225538, 135719, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225544, 225543, 135733, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225548, 225547, 135738, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225833, 225832, 135717, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225493, 225492, 135733, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225497, 225496, 135722, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225501, 225500, 135729, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225504, 225503, 135720, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225507, 225506, 135717, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225511, 225510, 135716, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225517, 225516, 135719, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225522, 225521, 135733, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225526, 225525, 135738, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225529, 225528, 135722, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225551, 225550, 135722, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225837, 225836, 135727, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225842, 225841, 135733, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225844, 225843, 135721, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225847, 225846, 135728, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225555, 225554, 135716, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225561, 225560, 135719, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225566, 225565, 135733, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225570, 225569, 135738, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225573, 225572, 135722, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225577, 225576, 135719, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225582, 225581, 135727, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225587, 225586, 135736, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225591, 225590, 135733, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225595, 225594, 135721, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225598, 225597, 135718, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225601, 225600, 135719, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225606, 225605, 135716, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225612, 225611, 135736, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225616, 225615, 135733, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225667, 225666, 135716, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225673, 225672, 135721, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225676, 225675, 135728, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225679, 225678, 135729, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225682, 225681, 135732, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225650, 225649, 135727, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225655, 225654, 135717, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225659, 225658, 135733, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225663, 225662, 135722, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225686, 225685, 135721, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225689, 225688, 135722, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225693, 225692, 135723, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225697, 225696, 135726, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225700, 225699, 135724, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225703, 225702, 135718, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225729, 225728, 135739, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225733, 225732, 135719, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225738, 225737, 135733, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225742, 225741, 135722, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225746, 225745, 135716, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225752, 225751, 135739, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225756, 225755, 135719, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225761, 225760, 135733, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225765, 225764, 135723, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225789, 225788, 135728, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225769, 225768, 135716, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225775, 225774, 135739, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225779, 225778, 135719, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225781, 225780, 135733, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225785, 225784, 135732, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225792, 225791, 135716, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225798, 225797, 135719, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225803, 225802, 135722, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225807, 225806, 135732, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225811, 225810, 135724, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225814, 225813, 135716, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225820, 225819, 135719, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225825, 225824, 135722, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225829, 225828, 135723, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225477, 225476, 135715, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225480, 225479, 135721, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225483, 225482, 135729, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225486, 225485, 135720, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225489, 225488, 135723, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (225620, 225619, 135721, 0, 0, -1);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237800, 237799, 135753, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237802, 237801, 135761, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237804, 237803, 135773, 0, 0, 0);
commit;
prompt 100 records committed...
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237806, 237805, 135762, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237808, 237807, 135765, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237789, 237788, 135753, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237791, 237790, 135761, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237793, 237792, 135773, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237795, 237794, 135762, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237797, 237796, 135774, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237811, 237810, 135758, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237813, 237812, 135763, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237815, 237814, 135773, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237817, 237816, 135762, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237819, 237818, 135757, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237822, 237821, 135755, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237824, 237823, 135760, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237826, 237825, 135758, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237828, 237827, 135769, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237830, 237829, 135763, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237833, 237832, 135755, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237835, 237834, 135760, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237837, 237836, 135758, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237839, 237838, 135769, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237841, 237840, 135763, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237844, 237843, 135755, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237846, 237845, 135760, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237848, 237847, 135758, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237850, 237849, 135769, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237852, 237851, 135763, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237855, 237854, 135760, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237857, 237856, 135771, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237859, 237858, 135764, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237861, 237860, 135758, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237863, 237862, 135761, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237865, 237864, 135754, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237868, 237867, 135760, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237870, 237869, 135755, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237872, 237871, 135764, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237874, 237873, 135758, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237876, 237875, 135761, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237879, 237878, 135760, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237881, 237880, 135771, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237883, 237882, 135764, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237885, 237884, 135758, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237887, 237886, 135763, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237890, 237889, 135760, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237892, 237891, 135771, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237894, 237893, 135757, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237896, 237895, 135758, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237898, 237897, 135763, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237901, 237900, 135755, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237903, 237902, 135761, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237905, 237904, 135772, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237907, 237906, 135773, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237909, 237908, 135775, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237912, 237911, 135761, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237914, 237913, 135763, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237916, 237915, 135765, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237918, 237917, 135770, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237920, 237919, 135766, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237922, 237921, 135754, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237925, 237924, 135774, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237927, 237926, 135766, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237929, 237928, 135767, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237931, 237930, 135770, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237933, 237932, 135771, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237936, 237935, 135755, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237938, 237937, 135768, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237940, 237939, 135760, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237942, 237941, 135758, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237944, 237943, 135763, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237947, 237946, 135755, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237949, 237948, 135768, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237951, 237950, 135760, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237953, 237952, 135758, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237955, 237954, 135765, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237958, 237957, 135755, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237960, 237959, 135768, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237962, 237961, 135760, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237964, 237963, 135758, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237966, 237965, 135775, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237969, 237968, 135772, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237971, 237970, 135755, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237973, 237972, 135760, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237975, 237974, 135763, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237977, 237976, 135775, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237980, 237979, 135766, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237982, 237981, 135755, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237984, 237983, 135760, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237986, 237985, 135763, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237988, 237987, 135765, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237991, 237990, 135757, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237993, 237992, 135771, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237995, 237994, 135758, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237997, 237996, 135761, 0, 0, 0);
insert into COURSE_REQUEST (uniqueid, course_demand_id, course_offering_id, ord, allow_overlap, credit)
values (237999, 237998, 135772, 0, 0, 0);
commit;
prompt 194 records loaded
prompt Loading CLASS_WAITLIST...
insert into CLASS_WAITLIST (uniqueid, student_id, course_request_id, class_id, type, timestamp)
values (226169, 223384, 226168, 223884, 1, to_date('25-04-2007 11:53:22', 'dd-mm-yyyy hh24:mi:ss'));
insert into CLASS_WAITLIST (uniqueid, student_id, course_request_id, class_id, type, timestamp)
values (226173, 223384, 226172, 223297, 1, to_date('25-04-2007 11:53:22', 'dd-mm-yyyy hh24:mi:ss'));
insert into CLASS_WAITLIST (uniqueid, student_id, course_request_id, class_id, type, timestamp)
values (226174, 223384, 226172, 223301, 1, to_date('25-04-2007 11:53:22', 'dd-mm-yyyy hh24:mi:ss'));
insert into CLASS_WAITLIST (uniqueid, student_id, course_request_id, class_id, type, timestamp)
values (226178, 223384, 226177, 223363, 1, to_date('25-04-2007 11:53:22', 'dd-mm-yyyy hh24:mi:ss'));
insert into CLASS_WAITLIST (uniqueid, student_id, course_request_id, class_id, type, timestamp)
values (226182, 223384, 226181, 223291, 1, to_date('25-04-2007 11:53:22', 'dd-mm-yyyy hh24:mi:ss'));
insert into CLASS_WAITLIST (uniqueid, student_id, course_request_id, class_id, type, timestamp)
values (226186, 223384, 226185, 223373, 1, to_date('25-04-2007 11:53:22', 'dd-mm-yyyy hh24:mi:ss'));
commit;
prompt 6 records loaded
prompt Loading CONSTRAINT_INFO...
prompt Table is empty
prompt Loading COURSE_CATALOG...
prompt Table is empty
prompt Loading COURSE_CREDIT_TYPE...
insert into COURSE_CREDIT_TYPE (uniqueid, reference, label, abbreviation, legacy_crse_master_code)
values (238, 'collegiate', 'Collegiate Credit', null, ' ');
insert into COURSE_CREDIT_TYPE (uniqueid, reference, label, abbreviation, legacy_crse_master_code)
values (239, 'continuingEdUnits', 'Continuing Education Units', 'CEU', 'Q');
insert into COURSE_CREDIT_TYPE (uniqueid, reference, label, abbreviation, legacy_crse_master_code)
values (240, 'equivalent', 'Equivalent Credit', 'EQV', 'E');
insert into COURSE_CREDIT_TYPE (uniqueid, reference, label, abbreviation, legacy_crse_master_code)
values (241, 'mastersCredit', 'Masters Credit', 'MS', 'M');
insert into COURSE_CREDIT_TYPE (uniqueid, reference, label, abbreviation, legacy_crse_master_code)
values (242, 'phdThesisCredit', 'Phd Thesis Credit', 'PhD', 'T');
commit;
prompt 5 records loaded
prompt Loading COURSE_CREDIT_UNIT_CONFIG...
insert into COURSE_CREDIT_UNIT_CONFIG (uniqueid, credit_format, owner_id, credit_type, credit_unit_type, defines_credit_at_course_level, fixed_units, min_units, max_units, fractional_incr_allowed, instr_offr_id, last_modified_time)
values (27604, 'fixedUnit', 223228, 238, 248, 0, 3, null, null, null, null, null);
insert into COURSE_CREDIT_UNIT_CONFIG (uniqueid, credit_format, owner_id, credit_type, credit_unit_type, defines_credit_at_course_level, fixed_units, min_units, max_units, fractional_incr_allowed, instr_offr_id, last_modified_time)
values (27602, 'fixedUnit', null, 238, 248, 1, 3, null, null, null, 132313, null);
insert into COURSE_CREDIT_UNIT_CONFIG (uniqueid, credit_format, owner_id, credit_type, credit_unit_type, defines_credit_at_course_level, fixed_units, min_units, max_units, fractional_incr_allowed, instr_offr_id, last_modified_time)
values (27621, 'fixedUnit', null, 238, 248, 1, 3, null, null, null, 132351, null);
insert into COURSE_CREDIT_UNIT_CONFIG (uniqueid, credit_format, owner_id, credit_type, credit_unit_type, defines_credit_at_course_level, fixed_units, min_units, max_units, fractional_incr_allowed, instr_offr_id, last_modified_time)
values (27622, 'fixedUnit', 231390, 238, 248, 0, 3, null, null, null, null, null);
commit;
prompt 4 records loaded
prompt Loading COURSE_CREDIT_UNIT_TYPE...
insert into COURSE_CREDIT_UNIT_TYPE (uniqueid, reference, label, abbreviation)
values (248, 'semesterHours', 'Semester Hours', null);
commit;
prompt 1 records loaded
prompt Loading COURSE_RESERVATION...
insert into COURSE_RESERVATION (uniqueid, owner, reservation_type, course_offering, priority, reserved, prior_enrollment, projected_enrollment, owner_class_id, requested, last_modified_time)
values (29623, 132313, 288, 135715, 1, 2, null, null, 'I', null, null);
commit;
prompt 1 records loaded
prompt Loading COURSE_SUBPART_CREDIT...
prompt Table is empty
prompt Loading CRSE_CREDIT_FORMAT...
insert into CRSE_CREDIT_FORMAT (uniqueid, reference, label, abbreviation)
values (243, 'arrangeHours', 'Arrange Hours', 'AH');
insert into CRSE_CREDIT_FORMAT (uniqueid, reference, label, abbreviation)
values (244, 'fixedUnit', 'Fixed Unit', null);
insert into CRSE_CREDIT_FORMAT (uniqueid, reference, label, abbreviation)
values (245, 'variableMinMax', 'Variable Min/Max', null);
insert into CRSE_CREDIT_FORMAT (uniqueid, reference, label, abbreviation)
values (246, 'variableRange', 'Variable Range', null);
commit;
prompt 4 records loaded
prompt Loading CURRICULUM...
insert into CURRICULUM (uniqueid, abbv, name, acad_area_id, dept_id)
values (238619, 'A/M3', 'The Woebegon''s Only Academic Area / Major 3', 142, 231383);
insert into CURRICULUM (uniqueid, abbv, name, acad_area_id, dept_id)
values (238634, 'A/M2', 'The Woebegon''s Only Academic Area / Major 2', 142, 231383);
insert into CURRICULUM (uniqueid, abbv, name, acad_area_id, dept_id)
values (238654, 'A/M1', 'The Woebegon''s Only Academic Area / Major 1', 142, 231383);
commit;
prompt 3 records loaded
prompt Loading CURRICULUM_CLASF...
insert into CURRICULUM_CLASF (uniqueid, curriculum_id, name, acad_clasf_id, nr_students, ord)
values (238620, 238619, '02', 62, 2, 1);
insert into CURRICULUM_CLASF (uniqueid, curriculum_id, name, acad_clasf_id, nr_students, ord)
values (238627, 238619, '01', 61, 2, 0);
insert into CURRICULUM_CLASF (uniqueid, curriculum_id, name, acad_clasf_id, nr_students, ord)
values (238635, 238634, '02', 62, 2, 1);
insert into CURRICULUM_CLASF (uniqueid, curriculum_id, name, acad_clasf_id, nr_students, ord)
values (238644, 238634, '01', 61, 4, 0);
insert into CURRICULUM_CLASF (uniqueid, curriculum_id, name, acad_clasf_id, nr_students, ord)
values (238655, 238654, '01', 61, 5, 0);
insert into CURRICULUM_CLASF (uniqueid, curriculum_id, name, acad_clasf_id, nr_students, ord)
values (238665, 238654, '02', 62, 4, 1);
commit;
prompt 6 records loaded
prompt Loading CURRICULUM_COURSE...
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238621, 135762, 238620, 1, 3);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238622, 135761, 238620, 1, 2);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238623, 135753, 238620, 1, 1);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238624, 135765, 238620, .5, 0);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238625, 135774, 238620, .5, 5);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238626, 135773, 238620, 1, 4);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238628, 135768, 238627, 1, 3);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238629, 135758, 238627, 1, 1);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238630, 135760, 238627, 1, 2);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238631, 135765, 238627, .5, 4);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238632, 135755, 238627, 1, 0);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238633, 135775, 238627, .5, 5);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238636, 135763, 238635, .5, 3);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238637, 135771, 238635, .5, 1);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238638, 135773, 238635, .5, 7);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238639, 135761, 238635, .5, 2);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238640, 135757, 238635, 1, 4);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238641, 135758, 238635, 1, 0);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238642, 135762, 238635, .5, 5);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238643, 135772, 238635, .5, 6);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238645, 135761, 238644, .5, 4);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238646, 135754, 238644, .25, 7);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238647, 135755, 238644, .25, 8);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238648, 135757, 238644, .25, 6);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238649, 135760, 238644, 1, 1);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238650, 135763, 238644, .5, 5);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238651, 135758, 238644, 1, 0);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238652, 135764, 238644, .75, 3);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238653, 135771, 238644, .75, 2);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238656, 135775, 238655, .2, 8);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238657, 135760, 238655, 1, 2);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238658, 135772, 238655, .2, 7);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238659, 135755, 238655, 1, 0);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238660, 135758, 238655, .6, 3);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238661, 135765, 238655, .2, 6);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238662, 135763, 238655, 1, 1);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238663, 135769, 238655, .6, 4);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238664, 135766, 238655, .2, 5);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238666, 135773, 238665, .25, 14);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238667, 135760, 238665, .25, 2);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238668, 135770, 238665, .5, 9);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238669, 135761, 238665, .5, 8);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238670, 135754, 238665, .25, 10);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238671, 135766, 238665, .5, 4);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238672, 135774, 238665, .25, 15);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238673, 135772, 238665, .25, 6);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238674, 135767, 238665, .25, 11);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238675, 135758, 238665, .25, 3);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238676, 135765, 238665, .25, 5);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238677, 135768, 238665, .25, 12);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238678, 135763, 238665, .5, 1);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238679, 135775, 238665, .25, 7);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238680, 135771, 238665, .25, 13);
insert into CURRICULUM_COURSE (uniqueid, course_id, cur_clasf_id, pr_share, ord)
values (238681, 135755, 238665, .5, 0);
commit;
prompt 54 records loaded
prompt Loading CURRICULUM_GROUP...
prompt Table is empty
prompt Loading CURRICULUM_COURSE_GROUP...
prompt Table is empty
prompt Loading POS_MAJOR...
insert into POS_MAJOR (uniqueid, code, name, external_uid, session_id)
values (1201, 'M1', 'Major 1', 'M1', 231379);
insert into POS_MAJOR (uniqueid, code, name, external_uid, session_id)
values (1204, 'M2', 'Major 2', 'M2', 231379);
insert into POS_MAJOR (uniqueid, code, name, external_uid, session_id)
values (1205, 'M3', 'Major 3', 'M3', 231379);
insert into POS_MAJOR (uniqueid, code, name, external_uid, session_id)
values (1207, 'M1', 'Major 1', 'M1', 223206);
insert into POS_MAJOR (uniqueid, code, name, external_uid, session_id)
values (1208, 'M2', 'Major 2', 'M2', 223206);
insert into POS_MAJOR (uniqueid, code, name, external_uid, session_id)
values (1209, 'M3', 'Major 3', 'M3', 223206);
commit;
prompt 6 records loaded
prompt Loading CURRICULUM_MAJOR...
insert into CURRICULUM_MAJOR (curriculum_id, major_id)
values (238619, 1205);
insert into CURRICULUM_MAJOR (curriculum_id, major_id)
values (238634, 1204);
insert into CURRICULUM_MAJOR (curriculum_id, major_id)
values (238654, 1201);
commit;
prompt 3 records loaded
prompt Loading CURRICULUM_RULE...
prompt Table is empty
prompt Loading DATE_PATTERN_DEPT...
prompt Table is empty
prompt Loading DEMAND_OFFR_TYPE...
prompt Table is empty
prompt Loading TIMETABLE_MANAGER...
insert into TIMETABLE_MANAGER (uniqueid, external_uid, first_name, middle_name, last_name, email_address, last_modified_time)
values (470, '1', 'Abraham', null, 'Root', 'demo@unitime.org', null);
insert into TIMETABLE_MANAGER (uniqueid, external_uid, first_name, middle_name, last_name, email_address, last_modified_time)
values (471, '2', 'Adam', null, 'Guest', 'demo@unitime.org', null);
insert into TIMETABLE_MANAGER (uniqueid, external_uid, first_name, middle_name, last_name, email_address, last_modified_time)
values (472, '3', 'Large', 'Lecture', 'Room', 'demo@unitime.org', null);
insert into TIMETABLE_MANAGER (uniqueid, external_uid, first_name, middle_name, last_name, email_address, last_modified_time)
values (473, '4', 'Schedule', null, 'Deputy', 'demo@unitime.org', null);
insert into TIMETABLE_MANAGER (uniqueid, external_uid, first_name, middle_name, last_name, email_address, last_modified_time)
values (490, '5', 'Manager', null, 'Exam', 'demo@unitime.org', null);
insert into TIMETABLE_MANAGER (uniqueid, external_uid, first_name, middle_name, last_name, email_address, last_modified_time)
values (510, '6', 'Event', null, 'Manager', 'demo@unitime.org', null);
insert into TIMETABLE_MANAGER (uniqueid, external_uid, first_name, middle_name, last_name, email_address, last_modified_time)
values (530, '7', 'Manager', null, 'Curriculum', 'demo@unitime.org', null);
commit;
prompt 7 records loaded
prompt Loading DEPT_TO_TT_MGR...
insert into DEPT_TO_TT_MGR (timetable_mgr_id, department_id)
values (470, 226199);
insert into DEPT_TO_TT_MGR (timetable_mgr_id, department_id)
values (470, 231382);
insert into DEPT_TO_TT_MGR (timetable_mgr_id, department_id)
values (471, 226216);
insert into DEPT_TO_TT_MGR (timetable_mgr_id, department_id)
values (471, 231384);
insert into DEPT_TO_TT_MGR (timetable_mgr_id, department_id)
values (472, 226199);
insert into DEPT_TO_TT_MGR (timetable_mgr_id, department_id)
values (472, 231382);
insert into DEPT_TO_TT_MGR (timetable_mgr_id, department_id)
values (473, 223207);
insert into DEPT_TO_TT_MGR (timetable_mgr_id, department_id)
values (473, 231383);
insert into DEPT_TO_TT_MGR (timetable_mgr_id, department_id)
values (510, 223207);
insert into DEPT_TO_TT_MGR (timetable_mgr_id, department_id)
values (510, 226199);
insert into DEPT_TO_TT_MGR (timetable_mgr_id, department_id)
values (510, 226216);
insert into DEPT_TO_TT_MGR (timetable_mgr_id, department_id)
values (510, 231382);
insert into DEPT_TO_TT_MGR (timetable_mgr_id, department_id)
values (510, 231383);
insert into DEPT_TO_TT_MGR (timetable_mgr_id, department_id)
values (510, 231384);
insert into DEPT_TO_TT_MGR (timetable_mgr_id, department_id)
values (530, 231383);
commit;
prompt 15 records loaded
prompt Loading DESIGNATOR...
prompt Table is empty
prompt Loading DISTRIBUTION_TYPE...
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (205, 'BTB_DAY', 'Back-To-Back Day', '0', 26, 'P43210R', 'Classes must be offered on adjacent days and may be placed in different rooms.<BR>When prohibited or (strongly) discouraged: classes can not be taught on adjacent days. They also can not be taught on the same days. This means that there must be at least one day between these classes.', 'BTB Day', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (206, 'MIN_GRUSE(10x1h)', 'Minimize Use Of 1h Groups', '0', 27, 'P43210R', 'Minimize number of groups of time that are used by the given classes. The time is spread into the following 10 groups of one hour: 7:30a-8:30a, 8:30a-9:30a, 9:30a-10:30a, ... 4:30p-5:30p.', 'Min 1h Groups', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (207, 'MIN_GRUSE(5x2h)', 'Minimize Use Of 2h Groups', '0', 28, 'P43210R', 'Minimize number of groups of time that are used by the given classes. The time is spread into the following 5 groups of two hours: 7:30a-9:30a, 9:30a-11:30a, 11:30a-1:30p, 1:30p-3:30p, 3:30p-5:30p.', 'Min 2h Groups', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (208, 'MIN_GRUSE(3x3h)', 'Minimize Use Of 3h Groups', '0', 29, 'P43210R', 'Minimize number of groups of time that are used by the given classes. The time is spread into the following 3 groups: 7:30a-10:30a, 10:30a-2:30p, 2:30p-5:30p.', 'Min 3h Groups', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (209, 'MIN_GRUSE(2x5h)', 'Minimize Use Of 5h Groups', '0', 30, 'P43210R', 'Minimize number of groups of time that are used by the given classes. The time is spread into the following 2 groups: 7:30a-12:30a, 12:30a-5:30p.', 'Min 5h Groups', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (161, 'SAME_STUDENTS', 'Same Students', '0', 20, '210R', 'Given classes are treated as they are attended by the same students, i.e., they cannot overlap in time and if they are back-to-back the assigned rooms cannot be too far (student limit is used).', 'Same Students', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (162, 'SAME_INSTR', 'Same Instructor', '0', 21, '210R', 'Given classes are treated as they are taught by the same instructor, i.e., they cannot overlap in time and if they are back-to-back the assigned rooms cannot be too far (instructor limit is used).<BR>If the constraint is required and the classes are back-to-back, discouraged and strongly discouraged distances between assigned rooms are also considered.', 'Same Instr', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (163, 'CAN_SHARE_ROOM', 'Can Share Room', '0', 22, '2R', 'Given classes can share the room (use the room in the same time) if the room is big enough.', 'Share Room', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (164, 'SPREAD', 'Spread In Time', '0', 23, '2R', 'Given classes have to be spread in time (overlapping of the classes in time needs to be minimized).', 'Time Spread', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (185, 'MIN_ROOM_USE', 'Minimize Number Of Rooms Used', '0', 25, 'P43210R', 'Minimize number of rooms used by the given set of classes.', 'Min Rooms', 1, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (165, 'PRECEDENCE', 'Precedence', '1', 24, 'P43210R', 'Given classes have to be taught in the given order (the first meeting of the first class has to end before the first meeting of the second class etc.)<BR>When prohibited or (strongly) discouraged: classes have to be taught in the order reverse to the given one', 'Precede', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (61, 'BTB', 'Back-To-Back & Same Room', '0', 1, 'P43210R', 'Classes must be offered in adjacent time segments and must be placed in the same room. Given classes must also be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes cannot be back-to-back. There must be at least half-hour between these classes, and they must be taught on the same days and in the same room.', 'BTB Same Room', 1, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (62, 'BTB_TIME', 'Back-To-Back', '0', 2, 'P43210R', 'Classes must be offered in adjacent time segments but may be placed in different rooms. Given classes must also be taught on the same days.<BR>When prohibited or (strongly) discouraged: no pair of classes can be taught back-to-back. They may not overlap in time, but must be taught on the same days. This means that there must be at least half-hour between these classes. ', 'BTB', 1, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (63, 'SAME_TIME', 'Same Time', '0', 3, 'P43210R', 'Given classes must be taught at the same time of day (independent of the actual day the classes meet). For the classes of the same length, this is the same constraint as <i>same start</i>. For classes of different length, the shorter one cannot start before, nor end after, the longer one.<BR>When prohibited or (strongly) discouraged: one class may not meet on any day at a time of day that overlaps with that of the other. For example, one class can not meet M 7:30 while the other meets F 7:30. Note the difference here from the <i>different time</i> constraint that only prohibits the actual class meetings from overlapping.', 'Same Time', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (64, 'SAME_DAYS', 'Same Days', '0', 4, 'P43210R', 'Given classes must be taught on the same days. In case of classes of different time patterns, a class with fewer meetings must meet on a subset of the days used by the class with more meetings. For example, if one class pattern is 3x50, all others given in the constraint can only be taught on Monday, Wednesday, or Friday. For a 2x100 class MW, MF, WF is allowed but TTh is prohibited.<BR>When prohibited or (strongly) discouraged: any pair of classes classes cannot be taught on the same days (cannot overlap in days). For instance, if one class is MFW, the second has to be TTh.', 'Same Days', 1, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (65, 'NHB(1)', '1 Hour Between', '0', 5, 'P43210R', 'Given classes must have exactly 1 hour in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 1 hour in between. They may not overlap in time but must be taught on the same days.', '1h Btw', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (66, 'NHB(2)', '2 Hours Between', '0', 6, 'P43210R', 'Given classes must have exactly 2 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 2 hours in between. They may not overlap in time but must be taught on the same days.', '2h Btw', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (67, 'NHB(3)', '3 Hours Between', '0', 7, 'P43210R', 'Given classes must have exactly 3 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 3 hours in between. They may not overlap in time but must be taught on the same days.', '3h Btw', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (68, 'NHB(4)', '4 Hours Between', '0', 8, 'P43210R', 'Given classes must have exactly 4 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 4 hours in between. They may not overlap in time but must be taught on the same days.', '4h Btw', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (69, 'NHB(5)', '5 Hours Between', '0', 9, 'P43210R', 'Given classes must have exactly 5 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 5 hours in between. They may not overlap in time but must be taught on the same days.', '5h Btw', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (70, 'NHB(6)', '6 Hours Between', '0', 10, 'P43210R', 'Given classes must have exactly 6 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 6 hours in between. They may not overlap in time but must be taught on the same days.', '6h Btw', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (71, 'NHB(7)', '7 Hours Between', '0', 11, 'P43210R', 'Given classes must have exactly 7 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 7 hours in between. They may not overlap in time but must be taught on the same days.', '7h Btw', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (72, 'NHB(8)', '8 Hours Between', '0', 12, 'P43210R', 'Given classes must have exactly 8 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 8 hours in between. They may not overlap in time but must be taught on the same days.', '8h Btw', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (73, 'DIFF_TIME', 'Different Time', '0', 13, 'P43210R', 'Given classes cannot overlap in time. They may be taught at the same time of day if they are on different days. For instance, MF 7:30 is compatible with TTh 7:30.<BR>When prohibited or (strongly) discouraged: every pair of classes in the constraint must overlap in time.', 'Diff Time', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (74, 'NHB(1.5)', '90 Minutes Between', '0', 14, 'P43210R', 'Given classes must have exactly 90 minutes in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 90 minutes in between. They may not overlap in time but must be taught on the same days.', '90min Btw', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (75, 'NHB(4.5)', '4.5 Hours Between', '0', 15, 'P43210R', 'Given classes must have exactly 4.5 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 4.5 hours in between. They may not overlap in time but must be taught on the same days.', '4.5h Btw', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (101, 'SAME_ROOM', 'Same Room', '0', 17, 'P43210R', 'Given classes must be taught in the same room.<BR>When prohibited or (strongly) discouraged: any pair of classes in the constraint cannot be taught in the same room.', 'Same Room', 1, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (102, 'NHB_GTE(1)', 'At Least 1 Hour Between', '0', 18, 'P43210R', 'Given classes have to have 1 hour or more in between.<BR>When prohibited or (strongly) discouraged: given classes have to have less than 1 hour in between.', '>=1h Btw', 1, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (103, 'SAME_START', 'Same Start Time', '0', 16, 'P43210R', 'Given classes must start during the same half-hour period of a day (independent of the actual day the classes meet). For instance, MW 7:30 is compatible with TTh 7:30 but not with MWF 8:00.<BR>When prohibited or (strongly) discouraged: any pair of classes in the given constraint cannot start during the same half-hour period of any day of the week.', 'Same Start', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (104, 'NHB_LT(6)', 'Less Than 6 Hours Between', '0', 19, 'P43210R', 'Given classes must have less than 6 hours from end of first class to the beginning of the next.  Given classes must also be taught on the same days.<BR>When prohibited or (strongly) discouraged: given classes must have 6 or more hours between. This constraint does not carry over from classes taught at the end of one day to the beginning of the next.', '<6h Btw', 1, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (345, 'CH_NOTOVERLAP', 'Children Cannot Overlap', '0', 33, '210R', 'If parent classes do not overlap in time, children classes can not overlap in time as well.<br>Note: This constraint only needs to be put on the parent classes. Preferred configurations are Required All Classes or Pairwise (Strongly) Preferred.', 'Ch No Ovlap', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (305, 'NDB_GT_1', 'More Than 1 Day Between', '0', 32, 'P43210R', 'Given classes must have two or more days in between.<br>When prohibited or (strongly) discouraged: given classes must be offered on adjacent days or with at most one day in between.', '>1d Btw', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (365, 'FOLLOWING_DAY', 'Next Day', '1', 34, 'P43210R', 'The second class has to be placed on the following day of the first class (if the first class is on Friday, second class have to be on Monday).<br> When prohibited or (strongly) discouraged: The second class has to be placed on the previous day of the first class (if the first class is on Monday, second class have to be on Friday).<br> Note: This constraint works only between pairs of classes.', 'Next Day', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (366, 'EVERY_OTHER_DAY', 'Two Days After', '1', 35, 'P43210R', 'The second class has to be placed two days after the first class (Monday &rarr; Wednesday, Tuesday &rarr; Thurday, Wednesday &rarr; Friday, Thursday &rarr; Monday, Friday &rarr; Tuesday).<br> When prohibited or (strongly) discouraged: The second class has to be placed two days before the first class (Monday &rarr; Thursday, Tuesday &rarr; Friday, Wednesday &rarr; Monday, Thursday &rarr; Tuesday, Friday &rarr; Wednesday).<br> Note: This constraint works only between pairs of classes.', '2d After', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (367, 'MEET_WITH', 'Meet Together', '0', 31, '2R', 'Given classes are meeting together (same as if the given classes require constraints Can Share Room, Same Room, Same Time and Same Days all together).', 'Meet Together', 0, 0);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (405, 'EX_SAME_PER', 'Same Period', '0', 36, 'P43210R', 'Exams are to be placed at the same period. <BR>When prohibited or (strongly) discouraged: exams are to be placed at different periods.', 'Same Per', 0, 1);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (406, 'EX_SAME_ROOM', 'Same Room', '0', 37, 'P43210R', 'Exams are to be placed at the same room(s). <BR>When prohibited or (strongly) discouraged: exams are to be placed at different rooms.', 'Same Room', 0, 1);
insert into DISTRIBUTION_TYPE (uniqueid, reference, label, sequencing_required, req_id, allowed_pref, description, abbreviation, instructor_pref, exam_pref)
values (407, 'EX_PRECEDENCE', 'Precedence', '1', 38, 'P43210R', 'Exams are to be placed in the given order. <BR>When prohibited or (strongly) discouraged: exams are to be placed in the order reverse to the given one.', 'Precede', 0, 1);
commit;
prompt 38 records loaded
prompt Loading DISTRIBUTION_PREF...
insert into DISTRIBUTION_PREF (uniqueid, owner_id, pref_level_id, dist_type_id, grouping, last_modified_time, uid_rolled_fwd_from)
values (121720, 223206, 2, 407, -1, null, null);
insert into DISTRIBUTION_PREF (uniqueid, owner_id, pref_level_id, dist_type_id, grouping, last_modified_time, uid_rolled_fwd_from)
values (121721, 223206, 1, 406, -1, null, null);
insert into DISTRIBUTION_PREF (uniqueid, owner_id, pref_level_id, dist_type_id, grouping, last_modified_time, uid_rolled_fwd_from)
values (121722, 223206, 7, 405, -1, null, null);
insert into DISTRIBUTION_PREF (uniqueid, owner_id, pref_level_id, dist_type_id, grouping, last_modified_time, uid_rolled_fwd_from)
values (121723, 223206, 1, 406, -1, null, null);
insert into DISTRIBUTION_PREF (uniqueid, owner_id, pref_level_id, dist_type_id, grouping, last_modified_time, uid_rolled_fwd_from)
values (123392, 231379, 1, 406, -1, null, null);
insert into DISTRIBUTION_PREF (uniqueid, owner_id, pref_level_id, dist_type_id, grouping, last_modified_time, uid_rolled_fwd_from)
values (123393, 231379, 7, 405, -1, null, null);
insert into DISTRIBUTION_PREF (uniqueid, owner_id, pref_level_id, dist_type_id, grouping, last_modified_time, uid_rolled_fwd_from)
values (123394, 231379, 7, 405, -1, null, null);
insert into DISTRIBUTION_PREF (uniqueid, owner_id, pref_level_id, dist_type_id, grouping, last_modified_time, uid_rolled_fwd_from)
values (123395, 231379, 2, 407, -1, null, null);
insert into DISTRIBUTION_PREF (uniqueid, owner_id, pref_level_id, dist_type_id, grouping, last_modified_time, uid_rolled_fwd_from)
values (123396, 231379, 1, 406, -1, null, null);
commit;
prompt 9 records loaded
prompt Loading DISTRIBUTION_OBJECT...
insert into DISTRIBUTION_OBJECT (uniqueid, dist_pref_id, sequence_number, pref_group_id, last_modified_time)
values (5732, 121720, 1, 230634, null);
insert into DISTRIBUTION_OBJECT (uniqueid, dist_pref_id, sequence_number, pref_group_id, last_modified_time)
values (5733, 121720, 2, 230623, null);
insert into DISTRIBUTION_OBJECT (uniqueid, dist_pref_id, sequence_number, pref_group_id, last_modified_time)
values (5734, 121721, 1, 230684, null);
insert into DISTRIBUTION_OBJECT (uniqueid, dist_pref_id, sequence_number, pref_group_id, last_modified_time)
values (5735, 121721, 2, 230687, null);
insert into DISTRIBUTION_OBJECT (uniqueid, dist_pref_id, sequence_number, pref_group_id, last_modified_time)
values (5736, 121722, 3, 230620, null);
insert into DISTRIBUTION_OBJECT (uniqueid, dist_pref_id, sequence_number, pref_group_id, last_modified_time)
values (5737, 121722, 2, 230617, null);
insert into DISTRIBUTION_OBJECT (uniqueid, dist_pref_id, sequence_number, pref_group_id, last_modified_time)
values (5738, 121722, 1, 230614, null);
insert into DISTRIBUTION_OBJECT (uniqueid, dist_pref_id, sequence_number, pref_group_id, last_modified_time)
values (5739, 121723, 2, 230604, null);
insert into DISTRIBUTION_OBJECT (uniqueid, dist_pref_id, sequence_number, pref_group_id, last_modified_time)
values (5740, 121723, 1, 230597, null);
insert into DISTRIBUTION_OBJECT (uniqueid, dist_pref_id, sequence_number, pref_group_id, last_modified_time)
values (5752, 123392, 1, 231698, null);
insert into DISTRIBUTION_OBJECT (uniqueid, dist_pref_id, sequence_number, pref_group_id, last_modified_time)
values (5753, 123392, 2, 231733, null);
insert into DISTRIBUTION_OBJECT (uniqueid, dist_pref_id, sequence_number, pref_group_id, last_modified_time)
values (5754, 123394, 2, 231736, null);
insert into DISTRIBUTION_OBJECT (uniqueid, dist_pref_id, sequence_number, pref_group_id, last_modified_time)
values (5755, 123394, 1, 231727, null);
insert into DISTRIBUTION_OBJECT (uniqueid, dist_pref_id, sequence_number, pref_group_id, last_modified_time)
values (5756, 123394, 3, 231688, null);
insert into DISTRIBUTION_OBJECT (uniqueid, dist_pref_id, sequence_number, pref_group_id, last_modified_time)
values (5757, 123395, 1, 231722, null);
insert into DISTRIBUTION_OBJECT (uniqueid, dist_pref_id, sequence_number, pref_group_id, last_modified_time)
values (5758, 123395, 2, 231702, null);
insert into DISTRIBUTION_OBJECT (uniqueid, dist_pref_id, sequence_number, pref_group_id, last_modified_time)
values (5759, 123396, 2, 231694, null);
insert into DISTRIBUTION_OBJECT (uniqueid, dist_pref_id, sequence_number, pref_group_id, last_modified_time)
values (5760, 123396, 1, 231690, null);
commit;
prompt 18 records loaded
prompt Loading DIST_TYPE_DEPT...
prompt Table is empty
prompt Loading EVENT_CONTACT...
insert into EVENT_CONTACT (uniqueid, external_id, email, phone, firstname, middlename, lastname)
values (226645, '1', 'test-admin@unitime.org', 'unknown', 'Abraham', null, 'Root');
insert into EVENT_CONTACT (uniqueid, external_id, email, phone, firstname, middlename, lastname)
values (230841, '5', 'demo-exam@unitime.org', 'unknown', 'Manager', null, 'Exam');
insert into EVENT_CONTACT (uniqueid, external_id, email, phone, firstname, middlename, lastname)
values (231314, 'null', 'test-event@unitime.org', null, 'Event', null, 'Manager');
commit;
prompt 3 records loaded
prompt Loading EXAM_PERIOD...
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226560, 223206, 0, 96, 24, 4, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226562, 223206, 0, 138, 12, 4, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226564, 223206, 0, 156, 36, 4, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226566, 223206, 1, 96, 24, 4, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226568, 223206, 1, 138, 12, 4, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226570, 223206, 1, 156, 36, 4, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226574, 223206, 2, 96, 24, 4, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226576, 223206, 2, 138, 12, 4, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226581, 223206, -105, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226582, 223206, -105, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226583, 223206, -104, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226584, 223206, -104, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226585, 223206, -103, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226586, 223206, -103, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226587, 223206, -96, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226588, 223206, -96, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226589, 223206, -95, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226590, 223206, -95, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226591, 223206, -91, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226592, 223206, -91, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226593, 223206, -90, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226594, 223206, -90, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226595, 223206, -89, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226596, 223206, -89, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226597, 223206, -84, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226598, 223206, -84, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226599, 223206, -83, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226600, 223206, -83, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226601, 223206, -82, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226602, 223206, -82, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226603, 223206, -77, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226604, 223206, -77, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226605, 223206, -76, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226606, 223206, -76, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226607, 223206, -75, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226608, 223206, -75, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226609, 223206, -70, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226610, 223206, -70, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226611, 223206, -69, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226612, 223206, -69, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226613, 223206, -68, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226614, 223206, -68, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226615, 223206, -56, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226616, 223206, -56, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226617, 223206, -55, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226618, 223206, -55, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226619, 223206, -54, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226620, 223206, -54, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226621, 223206, -49, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226622, 223206, -49, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226623, 223206, -48, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226624, 223206, -48, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226625, 223206, -47, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226626, 223206, -47, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226627, 223206, -42, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226628, 223206, -42, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226629, 223206, -41, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226630, 223206, -41, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226631, 223206, -40, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226632, 223206, -40, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226633, 223206, -35, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226634, 223206, -35, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226635, 223206, -34, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226636, 223206, -34, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226637, 223206, -33, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226638, 223206, -33, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226639, 223206, -28, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226640, 223206, -28, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226641, 223206, -27, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226642, 223206, -27, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226643, 223206, -26, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (226644, 223206, -26, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (230770, 223206, 3, 96, 24, 6, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (230772, 223206, 3, 138, 12, 6, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (230774, 223206, 2, 156, 36, 5, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231579, 231379, 0, 96, 24, 4, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231580, 231379, 0, 138, 12, 4, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231581, 231379, 0, 156, 36, 4, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231582, 231379, 1, 96, 24, 4, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231583, 231379, 1, 138, 12, 4, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231584, 231379, 1, 156, 36, 4, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231585, 231379, 2, 96, 24, 4, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231586, 231379, 2, 138, 12, 4, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231587, 231379, 2, 156, 36, 5, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231588, 231379, 3, 96, 24, 6, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231589, 231379, 3, 138, 12, 6, 0, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231590, 231379, -105, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231591, 231379, -105, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231592, 231379, -104, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231593, 231379, -104, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231594, 231379, -103, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231595, 231379, -103, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231596, 231379, -96, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231597, 231379, -96, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231598, 231379, -95, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231599, 231379, -95, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231600, 231379, -91, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231601, 231379, -91, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231602, 231379, -90, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231603, 231379, -90, 240, 24, 4, 1, 0, 0);
commit;
prompt 100 records committed...
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231604, 231379, -89, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231605, 231379, -89, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231606, 231379, -84, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231607, 231379, -84, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231608, 231379, -83, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231609, 231379, -83, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231610, 231379, -82, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231611, 231379, -82, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231612, 231379, -77, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231613, 231379, -77, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231614, 231379, -76, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231615, 231379, -76, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231616, 231379, -75, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231617, 231379, -75, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231618, 231379, -70, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231619, 231379, -70, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231620, 231379, -69, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231621, 231379, -69, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231622, 231379, -68, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231623, 231379, -68, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231624, 231379, -56, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231625, 231379, -56, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231626, 231379, -55, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231627, 231379, -55, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231628, 231379, -54, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231629, 231379, -54, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231630, 231379, -49, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231631, 231379, -49, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231632, 231379, -48, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231633, 231379, -48, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231634, 231379, -47, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231635, 231379, -47, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231636, 231379, -42, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231637, 231379, -42, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231638, 231379, -41, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231639, 231379, -41, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231640, 231379, -40, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231641, 231379, -40, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231642, 231379, -35, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231643, 231379, -35, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231644, 231379, -34, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231645, 231379, -34, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231646, 231379, -33, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231647, 231379, -33, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231648, 231379, -28, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231649, 231379, -28, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231650, 231379, -27, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231651, 231379, -27, 240, 24, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231652, 231379, -26, 222, 12, 4, 1, 0, 0);
insert into EXAM_PERIOD (uniqueid, session_id, date_ofs, start_slot, length, pref_level_id, exam_type, event_start_offset, event_stop_offset)
values (231653, 231379, -26, 240, 24, 4, 1, 0, 0);
commit;
prompt 150 records loaded
prompt Loading EXAM...
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230331, 223206, 'ALG 101', null, 120, 2, 1, 226566, '0:0:0', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230335, 223206, 'BAND 101', null, 60, 1, 0, 226562, '0:0:-4', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230338, 223206, null, null, 180, 4, 1, 230774, '1:0:0:0', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230342, 223206, null, null, 180, 4, 1, 226564, '0:0:0:0', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230584, 223206, null, null, 180, 4, 1, 226564, '0:0:0:0', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230597, 223206, 'C S 101', null, 60, 1, 0, 226568, '0:0:0', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230604, 223206, null, null, 60, 2, 0, 230772, '0:0:-4:0', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230611, 223206, null, null, 60, 2, 1, 226562, '-2:0:0', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230614, 223206, null, null, 120, 1, 0, 226570, '0:0:0', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230617, 223206, null, null, 120, 1, 0, 226566, '0:0:-4', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230620, 223206, null, null, 120, 1, 0, 226560, '0:0:-4', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230623, 223206, 'COM 101 Lec 3, 4, 5, 6', null, 60, 2, 1, 226570, '0:2:-4:-4', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230634, 223206, 'COM 101 Lec 1, 2, 7, 8', null, 60, 2, 1, 226574, '0:2:-4:-4', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230650, 223206, 'ECON 101', null, 120, 1, 0, 230770, '2:0:0', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230653, 223206, 'ENGL 101', null, 60, 4, 0, 226576, '0:0:0:0:0', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231055, 223206, 'ALG 101', null, 60, 1, 1, 226583, '-2:0:-100', 1, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230684, 223206, 'POL 101 Lec 1', null, 120, 1, 0, 226560, '-2:0:0', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230670, 223206, 'PHIL 101 Lec 1; SOC 101 Lec 1', null, 120, 1, 1, 226560, '0:0:0', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230678, 223206, 'SOC 101 Lec 2', null, 120, 1, 1, 226566, '0:0:-4', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230681, 223206, 'PSY 101', null, 120, 2, 1, 226564, '0:0:-100', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230687, 223206, 'POL 101 Lec 2', null, 120, 1, 0, 230774, '0:0:-4', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230690, 223206, 'ENGR 101 Lec 1', null, 120, 1, 1, 226570, '0:0:0', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230693, 223206, 'GER 101 Lec 1; SPAN 101 Lec 2', null, 60, 1, 1, 230770, '2:0:0', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230697, 223206, 'GER 101 Lec 2; SPAN 101 Lec 1', null, 60, 1, 1, 226574, '2:0:0', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230701, 223206, 'MBIO 101 Lec 1', null, 120, 1, 1, 226566, '0:0:0', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230704, 223206, 'PHYS 101 Lec 1', null, 120, 1, 1, 230774, '1:0:0', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (230707, 223206, 'PHYS 101 Lec 2', null, 120, 1, 1, 226574, '0:0:0', 0, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231058, 223206, 'ALG 101', null, 60, 1, 1, 226593, '-2:0:-100', 1, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231061, 223206, 'ALG 101', null, 120, 1, 1, 226636, '-2:0:-100', 1, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231070, 223206, 'ENGL 101', null, 120, 4, 1, 226594, '-1:2:0:0', 1, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231073, 223206, 'ENGL 101', null, 120, 4, 1, 226638, '-1:2:0:0', 1, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231095, 223206, 'BIOL 101', null, 120, 4, 1, 226624, '0:0:0:0:0', 1, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231086, 223206, 'SOC 101; SPAN 101', null, 120, 1, 1, 226596, '0:0:0', 1, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231090, 223206, 'SOC 101; SPAN 101', null, 120, 1, 1, 226626, '0:0:0', 1, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231098, 223206, 'CALC 101', null, 120, 4, 1, 226588, '0:0:0:0:0', 1, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231101, 223206, 'CALC 101', null, 120, 4, 1, 226618, '0:0:0:0:0', 1, null, null, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231654, 231379, 'ALG 101', null, 120, 1, 1, 231643, '0:0:-100', 1, 55, 231061, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231656, 231379, 'CALC 101', null, 120, 4, 1, 231597, '0:0:0:0:0', 1, 37, 231101, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231658, 231379, 'SOC 101; SPAN 101', null, 120, 1, 1, 231617, '-1:0:0', 1, 15, 231086, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231661, 231379, 'ALG 101', null, 60, 1, 1, 231614, '-2:0:-100', 1, 12, 231058, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231663, 231379, 'SOC 101; SPAN 101', null, 120, 1, 1, 231637, '-1:0:0', 1, 45, 231090, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231666, 231379, 'CALC 101', null, 120, 4, 1, 231631, '0:0:0:0:0', 1, 7, 231098, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231668, 231379, 'ENGL 101', null, 120, 4, 1, 231599, '-1:0:0:0', 1, 13, 231070, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231670, 231379, 'ENGL 101', null, 120, 4, 1, 231613, 'R:0:0:0', 1, 57, 231073, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231672, 231379, 'BIOL 101', null, 120, 4, 1, 231633, '0:0:0:0:0', 1, 43, 231095, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231674, 231379, 'ALG 101', null, 60, 1, 1, 231632, '-2:0:-100', 1, 2, 231055, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231676, 231379, 'BIOL 101 ', null, 180, 4, 1, 231581, '0:0:0', 0, 8, 230338, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231678, 231379, 'GER 101 Lec 2; SPAN 101 Lec 1', null, 60, 1, 1, 231588, '2:0:0', 0, 9, 230693, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231681, 231379, 'BIOL 101 ', null, 180, 4, 1, 231581, '0:0:-4:0', 0, 2, 230342, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231683, 231379, 'ENGR 101 Lec 1', null, 120, 1, 1, 231579, '0:0:0', 0, 5, 230690, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231685, 231379, 'GER 101 Lec 1; SPAN 101 Lec 2', null, 60, 1, 1, 231583, '0:0:0', 0, 6, 230697, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231688, 231379, 'CHM 101 Lec 3', null, 120, 1, 0, 231584, '0:0:-4', 0, 3, 230617, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231690, 231379, 'POL 101 Lec 1', null, 120, 1, 0, 231579, '-2:0:-4', 0, 8, 230687, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231692, 231379, 'ALG 101', null, 120, 2, 1, 231584, '0:0:0', 0, 3, 230331, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231694, 231379, 'POL 101 Lec 2', null, 120, 1, 0, 231585, '-2:0:-4', 0, 0, 230684, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231696, 231379, 'ECON 101', null, 120, 1, 0, 231579, '0:0:0', 0, 9, 230650, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231698, 231379, 'C S 101', null, 60, 1, 0, 231580, '0:0:0', 0, 4, 230597, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231700, 231379, 'BIOL 101 ', null, 180, 4, 1, 231581, '0:0:0', 0, 2, 230584, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231702, 231379, 'COM 101 Lec 2, 4, 8, 9', null, 60, 2, 1, 231585, '0:0:-4', 0, 5, 230623, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231707, 231379, 'ENGL 101', null, 60, 4, 0, 231586, '0:0:0:0:0', 0, 7, 230653, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231709, 231379, 'CALC 101 Lec 3', null, 60, 2, 1, 231582, '0:0:-4:0', 0, 1, 230611, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231711, 231379, 'MBIO 101 Lec 1', null, 120, 1, 1, 231584, '0:0:0', 0, 3, 230701, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231713, 231379, 'BAND 101', null, 60, 1, 0, 231582, '0:0:0', 0, 1, 230335, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231715, 231379, 'PHIL 101 Lec 1; SOC 101 Lec 2', null, 120, 1, 1, 231585, '0:0:0', 0, 0, 230670, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231718, 231379, 'SOC 101 Lec 1', null, 120, 1, 1, 231579, '0:0:-4', 0, 3, 230678, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231720, 231379, 'PSY 101', null, 120, 2, 1, 231582, '0:0:-100', 0, 2, 230681, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231722, 231379, 'COM 101 Lec 1, 3, 6, 7', null, 60, 2, 1, 231580, '0:0:-4:-4', 0, 6, 230634, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231727, 231379, 'CHM 101 Lec 1', null, 120, 1, 0, 231588, '2:0:-4', 0, 5, 230614, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231729, 231379, 'PHYS 101 Lec 2', null, 120, 1, 1, 231587, '1:0:0', 0, 8, 230704, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231731, 231379, 'PHYS 101 Lec 1', null, 120, 1, 1, 231584, '0:0:0', 0, 6, 230707, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231733, 231379, 'CALC 101 Lec 1, 2', null, 60, 2, 0, 231589, '0:0:-4:0', 0, 10, 230604, null, null);
insert into EXAM (uniqueid, session_id, name, note, length, max_nbr_rooms, seating_type, assigned_period, assigned_pref, exam_type, avg_period, uid_rolled_fwd_from, exam_size, print_offset)
values (231736, 231379, 'CHM 101 Lec 2', null, 120, 1, 0, 231585, '0:0:-4', 0, 0, 230620, null, null);
commit;
prompt 72 records loaded
prompt Loading SPONSORING_ORGANIZATION...
prompt Table is empty
prompt Loading EVENT...
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (226646, 'BIOL 101 Pso 3', 4, 4, null, 226645, 223973, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (226663, 'BIOL 101 Lec 3', 4, 4, null, 226645, 223900, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (226695, 'BIOL 101 Lec 2', 4, 4, null, 226645, 223899, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (226727, 'BIOL 101 Pso 2', 4, 4, null, 226645, 223927, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (226744, 'CALC 101 Lec 2', 4, 4, null, 226645, 223956, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (226790, 'BIOL 101 Pso 1', 4, 4, null, 226645, 223926, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (226807, 'CALC 101 Lec 1', 4, 4, null, 226645, 223869, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (226853, 'CHM 101 Lec 1', 4, 4, null, 226645, 223256, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (226885, 'CALC 101 Lec 3', 4, 4, null, 226645, 223957, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (226931, 'CHM 101 Lec 2', 4, 4, null, 226645, 223257, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (226962, 'BIOL 101 Lec 1', 4, 4, null, 226645, 223240, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (226994, 'PHAR 101 Lec 1', 4, 4, null, 226645, 224022, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227010, 'BAND 101 Lec 1', 4, 4, null, 226645, 223249, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227086, 'CHM 101 Lec 3', 4, 4, null, 226645, 223258, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227117, 'MBIO 101 Lec 1', 3, 3, null, 226645, 224057, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227149, 'PSY 101 Lec 1', 4, 4, null, 226645, 223363, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227195, 'ECON 101 Lec 1', 4, 4, null, 226645, 223291, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227227, 'ENGL 101 Lec 7', 1, 1, null, 226645, 223316, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227273, 'ENGL 101 Lec 8', 1, 1, null, 226645, 223317, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227319, 'BIOL 101 Rec 8', 1, 1, null, 226645, 223909, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227336, 'ENGL 101 Lec 9', 1, 1, null, 226645, 223318, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227382, 'BIOL 101 Rec 7', 1, 1, null, 226645, 223908, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227398, 'ENGL 101 Lec 10', 1, 1, null, 226645, 223319, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227444, 'BIOL 101 Rec 6', 1, 1, null, 226645, 223907, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227461, 'BIOL 101 Rec 5', 1, 1, null, 226645, 223906, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227478, 'BIOL 101 Rec 4', 1, 1, null, 226645, 223905, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227495, 'BIOL 101 Rec 3', 1, 1, null, 226645, 223904, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227512, 'ENGL 101 Lec 6', 1, 1, null, 226645, 223315, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227558, 'BIOL 101 Rec 2', 1, 1, null, 226645, 223903, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227575, 'BIOL 101 Rec 1', 1, 1, null, 226645, 223902, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227592, 'ENGL 101 Lec 5', 1, 1, null, 226645, 223314, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227638, 'ENGL 101 Lec 4', 1, 1, null, 226645, 223313, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227684, 'ENGL 101 Lec 1', 1, 1, null, 226645, 223310, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227730, 'ENGL 101 Lec 3', 1, 1, null, 226645, 223312, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227776, 'ENGL 101 Lec 2', 1, 1, null, 226645, 223311, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227822, 'BIOL 101 Lab 7', 1, 1, null, 226645, 223920, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227839, 'BIOL 101 Lab 4', 1, 1, null, 226645, 223917, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227856, 'BIOL 101 Lab 3', 1, 1, null, 226645, 223916, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227873, 'BIOL 101 Lab 6', 1, 1, null, 226645, 223919, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227890, 'BIOL 101 Lab 5', 1, 1, null, 226645, 223918, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227907, 'BIOL 101 Rec 11', 1, 1, null, 226645, 223977, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227924, 'BIOL 101 Rec 10', 1, 1, null, 226645, 223976, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227941, 'BIOL 101 Lab 2', 1, 1, null, 226645, 223915, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227958, 'BIOL 101 Lab 1', 1, 1, null, 226645, 223914, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227975, 'BIOL 101 Rec 9', 1, 1, null, 226645, 223910, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (227992, 'ALG 101 Lec 1', 2, 2, null, 226645, 223884, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228038, 'ENGL 101 Lab 5', 1, 1, null, 226645, 223855, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228055, 'ENGL 101 Lab 4', 1, 1, null, 226645, 223854, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228072, 'ENGL 101 Lab 3', 1, 1, null, 226645, 223853, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228089, 'ENGL 101 Lab 2', 1, 1, null, 226645, 223852, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228106, 'ENGL 101 Lab 1', 1, 1, null, 226645, 223851, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228123, 'C S 101 Lab 1', 1, 1, null, 226645, 223949, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228140, 'C S 101 Lec 2', 2, 2, null, 226645, 223947, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228171, 'C S 101 Lec 1', 2, 2, null, 226645, 223245, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228202, 'BIOL 101 Lab 9', 1, 1, null, 226645, 223922, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228219, 'BIOL 101 Lab 8', 1, 1, null, 226645, 223921, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228236, 'BIOL 101 Lab 11', 1, 1, null, 226645, 223979, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228253, 'BIOL 101 Lab 10', 1, 1, null, 226645, 223978, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228270, 'CALC 101 Rec 3', 1, 1, null, 226645, 223959, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228287, 'CALC 101 Rec 2', 1, 1, null, 226645, 223958, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228304, 'CALC 101 Rec 4', 1, 1, null, 226645, 223960, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228321, 'C S 101 Lab 2', 1, 1, null, 226645, 223950, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228338, 'C S 101 Lab 4', 1, 1, null, 226645, 223970, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228355, 'C S 101 Lab 3', 1, 1, null, 226645, 223951, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228372, 'CALC 101 Rec 1', 1, 1, null, 226645, 223870, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228389, 'CALC 101 Rec 11', 1, 1, null, 226645, 223967, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228406, 'CALC 101 Rec 12', 1, 1, null, 226645, 223968, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228423, 'CALC 101 Rec 9', 1, 1, null, 226645, 223965, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228440, 'CALC 101 Rec 10', 1, 1, null, 226645, 223966, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228457, 'CALC 101 Rec 7', 1, 1, null, 226645, 223963, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228474, 'CALC 101 Rec 8', 1, 1, null, 226645, 223964, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228491, 'CALC 101 Rec 5', 1, 1, null, 226645, 223961, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228508, 'CALC 101 Rec 6', 1, 1, null, 226645, 223962, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228525, 'PHYS 101 Lab 4', 1, 1, null, 226645, 224041, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228541, 'PHYS 101 Lab 5', 1, 1, null, 226645, 224042, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228558, 'PHYS 101 Lab 2', 1, 1, null, 226645, 224039, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228575, 'PHYS 101 Lab 3', 1, 1, null, 226645, 224040, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228591, 'PHYS 101 Rec 5', 1, 1, null, 226645, 224036, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228608, 'PHYS 101 Lab 1', 1, 1, null, 226645, 224038, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228625, 'SOC 101 Lec 1', 2, 2, null, 226645, 223373, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228671, 'POL 101 Lec 1', 2, 2, null, 226645, 223356, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228717, 'POL 101 Lec 2', 2, 2, null, 226645, 224028, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228763, 'CHM 101 Lab 5', 1, 1, null, 226645, 223264, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228780, 'CHM 101 Lab 6', 1, 1, null, 226645, 223265, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228797, 'CHM 101 Lab 7', 1, 1, null, 226645, 223267, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228814, 'CHM 101 Lab 8', 1, 1, null, 226645, 223268, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228831, 'CHM 101 Lab 1', 1, 1, null, 226645, 223259, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228848, 'CHM 101 Lab 2', 1, 1, null, 226645, 223260, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228865, 'CHM 101 Lab 3', 1, 1, null, 226645, 223261, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228882, 'CHM 101 Lab 4', 1, 1, null, 226645, 223263, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228899, 'CHM 101 Lab 9', 1, 1, null, 226645, 223269, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228916, 'MBIO 101 Lab 3', 1, 1, null, 226645, 224061, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228932, 'PHIL 101 Lec 1', 2, 2, null, 226645, 223344, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228964, 'PHYS 101 Lec 1', 3, 3, null, 226645, 223350, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (228996, 'MBIO 101 Lab 2', 1, 1, null, 226645, 224060, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229012, 'PHYS 101 Rec 4', 1, 1, null, 226645, 224035, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229029, 'CHM 101 Lab 11', 1, 1, null, 226645, 223818, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229046, 'CHM 101 Lab 10', 1, 1, null, 226645, 223817, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229063, 'PHYS 101 Lec 2', 2, 2, null, 226645, 223351, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229094, 'PHYS 101 Rec 1', 1, 1, null, 226645, 224032, null, 0, null, null, null);
commit;
prompt 100 records committed...
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229110, 'PHYS 101 Rec 2', 1, 1, null, 226645, 224033, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229127, 'PHYS 101 Rec 3', 1, 1, null, 226645, 224034, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229144, 'CHM 101 Rec 2', 1, 1, null, 226645, 223825, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229161, 'CHM 101 Rec 3', 1, 1, null, 226645, 223826, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229178, 'CHM 101 Lab 12', 1, 1, null, 226645, 223819, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229195, 'CHM 101 Rec 1', 1, 1, null, 226645, 223824, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229212, 'CHM 101 Rec 6', 1, 1, null, 226645, 223829, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229229, 'CHM 101 Rec 7', 1, 1, null, 226645, 223830, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229246, 'CHM 101 Rec 4', 1, 1, null, 226645, 223827, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229263, 'CHM 101 Rec 5', 1, 1, null, 226645, 223828, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229280, 'GER 101 Lab 2', 1, 1, null, 226645, 224006, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229297, 'GER 101 Lab 3', 1, 1, null, 226645, 224007, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229313, 'GER 101 Lec 2', 2, 2, null, 226645, 223325, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229359, 'GER 101 Lab 1', 1, 1, null, 226645, 224005, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229375, 'MBIO 101 Lab 1', 1, 1, null, 226645, 224059, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229391, 'HIST 101 Lec 2', 2, 2, null, 226645, 223331, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229437, 'CHM 101 Rec 10', 1, 1, null, 226645, 223833, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229453, 'LING 101 Lec 1', 2, 2, null, 226645, 224017, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229499, 'CHM 101 Rec 9', 1, 1, null, 226645, 223832, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229516, 'GER 101 Lab 4', 1, 1, null, 226645, 224008, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229533, 'CHM 101 Rec 8', 1, 1, null, 226645, 223831, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229550, 'HIST 101 Lec 1', 2, 2, null, 226645, 223330, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229582, 'CHM 101 Rec 11', 1, 1, null, 226645, 223834, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229599, 'CHM 101 Rec 12', 1, 1, null, 226645, 223835, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229615, 'COM 101 Lec 1', 1, 1, null, 226645, 223297, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229647, 'COM 101 Lec 2', 1, 1, null, 226645, 223298, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229679, 'COM 101 Lec 3', 1, 1, null, 226645, 223299, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229711, 'COM 101 Lec 4', 1, 1, null, 226645, 223300, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229743, 'COM 101 Lec 5', 1, 1, null, 226645, 223301, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229775, 'SOC 101 Lec 2', 2, 2, null, 226645, 224050, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229821, 'ENGL 101 Lab 6', 1, 1, null, 226645, 223856, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229838, 'SPAN 101 Lec 1', 2, 2, null, 226645, 223378, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229870, 'ENGL 101 Lab 7', 1, 1, null, 226645, 223857, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229887, 'SPAN 101 Lec 2', 2, 2, null, 226645, 223379, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229933, 'ENGL 101 Lab 8', 1, 1, null, 226645, 223858, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229950, 'SPAN 101 Lab 1', 1, 1, null, 226645, 223800, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229967, 'SPAN 101 Lab 2', 1, 1, null, 226645, 223801, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (229984, 'SPAN 101 Lab 3', 1, 1, null, 226645, 223802, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (230001, 'SPAN 101 Lab 4', 1, 1, null, 226645, 223803, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (230018, 'ENGR 101 Lab 2', 1, 1, null, 226645, 223999, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (230034, 'ENGR 101 Lab 3', 1, 1, null, 226645, 224000, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (230051, 'GER 101 Lec 1', 2, 2, null, 226645, 223324, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (230097, 'COM 101 Lec 7', 1, 1, null, 226645, 223303, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (230129, 'ENGL 101 Lab 9', 1, 1, null, 226645, 223859, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (230146, 'COM 101 Lec 6', 1, 1, null, 226645, 223302, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (230178, 'ENGL 101 Lab 10', 1, 1, null, 226645, 223860, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (230195, 'COM 101 Lec 9', 1, 1, null, 226645, 223305, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (230227, 'ENGR 101 Lec 1', 3, 3, null, 226645, 223996, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (230259, 'COM 101 Lec 8', 1, 1, null, 226645, 223304, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (230291, 'ENGR 101 Lab 1', 1, 1, null, 226645, 223998, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231209, 'ALG 101', 2, 2, null, 230841, null, 230331, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231211, 'BAND 101', 3, 3, null, 230841, null, 230335, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231213, 'BIOL 101 Lec 1', 3, 3, null, 230841, null, 230338, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231216, 'BIOL 101 Lec 3', 3, 3, null, 230841, null, 230342, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231219, 'BIOL 101 Lec 2', 4, 4, null, 230841, null, 230584, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231222, 'C S 101', 4, 4, null, 230841, null, 230597, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231224, 'CALC 101 Lec 1, 2', 8, 8, null, 230841, null, 230604, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231227, 'CALC 101 Lec 3', 4, 4, null, 230841, null, 230611, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231229, 'CHM 101 Lec 1', 4, 4, null, 230841, null, 230614, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231231, 'CHM 101 Lec 2', 4, 4, null, 230841, null, 230617, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231233, 'CHM 101 Lec 3', 4, 4, null, 230841, null, 230620, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231235, 'COM 101 Lec 3, 4, 5, 6', 4, 4, null, 230841, null, 230623, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231238, 'COM 101 Lec 1, 2, 7, 8', 4, 4, null, 230841, null, 230634, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231241, 'ECON 101', 4, 4, null, 230841, null, 230650, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231243, 'ENGL 101', 10, 10, null, 230841, null, 230653, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231247, 'POL 101 Lec 1', 2, 2, null, 230841, null, 230684, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231249, 'PHIL 101 Lec 1; SOC 101 Lec 1', 3, 3, null, 230841, null, 230670, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231251, 'SOC 101 Lec 2', 1, 1, null, 230841, null, 230678, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231253, 'PSY 101', 4, 4, null, 230841, null, 230681, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231255, 'POL 101 Lec 2', 2, 2, null, 230841, null, 230687, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231257, 'ENGR 101 Lec 1', 3, 3, null, 230841, null, 230690, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231259, 'GER 101 Lec 1; SPAN 101 Lec 2', 3, 3, null, 230841, null, 230693, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231261, 'GER 101 Lec 2; SPAN 101 Lec 1', 4, 4, null, 230841, null, 230697, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231263, 'MBIO 101 Lec 1', 3, 3, null, 230841, null, 230701, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231265, 'PHYS 101 Lec 1', 3, 3, null, 230841, null, 230704, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231267, 'PHYS 101 Lec 2', 2, 2, null, 230841, null, 230707, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231315, 'Performances', null, null, null, 231314, null, null, 4, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231343, 'ALG 101', 2, 2, null, 226645, null, 231055, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231345, 'ALG 101', 2, 2, null, 226645, null, 231058, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231347, 'ALG 101', 2, 2, null, 226645, null, 231061, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231349, 'ENGL 101', 10, 10, null, 226645, null, 231070, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231352, 'ENGL 101', 10, 10, null, 226645, null, 231073, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231355, 'BIOL 101', 11, 11, null, 226645, null, 231095, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231359, 'SOC 101; SPAN 101', 8, 8, null, 226645, null, 231086, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231361, 'SOC 101; SPAN 101', 8, 8, null, 226645, null, 231090, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231363, 'CALC 101', 12, 12, null, 226645, null, 231098, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (231367, 'CALC 101', 12, 12, null, 226645, null, 231101, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233325, 'CHM 101 Lab 4', 1, 1, null, 226645, 231468, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233341, 'CHM 101 Lab 5', 1, 1, null, 226645, 231460, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233357, 'CHM 101 Lab 2', 1, 1, null, 226645, 231466, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233373, 'CHM 101 Lab 3', 1, 1, null, 226645, 231467, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233389, 'CHM 101 Lab 8', 1, 1, null, 226645, 231465, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233405, 'CHM 101 Lab 9', 1, 1, null, 226645, 231464, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233421, 'CHM 101 Lab 6', 1, 1, null, 226645, 231462, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233437, 'CHM 101 Lab 7', 1, 1, null, 226645, 231463, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233453, 'CHM 101 Lab 12', 1, 1, null, 226645, 231471, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233469, 'CHM 101 Rec 1', 1, 1, null, 226645, 231480, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233485, 'CHM 101 Lab 10', 1, 1, null, 226645, 231469, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233501, 'CHM 101 Lab 11', 1, 1, null, 226645, 231470, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233517, 'CHM 101 Rec 4', 1, 1, null, 226645, 231479, null, 0, null, null, null);
commit;
prompt 200 records committed...
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233532, 'CHM 101 Rec 5', 1, 1, null, 226645, 231483, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233548, 'CHM 101 Rec 2', 1, 1, null, 226645, 231477, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233564, 'CHM 101 Rec 3', 1, 1, null, 226645, 231484, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233580, 'CALC 101 Rec 4', 1, 1, null, 226645, 231451, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233596, 'CALC 101 Rec 3', 1, 1, null, 226645, 231449, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233612, 'CALC 101 Rec 2', 1, 1, null, 226645, 231445, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233627, 'CALC 101 Rec 1', 1, 1, null, 226645, 231441, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233643, 'CALC 101 Rec 8', 1, 1, null, 226645, 231452, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233659, 'CALC 101 Rec 7', 1, 1, null, 226645, 231448, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233675, 'CALC 101 Rec 6', 1, 1, null, 226645, 231446, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233691, 'CALC 101 Rec 5', 1, 1, null, 226645, 231443, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233707, 'CALC 101 Rec 12', 1, 1, null, 226645, 231450, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233723, 'CALC 101 Rec 11', 1, 1, null, 226645, 231447, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233739, 'CALC 101 Rec 10', 1, 1, null, 226645, 231444, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233755, 'CALC 101 Rec 9', 1, 1, null, 226645, 231442, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233771, 'CHM 101 Lab 1', 1, 1, null, 226645, 231461, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233787, 'BIOL 101 Lab 8', 1, 1, null, 226645, 231406, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233803, 'BIOL 101 Lab 9', 1, 1, null, 226645, 231407, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233819, 'BIOL 101 Lab 10', 1, 1, null, 226645, 231408, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233835, 'BIOL 101 Lab 11', 1, 1, null, 226645, 231409, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233851, 'C S 101 Lec 1', 2, 2, null, 226645, 231434, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233881, 'C S 101 Lec 2', 2, 2, null, 226645, 231435, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233911, 'C S 101 Lab 1', 1, 1, null, 226645, 231429, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233927, 'C S 101 Lab 2', 1, 1, null, 226645, 231430, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233943, 'C S 101 Lab 3', 1, 1, null, 226645, 231431, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233959, 'C S 101 Lab 4', 1, 1, null, 226645, 231432, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233974, 'BIOL 101 Rec 4', 1, 1, null, 226645, 231414, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (233989, 'BIOL 101 Rec 3', 1, 1, null, 226645, 231413, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234005, 'BIOL 101 Rec 6', 1, 1, null, 226645, 231416, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234021, 'BIOL 101 Rec 5', 1, 1, null, 226645, 231415, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234037, 'BIOL 101 Rec 8', 1, 1, null, 226645, 231418, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234053, 'BIOL 101 Rec 7', 1, 1, null, 226645, 231417, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234069, 'BIOL 101 Rec 10', 1, 1, null, 226645, 231420, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234085, 'BIOL 101 Rec 9', 1, 1, null, 226645, 231419, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234101, 'BIOL 101 Lab 1', 1, 1, null, 226645, 231399, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234117, 'BIOL 101 Rec 11', 1, 1, null, 226645, 231421, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234133, 'BIOL 101 Lab 3', 1, 1, null, 226645, 231401, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234149, 'BIOL 101 Lab 2', 1, 1, null, 226645, 231400, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234165, 'BIOL 101 Lab 5', 1, 1, null, 226645, 231403, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234181, 'BIOL 101 Lab 4', 1, 1, null, 226645, 231402, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234197, 'BIOL 101 Lab 7', 1, 1, null, 226645, 231405, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234213, 'BIOL 101 Lab 6', 1, 1, null, 226645, 231404, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234229, 'PHIL 101 Lec 1', 2, 2, null, 226645, 231547, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234274, 'MBIO 101 Lab 2', 1, 1, null, 226645, 231542, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234289, 'MBIO 101 Lab 3', 1, 1, null, 226645, 231543, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234304, 'MBIO 101 Lab 1', 1, 1, null, 226645, 231541, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234319, 'HIST 101 Lec 2', 2, 2, null, 226645, 231535, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234364, 'LING 101 Lec 1', 2, 2, null, 226645, 231537, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234409, 'PHYS 101 Rec 5', 1, 1, null, 226645, 231555, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234424, 'PHYS 101 Lab 1', 1, 1, null, 226645, 231560, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234440, 'PHYS 101 Rec 3', 1, 1, null, 226645, 231552, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234456, 'PHYS 101 Rec 4', 1, 1, null, 226645, 231554, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234471, 'PHYS 101 Rec 1', 1, 1, null, 226645, 231553, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234487, 'PHYS 101 Rec 2', 1, 1, null, 226645, 231556, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234503, 'PHYS 101 Lec 1', 2, 2, null, 226645, 231549, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234534, 'PHYS 101 Lec 2', 3, 3, null, 226645, 231550, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234565, 'ENGR 101 Lab 2', 1, 1, null, 226645, 231521, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234580, 'ENGR 101 Lab 1', 1, 1, null, 226645, 231520, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234596, 'ENGR 101 Lec 1', 3, 3, null, 226645, 231524, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234627, 'ENGL 101 Lab 10', 1, 1, null, 226645, 231517, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234643, 'ENGL 101 Lab 9', 1, 1, null, 226645, 231514, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234659, 'ENGL 101 Lab 8', 1, 1, null, 226645, 231510, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234675, 'ENGL 101 Lab 7', 1, 1, null, 226645, 231509, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234691, 'ENGL 101 Lab 6', 1, 1, null, 226645, 231513, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234706, 'HIST 101 Lec 1', 2, 2, null, 226645, 231534, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234751, 'GER 101 Lab 4', 1, 1, null, 226645, 231530, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234767, 'GER 101 Lab 3', 1, 1, null, 226645, 231529, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234783, 'GER 101 Lab 2', 1, 1, null, 226645, 231532, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234799, 'GER 101 Lab 1', 1, 1, null, 226645, 231531, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234815, 'GER 101 Lec 2', 2, 2, null, 226645, 231527, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234860, 'GER 101 Lec 1', 2, 2, null, 226645, 231526, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234905, 'ENGR 101 Lab 3', 1, 1, null, 226645, 231522, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234921, 'ENGL 101 Lec 4', 1, 1, null, 226645, 231501, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (234966, 'ENGL 101 Lec 5', 1, 1, null, 226645, 231502, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235011, 'ENGL 101 Lec 6', 1, 1, null, 226645, 231503, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235056, 'ENGL 101 Lec 7', 1, 1, null, 226645, 231504, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235101, 'ENGL 101 Lec 1', 1, 1, null, 226645, 231498, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235146, 'ENGL 101 Lec 2', 1, 1, null, 226645, 231499, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235191, 'ENGL 101 Lec 3', 1, 1, null, 226645, 231500, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235236, 'ENGL 101 Lab 2', 1, 1, null, 226645, 231515, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235252, 'ENGL 101 Lab 3', 1, 1, null, 226645, 231518, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235268, 'ENGL 101 Lab 4', 1, 1, null, 226645, 231516, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235283, 'ENGL 101 Lab 5', 1, 1, null, 226645, 231512, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235299, 'ENGL 101 Lec 8', 1, 1, null, 226645, 231505, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235344, 'ENGL 101 Lec 9', 1, 1, null, 226645, 231506, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235389, 'ENGL 101 Lec 10', 1, 1, null, 226645, 231507, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235434, 'ENGL 101 Lab 1', 1, 1, null, 226645, 231511, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235450, 'CHM 101 Rec 11', 1, 1, null, 226645, 231481, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235465, 'CHM 101 Rec 10', 1, 1, null, 226645, 231475, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235481, 'COM 101 Lec 1', 1, 1, null, 226645, 231486, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235512, 'CHM 101 Rec 12', 1, 1, null, 226645, 231482, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235528, 'CHM 101 Rec 7', 1, 1, null, 226645, 231474, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235544, 'CHM 101 Rec 6', 1, 1, null, 226645, 231473, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235560, 'CHM 101 Rec 9', 1, 1, null, 226645, 231476, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235576, 'CHM 101 Rec 8', 1, 1, null, 226645, 231478, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235592, 'COM 101 Lec 7', 1, 1, null, 226645, 231492, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235623, 'COM 101 Lec 6', 1, 1, null, 226645, 231491, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235654, 'COM 101 Lec 9', 1, 1, null, 226645, 231494, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235685, 'COM 101 Lec 8', 1, 1, null, 226645, 231493, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235716, 'COM 101 Lec 3', 1, 1, null, 226645, 231488, null, 0, null, null, null);
commit;
prompt 300 records committed...
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235747, 'COM 101 Lec 2', 1, 1, null, 226645, 231487, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235778, 'COM 101 Lec 5', 1, 1, null, 226645, 231490, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235809, 'COM 101 Lec 4', 1, 1, null, 226645, 231489, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235840, 'SPAN 101 Lec 2', 2, 2, null, 226645, 231573, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235871, 'SPAN 101 Lab 1', 1, 1, null, 226645, 231577, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235887, 'SOC 101 Lec 2', 2, 2, null, 226645, 231570, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235932, 'SPAN 101 Lec 1', 2, 2, null, 226645, 231572, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235963, 'SPAN 101 Lab 4', 1, 1, null, 226645, 231576, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235979, 'SPAN 101 Lab 2', 1, 1, null, 226645, 231578, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (235995, 'SPAN 101 Lab 3', 1, 1, null, 226645, 231575, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236010, 'PHYS 101 Lab 4', 1, 1, null, 226645, 231561, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236026, 'PHYS 101 Lab 5', 1, 1, null, 226645, 231558, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236042, 'PHYS 101 Lab 2', 1, 1, null, 226645, 231562, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236058, 'PHYS 101 Lab 3', 1, 1, null, 226645, 231559, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236074, 'SOC 101 Lec 1', 2, 2, null, 226645, 231569, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236119, 'POL 101 Lec 1', 2, 2, null, 226645, 231564, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236150, 'POL 101 Lec 2', 2, 2, null, 226645, 231565, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236181, 'BIOL 101 Rec 2', 1, 1, null, 226645, 231412, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236197, 'BIOL 101 Rec 1', 1, 1, null, 226645, 231411, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236212, 'ALG 101 Lec 1', 2, 2, null, 226645, 231391, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236257, 'PHAR 101 Lec 1', 4, 4, null, 226645, 231545, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236273, 'BIOL 101 Lec 3', 4, 4, null, 226645, 231397, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236303, 'BIOL 101 Lec 2', 4, 4, null, 226645, 231396, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236334, 'MBIO 101 Lec 1', 3, 3, null, 226645, 231539, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236365, 'ECON 101 Lec 1', 4, 4, null, 226645, 231496, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236410, 'BIOL 101 Lec 1', 4, 4, null, 226645, 231395, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236440, 'BIOL 101 Pso 1', 4, 4, null, 226645, 231423, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236456, 'BAND 101 Lec 1', 4, 4, null, 226645, 231393, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236531, 'BIOL 101 Pso 2', 4, 4, null, 226645, 231424, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236547, 'BIOL 101 Pso 3', 4, 4, null, 226645, 231425, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236563, 'PSY 101 Lec 1', 4, 4, null, 226645, 231567, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236608, 'CALC 101 Lec 1', 4, 4, null, 226645, 231437, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236653, 'CALC 101 Lec 2', 4, 4, null, 226645, 231438, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236698, 'CALC 101 Lec 3', 4, 4, null, 226645, 231439, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236743, 'CHM 101 Lec 3', 4, 4, null, 226645, 231458, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236774, 'CHM 101 Lec 2', 4, 4, null, 226645, 231457, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (236805, 'CHM 101 Lec 1', 4, 4, null, 226645, 231456, null, 0, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239012, 'BIOL 101 ', 4, 4, null, 226645, null, 231676, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239014, 'GER 101 Lec 2; SPAN 101 Lec 1', 4, 4, null, 226645, null, 231678, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239016, 'BIOL 101 ', 4, 4, null, 226645, null, 231681, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239019, 'ENGR 101 Lec 1', 3, 3, null, 226645, null, 231683, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239021, 'GER 101 Lec 1; SPAN 101 Lec 2', 3, 3, null, 226645, null, 231685, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239023, 'CHM 101 Lec 3', 4, 4, null, 226645, null, 231688, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239025, 'POL 101 Lec 1', 2, 2, null, 226645, null, 231690, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239027, 'ALG 101', 2, 2, null, 226645, null, 231692, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239029, 'POL 101 Lec 2', 1, 1, null, 226645, null, 231694, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239031, 'ECON 101', 3, 3, null, 226645, null, 231696, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239033, 'C S 101', 3, 3, null, 226645, null, 231698, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239035, 'BIOL 101 ', 2, 2, null, 226645, null, 231700, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239037, 'COM 101 Lec 2, 4, 8, 9', 2, 2, null, 226645, null, 231702, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239039, 'ENGL 101', 10, 10, null, 226645, null, 231707, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239043, 'CALC 101 Lec 3', 4, 4, null, 226645, null, 231709, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239046, 'MBIO 101 Lec 1', 3, 3, null, 226645, null, 231711, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239048, 'BAND 101', 2, 2, null, 226645, null, 231713, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239050, 'PHIL 101 Lec 1; SOC 101 Lec 2', 3, 3, null, 226645, null, 231715, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239052, 'SOC 101 Lec 1', 1, 1, null, 226645, null, 231718, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239054, 'PSY 101', 4, 4, null, 226645, null, 231720, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239056, 'COM 101 Lec 1, 3, 6, 7', 4, 4, null, 226645, null, 231722, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239059, 'CHM 101 Lec 1', 4, 4, null, 226645, null, 231727, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239061, 'PHYS 101 Lec 2', 3, 3, null, 226645, null, 231729, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239063, 'PHYS 101 Lec 1', 2, 2, null, 226645, null, 231731, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239065, 'CALC 101 Lec 1, 2', 8, 8, null, 226645, null, 231733, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239068, 'CHM 101 Lec 2', 4, 4, null, 226645, null, 231736, 1, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239108, 'ALG 101', 2, 2, null, 226645, null, 231654, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239110, 'CALC 101', 12, 12, null, 226645, null, 231656, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239114, 'SOC 101; SPAN 101', 8, 8, null, 226645, null, 231658, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239116, 'ALG 101', 2, 2, null, 226645, null, 231661, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239118, 'SOC 101; SPAN 101', 8, 8, null, 226645, null, 231663, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239120, 'CALC 101', 12, 12, null, 226645, null, 231666, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239124, 'ENGL 101', 10, 10, null, 226645, null, 231668, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239127, 'ENGL 101', 10, 10, null, 226645, null, 231670, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239130, 'BIOL 101', 11, 11, null, 226645, null, 231672, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239134, 'ALG 101', 2, 2, null, 226645, null, 231674, 2, null, null, null);
insert into EVENT (uniqueid, event_name, min_capacity, max_capacity, sponsoring_org, main_contact_id, class_id, exam_id, event_type, req_attd, email, sponsor_org_id)
values (239136, 'Performances', null, null, null, 231314, null, null, 4, null, null, null);
commit;
prompt 374 records loaded
prompt Loading EVENT_JOIN_EVENT_CONTACT...
prompt Table is empty
prompt Loading EVENT_NOTE...
insert into EVENT_NOTE (uniqueid, event_id, text_note, time_stamp, note_type, uname, meetings)
values (231316, 231315, null, to_date('22-09-2010 14:13:09', 'dd-mm-yyyy hh24:mi:ss'), 0, null, null);
insert into EVENT_NOTE (uniqueid, event_id, text_note, time_stamp, note_type, uname, meetings)
values (239153, 239136, null, to_date('22-09-2010 17:10:14', 'dd-mm-yyyy hh24:mi:ss'), 0, 'A. Root', 'M 08/23 - 09/20 8:00a THTR 101' || chr(10) || 'M 09/27 - 12/06 8:00a THTR 101');
insert into EVENT_NOTE (uniqueid, event_id, text_note, time_stamp, note_type, uname, meetings)
values (239171, 239136, null, to_date('22-09-2010 17:10:19', 'dd-mm-yyyy hh24:mi:ss'), 2, 'A. Root', 'M 08/23 - 09/20 8:00a THTR 101' || chr(10) || 'M 09/27 - 12/06 8:00a THTR 101');
commit;
prompt 3 records loaded
prompt Loading EXACT_TIME_MINS...
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214405, 0, 0, 0, 0);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214406, 1, 5, 1, 0);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214407, 6, 10, 2, 0);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214408, 11, 15, 4, 0);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214409, 16, 20, 5, 0);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214410, 21, 25, 6, 0);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214411, 26, 30, 7, 0);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214412, 31, 35, 8, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214413, 36, 40, 10, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214414, 41, 45, 11, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214415, 46, 50, 12, 10);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214416, 51, 55, 13, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214417, 56, 60, 14, 10);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214418, 61, 65, 16, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214419, 66, 70, 17, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214420, 71, 75, 18, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214421, 76, 80, 19, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214422, 81, 85, 20, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214423, 86, 90, 21, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214424, 91, 95, 23, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214425, 96, 100, 24, 10);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214426, 101, 105, 25, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214427, 106, 110, 26, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214428, 111, 115, 28, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214429, 116, 120, 29, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214430, 121, 125, 30, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214431, 126, 130, 31, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214432, 131, 135, 32, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214433, 136, 140, 34, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214434, 141, 145, 35, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214435, 146, 150, 36, 10);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214436, 151, 155, 37, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214437, 156, 160, 38, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214438, 161, 165, 40, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214439, 166, 170, 41, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214440, 171, 175, 42, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214441, 176, 180, 43, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214442, 181, 185, 44, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214443, 186, 190, 46, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214444, 191, 195, 47, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214445, 196, 200, 48, 10);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214446, 201, 205, 49, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214447, 206, 210, 50, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214448, 211, 215, 52, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214449, 216, 220, 53, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214450, 221, 225, 54, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214451, 226, 230, 55, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214452, 231, 235, 56, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214453, 236, 240, 58, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214454, 241, 245, 59, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214455, 246, 250, 60, 10);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214456, 251, 255, 61, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214457, 256, 260, 62, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214458, 261, 265, 64, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214459, 266, 270, 65, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214460, 271, 275, 66, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214461, 276, 280, 67, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214462, 281, 285, 68, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214463, 286, 290, 70, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214464, 291, 295, 71, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214465, 296, 300, 72, 10);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214466, 301, 305, 73, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214467, 306, 310, 74, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214468, 311, 315, 76, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214469, 316, 320, 77, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214470, 321, 325, 78, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214471, 326, 330, 79, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214472, 331, 335, 80, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214473, 336, 340, 82, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214474, 341, 345, 83, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214475, 346, 350, 84, 10);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214476, 351, 355, 85, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214477, 356, 360, 86, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214478, 361, 365, 88, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214479, 366, 370, 89, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214480, 371, 375, 90, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214481, 376, 380, 91, 5);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214482, 381, 385, 92, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214483, 386, 390, 94, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214484, 391, 395, 95, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214485, 396, 400, 96, 10);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214486, 401, 405, 97, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214487, 406, 410, 98, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214488, 411, 415, 100, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214489, 416, 420, 101, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214490, 421, 425, 102, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214491, 426, 430, 103, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214492, 431, 435, 104, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214493, 436, 440, 106, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214494, 441, 445, 107, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214495, 446, 450, 108, 10);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214496, 451, 455, 109, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214497, 456, 460, 110, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214498, 461, 465, 112, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214499, 466, 470, 113, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214500, 471, 475, 114, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214501, 476, 480, 115, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214502, 481, 485, 116, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214503, 486, 490, 118, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214504, 491, 495, 119, 15);
commit;
prompt 100 records committed...
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214505, 496, 500, 120, 10);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214506, 501, 505, 121, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214507, 506, 510, 122, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214508, 511, 515, 124, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214509, 516, 520, 125, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214510, 521, 525, 126, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214511, 526, 530, 127, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214512, 531, 535, 128, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214513, 536, 540, 130, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214514, 541, 545, 131, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214515, 546, 550, 132, 10);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214516, 551, 555, 133, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214517, 556, 560, 134, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214518, 561, 565, 136, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214519, 566, 570, 137, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214520, 571, 575, 138, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214521, 576, 580, 139, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214522, 581, 585, 140, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214523, 586, 590, 142, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214524, 591, 595, 143, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214525, 596, 600, 144, 10);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214526, 601, 605, 145, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214527, 606, 610, 146, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214528, 611, 615, 148, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214529, 616, 620, 149, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214530, 621, 625, 150, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214531, 626, 630, 151, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214532, 631, 635, 152, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214533, 636, 640, 154, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214534, 641, 645, 155, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214535, 646, 650, 156, 10);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214536, 651, 655, 157, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214537, 656, 660, 158, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214538, 661, 665, 160, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214539, 666, 670, 161, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214540, 671, 675, 162, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214541, 676, 680, 163, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214542, 681, 685, 164, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214543, 686, 690, 166, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214544, 691, 695, 167, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214545, 696, 700, 168, 10);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214546, 701, 705, 169, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214547, 706, 710, 170, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214548, 711, 715, 172, 15);
insert into EXACT_TIME_MINS (uniqueid, mins_min, mins_max, nr_slots, break_time)
values (214549, 716, 720, 173, 15);
commit;
prompt 145 records loaded
prompt Loading EXAM_INSTRUCTOR...
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (230331, 226242);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (230338, 226240);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (230342, 226244);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (230342, 226246);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (230584, 226240);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (230597, 226242);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (230604, 226242);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (230611, 226238);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231055, 226242);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231058, 226242);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231061, 226242);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231095, 226240);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231098, 226238);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231101, 226238);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231654, 231388);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231656, 231385);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231661, 231388);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231666, 231385);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231672, 231389);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231674, 231388);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231676, 231389);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231681, 231389);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231692, 231388);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231698, 231388);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231700, 231386);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231700, 231387);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231709, 231385);
insert into EXAM_INSTRUCTOR (exam_id, instructor_id)
values (231733, 231388);
commit;
prompt 28 records loaded
prompt Loading EXAM_LOCATION_PREF...
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123200, 7986, 6, 230774);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123201, 7986, 6, 226570);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123202, 7986, 6, 226564);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123203, 7986, 7, 226587);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123204, 7986, 7, 226588);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123205, 7986, 7, 226589);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123206, 7986, 7, 226590);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123207, 7986, 7, 226591);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123208, 7986, 7, 226592);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123209, 7986, 7, 226593);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123210, 7986, 7, 226594);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123211, 7986, 7, 226595);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123212, 7986, 7, 226596);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123213, 7986, 7, 226597);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123214, 7986, 7, 226598);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123215, 7986, 7, 226599);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123216, 7986, 7, 226600);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123217, 7986, 7, 226601);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123218, 7986, 7, 226602);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123219, 7986, 7, 226603);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123220, 7986, 7, 226604);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123221, 7986, 7, 226605);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123222, 7986, 7, 226606);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123223, 7986, 7, 226607);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123224, 7986, 7, 226608);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123225, 7987, 7, 230772);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123226, 7987, 7, 230770);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123227, 7989, 7, 226633);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123228, 7989, 7, 226634);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123229, 7989, 7, 226635);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123230, 7989, 7, 226636);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123231, 7989, 7, 226637);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123232, 7989, 7, 226638);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123233, 7989, 7, 226639);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123234, 7989, 7, 226640);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123235, 7989, 7, 226641);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123236, 7989, 7, 226642);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123237, 7989, 7, 226643);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123238, 7989, 7, 226644);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123335, 8020, 7, 231642);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123336, 8020, 7, 231643);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123337, 8020, 7, 231644);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123338, 8020, 7, 231645);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123339, 8020, 7, 231646);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123340, 8020, 7, 231650);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123341, 8020, 7, 231649);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123342, 8020, 7, 231648);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123343, 8020, 7, 231647);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123344, 8020, 7, 231653);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123345, 8020, 7, 231652);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123346, 8020, 7, 231651);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123347, 8024, 7, 231589);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123348, 8024, 7, 231588);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123349, 8023, 7, 231602);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123350, 8023, 7, 231601);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123351, 8023, 7, 231604);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123352, 8023, 7, 231603);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123353, 8023, 7, 231606);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123354, 8023, 7, 231605);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123355, 8023, 7, 231608);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123356, 8023, 7, 231607);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123357, 8023, 6, 231584);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123358, 8023, 6, 231587);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123359, 8023, 7, 231596);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123360, 8023, 6, 231581);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123361, 8023, 7, 231598);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123362, 8023, 7, 231597);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123363, 8023, 7, 231600);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123364, 8023, 7, 231599);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123365, 8023, 7, 231617);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123366, 8023, 7, 231609);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123367, 8023, 7, 231610);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123368, 8023, 7, 231611);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123369, 8023, 7, 231612);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123370, 8023, 7, 231613);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123371, 8023, 7, 231614);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123372, 8023, 7, 231615);
insert into EXAM_LOCATION_PREF (uniqueid, location_id, pref_level_id, period_id)
values (123373, 8023, 7, 231616);
commit;
prompt 78 records loaded
prompt Loading EXAM_OWNER...
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230946, 230604, 223956, 3, 135733);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230744, 230617, 223257, 3, 135719);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230786, 230597, 135717, 1, 135717);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230591, 230331, 132313, 0, 135715);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230593, 230584, 223899, 3, 135716);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230582, 230338, 223240, 3, 135716);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230364, 230335, 135718, 1, 135718);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230751, 230634, 223304, 3, 135721);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230752, 230634, 223298, 3, 135721);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230740, 230614, 223256, 3, 135719);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230742, 230620, 223258, 3, 135719);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230746, 230623, 223302, 3, 135721);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (231198, 231090, 135732, 1, 135732);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230762, 230653, 135722, 1, 135722);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (231185, 231095, 135716, 1, 135716);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230784, 230342, 223900, 3, 135716);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (231199, 231090, 135731, 1, 135731);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230671, 230670, 223344, 3, 135726);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230672, 230670, 223373, 3, 135731);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230725, 230693, 223379, 3, 135732);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230947, 230604, 223869, 3, 135733);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230679, 230678, 224050, 3, 135731);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230726, 230693, 223324, 3, 135723);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230691, 230690, 223996, 3, 135736);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230942, 230684, 223356, 3, 135728);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230944, 230687, 224028, 3, 135728);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230949, 230611, 223957, 3, 135733);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (231189, 231101, 135733, 1, 135733);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230747, 230623, 223299, 3, 135721);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230723, 230681, 135729, 1, 135729);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230728, 230697, 223378, 3, 135732);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230729, 230697, 223325, 3, 135723);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (231187, 231098, 135733, 1, 135733);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230702, 230701, 224057, 3, 135739);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230705, 230704, 223350, 3, 135727);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230708, 230707, 223351, 3, 135727);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (231191, 231070, 135722, 1, 135722);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230748, 230623, 223301, 3, 135721);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230749, 230623, 223300, 3, 135721);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230753, 230634, 223303, 3, 135721);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230754, 230634, 223297, 3, 135721);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (230758, 230650, 135720, 1, 135720);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (231193, 231073, 135722, 1, 135722);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (231195, 231086, 135731, 1, 135731);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (231179, 231055, 135715, 1, 135715);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (231181, 231058, 135715, 1, 135715);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (231183, 231061, 135715, 1, 135715);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (231196, 231086, 135732, 1, 135732);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (239078, 231674, 135753, 1, 135753);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (239090, 231670, 135763, 1, 135763);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (239086, 231666, 135758, 1, 135758);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (239092, 231658, 135774, 1, 135774);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (239095, 231663, 135775, 1, 135775);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (239096, 231663, 135774, 1, 135774);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (239088, 231668, 135763, 1, 135763);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (239080, 231654, 135753, 1, 135753);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238907, 231713, 135754, 1, 135754);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238960, 231731, 231549, 3, 135771);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238962, 231729, 231550, 3, 135771);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238920, 231733, 231438, 3, 135758);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238955, 231711, 231539, 3, 135768);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238957, 231715, 231570, 3, 135774);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238958, 231715, 231547, 3, 135770);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238938, 231702, 231489, 3, 135761);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238968, 231720, 135773, 1, 135773);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238911, 231676, 231396, 3, 135755);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (239082, 231672, 135755, 1, 135755);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238949, 231685, 231573, 3, 135775);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238921, 231733, 231437, 3, 135758);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238909, 231681, 231395, 3, 135755);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238945, 231707, 135763, 1, 135763);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238947, 231683, 231524, 3, 135764);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238950, 231685, 231526, 3, 135765);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238952, 231678, 231572, 3, 135775);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238953, 231678, 231527, 3, 135765);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238927, 231727, 231456, 3, 135760);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238964, 231690, 231564, 3, 135772);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238915, 231698, 135757, 1, 135757);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238966, 231694, 231565, 3, 135772);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238970, 231718, 231569, 3, 135774);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (239076, 231661, 135753, 1, 135753);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (239084, 231656, 135758, 1, 135758);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (239093, 231658, 135775, 1, 135775);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238931, 231688, 231458, 3, 135760);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238933, 231722, 231488, 3, 135761);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238925, 231709, 231439, 3, 135758);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238939, 231702, 231487, 3, 135761);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238929, 231736, 231457, 3, 135760);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238905, 231692, 132351, 0, 135753);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238913, 231700, 231397, 3, 135755);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238934, 231722, 231486, 3, 135761);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238935, 231722, 231491, 3, 135761);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238936, 231722, 231492, 3, 135761);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238940, 231702, 231493, 3, 135761);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238941, 231702, 231494, 3, 135761);
insert into EXAM_OWNER (uniqueid, exam_id, owner_id, owner_type, course_id)
values (238943, 231696, 135762, 1, 135762);
commit;
prompt 96 records loaded
prompt Loading EXAM_PERIOD_PREF...
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (121659, 230693, 7, 226576);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (121660, 230697, 6, 226574);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (121662, 230697, 7, 226576);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (121605, 230331, 3, 226564);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (121607, 230331, 3, 226560);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (121608, 230331, 3, 226562);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (121724, 230684, 2, 226560);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (121657, 230693, 6, 226574);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (121728, 230687, 3, 226576);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (121726, 230687, 3, 230774);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (121729, 230687, 2, 226574);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (121678, 230650, 7, 226576);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (121681, 230650, 7, 226574);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (121730, 230604, 2, 230772);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (121733, 230611, 2, 226562);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123160, 231055, 4, 226584);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123161, 231055, 3, 226585);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123162, 231055, 4, 226586);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123163, 231055, 2, 226583);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123164, 231055, 3, 226581);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123166, 231055, 4, 226582);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123167, 231058, 2, 226593);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123168, 231058, 3, 226595);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123169, 231058, 4, 226596);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123171, 231058, 4, 226594);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123172, 231058, 4, 226592);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123173, 231058, 3, 226591);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123174, 231061, 4, 226634);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123175, 231061, 4, 226638);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123177, 231061, 2, 226636);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123178, 231095, 4, 226626);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123179, 231095, 4, 226624);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123180, 231095, 4, 226622);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123181, 231098, 4, 226590);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123182, 231098, 4, 226588);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123183, 231101, 4, 226620);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123184, 231101, 4, 226616);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123185, 231101, 4, 226618);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123186, 231070, 3, 226596);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123187, 231070, 4, 226592);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123188, 231070, 3, 226594);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123189, 231073, 3, 226638);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123190, 231073, 4, 226636);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123191, 231073, 4, 226634);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123192, 231086, 4, 226592);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123193, 231086, 4, 226594);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123194, 231086, 4, 226596);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123195, 231090, 4, 226624);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123196, 231090, 4, 226626);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123197, 231090, 4, 226622);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123422, 231696, 7, 231586);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123408, 231733, 2, 231589);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123430, 231678, 6, 231585);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123412, 231709, 2, 231580);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123423, 231696, 7, 231585);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123426, 231685, 7, 231586);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123397, 231692, 3, 231581);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123398, 231692, 3, 231580);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123400, 231692, 3, 231579);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123427, 231685, 6, 231585);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123431, 231678, 7, 231586);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123437, 231690, 2, 231579);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123438, 231694, 2, 231585);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123439, 231694, 3, 231587);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123440, 231694, 3, 231586);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123478, 231674, 4, 231631);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123479, 231654, 3, 231646);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123481, 231654, 4, 231647);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123482, 231654, 4, 231643);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123483, 231654, 4, 231645);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123484, 231654, 3, 231642);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123489, 231656, 4, 231599);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123490, 231656, 4, 231597);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123491, 231666, 4, 231633);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123492, 231666, 4, 231631);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123493, 231666, 4, 231635);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123494, 231668, 3, 231599);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123495, 231668, 4, 231597);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123496, 231670, 4, 231613);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123497, 231658, 3, 231617);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123498, 231658, 4, 231615);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123499, 231658, 4, 231613);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123500, 231663, 4, 231641);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123465, 231661, 3, 231616);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123466, 231661, 4, 231617);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123467, 231661, 4, 231613);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123468, 231661, 2, 231614);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123470, 231661, 4, 231615);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123471, 231661, 3, 231612);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123472, 231674, 3, 231630);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123473, 231674, 3, 231634);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123474, 231674, 2, 231632);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123475, 231674, 4, 231635);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123476, 231674, 4, 231633);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123485, 231654, 2, 231644);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123486, 231672, 4, 231631);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123487, 231672, 4, 231635);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123488, 231672, 4, 231633);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123501, 231663, 4, 231639);
insert into EXAM_PERIOD_PREF (uniqueid, owner_id, pref_level_id, period_id)
values (123502, 231663, 3, 231637);
commit;
prompt 100 records loaded
prompt Loading EXAM_ROOM_ASSIGNMENT...
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230331, 7988);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230335, 7986);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230338, 7986);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230338, 7988);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230342, 7987);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230342, 7989);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230584, 7986);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230584, 7988);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230597, 7994);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230604, 7986);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230604, 7994);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230611, 7994);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230614, 7986);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230617, 7986);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230620, 7986);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230623, 7987);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230623, 7988);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230634, 7987);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230634, 7988);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230650, 7986);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230653, 7986);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230653, 7988);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230653, 7994);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230670, 7994);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230678, 7987);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230681, 7994);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230684, 7987);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230687, 7987);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230690, 7994);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230693, 7994);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230697, 7994);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230701, 7994);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230704, 7994);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (230707, 7986);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231055, 7987);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231058, 7987);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231061, 7987);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231070, 7987);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231070, 7994);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231073, 7986);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231073, 7994);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231086, 7994);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231090, 7994);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231095, 7986);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231095, 7989);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231095, 7994);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231098, 7987);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231098, 7988);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231098, 7994);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231101, 7987);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231101, 7988);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231101, 7994);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231654, 8024);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231656, 8017);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231656, 8019);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231656, 8024);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231658, 8017);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231661, 8024);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231663, 8017);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231666, 8017);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231666, 8019);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231666, 8024);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231668, 8017);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231668, 8024);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231670, 8017);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231670, 8024);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231672, 8017);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231672, 8020);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231672, 8023);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231674, 8024);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231676, 8017);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231678, 8017);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231681, 8023);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231681, 8024);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231683, 8017);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231685, 8017);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231688, 8023);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231690, 8019);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231692, 8024);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231694, 8019);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231696, 8023);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231698, 8017);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231700, 8019);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231702, 8024);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231707, 8017);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231707, 8023);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231707, 8024);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231709, 8019);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231709, 8023);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231711, 8017);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231713, 8024);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231715, 8017);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231718, 8024);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231720, 8017);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231722, 8019);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231722, 8024);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231727, 8023);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231729, 8017);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231731, 8019);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231733, 8017);
commit;
prompt 100 records committed...
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231733, 8023);
insert into EXAM_ROOM_ASSIGNMENT (exam_id, location_id)
values (231736, 8023);
commit;
prompt 102 records loaded
prompt Loading EXTERNAL_BUILDING...
prompt Table is empty
prompt Loading ROOM_TYPE...
insert into ROOM_TYPE (uniqueid, reference, label, ord, is_room)
values (425, 'genClassroom', 'Classrooms', 0, 1);
insert into ROOM_TYPE (uniqueid, reference, label, ord, is_room)
values (426, 'computingLab', 'Computing Laboratories', 1, 1);
insert into ROOM_TYPE (uniqueid, reference, label, ord, is_room)
values (427, 'departmental', 'Additional Instructional Rooms', 2, 1);
insert into ROOM_TYPE (uniqueid, reference, label, ord, is_room)
values (428, 'specialUse', 'Special Use Rooms', 3, 1);
insert into ROOM_TYPE (uniqueid, reference, label, ord, is_room)
values (429, 'nonUniversity', 'Outside Locations', 4, 0);
commit;
prompt 5 records loaded
prompt Loading EXTERNAL_ROOM...
prompt Table is empty
prompt Loading EXTERNAL_ROOM_DEPARTMENT...
prompt Table is empty
prompt Loading EXTERNAL_ROOM_FEATURE...
prompt Table is empty
prompt Loading HISTORY...
prompt Table is empty
prompt Loading INDIVIDUAL_RESERVATION...
prompt Table is empty
prompt Loading JENRL...
prompt Table is empty
prompt Loading LASTLIKE_COURSE_DEMAND...
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224760, 223384, 767, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224761, 223384, 775, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224762, 223384, 766, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224763, 223384, 777, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224764, 223384, 761, '101', 0, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224765, 223385, 761, '101', 0, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224766, 223385, 767, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224767, 223385, 775, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224768, 223385, 766, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224769, 223385, 769, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224770, 223386, 768, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224771, 223386, 775, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224772, 223386, 766, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224773, 223386, 763, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224774, 223386, 771, '101', 0, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224775, 223387, 762, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224776, 223387, 765, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224777, 223387, 771, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224778, 223387, 781, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224779, 223387, 768, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224780, 223388, 762, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224781, 223388, 765, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224782, 223388, 771, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224783, 223388, 781, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224784, 223388, 768, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224785, 223389, 762, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224786, 223389, 765, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224787, 223389, 771, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224788, 223389, 781, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224789, 223389, 768, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224790, 223390, 765, '101', 0, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224791, 223390, 773, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224792, 223390, 779, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224793, 223390, 771, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224794, 223390, 767, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224795, 223390, 764, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224796, 223391, 765, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224797, 223391, 762, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224798, 223391, 779, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224799, 223391, 771, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224800, 223391, 767, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224801, 223392, 765, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224802, 223392, 773, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224803, 223392, 779, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224804, 223392, 771, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224805, 223392, 768, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224806, 223393, 765, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224807, 223393, 773, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224808, 223393, 763, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224809, 223393, 771, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224810, 223393, 768, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224811, 223394, 762, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224812, 223394, 767, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224813, 223394, 774, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224814, 223394, 775, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224815, 223394, 778, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224816, 223395, 768, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224817, 223395, 769, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224818, 223395, 772, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224819, 223395, 770, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224820, 223395, 764, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224821, 223395, 767, '101', 0, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224822, 223396, 777, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224823, 223396, 770, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224824, 223396, 780, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224825, 223396, 772, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224826, 223396, 773, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224827, 223397, 762, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224828, 223397, 782, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224829, 223397, 765, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224830, 223397, 771, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224831, 223397, 768, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224832, 223398, 762, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224833, 223398, 782, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224834, 223398, 765, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224835, 223398, 771, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224836, 223398, 769, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224837, 223399, 762, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224838, 223399, 782, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224839, 223399, 765, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224840, 223399, 771, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224841, 223399, 778, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224842, 223400, 774, '101', 0, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224843, 223400, 762, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224844, 223400, 765, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224845, 223400, 768, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224846, 223400, 778, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224847, 223401, 770, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224848, 223401, 762, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224849, 223401, 765, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224850, 223401, 768, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224851, 223401, 769, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224852, 223402, 763, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224853, 223402, 773, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224854, 223402, 771, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224855, 223402, 767, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (224856, 223402, 774, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231738, 223384, 807, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231739, 223385, 807, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231740, 223386, 802, '101', 4, null);
commit;
prompt 100 records committed...
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231741, 223389, 805, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231742, 223391, 801, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231743, 223392, 816, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231744, 223399, 805, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231745, 223399, 820, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231746, 223401, 811, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231747, 223384, 806, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231748, 223385, 799, '101', 0, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231749, 223388, 805, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231750, 223392, 803, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231751, 223394, 820, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231752, 223395, 811, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231753, 223398, 803, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231754, 223401, 805, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231755, 223402, 806, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231756, 223384, 799, '101', 0, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231757, 223384, 818, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231758, 223384, 819, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231759, 223386, 818, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231760, 223387, 814, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231761, 223390, 803, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231762, 223390, 805, '101', 0, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231763, 223391, 805, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231764, 223392, 808, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231765, 223393, 816, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231766, 223395, 810, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231767, 223398, 801, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231768, 223399, 801, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231769, 223400, 820, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231770, 223401, 801, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231771, 223401, 810, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231772, 223402, 817, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231773, 223385, 806, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231774, 223387, 805, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231775, 223388, 803, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231776, 223388, 808, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231777, 223389, 801, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231778, 223390, 809, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231779, 223393, 805, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231780, 223395, 808, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231781, 223396, 815, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231782, 223396, 816, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231783, 223397, 808, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231784, 223398, 813, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231785, 223400, 817, '101', 0, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231786, 223385, 810, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231787, 223387, 801, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231788, 223387, 803, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231789, 223390, 800, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231790, 223391, 806, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231791, 223391, 809, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231792, 223392, 805, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231793, 223393, 808, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231794, 223394, 806, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231795, 223395, 800, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231796, 223397, 813, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231797, 223400, 805, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231798, 223402, 803, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231801, 223385, 818, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231802, 223386, 803, '101', 0, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231803, 223386, 807, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231804, 223386, 808, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231805, 223388, 801, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231806, 223389, 808, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231807, 223390, 816, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231808, 223391, 803, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231809, 223392, 809, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231810, 223393, 803, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231811, 223395, 806, '101', 0, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231812, 223396, 811, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231813, 223397, 801, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231814, 223397, 803, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231815, 223399, 803, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231816, 223400, 801, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231817, 223402, 816, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231820, 223394, 801, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231821, 223395, 815, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231822, 223396, 812, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231823, 223397, 805, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231824, 223399, 813, '101', 2, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231825, 223401, 808, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231826, 223387, 808, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231827, 223388, 814, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231828, 223389, 803, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231829, 223389, 814, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231830, 223390, 806, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231831, 223393, 802, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231832, 223394, 817, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231833, 223394, 818, '101', 4, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231834, 223396, 819, '101', 1, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231835, 223398, 805, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231836, 223398, 810, '101', 5, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231837, 223400, 808, '101', 3, null);
insert into LASTLIKE_COURSE_DEMAND (uniqueid, student_id, subject_area_id, course_nbr, priority, course_perm_id)
values (231838, 223402, 802, '101', 1, null);
commit;
prompt 194 records loaded
prompt Loading SETTINGS...
insert into SETTINGS (uniqueid, name, default_value, allowed_values, description)
values (148, 'roomFeaturesInOneColumn', 'yes', 'yes,no', 'Display Room Features In One Column');
insert into SETTINGS (uniqueid, name, default_value, allowed_values, description)
values (88, 'jsConfirm', 'yes', 'yes,no', 'Display confirmation dialogs');
insert into SETTINGS (uniqueid, name, default_value, allowed_values, description)
values (85, 'name', 'last-initial', 'last-first,first-last,initial-last,last-initial,first-middle-last,short', 'Instructor name display format');
insert into SETTINGS (uniqueid, name, default_value, allowed_values, description)
values (42, 'timeGrid', 'vertical', 'horizontal,vertical,text', 'Time grid display format');
insert into SETTINGS (uniqueid, name, default_value, allowed_values, description)
values (86, 'cfgAutoCalc', 'yes', 'yes,no', 'Automatically calculate number of classes and room size when editing configuration');
insert into SETTINGS (uniqueid, name, default_value, allowed_values, description)
values (87, 'timeGridSize', 'Workdays x Daytime', 'Workdays x Daytime,All Week x Daytime,Workdays x Evening,All Week x Evening,All Week x All Times', 'Time grid default selection');
insert into SETTINGS (uniqueid, name, default_value, allowed_values, description)
values (89, 'inheritInstrPref', 'never', 'ask,always,never', 'Inherit instructor preferences on a class');
insert into SETTINGS (uniqueid, name, default_value, allowed_values, description)
values (108, 'showVarLimits', 'no', 'yes,no', 'Show the option to set variable class limits');
insert into SETTINGS (uniqueid, name, default_value, allowed_values, description)
values (128, 'keepSort', 'no', 'yes,no', 'Sort classes on detail pages');
insert into SETTINGS (uniqueid, name, default_value, allowed_values, description)
values (168, 'dispLastChanges', 'yes', 'yes,no', 'Display information from the change log in pages.');
insert into SETTINGS (uniqueid, name, default_value, allowed_values, description)
values (188, 'printNoteDisplay', 'icon', 'icon,shortened text,full text', 'Display an icon or shortened text when a class has a schedule print note.');
insert into SETTINGS (uniqueid, name, default_value, allowed_values, description)
values (189, 'crsOffrNoteDisplay', 'icon', 'icon,shortened text,full text', 'Display an icon or shortened text when a course offering has a schedule note.');
insert into SETTINGS (uniqueid, name, default_value, allowed_values, description)
values (190, 'mgrNoteDisplay', 'icon', 'icon,shortened text,full text', 'Display an icon or shortened text when a class has a note to the schedule manager.');
insert into SETTINGS (uniqueid, name, default_value, allowed_values, description)
values (208, 'unitime.menu.style', 'Dynamic On Top', 'Dynamic On Top,Static On Top,Tree On Side,Stack On Side', 'Menu style');
commit;
prompt 14 records loaded
prompt Loading MANAGER_SETTINGS...
prompt Table is empty
prompt Loading MEETING...
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226648, 226646, to_date('17-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226649, 226646, to_date('05-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226650, 226646, to_date('28-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226651, 226646, to_date('05-12-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226652, 226646, to_date('29-08-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226653, 226646, to_date('14-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226654, 226646, to_date('03-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226655, 226646, to_date('22-08-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226656, 226646, to_date('31-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226657, 226646, to_date('07-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226658, 226646, to_date('19-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226659, 226646, to_date('10-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226660, 226646, to_date('12-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226661, 226646, to_date('26-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226662, 226646, to_date('24-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226665, 226663, to_date('06-12-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226666, 226663, to_date('04-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226667, 226663, to_date('11-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226668, 226663, to_date('08-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226669, 226663, to_date('02-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226670, 226663, to_date('23-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226671, 226663, to_date('16-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226672, 226663, to_date('18-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226673, 226663, to_date('25-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226674, 226663, to_date('13-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226675, 226663, to_date('04-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226676, 226663, to_date('27-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226677, 226663, to_date('11-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226678, 226663, to_date('29-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226679, 226663, to_date('04-12-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226680, 226663, to_date('06-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226681, 226663, to_date('06-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226682, 226663, to_date('18-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226683, 226663, to_date('20-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226684, 226663, to_date('30-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226685, 226663, to_date('13-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226686, 226663, to_date('23-08-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226687, 226663, to_date('28-08-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226688, 226663, to_date('20-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226689, 226663, to_date('01-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226690, 226663, to_date('30-08-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226691, 226663, to_date('21-08-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226692, 226663, to_date('25-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226693, 226663, to_date('27-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226694, 226663, to_date('15-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226697, 226695, to_date('04-12-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226698, 226695, to_date('11-10-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226699, 226695, to_date('04-10-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226700, 226695, to_date('13-09-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226701, 226695, to_date('30-10-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226702, 226695, to_date('20-11-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226703, 226695, to_date('01-11-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226704, 226695, to_date('23-08-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226705, 226695, to_date('02-10-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226706, 226695, to_date('21-08-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226707, 226695, to_date('23-10-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226708, 226695, to_date('06-09-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226709, 226695, to_date('13-11-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226710, 226695, to_date('30-08-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226711, 226695, to_date('06-11-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226712, 226695, to_date('18-09-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226713, 226695, to_date('11-09-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226714, 226695, to_date('06-12-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226715, 226695, to_date('29-11-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226716, 226695, to_date('18-10-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226717, 226695, to_date('25-09-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226718, 226695, to_date('15-11-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226719, 226695, to_date('20-09-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226720, 226695, to_date('27-09-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226721, 226695, to_date('04-09-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226722, 226695, to_date('08-11-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226723, 226695, to_date('16-10-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226724, 226695, to_date('25-10-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226725, 226695, to_date('28-08-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226726, 226695, to_date('27-11-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226729, 226727, to_date('06-12-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226730, 226727, to_date('11-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226731, 226727, to_date('27-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226732, 226727, to_date('13-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226733, 226727, to_date('20-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226734, 226727, to_date('18-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226735, 226727, to_date('25-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226736, 226727, to_date('06-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226737, 226727, to_date('15-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226738, 226727, to_date('23-08-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226739, 226727, to_date('04-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226740, 226727, to_date('29-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226741, 226727, to_date('01-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226742, 226727, to_date('08-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226743, 226727, to_date('30-08-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226746, 226744, to_date('29-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226747, 226744, to_date('24-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226748, 226744, to_date('02-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226749, 226744, to_date('01-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226750, 226744, to_date('10-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226751, 226744, to_date('26-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226752, 226744, to_date('03-12-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226753, 226744, to_date('22-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226754, 226744, to_date('19-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226755, 226744, to_date('19-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
commit;
prompt 100 records committed...
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226756, 226744, to_date('16-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226757, 226744, to_date('17-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226758, 226744, to_date('24-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226759, 226744, to_date('31-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226760, 226744, to_date('05-12-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226761, 226744, to_date('09-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226762, 226744, to_date('05-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226763, 226744, to_date('21-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226764, 226744, to_date('28-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226765, 226744, to_date('24-08-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226766, 226744, to_date('15-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226767, 226744, to_date('26-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226768, 226744, to_date('20-08-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226769, 226744, to_date('07-12-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226770, 226744, to_date('26-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226771, 226744, to_date('29-08-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226772, 226744, to_date('07-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226773, 226744, to_date('22-08-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226774, 226744, to_date('17-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226775, 226744, to_date('14-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226776, 226744, to_date('03-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226777, 226744, to_date('27-08-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226778, 226744, to_date('05-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226779, 226744, to_date('07-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226780, 226744, to_date('12-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226781, 226744, to_date('30-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226782, 226744, to_date('28-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226783, 226744, to_date('19-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226784, 226744, to_date('14-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226785, 226744, to_date('12-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226786, 226744, to_date('31-08-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226787, 226744, to_date('10-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226788, 226744, to_date('12-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226789, 226744, to_date('05-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226792, 226790, to_date('25-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226793, 226790, to_date('30-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226794, 226790, to_date('02-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226795, 226790, to_date('21-08-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226796, 226790, to_date('23-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226797, 226790, to_date('28-08-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226798, 226790, to_date('04-12-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226799, 226790, to_date('11-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226800, 226790, to_date('20-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226801, 226790, to_date('04-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226802, 226790, to_date('18-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226803, 226790, to_date('13-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226804, 226790, to_date('16-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226805, 226790, to_date('06-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226806, 226790, to_date('27-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226809, 226807, to_date('24-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226810, 226807, to_date('24-09-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226811, 226807, to_date('28-09-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226812, 226807, to_date('14-09-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226813, 226807, to_date('10-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226814, 226807, to_date('07-11-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226815, 226807, to_date('31-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226816, 226807, to_date('01-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226817, 226807, to_date('02-11-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226818, 226807, to_date('19-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226819, 226807, to_date('31-08-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226820, 226807, to_date('12-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226821, 226807, to_date('12-11-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226822, 226807, to_date('22-08-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226823, 226807, to_date('14-11-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226824, 226807, to_date('20-08-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226825, 226807, to_date('15-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226826, 226807, to_date('12-09-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226827, 226807, to_date('09-11-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226828, 226807, to_date('16-11-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226829, 226807, to_date('07-12-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226830, 226807, to_date('03-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226831, 226807, to_date('10-09-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226832, 226807, to_date('03-12-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226833, 226807, to_date('05-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226834, 226807, to_date('26-11-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226835, 226807, to_date('19-11-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226836, 226807, to_date('26-09-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226837, 226807, to_date('27-08-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226838, 226807, to_date('29-08-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226839, 226807, to_date('19-09-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226840, 226807, to_date('17-09-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226841, 226807, to_date('24-08-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226842, 226807, to_date('05-11-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226843, 226807, to_date('29-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226844, 226807, to_date('07-09-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226845, 226807, to_date('05-12-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226846, 226807, to_date('30-11-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226847, 226807, to_date('05-09-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226848, 226807, to_date('22-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226849, 226807, to_date('17-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226850, 226807, to_date('26-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226851, 226807, to_date('28-11-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226852, 226807, to_date('21-09-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226855, 226853, to_date('16-11-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226856, 226853, to_date('10-10-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226857, 226853, to_date('24-08-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226858, 226853, to_date('26-09-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226859, 226853, to_date('24-10-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226860, 226853, to_date('07-11-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226861, 226853, to_date('28-09-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
commit;
prompt 200 records committed...
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226862, 226853, to_date('14-09-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226863, 226853, to_date('03-10-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226864, 226853, to_date('05-10-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226865, 226853, to_date('12-10-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226866, 226853, to_date('14-11-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226867, 226853, to_date('21-09-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226868, 226853, to_date('31-08-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226869, 226853, to_date('05-09-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226870, 226853, to_date('30-11-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226871, 226853, to_date('28-11-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226872, 226853, to_date('12-09-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226873, 226853, to_date('31-10-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226874, 226853, to_date('29-08-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226875, 226853, to_date('17-10-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226876, 226853, to_date('05-12-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226877, 226853, to_date('07-09-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226878, 226853, to_date('26-10-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226879, 226853, to_date('19-09-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226880, 226853, to_date('02-11-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226881, 226853, to_date('07-12-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226882, 226853, to_date('22-08-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226883, 226853, to_date('19-10-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226884, 226853, to_date('09-11-2007', 'dd-mm-yyyy'), 126, 0, 138, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226887, 226885, to_date('26-10-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226888, 226885, to_date('31-08-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226889, 226885, to_date('14-09-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226890, 226885, to_date('19-10-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226891, 226885, to_date('19-11-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226892, 226885, to_date('24-09-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226893, 226885, to_date('28-11-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226894, 226885, to_date('24-08-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226895, 226885, to_date('05-10-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226896, 226885, to_date('07-11-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226897, 226885, to_date('28-09-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226898, 226885, to_date('24-10-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226899, 226885, to_date('22-08-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226900, 226885, to_date('03-12-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226901, 226885, to_date('10-09-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226902, 226885, to_date('05-09-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226903, 226885, to_date('12-10-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226904, 226885, to_date('20-08-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226905, 226885, to_date('03-10-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226906, 226885, to_date('12-09-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226907, 226885, to_date('30-11-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226908, 226885, to_date('17-10-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226909, 226885, to_date('05-11-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226910, 226885, to_date('02-11-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226911, 226885, to_date('16-11-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226912, 226885, to_date('31-10-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226913, 226885, to_date('14-11-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226914, 226885, to_date('19-09-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226915, 226885, to_date('29-10-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226916, 226885, to_date('07-09-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226917, 226885, to_date('17-09-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226918, 226885, to_date('21-09-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226919, 226885, to_date('26-09-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226920, 226885, to_date('07-12-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226921, 226885, to_date('29-08-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226922, 226885, to_date('27-08-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226923, 226885, to_date('26-11-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226924, 226885, to_date('12-11-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226925, 226885, to_date('01-10-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226926, 226885, to_date('05-12-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226927, 226885, to_date('09-11-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226928, 226885, to_date('22-10-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226929, 226885, to_date('15-10-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226930, 226885, to_date('10-10-2007', 'dd-mm-yyyy'), 90, 0, 102, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226933, 226931, to_date('30-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226934, 226931, to_date('03-12-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226935, 226931, to_date('07-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226936, 226931, to_date('26-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226937, 226931, to_date('28-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226938, 226931, to_date('05-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226939, 226931, to_date('20-08-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226940, 226931, to_date('17-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226941, 226931, to_date('16-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226942, 226931, to_date('02-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226943, 226931, to_date('12-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226944, 226931, to_date('14-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226945, 226931, to_date('19-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226946, 226931, to_date('22-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226947, 226931, to_date('01-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226948, 226931, to_date('09-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226949, 226931, to_date('24-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226950, 226931, to_date('05-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226951, 226931, to_date('15-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226952, 226931, to_date('27-08-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226953, 226931, to_date('19-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226954, 226931, to_date('07-12-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226955, 226931, to_date('31-08-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226956, 226931, to_date('21-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226957, 226931, to_date('29-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226958, 226931, to_date('24-08-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226959, 226931, to_date('10-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226960, 226931, to_date('12-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226961, 226931, to_date('26-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226964, 226962, to_date('29-11-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226965, 226962, to_date('06-09-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226966, 226962, to_date('20-09-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226967, 226962, to_date('25-09-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
commit;
prompt 300 records committed...
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226968, 226962, to_date('04-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226969, 226962, to_date('06-11-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226970, 226962, to_date('23-08-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226971, 226962, to_date('16-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226972, 226962, to_date('18-09-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226973, 226962, to_date('30-08-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226974, 226962, to_date('28-08-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226975, 226962, to_date('18-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226976, 226962, to_date('13-11-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226977, 226962, to_date('08-11-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226978, 226962, to_date('04-12-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226979, 226962, to_date('06-12-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226980, 226962, to_date('27-09-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226981, 226962, to_date('02-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226982, 226962, to_date('11-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226983, 226962, to_date('30-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226984, 226962, to_date('04-09-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226985, 226962, to_date('27-11-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226986, 226962, to_date('11-09-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226987, 226962, to_date('23-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226988, 226962, to_date('21-08-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226989, 226962, to_date('13-09-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226990, 226962, to_date('15-11-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226991, 226962, to_date('20-11-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226992, 226962, to_date('25-10-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226993, 226962, to_date('01-11-2007', 'dd-mm-yyyy'), 150, 0, 162, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226996, 226994, to_date('15-10-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226997, 226994, to_date('03-12-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226998, 226994, to_date('22-10-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (226999, 226994, to_date('12-11-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227000, 226994, to_date('17-09-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227001, 226994, to_date('20-08-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227002, 226994, to_date('10-09-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227003, 226994, to_date('29-10-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227004, 226994, to_date('01-10-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227005, 226994, to_date('27-08-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227006, 226994, to_date('24-09-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227007, 226994, to_date('19-11-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227008, 226994, to_date('05-11-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227009, 226994, to_date('26-11-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227012, 227010, to_date('04-12-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227013, 227010, to_date('27-11-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227014, 227010, to_date('27-08-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227015, 227010, to_date('10-09-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227016, 227010, to_date('06-09-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227017, 227010, to_date('25-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227018, 227010, to_date('15-11-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227019, 227010, to_date('31-08-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227020, 227010, to_date('20-08-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227021, 227010, to_date('23-08-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227022, 227010, to_date('09-11-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227023, 227010, to_date('13-11-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227024, 227010, to_date('12-09-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227025, 227010, to_date('14-11-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227026, 227010, to_date('02-11-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227027, 227010, to_date('05-11-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227028, 227010, to_date('03-12-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227029, 227010, to_date('28-09-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227030, 227010, to_date('25-09-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227031, 227010, to_date('07-12-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227032, 227010, to_date('22-08-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227033, 227010, to_date('01-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227034, 227010, to_date('12-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227035, 227010, to_date('18-09-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227036, 227010, to_date('11-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227037, 227010, to_date('30-11-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227038, 227010, to_date('28-11-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227039, 227010, to_date('05-09-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227040, 227010, to_date('04-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227041, 227010, to_date('07-09-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227042, 227010, to_date('26-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227043, 227010, to_date('21-08-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227044, 227010, to_date('23-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227045, 227010, to_date('08-11-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227046, 227010, to_date('14-09-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227047, 227010, to_date('26-11-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227048, 227010, to_date('05-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227049, 227010, to_date('15-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227050, 227010, to_date('19-11-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227051, 227010, to_date('29-08-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227052, 227010, to_date('13-09-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227053, 227010, to_date('07-11-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227054, 227010, to_date('20-11-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227055, 227010, to_date('24-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227056, 227010, to_date('06-11-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227057, 227010, to_date('31-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227058, 227010, to_date('19-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227059, 227010, to_date('22-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227060, 227010, to_date('20-09-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227061, 227010, to_date('30-08-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227062, 227010, to_date('16-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227063, 227010, to_date('30-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227064, 227010, to_date('18-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227065, 227010, to_date('24-08-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227066, 227010, to_date('04-09-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227067, 227010, to_date('26-09-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227068, 227010, to_date('29-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227069, 227010, to_date('06-12-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227070, 227010, to_date('16-11-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227071, 227010, to_date('10-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
commit;
prompt 400 records committed...
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227072, 227010, to_date('05-12-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227073, 227010, to_date('27-09-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227074, 227010, to_date('21-09-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227075, 227010, to_date('19-09-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227076, 227010, to_date('12-11-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227077, 227010, to_date('03-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227078, 227010, to_date('17-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227079, 227010, to_date('11-09-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227080, 227010, to_date('28-08-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227081, 227010, to_date('29-11-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227082, 227010, to_date('17-09-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227083, 227010, to_date('01-11-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227084, 227010, to_date('02-10-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227085, 227010, to_date('24-09-2007', 'dd-mm-yyyy'), 186, 0, 210, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227088, 227086, to_date('05-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227089, 227086, to_date('12-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227090, 227086, to_date('24-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227091, 227086, to_date('19-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227092, 227086, to_date('01-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227093, 227086, to_date('27-08-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227094, 227086, to_date('29-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227095, 227086, to_date('26-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227096, 227086, to_date('10-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227097, 227086, to_date('10-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227098, 227086, to_date('14-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227099, 227086, to_date('20-08-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227100, 227086, to_date('28-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227101, 227086, to_date('05-12-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227102, 227086, to_date('19-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227103, 227086, to_date('05-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227104, 227086, to_date('17-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227105, 227086, to_date('26-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227106, 227086, to_date('29-08-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227107, 227086, to_date('07-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227108, 227086, to_date('12-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227109, 227086, to_date('22-08-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227110, 227086, to_date('24-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227111, 227086, to_date('15-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227112, 227086, to_date('31-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227113, 227086, to_date('17-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227114, 227086, to_date('22-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227115, 227086, to_date('03-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227116, 227086, to_date('03-12-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227119, 227117, to_date('26-10-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227120, 227117, to_date('02-11-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227121, 227117, to_date('24-10-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227122, 227117, to_date('19-10-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227123, 227117, to_date('26-09-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227124, 227117, to_date('12-09-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227125, 227117, to_date('28-09-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227126, 227117, to_date('31-10-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227127, 227117, to_date('05-10-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227128, 227117, to_date('14-09-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227129, 227117, to_date('10-10-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227130, 227117, to_date('21-09-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227131, 227117, to_date('16-11-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227132, 227117, to_date('07-11-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227133, 227117, to_date('07-12-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227134, 227117, to_date('12-10-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227135, 227117, to_date('17-10-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227136, 227117, to_date('31-08-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227137, 227117, to_date('14-11-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227138, 227117, to_date('05-09-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227139, 227117, to_date('19-09-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227140, 227117, to_date('05-12-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227141, 227117, to_date('24-08-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227142, 227117, to_date('28-11-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227143, 227117, to_date('03-10-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227144, 227117, to_date('30-11-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227145, 227117, to_date('09-11-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227146, 227117, to_date('29-08-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227147, 227117, to_date('22-08-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227148, 227117, to_date('07-09-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227151, 227149, to_date('26-11-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227152, 227149, to_date('21-09-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227153, 227149, to_date('05-09-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227154, 227149, to_date('22-08-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227155, 227149, to_date('16-11-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227156, 227149, to_date('26-09-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227157, 227149, to_date('24-08-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227158, 227149, to_date('10-09-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227159, 227149, to_date('29-08-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227160, 227149, to_date('19-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227161, 227149, to_date('24-09-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227162, 227149, to_date('20-08-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227163, 227149, to_date('31-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227164, 227149, to_date('24-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227165, 227149, to_date('03-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227166, 227149, to_date('09-11-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227167, 227149, to_date('02-11-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227168, 227149, to_date('17-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227169, 227149, to_date('28-11-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227170, 227149, to_date('07-11-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227171, 227149, to_date('29-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227172, 227149, to_date('05-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227173, 227149, to_date('26-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227174, 227149, to_date('17-09-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227175, 227149, to_date('31-08-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227176, 227149, to_date('01-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227177, 227149, to_date('19-09-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
commit;
prompt 500 records committed...
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227178, 227149, to_date('12-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227179, 227149, to_date('05-11-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227180, 227149, to_date('28-09-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227181, 227149, to_date('07-09-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227182, 227149, to_date('14-11-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227183, 227149, to_date('19-11-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227184, 227149, to_date('22-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227185, 227149, to_date('27-08-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227186, 227149, to_date('07-12-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227187, 227149, to_date('14-09-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227188, 227149, to_date('10-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227189, 227149, to_date('03-12-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227190, 227149, to_date('12-09-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227191, 227149, to_date('15-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227192, 227149, to_date('05-12-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227193, 227149, to_date('12-11-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227194, 227149, to_date('30-11-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227197, 227195, to_date('16-10-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227198, 227195, to_date('21-08-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227199, 227195, to_date('04-12-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227200, 227195, to_date('13-11-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227201, 227195, to_date('18-09-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227202, 227195, to_date('13-09-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227203, 227195, to_date('27-09-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227204, 227195, to_date('23-08-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227205, 227195, to_date('29-11-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227206, 227195, to_date('27-11-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227207, 227195, to_date('20-09-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227208, 227195, to_date('06-09-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227209, 227195, to_date('04-09-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227210, 227195, to_date('28-08-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227211, 227195, to_date('08-11-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227212, 227195, to_date('30-10-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227213, 227195, to_date('02-10-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227214, 227195, to_date('25-10-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227215, 227195, to_date('11-10-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227216, 227195, to_date('25-09-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227217, 227195, to_date('01-11-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227218, 227195, to_date('15-11-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227219, 227195, to_date('20-11-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227220, 227195, to_date('18-10-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227221, 227195, to_date('23-10-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227222, 227195, to_date('06-11-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227223, 227195, to_date('11-09-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227224, 227195, to_date('30-08-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227225, 227195, to_date('04-10-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227226, 227195, to_date('06-12-2007', 'dd-mm-yyyy'), 90, 0, 108, -15, 1, 0, to_date('07-05-2008 08:40:01', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227229, 227227, to_date('17-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227230, 227227, to_date('24-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227231, 227227, to_date('21-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227232, 227227, to_date('31-08-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227233, 227227, to_date('14-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227234, 227227, to_date('14-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227235, 227227, to_date('27-08-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227236, 227227, to_date('20-08-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227237, 227227, to_date('28-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227238, 227227, to_date('12-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227239, 227227, to_date('22-08-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227240, 227227, to_date('29-08-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227241, 227227, to_date('07-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227242, 227227, to_date('22-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227243, 227227, to_date('10-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227244, 227227, to_date('05-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227245, 227227, to_date('26-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227246, 227227, to_date('02-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227247, 227227, to_date('07-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227248, 227227, to_date('05-12-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227249, 227227, to_date('26-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227250, 227227, to_date('19-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227251, 227227, to_date('05-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227252, 227227, to_date('15-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227253, 227227, to_date('19-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227254, 227227, to_date('24-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227255, 227227, to_date('26-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227256, 227227, to_date('12-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227257, 227227, to_date('12-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227258, 227227, to_date('09-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227259, 227227, to_date('17-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227260, 227227, to_date('19-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227261, 227227, to_date('31-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227262, 227227, to_date('29-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227263, 227227, to_date('28-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227264, 227227, to_date('01-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227265, 227227, to_date('03-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227266, 227227, to_date('30-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227267, 227227, to_date('05-10-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227268, 227227, to_date('16-11-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227269, 227227, to_date('24-08-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227270, 227227, to_date('03-12-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227271, 227227, to_date('10-09-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227272, 227227, to_date('07-12-2007', 'dd-mm-yyyy'), 114, 0, 126, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227275, 227273, to_date('10-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227276, 227273, to_date('29-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227277, 227273, to_date('07-12-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227278, 227273, to_date('22-08-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227279, 227273, to_date('26-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227280, 227273, to_date('05-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227281, 227273, to_date('14-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227282, 227273, to_date('21-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227283, 227273, to_date('19-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
commit;
prompt 600 records committed...
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227284, 227273, to_date('17-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227285, 227273, to_date('28-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227286, 227273, to_date('30-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227287, 227273, to_date('03-12-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227288, 227273, to_date('16-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227289, 227273, to_date('24-08-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227290, 227273, to_date('20-08-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227291, 227273, to_date('02-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227292, 227273, to_date('15-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227293, 227273, to_date('05-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227294, 227273, to_date('19-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227295, 227273, to_date('24-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227296, 227273, to_date('07-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227297, 227273, to_date('28-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227298, 227273, to_date('10-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227299, 227273, to_date('19-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227300, 227273, to_date('17-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227301, 227273, to_date('24-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227302, 227273, to_date('26-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227303, 227273, to_date('12-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227304, 227273, to_date('14-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227305, 227273, to_date('27-08-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227306, 227273, to_date('26-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227307, 227273, to_date('12-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227308, 227273, to_date('09-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227309, 227273, to_date('12-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227310, 227273, to_date('31-08-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227311, 227273, to_date('03-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227312, 227273, to_date('22-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227313, 227273, to_date('07-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227314, 227273, to_date('01-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227315, 227273, to_date('05-12-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227316, 227273, to_date('05-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227317, 227273, to_date('29-08-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227318, 227273, to_date('31-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227321, 227319, to_date('13-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227322, 227319, to_date('23-08-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227323, 227319, to_date('18-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227324, 227319, to_date('08-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227325, 227319, to_date('04-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227326, 227319, to_date('06-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227327, 227319, to_date('29-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227328, 227319, to_date('27-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227329, 227319, to_date('06-12-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227330, 227319, to_date('20-09-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227331, 227319, to_date('11-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227332, 227319, to_date('01-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227333, 227319, to_date('30-08-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227334, 227319, to_date('25-10-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227335, 227319, to_date('15-11-2007', 'dd-mm-yyyy'), 138, 0, 150, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227338, 227336, to_date('26-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227339, 227336, to_date('12-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227340, 227336, to_date('07-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227341, 227336, to_date('31-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227342, 227336, to_date('29-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227343, 227336, to_date('07-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227344, 227336, to_date('24-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227345, 227336, to_date('22-08-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227346, 227336, to_date('24-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227347, 227336, to_date('14-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227348, 227336, to_date('28-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227349, 227336, to_date('05-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227350, 227336, to_date('21-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227351, 227336, to_date('19-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227352, 227336, to_date('26-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227353, 227336, to_date('17-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227354, 227336, to_date('20-08-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227355, 227336, to_date('19-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227356, 227336, to_date('02-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227357, 227336, to_date('10-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227358, 227336, to_date('05-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227359, 227336, to_date('24-08-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227360, 227336, to_date('17-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227361, 227336, to_date('10-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227362, 227336, to_date('31-08-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227363, 227336, to_date('09-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227364, 227336, to_date('03-12-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227365, 227336, to_date('27-08-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227366, 227336, to_date('07-12-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227367, 227336, to_date('19-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227368, 227336, to_date('03-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227369, 227336, to_date('12-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227370, 227336, to_date('29-08-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227371, 227336, to_date('15-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227372, 227336, to_date('28-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227373, 227336, to_date('26-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227374, 227336, to_date('14-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227375, 227336, to_date('05-09-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227376, 227336, to_date('01-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227377, 227336, to_date('16-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227378, 227336, to_date('22-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227379, 227336, to_date('12-10-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227380, 227336, to_date('30-11-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227381, 227336, to_date('05-12-2007', 'dd-mm-yyyy'), 174, 0, 186, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227384, 227382, to_date('20-08-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227385, 227382, to_date('01-10-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227386, 227382, to_date('22-10-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227387, 227382, to_date('05-11-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227388, 227382, to_date('26-11-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227389, 227382, to_date('17-09-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
commit;
prompt 700 records committed...
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227390, 227382, to_date('24-09-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227391, 227382, to_date('10-09-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227392, 227382, to_date('03-12-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227393, 227382, to_date('19-11-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227394, 227382, to_date('27-08-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227395, 227382, to_date('29-10-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227396, 227382, to_date('15-10-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227397, 227382, to_date('12-11-2007', 'dd-mm-yyyy'), 102, 0, 114, -10, 4, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227400, 227398, to_date('19-09-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227401, 227398, to_date('12-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227402, 227398, to_date('19-11-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227403, 227398, to_date('05-11-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227404, 227398, to_date('03-12-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227405, 227398, to_date('24-08-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227406, 227398, to_date('03-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227407, 227398, to_date('19-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227408, 227398, to_date('14-11-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227409, 227398, to_date('28-09-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227410, 227398, to_date('26-11-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227411, 227398, to_date('17-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227412, 227398, to_date('26-09-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227413, 227398, to_date('22-08-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227414, 227398, to_date('17-09-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227415, 227398, to_date('07-11-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227416, 227398, to_date('12-09-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227417, 227398, to_date('12-11-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227418, 227398, to_date('14-09-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227419, 227398, to_date('27-08-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227420, 227398, to_date('10-09-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227421, 227398, to_date('01-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227422, 227398, to_date('31-08-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227423, 227398, to_date('16-11-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227424, 227398, to_date('24-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227425, 227398, to_date('30-11-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id, meeting_date, start_period, start_offset, stop_period, stop_offset, location_perm_id, class_can_override, approved_date)
values (227426, 227398, to_date('22-10-2007', 'dd-mm-yyyy'), 162, 0, 174, -10, 3, 0, to_date('07-05-2008 08:40:04', 'dd-mm-yyyy hh24:mi:ss'));
insert into MEETING (uniqueid, event_id