/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online.selection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.online.selection.MultiCriteriaBranchAndBoundSelection;

public class OnlineSectioningCriterion
implements MultiCriteriaBranchAndBoundSelection.SelectionCriterion {
    private Hashtable<CourseRequest, Set<Section>> iPreferredSections = null;
    private List<TimeToAvoid> iTimesToAvoid = null;
    private OnlineSectioningModel iModel;
    private Student iStudent;

    public OnlineSectioningCriterion(Student student, OnlineSectioningModel model, Assignment<Request, Enrollment> assignment, Hashtable<CourseRequest, Set<Section>> preferredSections) {
        this.iStudent = student;
        this.iModel = model;
        this.iPreferredSections = preferredSections;
        if (model.getProperties().getPropertyBoolean("OnlineStudentSectioning.TimesToAvoidHeuristics", true)) {
            this.iTimesToAvoid = new ArrayList<TimeToAvoid>();
            for (Request r : this.iStudent.getRequests()) {
                if (r instanceof CourseRequest) {
                    List<Enrollment> enrollments = ((CourseRequest)r).getAvaiableEnrollmentsSkipSameTime(assignment);
                    if (enrollments.size() > 5) continue;
                    int penalty = (7 - enrollments.size()) * (r.isAlternative() ? 1 : 7 - enrollments.size());
                    for (Enrollment enrollment : enrollments) {
                        for (Section section : enrollment.getSections()) {
                            if (section.getTime() == null) continue;
                            this.iTimesToAvoid.add(new TimeToAvoid(section.getTime(), penalty, r.getPriority()));
                        }
                    }
                    continue;
                }
                if (!(r instanceof FreeTimeRequest)) continue;
                this.iTimesToAvoid.add(new TimeToAvoid(((FreeTimeRequest)r).getTime(), 1, Integer.MAX_VALUE));
            }
            for (Unavailability unavailability : this.iStudent.getUnavailabilities()) {
                if (unavailability.getTime() == null) continue;
                this.iTimesToAvoid.add(new TimeToAvoid(unavailability.getTime(), 1, Integer.MAX_VALUE));
            }
        }
    }

    protected OnlineSectioningModel getModel() {
        return this.iModel;
    }

    protected Student getStudent() {
        return this.iStudent;
    }

    protected Set<Section> getPreferredSections(Request request) {
        return this.iPreferredSections.get(request);
    }

    protected List<TimeToAvoid> getTimesToAvoid() {
        return this.iTimesToAvoid;
    }

    public Set<DistanceConflict.Conflict> getDistanceConflicts(Enrollment[] assignment, int idx) {
        if (this.getModel().getDistanceConflict() == null || assignment[idx] == null) {
            return null;
        }
        Set<DistanceConflict.Conflict> dist = this.getModel().getDistanceConflict().conflicts(assignment[idx]);
        for (int x = 0; x < idx; ++x) {
            if (assignment[x] == null) continue;
            dist.addAll(this.getModel().getDistanceConflict().conflicts(assignment[x], assignment[idx]));
        }
        return dist;
    }

    public Set<TimeOverlapsCounter.Conflict> getTimeOverlappingConflicts(Enrollment[] assignment, int idx) {
        if (this.getModel().getTimeOverlaps() == null || assignment[idx] == null) {
            return null;
        }
        HashSet<TimeOverlapsCounter.Conflict> overlaps = new HashSet<TimeOverlapsCounter.Conflict>();
        for (int x = 0; x < idx; ++x) {
            if (assignment[x] != null) {
                overlaps.addAll(this.getModel().getTimeOverlaps().conflicts(assignment[x], assignment[idx]));
                continue;
            }
            if (!(this.getStudent().getRequests().get(x) instanceof FreeTimeRequest)) continue;
            overlaps.addAll(this.getModel().getTimeOverlaps().conflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x)).createEnrollment(), assignment[idx]));
        }
        overlaps.addAll(this.getModel().getTimeOverlaps().notAvailableTimeConflicts(assignment[idx]));
        return overlaps;
    }

    protected double getWeight(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Set<DistanceConflict.Conflict> distanceConflicts, Set<TimeOverlapsCounter.Conflict> timeOverlappingConflicts) {
        double weight = -this.getModel().getStudentWeights().getWeight(assignment, enrollment);
        if (distanceConflicts != null) {
            for (DistanceConflict.Conflict conflict : distanceConflicts) {
                Enrollment other = conflict.getE1().equals(enrollment) ? conflict.getE2() : conflict.getE1();
                if (other.getRequest().getPriority() > enrollment.getRequest().getPriority()) continue;
                weight += this.getModel().getStudentWeights().getDistanceConflictWeight(assignment, conflict);
            }
        }
        if (timeOverlappingConflicts != null) {
            for (TimeOverlapsCounter.Conflict conflict : timeOverlappingConflicts) {
                weight += this.getModel().getStudentWeights().getTimeOverlapConflictWeight(assignment, enrollment, conflict);
            }
        }
        return enrollment.getRequest().getWeight() * weight;
    }

    public Request getRequest(int index) {
        return index < 0 || index >= this.getStudent().getRequests().size() ? null : this.getStudent().getRequests().get(index);
    }

    public boolean isFreeTime(int index) {
        Request r = this.getRequest(index);
        return r != null && r instanceof FreeTimeRequest;
    }

    @Override
    public int compare(Assignment<Request, Enrollment> assignment, Enrollment[] current, Enrollment[] best) {
        double currentUnavailableSizeFraction;
        int x;
        int idx;
        int idx2;
        if (best == null) {
            return -1;
        }
        boolean ft = false;
        for (int idx3 = 0; idx3 < current.length; ++idx3) {
            if (this.isFreeTime(idx3)) {
                ft = true;
                continue;
            }
            if (best[idx3] != null && best[idx3].getAssignments() != null) {
                if (current[idx3] == null || current[idx3].getSections() == null) {
                    return 1;
                }
                if (best[idx3].getPriority() >= current[idx3].getPriority()) continue;
                return 1;
            }
            if (current[idx3] == null || current[idx3].getAssignments() == null) continue;
            return -1;
        }
        int bestNotAvailable = 0;
        int currentNotAvailable = 0;
        for (int idx4 = 0; idx4 < current.length; ++idx4) {
            if (best[idx4] != null && best[idx4].getAssignments() != null && best[idx4].getRequest() instanceof CourseRequest && best[idx4].getReservation() != null && best[idx4].getReservation().canAssignOverLimit()) {
                for (Section section : best[idx4].getSections()) {
                    if (section.getLimit() != 0) continue;
                    ++bestNotAvailable;
                }
            }
            if (current[idx4] == null || current[idx4].getAssignments() == null || !(current[idx4].getRequest() instanceof CourseRequest) || current[idx4].getReservation() == null || !current[idx4].getReservation().canAssignOverLimit()) continue;
            for (Section section : current[idx4].getSections()) {
                if (section.getLimit() != 0) continue;
                ++currentNotAvailable;
            }
        }
        if (bestNotAvailable > currentNotAvailable) {
            return -1;
        }
        if (bestNotAvailable < currentNotAvailable) {
            return 1;
        }
        if (this.getModel().getTimeOverlaps() != null) {
            int idx5;
            int bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (idx5 = 0; idx5 < current.length; ++idx5) {
                int x2;
                if (best[idx5] == null || best[idx5].getAssignments() == null || !(best[idx5].getRequest() instanceof CourseRequest)) continue;
                for (x2 = 0; x2 < idx5; ++x2) {
                    if (best[x2] == null || best[x2].getAssignments() == null || !(best[x2].getRequest() instanceof CourseRequest)) continue;
                    bestTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(best[x2], best[idx5]);
                }
                for (x2 = 0; x2 < idx5; ++x2) {
                    if (current[x2] == null || current[x2].getAssignments() == null || !(current[x2].getRequest() instanceof CourseRequest)) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x2], current[idx5]);
                }
            }
            for (idx5 = 0; idx5 < current.length; ++idx5) {
                if (best[idx5] != null && best[idx5].getAssignments() != null && best[idx5].isCourseRequest()) {
                    bestTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(best[idx5]);
                }
                if (current[idx5] == null || current[idx5].getAssignments() == null || !current[idx5].isCourseRequest()) continue;
                currentTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(current[idx5]);
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return -1;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return 1;
            }
        }
        double bestPenalties = 0.0;
        double currentPenalties = 0.0;
        for (idx2 = 0; idx2 < current.length; ++idx2) {
            if (best[idx2] == null || best[idx2].getAssignments() == null || !best[idx2].isCourseRequest()) continue;
            for (Section section : best[idx2].getSections()) {
                bestPenalties += this.getModel().getOverExpected(assignment, section, best[idx2].getRequest());
            }
            for (Section section : current[idx2].getSections()) {
                currentPenalties += this.getModel().getOverExpected(assignment, section, current[idx2].getRequest());
            }
        }
        if (currentPenalties < bestPenalties) {
            return -1;
        }
        if (bestPenalties < currentPenalties) {
            return 1;
        }
        if (ft) {
            for (idx2 = 0; idx2 < current.length; ++idx2) {
                if (best[idx2] != null && best[idx2].getAssignments() != null) {
                    if (current[idx2] == null || current[idx2].getSections() == null) {
                        return 1;
                    }
                    if (best[idx2].getPriority() >= current[idx2].getPriority()) continue;
                    return 1;
                }
                if (current[idx2] == null || current[idx2].getAssignments() == null) continue;
                return -1;
            }
        }
        int bestSelected = 0;
        int currentSelected = 0;
        for (int idx6 = 0; idx6 < current.length; ++idx6) {
            Set<Section> preferred;
            if (best[idx6] == null || best[idx6].getAssignments() == null || !best[idx6].isCourseRequest() || (preferred = this.getPreferredSections(best[idx6].getRequest())) == null || preferred.isEmpty()) continue;
            for (Section section : best[idx6].getSections()) {
                if (!preferred.contains(section)) continue;
                ++bestSelected;
            }
            for (Section section : current[idx6].getSections()) {
                if (!preferred.contains(section)) continue;
                ++currentSelected;
            }
        }
        if (currentSelected > bestSelected) {
            return -1;
        }
        if (bestSelected > currentSelected) {
            return 1;
        }
        double bestSelectedConfigs = 0.0;
        double currentSelectedConfigs = 0.0;
        double bestSelectedSections = 0.0;
        double currentSelectedSections = 0.0;
        for (int idx7 = 0; idx7 < current.length; ++idx7) {
            if (best[idx7] != null && best[idx7].getAssignments() != null && best[idx7].isCourseRequest()) {
                bestSelectedSections += best[idx7].percentSelectedSameSection();
                bestSelectedConfigs += best[idx7].percentSelectedSameConfig();
            }
            if (current[idx7] == null || current[idx7].getAssignments() == null || !current[idx7].isCourseRequest()) continue;
            currentSelectedSections += current[idx7].percentSelectedSameSection();
            currentSelectedConfigs += current[idx7].percentSelectedSameConfig();
        }
        if (0.3 * currentSelectedConfigs + 0.7 * currentSelectedSections > 0.3 * bestSelectedConfigs + 0.7 * bestSelectedSections) {
            return -1;
        }
        if (0.3 * bestSelectedConfigs + 0.7 * bestSelectedSections > 0.3 * currentSelectedConfigs + 0.7 * currentSelectedSections) {
            return 1;
        }
        if (this.getModel().getTimeOverlaps() != null) {
            int bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (idx = 0; idx < current.length; ++idx) {
                if (best[idx] == null || best[idx].getAssignments() == null) continue;
                for (x = 0; x < idx; ++x) {
                    if (best[x] != null && best[x].getAssignments() != null) {
                        bestTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(best[x], best[idx]);
                        continue;
                    }
                    if (!(this.getStudent().getRequests().get(x) instanceof FreeTimeRequest)) continue;
                    bestTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x)).createEnrollment(), best[idx]);
                }
                for (x = 0; x < idx; ++x) {
                    if (current[x] != null && current[x].getAssignments() != null) {
                        currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x], current[idx]);
                        continue;
                    }
                    if (!(this.getStudent().getRequests().get(x) instanceof FreeTimeRequest)) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x)).createEnrollment(), current[idx]);
                }
            }
            for (idx = 0; idx < current.length; ++idx) {
                if (best[idx] != null && best[idx].getAssignments() != null && best[idx].isCourseRequest()) {
                    bestTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(best[idx]);
                }
                if (current[idx] == null || current[idx].getAssignments() == null || !current[idx].isCourseRequest()) continue;
                currentTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(current[idx]);
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return -1;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return 1;
            }
        }
        if (this.getModel().getDistanceConflict() != null) {
            int bestDistanceConf = 0;
            int currentDistanceConf = 0;
            for (idx = 0; idx < current.length; ++idx) {
                if (best[idx] == null || best[idx].getAssignments() == null) continue;
                for (x = 0; x < idx; ++x) {
                    if (best[x] == null || best[x].getAssignments() == null) continue;
                    bestDistanceConf += this.getModel().getDistanceConflict().nrConflicts(best[x], best[idx]);
                }
                for (x = 0; x < idx; ++x) {
                    if (current[x] == null || current[x].getAssignments() == null) continue;
                    currentDistanceConf += this.getModel().getDistanceConflict().nrConflicts(current[x], current[idx]);
                }
            }
            if (currentDistanceConf < bestDistanceConf) {
                return -1;
            }
            if (bestDistanceConf < currentDistanceConf) {
                return 1;
            }
        }
        int bestNoTime = 0;
        int currentNoTime = 0;
        for (idx = 0; idx < current.length; ++idx) {
            if (best[idx] == null || best[idx].getAssignments() == null) continue;
            for (Section section : best[idx].getSections()) {
                if (section.getTime() != null) continue;
                ++bestNoTime;
            }
            for (Section section : current[idx].getSections()) {
                if (section.getTime() != null) continue;
                ++currentNoTime;
            }
        }
        if (currentNoTime < bestNoTime) {
            return -1;
        }
        if (bestNoTime < currentNoTime) {
            return 1;
        }
        double bestUnavailableSize = 0.0;
        double currentUnavailableSize = 0.0;
        int bestAltSectionsWithLimit = 0;
        int currentAltSectionsWithLimit = 0;
        for (int idx8 = 0; idx8 < current.length; ++idx8) {
            double averageSize;
            Subpart subpart;
            if (best[idx8] == null || best[idx8].getAssignments() == null) continue;
            for (Section section : best[idx8].getSections()) {
                subpart = section.getSubpart();
                if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                if ((double)section.getLimit() < averageSize) {
                    bestUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                }
                ++bestAltSectionsWithLimit;
            }
            for (Section section : current[idx8].getSections()) {
                subpart = section.getSubpart();
                if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                if ((double)section.getLimit() < averageSize) {
                    currentUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                }
                ++currentAltSectionsWithLimit;
            }
        }
        double bestUnavailableSizeFraction = bestUnavailableSize > 0.0 ? bestUnavailableSize / (double)bestAltSectionsWithLimit : 0.0;
        double d = currentUnavailableSizeFraction = currentUnavailableSize > 0.0 ? currentUnavailableSize / (double)currentAltSectionsWithLimit : 0.0;
        if (currentUnavailableSizeFraction < bestUnavailableSizeFraction) {
            return -1;
        }
        if (bestUnavailableSizeFraction < currentUnavailableSizeFraction) {
            return 1;
        }
        double bestPenalty = 0.0;
        double currentPenalty = 0.0;
        for (int idx9 = 0; idx9 < current.length; ++idx9) {
            if (best[idx9] == null || best[idx9].getAssignments() == null) continue;
            for (Section section : best[idx9].getSections()) {
                bestPenalty += section.getPenalty() / (double)best[idx9].getSections().size();
            }
            for (Section section : current[idx9].getSections()) {
                currentPenalty += section.getPenalty() / (double)current[idx9].getSections().size();
            }
        }
        if (currentPenalty < bestPenalty) {
            return -1;
        }
        if (bestPenalty < currentPenalty) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean canImprove(Assignment<Request, Enrollment> assignment, int maxIdx, Enrollment[] current, Enrollment[] best) {
        double currentUnavailableSizeFraction;
        int x;
        int idx;
        int idx2;
        int alt = 0;
        boolean ft = false;
        for (int idx3 = 0; idx3 < current.length; ++idx3) {
            if (this.isFreeTime(idx3)) {
                ft = true;
                continue;
            }
            Request request = this.getRequest(idx3);
            if (idx3 < maxIdx) {
                if (best[idx3] != null) {
                    if (current[idx3] == null) {
                        return false;
                    }
                    if (best[idx3].getPriority() < current[idx3].getPriority()) {
                        return false;
                    }
                    if (!request.isAlternative()) continue;
                    --alt;
                    continue;
                }
                if (current[idx3] != null) {
                    return true;
                }
                if (request.isAlternative()) continue;
                ++alt;
                continue;
            }
            if (!(best[idx3] != null ? best[idx3].getPriority() > 0 : !request.isAlternative() || alt > 0)) continue;
            return true;
        }
        int notAvailable = 0;
        for (int idx4 = 0; idx4 < current.length; ++idx4) {
            if (best[idx4] != null && best[idx4].getAssignments() != null && best[idx4].getRequest() instanceof CourseRequest && best[idx4].getReservation() != null && best[idx4].getReservation().canAssignOverLimit()) {
                for (Section section : best[idx4].getSections()) {
                    if (section.getLimit() != 0) continue;
                    ++notAvailable;
                }
            }
            if (idx4 >= maxIdx || current[idx4] == null || current[idx4].getAssignments() == null || !(current[idx4].getRequest() instanceof CourseRequest) || current[idx4].getReservation() == null || !current[idx4].getReservation().canAssignOverLimit()) continue;
            for (Section section : current[idx4].getSections()) {
                if (section.getLimit() != 0) continue;
                --notAvailable;
            }
        }
        if (notAvailable > 0) {
            return true;
        }
        if (this.getModel().getTimeOverlaps() != null) {
            int idx5;
            int bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (idx5 = 0; idx5 < current.length; ++idx5) {
                int x2;
                if (best[idx5] != null && best[idx5].getRequest() instanceof CourseRequest) {
                    for (x2 = 0; x2 < idx5; ++x2) {
                        if (best[x2] == null || !(best[x2].getRequest() instanceof CourseRequest)) continue;
                        bestTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(best[x2], best[idx5]);
                    }
                }
                if (current[idx5] == null || idx5 >= maxIdx || !(current[idx5].getRequest() instanceof CourseRequest)) continue;
                for (x2 = 0; x2 < idx5; ++x2) {
                    if (current[x2] == null || !(current[x2].getRequest() instanceof CourseRequest)) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x2], current[idx5]);
                }
            }
            for (idx5 = 0; idx5 < current.length; ++idx5) {
                if (best[idx5] != null && best[idx5].getAssignments() != null && best[idx5].isCourseRequest()) {
                    bestTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(best[idx5]);
                }
                if (current[idx5] == null || idx5 >= maxIdx || current[idx5].getAssignments() == null || !current[idx5].isCourseRequest()) continue;
                currentTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(current[idx5]);
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return true;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return false;
            }
        }
        double bestPenalties = 0.0;
        double currentPenalties = 0.0;
        for (idx2 = 0; idx2 < current.length; ++idx2) {
            if (best[idx2] != null) {
                for (Section section : best[idx2].getSections()) {
                    bestPenalties += this.getModel().getOverExpected(assignment, section, best[idx2].getRequest());
                }
            }
            if (current[idx2] == null || idx2 >= maxIdx) continue;
            for (Section section : current[idx2].getSections()) {
                currentPenalties += this.getModel().getOverExpected(assignment, section, current[idx2].getRequest());
            }
        }
        if (currentPenalties < bestPenalties) {
            return true;
        }
        if (bestPenalties < currentPenalties) {
            return false;
        }
        if (ft) {
            alt = 0;
            for (idx2 = 0; idx2 < current.length; ++idx2) {
                Request request = this.getStudent().getRequests().get(idx2);
                if (idx2 < maxIdx) {
                    if (best[idx2] != null) {
                        if (current[idx2] == null) {
                            return false;
                        }
                        if (best[idx2].getPriority() < current[idx2].getPriority()) {
                            return false;
                        }
                        if (!request.isAlternative()) continue;
                        --alt;
                        continue;
                    }
                    if (current[idx2] != null) {
                        return true;
                    }
                    if (!(request instanceof CourseRequest) || request.isAlternative()) continue;
                    ++alt;
                    continue;
                }
                if (!(best[idx2] != null ? best[idx2].getPriority() > 0 : !request.isAlternative() || alt > 0)) continue;
                return true;
            }
        }
        int bestSelected = 0;
        int currentSelected = 0;
        for (int idx6 = 0; idx6 < current.length; ++idx6) {
            Set<Section> preferred;
            if (best[idx6] != null && best[idx6].isCourseRequest() && (preferred = this.getPreferredSections(best[idx6].getRequest())) != null && !preferred.isEmpty()) {
                for (Section section : best[idx6].getSections()) {
                    if (preferred.contains(section)) {
                        if (idx6 >= maxIdx) continue;
                        ++bestSelected;
                        continue;
                    }
                    if (idx6 < maxIdx) continue;
                    --bestSelected;
                }
            }
            if (current[idx6] == null || idx6 >= maxIdx || !current[idx6].isCourseRequest() || (preferred = this.getPreferredSections(current[idx6].getRequest())) == null || preferred.isEmpty()) continue;
            for (Section section : current[idx6].getSections()) {
                if (!preferred.contains(section)) continue;
                ++currentSelected;
            }
        }
        if (currentSelected > bestSelected) {
            return true;
        }
        if (bestSelected > currentSelected) {
            return false;
        }
        double bestSelectedConfigs = 0.0;
        double currentSelectedConfigs = 0.0;
        double bestSelectedSections = 0.0;
        double currentSelectedSections = 0.0;
        for (int idx7 = 0; idx7 < current.length; ++idx7) {
            if (best[idx7] != null && best[idx7].getAssignments() != null && best[idx7].isCourseRequest()) {
                bestSelectedSections += best[idx7].percentSelectedSameSection();
                bestSelectedConfigs += best[idx7].percentSelectedSameConfig();
                if (idx7 >= maxIdx) {
                    bestSelectedSections -= 1.0;
                    bestSelectedConfigs -= 1.0;
                }
            }
            if (current[idx7] == null || idx7 >= maxIdx || current[idx7].getAssignments() == null || !current[idx7].isCourseRequest()) continue;
            currentSelectedSections += current[idx7].percentSelectedSameSection();
            currentSelectedConfigs += current[idx7].percentSelectedSameConfig();
        }
        if (0.3 * currentSelectedConfigs + 0.7 * currentSelectedSections > 0.3 * bestSelectedConfigs + 0.7 * bestSelectedSections) {
            return true;
        }
        if (0.3 * bestSelectedConfigs + 0.7 * bestSelectedSections > 0.3 * currentSelectedConfigs + 0.7 * currentSelectedSections) {
            return false;
        }
        if (this.getModel().getTimeOverlaps() != null) {
            int bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (idx = 0; idx < current.length; ++idx) {
                if (best[idx] != null) {
                    for (x = 0; x < idx; ++x) {
                        if (best[x] != null) {
                            bestTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(best[x], best[idx]);
                            continue;
                        }
                        if (!(this.getStudent().getRequests().get(x) instanceof FreeTimeRequest)) continue;
                        bestTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x)).createEnrollment(), best[idx]);
                    }
                }
                if (current[idx] == null || idx >= maxIdx) continue;
                for (x = 0; x < idx; ++x) {
                    if (current[x] != null) {
                        currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x], current[idx]);
                        continue;
                    }
                    if (!(this.getStudent().getRequests().get(x) instanceof FreeTimeRequest)) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x)).createEnrollment(), current[idx]);
                }
            }
            for (idx = 0; idx < current.length; ++idx) {
                if (best[idx] != null && best[idx].getAssignments() != null && best[idx].isCourseRequest()) {
                    bestTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(best[idx]);
                }
                if (current[idx] == null || idx >= maxIdx || current[idx].getAssignments() == null || !current[idx].isCourseRequest()) continue;
                currentTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(current[idx]);
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return true;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return false;
            }
        }
        if (this.getModel().getDistanceConflict() != null) {
            int bestDistanceConf = 0;
            int currentDistanceConf = 0;
            for (idx = 0; idx < current.length; ++idx) {
                if (best[idx] != null) {
                    for (x = 0; x < idx; ++x) {
                        if (best[x] == null) continue;
                        bestDistanceConf += this.getModel().getDistanceConflict().nrConflicts(best[x], best[idx]);
                    }
                }
                if (current[idx] == null || idx >= maxIdx) continue;
                for (x = 0; x < idx; ++x) {
                    if (current[x] == null) continue;
                    currentDistanceConf += this.getModel().getDistanceConflict().nrConflicts(current[x], current[idx]);
                }
            }
            if (currentDistanceConf < bestDistanceConf) {
                return true;
            }
            if (bestDistanceConf < currentDistanceConf) {
                return false;
            }
        }
        int bestNoTime = 0;
        int currentNoTime = 0;
        for (idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null) {
                for (Section section : best[idx].getSections()) {
                    if (section.getTime() != null) continue;
                    ++bestNoTime;
                }
            }
            if (current[idx] == null || idx >= maxIdx) continue;
            for (Section section : current[idx].getSections()) {
                if (section.getTime() != null) continue;
                ++currentNoTime;
            }
        }
        if (currentNoTime < bestNoTime) {
            return true;
        }
        if (bestNoTime < currentNoTime) {
            return false;
        }
        double bestUnavailableSize = 0.0;
        double currentUnavailableSize = 0.0;
        int bestAltSectionsWithLimit = 0;
        int currentAltSectionsWithLimit = 0;
        for (int idx8 = 0; idx8 < current.length; ++idx8) {
            double averageSize;
            Subpart subpart;
            if (best[idx8] != null) {
                for (Section section : best[idx8].getSections()) {
                    subpart = section.getSubpart();
                    if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                    averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                    if ((double)section.getLimit() < averageSize) {
                        bestUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                    }
                    ++bestAltSectionsWithLimit;
                }
            }
            if (current[idx8] == null || idx8 >= maxIdx) continue;
            for (Section section : current[idx8].getSections()) {
                subpart = section.getSubpart();
                if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                if ((double)section.getLimit() < averageSize) {
                    currentUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                }
                ++currentAltSectionsWithLimit;
            }
        }
        double bestUnavailableSizeFraction = bestUnavailableSize > 0.0 ? bestUnavailableSize / (double)bestAltSectionsWithLimit : 0.0;
        double d = currentUnavailableSizeFraction = currentUnavailableSize > 0.0 ? currentUnavailableSize / (double)currentAltSectionsWithLimit : 0.0;
        if (currentUnavailableSizeFraction < bestUnavailableSizeFraction) {
            return true;
        }
        if (bestUnavailableSizeFraction < currentUnavailableSizeFraction) {
            return false;
        }
        double bestPenalty = 0.0;
        double currentPenalty = 0.0;
        for (int idx9 = 0; idx9 < current.length; ++idx9) {
            if (best[idx9] != null) {
                for (Section section : best[idx9].getSections()) {
                    bestPenalty += section.getPenalty() / (double)best[idx9].getSections().size();
                }
                if (idx9 >= maxIdx && best[idx9].isCourseRequest()) {
                    bestPenalty -= ((CourseRequest)best[idx9].getRequest()).getMinPenalty();
                }
            }
            if (current[idx9] == null || idx9 >= maxIdx) continue;
            for (Section section : current[idx9].getSections()) {
                currentPenalty += section.getPenalty() / (double)current[idx9].getSections().size();
            }
        }
        if (currentPenalty < bestPenalty) {
            return true;
        }
        return !(bestPenalty < currentPenalty);
    }

    @Override
    public double getTotalWeight(Assignment<Request, Enrollment> assignment, Enrollment[] enrollemnts) {
        if (enrollemnts == null) {
            return 0.0;
        }
        double value = 0.0;
        for (int idx = 0; idx < enrollemnts.length; ++idx) {
            if (enrollemnts[idx] == null) continue;
            value += this.getWeight(assignment, enrollemnts[idx], this.getDistanceConflicts(enrollemnts, idx), this.getTimeOverlappingConflicts(enrollemnts, idx));
        }
        return value;
    }

    @Override
    public int compare(Assignment<Request, Enrollment> assignment, Enrollment e1, Enrollment e2) {
        double f2;
        double averageSize;
        Subpart subpart;
        Set<Section> preferred;
        if (e1.getPriority() < e2.getPriority()) {
            return -1;
        }
        if (e1.getPriority() > e2.getPriority()) {
            return 1;
        }
        int na1 = 0;
        int na2 = 0;
        for (Section section : e1.getSections()) {
            if (section.getLimit() != 0) continue;
            ++na1;
        }
        for (Section section : e2.getSections()) {
            if (section.getLimit() != 0) continue;
            ++na2;
        }
        if (na1 < na2) {
            return -1;
        }
        if (na1 > na2) {
            return 1;
        }
        double p1 = 0.0;
        double p2 = 0.0;
        for (Section section : e1.getSections()) {
            p1 += this.getModel().getOverExpected(assignment, section, e1.getRequest());
        }
        for (Section section : e2.getSections()) {
            p2 += this.getModel().getOverExpected(assignment, section, e2.getRequest());
        }
        if (p1 < p2) {
            return -1;
        }
        if (p2 < p1) {
            return 1;
        }
        if (e1.isCourseRequest() && (preferred = this.getPreferredSections(e1.getRequest())) != null && !preferred.isEmpty()) {
            int s1 = 0;
            int s2 = 0;
            for (Section section : e1.getSections()) {
                if (!preferred.contains(section)) continue;
                ++s1;
            }
            for (Section section : e2.getSections()) {
                if (!preferred.contains(section)) continue;
                ++s2;
            }
            if (s2 > s1) {
                return -1;
            }
            if (s1 > s2) {
                return 1;
            }
        }
        if (e1.isCourseRequest()) {
            double s2;
            double s1 = 0.3 * e1.percentSelectedSameConfig() + 0.7 * e1.percentSelectedSameSection();
            if (s1 > (s2 = 0.3 * e2.percentSelectedSameConfig() + 0.7 * e2.percentSelectedSameSection())) {
                return -1;
            }
            if (s2 > s1) {
                return 1;
            }
        }
        if (this.getTimesToAvoid() == null) {
            if (this.getModel().getTimeOverlaps() != null) {
                int o2;
                int o1 = this.getModel().getTimeOverlaps().nrFreeTimeConflicts(e1) + this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(e1);
                if (o1 < (o2 = this.getModel().getTimeOverlaps().nrFreeTimeConflicts(e2) + this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(e2))) {
                    return -1;
                }
                if (o2 < o1) {
                    return 1;
                }
            }
        } else if (e1.getRequest().equals(e2.getRequest()) && e1.isCourseRequest()) {
            double o1 = 0.0;
            double o2 = 0.0;
            for (Section s : e1.getSections()) {
                if (s.getTime() == null) continue;
                for (TimeToAvoid avoid : this.getTimesToAvoid()) {
                    if (avoid.priority() <= e1.getPriority()) continue;
                    o1 += avoid.overlap(s.getTime());
                }
            }
            for (Section s : e2.getSections()) {
                if (s.getTime() == null) continue;
                for (TimeToAvoid avoid : this.getTimesToAvoid()) {
                    if (avoid.priority() <= e2.getPriority()) continue;
                    o2 += avoid.overlap(s.getTime());
                }
            }
            if (o1 < o2) {
                return -1;
            }
            if (o2 < o1) {
                return 1;
            }
        }
        if (this.getModel().getDistanceConflict() != null) {
            int c2;
            int c1 = this.getModel().getDistanceConflict().nrConflicts(e1);
            if (c1 < (c2 = this.getModel().getDistanceConflict().nrConflicts(e2))) {
                return -1;
            }
            if (c2 < c1) {
                return 1;
            }
        }
        int n1 = 0;
        int n2 = 0;
        for (Section section : e1.getSections()) {
            if (section.getTime() != null) continue;
            ++n1;
        }
        for (Section section : e2.getSections()) {
            if (section.getTime() != null) continue;
            ++n2;
        }
        if (n1 < n2) {
            return -1;
        }
        if (n2 < n1) {
            return 1;
        }
        double u1 = 0.0;
        double d = 0.0;
        int a1 = 0;
        int a2 = 0;
        for (Section section : e1.getSections()) {
            subpart = section.getSubpart();
            if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
            averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
            if ((double)section.getLimit() < averageSize) {
                u1 += (averageSize - (double)section.getLimit()) / averageSize;
            }
            ++a1;
        }
        for (Section section : e2.getSections()) {
            subpart = section.getSubpart();
            if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
            averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
            if ((double)section.getLimit() < averageSize) {
                d += (averageSize - (double)section.getLimit()) / averageSize;
            }
            ++a2;
        }
        double f1 = u1 > 0.0 ? u1 / (double)a1 : 0.0;
        double d2 = f2 = d > 0.0 ? d / (double)a2 : 0.0;
        if (f1 < f2) {
            return -1;
        }
        if (f2 < f1) {
            return 1;
        }
        double x1 = 0.0;
        double x2 = 0.0;
        for (Section section : e1.getSections()) {
            x1 += section.getPenalty() / (double)e1.getSections().size();
        }
        for (Section section : e2.getSections()) {
            x2 += section.getPenalty() / (double)e2.getSections().size();
        }
        if (x1 < x2) {
            return -1;
        }
        if (x2 < x1) {
            return 1;
        }
        return 0;
    }

    protected static class TimeToAvoid {
        private TimeLocation iTime;
        private double iPenalty;
        private int iPriority;

        public TimeToAvoid(TimeLocation time, int penalty, int priority) {
            this.iTime = time;
            this.iPenalty = penalty;
            this.iPriority = priority;
        }

        public int priority() {
            return this.iPriority;
        }

        public double overlap(TimeLocation time) {
            if (time.hasIntersection(this.iTime)) {
                return this.iPenalty * (double)(time.nrSharedDays(this.iTime) * time.nrSharedDays(this.iTime)) / (double)(this.iTime.getNrMeetings() * this.iTime.getLength());
            }
            return 0.0;
        }

        public String toString() {
            return this.iTime.getLongName(true) + " (" + this.iPriority + "/" + this.iPenalty + ")";
        }
    }
}

