/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.BitSet;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.cpsolver.coursett.IdConvertor;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.StudentSectioningSaver;
import org.cpsolver.studentsct.constraint.LinkedSections;
import org.cpsolver.studentsct.model.AcademicAreaCode;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.RequestGroup;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.reservation.CourseReservation;
import org.cpsolver.studentsct.reservation.CurriculumReservation;
import org.cpsolver.studentsct.reservation.DummyReservation;
import org.cpsolver.studentsct.reservation.GroupReservation;
import org.cpsolver.studentsct.reservation.IndividualReservation;
import org.cpsolver.studentsct.reservation.Reservation;
import org.cpsolver.studentsct.reservation.ReservationOverride;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class StudentSectioningXMLSaver
extends StudentSectioningSaver {
    private static Logger sLogger = Logger.getLogger(StudentSectioningXMLSaver.class);
    private static DecimalFormat[] sDF = new DecimalFormat[]{new DecimalFormat(""), new DecimalFormat("0"), new DecimalFormat("00"), new DecimalFormat("000"), new DecimalFormat("0000"), new DecimalFormat("00000"), new DecimalFormat("000000"), new DecimalFormat("0000000")};
    private static DecimalFormat sStudentWeightFormat = new DecimalFormat("0.0000", new DecimalFormatSymbols(Locale.US));
    private File iOutputFolder = new File(((StudentSectioningModel)this.getModel()).getProperties().getProperty("General.Output", "." + File.separator + "output"));
    private boolean iSaveBest = ((StudentSectioningModel)this.getModel()).getProperties().getPropertyBoolean("Xml.SaveBest", true);
    private boolean iSaveInitial = ((StudentSectioningModel)this.getModel()).getProperties().getPropertyBoolean("Xml.SaveInitial", true);
    private boolean iSaveCurrent = ((StudentSectioningModel)this.getModel()).getProperties().getPropertyBoolean("Xml.SaveCurrent", false);
    private boolean iSaveOnlineSectioningInfo = ((StudentSectioningModel)this.getModel()).getProperties().getPropertyBoolean("Xml.SaveOnlineSectioningInfo", true);
    private boolean iSaveStudentInfo = ((StudentSectioningModel)this.getModel()).getProperties().getPropertyBoolean("Xml.SaveStudentInfo", true);
    private boolean iConvertIds = false;
    private boolean iShowNames = ((StudentSectioningModel)this.getModel()).getProperties().getPropertyBoolean("Xml.ShowNames", true);

    public StudentSectioningXMLSaver(Solver<Request, Enrollment> solver) {
        super(solver);
        this.iConvertIds = ((StudentSectioningModel)this.getModel()).getProperties().getPropertyBoolean("Xml.ConvertIds", false);
    }

    private static String bitset2string(BitSet b) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length(); ++i) {
            sb.append(b.get(i) ? "1" : "0");
        }
        return sb.toString();
    }

    private String getId(String type, String id) {
        if (!this.iConvertIds) {
            return id.toString();
        }
        return IdConvertor.getInstance().convert(type, id);
    }

    private String getId(String type, Number id) {
        return this.getId(type, id.toString());
    }

    private String getId(String type, long id) {
        return this.getId(type, String.valueOf(id));
    }

    @Override
    public void save() throws Exception {
        this.save(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File outFile) throws Exception {
        if (outFile == null) {
            outFile = new File(this.iOutputFolder, "solution.xml");
        } else if (outFile.getParentFile() != null) {
            outFile.getParentFile().mkdirs();
        }
        sLogger.debug("Writting XML data to:" + outFile);
        Document document = DocumentHelper.createDocument();
        document.addComment("Student Sectioning");
        this.populate(document);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outFile);
            new XMLWriter(fos, OutputFormat.createPrettyPrint()).write(document);
            fos.flush();
            fos.close();
            fos = null;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (this.iConvertIds) {
            IdConvertor.getInstance().save();
        }
    }

    public Document saveDocument() {
        Document document = DocumentHelper.createDocument();
        document.addComment("Student Sectioning");
        this.populate(document);
        return document;
    }

    protected void populate(Document document) {
        if (this.iSaveCurrent || this.iSaveBest) {
            StringBuffer comments = new StringBuffer("Solution Info:\n");
            Map<String, String> solutionInfo = this.getSolution() == null ? ((StudentSectioningModel)this.getModel()).getExtendedInfo(this.getAssignment()) : this.getSolution().getExtendedInfo();
            for (String key : new TreeSet<String>(solutionInfo.keySet())) {
                String value = solutionInfo.get(key);
                comments.append("    " + key + ": " + value + "\n");
            }
            document.addComment(comments.toString());
        }
        Element root = document.addElement("sectioning");
        root.addAttribute("version", "1.0");
        root.addAttribute("initiative", ((StudentSectioningModel)this.getModel()).getProperties().getProperty("Data.Initiative"));
        root.addAttribute("term", ((StudentSectioningModel)this.getModel()).getProperties().getProperty("Data.Term"));
        root.addAttribute("year", ((StudentSectioningModel)this.getModel()).getProperties().getProperty("Data.Year"));
        root.addAttribute("created", String.valueOf(new Date()));
        this.saveOfferings(root);
        this.saveStudents(root);
        this.saveLinkedSections(root);
        this.saveTravelTimes(root);
        if (this.iShowNames) {
            Progress.getInstance(this.getModel()).save(root);
        }
    }

    protected void saveOfferings(Element root) {
        Element offeringsEl = root.addElement("offerings");
        for (Offering offering : ((StudentSectioningModel)this.getModel()).getOfferings()) {
            Element offeringEl = offeringsEl.addElement("offering");
            this.saveOffering(offeringEl, offering);
            this.saveReservations(offeringEl, offering);
        }
    }

    protected void saveOffering(Element offeringEl, Offering offering) {
        offeringEl.addAttribute("id", this.getId("offering", offering.getId()));
        if (this.iShowNames) {
            offeringEl.addAttribute("name", offering.getName());
        }
        for (Course course : offering.getCourses()) {
            Element courseEl = offeringEl.addElement("course");
            this.saveCourse(courseEl, course);
        }
        for (Config config : offering.getConfigs()) {
            Element configEl = offeringEl.addElement("config");
            this.saveConfig(configEl, config);
        }
    }

    protected void saveCourse(Element courseEl, Course course) {
        courseEl.addAttribute("id", this.getId("course", course.getId()));
        if (this.iShowNames) {
            courseEl.addAttribute("subjectArea", course.getSubjectArea());
        }
        if (this.iShowNames) {
            courseEl.addAttribute("courseNbr", course.getCourseNumber());
        }
        if (this.iShowNames && course.getLimit() >= 0) {
            courseEl.addAttribute("limit", String.valueOf(course.getLimit()));
        }
        if (this.iShowNames && course.getProjected() != 0) {
            courseEl.addAttribute("projected", String.valueOf(course.getProjected()));
        }
        if (this.iShowNames && course.getCredit() != null) {
            courseEl.addAttribute("credit", course.getCredit());
        }
    }

    protected void saveConfig(Element configEl, Config config) {
        configEl.addAttribute("id", this.getId("config", config.getId()));
        if (config.getLimit() >= 0) {
            configEl.addAttribute("limit", String.valueOf(config.getLimit()));
        }
        if (this.iShowNames) {
            configEl.addAttribute("name", config.getName());
        }
        for (Subpart subpart : config.getSubparts()) {
            Element subpartEl = configEl.addElement("subpart");
            this.saveSubpart(subpartEl, subpart);
        }
        if (config.getInstructionalMethodId() != null) {
            Element imEl = configEl.addElement("instructional-method");
            imEl.addAttribute("id", this.getId("instructional-method", config.getInstructionalMethodId()));
            if (this.iShowNames && config.getInstructionalMethodName() != null) {
                imEl.addAttribute("name", config.getInstructionalMethodName());
            }
        }
    }

    protected void saveSubpart(Element subpartEl, Subpart subpart) {
        subpartEl.addAttribute("id", this.getId("subpart", subpart.getId()));
        subpartEl.addAttribute("itype", subpart.getInstructionalType());
        if (subpart.getParent() != null) {
            subpartEl.addAttribute("parent", this.getId("subpart", subpart.getParent().getId()));
        }
        if (this.iShowNames) {
            subpartEl.addAttribute("name", subpart.getName());
            if (subpart.getCredit() != null) {
                subpartEl.addAttribute("credit", subpart.getCredit());
            }
        }
        if (subpart.isAllowOverlap()) {
            subpartEl.addAttribute("allowOverlap", "true");
        }
        for (Section section : subpart.getSections()) {
            Element sectionEl = subpartEl.addElement("section");
            this.saveSection(sectionEl, section);
        }
    }

    protected void saveSection(Element sectionEl, Section section) {
        sectionEl.addAttribute("id", this.getId("section", section.getId()));
        sectionEl.addAttribute("limit", String.valueOf(section.getLimit()));
        if (section.isCancelled()) {
            sectionEl.addAttribute("cancelled", "true");
        }
        if (this.iShowNames && section.getNameByCourse() != null) {
            for (Map.Entry entry : section.getNameByCourse().entrySet()) {
                sectionEl.addElement("cname").addAttribute("id", this.getId("course", (Number)entry.getKey())).setText((String)entry.getValue());
            }
        }
        if (section.getParent() != null) {
            sectionEl.addAttribute("parent", this.getId("section", section.getParent().getId()));
        }
        if (section.hasInstructors()) {
            for (Instructor instructor : section.getInstructors()) {
                Element instructorEl = sectionEl.addElement("instructor");
                instructorEl.addAttribute("id", this.getId("instructor", instructor.getId()));
                if (this.iShowNames && instructor.getName() != null) {
                    instructorEl.addAttribute("name", instructor.getName());
                }
                if (this.iShowNames && instructor.getExternalId() != null) {
                    instructorEl.addAttribute("externalId", instructor.getExternalId());
                }
                if (!this.iShowNames || instructor.getEmail() == null) continue;
                instructorEl.addAttribute("email", instructor.getExternalId());
            }
        }
        if (this.iShowNames) {
            sectionEl.addAttribute("name", section.getName());
        }
        if (section.getPlacement() != null) {
            TimeLocation tl = section.getPlacement().getTimeLocation();
            if (tl != null) {
                Element element = sectionEl.addElement("time");
                element.addAttribute("days", sDF[7].format(Long.parseLong(Integer.toBinaryString(tl.getDayCode()))));
                element.addAttribute("start", String.valueOf(tl.getStartSlot()));
                element.addAttribute("length", String.valueOf(tl.getLength()));
                if (tl.getBreakTime() != 0) {
                    element.addAttribute("breakTime", String.valueOf(tl.getBreakTime()));
                }
                if (this.iShowNames && tl.getTimePatternId() != null) {
                    element.addAttribute("pattern", this.getId("timePattern", tl.getTimePatternId()));
                }
                if (this.iShowNames && tl.getDatePatternId() != null) {
                    element.addAttribute("datePattern", tl.getDatePatternId().toString());
                }
                if (this.iShowNames && tl.getDatePatternName() != null && tl.getDatePatternName().length() > 0) {
                    element.addAttribute("datePatternName", tl.getDatePatternName());
                }
                element.addAttribute("dates", StudentSectioningXMLSaver.bitset2string(tl.getWeekCode()));
                if (this.iShowNames) {
                    element.setText(tl.getLongName(true));
                }
            }
            for (RoomLocation rl : section.getRooms()) {
                Element roomLocationEl = sectionEl.addElement("room");
                roomLocationEl.addAttribute("id", this.getId("room", rl.getId()));
                if (this.iShowNames && rl.getBuildingId() != null) {
                    roomLocationEl.addAttribute("building", this.getId("building", rl.getBuildingId()));
                }
                if (this.iShowNames && rl.getName() != null) {
                    roomLocationEl.addAttribute("name", rl.getName());
                }
                roomLocationEl.addAttribute("capacity", String.valueOf(rl.getRoomSize()));
                if (rl.getPosX() != null && rl.getPosY() != null) {
                    roomLocationEl.addAttribute("location", rl.getPosX() + "," + rl.getPosY());
                }
                if (!rl.getIgnoreTooFar()) continue;
                roomLocationEl.addAttribute("ignoreTooFar", "true");
            }
        }
        if (this.iSaveOnlineSectioningInfo) {
            if (section.getSpaceHeld() != 0.0) {
                sectionEl.addAttribute("hold", sStudentWeightFormat.format(section.getSpaceHeld()));
            }
            if (section.getSpaceExpected() != 0.0) {
                sectionEl.addAttribute("expect", sStudentWeightFormat.format(section.getSpaceExpected()));
            }
        }
        if (section.getIgnoreConflictWithSectionIds() != null && !section.getIgnoreConflictWithSectionIds().isEmpty()) {
            Element ignoreEl = sectionEl.addElement("no-conflicts");
            for (Long sectionId : section.getIgnoreConflictWithSectionIds()) {
                ignoreEl.addElement("section").addAttribute("id", this.getId("section", sectionId));
            }
        }
    }

    protected void saveReservations(Element offeringEl, Offering offering) {
        if (!offering.getReservations().isEmpty()) {
            for (Reservation r : offering.getReservations()) {
                this.saveReservation(offeringEl.addElement("reservation"), r);
            }
        }
    }

    protected void saveReservation(Element reservationEl, Reservation reservation) {
        Reservation cr;
        reservationEl.addAttribute("id", this.getId("reservation", reservation.getId()));
        reservationEl.addAttribute("expired", reservation.isExpired() ? "true" : "false");
        if (reservation instanceof GroupReservation) {
            GroupReservation gr = (GroupReservation)reservation;
            reservationEl.addAttribute("type", "group");
            for (Long studentId : gr.getStudentIds()) {
                reservationEl.addElement("student").addAttribute("id", this.getId("student", studentId));
            }
            if (gr.getReservationLimit() >= 0.0) {
                reservationEl.addAttribute("limit", String.valueOf(gr.getReservationLimit()));
            }
        } else if (reservation instanceof ReservationOverride) {
            reservationEl.addAttribute("type", "override");
            ReservationOverride o = (ReservationOverride)reservation;
            for (Long studentId : o.getStudentIds()) {
                reservationEl.addElement("student").addAttribute("id", this.getId("student", studentId));
            }
        } else if (reservation instanceof IndividualReservation) {
            reservationEl.addAttribute("type", "individual");
            for (Long l : ((IndividualReservation)reservation).getStudentIds()) {
                reservationEl.addElement("student").addAttribute("id", this.getId("student", l));
            }
        } else if (reservation instanceof CurriculumReservation) {
            reservationEl.addAttribute("type", "curriculum");
            cr = (CurriculumReservation)reservation;
            if (((CurriculumReservation)cr).getReservationLimit() >= 0.0) {
                reservationEl.addAttribute("limit", String.valueOf(((CurriculumReservation)cr).getReservationLimit()));
            }
            reservationEl.addAttribute("area", ((CurriculumReservation)cr).getAcademicArea());
            for (String clasf : ((CurriculumReservation)cr).getClassifications()) {
                reservationEl.addElement("classification").addAttribute("code", clasf);
            }
            for (String major : ((CurriculumReservation)cr).getMajors()) {
                reservationEl.addElement("major").addAttribute("code", major);
            }
        } else if (reservation instanceof CourseReservation) {
            reservationEl.addAttribute("type", "course");
            cr = (CourseReservation)reservation;
            reservationEl.addAttribute("course", this.getId("course", ((CourseReservation)cr).getCourse().getId()));
        } else if (reservation instanceof DummyReservation) {
            reservationEl.addAttribute("type", "dummy");
        }
        reservationEl.addAttribute("priority", String.valueOf(reservation.getPriority()));
        reservationEl.addAttribute("mustBeUsed", reservation.mustBeUsed() ? "true" : "false");
        reservationEl.addAttribute("allowOverlap", reservation.isAllowOverlap() ? "true" : "false");
        reservationEl.addAttribute("canAssignOverLimit", reservation.canAssignOverLimit() ? "true" : "false");
        for (Config config : reservation.getConfigs()) {
            reservationEl.addElement("config").addAttribute("id", this.getId("config", config.getId()));
        }
        for (Map.Entry entry : reservation.getSections().entrySet()) {
            for (Section section : (Set)entry.getValue()) {
                reservationEl.addElement("section").addAttribute("id", this.getId("section", section.getId()));
            }
        }
    }

    protected void saveStudents(Element root) {
        Element studentsEl = root.addElement("students");
        for (Student student : ((StudentSectioningModel)this.getModel()).getStudents()) {
            Element studentEl = studentsEl.addElement("student");
            this.saveStudent(studentEl, student);
            for (Request request : student.getRequests()) {
                this.saveRequest(studentEl, request);
            }
        }
    }

    protected void saveStudent(Element studentEl, Student student) {
        studentEl.addAttribute("id", this.getId("student", student.getId()));
        if (this.iShowNames) {
            if (student.getExternalId() != null && !student.getExternalId().isEmpty()) {
                studentEl.addAttribute("externalId", student.getExternalId());
            }
            if (student.getName() != null && !student.getName().isEmpty()) {
                studentEl.addAttribute("name", student.getName());
            }
            if (student.getStatus() != null && !student.getStatus().isEmpty()) {
                studentEl.addAttribute("status", student.getStatus());
            }
        }
        if (student.isDummy()) {
            studentEl.addAttribute("dummy", "true");
        }
        if (this.iSaveStudentInfo) {
            Element aacEl;
            for (AcademicAreaCode aac : student.getAcademicAreaClasiffications()) {
                aacEl = studentEl.addElement("classification");
                if (aac.getArea() != null) {
                    aacEl.addAttribute("area", aac.getArea());
                }
                if (aac.getCode() == null) continue;
                aacEl.addAttribute("code", aac.getCode());
            }
            for (AcademicAreaCode aac : student.getMajors()) {
                aacEl = studentEl.addElement("major");
                if (aac.getArea() != null) {
                    aacEl.addAttribute("area", aac.getArea());
                }
                if (aac.getCode() == null) continue;
                aacEl.addAttribute("code", aac.getCode());
            }
            for (AcademicAreaCode aac : student.getMinors()) {
                aacEl = studentEl.addElement("minor");
                if (aac.getArea() != null) {
                    aacEl.addAttribute("area", aac.getArea());
                }
                if (aac.getCode() == null) continue;
                aacEl.addAttribute("code", aac.getCode());
            }
            for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
                Element acmEl = studentEl.addElement("acm");
                if (acm.getArea() != null) {
                    acmEl.addAttribute("area", acm.getArea());
                }
                if (acm.getArea() != null) {
                    acmEl.addAttribute("classification", acm.getClassification());
                }
                if (acm.getArea() == null) continue;
                acmEl.addAttribute("major", acm.getMajor());
            }
        }
        for (Unavailability unavailability : student.getUnavailabilities()) {
            Element unavEl = studentEl.addElement("unavailability");
            unavEl.addAttribute("offering", this.getId("offering", unavailability.getSection().getSubpart().getConfig().getOffering().getId()));
            unavEl.addAttribute("section", this.getId("section", unavailability.getSection().getId()));
            if (!unavailability.isAllowOverlap()) continue;
            unavEl.addAttribute("allowOverlap", "true");
        }
    }

    protected void saveRequest(Element studentEl, Request request) {
        if (request instanceof FreeTimeRequest) {
            this.saveFreeTimeRequest(studentEl.addElement("freeTime"), (FreeTimeRequest)request);
        } else if (request instanceof CourseRequest) {
            this.saveCourseRequest(studentEl.addElement("course"), (CourseRequest)request);
        }
    }

    protected void saveFreeTimeRequest(Element requestEl, FreeTimeRequest request) {
        TimeLocation tl;
        requestEl.addAttribute("id", this.getId("request", request.getId()));
        requestEl.addAttribute("priority", String.valueOf(request.getPriority()));
        if (request.isAlternative()) {
            requestEl.addAttribute("alternative", "true");
        }
        if (request.getWeight() != 1.0) {
            requestEl.addAttribute("weight", sStudentWeightFormat.format(request.getWeight()));
        }
        if ((tl = request.getTime()) != null) {
            requestEl.addAttribute("days", sDF[7].format(Long.parseLong(Integer.toBinaryString(tl.getDayCode()))));
            requestEl.addAttribute("start", String.valueOf(tl.getStartSlot()));
            requestEl.addAttribute("length", String.valueOf(tl.getLength()));
            if (this.iShowNames && tl.getDatePatternId() != null) {
                requestEl.addAttribute("datePattern", tl.getDatePatternId().toString());
            }
            requestEl.addAttribute("dates", StudentSectioningXMLSaver.bitset2string(tl.getWeekCode()));
            if (this.iShowNames) {
                requestEl.setText(tl.getLongName(true));
            }
        }
        if (this.iSaveInitial && request.getInitialAssignment() != null) {
            requestEl.addElement("initial");
        }
        if (this.iSaveCurrent && this.getAssignment().getValue(request) != null) {
            requestEl.addElement("current");
        }
        if (this.iSaveBest && request.getBestAssignment() != null) {
            requestEl.addElement("best");
        }
    }

    protected void saveCourseRequest(Element requestEl, CourseRequest request) {
        Element choiceEl;
        requestEl.addAttribute("id", this.getId("request", request.getId()));
        requestEl.addAttribute("priority", String.valueOf(request.getPriority()));
        if (request.isAlternative()) {
            requestEl.addAttribute("alternative", "true");
        }
        if (request.getWeight() != 1.0) {
            requestEl.addAttribute("weight", sStudentWeightFormat.format(request.getWeight()));
        }
        requestEl.addAttribute("waitlist", request.isWaitlist() ? "true" : "false");
        if (request.getTimeStamp() != null) {
            requestEl.addAttribute("timeStamp", request.getTimeStamp().toString());
        }
        boolean first = true;
        for (Course course : request.getCourses()) {
            if (first) {
                requestEl.addAttribute("course", this.getId("course", course.getId()));
            } else {
                requestEl.addElement("alternative").addAttribute("course", this.getId("course", course.getId()));
            }
            first = false;
        }
        for (Choice choice : request.getWaitlistedChoices()) {
            choiceEl = requestEl.addElement("waitlisted");
            choiceEl.addAttribute("offering", this.getId("offering", choice.getOffering().getId()));
            choiceEl.setText(choice.getId());
        }
        for (Choice choice : request.getSelectedChoices()) {
            choiceEl = requestEl.addElement("selected");
            choiceEl.addAttribute("offering", this.getId("offering", choice.getOffering().getId()));
            choiceEl.setText(choice.getId());
        }
        if (this.iSaveInitial && request.getInitialAssignment() != null) {
            this.saveEnrollment(requestEl.addElement("initial"), (Enrollment)request.getInitialAssignment());
        }
        if (this.iSaveCurrent && this.getAssignment().getValue(request) != null) {
            this.saveEnrollment(requestEl.addElement("current"), (Enrollment)this.getAssignment().getValue(request));
        }
        if (this.iSaveBest && request.getBestAssignment() != null) {
            this.saveEnrollment(requestEl.addElement("best"), (Enrollment)request.getBestAssignment());
        }
        for (RequestGroup g : request.getRequestGroups()) {
            Element groupEl = requestEl.addElement("group").addAttribute("id", this.getId("group", g.getId())).addAttribute("course", this.getId("course", g.getCourse().getId()));
            if (!this.iShowNames) continue;
            groupEl.addAttribute("name", g.getName());
        }
    }

    protected void saveEnrollment(Element assignmentEl, Enrollment enrollment) {
        if (enrollment.getReservation() != null) {
            assignmentEl.addAttribute("reservation", this.getId("reservation", enrollment.getReservation().getId()));
        }
        for (Section section : enrollment.getSections()) {
            Element sectionEl = assignmentEl.addElement("section").addAttribute("id", this.getId("section", section.getId()));
            if (!this.iShowNames) continue;
            sectionEl.setText(section.getName() + " " + (section.getTime() == null ? " Arr Hrs" : " " + section.getTime().getLongName(true)) + (section.getNrRooms() == 0 ? "" : " " + section.getPlacement().getRoomName(",")) + (section.hasInstructors() ? " " + section.getInstructorNames(",") : ""));
        }
    }

    protected void saveLinkedSections(Element root) {
        Element constrainstEl = root.addElement("constraints");
        for (LinkedSections linkedSections : ((StudentSectioningModel)this.getModel()).getLinkedSections()) {
            Element linkEl = constrainstEl.addElement("linked-sections");
            linkEl.addAttribute("mustBeUsed", linkedSections.isMustBeUsed() ? "true" : "false");
            for (Offering offering : linkedSections.getOfferings()) {
                for (Subpart subpart : linkedSections.getSubparts(offering)) {
                    for (Section section : linkedSections.getSections(subpart)) {
                        linkEl.addElement("section").addAttribute("offering", this.getId("offering", offering.getId())).addAttribute("id", this.getId("section", section.getId()));
                    }
                }
            }
        }
    }

    protected void saveTravelTimes(Element root) {
        Map<Long, Map<Long, Integer>> travelTimes;
        if (((StudentSectioningModel)this.getModel()).getDistanceConflict() != null && (travelTimes = ((StudentSectioningModel)this.getModel()).getDistanceConflict().getDistanceMetric().getTravelTimes()) != null) {
            Element travelTimesEl = root.addElement("travel-times");
            for (Map.Entry<Long, Map<Long, Integer>> e1 : travelTimes.entrySet()) {
                for (Map.Entry<Long, Integer> e2 : e1.getValue().entrySet()) {
                    travelTimesEl.addElement("travel-time").addAttribute("id1", this.getId("room", e1.getKey().toString())).addAttribute("id2", this.getId("room", e2.getKey().toString())).addAttribute("minutes", e2.getValue().toString());
                }
            }
        }
    }

    static {
        sStudentWeightFormat.setRoundingMode(RoundingMode.DOWN);
    }
}

