/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.cpsolver.ifs.util.DataProperties;

public class DistanceMetric {
    private Ellipsoid iModel = Ellipsoid.WGS84;
    private double iSpeed = 66.66666666666667;
    private double iInstructorNoPreferenceLimit = 0.0;
    private double iInstructorDiscouragedLimit = 50.0;
    private double iInstructorProhibitedLimit = 200.0;
    private double iInstructorLongTravelInMinutes = 30.0;
    private double iNullDistance = 10000.0;
    private int iMaxTravelTime = 60;
    private Map<Long, Map<Long, Integer>> iTravelTimes = new HashMap<Long, Map<Long, Integer>>();
    private Map<String, Double> iDistanceCache = new HashMap<String, Double>();
    private boolean iComputeDistanceConflictsBetweenNonBTBClasses = false;
    private final ReentrantReadWriteLock iLock = new ReentrantReadWriteLock();

    public DistanceMetric() {
    }

    public DistanceMetric(Ellipsoid model) {
        this.iModel = model;
        if (this.iModel == Ellipsoid.LEGACY) {
            this.iSpeed = 6.666666666666667;
            this.iInstructorDiscouragedLimit = 5.0;
            this.iInstructorProhibitedLimit = 20.0;
        }
    }

    public DistanceMetric(Ellipsoid model, double speed) {
        this.iModel = model;
        this.iSpeed = speed;
    }

    public DistanceMetric(DataProperties properties) {
        if (Ellipsoid.LEGACY.name().equals(properties.getProperty("Distances.Ellipsoid", Ellipsoid.LEGACY.name()))) {
            this.iModel = Ellipsoid.LEGACY;
            this.iSpeed = properties.getPropertyDouble("Student.DistanceLimit", 66.66666666666667) / 10.0;
            this.iInstructorNoPreferenceLimit = properties.getPropertyDouble("Instructor.NoPreferenceLimit", 0.0);
            this.iInstructorDiscouragedLimit = properties.getPropertyDouble("Instructor.DiscouragedLimit", 5.0);
            this.iInstructorProhibitedLimit = properties.getPropertyDouble("Instructor.ProhibitedLimit", 20.0);
            this.iNullDistance = properties.getPropertyDouble("Distances.NullDistance", 1000.0);
            this.iMaxTravelTime = properties.getPropertyInt("Distances.MaxTravelDistanceInMinutes", 60);
        } else {
            this.iModel = Ellipsoid.valueOf(properties.getProperty("Distances.Ellipsoid", Ellipsoid.WGS84.name()));
            if (this.iModel == null) {
                this.iModel = Ellipsoid.WGS84;
            }
            this.iSpeed = properties.getPropertyDouble("Distances.Speed", properties.getPropertyDouble("Student.DistanceLimit", 66.66666666666667));
            this.iInstructorNoPreferenceLimit = properties.getPropertyDouble("Instructor.NoPreferenceLimit", this.iInstructorNoPreferenceLimit);
            this.iInstructorDiscouragedLimit = properties.getPropertyDouble("Instructor.DiscouragedLimit", this.iInstructorDiscouragedLimit);
            this.iInstructorProhibitedLimit = properties.getPropertyDouble("Instructor.ProhibitedLimit", this.iInstructorProhibitedLimit);
            this.iNullDistance = properties.getPropertyDouble("Distances.NullDistance", this.iNullDistance);
            this.iMaxTravelTime = properties.getPropertyInt("Distances.MaxTravelDistanceInMinutes", 60);
        }
        this.iComputeDistanceConflictsBetweenNonBTBClasses = properties.getPropertyBoolean("Distances.ComputeDistanceConflictsBetweenNonBTBClasses", this.iComputeDistanceConflictsBetweenNonBTBClasses);
        this.iInstructorLongTravelInMinutes = properties.getPropertyDouble("Instructor.InstructorLongTravelInMinutes", 30.0);
    }

    protected double deg2rad(double deg) {
        return deg * Math.PI / 180.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public double getDistanceInMeters(Double lat1, Double lon1, Double lat2, Double lon2) {
        Double distance;
        if (lat1 == null || lat2 == null || lon1 == null || lon2 == null) {
            return this.iNullDistance;
        }
        if (lat1.equals(lat2) && lon1.equals(lon2)) {
            return 0.0;
        }
        if (this.iModel == Ellipsoid.LEGACY) {
            if (lat1 < 0.0 || lat2 < 0.0 || lon1 < 0.0 || lon2 < 0.0) {
                return this.iNullDistance;
            }
            double dx = lat1 - lat2;
            double dy = lon1 - lon2;
            return Math.sqrt(dx * dx + dy * dy);
        }
        String id = null;
        id = lat1 < lat2 || lat1 == lat2 && lon1 <= lon2 ? Long.toHexString(Double.doubleToRawLongBits(lat1)) + Long.toHexString(Double.doubleToRawLongBits(lon1)) + Long.toHexString(Double.doubleToRawLongBits(lat2)) + Long.toHexString(Double.doubleToRawLongBits(lon2)) : Long.toHexString(Double.doubleToRawLongBits(lat1)) + Long.toHexString(Double.doubleToRawLongBits(lon1)) + Long.toHexString(Double.doubleToRawLongBits(lat2)) + Long.toHexString(Double.doubleToRawLongBits(lon2));
        this.iLock.readLock().lock();
        try {
            distance = this.iDistanceCache.get(id);
            if (distance != null) {
                double dy = distance;
                return dy;
            }
        }
        finally {
            this.iLock.readLock().unlock();
        }
        this.iLock.writeLock().lock();
        try {
            double lambdaP;
            double cosSigma;
            double cos2SigmaM;
            double sinSigma;
            double sigma;
            double sinAlpha;
            double cosSqAlpha;
            double C;
            distance = this.iDistanceCache.get(id);
            if (distance != null) {
                double dy = distance;
                return dy;
            }
            double a = this.iModel.a();
            double b = this.iModel.b();
            double f = this.iModel.f();
            double L = this.deg2rad(lon2 - lon1);
            double U1 = Math.atan((1.0 - f) * Math.tan(this.deg2rad(lat1)));
            double U2 = Math.atan((1.0 - f) * Math.tan(this.deg2rad(lat2)));
            double sinU1 = Math.sin(U1);
            double cosU1 = Math.cos(U1);
            double sinU2 = Math.sin(U2);
            double cosU2 = Math.cos(U2);
            double lambda = L;
            double iterLimit = 100.0;
            do {
                double cosLambda;
                double sinLambda;
                if ((sinSigma = Math.sqrt(cosU2 * (sinLambda = Math.sin(lambda)) * (cosU2 * sinLambda) + (cosU1 * sinU2 - sinU1 * cosU2 * (cosLambda = Math.cos(lambda))) * (cosU1 * sinU2 - sinU1 * cosU2 * cosLambda))) == 0.0) {
                    double d = 0.0;
                    return d;
                }
                cosSigma = sinU1 * sinU2 + cosU1 * cosU2 * cosLambda;
                sigma = Math.atan2(sinSigma, cosSigma);
                sinAlpha = cosU1 * cosU2 * sinLambda / sinSigma;
                cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
                cos2SigmaM = cosSigma - 2.0 * sinU1 * sinU2 / cosSqAlpha;
                if (!Double.isNaN(cos2SigmaM)) continue;
                cos2SigmaM = 0.0;
            } while (Math.abs((lambda = L + (1.0 - (C = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha)))) * f * sinAlpha * (sigma + C * sinSigma * (cos2SigmaM + C * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)))) - (lambdaP = lambda)) > 1.0E-12 && (iterLimit -= 1.0) > 0.0);
            if (iterLimit == 0.0) {
                sinAlpha = Double.NaN;
                return sinAlpha;
            }
            double uSq = cosSqAlpha * (a * a - b * b) / (b * b);
            double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
            double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
            double deltaSigma = B * sinSigma * (cos2SigmaM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
            distance = b * A * (sigma - deltaSigma);
            this.iDistanceCache.put(id, distance);
            double d = distance;
            return d;
        }
        finally {
            this.iLock.writeLock().unlock();
        }
    }

    @Deprecated
    public int getDistanceInMinutes(double lat1, double lon1, double lat2, double lon2) {
        return (int)Math.round(this.getDistanceInMeters(lat1, lon1, lat2, lon2) / this.iSpeed);
    }

    public double minutes2meters(int min) {
        return this.iSpeed * (double)min;
    }

    public double getInstructorNoPreferenceLimit() {
        return this.iInstructorNoPreferenceLimit;
    }

    public double getInstructorDiscouragedLimit() {
        return this.iInstructorDiscouragedLimit;
    }

    public double getInstructorProhibitedLimit() {
        return this.iInstructorProhibitedLimit;
    }

    public double getInstructorLongTravelInMinutes() {
        return this.iInstructorLongTravelInMinutes;
    }

    public boolean isLegacy() {
        return this.iModel == Ellipsoid.LEGACY;
    }

    public int getMaxTravelDistanceInMinutes() {
        return this.iMaxTravelTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTravelTime(Long roomId1, Long roomId2, Integer travelTimeInMinutes) {
        this.iLock.writeLock().lock();
        try {
            if (roomId1 == null || roomId2 == null) {
                return;
            }
            if (roomId1 < roomId2) {
                Map<Long, Integer> times = this.iTravelTimes.get(roomId1);
                if (times == null) {
                    times = new HashMap<Long, Integer>();
                    this.iTravelTimes.put(roomId1, times);
                }
                if (travelTimeInMinutes == null) {
                    times.remove(roomId2);
                } else {
                    times.put(roomId2, travelTimeInMinutes);
                }
            } else {
                Map<Long, Integer> times = this.iTravelTimes.get(roomId2);
                if (times == null) {
                    times = new HashMap<Long, Integer>();
                    this.iTravelTimes.put(roomId2, times);
                }
                if (travelTimeInMinutes == null) {
                    times.remove(roomId1);
                } else {
                    times.put(roomId1, travelTimeInMinutes);
                }
            }
        }
        finally {
            this.iLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getTravelTimeInMinutes(Long roomId1, Long roomId2) {
        this.iLock.readLock().lock();
        try {
            if (roomId1 == null || roomId2 == null) {
                Integer n = null;
                return n;
            }
            if (roomId1 < roomId2) {
                Map<Long, Integer> times = this.iTravelTimes.get(roomId1);
                Integer n = times == null ? null : times.get(roomId2);
                return n;
            }
            Map<Long, Integer> times = this.iTravelTimes.get(roomId2);
            Integer n = times == null ? null : times.get(roomId1);
            return n;
        }
        finally {
            this.iLock.readLock().unlock();
        }
    }

    public Integer getDistanceInMinutes(Long roomId1, Double lat1, Double lon1, Long roomId2, Double lat2, Double lon2) {
        Integer distance = this.getTravelTimeInMinutes(roomId1, roomId2);
        if (distance != null) {
            return distance;
        }
        if (lat1 == null || lat2 == null || lon1 == null || lon2 == null) {
            return this.getMaxTravelDistanceInMinutes();
        }
        return (int)Math.min((long)this.getMaxTravelDistanceInMinutes(), Math.round(this.getDistanceInMeters(lat1, lon1, lat2, lon2) / this.iSpeed));
    }

    public double getDistanceInMeters(Long roomId1, Double lat1, Double lon1, Long roomId2, Double lat2, Double lon2) {
        Integer distance = this.getTravelTimeInMinutes(roomId1, roomId2);
        if (distance != null) {
            return this.minutes2meters(distance);
        }
        return this.getDistanceInMeters(lat1, lon1, lat2, lon2);
    }

    public Map<Long, Map<Long, Integer>> getTravelTimes() {
        return this.iTravelTimes;
    }

    public boolean doComputeDistanceConflictsBetweenNonBTBClasses() {
        return this.iComputeDistanceConflictsBetweenNonBTBClasses;
    }

    public static void main(String[] args) {
        System.out.println("Distance between Prague and Zlin: " + new DistanceMetric().getDistanceInMeters(50.087661, 14.420535, 49.226736, 17.668856) / 1000.0 + " km");
        System.out.println("Distance between ENAD and PMU: " + new DistanceMetric().getDistanceInMeters(40.428323, -86.912785, 40.425078, -86.911474) + " m");
        System.out.println("Distance between ENAD and ME: " + new DistanceMetric().getDistanceInMeters(40.428323, -86.912785, 40.429338, -86.91267) + " m");
        System.out.println("Distance between Prague and Zlin: " + new DistanceMetric().getDistanceInMinutes(50.087661, 14.420535, 49.226736, 17.668856) / 60 + " hours");
        System.out.println("Distance between ENAD and PMU: " + new DistanceMetric().getDistanceInMinutes(40.428323, -86.912785, 40.425078, -86.911474) + " minutes");
        System.out.println("Distance between ENAD and ME: " + new DistanceMetric().getDistanceInMinutes(40.428323, -86.912785, 40.429338, -86.91267) + " minutes");
    }

    public static enum Ellipsoid {
        LEGACY("Euclidean metric (1 unit equals to 10 meters)", "X-Coordinate", "Y-Coordinate", 0.0, 0.0, 0.0),
        WGS84("WGS-84 (GPS)", 6378137.0, 6356752.3142, 0.0033528106647474805),
        GRS80("GRS-80", 6378137.0, 6356752.3141, 0.003352810681182319),
        Airy1830("Airy (1830)", 6377563.396, 6356256.909, 0.0033408506414970775),
        Intl1924("Int'l 1924", 6378388.0, 6356911.946, 0.003367003367003367),
        Clarke1880("Clarke (1880)", 6378249.145, 6356514.86955, 0.003407561378699334),
        GRS67("GRS-67", 6378160.0, 6356774.719, 0.003352891869237217);

        private double iA;
        private double iB;
        private double iF;
        private String iName;
        private String iFirstCoord;
        private String iSecondCoord;

        private Ellipsoid(String name, double a, double b) {
            this(name, "Latitude", "Longitude", a, b, (a - b) / a);
        }

        private Ellipsoid(String name, double a, double b, double f) {
            this(name, "Latitude", "Longitude", a, b, f);
        }

        private Ellipsoid(String name, String xCoord, String yCoord, double a, double b, double f) {
            this.iName = name;
            this.iFirstCoord = xCoord;
            this.iSecondCoord = yCoord;
            this.iA = a;
            this.iB = b;
            this.iF = f;
        }

        public double a() {
            return this.iA;
        }

        public double b() {
            return this.iB;
        }

        public double f() {
            return this.iF;
        }

        public String getEclipsoindName() {
            return this.iName;
        }

        public String getFirstCoordinateName() {
            return this.iFirstCoord;
        }

        public String getSecondCoordinateName() {
            return this.iSecondCoord;
        }
    }
}

