/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;

public class ViolatedInitials<V extends Variable<V, T>, T extends Value<V, T>>
extends Extension<V, T> {
    private static Logger sLogger = Logger.getLogger(ViolatedInitials.class);
    private Map<T, Set<T>> iViolatedInitials = new HashMap<T, Set<T>>();

    public ViolatedInitials(Solver<V, T> solver, DataProperties properties) {
        super(solver, properties);
    }

    @Override
    public boolean init(Assignment<V, T> assignment) {
        sLogger.info("Computation of violated initials enabled.");
        for (Variable variable : this.getModel().variables()) {
            if (variable.getInitialAssignment() == null) continue;
            for (Constraint constraint : variable.hardConstraints()) {
                for (Value value : this.conflictValues(assignment, constraint, variable.getInitialAssignment())) {
                    this.addViolatedInitial(value, variable.getInitialAssignment());
                }
            }
        }
        return true;
    }

    public Set<T> getViolatedInitials(T value) {
        return this.iViolatedInitials.get(value);
    }

    private void addViolatedInitial(T value, T anotherValue) {
        Set<T> violations = this.iViolatedInitials.get(value);
        if (violations == null) {
            violations = new HashSet<T>();
            this.iViolatedInitials.put(value, violations);
        }
        violations.add(anotherValue);
    }

    private List<T> conflictValues(Assignment<V, T> assignment, Constraint<V, T> constraint, T aValue) {
        ArrayList<Value> ret = new ArrayList<Value>();
        for (Variable variable : constraint.variables()) {
            if (variable.equals(((Value)aValue).variable()) || assignment.getValue(variable) != null) continue;
            for (Value value : variable.values(assignment)) {
                if (constraint.isConsistent((Value)aValue, value)) continue;
                ret.add(value);
            }
        }
        return ret;
    }
}

