/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.neighbours;

import java.text.DecimalFormat;
import org.apache.log4j.Logger;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.SimpleNeighbour;

public class ExamSimpleNeighbour
extends SimpleNeighbour<Exam, ExamPlacement> {
    private static Logger sLog = Logger.getLogger(ExamSimpleNeighbour.class);
    private static boolean sCheck = false;
    private double iValue = 0.0;
    private double iDx;

    public ExamSimpleNeighbour(Assignment<Exam, ExamPlacement> assignment, ExamPlacement placement) {
        super(placement.variable(), placement);
        this.iValue = placement.toDouble(assignment);
        ExamPlacement current = assignment.getValue((Exam)placement.variable());
        this.iValue = current != null ? (this.iValue -= current.toDouble(assignment)) : (this.iValue -= 1000.0);
        if (sCheck) {
            this.iDx = placement.toDouble(assignment);
            if (current != null) {
                this.iDx -= current.toDouble(assignment);
            }
        }
    }

    @Override
    public void assign(Assignment<Exam, ExamPlacement> assignment, long iteration) {
        if (sCheck) {
            double beforeVal = ((Exam)this.getVariable()).getModel().getTotalValue(assignment);
            double[] beforeValM = ((ExamModel)((Exam)this.getVariable()).getModel()).getTotalMultiValue(assignment);
            String n = this.toString();
            assignment.assign(iteration, (ExamPlacement)this.getValue());
            double afterVal = ((Exam)this.getVariable()).getModel().getTotalValue(assignment);
            double[] afterValM = ((ExamModel)((Exam)this.getVariable()).getModel()).getTotalMultiValue(assignment);
            if (Math.abs(afterVal - beforeVal - this.iDx) >= 1.0E-7) {
                sLog.error("-- value mischmatch (delta:" + (afterVal - beforeVal) + ", value:" + this.iDx + ")");
                sLog.error("  -- neighbour: " + n);
                sLog.error("  -- solution:  " + ExamSimpleNeighbour.toString(afterValM, beforeValM));
            }
        } else {
            assignment.assign(iteration, (ExamPlacement)this.getValue());
        }
    }

    protected static String toString(double[] x) {
        DecimalFormat df = new DecimalFormat("0.00");
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < x.length; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(df.format(x[i]));
        }
        return "[" + s.toString() + "]";
    }

    protected static String toString(double[] x, double[] y) {
        DecimalFormat df = new DecimalFormat("0.00");
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < x.length; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(df.format(x[i] - y[i]));
        }
        return "[" + s.toString() + "]";
    }

    @Override
    public String toString() {
        return this.getVariable() + " := " + ((ExamPlacement)this.getValue()).toString() + " /  (value:" + this.value((Assignment<Exam, ExamPlacement>)null) + ")";
    }

    @Override
    public double value(Assignment<Exam, ExamPlacement> assignment) {
        return this.iValue;
    }
}

