/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria.additional;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class StudentMinimizeScheduleHoles
extends StudentConflict {
    public static double btbDistance(Placement p1, Placement p2) {
        if (p1 == null || p2 == null) {
            return 0.0;
        }
        return StudentMinimizeScheduleHoles.btbDistance(p1.getTimeLocation(), p2.getTimeLocation());
    }

    private static double btbDistance(TimeLocation t1, TimeLocation t2) {
        if (!t1.shareDays(t2) || !t1.shareWeeks(t2) || t1.shareHours(t2)) {
            return 0.0;
        }
        int s1 = t1.getStartSlot();
        int e1 = s1 + t1.getLength();
        int s2 = t2.getStartSlot();
        int e2 = s2 + t2.getLength();
        if (e1 < s2) {
            return (double)(t1.nrSharedDays(t2) * (s2 - e1)) / 12.0;
        }
        if (e2 < s1) {
            return (double)(t1.nrSharedDays(t2) * (s1 - e2)) / 12.0;
        }
        return 0.0;
    }

    @Override
    public boolean inConflict(Placement p1, Placement p2) {
        return StudentMinimizeScheduleHoles.btbDistance(p1, p2) > 0.0;
    }

    @Override
    protected double jointEnrollment(JenrlConstraint jenrl, Placement p1, Placement p2) {
        return StudentMinimizeScheduleHoles.btbDistance(p1, p2) * jenrl.jenrl();
    }

    @Override
    protected double jointEnrollment(JenrlConstraint jenrl) {
        double max = 0.0;
        for (TimeLocation t1 : ((Lecture)jenrl.first()).timeLocations()) {
            for (TimeLocation t2 : ((Lecture)jenrl.second()).timeLocations()) {
                double distance = StudentMinimizeScheduleHoles.btbDistance(t1, t2);
                if (!(distance > max)) continue;
                max = distance;
            }
        }
        return max;
    }

    @Override
    public boolean isApplicable(Lecture l1, Lecture l2) {
        return l1 != null && l2 != null && !StudentMinimizeScheduleHoles.ignore(l1, l2) && StudentMinimizeScheduleHoles.applicable(l1, l2);
    }

    @Override
    public void incJenrl(Assignment<Lecture, Placement> assignment, JenrlConstraint jenrl, double studentWeight, Double conflictPriority, Student student) {
        if (this.isApplicable(student, (Lecture)jenrl.first(), (Lecture)jenrl.second())) {
            this.inc(assignment, studentWeight * StudentMinimizeScheduleHoles.btbDistance(assignment.getValue((Lecture)jenrl.first()), assignment.getValue((Lecture)jenrl.second())));
        }
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.MinimizeStudentScheduleHolesWeight", 0.05 * config.getPropertyDouble("Comparator.StudentConflictWeight", 1.0));
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.MinimizeStudentScheduleHolesWeight";
    }

    @Override
    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info) {
        super.getInfo(assignment, info);
        double total = 0.0;
        for (JenrlConstraint jenrl : ((TimetableModel)this.getModel()).getJenrlConstraints()) {
            if (jenrl.isToBeIgnored()) continue;
            total += jenrl.jenrl();
        }
        info.put("Student class distance", sDoubleFormat.format(this.getValue(assignment) / total) + " hours");
    }

    @Override
    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info, Collection<Lecture> variables) {
        super.getInfo(assignment, info, variables);
        HashSet<JenrlConstraint> jenrls = new HashSet<JenrlConstraint>();
        double distance = 0.0;
        double total = 0.0;
        for (Lecture lecture : variables) {
            for (JenrlConstraint jenrl : lecture.jenrlConstraints()) {
                if (!jenrls.add(jenrl) || jenrl.isToBeIgnored()) continue;
                distance += jenrl.jenrl() * StudentMinimizeScheduleHoles.btbDistance(assignment.getValue((Lecture)jenrl.first()), assignment.getValue((Lecture)jenrl.second()));
                total += jenrl.jenrl();
            }
        }
        info.put("Student class distance", sDoubleFormat.format(distance / total) + " hours");
    }
}

