/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.criteria.FlexibleConstraintCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.util.ToolBox;

public class MaxDaysFlexibleConstraint
extends FlexibleConstraint {
    private int iMaxDays;

    public MaxDaysFlexibleConstraint(Long id, String owner, String preference, String reference) {
        super(id, owner, preference, reference);
        Matcher matcher = Pattern.compile(FlexibleConstraint.FlexibleConstraintType.MAX_DAYS.getPattern()).matcher(reference);
        if (matcher.find()) {
            this.iMaxDays = Integer.parseInt(matcher.group(2));
            this.iConstraintType = FlexibleConstraint.FlexibleConstraintType.MAX_DAYS;
        }
    }

    @Override
    public double getNrViolations(Assignment<Lecture, Placement> assignment, Set<Placement> conflicts, HashMap<Lecture, Placement> assignments) {
        return ((MaxDaysFlexibleConstraintContext)this.getContext((Assignment)assignment)).nrViolations(assignments, conflicts);
    }

    @Override
    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        if (!this.isHard()) {
            return;
        }
        MaxDaysFlexibleConstraintContext context = (MaxDaysFlexibleConstraintContext)this.getContext((Assignment)assignment);
        while (context.nrDays(value, conflicts) > this.iMaxDays) {
            Set<Lecture> candidates = context.candidates(value, conflicts);
            if (candidates == null) {
                return;
            }
            for (Lecture candidate : candidates) {
                Placement conflict = assignment.getValue(candidate);
                if (conflict == null) continue;
                conflicts.add(conflict);
            }
        }
    }

    @Override
    public boolean inConflict(Assignment<Lecture, Placement> assignment, Placement value) {
        if (!this.isHard()) {
            return false;
        }
        return ((MaxDaysFlexibleConstraintContext)this.getContext((Assignment)assignment)).nrDays(value, null) > this.iMaxDays;
    }

    @Override
    public FlexibleConstraint.FlexibleConstraintContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new MaxDaysFlexibleConstraintContext(assignment);
    }

    public class MaxDaysFlexibleConstraintContext
    extends FlexibleConstraint.FlexibleConstraintContext {
        private Set<Lecture>[] iDayAssignments;

        public MaxDaysFlexibleConstraintContext(Assignment<Lecture, Placement> assignment) {
            Criterion<Lecture, Placement> criterion;
            super(MaxDaysFlexibleConstraint.this);
            this.iDayAssignments = null;
            this.iDayAssignments = new Set[Constants.NR_DAYS];
            for (int i = 0; i < this.iDayAssignments.length; ++i) {
                this.iDayAssignments[i] = new HashSet<Lecture>();
            }
            for (Lecture variable : MaxDaysFlexibleConstraint.this.variables()) {
                Placement value = assignment.getValue(variable);
                if (value == null) continue;
                for (int i = 0; i < this.iDayAssignments.length; ++i) {
                    if ((value.getTimeLocation().getDayCode() & Constants.DAY_CODES[i]) == 0) continue;
                    this.iDayAssignments[i].add((Lecture)value.variable());
                }
            }
            if (!MaxDaysFlexibleConstraint.this.isHard() && (criterion = MaxDaysFlexibleConstraint.this.getModel().getCriterion(FlexibleConstraintCriterion.class)) != null) {
                double pref = this.nrViolations(null, null);
                this.iLastPreference = pref == 0.0 ? (double)(-Math.abs(MaxDaysFlexibleConstraint.this.iPreference)) : (double)Math.abs(MaxDaysFlexibleConstraint.this.iPreference) * pref;
                criterion.inc(assignment, this.iLastPreference);
            }
        }

        @Override
        public void assigned(Assignment<Lecture, Placement> assignment, Placement value) {
            for (int i = 0; i < this.iDayAssignments.length; ++i) {
                if ((value.getTimeLocation().getDayCode() & Constants.DAY_CODES[i]) == 0) continue;
                this.iDayAssignments[i].add((Lecture)value.variable());
            }
            this.updateCriterion(assignment);
        }

        @Override
        public void unassigned(Assignment<Lecture, Placement> assignment, Placement value) {
            for (int i = 0; i < this.iDayAssignments.length; ++i) {
                if ((value.getTimeLocation().getDayCode() & Constants.DAY_CODES[i]) == 0) continue;
                this.iDayAssignments[i].remove(value.variable());
            }
            this.updateCriterion(assignment);
        }

        public int nrDays(Placement value, Set<Placement> conflicts) {
            int ret = 0;
            for (int i = 0; i < this.iDayAssignments.length; ++i) {
                int cnt = this.iDayAssignments[i].size();
                if (value != null) {
                    if ((value.getTimeLocation().getDayCode() & Constants.DAY_CODES[i]) != 0) {
                        ++cnt;
                    }
                    if (this.iDayAssignments[i].contains(value.variable())) {
                        --cnt;
                    }
                }
                if (conflicts != null) {
                    for (Placement conflict : conflicts) {
                        if (value != null && ((Lecture)conflict.variable()).equals(value.variable()) || !this.iDayAssignments[i].contains(conflict.variable())) continue;
                        --cnt;
                    }
                }
                if (cnt <= 0) continue;
                ++ret;
            }
            return ret;
        }

        public Set<Lecture> candidates(Placement value, Set<Placement> conflicts) {
            int bestCnt = 0;
            ArrayList<Integer> bestWeeks = new ArrayList<Integer>();
            for (int i = 0; i < this.iDayAssignments.length; ++i) {
                if ((value.getTimeLocation().getDayCode() & Constants.DAY_CODES[i]) != 0) continue;
                int cnt = this.iDayAssignments[i].size();
                if (this.iDayAssignments[i].contains(value.variable())) {
                    --cnt;
                }
                for (Placement conflict : conflicts) {
                    if (((Lecture)conflict.variable()).equals(value.variable()) || !this.iDayAssignments[i].contains(conflict.variable())) continue;
                    --cnt;
                }
                if (cnt <= 0) continue;
                if (bestWeeks.isEmpty() || bestCnt > cnt) {
                    bestWeeks.clear();
                    bestWeeks.add(i);
                    bestCnt = cnt;
                    continue;
                }
                if (bestCnt != cnt) continue;
                bestWeeks.add(i);
            }
            return bestWeeks.isEmpty() ? null : this.iDayAssignments[(Integer)ToolBox.random(bestWeeks)];
        }

        public int nrViolations(HashMap<Lecture, Placement> assignments, Set<Placement> conflicts) {
            int days = 0;
            for (int i = 0; i < this.iDayAssignments.length; ++i) {
                int cnt = this.iDayAssignments[i].size();
                if (assignments != null) {
                    for (Map.Entry entry : assignments.entrySet()) {
                        Placement assignment = (Placement)entry.getValue();
                        if (assignment == null || (assignment.getTimeLocation().getDayCode() & Constants.DAY_CODES[i]) == 0) continue;
                        ++cnt;
                    }
                }
                if (conflicts != null) {
                    for (Placement placement : conflicts) {
                        if (assignments != null && assignments.containsKey(placement.variable()) || !this.iDayAssignments[i].contains(placement.variable())) continue;
                        --cnt;
                    }
                }
                if (cnt <= 0) continue;
                ++days;
            }
            return days <= MaxDaysFlexibleConstraint.this.iMaxDays ? 0 : days - MaxDaysFlexibleConstraint.this.iMaxDays;
        }
    }
}

