/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.ICalVersion;
import biweekly.Warning;
import biweekly.component.ICalComponent;
import biweekly.property.ICalProperty;
import biweekly.util.VersionNumber;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
extends ICalProperty {
    public static final VersionNumber VCAL = new VersionNumber(ICalVersion.V1_0.getVersion());
    public static final VersionNumber ICAL = new VersionNumber(ICalVersion.V2_0.getVersion());
    private VersionNumber minVersion;
    private VersionNumber maxVersion;

    public Version(ICalVersion version) {
        this(version == null ? null : version.getVersion());
    }

    public Version(String version) {
        this(null, version);
    }

    public Version(String minVersion, String maxVersion) {
        this(minVersion == null ? null : new VersionNumber(minVersion), maxVersion == null ? null : new VersionNumber(maxVersion));
    }

    private Version(VersionNumber minVersion, VersionNumber maxVersion) {
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
    }

    public static Version v1_0() {
        return new Version(ICalVersion.V1_0);
    }

    public static Version v2_0() {
        return new Version(ICalVersion.V2_0);
    }

    public boolean isV1_0() {
        return VCAL.equals(this.maxVersion);
    }

    public boolean isV2_0() {
        return ICAL.equals(this.maxVersion);
    }

    public VersionNumber getMinVersion() {
        return this.minVersion;
    }

    public void setMinVersion(VersionNumber minVersion) {
        this.minVersion = minVersion;
    }

    public VersionNumber getMaxVersion() {
        return this.maxVersion;
    }

    public void setMaxVersion(VersionNumber maxVersion) {
        this.maxVersion = maxVersion;
    }

    public ICalVersion toICalVersion() {
        if (this.minVersion == null && this.maxVersion != null) {
            return ICalVersion.get(this.maxVersion.toString());
        }
        return null;
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<Warning> warnings) {
        if (this.maxVersion == null) {
            warnings.add(Warning.validate(35, new Object[0]));
        }
    }
}

