/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.text;

import biweekly.ICalVersion;
import biweekly.io.text.FoldedLineWriter;
import biweekly.parameter.Encoding;
import biweekly.parameter.ICalParameters;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ICalRawWriter
implements Closeable,
Flushable {
    private static final Pattern quoteMeRegex = Pattern.compile(".*?[,:;].*");
    private static final Pattern newlineRegex = Pattern.compile("\\r\\n|\\r|\\n");
    private static final Pattern propertyNameRegex = Pattern.compile("(?i)[-a-z0-9]+");
    private static final Map<ICalVersion, BitSet> invalidParamValueChars;
    private final FoldedLineWriter writer;
    private boolean caretEncodingEnabled = false;
    private ICalVersion version;

    public ICalRawWriter(Writer writer, ICalVersion version) {
        this.writer = new FoldedLineWriter(writer);
        this.version = version;
    }

    public FoldedLineWriter getFoldedLineWriter() {
        return this.writer;
    }

    public boolean isCaretEncodingEnabled() {
        return this.caretEncodingEnabled;
    }

    public void setCaretEncodingEnabled(boolean enable) {
        this.caretEncodingEnabled = enable;
    }

    public ICalVersion getVersion() {
        return this.version;
    }

    public void setVersion(ICalVersion version) {
        this.version = version;
    }

    public void writeBeginComponent(String componentName) throws IOException {
        this.writeProperty("BEGIN", componentName);
    }

    public void writeEndComponent(String componentName) throws IOException {
        this.writeProperty("END", componentName);
    }

    public void writeVersion() throws IOException {
        this.writeProperty("VERSION", this.version.getVersion());
    }

    public void writeProperty(String propertyName, String value) throws IOException {
        this.writeProperty(propertyName, new ICalParameters(), value);
    }

    public void writeProperty(String propertyName, ICalParameters parameters, String value) throws IOException {
        if (!propertyNameRegex.matcher(propertyName).matches()) {
            throw new IllegalArgumentException("Property name invalid.  Property names can only contain letters, numbers, and hyphens.");
        }
        value = this.sanitizeValue(parameters, value);
        boolean useQuotedPrintable = parameters.getEncoding() == Encoding.QUOTED_PRINTABLE;
        Charset quotedPrintableCharset = null;
        if (useQuotedPrintable) {
            String charsetParam = parameters.getCharset();
            if (charsetParam == null) {
                quotedPrintableCharset = Charset.forName("UTF-8");
            } else {
                try {
                    quotedPrintableCharset = Charset.forName(charsetParam);
                }
                catch (Throwable t) {
                    quotedPrintableCharset = Charset.forName("UTF-8");
                }
            }
            parameters.setCharset(quotedPrintableCharset.name());
        }
        this.writer.append(propertyName);
        for (Map.Entry subType : parameters) {
            String parameterName = (String)subType.getKey();
            List parameterValues = subType.getValue();
            if (parameterValues.isEmpty()) continue;
            if (this.version == ICalVersion.V1_0) {
                for (String parameterValue : parameterValues) {
                    parameterValue = this.sanitizeParameterValue(parameterValue, parameterName, propertyName);
                    this.writer.append(';').append(parameterName).append('=').append(parameterValue);
                }
                continue;
            }
            boolean first = true;
            this.writer.append(';').append(parameterName).append('=');
            for (String parameterValue : parameterValues) {
                if (!first) {
                    this.writer.append(',');
                }
                if (this.containsSpecialChars(parameterValue = this.sanitizeParameterValue(parameterValue, parameterName, propertyName))) {
                    this.writer.append('\"').append(parameterValue).append('\"');
                } else {
                    this.writer.append(parameterValue);
                }
                first = false;
            }
        }
        this.writer.append(':');
        this.writer.append((CharSequence)value, useQuotedPrintable, quotedPrintableCharset);
        this.writer.append(this.writer.getNewline());
    }

    private String sanitizeValue(ICalParameters parameters, String value) {
        if (value == null) {
            return "";
        }
        if (this.version == ICalVersion.V1_0 && this.containsNewlines(value)) {
            parameters.setEncoding(Encoding.QUOTED_PRINTABLE);
            return value;
        }
        return this.escapeNewlines(value);
    }

    private String sanitizeParameterValue(String parameterValue, String parameterName, String propertyName) {
        parameterValue = this.removeInvalidParameterValueChars(parameterValue);
        switch (this.version) {
            case V1_0: {
                parameterValue = newlineRegex.matcher(parameterValue).replaceAll(" ");
                parameterValue = parameterValue.replace("\\", "\\\\");
                parameterValue = parameterValue.replace(";", "\\;");
                break;
            }
            default: {
                if (this.caretEncodingEnabled) {
                    parameterValue = this.applyCaretEncoding(parameterValue);
                    break;
                }
                parameterValue = parameterValue.replace('\"', '\'');
                parameterValue = newlineRegex.matcher(parameterValue).replaceAll(" ");
            }
        }
        return parameterValue;
    }

    private String removeInvalidParameterValueChars(String value) {
        BitSet invalidChars = invalidParamValueChars.get((Object)this.version);
        StringBuilder sb = null;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (invalidChars.get(ch)) {
                if (sb != null) continue;
                sb = new StringBuilder(value.length());
                sb.append(value.substring(0, i));
                continue;
            }
            if (sb == null) continue;
            sb.append(ch);
        }
        return sb == null ? value : sb.toString();
    }

    private String applyCaretEncoding(String value) {
        value = value.replace("^", "^^");
        value = newlineRegex.matcher(value).replaceAll("^n");
        value = value.replace("\"", "^'");
        return value;
    }

    private String escapeNewlines(String text) {
        return newlineRegex.matcher(text).replaceAll("\\\\n");
    }

    private boolean containsNewlines(String text) {
        return newlineRegex.matcher(text).find();
    }

    private boolean containsSpecialChars(String parameterValue) {
        return quoteMeRegex.matcher(parameterValue).matches();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    static {
        BitSet controlChars = new BitSet(128);
        controlChars.set(0, 31);
        controlChars.set(127);
        controlChars.set(9, false);
        controlChars.set(10, false);
        controlChars.set(13, false);
        HashMap<ICalVersion, BitSet> map = new HashMap<ICalVersion, BitSet>();
        BitSet bitSet = new BitSet(128);
        bitSet.or(controlChars);
        bitSet.set(44);
        bitSet.set(46);
        bitSet.set(58);
        bitSet.set(61);
        bitSet.set(91);
        bitSet.set(93);
        map.put(ICalVersion.V1_0, bitSet);
        bitSet = new BitSet(128);
        bitSet.or(controlChars);
        map.put(ICalVersion.V2_0_DEPRECATED, bitSet);
        map.put(ICalVersion.V2_0, bitSet);
        invalidParamValueChars = Collections.unmodifiableMap(map);
    }
}

