/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.Warning;
import biweekly.component.ICalComponent;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.TimezoneInfo;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.DateStart;
import biweekly.property.ICalProperty;
import biweekly.property.RecurrenceProperty;
import biweekly.property.ValuedProperty;
import biweekly.util.ICalDate;
import biweekly.util.ListMultimap;
import biweekly.util.Recurrence;
import biweekly.util.XmlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RecurrencePropertyScribe<T extends RecurrenceProperty>
extends ICalPropertyScribe<T> {
    private static final String FREQ = "FREQ";
    private static final String UNTIL = "UNTIL";
    private static final String COUNT = "COUNT";
    private static final String INTERVAL = "INTERVAL";
    private static final String BYSECOND = "BYSECOND";
    private static final String BYMINUTE = "BYMINUTE";
    private static final String BYHOUR = "BYHOUR";
    private static final String BYDAY = "BYDAY";
    private static final String BYMONTHDAY = "BYMONTHDAY";
    private static final String BYYEARDAY = "BYYEARDAY";
    private static final String BYWEEKNO = "BYWEEKNO";
    private static final String BYMONTH = "BYMONTH";
    private static final String BYSETPOS = "BYSETPOS";
    private static final String WKST = "WKST";

    public RecurrencePropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName);
    }

    @Override
    protected ICalDataType _defaultDataType(ICalVersion version) {
        return ICalDataType.RECUR;
    }

    @Override
    protected String _writeText(T property, WriteContext context) {
        Recurrence recur = (Recurrence)((ValuedProperty)property).getValue();
        if (recur == null) {
            return "";
        }
        if (context.getVersion() != ICalVersion.V1_0) {
            ListMultimap<String, Object> components = this.buildComponents(property, context, false);
            return RecurrencePropertyScribe.object(components.getMap());
        }
        Recurrence.Frequency frequency = recur.getFrequency();
        if (frequency == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Integer interval = recur.getInterval();
        if (interval == null) {
            interval = 1;
        }
        switch (frequency) {
            case YEARLY: {
                if (!recur.getByMonth().isEmpty()) {
                    sb.append("YM").append(interval);
                    for (Integer month : recur.getByMonth()) {
                        sb.append(' ').append(month);
                    }
                } else {
                    sb.append("YD").append(interval);
                    for (Integer day : recur.getByYearDay()) {
                        sb.append(' ').append(day);
                    }
                }
                break;
            }
            case MONTHLY: {
                if (!recur.getByMonthDay().isEmpty()) {
                    sb.append("MD").append(interval);
                    for (Integer day : recur.getByMonthDay()) {
                        sb.append(' ').append(this.writeVCalInt(day));
                    }
                } else {
                    sb.append("MP").append(interval);
                    for (Recurrence.ByDay byDay : recur.getByDay()) {
                        Recurrence.DayOfWeek day = byDay.getDay();
                        Integer prefix = byDay.getNum();
                        if (prefix == null) {
                            prefix = 1;
                        }
                        sb.append(' ').append(this.writeVCalInt(prefix)).append(' ').append(day.getAbbr());
                    }
                }
                break;
            }
            case WEEKLY: {
                sb.append("W").append(interval);
                for (Recurrence.ByDay byDay : recur.getByDay()) {
                    sb.append(' ').append(byDay.getDay().getAbbr());
                }
                break;
            }
            case DAILY: {
                sb.append("D").append(interval);
                break;
            }
            case HOURLY: {
                sb.append("M").append(interval * 60);
                break;
            }
            case MINUTELY: {
                sb.append("M").append(interval);
                break;
            }
            default: {
                return "";
            }
        }
        Integer count = recur.getCount();
        ICalDate until = recur.getUntil();
        sb.append(' ');
        if (count != null) {
            sb.append('#').append(count);
        } else if (until != null) {
            String dateStr = RecurrencePropertyScribe.date(until, property, context).extended(false).write();
            sb.append(dateStr);
        } else {
            sb.append("#0");
        }
        return sb.toString();
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        final Recurrence.Builder builder = new Recurrence.Builder((Recurrence.Frequency)null);
        if (value.length() == 0) {
            return this.newInstance(builder.build());
        }
        if (context.getVersion() != ICalVersion.V1_0) {
            ListMultimap<String, String> rules = RecurrencePropertyScribe.object(value);
            List<Warning> warnings = context.getWarnings();
            this.parseFreq(rules, builder, warnings);
            this.parseUntil(rules, builder, warnings);
            this.parseCount(rules, builder, warnings);
            this.parseInterval(rules, builder, warnings);
            this.parseBySecond(rules, builder, warnings);
            this.parseByMinute(rules, builder, warnings);
            this.parseByHour(rules, builder, warnings);
            this.parseByDay(rules, builder, warnings);
            this.parseByMonthDay(rules, builder, warnings);
            this.parseByYearDay(rules, builder, warnings);
            this.parseByWeekNo(rules, builder, warnings);
            this.parseByMonth(rules, builder, warnings);
            this.parseBySetPos(rules, builder, warnings);
            this.parseWkst(rules, builder, warnings);
            this.parseXRules(rules, builder, warnings);
            T property = this.newInstance(builder.build());
            ICalDate until = ((Recurrence)((ValuedProperty)property).getValue()).getUntil();
            if (until != null) {
                context.addDate(until, (ICalProperty)property, parameters);
            }
            return property;
        }
        String[] splitValues = value.toUpperCase().split("\\s+");
        String firstToken = splitValues[0];
        Pattern p = Pattern.compile("^([A-Z]+)(\\d+)$");
        Matcher m = p.matcher(firstToken);
        if (!m.find()) {
            throw new CannotParseException("Invalid token: " + firstToken);
        }
        String frequencyStr = m.group(1);
        Integer interval = Integer.valueOf(m.group(2));
        splitValues = Arrays.copyOfRange(splitValues, 1, splitValues.length);
        builder.interval(interval);
        Integer count = null;
        ICalDate until = null;
        if (splitValues.length == 0) {
            count = 2;
        } else {
            String lastToken = splitValues[splitValues.length - 1];
            if (lastToken.startsWith("#")) {
                String countStr = lastToken.substring(1, lastToken.length());
                count = Integer.valueOf(countStr);
                if (count == 0) {
                    count = null;
                }
                splitValues = Arrays.copyOfRange(splitValues, 0, splitValues.length - 1);
            } else {
                try {
                    until = RecurrencePropertyScribe.date(lastToken).parse();
                    splitValues = Arrays.copyOfRange(splitValues, 0, splitValues.length - 1);
                }
                catch (IllegalArgumentException e) {
                    count = 2;
                }
            }
        }
        builder.count(count);
        builder.until(until);
        Recurrence.Frequency frequency = null;
        Handler<String> handler = null;
        if ("YD".equals(frequencyStr)) {
            frequency = Recurrence.Frequency.YEARLY;
            handler = new Handler<String>(){

                @Override
                public void handle(String value) {
                    if (value == null) {
                        return;
                    }
                    Integer dayOfYear = Integer.valueOf(value);
                    builder.byYearDay(dayOfYear);
                }
            };
        } else if ("YM".equals(frequencyStr)) {
            frequency = Recurrence.Frequency.YEARLY;
            handler = new Handler<String>(){

                @Override
                public void handle(String value) {
                    if (value == null) {
                        return;
                    }
                    Integer month = Integer.valueOf(value);
                    builder.byMonth(month);
                }
            };
        } else if ("MD".equals(frequencyStr)) {
            frequency = Recurrence.Frequency.MONTHLY;
            handler = new Handler<String>(){

                @Override
                public void handle(String value) {
                    if (value == null) {
                        return;
                    }
                    Integer date = "LD".equals(value) ? -1 : RecurrencePropertyScribe.this.parseVCalInt(value);
                    builder.byMonthDay(date);
                }
            };
        } else if ("MP".equals(frequencyStr)) {
            frequency = Recurrence.Frequency.MONTHLY;
            handler = new Handler<String>(){
                private final List<Integer> nums = new ArrayList<Integer>();
                private final List<Recurrence.DayOfWeek> days = new ArrayList<Recurrence.DayOfWeek>();
                private boolean readNum = false;

                @Override
                public void handle(String value) {
                    if (value == null) {
                        for (Integer num : this.nums) {
                            for (Recurrence.DayOfWeek day : this.days) {
                                builder.byDay(num, day);
                            }
                        }
                        return;
                    }
                    if (value.matches("\\d{4}")) {
                        this.readNum = false;
                        Integer hour = Integer.valueOf(value.substring(0, 2));
                        builder.byHour(hour);
                        Integer minute = Integer.valueOf(value.substring(2, 4));
                        builder.byMinute(minute);
                        return;
                    }
                    try {
                        Integer curNum = RecurrencePropertyScribe.this.parseVCalInt(value);
                        if (!this.readNum) {
                            for (Integer num : this.nums) {
                                for (Recurrence.DayOfWeek day : this.days) {
                                    builder.byDay(num, day);
                                }
                            }
                            this.nums.clear();
                            this.days.clear();
                            this.readNum = true;
                        }
                        this.nums.add(curNum);
                    }
                    catch (NumberFormatException e) {
                        this.readNum = false;
                        Recurrence.DayOfWeek day = RecurrencePropertyScribe.this.parseDay(value);
                        this.days.add(day);
                    }
                }
            };
        } else if ("W".equals(frequencyStr)) {
            frequency = Recurrence.Frequency.WEEKLY;
            handler = new Handler<String>(){

                @Override
                public void handle(String value) {
                    if (value == null) {
                        return;
                    }
                    Recurrence.DayOfWeek day = RecurrencePropertyScribe.this.parseDay(value);
                    builder.byDay(day);
                }
            };
        } else if ("D".equals(frequencyStr)) {
            frequency = Recurrence.Frequency.DAILY;
            handler = new Handler<String>(){

                @Override
                public void handle(String value) {
                    if (value == null) {
                        return;
                    }
                    Integer hour = Integer.valueOf(value.substring(0, 2));
                    builder.byHour(hour);
                    Integer minute = Integer.valueOf(value.substring(2, 4));
                    builder.byMinute(minute);
                }
            };
        } else if ("M".equals(frequencyStr)) {
            frequency = Recurrence.Frequency.MINUTELY;
            handler = new Handler<String>(){

                @Override
                public void handle(String value) {
                }
            };
        } else {
            throw new CannotParseException("Unrecognized frequency: " + frequencyStr);
        }
        builder.frequency(frequency);
        for (String splitValue : splitValues) {
            if (splitValue.endsWith("$")) {
                context.addWarning(36, splitValue);
                splitValue = splitValue.substring(0, splitValue.length() - 1);
            }
            handler.handle(splitValue);
        }
        handler.handle(null);
        T property = this.newInstance(builder.build());
        if (until != null) {
            context.addDate(until, (ICalProperty)property, parameters);
        }
        return property;
    }

    private int parseVCalInt(String value) {
        int negate = 1;
        if (value.endsWith("+")) {
            value = value.substring(0, value.length() - 1);
        } else if (value.endsWith("-")) {
            value = value.substring(0, value.length() - 1);
            negate = -1;
        }
        return Integer.parseInt(value) * negate;
    }

    private String writeVCalInt(Integer value) {
        if (value > 0) {
            return value + "+";
        }
        if (value < 0) {
            return Math.abs(value) + "-";
        }
        return value + "";
    }

    private Recurrence.DayOfWeek parseDay(String value) {
        Recurrence.DayOfWeek day = Recurrence.DayOfWeek.valueOfAbbr(value);
        if (day == null) {
            throw new CannotParseException("Invalid day: " + value);
        }
        return day;
    }

    @Override
    protected void _writeXml(T property, XCalElement element, WriteContext context) {
        XCalElement recurElement = element.append(this.dataType(property, null));
        Recurrence recur = (Recurrence)((ValuedProperty)property).getValue();
        if (recur == null) {
            return;
        }
        ListMultimap<String, Object> components = this.buildComponents(property, context, true);
        for (Map.Entry<String, List<Object>> entry : components) {
            String name = entry.getKey().toLowerCase();
            for (Object value : entry.getValue()) {
                recurElement.append(name, value.toString());
            }
        }
    }

    @Override
    protected T _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        ICalDataType dataType = this.defaultDataType(context.getVersion());
        XCalElement value = element.child(dataType);
        if (value == null) {
            throw RecurrencePropertyScribe.missingXmlElements(dataType);
        }
        ListMultimap<String, String> rules = new ListMultimap<String, String>();
        for (Element child : XmlUtils.toElementList(value.getElement().getChildNodes())) {
            if (!"urn:ietf:params:xml:ns:icalendar-2.0".equals(child.getNamespaceURI())) continue;
            String name = child.getLocalName().toUpperCase();
            String text = child.getTextContent();
            rules.put(name, text);
        }
        Recurrence.Builder builder = new Recurrence.Builder((Recurrence.Frequency)null);
        List<Warning> warnings = context.getWarnings();
        this.parseFreq(rules, builder, warnings);
        this.parseUntil(rules, builder, warnings);
        this.parseCount(rules, builder, warnings);
        this.parseInterval(rules, builder, warnings);
        this.parseBySecond(rules, builder, warnings);
        this.parseByMinute(rules, builder, warnings);
        this.parseByHour(rules, builder, warnings);
        this.parseByDay(rules, builder, warnings);
        this.parseByMonthDay(rules, builder, warnings);
        this.parseByYearDay(rules, builder, warnings);
        this.parseByWeekNo(rules, builder, warnings);
        this.parseByMonth(rules, builder, warnings);
        this.parseBySetPos(rules, builder, warnings);
        this.parseWkst(rules, builder, warnings);
        this.parseXRules(rules, builder, warnings);
        T property = this.newInstance(builder.build());
        ICalDate until = ((Recurrence)((ValuedProperty)property).getValue()).getUntil();
        if (until != null) {
            context.addDate(until, (ICalProperty)property, parameters);
        }
        return property;
    }

    @Override
    protected JCalValue _writeJson(T property, WriteContext context) {
        Recurrence recur = (Recurrence)((ValuedProperty)property).getValue();
        if (recur == null) {
            return JCalValue.object(new ListMultimap<String, Object>(0));
        }
        ListMultimap<String, Object> components = this.buildComponents(property, context, true);
        ListMultimap<String, Object> object = new ListMultimap<String, Object>(components.keySet().size());
        for (Map.Entry<String, List<Object>> entry : components) {
            String key = entry.getKey().toLowerCase();
            object.putAll(key, (Collection<Object>)entry.getValue());
        }
        return JCalValue.object(object);
    }

    @Override
    protected T _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        Recurrence.Builder builder = new Recurrence.Builder((Recurrence.Frequency)null);
        ListMultimap<String, String> object = value.asObject();
        ListMultimap<String, String> rules = new ListMultimap<String, String>(object.keySet().size());
        for (Map.Entry<String, List<String>> entry : object) {
            String key = entry.getKey().toUpperCase();
            rules.putAll(key, (Collection<String>)entry.getValue());
        }
        List<Warning> warnings = context.getWarnings();
        this.parseFreq(rules, builder, warnings);
        this.parseUntil(rules, builder, warnings);
        this.parseCount(rules, builder, warnings);
        this.parseInterval(rules, builder, warnings);
        this.parseBySecond(rules, builder, warnings);
        this.parseByMinute(rules, builder, warnings);
        this.parseByHour(rules, builder, warnings);
        this.parseByDay(rules, builder, warnings);
        this.parseByMonthDay(rules, builder, warnings);
        this.parseByYearDay(rules, builder, warnings);
        this.parseByWeekNo(rules, builder, warnings);
        this.parseByMonth(rules, builder, warnings);
        this.parseBySetPos(rules, builder, warnings);
        this.parseWkst(rules, builder, warnings);
        this.parseXRules(rules, builder, warnings);
        T t = this.newInstance(builder.build());
        ICalDate until = ((Recurrence)((ValuedProperty)t).getValue()).getUntil();
        if (until != null) {
            context.addDate(until, (ICalProperty)t, parameters);
        }
        return t;
    }

    protected abstract T newInstance(Recurrence var1);

    private void parseFreq(ListMultimap<String, String> rules, final Recurrence.Builder builder, final List<Warning> warnings) {
        this.parseFirst(rules, FREQ, new Handler<String>(){

            @Override
            public void handle(String value) {
                value = value.toUpperCase();
                try {
                    Recurrence.Frequency frequency = Recurrence.Frequency.valueOf(value);
                    builder.frequency(frequency);
                }
                catch (IllegalArgumentException e) {
                    warnings.add(Warning.parse(7, RecurrencePropertyScribe.FREQ, value));
                }
            }
        });
    }

    private void parseUntil(ListMultimap<String, String> rules, final Recurrence.Builder builder, final List<Warning> warnings) {
        this.parseFirst(rules, UNTIL, new Handler<String>(){

            @Override
            public void handle(String value) {
                try {
                    ICalDate date = ICalPropertyScribe.date(value).parse();
                    builder.until(date);
                }
                catch (IllegalArgumentException e) {
                    warnings.add(Warning.parse(7, RecurrencePropertyScribe.UNTIL, value));
                }
            }
        });
    }

    private void parseCount(ListMultimap<String, String> rules, final Recurrence.Builder builder, final List<Warning> warnings) {
        this.parseFirst(rules, COUNT, new Handler<String>(){

            @Override
            public void handle(String value) {
                try {
                    builder.count(Integer.valueOf(value));
                }
                catch (NumberFormatException e) {
                    warnings.add(Warning.parse(7, RecurrencePropertyScribe.COUNT, value));
                }
            }
        });
    }

    private void parseInterval(ListMultimap<String, String> rules, final Recurrence.Builder builder, final List<Warning> warnings) {
        this.parseFirst(rules, INTERVAL, new Handler<String>(){

            @Override
            public void handle(String value) {
                try {
                    builder.interval(Integer.valueOf(value));
                }
                catch (NumberFormatException e) {
                    warnings.add(Warning.parse(7, RecurrencePropertyScribe.INTERVAL, value));
                }
            }
        });
    }

    private void parseBySecond(ListMultimap<String, String> rules, final Recurrence.Builder builder, List<Warning> warnings) {
        this.parseIntegerList(BYSECOND, rules, warnings, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.bySecond(value);
            }
        });
    }

    private void parseByMinute(ListMultimap<String, String> rules, final Recurrence.Builder builder, List<Warning> warnings) {
        this.parseIntegerList(BYMINUTE, rules, warnings, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byMinute(value);
            }
        });
    }

    private void parseByHour(ListMultimap<String, String> rules, final Recurrence.Builder builder, List<Warning> warnings) {
        this.parseIntegerList(BYHOUR, rules, warnings, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byHour(value);
            }
        });
    }

    private void parseByDay(ListMultimap<String, String> rules, Recurrence.Builder builder, List<Warning> warnings) {
        Pattern p = Pattern.compile("^([-+]?\\d+)?(.*)$");
        for (String value : rules.removeAll(BYDAY)) {
            Matcher m = p.matcher(value);
            if (!m.find()) {
                warnings.add(Warning.parse(7, BYDAY, value));
                continue;
            }
            String dayStr = m.group(2);
            Recurrence.DayOfWeek day = Recurrence.DayOfWeek.valueOfAbbr(dayStr);
            if (day == null) {
                warnings.add(Warning.parse(7, BYDAY, value));
                continue;
            }
            String prefixStr = m.group(1);
            Integer prefix = prefixStr == null ? null : Integer.valueOf(prefixStr);
            builder.byDay(prefix, day);
        }
    }

    private void parseByMonthDay(ListMultimap<String, String> rules, final Recurrence.Builder builder, List<Warning> warnings) {
        this.parseIntegerList(BYMONTHDAY, rules, warnings, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byMonthDay(value);
            }
        });
    }

    private void parseByYearDay(ListMultimap<String, String> rules, final Recurrence.Builder builder, List<Warning> warnings) {
        this.parseIntegerList(BYYEARDAY, rules, warnings, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byYearDay(value);
            }
        });
    }

    private void parseByWeekNo(ListMultimap<String, String> rules, final Recurrence.Builder builder, List<Warning> warnings) {
        this.parseIntegerList(BYWEEKNO, rules, warnings, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byWeekNo(value);
            }
        });
    }

    private void parseByMonth(ListMultimap<String, String> rules, final Recurrence.Builder builder, List<Warning> warnings) {
        this.parseIntegerList(BYMONTH, rules, warnings, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byMonth(value);
            }
        });
    }

    private void parseBySetPos(ListMultimap<String, String> rules, final Recurrence.Builder builder, List<Warning> warnings) {
        this.parseIntegerList(BYSETPOS, rules, warnings, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.bySetPos(value);
            }
        });
    }

    private void parseWkst(ListMultimap<String, String> rules, final Recurrence.Builder builder, final List<Warning> warnings) {
        this.parseFirst(rules, WKST, new Handler<String>(){

            @Override
            public void handle(String value) {
                Recurrence.DayOfWeek day = Recurrence.DayOfWeek.valueOfAbbr(value);
                if (day == null) {
                    warnings.add(Warning.parse(7, RecurrencePropertyScribe.WKST, value));
                    return;
                }
                builder.workweekStarts(day);
            }
        });
    }

    private void parseXRules(ListMultimap<String, String> rules, Recurrence.Builder builder, List<Warning> warnings) {
        for (Map.Entry<String, List<String>> entry : rules) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                builder.xrule(name, value);
            }
        }
    }

    private ListMultimap<String, Object> buildComponents(T property, WriteContext context, boolean extended) {
        ICalDate until;
        ListMultimap<String, Object> components = new ListMultimap<String, Object>();
        Recurrence recur = (Recurrence)((ValuedProperty)property).getValue();
        if (recur.getFrequency() != null) {
            components.put(FREQ, recur.getFrequency().name());
        }
        if ((until = recur.getUntil()) != null) {
            components.put(UNTIL, this.writeUntil(until, context, extended));
        }
        if (recur.getCount() != null) {
            components.put(COUNT, recur.getCount());
        }
        if (recur.getInterval() != null) {
            components.put(INTERVAL, recur.getInterval());
        }
        this.addIntegerListComponent(components, BYSECOND, recur.getBySecond());
        this.addIntegerListComponent(components, BYMINUTE, recur.getByMinute());
        this.addIntegerListComponent(components, BYHOUR, recur.getByHour());
        for (Recurrence.ByDay byDay : recur.getByDay()) {
            Integer prefix = byDay.getNum();
            Recurrence.DayOfWeek day = byDay.getDay();
            String value = day.getAbbr();
            if (prefix != null) {
                value = prefix + value;
            }
            components.put(BYDAY, value);
        }
        this.addIntegerListComponent(components, BYMONTHDAY, recur.getByMonthDay());
        this.addIntegerListComponent(components, BYYEARDAY, recur.getByYearDay());
        this.addIntegerListComponent(components, BYWEEKNO, recur.getByWeekNo());
        this.addIntegerListComponent(components, BYMONTH, recur.getByMonth());
        this.addIntegerListComponent(components, BYSETPOS, recur.getBySetPos());
        if (recur.getWorkweekStarts() != null) {
            components.put(WKST, recur.getWorkweekStarts().getAbbr());
        }
        for (Map.Entry entry : recur.getXRules().entrySet()) {
            String name = (String)entry.getKey();
            for (String value : (List)entry.getValue()) {
                components.put(name, value);
            }
        }
        return components;
    }

    private String writeUntil(ICalDate until, WriteContext context, boolean extended) {
        if (!until.hasTime()) {
            return RecurrencePropertyScribe.date(until).extended(extended).write();
        }
        if (RecurrencePropertyScribe.isInObservance(context)) {
            return RecurrencePropertyScribe.date(until).utc(true).extended(extended).write();
        }
        if (context.getVersion() == ICalVersion.V2_0_DEPRECATED) {
            return RecurrencePropertyScribe.date(until).extended(extended).utc(true).write();
        }
        ICalComponent parent = context.getParent();
        if (parent == null) {
            return RecurrencePropertyScribe.date(until).extended(extended).utc(true).write();
        }
        DateStart dtstart = parent.getProperty(DateStart.class);
        if (dtstart == null) {
            return RecurrencePropertyScribe.date(until).extended(extended).utc(true).write();
        }
        TimezoneInfo tzinfo = context.getTimezoneInfo();
        boolean dtstartFloating = tzinfo.isFloating(dtstart);
        if (dtstartFloating) {
            return RecurrencePropertyScribe.date(until).extended(extended).tz(true, null).write();
        }
        return RecurrencePropertyScribe.date(until).extended(extended).utc(true).write();
    }

    private void addIntegerListComponent(ListMultimap<String, Object> components, String name, List<Integer> values) {
        for (Integer value : values) {
            components.put(name, value);
        }
    }

    private void parseFirst(ListMultimap<String, String> rules, String name, Handler<String> handler) {
        List<String> values = rules.removeAll(name);
        if (values.isEmpty()) {
            return;
        }
        String value = values.get(0);
        handler.handle(value);
    }

    private void parseIntegerList(String name, ListMultimap<String, String> rules, List<Warning> warnings, Handler<Integer> handler) {
        List<String> values = rules.removeAll(name);
        for (String value : values) {
            try {
                handler.handle(Integer.valueOf(value));
            }
            catch (NumberFormatException e) {
                warnings.add(Warning.parse(8, name, value));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Handler<T> {
        public void handle(T var1);
    }
}

