/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.RawProperty;
import biweekly.util.XmlUtils;
import java.util.List;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawPropertyScribe
extends ICalPropertyScribe<RawProperty> {
    public RawPropertyScribe(String propertyName) {
        super(RawProperty.class, propertyName, null);
    }

    @Override
    protected ICalDataType _dataType(RawProperty property, ICalVersion version) {
        return property.getDataType();
    }

    @Override
    protected String _writeText(RawProperty property, WriteContext context) {
        String value = property.getValue();
        if (value != null) {
            return value;
        }
        return "";
    }

    @Override
    protected RawProperty _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        return new RawProperty(this.propertyName, dataType, value);
    }

    @Override
    protected RawProperty _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        Element rawElement = element.getElement();
        String name = rawElement.getLocalName();
        List<Element> children = XmlUtils.toElementList(rawElement.getChildNodes());
        for (Element child : children) {
            if (!"urn:ietf:params:xml:ns:icalendar-2.0".equals(child.getNamespaceURI())) continue;
            String dataTypeStr = child.getLocalName();
            ICalDataType dataType = "unknown".equals(dataTypeStr) ? null : ICalDataType.get(dataTypeStr);
            String value = child.getTextContent();
            return new RawProperty(name, dataType, value);
        }
        String value = rawElement.getTextContent();
        return new RawProperty(name, null, value);
    }
}

