/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.Geo;
import biweekly.util.ICalFloatFormatter;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoScribe
extends ICalPropertyScribe<Geo> {
    public GeoScribe() {
        super(Geo.class, "GEO");
    }

    @Override
    protected ICalDataType _defaultDataType(ICalVersion version) {
        return ICalDataType.FLOAT;
    }

    @Override
    protected String _writeText(Geo property, WriteContext context) {
        ICalFloatFormatter formatter = new ICalFloatFormatter();
        Double latitude = property.getLatitude();
        if (latitude == null) {
            latitude = 0.0;
        }
        String latitudeStr = formatter.format(latitude);
        Double longitude = property.getLongitude();
        if (longitude == null) {
            longitude = 0.0;
        }
        String longitudeStr = formatter.format(longitude);
        switch (context.getVersion()) {
            case V1_0: {
                return GeoScribe.list(latitudeStr, longitudeStr);
            }
        }
        return GeoScribe.structured(latitudeStr, longitudeStr);
    }

    @Override
    protected Geo _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        String longitudeStr;
        String latitudeStr;
        switch (context.getVersion()) {
            case V1_0: {
                Iterator<String> it1 = GeoScribe.list(value).iterator();
                latitudeStr = it1.hasNext() ? it1.next() : null;
                longitudeStr = it1.hasNext() ? it1.next() : null;
                break;
            }
            default: {
                ICalPropertyScribe.SemiStructuredIterator it2 = GeoScribe.semistructured(value, true);
                latitudeStr = it2.next();
                longitudeStr = it2.next();
            }
        }
        if (latitudeStr == null || longitudeStr == null) {
            throw new CannotParseException(20, new Object[0]);
        }
        return this.parse(latitudeStr, longitudeStr);
    }

    @Override
    protected void _writeXml(Geo property, XCalElement element, WriteContext context) {
        ICalFloatFormatter formatter = new ICalFloatFormatter();
        Double latitude = property.getLatitude();
        if (latitude == null) {
            latitude = 0.0;
        }
        element.append("latitude", formatter.format(latitude));
        Double longitude = property.getLongitude();
        if (longitude == null) {
            longitude = 0.0;
        }
        element.append("longitude", formatter.format(longitude));
    }

    @Override
    protected Geo _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        String latitudeStr = element.first("latitude");
        String longitudeStr = element.first("longitude");
        if (latitudeStr == null && longitudeStr == null) {
            throw GeoScribe.missingXmlElements("latitude", "longitude");
        }
        if (latitudeStr == null) {
            throw GeoScribe.missingXmlElements("latitude");
        }
        if (longitudeStr == null) {
            throw GeoScribe.missingXmlElements("longitude");
        }
        return this.parse(latitudeStr, longitudeStr);
    }

    @Override
    protected JCalValue _writeJson(Geo property, WriteContext context) {
        Double longitude;
        Double latitude = property.getLatitude();
        if (latitude == null) {
            latitude = 0.0;
        }
        if ((longitude = property.getLongitude()) == null) {
            longitude = 0.0;
        }
        return JCalValue.structured(latitude, longitude);
    }

    @Override
    protected Geo _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        ICalPropertyScribe.StructuredIterator it = GeoScribe.structured(value);
        String latitudeStr = it.nextString();
        String longitudeStr = it.nextString();
        return this.parse(latitudeStr, longitudeStr);
    }

    private Geo parse(String latitudeStr, String longitudeStr) {
        Double latitude = null;
        if (latitudeStr != null) {
            try {
                latitude = Double.valueOf(latitudeStr);
            }
            catch (NumberFormatException e) {
                throw new CannotParseException(21, latitudeStr);
            }
        }
        Double longitude = null;
        if (longitudeStr != null) {
            try {
                longitude = Double.valueOf(longitudeStr);
            }
            catch (NumberFormatException e) {
                throw new CannotParseException(22, longitudeStr);
            }
        }
        return new Geo(latitude, longitude);
    }
}

