/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.DateTimeProperty;
import biweekly.property.ICalProperty;
import biweekly.property.ValuedProperty;
import biweekly.util.ICalDate;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DateTimePropertyScribe<T extends DateTimeProperty>
extends ICalPropertyScribe<T> {
    public DateTimePropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName, ICalDataType.DATE_TIME);
    }

    @Override
    protected String _writeText(T property, WriteContext context) {
        Date value = (Date)((ValuedProperty)property).getValue();
        return DateTimePropertyScribe.date(value).utc(true).extended(false).write();
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        value = DateTimePropertyScribe.unescape(value);
        return this.parse(value, parameters, context);
    }

    @Override
    protected void _writeXml(T property, XCalElement element, WriteContext context) {
        ICalDataType dataType = this.dataType(property, null);
        Date value = (Date)((ValuedProperty)property).getValue();
        String dateStr = DateTimePropertyScribe.date(value).utc(true).extended(true).write();
        element.append(dataType, dateStr);
    }

    @Override
    protected T _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        ICalDataType dataType = this.defaultDataType(context.getVersion());
        String value = element.first(dataType);
        if (value != null) {
            return this.parse(value, parameters, context);
        }
        throw DateTimePropertyScribe.missingXmlElements(dataType);
    }

    @Override
    protected JCalValue _writeJson(T property, WriteContext context) {
        Date value = (Date)((ValuedProperty)property).getValue();
        String dateStr = DateTimePropertyScribe.date(value).utc(true).extended(true).write();
        return JCalValue.single(dateStr);
    }

    @Override
    protected T _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        String valueStr = value.asSingle();
        return this.parse(valueStr, parameters, context);
    }

    private T parse(String value, ICalParameters parameters, ParseContext context) {
        ICalDate date;
        try {
            date = DateTimePropertyScribe.date(value).parse();
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException(17, new Object[0]);
        }
        T property = this.newInstance(date);
        context.addDate(date, (ICalProperty)property, parameters);
        return property;
    }

    protected abstract T newInstance(Date var1);
}

