/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.validation.client.impl;

import com.google.gwt.validation.client.impl.AbstractGwtValidator;
import com.google.gwt.validation.client.impl.ConstraintValidatorContextImpl;
import com.google.gwt.validation.client.impl.PathImpl;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;

public final class GwtValidationContext<T> {
    private final BeanDescriptor beanDescriptor;
    private PathImpl path = new PathImpl();
    private final Class<T> rootBeanClass;
    private final T rootBean;
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final AbstractGwtValidator validator;
    private final Set<Object> validatedObjects;

    public GwtValidationContext(Class<T> rootBeanClass, T rootBean, BeanDescriptor beanDescriptor, MessageInterpolator messageInterpolator, TraversableResolver traversableResolver, AbstractGwtValidator validator) {
        this(rootBeanClass, rootBean, beanDescriptor, messageInterpolator, traversableResolver, validator, new HashSet<Object>());
    }

    private GwtValidationContext(Class<T> rootBeanClass, T rootBean, BeanDescriptor beanDescriptor, MessageInterpolator messageInterpolator, TraversableResolver traversableResolver, AbstractGwtValidator validator, Set<Object> validatedObjects) {
        this.rootBeanClass = rootBeanClass;
        this.rootBean = rootBean;
        this.beanDescriptor = beanDescriptor;
        this.messageInterpolator = messageInterpolator;
        this.traversableResolver = traversableResolver;
        this.validator = validator;
        this.validatedObjects = new HashSet<Object>(validatedObjects);
    }

    public final void addValidatedObject(Object o) {
        this.validatedObjects.add(o);
    }

    public final boolean alreadyValidated(Object o) {
        return this.validatedObjects.contains(o);
    }

    public GwtValidationContext<T> append(String name) {
        GwtValidationContext<T> temp = new GwtValidationContext<T>(this.rootBeanClass, this.rootBean, this.beanDescriptor, this.messageInterpolator, this.traversableResolver, this.validator, this.validatedObjects);
        temp.path = this.path.append(name);
        return temp;
    }

    public GwtValidationContext<T> appendIndex(String name, int index) {
        GwtValidationContext<T> temp = new GwtValidationContext<T>(this.rootBeanClass, this.rootBean, this.beanDescriptor, this.messageInterpolator, this.traversableResolver, this.validator, this.validatedObjects);
        temp.path = this.path.appendIndex(name, index);
        return temp;
    }

    public GwtValidationContext<T> appendIterable(String name) {
        GwtValidationContext<T> temp = new GwtValidationContext<T>(this.rootBeanClass, this.rootBean, this.beanDescriptor, this.messageInterpolator, this.traversableResolver, this.validator, this.validatedObjects);
        temp.path = this.path.appendIterable(name);
        return temp;
    }

    public GwtValidationContext<T> appendKey(String name, Object key) {
        GwtValidationContext<T> temp = new GwtValidationContext<T>(this.rootBeanClass, this.rootBean, this.beanDescriptor, this.messageInterpolator, this.traversableResolver, this.validator, this.validatedObjects);
        temp.path = this.path.appendKey(name, key);
        return temp;
    }

    public <A extends Annotation, V> ConstraintValidatorContextImpl<A, V> createConstraintValidatorContext(ConstraintDescriptor<A> descriptor) {
        return new ConstraintValidatorContextImpl(this.path, descriptor);
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public PathImpl getPath() {
        return this.path;
    }

    public T getRootBean() {
        return this.rootBean;
    }

    public Class<T> getRootBeanClass() {
        return this.rootBeanClass;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public AbstractGwtValidator getValidator() {
        return this.validator;
    }
}

