/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil.timegrid;

import java.io.Serializable;
import java.util.BitSet;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.webutil.timegrid.TimetableGridTable;

public class TimetableGridContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iFilter;
    private int iStartDayDayOfWeek;
    private int iResourceType;
    private int iFirstDay;
    private int iBgMode;
    private boolean iShowEvents;
    private int iFirstSlot;
    private int iLastSlot;
    private int iDayCode;
    private BitSet iPattern;
    private float iNrWeeks;
    private int iSlotsPerWeek;

    public TimetableGridContext() {
    }

    public TimetableGridContext(TimetableGridTable table, Session session) {
        DatePattern dp = session.getDefaultDatePatternNotNull();
        this.iFilter = table.getFindString();
        this.iStartDayDayOfWeek = Constants.getDayOfWeek(DateUtils.getDate(1, session.getPatternStartMonth(), session.getSessionStartYear()));
        this.iFirstDay = table.getWeek() == -100 ? -1 : DateUtils.getFirstDayOfWeek(session.getSessionStartYear(), table.getWeek()) - session.getDayOfYear(1, session.getPatternStartMonth()) - 1;
        this.iResourceType = table.getResourceType();
        this.iBgMode = table.getBgMode();
        this.iShowEvents = table.getShowEvents();
        this.iFirstSlot = table.firstSlot();
        this.iLastSlot = table.lastSlot();
        this.iDayCode = 0;
        for (int day = table.startDay(); day <= table.endDay(); ++day) {
            if (table.skipDay(day)) continue;
            this.iDayCode += Constants.DAY_CODES[day];
        }
        this.iPattern = dp.getPatternBitSet();
        this.iNrWeeks = dp.getEffectiveNumberOfWeeks();
        if (this.iFirstDay < 0 && ApplicationProperty.TimetableGridUtilizationSkipHolidays.isTrue()) {
            int nrDays = 0;
            int idx = -1;
            int[] daysInWeek = new int[]{0, 0, 0, 0, 0, 0, 0};
            while ((idx = this.iPattern.nextSetBit(1 + idx)) >= 0) {
                int dow = (idx + this.iStartDayDayOfWeek) % 7;
                if ((this.iDayCode & Constants.DAY_CODES[dow]) == 0) continue;
                ++nrDays;
                int n = dow;
                daysInWeek[n] = daysInWeek[n] + 1;
            }
            float weekDays = 1.0f / (float)table.nrDays();
            this.iNrWeeks = weekDays >= 0.2f ? weekDays * (float)nrDays : 0.2f * (float)(daysInWeek[0] + daysInWeek[1] + daysInWeek[2] + daysInWeek[3] + daysInWeek[4]);
        }
        this.iSlotsPerWeek = (this.iLastSlot - this.iFirstSlot + 1) * table.nrDays();
    }

    public String getFilter() {
        return this.iFilter;
    }

    public int getResourceType() {
        return this.iResourceType;
    }

    public int getFirstDay() {
        return this.iFirstDay;
    }

    public int getBgMode() {
        return this.iBgMode;
    }

    public boolean isShowEvents() {
        return this.iShowEvents;
    }

    public int getStartDayDayOfWeek() {
        return this.iStartDayDayOfWeek;
    }

    public int getFirstSlot() {
        return this.iFirstSlot;
    }

    public int getLastSlot() {
        return this.iLastSlot;
    }

    public int getDayCode() {
        return this.iDayCode;
    }

    public BitSet getDefaultDatePattern() {
        return this.iPattern;
    }

    public float getNumberOfWeeks() {
        return this.iFirstDay >= 0 ? 1.0f : this.iNrWeeks;
    }

    public int getSlotsPerWeek() {
        return this.iSlotsPerWeek;
    }
}

