/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.ClassInstructorComparator;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.PdfEventHandler;
import org.unitime.timetable.util.PdfFont;
import org.unitime.timetable.webutil.PdfWebTable;

public class DistributionPrefsTableBuilder {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    public String getAllDistPrefsTableForCurrentUser(HttpServletRequest request, SessionContext context, String subjectAreaId, String courseNbr) throws Exception {
        if (subjectAreaId.equals(Constants.BLANK_OPTION_VALUE)) {
            return "";
        }
        if (subjectAreaId.equals(Constants.ALL_OPTION_VALUE)) {
            subjectAreaId = null;
        }
        Long subjAreaId = null;
        if (subjectAreaId != null && subjectAreaId.length() > 0) {
            subjAreaId = Long.valueOf(subjectAreaId);
        }
        HashSet prefs = new HashSet();
        for (Department d : Department.getUserDepartments(context.getUser())) {
            prefs.addAll(DistributionPref.getPreferences(context.getUser().getCurrentAcademicSessionId(), d.getUniqueId(), true, null, subjAreaId, courseNbr == null || courseNbr.length() == 0 ? null : courseNbr));
            prefs.addAll(DistributionPref.getInstructorPreferences(context.getUser().getCurrentAcademicSessionId(), d.getUniqueId(), subjAreaId, courseNbr == null || courseNbr.length() == 0 ? null : courseNbr));
        }
        return this.toHtmlTable(request, context, prefs, true);
    }

    public void getAllDistPrefsTableForCurrentUserAsPdf(OutputStream out, SessionContext context, String subjectAreaId, String courseNbr) throws Exception {
        if (subjectAreaId.equals(Constants.BLANK_OPTION_VALUE)) {
            subjectAreaId = null;
        } else if (subjectAreaId.equals(Constants.ALL_OPTION_VALUE)) {
            subjectAreaId = null;
        }
        String title = null;
        Long subjAreaId = null;
        if (subjectAreaId != null && subjectAreaId.length() > 0) {
            subjAreaId = Long.valueOf(subjectAreaId);
            SubjectArea area = (SubjectArea)new SubjectAreaDAO().get(subjAreaId);
            title = area.getSubjectAreaAbbreviation() + (courseNbr == null ? "" : " " + courseNbr);
        }
        HashSet prefs = new HashSet();
        for (Department d : Department.getUserDepartments(context.getUser())) {
            prefs.addAll(DistributionPref.getPreferences(context.getUser().getCurrentAcademicSessionId(), d.getUniqueId(), true, null, subjAreaId, courseNbr == null || courseNbr.length() == 0 ? null : courseNbr));
            prefs.addAll(DistributionPref.getInstructorPreferences(context.getUser().getCurrentAcademicSessionId(), d.getUniqueId(), subjAreaId, courseNbr == null || courseNbr.length() == 0 ? null : courseNbr));
        }
        Session session = (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId());
        title = title == null ? session.getLabel() + " " + MSG.pageTitleDistributionPreferencesPdf() : title + " - " + session.getLabel() + " " + MSG.pageTitleDistributionPreferencesPdf();
        this.toPdfTable(out, context, prefs, title);
    }

    public String getDistPrefsTableForClass(HttpServletRequest request, SessionContext context, Class_ clazz) {
        if (clazz.getManagingDept() == null) {
            return null;
        }
        Set prefs = clazz.effectiveDistributionPreferences(null);
        List<DepartmentalInstructor> leadInstructors = clazz.getLeadInstructors();
        if (!leadInstructors.isEmpty()) {
            for (DepartmentalInstructor instructor : leadInstructors) {
                prefs.addAll(instructor.getDistributionPreferences());
            }
        }
        return this.toHtmlTable(request, context, prefs, false);
    }

    public String getDistPrefsTableForExam(HttpServletRequest request, SessionContext context, Exam exam, boolean editable) {
        Set prefs = exam.effectivePreferences(DistributionPref.class);
        return this.toHtmlTable(request, context, prefs, false);
    }

    public String getDistPrefsTableForSchedulingSubpart(HttpServletRequest request, SessionContext context, SchedulingSubpart subpart) {
        if (subpart.getManagingDept() == null) {
            return null;
        }
        HashSet<DepartmentalInstructor> leadInstructors = new HashSet<DepartmentalInstructor>();
        Set prefs = subpart.getDistributionPreferences();
        for (Class_ clazz : subpart.getClasses()) {
            prefs.addAll(clazz.getDistributionPreferences());
            leadInstructors.addAll(clazz.getLeadInstructors());
        }
        for (DepartmentalInstructor instructor : leadInstructors) {
            prefs.addAll(instructor.getDistributionPreferences());
        }
        return this.toHtmlTable(request, context, prefs, false);
    }

    public String getDistPrefsTableForInstructionalOffering(HttpServletRequest request, SessionContext context, InstructionalOffering instructionalOffering) throws Exception {
        HashSet<DepartmentalInstructor> leadInstructors = new HashSet<DepartmentalInstructor>();
        TreeSet prefs = new TreeSet();
        for (InstrOfferingConfig config : instructionalOffering.getInstrOfferingConfigs()) {
            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                prefs.addAll(subpart.getDistributionPreferences());
                for (Class_ clazz : subpart.getClasses()) {
                    prefs.addAll(clazz.getDistributionPreferences());
                    leadInstructors.addAll(clazz.getLeadInstructors());
                }
            }
        }
        for (DepartmentalInstructor instructor : leadInstructors) {
            prefs.addAll(instructor.getDistributionPreferences());
        }
        return this.toHtmlTable(request, context, prefs, false);
    }

    public String toHtmlTable(HttpServletRequest request, SessionContext context, Collection distPrefs, boolean addButton) {
        String title = MSG.sectionTitleDistributionPreferences();
        String backType = request.getParameter("backType");
        String backId = request.getParameter("backId");
        String instructorFormat = UserProperty.NameFormat.get(context.getUser());
        if (addButton && context.hasPermission(Right.DistributionPreferenceAdd)) {
            title = "<table width='100%'><tr><td width='100%'><DIV class=\"WelcomeRowHeadNoLine\">" + MSG.sectionTitleDistributionPreferences() + "</DIV>" + "</td><td style='padding-bottom: 2px'>" + "<input type=\"submit\" name=\"op\" class=\"btn\" accesskey=\"" + MSG.accessAddDistributionPreference() + "\" " + "title=\"" + MSG.titleAddDistributionPreference(MSG.accessAddDistributionPreference()) + "\" " + "value=\"" + MSG.actionAddDistributionPreference() + "\">" + "</td></tr></table>";
        }
        WebTable.setOrder(context, "distPrefsTable.ord", request.getParameter("order"), 4);
        WebTable tbl = new WebTable(4, title, "distributionPrefs.do?order=%%", new String[]{MSG.columnDistrPrefType(), MSG.columnDistrPrefStructure(), MSG.columnDistrPrefOwner(), MSG.columnDistrPrefClass()}, new String[]{"left", "left", "left", "left"}, new boolean[]{true, true, true, true});
        int nrPrefs = 0;
        boolean suffix = ApplicationProperty.DistributionsShowClassSufix.isTrue();
        for (DistributionPref dp : distPrefs) {
            String groupingCmp;
            if (!context.hasPermission(dp, Right.DistributionPreferenceDetail)) continue;
            ++nrPrefs;
            String objStr = "";
            PreferenceGroup pg = dp.getOwner();
            String ownerType = "Unknown";
            if (pg instanceof Department) {
                Department d = (Department)pg;
                ownerType = d.getManagingDeptAbbv();
            }
            Iterator<DistributionObject> i2 = dp.getOrderedSetOfDistributionObjects().iterator();
            while (i2.hasNext()) {
                DistributionObject dO = i2.next();
                objStr = objStr + dO.preferenceText(suffix);
                if (!i2.hasNext()) continue;
                objStr = objStr + "<BR>";
            }
            String groupingText = dp.getStructureName();
            String string = groupingCmp = dp.getGrouping() == null ? "0" : dp.getGrouping().toString();
            if (pg instanceof DepartmentalInstructor) {
                DepartmentalInstructor instructor = (DepartmentalInstructor)pg;
                TreeSet<Department> owners = new TreeSet<Department>();
                TreeSet<ClassInstructor> classes = new TreeSet<ClassInstructor>(new ClassInstructorComparator(new ClassComparator(5)));
                classes.addAll(instructor.getClasses());
                for (ClassInstructor clazz : classes) {
                    if (!clazz.isLead().booleanValue()) continue;
                    if (objStr.length() > 0) {
                        objStr = objStr + "<BR>";
                    }
                    objStr = objStr + clazz.getClassInstructing().getClassLabel(suffix);
                    Department dept = clazz.getClassInstructing().getManagingDept();
                    if (!dept.isInheritInstructorPreferences().booleanValue()) continue;
                    owners.add(dept);
                }
                ownerType = "";
                for (Department owner : owners) {
                    ownerType = ownerType + (ownerType.isEmpty() ? "" : "<br>") + owner.getManagingDeptAbbv();
                }
                groupingText = MSG.columnInstructor() + " " + instructor.getName(instructorFormat);
                groupingCmp = instructor.getName(instructorFormat);
                if (owners.isEmpty()) continue;
            }
            String distType = dp.getDistributionType().getLabel();
            String prefLevel = dp.getPrefLevel().getPrefName();
            String prefColor = dp.getPrefLevel().prefcolor();
            if (PreferenceLevel.sNeutral.equals(dp.getPrefLevel().getPrefProlog())) {
                prefColor = "gray";
            }
            String onClick = null;
            boolean gray = false;
            if (pg instanceof DepartmentalInstructor) {
                if (context.hasPermission(pg, Right.InstructorDetail)) {
                    onClick = "onClick=\"document.location='instructorDetail.do?instructorId=" + dp.getOwner().getUniqueId().toString() + "&op=Show%20Instructor%20Preferences'\"";
                }
            } else if (context.hasPermission(dp, Right.DistributionPreferenceEdit)) {
                onClick = "onClick=\"document.location='distributionPrefs.do?dp=" + dp.getUniqueId().toString() + "&op=view'\"";
            }
            boolean back = "PreferenceGroup".equals(backType) && dp.getUniqueId().toString().equals(backId);
            tbl.addLine(onClick, new String[]{(back ? "<A name=\"back\"</A>" : "") + (gray ? "<span style='color:gray;'>" : "<span style='color:" + prefColor + ";font-weight:bold;' title='" + prefLevel + " " + distType + "'>") + distType + "</span>", (gray ? "<span style='color:gray;'>" : "") + groupingText + (gray ? "</span>" : ""), (gray ? "<span style='color:gray;'>" : "") + ownerType + (gray ? "</span>" : ""), (gray ? "<span style='color:gray;'>" : "") + objStr + (gray ? "</span>" : "")}, new Comparable[]{distType, groupingCmp, ownerType, objStr});
        }
        if (nrPrefs == 0) {
            tbl.addLine(null, new String[]{MSG.noPreferencesFound(), "", "", ""}, null);
        }
        return tbl.printTable(WebTable.getOrder(context, "distPrefsTable.ord"));
    }

    public void toPdfTable(OutputStream out, SessionContext context, Collection distPrefs, String title) throws Exception {
        int ord;
        String instructorFormat = UserProperty.NameFormat.get(context.getUser());
        PdfWebTable tbl = new PdfWebTable(5, title, null, new String[]{MSG.columnDistrPrefLevel(), MSG.columnDistrPrefType(), MSG.columnDistrPrefStructure(), MSG.columnDistrPrefOwner(), MSG.columnDistrPrefClass()}, new String[]{"left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true});
        int nrPrefs = 0;
        boolean suffix = ApplicationProperty.DistributionsShowClassSufix.isTrue();
        for (DistributionPref dp : distPrefs) {
            String groupingCmp;
            if (!context.hasPermission(dp, Right.DistributionPreferenceDetail)) continue;
            ++nrPrefs;
            String objStr = "";
            PreferenceGroup pg = dp.getOwner();
            String ownerType = "Unknown";
            if (pg instanceof Department) {
                Department d = (Department)pg;
                ownerType = d.getShortLabel();
            }
            Iterator<DistributionObject> i2 = dp.getOrderedSetOfDistributionObjects().iterator();
            while (i2.hasNext()) {
                DistributionObject dO = i2.next();
                objStr = objStr + dO.preferenceText(suffix);
                if (!i2.hasNext()) continue;
                objStr = objStr + "\n";
            }
            String groupingText = dp.getStructureName();
            String string = groupingCmp = dp.getGrouping() == null ? "0" : dp.getGrouping().toString();
            if (pg instanceof DepartmentalInstructor) {
                DepartmentalInstructor instructor = (DepartmentalInstructor)pg;
                Department d = instructor.getDepartment();
                ownerType = d.getShortLabel();
                TreeSet<ClassInstructor> classes = new TreeSet<ClassInstructor>(new ClassInstructorComparator(new ClassComparator(5)));
                classes.addAll(instructor.getClasses());
                for (ClassInstructor clazz : classes) {
                    if (!clazz.isLead().booleanValue()) continue;
                    if (objStr.length() > 0) {
                        objStr = objStr + "\n";
                    }
                    objStr = objStr + clazz.getClassInstructing().getClassLabel(suffix);
                }
                groupingText = MSG.columnInstructor() + " " + instructor.getName(instructorFormat);
                groupingCmp = instructor.getName(instructorFormat);
            }
            String distType = dp.getDistributionType().getLabel();
            String prefLevel = dp.getPrefLevel().getPrefName();
            String onClick = null;
            tbl.addLine(onClick, new String[]{prefLevel, distType, groupingText, ownerType, objStr}, new Comparable[]{prefLevel, distType, groupingCmp, ownerType, objStr});
        }
        if (nrPrefs == 0) {
            tbl.addLine(null, new String[]{MSG.errorNoDistributionPreferencesFound(), "", "", "", ""}, null);
        }
        ord = ((ord = WebTable.getOrder(context, "distPrefsTable.ord")) > 0 ? 1 : -1) * (1 + Math.abs(ord));
        PdfPTable table = tbl.printPdfTable(ord);
        float width = tbl.getWidth();
        Document doc = new Document(new Rectangle(60.0f + width, 60.0f + 1.3f * width), 30.0f, 30.0f, 30.0f, 30.0f);
        PdfWriter iWriter = PdfWriter.getInstance((Document)doc, (OutputStream)out);
        iWriter.setPageEvent((PdfPageEvent)new PdfEventHandler());
        doc.open();
        if (tbl.getName() != null) {
            doc.add((Element)new Paragraph(tbl.getName(), PdfFont.getBigFont(true)));
        }
        doc.add((Element)table);
        doc.close();
    }
}

