/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.unitime.timetable.util.DynamicListObjectFactory;

public class DynamicList
implements List {
    private DynamicListObjectFactory objectFactory;
    private List list;

    public static List getInstance(List list, DynamicListObjectFactory objectFactory) {
        return new DynamicList(list, objectFactory);
    }

    private DynamicList(List list, DynamicListObjectFactory objectFactory) {
        if (objectFactory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        this.list = list;
        this.objectFactory = objectFactory;
    }

    public Object get(int index) {
        int size = this.list.size();
        if (index < size) {
            Object object = this.list.get(index);
            if (object == null) {
                object = this.objectFactory.create();
                this.list.set(index, object);
                return object;
            }
            return object;
        }
        for (int i = size; i < index; ++i) {
            this.list.add(null);
        }
        Object object = this.objectFactory.create();
        this.list.add(object);
        return object;
    }

    public Object set(int index, Object element) {
        int size = this.list.size();
        if (index >= size) {
            for (int i = size; i <= index; ++i) {
                this.list.add(null);
            }
        }
        return this.list.set(index, element);
    }

    public void add(int index, Object element) {
        this.list.add(index, element);
    }

    public boolean add(Object o) {
        return this.list.add(o);
    }

    public boolean addAll(int index, Collection c) {
        return this.list.addAll(index, c);
    }

    public boolean addAll(Collection c) {
        return this.list.addAll(c);
    }

    public void clear() {
        this.list.clear();
    }

    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.list.containsAll(c);
    }

    public boolean equals(Object obj) {
        return this.list.equals(obj);
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.list.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.list.listIterator(index);
    }

    public Object remove(int index) {
        return this.list.remove(index);
    }

    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    public boolean removeAll(Collection c) {
        return this.list.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.list.retainAll(c);
    }

    public int size() {
        return this.list.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.list.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.list.toArray(a);
    }

    public String toString() {
        return this.list.toString();
    }
}

