/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseSchedulingSubpart;
import org.unitime.timetable.model.dao._RootDAO;

public class ExamResetInstructors {
    private static Log sLog = LogFactory.getLog(ExamResetInstructors.class);

    public static void doUpdate(Long sessionId, Long examType, boolean override, boolean classOnly, org.hibernate.Session hibSession) {
        for (Exam exam : new TreeSet(Exam.findAll(sessionId, examType))) {
            if (!override && !exam.getInstructors().isEmpty()) continue;
            sLog.info((Object)("Updating " + exam.getLabel()));
            Iterator<DepartmentalInstructor> i = exam.getInstructors().iterator();
            while (i.hasNext()) {
                DepartmentalInstructor instructor = i.next();
                instructor.getExams().remove(exam);
                i.remove();
            }
            for (ExamOwner owner : exam.getOwners()) {
                sLog.info((Object)("  owner " + owner.getLabel()));
                Object object = owner.getOwnerObject();
                if (object instanceof Class_) {
                    for (ClassInstructor classInstructor : ((Class_)object).getClassInstructors()) {
                        if (classInstructor.getPercentShare() < 100) continue;
                        exam.getInstructors().add(classInstructor.getInstructor());
                    }
                    continue;
                }
                if (object instanceof InstrOfferingConfig && !classOnly) {
                    BaseSchedulingSubpart top = null;
                    for (SchedulingSubpart s : ((InstrOfferingConfig)object).getSchedulingSubparts()) {
                        if (s.getParentSubpart() != null || top != null && s.getItype().compareTo(top.getItype()) >= 0 && (s.getItype().compareTo(top.getItype()) != 0 || s.getClasses().size() >= top.getClasses().size())) continue;
                        top = s;
                    }
                    if (top == null) continue;
                    for (Class_ clazz : top.getClasses()) {
                        sLog.info((Object)("  using " + clazz.getClassLabel()));
                        for (ClassInstructor instructor2 : clazz.getClassInstructors()) {
                            if (instructor2.getPercentShare() < 100) continue;
                            exam.getInstructors().add(instructor2.getInstructor());
                        }
                    }
                    continue;
                }
                if (classOnly) continue;
                for (InstrOfferingConfig instrOfferingConfig : owner.getCourse().getInstructionalOffering().getInstrOfferingConfigs()) {
                    BaseSchedulingSubpart top = null;
                    for (SchedulingSubpart s : instrOfferingConfig.getSchedulingSubparts()) {
                        if (s.getParentSubpart() != null || top != null && s.getItype().compareTo(top.getItype()) >= 0 && (s.getItype().compareTo(top.getItype()) != 0 || s.getClasses().size() >= top.getClasses().size())) continue;
                        top = s;
                    }
                    if (top == null) continue;
                    for (Class_ clazz : top.getClasses()) {
                        sLog.info((Object)("  using " + clazz.getClassLabel()));
                        for (ClassInstructor instructor : clazz.getClassInstructors()) {
                            if (instructor.getPercentShare() < 100) continue;
                            exam.getInstructors().add(instructor.getInstructor());
                        }
                    }
                }
            }
            if (exam.getInstructors().isEmpty()) {
                sLog.info((Object)"    no instructors");
            } else {
                sLog.info((Object)("    instructors " + new TreeSet<DepartmentalInstructor>(exam.getInstructors())));
            }
            for (DepartmentalInstructor instructor : exam.getInstructors()) {
                instructor.getExams().add(exam);
                hibSession.saveOrUpdate((Object)instructor);
            }
            hibSession.saveOrUpdate((Object)exam);
        }
        hibSession.flush();
    }

    public static void main(String[] args) {
        try {
            Properties props = new Properties();
            props.setProperty("log4j.rootLogger", "DEBUG, A1");
            props.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
            props.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
            props.setProperty("log4j.appender.A1.layout.ConversionPattern", "%-5p %c{2}: %m%n");
            props.setProperty("log4j.logger.org.hibernate", "INFO");
            props.setProperty("log4j.logger.org.hibernate.cfg", "WARN");
            props.setProperty("log4j.logger.org.hibernate.cache.EhCacheProvider", "ERROR");
            props.setProperty("log4j.logger.org.unitime.commons.hibernate", "INFO");
            props.setProperty("log4j.logger.net", "INFO");
            PropertyConfigurator.configure((Properties)props);
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            Session session = Session.getSessionUsingInitiativeYearTerm(ApplicationProperties.getProperty("initiative", "PWL"), ApplicationProperties.getProperty("year", "2013"), ApplicationProperties.getProperty("term", "Fall"));
            if (session == null) {
                sLog.error((Object)"Academic session not found, use properties initiative, year, and term to set academic session.");
                System.exit(0);
            } else {
                sLog.info((Object)("Session: " + session));
            }
            ExamType examType = ExamType.findByReference(ApplicationProperties.getProperty("type", "final"));
            boolean override = "true".equals(ApplicationProperties.getProperty("override", "true"));
            boolean classOnly = "true".equals(ApplicationProperties.getProperty("classOnly", "false"));
            ExamResetInstructors.doUpdate(session.getUniqueId(), examType.getUniqueId(), override, classOnly, new _RootDAO().getSession());
            HibernateUtil.closeHibernate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

