/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.studentsct.StudentSectioningLoader;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.Test;
import org.cpsolver.studentsct.model.AcademicAreaCode;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.hibernate.Transaction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.ExactTimeMins;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.LastLikeCourseDemand;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.duration.DurationModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchStudentSectioningLoader
extends StudentSectioningLoader {
    private static Log sLog = LogFactory.getLog(BatchStudentSectioningLoader.class);
    private boolean iIncludeCourseDemands = true;
    private boolean iIncludeLastLikeStudents = true;
    private boolean iIncludeUseCommittedAssignments = false;
    private boolean iMakeupAssignmentsFromRequiredPrefs = false;
    private boolean iLoadStudentInfo = false;
    private String iInitiative = null;
    private String iTerm = null;
    private String iYear = null;
    private long iMakeupAssignmentId = 0L;
    private NameFormat iInstructorNameFormat;

    public BatchStudentSectioningLoader(StudentSectioningModel model, org.cpsolver.ifs.assignment.Assignment<Request, Enrollment> assignment) {
        super(model, assignment);
        this.iIncludeCourseDemands = model.getProperties().getPropertyBoolean("Load.IncludeCourseDemands", this.iIncludeCourseDemands);
        this.iIncludeLastLikeStudents = model.getProperties().getPropertyBoolean("Load.IncludeLastLikeStudents", this.iIncludeLastLikeStudents);
        this.iIncludeUseCommittedAssignments = model.getProperties().getPropertyBoolean("Load.IncludeUseCommittedAssignments", this.iIncludeUseCommittedAssignments);
        this.iLoadStudentInfo = model.getProperties().getPropertyBoolean("Load.LoadStudentInfo", this.iLoadStudentInfo);
        this.iMakeupAssignmentsFromRequiredPrefs = model.getProperties().getPropertyBoolean("Load.MakeupAssignmentsFromRequiredPrefs", this.iMakeupAssignmentsFromRequiredPrefs);
        this.iInitiative = model.getProperties().getProperty("Data.Initiative");
        this.iYear = model.getProperties().getProperty("Data.Year");
        this.iTerm = model.getProperties().getProperty("Data.Term");
        this.iInstructorNameFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingInstructorNameFormat.value());
    }

    public void load() throws Exception {
        Session session = Session.getSessionUsingInitiativeYearTerm(this.iInitiative, this.iYear, this.iTerm);
        if (session == null) {
            throw new Exception("Session " + this.iInitiative + " " + this.iTerm + this.iYear + " not found!");
        }
        sLog.info((Object)("Loading data for " + this.iInitiative + " " + this.iTerm + this.iYear + "..."));
        this.load(session);
    }

    private List<Instructor> getInstructors(Class_ clazz) {
        if (!clazz.isDisplayInstructor().booleanValue()) {
            return null;
        }
        ArrayList<Instructor> ret = new ArrayList<Instructor>();
        TreeSet<ClassInstructor> ts = new TreeSet<ClassInstructor>(clazz.getClassInstructors());
        for (ClassInstructor ci : ts) {
            if (!ci.isLead().booleanValue()) continue;
            ret.add(new Instructor(ci.getInstructor().getUniqueId().longValue(), ci.getInstructor().getExternalUniqueId(), this.iInstructorNameFormat.format(ci.getInstructor()), ci.getInstructor().getEmail()));
        }
        return ret;
    }

    public TimeLocation makeupTime(Class_ c) {
        DatePattern datePattern = c.effectiveDatePattern();
        if (datePattern == null) {
            sLog.warn((Object)("        -- makup time for " + c.getClassLabel() + ": no date pattern set"));
            return null;
        }
        for (TimePref tp : c.getEffectiveTimePreferences()) {
            TimePatternModel pattern = tp.getTimePatternModel();
            if (pattern.isExactTime()) {
                DurationModel dm = c.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
                int minsPerMeeting = dm.getExactTimeMinutesPerMeeting(c.getSchedulingSubpart().getMinutesPerWk(), c.effectiveDatePattern(), pattern.getExactDays());
                int length = ExactTimeMins.getNrSlotsPerMtg(minsPerMeeting);
                int breakTime = ExactTimeMins.getBreakTime(minsPerMeeting);
                return new TimeLocation(pattern.getExactDays(), pattern.getExactStartSlot(), length, PreferenceLevel.sIntLevelNeutral, 0.0, datePattern.getUniqueId(), datePattern.getName(), datePattern.getPatternBitSet(), breakTime);
            }
            for (int time = 0; time < pattern.getNrTimes(); ++time) {
                for (int day = 0; day < pattern.getNrDays(); ++day) {
                    String pref = pattern.getPreference(day, time);
                    if (!pref.equals(PreferenceLevel.sRequired)) continue;
                    return new TimeLocation(pattern.getDayCode(day), pattern.getStartSlot(time), pattern.getSlotsPerMtg(), PreferenceLevel.prolog2int(pattern.getPreference(day, time)), pattern.getNormalizedPreference(day, time, 0.77), datePattern.getUniqueId(), datePattern.getName(), datePattern.getPatternBitSet(), pattern.getBreakTime());
                }
            }
        }
        if (c.getEffectiveTimePreferences().isEmpty()) {
            sLog.warn((Object)("        -- makup time for " + c.getClassLabel() + ": no time preference set"));
        } else {
            sLog.warn((Object)("        -- makup time for " + c.getClassLabel() + ": no required time set"));
        }
        return null;
    }

    public Vector makeupRooms(Class_ c) {
        Vector<RoomLocation> rooms = new Vector<RoomLocation>();
        for (RoomPref rp : c.getEffectiveRoomPreferences()) {
            if (!PreferenceLevel.sRequired.equals(rp.getPrefLevel().getPrefProlog())) {
                sLog.warn((Object)("        -- makup room for " + c.getClassLabel() + ": preference for " + rp.getRoom().getLabel() + " is not required"));
                continue;
            }
            Location room = rp.getRoom();
            RoomLocation roomLocation = new RoomLocation(room.getUniqueId(), room.getLabel(), room instanceof Room ? ((Room)room).getBuilding().getUniqueId() : null, 0, room.getCapacity().intValue(), room.getCoordinateX(), room.getCoordinateY(), room.isIgnoreTooFar().booleanValue(), null);
            rooms.addElement(roomLocation);
        }
        return rooms;
    }

    public Placement makeupPlacement(Class_ c) {
        TimeLocation time = this.makeupTime(c);
        if (time == null) {
            return null;
        }
        Vector rooms = this.makeupRooms(c);
        Vector<TimeLocation> times = new Vector<TimeLocation>(1);
        times.addElement(time);
        Lecture lecture = new Lecture(c.getUniqueId(), null, c.getSchedulingSubpart().getUniqueId(), c.getClassLabel(), times, (List)rooms, rooms.size(), new Placement(null, time, (List)rooms), 0, 0, 1.0);
        lecture.setNote(c.getNotes());
        Placement p = (Placement)lecture.getInitialAssignment();
        p.setAssignmentId(new Long(this.iMakeupAssignmentId++));
        lecture.setBestAssignment((Value)p, 0L);
        sLog.debug((Object)("        -- makup placement for " + c.getClassLabel() + ": " + p.getLongName(true)));
        return p;
    }

    private Section loadSection(Subpart subpart, Section parentSection, Class_ c, int limit) {
        Assignment a;
        Placement p = null;
        p = this.iMakeupAssignmentsFromRequiredPrefs ? this.makeupPlacement(c) : ((a = c.getCommittedAssignment()) == null ? null : a.getPlacement());
        Section section = new Section(c.getUniqueId().longValue(), limit, c.getClassLabel(), subpart, p, this.getInstructors(c), parentSection);
        if (section.getTime() != null && section.getTime().getDatePatternId().equals(c.getSession().getDefaultDatePattern().getUniqueId())) {
            section.getTime().setDatePattern(section.getTime().getDatePatternId(), "", section.getTime().getWeekCode());
        }
        if (section.getTime() != null && section.getTime().getDatePatternName().startsWith("generated")) {
            Formats.Format<Date> sdf = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
            section.getTime().setDatePattern(section.getTime().getDatePatternId(), sdf.format(c.effectiveDatePattern().getStartDate()) + " - " + sdf.format(c.effectiveDatePattern().getEndDate()), section.getTime().getWeekCode());
        }
        return section;
    }

    private Offering loadOffering(InstructionalOffering io, Hashtable courseTable, Hashtable classTable) {
        sLog.debug((Object)("Loading offering " + io.getCourseName()));
        if (!io.hasClasses()) {
            sLog.debug((Object)("  -- offering " + io.getCourseName() + " has no class"));
            return null;
        }
        Offering offering = new Offering(io.getUniqueId().longValue(), io.getCourseName());
        boolean unlimited = false;
        for (InstrOfferingConfig ioc : io.getInstrOfferingConfigs()) {
            if (!ioc.isUnlimitedEnrollment().booleanValue()) continue;
            unlimited = true;
        }
        for (CourseOffering co : io.getCourseOfferings()) {
            int projected = co.getProjectedDemand() == null ? 0 : co.getProjectedDemand();
            int limit = co.getInstructionalOffering().getLimit();
            if (unlimited) {
                limit = -1;
            }
            if (co.getReservation() != null) {
                limit = co.getReservation();
            }
            Course course = new Course(co.getUniqueId().longValue(), co.getSubjectAreaAbbv(), co.getCourseNbr(), offering, limit, projected);
            courseTable.put(co.getUniqueId(), course);
            sLog.debug((Object)("  -- created course " + course));
        }
        Hashtable<Class_, Section> class2section = new Hashtable<Class_, Section>();
        Hashtable<SchedulingSubpart, Subpart> ss2subpart = new Hashtable<SchedulingSubpart, Subpart>();
        for (InstrOfferingConfig ioc : io.getInstrOfferingConfigs()) {
            if (!ioc.hasClasses()) {
                sLog.debug((Object)("  -- config " + ioc.getName() + " has no class"));
                continue;
            }
            Config config = new Config(ioc.getUniqueId().longValue(), ioc.isUnlimitedEnrollment() != false ? -1 : ioc.getLimit(), ioc.getCourseName() + " [" + ioc.getName() + "]", offering);
            if (ioc.getInstructionalMethod() != null) {
                config.setInstructionalMethodId(ioc.getInstructionalMethod().getUniqueId());
                config.setInstructionalMethodName(ioc.getInstructionalMethod().getLabel());
            }
            sLog.debug((Object)("  -- created config " + config));
            TreeSet<SchedulingSubpart> subparts = new TreeSet<SchedulingSubpart>(new SchedulingSubpartComparator());
            subparts.addAll(ioc.getSchedulingSubparts());
            for (SchedulingSubpart ss : subparts) {
                Subpart parentSubpart;
                String sufix = ss.getSchedulingSubpartSuffix();
                Subpart subpart = parentSubpart = ss.getParentSubpart() == null ? null : (Subpart)ss2subpart.get(ss.getParentSubpart());
                if (ss.getParentSubpart() != null && parentSubpart == null) {
                    sLog.error((Object)("    -- subpart " + ss.getSchedulingSubpartLabel() + " has parent " + ss.getParentSubpart().getSchedulingSubpartLabel() + ", but the appropriate parent subpart is not loaded."));
                }
                Subpart subpart2 = new Subpart(ss.getUniqueId().longValue(), ss.getItype().getItype().toString() + sufix, ss.getItypeDesc().trim() + (sufix == null || sufix.length() == 0 ? "" : " (" + sufix + ")"), config, parentSubpart);
                subpart2.setAllowOverlap(ss.isStudentAllowOverlap().booleanValue());
                ss2subpart.put(ss, subpart2);
                sLog.debug((Object)("    -- created subpart " + subpart2));
                for (Class_ c : ss.getClasses()) {
                    Section parentSection;
                    int limit = c.getClassLimit();
                    if (ioc.isUnlimitedEnrollment().booleanValue()) {
                        limit = -1;
                    }
                    if (!c.isEnabledForStudentScheduling().booleanValue()) {
                        limit = 0;
                    }
                    Section section = parentSection = c.getParentClass() == null ? null : (Section)class2section.get(c.getParentClass());
                    if (c.getParentClass() != null && parentSection == null) {
                        sLog.error((Object)("    -- class " + c.getClassLabel() + " has parent " + c.getParentClass().getClassLabel() + ", but the appropriate parent section is not loaded."));
                    }
                    Section section2 = this.loadSection(subpart2, parentSection, c, limit);
                    class2section.put(c, section2);
                    classTable.put(c.getUniqueId(), section2);
                    sLog.debug((Object)("      -- created section " + section2));
                }
            }
        }
        return offering;
    }

    public Student loadStudent(org.unitime.timetable.model.Student s, Hashtable courseTable, Hashtable classTable) {
        sLog.debug((Object)("Loading student " + s.getUniqueId() + " (id=" + s.getExternalUniqueId() + ", name=" + s.getFirstName() + " " + s.getMiddleName() + " " + s.getLastName() + ")"));
        Student student = new Student(s.getUniqueId().longValue());
        if (this.iLoadStudentInfo) {
            this.loadStudentInfo(student, s);
        }
        int priority = 0;
        for (CourseDemand cd : new TreeSet<CourseDemand>(s.getCourseDemands())) {
            if (cd.getFreeTime() != null) {
                FreeTimeRequest request = new FreeTimeRequest(cd.getUniqueId().longValue(), priority++, cd.isAlternative().booleanValue(), student, new TimeLocation(cd.getFreeTime().getDayCode().intValue(), cd.getFreeTime().getStartSlot().intValue(), cd.getFreeTime().getLength().intValue(), 0, 0.0, s.getSession().getDefaultDatePattern().getUniqueId(), "", s.getSession().getDefaultDatePattern().getPatternBitSet(), 0));
                sLog.debug((Object)("  -- added request " + request));
                continue;
            }
            if (!cd.getCourseRequests().isEmpty()) {
                Vector<Course> courses = new Vector<Course>();
                HashSet selChoices = new HashSet();
                HashSet wlChoices = new HashSet();
                HashSet<Section> assignedSections = new HashSet<Section>();
                Config assignedConfig = null;
                for (org.unitime.timetable.model.CourseRequest cr : new TreeSet<org.unitime.timetable.model.CourseRequest>(cd.getCourseRequests())) {
                    Course course = (Course)courseTable.get(cr.getCourseOffering().getUniqueId());
                    if (course == null) {
                        sLog.warn((Object)("  -- course " + cr.getCourseOffering().getCourseName() + " not loaded"));
                        continue;
                    }
                    if (assignedConfig == null) {
                        for (StudentClassEnrollment sce : cr.getClassEnrollments()) {
                            Section section = course.getOffering().getSection(sce.getClazz().getUniqueId().longValue());
                            if (section == null) continue;
                            assignedSections.add(section);
                            assignedConfig = section.getSubpart().getConfig();
                        }
                    }
                    courses.addElement(course);
                }
                if (courses.isEmpty()) continue;
                CourseRequest request = new CourseRequest(cd.getUniqueId().longValue(), priority++, cd.isAlternative().booleanValue(), student, courses, cd.isWaitlist().booleanValue(), Long.valueOf(cd.getTimestamp().getTime()));
                request.getSelectedChoices().addAll(selChoices);
                request.getWaitlistedChoices().addAll(wlChoices);
                if (assignedConfig != null && assignedSections.size() == assignedConfig.getSubparts().size()) {
                    Enrollment enrollment = new Enrollment((Request)request, 0, assignedConfig, assignedSections, this.getAssignment());
                    request.setInitialAssignment((Value)enrollment);
                }
                sLog.debug((Object)("  -- added request " + request));
                continue;
            }
            sLog.warn((Object)("  -- course demand " + cd.getUniqueId() + " has no course requests"));
        }
        return student;
    }

    private void fixWeights() {
        Course course;
        CourseRequest courseRequest;
        Hashtable<Course, Integer> lastLike = new Hashtable<Course, Integer>();
        Hashtable real = new Hashtable();
        for (Student student : ((StudentSectioningModel)this.getModel()).getStudents()) {
            for (Request request : student.getRequests()) {
                if (!(request instanceof CourseRequest)) continue;
                courseRequest = (CourseRequest)request;
                course = (Course)courseRequest.getCourses().get(0);
                Integer cnt = (Integer)(student.isDummy() ? lastLike : real).get(course);
                (student.isDummy() ? lastLike : real).put(course, new Integer((cnt == null ? 0 : cnt) + 1));
            }
        }
        Enumeration e = new Vector(((StudentSectioningModel)this.getModel()).getStudents()).elements();
        while (e.hasMoreElements()) {
            Student student;
            student = (Student)e.nextElement();
            Enumeration f = new Vector(student.getRequests()).elements();
            while (f.hasMoreElements()) {
                Request request;
                request = (Request)f.nextElement();
                if (!student.isDummy()) {
                    request.setWeight(1.0);
                    continue;
                }
                if (request instanceof CourseRequest) {
                    courseRequest = (CourseRequest)request;
                    course = (Course)courseRequest.getCourses().get(0);
                    Integer lastLikeCnt = (Integer)lastLike.get(course);
                    Integer realCnt = (Integer)real.get(course);
                    courseRequest.setWeight(Test.getLastLikeStudentWeight((Course)course, (int)(realCnt == null ? 0 : realCnt), (int)(lastLikeCnt == null ? 0 : lastLikeCnt)));
                } else {
                    request.setWeight(1.0);
                }
                if (!(request.getWeight() <= 0.0)) continue;
                ((StudentSectioningModel)this.getModel()).removeVariable(request);
                student.getRequests().remove(request);
            }
            if (!student.getRequests().isEmpty()) continue;
            ((StudentSectioningModel)this.getModel()).getStudents().remove(student);
        }
    }

    public void loadLastLikeStudent(org.hibernate.Session hibSession, LastLikeCourseDemand d, org.unitime.timetable.model.Student s, Long courseOfferingId, Hashtable studentTable, Hashtable courseTable, Hashtable classTable, Hashtable classAssignments) {
        sLog.debug((Object)("Loading last like demand of student " + s.getUniqueId() + " (id=" + s.getExternalUniqueId() + ", name=" + s.getFirstName() + " " + s.getMiddleName() + " " + s.getLastName() + ") for " + courseOfferingId));
        Student student = (Student)studentTable.get(s.getUniqueId());
        if (student == null) {
            student = new Student(s.getUniqueId().longValue(), true);
            if (this.iLoadStudentInfo) {
                this.loadStudentInfo(student, s);
            }
            studentTable.put(s.getUniqueId(), student);
        }
        int priority = student.getRequests().size();
        Vector<Course> courses = new Vector<Course>();
        Course course = (Course)courseTable.get(courseOfferingId);
        if (course == null) {
            sLog.warn((Object)("  -- course " + courseOfferingId + " not loaded"));
            return;
        }
        courses.addElement(course);
        CourseRequest request = new CourseRequest(d.getUniqueId().longValue(), priority++, false, student, courses, false, null);
        sLog.debug((Object)("  -- added request " + request));
        if (classAssignments != null && !classAssignments.isEmpty()) {
            HashSet<Section> assignedSections = new HashSet<Section>();
            HashSet classIds = (HashSet)classAssignments.get(s.getUniqueId());
            if (classIds != null) {
                for (Long classId : classIds) {
                    Section section = request.getSection(classId.longValue());
                    if (section == null) continue;
                    assignedSections.add(section);
                }
            }
            if (!assignedSections.isEmpty()) {
                sLog.debug((Object)("    -- committed assignment: " + assignedSections));
                for (Enrollment enrollment : request.values(this.getAssignment())) {
                    if (!enrollment.getAssignments().containsAll(assignedSections)) continue;
                    request.setInitialAssignment((Value)enrollment);
                    sLog.debug((Object)("      -- found: " + enrollment));
                    break;
                }
            }
        }
    }

    public void loadStudentInfo(Student student, org.unitime.timetable.model.Student s) {
        for (StudentAreaClassificationMajor aac : s.getAreaClasfMajors()) {
            student.getAcademicAreaClasiffications().add(new AcademicAreaCode(aac.getAcademicArea().getAcademicAreaAbbreviation(), aac.getAcademicClassification().getCode()));
            sLog.debug((Object)("  -- aac: " + aac.getAcademicArea().getAcademicAreaAbbreviation() + ":" + aac.getAcademicClassification().getCode()));
            student.getMajors().add(new AcademicAreaCode(aac.getAcademicArea().getAcademicAreaAbbreviation(), aac.getMajor().getCode()));
            sLog.debug((Object)("  -- mj: " + aac.getAcademicArea().getAcademicAreaAbbreviation() + ":" + aac.getMajor().getCode()));
        }
    }

    public void load(Session session) {
        org.hibernate.Session hibSession = new SessionDAO().getSession();
        Transaction tx = hibSession.beginTransaction();
        try {
            try {
                Student student;
                Hashtable courseTable = new Hashtable();
                Hashtable classTable = new Hashtable();
                List offerings = hibSession.createQuery("select distinct io from InstructionalOffering io left join fetch io.courseOfferings as co left join fetch io.instrOfferingConfigs as ioc left join fetch ioc.schedulingSubparts as ss left join fetch ss.classes as c where io.session.uniqueId=:sessionId and io.notOffered=false").setLong("sessionId", session.getUniqueId().longValue()).setFetchSize(1000).list();
                for (InstructionalOffering io : offerings) {
                    Offering offering = this.loadOffering(io, courseTable, classTable);
                    if (offering == null) continue;
                    ((StudentSectioningModel)this.getModel()).addOffering(offering);
                }
                HashSet<String> loadedStudentIds = new HashSet<String>();
                if (this.iIncludeCourseDemands) {
                    List students = hibSession.createQuery("select distinct s from Student s left join fetch s.courseDemands as cd left join fetch cd.courseRequests as cr where s.session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).setFetchSize(1000).list();
                    for (org.unitime.timetable.model.Student s : students) {
                        if (s.getCourseDemands().isEmpty()) continue;
                        student = this.loadStudent(s, courseTable, classTable);
                        if (student != null) {
                            ((StudentSectioningModel)this.getModel()).addStudent(student);
                        }
                        if (s.getExternalUniqueId() == null) continue;
                        loadedStudentIds.add(s.getExternalUniqueId());
                    }
                }
                if (this.iIncludeLastLikeStudents) {
                    Hashtable<Long, HashSet<Long>> classAssignments = null;
                    if (this.iIncludeUseCommittedAssignments) {
                        classAssignments = new Hashtable<Long, HashSet<Long>>();
                        Iterator i = hibSession.createQuery("select distinct se.studentId, se.clazz.uniqueId from StudentEnrollment se where se.solution.commited=true and se.solution.owner.session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).iterate();
                        while (i.hasNext()) {
                            Object[] o = (Object[])i.next();
                            Long studentId = (Long)o[0];
                            Long classId = (Long)o[1];
                            HashSet<Long> classIds = (HashSet<Long>)classAssignments.get(studentId);
                            if (classIds == null) {
                                classIds = new HashSet<Long>();
                                classAssignments.put(studentId, classIds);
                            }
                            classIds.add(classId);
                        }
                    }
                    Hashtable lastLikeStudentTable = new Hashtable();
                    for (Object[] o : hibSession.createQuery("select d, c.uniqueId from LastLikeCourseDemand d left join fetch d.student s, CourseOffering c left join c.demandOffering cx where d.subjectArea.session.uniqueId=:sessionId and c.subjectArea.session.uniqueId=:sessionId and ((c.permId=null and d.subjectArea=c.subjectArea and d.courseNbr=c.courseNbr ) or  (c.permId!=null and c.permId=d.coursePermId) or  (cx.permId=null and d.subjectArea=cx.subjectArea and d.courseNbr=cx.courseNbr) or  (cx.permId!=null and cx.permId=d.coursePermId)) order by s.uniqueId, d.priority, d.uniqueId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                        LastLikeCourseDemand d = (LastLikeCourseDemand)o[0];
                        org.unitime.timetable.model.Student s = d.getStudent();
                        Long courseOfferingId = (Long)o[1];
                        if (s.getExternalUniqueId() != null && loadedStudentIds.contains(s.getExternalUniqueId())) continue;
                        this.loadLastLikeStudent(hibSession, d, s, courseOfferingId, lastLikeStudentTable, courseTable, classTable, classAssignments);
                    }
                    Enumeration e = lastLikeStudentTable.elements();
                    while (e.hasMoreElements()) {
                        student = (Student)e.nextElement();
                        ((StudentSectioningModel)this.getModel()).addStudent(student);
                    }
                    if (classAssignments != null && !classAssignments.isEmpty()) {
                        for (Request request : ((StudentSectioningModel)this.getModel()).variables()) {
                            if (request.getInitialAssignment() == null) continue;
                            Set conflicts = ((StudentSectioningModel)this.getModel()).conflictValues(this.getAssignment(), request.getInitialAssignment());
                            if (conflicts.isEmpty()) {
                                this.getAssignment().assign(0L, request.getInitialAssignment());
                                continue;
                            }
                            sLog.debug((Object)("Unable to assign " + request.getInitialAssignment() + ", conflicts: " + conflicts));
                        }
                    }
                    this.fixWeights();
                }
                tx.commit();
            }
            catch (Exception e) {
                tx.rollback();
                throw new RuntimeException(e);
            }
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            hibSession.close();
            throw throwable;
        }
        hibSession.close();
    }
}

