/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.spring.security;

import java.util.Collection;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.ExternalUidTranslation;
import org.unitime.timetable.security.context.UniTimeUserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="unitimeUserContextMapper")
public class UniTimeUserContextMapper
implements UserDetailsContextMapper {
    private ExternalUidTranslation iTranslation = null;

    public UniTimeUserContextMapper() {
        if (ApplicationProperty.ExternalUserIdTranslation.value() != null) {
            try {
                this.iTranslation = (ExternalUidTranslation)Class.forName(ApplicationProperty.ExternalUserIdTranslation.value()).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                Debug.error("Unable to instantiate external uid translation class, " + e.getMessage());
            }
        }
    }

    public UserDetails mapUserFromContext(DirContextOperations ctx, String username, Collection<? extends GrantedAuthority> authorities) {
        String userId = username;
        if (!authorities.isEmpty()) {
            userId = authorities.iterator().next().getAuthority();
        }
        if (this.iTranslation != null && ApplicationProperty.AuthenticationLdapIdTranslate.isTrue()) {
            userId = this.iTranslation.translate(userId, ExternalUidTranslation.Source.LDAP, ExternalUidTranslation.Source.User);
        }
        if (ApplicationProperty.AuthenticationLdapIdTrimLeadingZeros.isTrue()) {
            while (userId.startsWith("0")) {
                userId = userId.substring(1);
            }
        }
        return new UniTimeUserContext(userId, username, ctx.getStringAttribute("cn"), null);
    }

    public void mapUserToContext(UserDetails user, DirContextAdapter ctx) {
    }
}

