/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.ui;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.RoomConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.util.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomReport
implements Serializable {
    public static int[] sGroupSizes = new int[]{0, 10, 20, 40, 60, 80, 100, 150, 200, 400, Integer.MAX_VALUE};
    private static final long serialVersionUID = 1L;
    private HashSet iGroups = new HashSet();
    private Long iRoomType = null;
    private BitSet iSessionDays = null;
    private int iStartDayDayOfWeek = 0;
    private double iNrWeeks = 0.0;

    public RoomReport(Solver<Lecture, Placement> solver, BitSet sessionDays, int startDayDayOfWeek, Long roomType, Float nrWeeks) {
        TimetableModel model = (TimetableModel)solver.currentSolution().getModel();
        Assignment assignment = solver.currentSolution().getAssignment();
        this.iSessionDays = sessionDays;
        this.iStartDayDayOfWeek = startDayDayOfWeek;
        this.iRoomType = roomType;
        if (nrWeeks == null) {
            int dow = this.iStartDayDayOfWeek;
            int[] nrDays = new int[]{0, 0, 0, 0, 0, 0, 0};
            for (int day = this.iSessionDays.nextSetBit(0); day < this.iSessionDays.length(); ++day) {
                if (this.iSessionDays.get(day)) {
                    int n = dow;
                    nrDays[n] = nrDays[n] + 1;
                }
                dow = (dow + 1) % 7;
            }
            this.iNrWeeks = 0.2 * (double)(nrDays[0] + nrDays[1] + nrDays[2] + nrDays[3] + nrDays[4]);
        } else {
            this.iNrWeeks = nrWeeks.floatValue();
        }
        for (int i = 0; i < sGroupSizes.length - 1; ++i) {
            this.iGroups.add(new RoomAllocationGroup(sGroupSizes[i], sGroupSizes[i + 1]));
        }
        for (RoomConstraint rc : model.getRoomConstraints()) {
            if (!ToolBox.equals((Object)this.iRoomType, (Object)rc.getType())) continue;
            for (RoomAllocationGroup g : this.iGroups) {
                g.add(rc);
            }
        }
        for (Lecture lecture : model.variables()) {
            for (RoomAllocationGroup g : this.iGroups) {
                g.add(lecture, (Placement)assignment.getValue((Variable)lecture));
            }
        }
    }

    public Set getGroups() {
        return this.iGroups;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RoomAllocationGroup
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int iMinRoomSize = 0;
        private int iMaxRoomSize = 0;
        private int iNrRooms = 0;
        private int iNrRoomsThisSizeOrBigger = 0;
        private double iSlotsUse = 0.0;
        private double iSlotsMustUse = 0.0;
        private double iSlotsMustUseThisSizeOrBigger = 0.0;
        private double iSlotsCanUse = 0.0;
        private int iLecturesUse = 0;
        private int iLecturesMustUse = 0;
        private int iLecturesMustUseThisSizeOrBigger = 0;
        private int iLecturesCanUse = 0;
        private int iRealMinRoomSize = 0;
        private int iRealMaxRoomSize = 0;
        private int iLecturesShouldUse = 0;
        private double iSlotsShouldUse = 0.0;

        public RoomAllocationGroup(int minSize, int maxSize) {
            this.iMinRoomSize = minSize;
            this.iMaxRoomSize = maxSize;
            this.iRealMinRoomSize = maxSize;
            this.iRealMaxRoomSize = minSize;
        }

        public int getMinRoomSize() {
            return this.iMinRoomSize;
        }

        public int getMaxRoomSize() {
            return this.iMaxRoomSize;
        }

        public int getActualMinRoomSize() {
            return this.iRealMinRoomSize;
        }

        public int getActualMaxRoomSize() {
            return this.iRealMaxRoomSize;
        }

        public int getNrRooms() {
            return this.iNrRooms;
        }

        public int getNrRoomsThisSizeOrBigger() {
            return this.iNrRoomsThisSizeOrBigger;
        }

        public double getSlotsUse() {
            return this.iSlotsUse;
        }

        public double getSlotsCanUse() {
            return this.iSlotsCanUse;
        }

        public double getSlotsMustUse() {
            return this.iSlotsMustUse;
        }

        public double getSlotsMustUseThisSizeOrBigger() {
            return this.iSlotsMustUseThisSizeOrBigger;
        }

        public double getSlotsShouldUse() {
            return this.iSlotsShouldUse;
        }

        public int getLecturesUse() {
            return this.iLecturesUse;
        }

        public int getLecturesCanUse() {
            return this.iLecturesCanUse;
        }

        public int getLecturesMustUse() {
            return this.iLecturesMustUse;
        }

        public int getLecturesMustUseThisSizeOrBigger() {
            return this.iLecturesMustUseThisSizeOrBigger;
        }

        public int getLecturesShouldUse() {
            return this.iLecturesShouldUse;
        }

        public void add(RoomConstraint rc) {
            if (this.iMinRoomSize <= rc.getCapacity() && rc.getCapacity() < this.iMaxRoomSize) {
                ++this.iNrRooms;
                this.iRealMinRoomSize = Math.min(this.iRealMinRoomSize, rc.getCapacity());
                this.iRealMaxRoomSize = Math.max(this.iRealMaxRoomSize, rc.getCapacity());
            }
            if (this.iMinRoomSize <= rc.getCapacity()) {
                ++this.iNrRoomsThisSizeOrBigger;
            }
        }

        public void add(Lecture lecture, Placement placement) {
            boolean shouldUse;
            if (lecture.getNrRooms() == 0) {
                return;
            }
            boolean skip = false;
            if (lecture.canShareRoom()) {
                for (GroupConstraint gc : lecture.canShareRoomConstraints()) {
                    for (Lecture other : gc.variables()) {
                        if (other.getClassId().compareTo(lecture.getClassId()) >= 0) continue;
                        skip = true;
                    }
                }
            }
            if (skip) {
                return;
            }
            skip = true;
            boolean canUse = false;
            boolean mustUse = true;
            boolean mustUseThisSizeOrBigger = true;
            for (RoomLocation r : lecture.roomLocations()) {
                if (r.getRoomConstraint() == null || PreferenceLevel.sProhibited.equals(PreferenceLevel.int2prolog(r.getPreference()))) continue;
                if (!ToolBox.equals((Object)RoomReport.this.iRoomType, (Object)r.getRoomConstraint().getType())) {
                    mustUse = false;
                    mustUseThisSizeOrBigger = false;
                    continue;
                }
                skip = false;
                if (this.iMinRoomSize <= r.getRoomSize() && r.getRoomSize() < this.iMaxRoomSize) {
                    canUse = true;
                } else {
                    mustUse = false;
                }
                if (r.getRoomSize() >= this.iMinRoomSize) continue;
                mustUseThisSizeOrBigger = false;
            }
            if (skip) {
                return;
            }
            boolean bl = shouldUse = canUse && mustUseThisSizeOrBigger;
            if (canUse) {
                this.iSlotsCanUse += this.getSlotsAWeek(lecture.timeLocations()) * (double)lecture.getNrRooms();
                this.iLecturesCanUse += lecture.getNrRooms();
            }
            if (mustUse) {
                this.iSlotsMustUse += this.getSlotsAWeek(lecture.timeLocations()) * (double)lecture.getNrRooms();
                this.iLecturesMustUse += lecture.getNrRooms();
            }
            if (mustUseThisSizeOrBigger) {
                this.iSlotsMustUseThisSizeOrBigger += this.getSlotsAWeek(lecture.timeLocations()) * (double)lecture.getNrRooms();
                this.iLecturesMustUseThisSizeOrBigger += lecture.getNrRooms();
            }
            if (shouldUse) {
                this.iSlotsShouldUse += this.getSlotsAWeek(lecture.timeLocations()) * (double)lecture.getNrRooms();
                this.iLecturesShouldUse += lecture.getNrRooms();
            }
            int use = 0;
            if (placement != null) {
                if (placement.isMultiRoom()) {
                    for (RoomLocation r : placement.getRoomLocations()) {
                        if (r.getRoomConstraint() == null || !ToolBox.equals((Object)RoomReport.this.iRoomType, (Object)r.getRoomConstraint().getType()) || this.iMinRoomSize > r.getRoomSize() || r.getRoomSize() >= this.iMaxRoomSize) continue;
                        ++use;
                    }
                } else if (placement.getRoomLocation().getRoomConstraint() != null && ToolBox.equals((Object)RoomReport.this.iRoomType, (Object)placement.getRoomLocation().getRoomConstraint().getType()) && this.iMinRoomSize <= placement.getRoomLocation().getRoomSize() && placement.getRoomLocation().getRoomSize() < this.iMaxRoomSize) {
                    ++use;
                }
                if (use > 0) {
                    TimeLocation t = placement.getTimeLocation();
                    this.iSlotsUse += this.getSlotsAWeek(t) * (double)use;
                    this.iLecturesUse += use;
                }
            }
        }

        public double getSlotsAWeek(Collection<TimeLocation> times) {
            if (times.isEmpty()) {
                return 0.0;
            }
            double totalHoursAWeek = 0.0;
            for (TimeLocation t : times) {
                totalHoursAWeek += this.getSlotsAWeek(t);
            }
            return totalHoursAWeek / (double)times.size();
        }

        public double getSlotsAWeek(TimeLocation t) {
            return this.getAverageDays(t) * (double)t.getNrSlotsPerMeeting();
        }

        public double getAverageDays(TimeLocation t) {
            int nrDays = 0;
            int dow = RoomReport.this.iStartDayDayOfWeek;
            for (int day = RoomReport.this.iSessionDays.nextSetBit(0); day < RoomReport.this.iSessionDays.length(); ++day) {
                if (RoomReport.this.iSessionDays.get(day) && t.getWeekCode().get(day) && (t.getDayCode() & Constants.DAY_CODES[dow]) != 0) {
                    ++nrDays;
                }
                dow = (dow + 1) % 7;
            }
            return (double)nrDays / RoomReport.this.iNrWeeks;
        }
    }
}

