/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.studentsct;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.StudentSectioningSaver;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Transaction;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.FreeTime;
import org.unitime.timetable.model.SectioningInfo;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.WaitList;
import org.unitime.timetable.model.base.BaseCourseDemand;
import org.unitime.timetable.model.dao.SessionDAO;

public class StudentSectioningDatabaseSaver
extends StudentSectioningSaver {
    private static Log sLog = LogFactory.getLog(StudentSectioningDatabaseSaver.class);
    private boolean iIncludeCourseDemands = true;
    private String iInitiative = null;
    private String iTerm = null;
    private String iYear = null;
    private Hashtable<Long, org.unitime.timetable.model.Student> iStudents = null;
    private Hashtable<Long, CourseOffering> iCourses = null;
    private Hashtable<Long, Class_> iClasses = null;
    private Hashtable<String, org.unitime.timetable.model.CourseRequest> iRequests = null;
    private Date iTimeStamp = null;
    private StudentSectioningStatus iStatusToSet = null;
    private boolean iResetStatus = false;
    private boolean iUpdateCourseRequests = true;
    private String iOwnerId = null;
    private int iInsert = 0;
    private Progress iProgress = null;
    private boolean iProjections = false;

    public StudentSectioningDatabaseSaver(Solver solver) {
        super(solver);
        this.iIncludeCourseDemands = solver.getProperties().getPropertyBoolean("Load.IncludeCourseDemands", this.iIncludeCourseDemands);
        this.iInitiative = solver.getProperties().getProperty("Data.Initiative");
        this.iYear = solver.getProperties().getProperty("Data.Year");
        this.iTerm = solver.getProperties().getProperty("Data.Term");
        this.iProgress = Progress.getInstance((Object)this.getModel());
        this.iProjections = "Projection".equals(solver.getProperties().getProperty("StudentSctBasic.Mode", "Initial"));
        this.iUpdateCourseRequests = solver.getProperties().getPropertyBoolean("Interactive.UpdateCourseRequests", true);
        this.iOwnerId = solver.getProperties().getProperty("General.OwnerPuid");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() {
        this.iProgress.setStatus("Saving solution ...");
        this.iTimeStamp = new Date();
        org.hibernate.Session hibSession = null;
        Transaction tx = null;
        try {
            try {
                hibSession = SessionDAO.getInstance().getSession();
                hibSession.setCacheMode(CacheMode.IGNORE);
                hibSession.setFlushMode(FlushMode.MANUAL);
                tx = hibSession.beginTransaction();
                Session session = Session.getSessionUsingInitiativeYearTerm(this.iInitiative, this.iYear, this.iTerm);
                if (session == null) {
                    throw new Exception("Session " + this.iInitiative + " " + this.iTerm + this.iYear + " not found!");
                }
                ApplicationProperties.setSessionId(session.getUniqueId());
                this.save(session, hibSession);
                StudentSectioningQueue.sessionStatusChanged(hibSession, null, session.getUniqueId(), true);
                hibSession.flush();
                tx.commit();
                tx = null;
            }
            catch (Exception e) {
                this.iProgress.fatal("Unable to save student schedule, reason: " + e.getMessage(), (Throwable)e);
                sLog.error((Object)e.getMessage(), (Throwable)e);
                if (tx != null) {
                    tx.rollback();
                }
                Object var5_6 = null;
                if (hibSession == null) return;
                if (!hibSession.isOpen()) return;
                hibSession.close();
                return;
            }
            Object var5_5 = null;
            if (hibSession == null) return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (hibSession == null) throw throwable;
            if (!hibSession.isOpen()) throw throwable;
            hibSession.close();
            throw throwable;
        }
        if (!hibSession.isOpen()) return;
        hibSession.close();
    }

    public void flushIfNeeded(org.hibernate.Session hibSession) {
        ++this.iInsert;
        if (this.iInsert % 1000 == 0) {
            hibSession.flush();
            hibSession.clear();
        }
    }

    public void flush(org.hibernate.Session hibSession) {
        hibSession.flush();
        hibSession.clear();
        this.iInsert = 0;
    }

    public void saveStudent(org.hibernate.Session hibSession, Student student) {
        CourseOffering co;
        org.unitime.timetable.model.Student s = this.iStudents.get(student.getId());
        if (s == null) {
            this.iProgress.warn("Student " + student.getId() + " not found.");
            return;
        }
        if (this.iStatusToSet != null) {
            s.setSectioningStatus(this.iStatusToSet);
        } else if (this.iResetStatus) {
            s.setSectioningStatus(null);
        }
        Iterator<Serializable> i = s.getClassEnrollments().iterator();
        while (i.hasNext()) {
            StudentClassEnrollment sce = i.next();
            sce.getClazz().getStudentEnrollments().remove(sce);
            hibSession.delete((Object)sce);
            i.remove();
        }
        i = s.getWaitlists().iterator();
        while (i.hasNext()) {
            WaitList wl = (WaitList)i.next();
            hibSession.delete((Object)wl);
            i.remove();
        }
        if (this.iUpdateCourseRequests && "Modified".equals(student.getStatus())) {
            TreeSet<CourseDemand> remaining = new TreeSet<CourseDemand>(s.getCourseDemands());
            Date ts = new Date();
            for (Request request : student.getRequests()) {
                Object cd = null;
                Iterator i2 = remaining.iterator();
                while (i2.hasNext()) {
                    CourseDemand adept = (CourseDemand)i2.next();
                    if (!adept.getUniqueId().equals(request.getId())) continue;
                    cd = adept;
                    i2.remove();
                    break;
                }
                if (cd != null) {
                    ((BaseCourseDemand)cd).setPriority(request.getPriority());
                    ((BaseCourseDemand)cd).setWaitlist(request instanceof CourseRequest && ((CourseRequest)request).isWaitlist());
                    hibSession.update(cd);
                    continue;
                }
                cd = new CourseDemand();
                ((BaseCourseDemand)cd).setTimestamp(ts);
                ((BaseCourseDemand)cd).setChangedBy(this.iOwnerId);
                s.getCourseDemands().add((CourseDemand)cd);
                ((BaseCourseDemand)cd).setStudent(s);
                ((BaseCourseDemand)cd).setAlternative(request.isAlternative());
                ((BaseCourseDemand)cd).setPriority(request.getPriority());
                if (request instanceof FreeTimeRequest) {
                    FreeTimeRequest ft = (FreeTimeRequest)request;
                    ((BaseCourseDemand)cd).setWaitlist(false);
                    FreeTime free = new FreeTime();
                    ((BaseCourseDemand)cd).setFreeTime(free);
                    free.setCategory(0);
                    free.setDayCode(ft.getTime().getDayCode());
                    free.setStartSlot(ft.getTime().getStartSlot());
                    free.setLength(ft.getTime().getLength());
                    free.setSession(s.getSession());
                    free.setName("Free " + ft.getTime().getDayHeader() + " " + ft.getTime().getStartTimeHeader(true) + " - " + ft.getTime().getEndTimeHeader(true));
                    hibSession.saveOrUpdate((Object)free);
                } else {
                    org.unitime.timetable.model.CourseRequest cr = (CourseRequest)request;
                    ((BaseCourseDemand)cd).setWaitlist(cr.isWaitlist());
                    ((BaseCourseDemand)cd).setCourseRequests(new HashSet<org.unitime.timetable.model.CourseRequest>());
                    ((BaseCourseDemand)cd).setTimestamp(new Date(cr.getTimeStamp()));
                    int order = 0;
                    for (Course course : cr.getCourses()) {
                        co = this.iCourses.get(course.getId());
                        if (co == null) continue;
                        org.unitime.timetable.model.CourseRequest crq = new org.unitime.timetable.model.CourseRequest();
                        ((BaseCourseDemand)cd).getCourseRequests().add(crq);
                        crq.setCourseDemand((CourseDemand)cd);
                        crq.setAllowOverlap(false);
                        crq.setCredit(0);
                        crq.setOrder(order++);
                        crq.setCourseOffering(co);
                    }
                }
                Long demandId = (Long)hibSession.save(cd);
                for (org.unitime.timetable.model.CourseRequest cr : ((BaseCourseDemand)cd).getCourseRequests()) {
                    this.iRequests.put(demandId + ":" + cr.getCourseOffering().getInstructionalOffering().getUniqueId(), cr);
                }
            }
            for (CourseDemand cd : remaining) {
                if (cd.getFreeTime() != null) {
                    hibSession.delete((Object)cd.getFreeTime());
                }
                for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                    this.iRequests.remove(cd.getUniqueId() + ":" + cr.getCourseOffering().getInstructionalOffering().getUniqueId());
                    hibSession.delete((Object)cr);
                }
                s.getCourseDemands().remove(cd);
                hibSession.delete((Object)cd);
            }
        }
        for (Request request : student.getRequests()) {
            Enrollment enrollment = (Enrollment)this.getAssignment().getValue((Variable)request);
            if (!(request instanceof CourseRequest)) continue;
            CourseRequest courseRequest = (CourseRequest)request;
            if (enrollment == null) {
                if (!courseRequest.isWaitlist() || !student.canAssign(this.getAssignment(), (Request)courseRequest)) continue;
                CourseOffering co2 = this.iCourses.get(((Course)courseRequest.getCourses().get(0)).getId());
                if (co2 == null) {
                    this.iProgress.warn("Course offering " + ((Course)courseRequest.getCourses().get(0)).getId() + " not found.");
                    continue;
                }
                WaitList wl = new WaitList();
                wl.setStudent(s);
                wl.setCourseOffering(co2);
                wl.setTimestamp(this.iTimeStamp);
                wl.setType(new Integer(0));
                s.getWaitlists().add(wl);
                hibSession.save((Object)wl);
                continue;
            }
            org.unitime.timetable.model.CourseRequest cr = this.iRequests.get(request.getId() + ":" + enrollment.getOffering().getId());
            for (Section section : enrollment.getAssignments()) {
                Class_ clazz = this.iClasses.get(section.getId());
                if (clazz == null) {
                    this.iProgress.warn("Class " + section.getId() + " not found.");
                    continue;
                }
                StudentClassEnrollment sce = new StudentClassEnrollment();
                sce.setChangedBy(StudentClassEnrollment.SystemChange.BATCH.toString());
                sce.setStudent(s);
                sce.setClazz(clazz);
                if (cr == null) {
                    co = this.iCourses.get(enrollment.getCourse().getId());
                    if (co == null) {
                        co = clazz.getSchedulingSubpart().getControllingCourseOffering();
                    }
                    sce.setCourseOffering(co);
                } else {
                    sce.setCourseRequest(cr);
                    sce.setCourseOffering(cr.getCourseOffering());
                }
                sce.setTimestamp(this.iTimeStamp);
                s.getClassEnrollments().add(sce);
                hibSession.save((Object)sce);
            }
            if (cr == null) continue;
            hibSession.saveOrUpdate((Object)cr);
        }
        hibSession.saveOrUpdate((Object)s);
    }

    public void save(Session session, org.hibernate.Session hibSession) {
        this.iClasses = new Hashtable();
        this.iProgress.setPhase("Loading classes...", 1L);
        for (Class_ clazz : hibSession.createQuery("select distinct c from Class_ c where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            this.iClasses.put(clazz.getUniqueId(), clazz);
        }
        this.iProgress.incProgress();
        if (this.iIncludeCourseDemands && !this.iProjections) {
            this.iCourses = new Hashtable();
            this.iProgress.setPhase("Loading courses...", 1L);
            for (CourseOffering course : hibSession.createQuery("select distinct c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                this.iCourses.put(course.getUniqueId(), course);
            }
            this.iProgress.incProgress();
            this.iStudents = new Hashtable();
            this.iProgress.setPhase("Loading students...", 1L);
            for (org.unitime.timetable.model.Student student : hibSession.createQuery("select distinct s from Student s left join fetch s.courseDemands as cd left join fetch cd.courseRequests as cr left join fetch s.classEnrollments as e left join fetch s.waitlists as w where s.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                this.iStudents.put(student.getUniqueId(), student);
            }
            this.iProgress.incProgress();
            this.iRequests = new Hashtable();
            this.iProgress.setPhase("Loading course demands...", 1L);
            for (CourseDemand demand : hibSession.createQuery("select distinct c from CourseDemand c left join fetch c.courseRequests r left join fetch r.courseOffering as co left join fetch co.instructionalOffering as io where c.student.session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                for (org.unitime.timetable.model.CourseRequest request : demand.getCourseRequests()) {
                    this.iRequests.put(demand.getUniqueId() + ":" + request.getCourseOffering().getInstructionalOffering().getUniqueId(), request);
                }
            }
            this.iProgress.incProgress();
            this.iProgress.setPhase("Saving student enrollments...", (long)((StudentSectioningModel)this.getModel()).getStudents().size());
            String statusToSet = this.getSolver().getProperties().getProperty("Save.StudentSectioningStatusToSet");
            if ("Default".equalsIgnoreCase(statusToSet)) {
                this.iStatusToSet = null;
                this.iResetStatus = true;
                this.iProgress.info("Setting student sectioning status to " + (session.getDefaultSectioningStatus() == null ? "System Default (All Enabled)" : "Session Default (" + session.getDefaultSectioningStatus().getLabel() + ")") + ".");
            } else if (statusToSet != null && !statusToSet.isEmpty() && !statusToSet.equals("N/A")) {
                this.iStatusToSet = StudentSectioningStatus.getStatus(statusToSet, null, hibSession);
                if (this.iStatusToSet == null) {
                    this.iProgress.warn("Student sectioning status " + statusToSet + " does not exist.");
                } else {
                    this.iProgress.info("Setting student sectioning status to " + this.iStatusToSet.getLabel());
                }
            }
            if (this.iStatusToSet == null && !this.iResetStatus) {
                this.iProgress.info("Keeping student sectioning status unchanged.");
            }
            for (Student student : ((StudentSectioningModel)this.getModel()).getStudents()) {
                this.iProgress.incProgress();
                if (student.isDummy()) continue;
                this.saveStudent(hibSession, student);
            }
            this.flush(hibSession);
        }
        if (((StudentSectioningModel)this.getModel()).getNrLastLikeRequests(false) > 0 || this.iProjections) {
            this.iProgress.setPhase("Computing expected/held space for online sectioning...", 0L);
            ((StudentSectioningModel)this.getModel()).computeOnlineSectioningInfos(this.getAssignment());
            this.iProgress.incProgress();
            Hashtable<Long, SectioningInfo> infoTable = new Hashtable<Long, SectioningInfo>();
            List infos = hibSession.createQuery("select i from SectioningInfo i where i.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list();
            for (SectioningInfo info : infos) {
                infoTable.put(info.getClazz().getUniqueId(), info);
            }
            this.iProgress.setPhase("Saving expected/held space for online sectioning...", (long)((StudentSectioningModel)this.getModel()).getOfferings().size());
            for (Offering offering : ((StudentSectioningModel)this.getModel()).getOfferings()) {
                this.iProgress.incProgress();
                for (Config config : offering.getConfigs()) {
                    for (Subpart subpart : config.getSubparts()) {
                        for (Section section : subpart.getSections()) {
                            Class_ clazz = this.iClasses.get(section.getId());
                            if (clazz == null) continue;
                            SectioningInfo info = (SectioningInfo)infoTable.get(section.getId());
                            if (info == null) {
                                info = new SectioningInfo();
                                info.setClazz(clazz);
                            }
                            info.setNbrExpectedStudents(section.getSpaceExpected());
                            info.setNbrHoldingStudents(section.getSpaceHeld());
                            hibSession.saveOrUpdate((Object)info);
                            this.flushIfNeeded(hibSession);
                        }
                    }
                }
            }
        }
        this.flush(hibSession);
        this.iProgress.setPhase("Done", 1L);
        this.iProgress.incProgress();
    }
}

